/*
 * Decompiled with CFR 0.152.
 */
import ca.jamdat.bejeweled.ApplicationStarter;
import ca.jamdat.flight.Application;
import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.J2MEScene;
import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.VibrationManager;
import ca.jamdat.flight.VideoMode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import net.rim.device.api.system.GlobalEventListener;
import net.rim.device.api.system.HolsterListener;
import net.rim.device.api.system.KeyListener;

public class Bejeweled
extends MIDlet
implements Runnable {
    private volatile boolean mResumeInQueue;
    public static final int EVT_KEY_PRESSED;
    public static final int EVT_REPAINT;
    private long[] mEvtQueue;
    private int mLastEventType = -1;
    public static Application mApplication;
    public static FrameworkGlobals mFrameworkGlobals;
    public boolean mDoublePaint = false;
    private int mLastResumeTimeStamp;
    private String mExitURI = "";
    public boolean mBtnDisabled;
    private boolean mForceRepaintBeforeNextEvent = false;
    private static final int MAX_EVENTS;
    private int mStopTimeStamp = -1;
    private static final int MAX_KEY_EVENTS;
    public static Bejeweled instance;
    private boolean mLaunchBrowserOnExit = false;
    public volatile boolean mMustQuit;
    public static J2MEScene mScene;
    public static final int EVT_FLIGHT_KEY_RELEASED;
    private boolean mFirstTime = true;
    public static final int EVT_RESUME;
    public static final int EVT_KEY_RELEASED;
    public Thread mMainLoop;
    public static Object paintLock;
    private volatile boolean mIsPaused;
    private int mTotalTimePaused = Application.GetRealTime();
    public static final int EVT_INVALID;
    private int mEvtCount;
    public boolean mResumeNextIsShown = false;
    public static final int EVT_PAUSE;
    public static final int EVT_FLIGHT_KEY_PRESSED;
    private volatile boolean mPauseInQueue;
    private boolean mIsSoundManagerMuted;

    public Bejeweled() {
        this.mEvtQueue = new long[8];
        instance = this;
        J2MEScene.mApp = this;
    }

    public void destruct() {
    }

    public final String getVersion() {
        String string = StringUtils.CreateJavaString(Application.GetPropertyValue(StringUtils.CreateString("Version-Tag")));
        if (string != null && !string.equals("NULL") && ("" + string.charAt(0)).equals("1")) {
            return StringUtils.CreateJavaString(Application.GetPropertyValue(StringUtils.CreateString("JAMDAT-BUILD")));
        }
        return StringUtils.CreateJavaString(Application.GetPropertyValue(StringUtils.CreateString("MIDlet-Version")));
    }

    public void setLaunchBrowserOnExit(boolean bl) {
        this.mLaunchBrowserOnExit = bl;
    }

    public void setExitURI(String string) {
        this.mExitURI = string;
    }

    public boolean callPlatformRequest(String string) {
        return this.platformRequest(string);
    }

    public boolean launchURI(String string, boolean bl) {
        boolean bl2 = false;
        String string2 = StringUtils.CreateJavaString(Application.GetPropertyValue(StringUtils.CreateString("Browser-Launch-Enabled")));
        if (string2 != null && string2.equals("1")) {
            try {
                if (bl) {
                    this.callPlatformRequest(string);
                } else if (this.callPlatformRequest(string)) {
                    this.exit();
                }
                bl2 = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl2;
    }

    public final void startApp() {
        this.start();
    }

    public final void start() {
        this.startTime();
        if (this.mMainLoop == null && this.mFirstTime) {
            this.mMainLoop = new Thread(this);
            this.InitializeFrameworkApplication();
            this.InitializeNetworkThreads();
            this.mMainLoop.start();
            return;
        }
        if (this.mPauseInQueue || this.mIsPaused) {
            this.AddEvent(6);
        }
    }

    public final void pauseApp() {
        this.pause();
    }

    public void pause() {
        this.stopTime();
        if (!(this.mPauseInQueue || this.mIsPaused || this.mFirstTime || this.mMustQuit)) {
            this.mBtnDisabled = true;
            this.AddEvent(5);
        }
    }

    public final void destroyApp(boolean bl) {
        if (!this.mMustQuit) {
            this.mMustQuit = true;
            mApplication.SaveGame();
        }
    }

    public void exit() {
        this.mMustQuit = true;
        mApplication.SaveGame();
        SoundManager.Get().StopAllSoundPlayers();
        if (this.mLaunchBrowserOnExit) {
            try {
                this.callPlatformRequest(this.mExitURI);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        net.rim.device.api.system.Application.getApplication().removeKeyListener((KeyListener)mScene);
        net.rim.device.api.system.Application.getApplication().removeHolsterListener((HolsterListener)mScene);
        net.rim.device.api.system.Application.getApplication().removeGlobalEventListener((GlobalEventListener)mScene);
        this.notifyDestroyed();
    }

    public final void forceRepaintBeforeNextEvent() {
        this.mForceRepaintBeforeNextEvent = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        mScene = new J2MEScene();
        J2MEScene.repaintScene = false;
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)mScene);
        this.mFirstTime = false;
        while (!this.mMustQuit) {
            int n;
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object = paintLock;
            // MONITORENTER : object
            while (this.mEvtCount > 0 && !this.mForceRepaintBeforeNextEvent) {
                long[] lArray = this.mEvtQueue;
                // MONITORENTER : lArray
                long[] lArray2 = this.mEvtQueue;
                long l = lArray2[0];
                int n2 = (int)(l & 0xFFFFFFFFL);
                n = (int)(l >> 32);
                if (this.mEvtCount > 1) {
                    for (int i = 0; i < 7; ++i) {
                        lArray2[i] = lArray2[i + 1];
                    }
                }
                --this.mEvtCount;
                // MONITOREXIT : lArray
                switch (n) {
                    case 1: {
                        mScene.OnKeyPressed(n2);
                        break;
                    }
                    case 2: {
                        mScene.OnKeyReleased(n2);
                        break;
                    }
                    case 3: {
                        mScene.OnFlightKeyPressed(n2);
                        break;
                    }
                    case 4: {
                        mScene.OnFlightKeyReleased(n2);
                        break;
                    }
                    case 5: {
                        this.mPauseInQueue = false;
                        this.mIsPaused = true;
                        Bejeweled.mFrameworkGlobals.application.FocusLost();
                        this.mBtnDisabled = true;
                        break;
                    }
                    case 6: {
                        this.mLastResumeTimeStamp = Application.GetRealTime();
                        this.mResumeInQueue = false;
                        if (!this.mIsPaused) break;
                        Bejeweled.mFrameworkGlobals.application.Invalidate();
                        Bejeweled.mFrameworkGlobals.application.FocusGained();
                        SoundManager.Get().SetMuted(this.mIsSoundManagerMuted);
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException n3) {
                            // empty catch block
                        }
                        this.mIsPaused = false;
                        this.mDoublePaint = true;
                        break;
                    }
                    case 7: {
                        J2MEScene.repaintScene = true;
                        Application.GetInstance().Invalidate();
                        break;
                    }
                }
            }
            this.mForceRepaintBeforeNextEvent = false;
            // MONITOREXIT : object
            if (this.mResumeNextIsShown && mScene.isShown()) {
                this.mResumeNextIsShown = false;
                this.start();
            }
            if (this.mIsPaused) continue;
            n = Application.GetRealTime();
            object = paintLock;
            // MONITORENTER : object
            mScene.onTime(this.getGameTime());
            // MONITOREXIT : object
            if (this.mMustQuit) {
                return;
            }
            if (n - this.mLastResumeTimeStamp < 2000) {
                J2MEScene.repaintScene = true;
                Application.GetInstance().Invalidate();
            }
            if (J2MEScene.repaintScene && Application.GetInstance().IsDirty()) {
                mScene.paint2();
            }
            Object throwable = paintLock;
            // MONITORENTER : throwable
            FrameworkGlobals.GetInstance().mPackageLoader.LoadQueuedPackages();
            // MONITOREXIT : throwable
        }
    }

    public void InitializeNetworkThreads() {
    }

    public void AddEvent(int n) {
        this.AddEvent(n, 0);
    }

    public void AddEvent(int n, short s, short s2) {
        this.AddEvent(n, s << 16 | s2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void AddEvent(int n, int n2) {
        if ((this.mPauseInQueue || this.mIsPaused) && n != 6) {
            return;
        }
        if (this.mResumeInQueue) {
            return;
        }
        switch (n) {
            case 5: {
                this.mPauseInQueue = true;
                this.mIsSoundManagerMuted = SoundManager.Get().IsMuted();
                SoundManager.Get().SetMuted(true);
                VibrationManager.Get().Stop();
                long[] lArray = this.mEvtQueue;
                synchronized (lArray) {
                    this.mEvtCount = 0;
                    break;
                }
            }
            case 6: {
                if (SoundManager.Get().IsPauseSoundsOnInterrupt()) {
                    // empty if block
                }
                SoundManager.Get().SetMuted(false);
                this.mResumeInQueue = true;
                break;
            }
            case 1: 
            case 2: {
                if (!this.mBtnDisabled) break;
                this.mBtnDisabled = false;
                if (n != 2 || this.mLastEventType == 1) break;
                this.mLastEventType = n;
                return;
            }
        }
        this.AddEventInQueue(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void AddEventInQueue(int n, int n2) {
        int n3 = 1;
        long[] lArray = this.mEvtQueue;
        synchronized (lArray) {
            switch (n) {
                case 1: {
                    if (this.mEvtCount < 5) break;
                    return;
                }
                case 5: 
                case 6: {
                    if (this.mEvtCount < 8) break;
                    return;
                }
                default: {
                    if (this.mEvtCount < 6) break;
                    return;
                }
            }
            if (n3 == 0) return;
            this.mLastEventType = n;
            int n4 = this.mEvtCount;
            this.mEvtCount = n3 = n4 + 1;
            this.mEvtQueue[n4] = (long)n2 & 0xFFFFFFFFL | (long)n << 32;
            return;
        }
    }

    public final void startTime() {
        if (this.mStopTimeStamp != -1) {
            this.mTotalTimePaused += Application.GetRealTime() - this.mStopTimeStamp;
            this.mStopTimeStamp = -1;
        }
    }

    public final void stopTime() {
        this.stopTime(Application.GetRealTime());
    }

    public final void stopTime(int n) {
        if (this.mStopTimeStamp == -1) {
            this.mStopTimeStamp = n;
        }
    }

    public int getGameTime() {
        if (this.mStopTimeStamp == -1) {
            return Application.GetRealTime() - this.mTotalTimePaused;
        }
        return this.mStopTimeStamp - this.mTotalTimePaused;
    }

    public static final String URLEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new DataOutputStream(byteArrayOutputStream).writeUTF(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        byteArrayInputStream.read();
        byteArrayInputStream.read();
        int n = byteArrayInputStream.read();
        while (n >= 0) {
            if (n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 46 || n == 45 || n == 42 || n == 95) {
                stringBuffer.append((char)n);
            } else if (n == 32) {
                stringBuffer.append('+');
            } else if (n < 128) {
                Bejeweled.appendHex(n, stringBuffer);
            } else if (n < 224) {
                Bejeweled.appendHex(n, stringBuffer);
                Bejeweled.appendHex(byteArrayInputStream.read(), stringBuffer);
            } else if (n < 240) {
                Bejeweled.appendHex(n, stringBuffer);
                Bejeweled.appendHex(byteArrayInputStream.read(), stringBuffer);
                Bejeweled.appendHex(byteArrayInputStream.read(), stringBuffer);
            }
            n = byteArrayInputStream.read();
        }
        return stringBuffer.toString();
    }

    private static final void appendHex(int n, StringBuffer stringBuffer) {
        stringBuffer.append('%');
        if (n < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toHexString(n));
    }

    public static final Vector tokenize(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        if (n3 == 0) {
            vector.addElement("");
            return vector;
        }
        while (n < n3) {
            while (n2 < n3 && string2.indexOf(string.charAt(n2)) < 0) {
                ++n2;
            }
            if (n2 < n3) {
                vector.addElement(string.substring(n, n2));
            } else {
                vector.addElement(string.substring(n));
            }
            n = ++n2;
        }
        return vector;
    }

    public static final byte[] loadFile(String object) {
        byte[] byArray = null;
        byte[] byArray2 = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try {
            object = byteArrayOutputStream.getClass().getResourceAsStream("/" + (String)object);
            if (object != null) {
                int n = ((InputStream)object).read(byArray2);
                while (n != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                    n = ((InputStream)object).read(byArray2);
                }
                ((InputStream)object).close();
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static void _FatalError(String string) {
    }

    public static J2MEScene getCurrentScene() {
        return mScene;
    }

    public void InitializeFrameworkApplication() {
        mFrameworkGlobals = new FrameworkGlobals();
        FrameworkGlobals.GetInstance().j2meApp = object;
        Object object = new VideoMode(320, 240, 24);
        DisplayManager.Initialize((VideoMode)object, (VideoMode)object);
        mApplication = ApplicationStarter.NewFlightApp();
    }

    static {
        paintLock = new Object();
    }

    public static Bejeweled[][][] InstArrayJ2MEApp(int n, int n2, int n3) {
        Bejeweled[][][] bejeweledArray = new Bejeweled[n][][];
        for (int i = 0; i < n; ++i) {
            bejeweledArray[i] = new Bejeweled[n2][];
            for (int j = 0; j < n2; ++j) {
                bejeweledArray[i][j] = new Bejeweled[n3];
                for (int k = 0; k < n3; ++k) {
                    bejeweledArray[i][j][k] = new Bejeweled();
                }
            }
        }
        return bejeweledArray;
    }

    public static Bejeweled[][] InstArrayJ2MEApp(int n, int n2) {
        Bejeweled[][] bejeweledArray = new Bejeweled[n][];
        for (int i = 0; i < n; ++i) {
            bejeweledArray[i] = new Bejeweled[n2];
            for (int j = 0; j < n2; ++j) {
                bejeweledArray[i][j] = new Bejeweled();
            }
        }
        return bejeweledArray;
    }

    public static Bejeweled[] InstArrayJ2MEApp(int n) {
        Bejeweled[] bejeweledArray = new Bejeweled[n];
        for (int i = 0; i < n; ++i) {
            bejeweledArray[i] = new Bejeweled();
        }
        return bejeweledArray;
    }
}

