/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import Coral.Graphics2D.crlFont;
import Coral.Graphics2D.crlImagePacked;
import Coral.Util.crlResourceManager;
import Coral.Util.crlString;
import Coral.crlCanvas;
import javax.microedition.lcdui.Image;
import monkey.cBaseRenderer;
import monkey.cCanvas;
import monkey.cFixedPoint;
import monkey.cPhysicsManager;
import monkey.cUI;

public class cMenu
extends cUI {
    static final int MBOOSTER_MAX_INSTANCES = 1;
    private static final int[][] FRAME_MAP = new int[][]{{64}, {65}, {66}, {67}, {82, 160}, {81, 161}, {155}, {156}, {157}, {158, 162}, {113}, {28}, {103}, {2, 23}, {3, 22}, {29}, {31}, {123}, {18}, {6}, {19, 74}, {12}, {122, 83}, {27}, {32}, {33}, {34}, {47}, {36, 37}};
    public static final int[] MENU_LEVEL_MAP = new int[]{0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 5, 11, 12, 13, 14};
    public static final int[] SPECIAL_MENU_LEVEL_MAP = new int[]{11, 12, 13, 14, 26, 27, 28, 29, 41, 42, 43, 44};
    public static final int NAME_ENTRY_OK = 37;
    public static final int NAME_ENTRY_OFFSET = -5;
    public static final int SPECIAL_LEVELS = 12;
    public static final int NORMAL_LEVELS = 15;
    public static final int LOCK_LEVELS = 11;
    public static final int SPECIAL_ICON = 28;
    public static final int ARCADE_ICON = 15;
    public static final int CHALLENGE_ICON = 16;
    public static final int TIME_ATTACK_ICON = 17;
    public static final int RANDOM_ICON = 20;
    public static final int NUM_DEMO_LEVELS = 3;
    public static final int NUM_DEMO_CHARS = 1;
    public static final int[] RAINBOW_COLOURS = new int[]{3182808, 6340752, 16293936, 15757376, 14698616, 11026528};
    public static final int[] CHEAT_CODE = new int[]{1, 1, 2, 2, 4, 8, 4, 8, 256};
    public static final int STATS_DRAW = 5;
    public static final int RANKING_STATS_OPTION = 4;
    public static final int[] STATS_TEXT = new int[]{105, 107, 166, 106, 108, 167, 168, 169};
    public static final int[] STATS_FIELDS = new int[]{0, 2, 5, 1, 3, 8, 6, 7};
    public static final int BONUS_1 = 5;
    public static final int BONUS_2 = 14;
    private static final int NAME_ENTRY_COUNT = 38;
    private static final int BONUS_ICON = 27;
    public static final int WORLD_ICON_START = 24;
    public static final int MODE_ICON_START = 14;
    public static final int WHEEL_CENTER = -11;
    public static final int TEXT_HEIGHT = 160;
    public static final int DECORATOR_XOFFS = 8;
    public static final int DECORATOR_YOFFS = 5;
    public static final int DECORATOR_PADLOCK = -1;
    public static final int DECORATOR_TICK = -2;
    public static final int MENU_ANIMATE_DURATION = 150;
    public static final int MENU_ICON_COUNT = 14;
    private static final int MENU_HEADER_Y = 40;
    public static final int WHEEL_RADIUS = 152;
    public static final int MENU_TITLE_Y = 15;
    private static final int MENU_APPOGEE = 80;
    public static final int HI_SCORE_APPOGEE = 80;
    public static final int LEVEL_SELECT_APPOGEE = 80;
    public static final int HI_SCORE_Y = 120;
    public static final int HI_SCORE_LEFT_MARGIN = 40;
    public static final int HI_SCORE_RIGHT_MARGIN = 40;
    public static final int STATS_LEFT_MARGIN = 10;
    public static final int STATS_RIGHT_MARGIN = 10;
    public static final int MENU_CYCLE_DURATION = 250;
    public static final int TEXT_X_MARGIN = 20;
    public static final int TEXT_Y_TOP = 35;
    public static final int LEVEL_SELECT_Y = 120;
    public static final int TEXT_ARROW_MARGIN = 10;
    public static final int STATS_UP_ARROW = 100;
    public static final int RAINBOW_ARROW_MARGIN = 28;
    public static final int MENU_OPTION_ARROWS = 70;
    public static final int MAX_MENU_PAGES = 64;
    public static final int[][] uiDesign = new int[][]{{-16, 1, 16, 7, -27, 6, -8, 0, 7, -9, 2, 27, -28, 0, 28, -23, 0, 19, -21, 0, 12, -4, 0, 18, -17, 0, 6, -8, 0, 174, -11, 0}, {-28, 1, 46, 7, -27, 5, -16, 0, 4, -9, 2, 29, -25, 0, 31, -37, 0, 123, -20, 0, 74, -22, 0}, {-23, 1, 104, 0, -12, 5, -16, 0, 5, -6, 2, 32, -23, 0, 33, -23, 0, 34, -23, 0, 37, -23, 0, 103, -23, 0}, {-21, 1, 19, 0, -12, 5, -32, 0, 0, -8, 2}, {-4, 1, 12, 114, -12, 5, -32, 0, 0, -8, 2}, {-17, 1, 18, 7, -16, 5, -16, 0, 0, -1, 2}, {-8, 1, 55, 7, -27, 5, -16, 0, 2, -9, 2, 3, -16, 0, 2, -34, 0}, {-26, 1, 61, 7, -26, 122, -30, 0, 0, -7, 2}, {-38, 1, 109, 4, -38, 5, -17, 0, 2, -9, 2, 3, -17, 0, 2, -38, 0}, {-24, 1, 111, 4, -17, 5, -17, 0, 4, -2, 2, 155, -24, 0, 156, -24, 0, 157, -24, 0, 158, -24, 0}, {-35, 1, 112, 4, -17, 5, -17, 0, 4, -2, 2, 155, -35, 0, 156, -35, 0, 157, -35, 0, 158, -35, 0}, {-25, 1, 115, 7, -29, 5, -28, 0, 4, -5, 2, 116, -29, 0, 117, -29, 0, 118, -29, 0, 119, -29, 0}, {-29, 1, 39, 7, -33, 5, -25, 0, 3, -4, 2, 32, -33, 0, 33, -33, 0, 34, -33, 0}, {-33, 1, 40, 7, -10, 5, -29, 0, 0, -3, 2}, {-13, 1, 164, 7, -27, 5, -33, 0, 2, -9, 2, 2, -13, 0, 3, -33, 0}, {-22, 1, 63, 7, -27, 5, -28, 0, 4, -9, 2, 64, -31, 0, 65, -31, 0, 66, -31, 0, 67, -31, 0}, {-31, 1, 115, 7, -27, 5, -22, 0, 4, -5, 2, 116, -15, 0, 117, -15, 0, 118, -15, 0, 119, -15, 0}, {-37, 1, 63, 7, -9, 5, -28, 0, 4, -9, 2, 64, -9, 0, 65, -9, 0, 66, -9, 0, 67, -9, 0}, {-5, 1, 39, 7, -19, 5, -9, 0, 4, -4, 2, 32, -19, 0, 33, -19, 0, 34, -19, 0, 37, -19, 0}, {-6, 1, 75, 76, -19, 6, -16, 0, 2, -9, 2, 76, -19, 0, 77, -5, 0}, {-9, 1, 115, 7, -5, 5, -37, 0, 4, -5, 2, 116, -5, 0, 117, -5, 0, 118, -5, 0, 119, -5, 0}, {-40, 1, 115, 7, -36, 5, -20, 0, 4, -5, 2, 116, -36, 0, 117, -36, 0, 118, -36, 0, 119, -36, 0}, {-20, 1, 63, 7, -40, 5, -28, 0, 4, -9, 2, 64, -40, 0, 65, -40, 0, 66, -40, 0, 67, -40, 0}, {-14, 1, 113, 4, -14, 5, -17, 0, 2, -2, 2, 23, -14, 0, 22, -14, 0}, {-2, 1, 159, 4, -2, 5, -17, 0, 4, -2, 2, 155, -2, 0, 156, -2, 0, 157, -2, 0, 158, -2, 0}, {-7, 1, 160, 4, -7, 5, -17, 0, 2, -2, 2, 82, -7, 0, 161, -7, 0}, {-3, 1, 18, 7, -27, 5, -16, 0, 4, -1, 2, 160, -7, 0, 162, -2, 0, 83, -38, 0, 113, -14, 0}, {-39, 1, 18, 7, -27, 5, -16, 0, 3, -1, 2, 162, -2, 0, 83, -38, 0, 113, -14, 0}, {-18, 1, 18, 7, -27, 5, -16, 0, 4, -1, 2, 82, -24, 0, 81, -35, 0, 83, -38, 0, 113, -14, 0}, {-36, 1, 39, 7, -1, 5, -40, 0, 3, -4, 2, 32, -1, 0, 33, -1, 0, 34, -1, 0}, {-1, 1, 40, 7, -10, 5, -36, 0, 0, -3, 2}, {-11, 1, 14, 7, -27, 5, -16, 0, 2, -9, 2, 3, -16, 0, 2, -11, 0}};
    private crlImagePacked menuIconBase;
    private crlImagePacked iconOverlay;
    private crlImagePacked characters;
    private Image rainbow;
    private Image plank;
    private cCanvas canvas;
    boolean showLsk = true;
    private int worldSelect = -1;
    private int stageSelect = -1;
    private int charSelect = -1;
    private int screenTimer;
    private int animate;
    private int selectTimer;
    public byte[] initals;
    private int entryCount = 0;
    private int cheatIndex = 0;
    private int nextOffset;
    private int currentOffset;
    private int currentChapter;
    private int maxChapter;
    private int minChapter;
    public static int[] multiPlayerCharacters;
    private int multiPlayerCount;
    public int multiCharSelect;
    private int[] optionIdx;
    private int localOptions = 0;
    private int[][] pageOffsets = new int[64][2];
    private int currentPage;
    boolean oldType;
    boolean oldVibrate;
    int oldVolume;
    int verticalScroll;
    public static int nameEntryPlayer;
    public static final int[] MENU_PARRALAX_X;
    public static final int[] MENU_PARRALAX_Y;
    public static final int[] MENU_PARRALAX_TYPE;
    public static int[] helpTextColour;

    public cMenu(cCanvas cCanvas2) {
        this.canvas = cCanvas2;
    }

    private int getScreenDuration() {
        return cCanvas.time - this.screenTimer;
    }

    private int getSelectDuration() {
        int n = Math.abs(cCanvas.time - this.selectTimer);
        if (n > 1500) {
            this.selectTimer = cCanvas.time;
            n = 0;
        }
        return n;
    }

    public void postLoadSetup() {
        cUI.mFont = new crlFont[2];
        cUI.mFont[0] = cBaseRenderer.textFont;
        cUI.mFont[1] = cBaseRenderer.headerFont;
        this.screenTimer = cCanvas.time;
        this.menuIconBase = new crlImagePacked();
        this.menuIconBase.open(crlCanvas.gResourceManager.getImageByID(19460853699453L), 2);
        this.characters = new crlImagePacked();
        this.characters.open(crlCanvas.gResourceManager.getImageByID(102260544835409L), 4);
        this.iconOverlay = crlCanvas.gResourceManager.getIMPByID(69051972810980L);
        this.rainbow = crlCanvas.gResourceManager.getImageByID(59462057342897L);
        this.plank = crlCanvas.gResourceManager.getImageByID(62690905169987L);
        cPhysicsManager.loadLevelSettings();
    }

    private int[] getPageData() {
        return cUI._mUIdsgnLayout[cUI._mUIdsgn];
    }

    private int getSelectedField(int n) {
        int[] nArray = cUI._mUIdsgnLayout[cUI._mUIdsgn];
        int n2 = nArray[11 + 3 * cUI._mUIoption + n];
        return n2;
    }

    private boolean levelAllowed(int n, int n2) {
        boolean bl = n >= 11 && !this.canvas.specialLocked() && n != 14;
        boolean bl2 = n < 11 && n != 5;
        boolean bl3 = (n == 5 && this.canvas.completed(n2) || n == 14 && !this.canvas.specialLocked()) && this.canvas.completed(n2);
        boolean bl4 = bl || bl2 || bl3 || this.canvas.cheat;
        return bl4;
    }

    protected void usrActionUI(int n) {
        int[] nArray = this.getPageData();
        int n2 = nArray[0];
        int n3 = nArray[9];
        if (n3 == -5 && n != -28 && n != -37 && n != -20 && n != -22) {
            this.canvas.playSfx(cUI._mUIoption + 1);
        } else if (n != -23 || n2 != -23) {
            this.canvas.playSfx(5);
        }
        switch (n) {
            case -30: {
                this.initals[this.entryCount] = 0;
                --this.entryCount;
                if (this.entryCount >= 0) break;
                this.entryCount = 0;
                break;
            }
            case -33: 
            case -1: {
                if (n2 == -13) {
                    this.pushMode(n);
                    cUI._mUIoption = this.fromLevelId(this.stageSelect, this.worldSelect);
                    break;
                }
                this.worldSelect = cUI._mUIoption;
                if (this.canvas.zoneLocked(this.worldSelect)) break;
                cBaseRenderer.loadParralax(cUI._mUIwidth, cUI._mUIheight, this.worldSelect, false);
                this.pushMode(n);
                break;
            }
            case -10: {
                try {
                    boolean bl;
                    cPhysicsManager.score = 0;
                    int n4 = this.toLevelId(cUI._mUIoption, false);
                    this.stageSelect = this.canvas.getTypeStart(this.worldSelect) + n4;
                    boolean bl2 = bl = crlCanvas._mDemo && n4 >= 3;
                    if (bl) break;
                    if (this.canvas.completed(this.stageSelect) && !bl && n2 != -1) {
                        this.pushMode(-13);
                        break;
                    }
                    if (!this.levelAllowed(n4, this.stageSelect)) break;
                    cUI._mUIoption = 0;
                    if (n2 == -1) {
                        this.canvas.startLevel(this.stageSelect, multiPlayerCharacters[0], 3);
                        break;
                    }
                    this.canvas.startLevel(this.stageSelect, this.charSelect, 0);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break;
            }
            case -13: {
                cUI._mUIoption = 0;
                this.canvas.startLevel(this.stageSelect, this.charSelect, 1);
                break;
            }
            case -19: {
                this.worldSelect = cUI._mUIoption;
                if (this.canvas.zoneLocked(cUI._mUIoption)) break;
                int n5 = this.canvas.getTypeStart(this.worldSelect);
                if (cUI._mUIoption == 3) {
                    n5 = SPECIAL_MENU_LEVEL_MAP[0];
                }
                cUI._mUIoption = 0;
                this.canvas.startLevel(n5, multiPlayerCharacters[0], 2);
                break;
            }
            case -27: {
                int n6 = this.getSelectedField(1);
                this.usrActionUI(n6);
                break;
            }
            case -34: {
                this.canvas.quitApp();
                break;
            }
            case -26: {
                ++this.entryCount;
                if (this.entryCount < 6 && cUI._mUIoption != 37) break;
                this.entryCount = 5;
                this.pushMode(-23);
                this.canvas.setTypeScore(cPhysicsManager.levelType, cPhysicsManager.score, this.initals);
                cUI._mUIoption = cPhysicsManager.levelType;
                this.canvas.saveRmsData();
                break;
            }
            case -21: {
                this.minChapter = 224;
                this.maxChapter = 238;
                this.currentChapter = this.minChapter;
                this.resetText();
                this.pushMode(n);
                break;
            }
            case -4: {
                this.minChapter = 222;
                this.maxChapter = 223;
                this.currentChapter = this.minChapter;
                this.resetText();
                this.pushMode(n);
                break;
            }
            case -29: {
                if (crlCanvas._mDemo) {
                    if (n2 == -25) {
                        if (cUI._mUIoption <= 0) {
                            this.charSelect = cUI._mUIoption;
                            this.pushMode(n);
                        }
                        return;
                    }
                    this.pushMode(n);
                    break;
                }
                if (n2 == -25) {
                    this.charSelect = cUI._mUIoption;
                }
                this.pushMode(n);
                break;
            }
            case -36: 
            case -15: 
            case -5: {
                if (n2 != -1) {
                    cMenu.multiPlayerCharacters[this.multiCharSelect] = cUI._mUIoption;
                }
                ++this.multiCharSelect;
                if (this.multiCharSelect == this.multiPlayerCount) {
                    if (n == -15) {
                        this.multiCharSelect = 0;
                        this.canvas.startLevel(0, multiPlayerCharacters[0], 4);
                    } else {
                        this.pushMode(n);
                        --this.multiCharSelect;
                        cUI._mUIoption = n2 == n ? multiPlayerCharacters[this.multiCharSelect] : 0;
                        return;
                    }
                }
                this.screenTimer = cCanvas.time;
                cUI._mUIoption = 0;
                break;
            }
            case -37: 
            case -22: 
            case -20: {
                if (crlCanvas._mDemo) break;
                if (n2 == -40 || n2 == -9 || n2 == -31) {
                    --this.multiCharSelect;
                    if (this.multiCharSelect < 0) {
                        this.pushMode(n);
                        this.multiCharSelect = 0;
                        cUI._mUIoption = 0;
                        break;
                    }
                    this.screenTimer = cCanvas.time;
                    cUI._mUIoption = multiPlayerCharacters[this.multiCharSelect];
                    break;
                }
                if (n == -22 && !this.canvas.randomLocked()) {
                    this.pushMode(n);
                    break;
                }
                if (n == -22) break;
                this.pushMode(n);
                break;
            }
            case -40: 
            case -31: 
            case -9: {
                if (n2 == -36 || n2 == -5) {
                    this.pushMode(n);
                    cUI._mUIoption = multiPlayerCharacters[this.multiCharSelect];
                    break;
                }
                this.multiPlayerCount = cUI._mUIoption + 1;
                multiPlayerCharacters = new int[this.multiPlayerCount];
                this.pushMode(n);
                this.worldSelect = 0;
                this.stageSelect = 0;
                break;
            }
            case -2: {
                if (n2 == -2) {
                    this.canvas.setVolume(cUI._mUIoption);
                    this.canvas.pauseAudio();
                    this.canvas.playMusic();
                    this.gotoOptions();
                    return;
                }
                this.pushMode(n);
                this.oldVolume = cCanvas.audioVolume;
                cUI._mUIoption = cCanvas.audioVolume;
                break;
            }
            case -7: {
                if (n2 == -7) {
                    this.canvas.setAudioMode(cUI._mUIoption == 0);
                    if (!cCanvas.isMusic) {
                        this.canvas.pauseAudio();
                    } else {
                        this.canvas.playMusic();
                    }
                    this.gotoOptions();
                    return;
                }
                this.pushMode(n);
                this.oldType = cCanvas.isMusic;
                cUI._mUIoption = cCanvas.isMusic ? 0 : 1;
                break;
            }
            case -17: {
                if (n2 == -7) {
                    cCanvas.isMusic = this.oldType;
                    if (!cCanvas.isMusic) {
                        this.canvas.pauseAudio();
                    } else {
                        this.canvas.playMusic();
                    }
                } else if (n2 != -14 && n2 == -2) {
                    this.canvas.setVolume(this.oldVolume);
                    this.canvas.pauseAudio();
                    this.canvas.playMusic();
                }
                this.gotoOptions();
                break;
            }
            case -38: {
                if (n2 == -38) {
                    this.canvas.resetRmsData(false);
                    this.canvas.saveRmsData();
                    this.gotoOptions();
                    return;
                }
                this.pushMode(n);
                break;
            }
            case -11: {
                if (n2 == -11 && cUI._mUIoption == 1) {
                    this.canvas.gameMidlet.exitToURL(crlCanvas._mUpsellURL);
                    return;
                }
                this.pushMode(n);
                break;
            }
            default: {
                this.pushMode(n);
            }
        }
    }

    private void gotoOptions() {
        this.pushMode(-3);
    }

    private void resetText() {
        this.currentOffset = 0;
        this.nextOffset = 0;
        this.currentPage = 0;
        this.currentChapter = this.minChapter;
    }

    public void pushMode(int n) {
        int[] nArray = this.getPageData();
        int n2 = nArray[0];
        if (n2 != n) {
            this.screenTimer = cCanvas.time;
            cUI._mUIoption = 0;
        }
        super.pushMode(n);
        nArray = this.getPageData();
        if (n == -26 && this.initals != null) {
            cUI._mUIoption = 37;
        }
        int n3 = nArray[8];
        this.optionIdx = new int[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[11 + i * 3];
            this.optionIdx[i] = this.textToFrame(n4);
        }
    }

    protected boolean menuKeyEvent(int n, int[] nArray) {
        this.checkCheatKey(n);
        this.canvas.repaintNeeded = false;
        if (crlCanvas.mPad > 0) {
            this.canvas.repaintNeeded = true;
        }
        this.localOptions = nArray[8];
        int n2 = nArray[9];
        int n3 = nArray[0];
        if (n2 != -8) {
            this.showLsk = true;
        }
        switch (n2) {
            case -3: {
                if (n3 == -33 || n3 == -1) {
                    this.localOptions = MENU_LEVEL_MAP.length;
                    break;
                }
                if (crlCanvas.mPadDB != 1) break;
                if (cCanvas.hasKey(1)) {
                    --this.stageSelect;
                    break;
                }
                if (!cCanvas.hasKey(2)) break;
                ++this.stageSelect;
                break;
            }
            case -5: {
                this.localOptions = 4;
                break;
            }
            case -8: {
                this.processHelpControls();
                return false;
            }
            case -7: {
                this.localOptions = 38;
                break;
            }
            case -6: {
                if (cUI._mUIoption == 4) {
                    if (crlCanvas.mPadDB == 1) {
                        if (cCanvas.hasKey(1) && !cCanvas.hasKey(5) && !cCanvas.hasKey(9)) {
                            --this.verticalScroll;
                        } else if (cCanvas.hasKey(2) && !cCanvas.hasKey(6) && !cCanvas.hasKey(10)) {
                            ++this.verticalScroll;
                        }
                    }
                    if (this.verticalScroll < 0) {
                        this.verticalScroll = 0;
                        break;
                    }
                    if (this.verticalScroll <= STATS_FIELDS.length - 5) break;
                    this.verticalScroll = STATS_FIELDS.length - 5;
                    break;
                }
                this.verticalScroll = 0;
                break;
            }
            case -1: {
                --this.localOptions;
            }
        }
        if (n3 == -16 && !crlCanvas._mUpsell) {
            --this.localOptions;
        }
        if (this.localOptions == 0) {
            return true;
        }
        if ((crlCanvas.mPadDB == 1 || this.getSelectDuration() > 250 && crlCanvas.mPadDB == 0) && this.getSelectDuration() > 150) {
            if (cCanvas.hasKey(256)) {
                return true;
            }
            if (cCanvas.hasKey(512)) {
                return true;
            }
            int n4 = cUI._mUIoption++;
            if (cCanvas.hasKey(8) && !cCanvas.hasKey(10) && !cCanvas.hasKey(9)) {
                if (n3 == -26) {
                    if (cUI._mUIoption > this.localOptions - 1) {
                        cUI._mUIoption = 0;
                    }
                    this.animate = -1;
                    this.selectTimer = cCanvas.time;
                } else if (cUI._mUIoption > this.localOptions - 1) {
                    cUI._mUIoption = this.localOptions - 1;
                } else {
                    this.animate = -1;
                    this.selectTimer = cCanvas.time;
                }
                crlCanvas.mPadDB = 0;
            } else if (cCanvas.hasKey(4) && !cCanvas.hasKey(6) && !cCanvas.hasKey(5)) {
                --cUI._mUIoption;
                if (n3 == -26) {
                    if (cUI._mUIoption < 0) {
                        cUI._mUIoption = this.localOptions - 1;
                    }
                    this.selectTimer = cCanvas.time;
                    this.animate = 1;
                } else if (cUI._mUIoption < 0) {
                    cUI._mUIoption = 0;
                } else {
                    this.animate = 1;
                    this.selectTimer = cCanvas.time;
                }
                crlCanvas.mPadDB = 0;
            } else {
                this.animate = 0;
                this.selectTimer = cCanvas.time;
                return true;
            }
            this.setAudioOptions(n3);
            if (cUI._mUIoption != n4) {
                if (n3 == -7) {
                    if (!cCanvas.isMusic) {
                        this.canvas.pauseAudio();
                    } else {
                        this.canvas.playMusic();
                    }
                }
                this.canvas.playSfx(5);
            }
            return false;
        }
        return true;
    }

    private void setAudioOptions(int n) {
        switch (n) {
            case -7: {
                this.canvas.setAudioMode(cUI._mUIoption == 0);
                break;
            }
            case -2: {
                this.canvas.setVolume(cUI._mUIoption);
                this.canvas.pauseAudio();
                this.canvas.playMusic();
            }
        }
    }

    private void processHelpControls() {
        if (cCanvas.hasKey(512)) {
            this.pushMode(-16);
            crlCanvas.mPadDB = 0;
            return;
        }
        crlString crlString2 = crlResourceManager.mLocaleText[this.currentChapter + 1];
        if (crlCanvas.mPadDB == 1 && this.getSelectDuration() > 150) {
            if (cCanvas.hasKey(8) && !cCanvas.hasKey(10) && !cCanvas.hasKey(9)) {
                this.selectTimer = cCanvas.time;
                if (this.currentChapter < this.maxChapter - 2) {
                    this.pageOffsets[this.currentPage][0] = this.currentOffset;
                    this.pageOffsets[this.currentPage][1] = this.currentChapter;
                    ++this.currentPage;
                }
                if (this.nextOffset != crlString2.length() - 1) {
                    this.currentOffset = this.nextOffset;
                }
                if (crlString2.length() - 1 == this.nextOffset && this.currentChapter + 2 < this.maxChapter) {
                    this.currentChapter += 2;
                    this.currentOffset = 0;
                }
                crlString2 = crlResourceManager.mLocaleText[this.currentChapter + 1];
                this.nextOffset = cUI.mFont[0].printWrapped(null, 20, 35, this.canvas.screenWidth() - 40, 160, crlString2.get(), null, this.currentOffset);
            } else if (cCanvas.hasKey(4) && !cCanvas.hasKey(5) && !cCanvas.hasKey(6)) {
                this.selectTimer = cCanvas.time;
                if (this.currentPage > 0) {
                    --this.currentPage;
                    this.currentOffset = this.pageOffsets[this.currentPage][0];
                    this.currentChapter = this.pageOffsets[this.currentPage][1];
                }
            }
        }
        crlCanvas.mPadDB = 0;
    }

    private void checkCheatKey(int n) {
        if (crlCanvas._mDemo) {
            return;
        }
        if (!this.canvas.cheat && crlCanvas.mPadDB == 1) {
            if ((n & CHEAT_CODE[this.cheatIndex]) > 0) {
                ++this.cheatIndex;
                if (this.cheatIndex > CHEAT_CODE.length - 1) {
                    this.canvas.cheat = true;
                }
            } else {
                this.cheatIndex = 0;
            }
        }
    }

    private int textToFrame(int n) {
        for (int i = 0; i < FRAME_MAP.length; ++i) {
            for (int j = 0; j < FRAME_MAP[i].length; ++j) {
                if (FRAME_MAP[i][j] != n) continue;
                return i;
            }
        }
        return 0;
    }

    protected void drawPanel() {
    }

    public void drawBackground() {
        if (this.g == null) {
            return;
        }
        try {
            int n = cBaseRenderer.bob(0, 250, 1) + 500;
            cBaseRenderer.parralax.tick((int)crlCanvas._mLastFrameTime);
            cBaseRenderer.parralax.draw(this.g, this.canvas.frameCounter, n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void drawSurround() {
        int n;
        int[] nArray = this.getPageData();
        int n2 = nArray[9];
        int n3 = nArray[0];
        int n4 = nArray[2];
        if (n4 != 0) {
            this.g.drawImage(this.plank, cUI._mUIwidth >> 1, 2, 17);
            if (n2 == -8) {
                n4 = this.currentChapter;
                this.showLsk = false;
            } else {
                this.showLsk = true;
            }
            cUI.mFont[1].setAlign(1);
            cUI.mFont[1].print(this.g, cUI._mUIwidth >> 1, 15, n4);
        }
        if ((n = nArray[3]) != 0 && this.showLsk) {
            cUI.mFont[0].setAlign(0);
            cUI.mFont[0].print(this.g, this.getSKPositiveX(n), this.getSKfooterY(), n);
        }
        if ((n = nArray[5]) != 0) {
            cUI.mFont[0].setAlign(0);
            cUI.mFont[0].print(this.g, this.getSKNegativeX(n), this.getSKfooterY(), n);
        }
    }

    protected void drawOptions() {
        int[] nArray = this.getPageData();
        int n = nArray[9];
        int n2 = nArray[0];
        switch (n) {
            case -8: {
                this.drawText();
                break;
            }
            case -3: {
                this.drawLevelSelect();
                break;
            }
            case -6: {
                int n3 = nArray[8];
                crlString crlString2 = crlResourceManager.mLocaleText[this.getCurrentOptionData(0)];
                this.drawOptionWheel(n3, crlString2.get(), cUI._mUIoption, 80, 40);
                this.drawHiscoreTable();
                break;
            }
            case -1: {
                int n4 = nArray[8];
                crlString crlString3 = crlResourceManager.mLocaleText[this.getCurrentOptionData(0)];
                this.drawOptionWheel(--n4, crlString3.get(), cUI._mUIoption);
                break;
            }
            case -7: {
                this.drawNameEntry();
                break;
            }
            case -4: {
                this.drawMenuOptions(nArray);
                int n5 = 120;
                if (this.canvas.zoneLocked(cUI._mUIoption)) {
                    cUI.mFont[0].print(this.g, cUI._mUIwidth >> 1, n5, 172);
                    break;
                }
                if (n2 != -29) break;
                n5 = cUI.mFont[0].print(this.g, cUI._mUIwidth >> 1, n5, 102);
                cUI.mFont[0].printNumber(this.g, cUI._mUIwidth >> 1, n5, this.canvas.sumScore(cUI._mUIoption), 7);
                break;
            }
            case -5: {
                crlString crlString4 = crlResourceManager.mLocaleText[this.getCurrentOptionData(0)];
                this.drawOptionWheel(4, crlString4.get(), cUI._mUIoption);
                if (n2 != -9 && n2 != -40 && n2 != -31) break;
                crlFont crlFont2 = cUI.mFont[0];
                int n6 = 120;
                n6 = crlFont2.print(this.g, this.canvas.screenWidth() >> 1, n6, 124 + this.multiCharSelect);
                crlFont2.print(this.g, this.canvas.screenWidth() >> 1, n6, 128);
                break;
            }
            default: {
                this.drawMenuOptions(nArray);
                if (n2 != -28) break;
                int n7 = 120;
                int[] nArray2 = new int[]{170, 171, 171, this.canvas.randomLocked() ? 172 : 171};
                cUI.mFont[0].print(this.g, cUI._mUIwidth >> 1, n7, nArray2[cUI._mUIoption]);
            }
        }
        if (this.canvas.cheat) {
            cUI.mFont[0].setAlign(1);
            cUI.mFont[0].print(this.g, this.canvas.screenWidth() >> 1, this.canvas.screenHeight() - 20, 129);
        }
    }

    private void drawText() {
        crlString crlString2 = crlResourceManager.mLocaleText[this.currentChapter + 1];
        try {
            this.nextOffset = cUI.mFont[0].printWrapped(this.g, 20, 35, this.canvas.screenWidth() - 40, 160, crlString2.get(), null, this.currentOffset);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.currentChapter > this.minChapter || this.currentChapter == this.minChapter && this.currentOffset != 0) {
            cBaseRenderer.drawArrow(this.g, 10, this.canvas.getFullHeight() / 2, 0, 9);
        }
        int n = crlString2.length();
        if (this.currentChapter + 2 < this.maxChapter || this.currentChapter + 2 == this.minChapter && this.nextOffset <= n - 1 || this.currentChapter + 2 == this.maxChapter && this.nextOffset < n - 1) {
            cBaseRenderer.drawArrow(this.g, this.canvas.screenWidth() - 10, this.canvas.getFullHeight() / 2, 0, 8);
        }
    }

    private int toLevelId(int n, boolean bl) {
        if (bl) {
            return SPECIAL_MENU_LEVEL_MAP[n];
        }
        return MENU_LEVEL_MAP[n];
    }

    private int fromLevelId(int n, int n2) {
        int n3 = this.canvas.getTypeStart(n2);
        int n4 = n - n3;
        for (int i = 0; i < MENU_LEVEL_MAP.length; ++i) {
            if (MENU_LEVEL_MAP[i] != n4) continue;
            return i;
        }
        return -1;
    }

    private void drawLevelSelect() {
        int[] nArray = this.getPageData();
        int n = nArray[0];
        crlFont crlFont2 = cUI.mFont[0];
        if (n == -33 || n == -1) {
            int n2;
            int n3 = n2 = this.toLevelId(cUI._mUIoption, false);
            if (n == -33 || n == -1) {
                n3 += this.canvas.getTypeStart(this.worldSelect);
            }
            int n4 = 177 + n3;
            crlString crlString2 = crlResourceManager.mLocaleText[n4];
            this.drawOptionWheel(this.localOptions, crlString2.get(), cUI._mUIoption, 80, 40);
            crlFont2.setAlign(1);
            int n5 = 120;
            if (cUI._mUIoption > 10 && this.canvas.specialLocked() || (n3 == 5 || n3 == 14) && !this.canvas.completed(n3) && !this.canvas.cheat || crlCanvas._mDemo && n3 >= 3) {
                n5 = crlFont2.print(this.g, cUI._mUIwidth >> 1, n5, 172);
                if (n3 != 5 && !crlCanvas._mDemo) {
                    n5 = crlFont2.print(this.g, cUI._mUIwidth >> 1, n5, 36);
                }
            } else if (n == -33) {
                n5 = crlFont2.print(this.g, cUI._mUIwidth >> 1, n5, 176);
                crlFont2.printNumber(this.g, cUI._mUIwidth >> 1, n5, this.canvas.levelScores[n3], 6);
            } else {
                n5 = this.canvas.timeAttack[n3] == 0 ? crlFont2.print(this.g, cUI._mUIwidth >> 1, n5, new byte[]{45, 45, 58, 45, 45, 46, 45, 45, 0}) : cBaseRenderer.printShortTime(crlFont2, this.g, cUI._mUIwidth >> 1, n5, this.canvas.timeAttack[n3]);
            }
        }
    }

    private void drawNameEntry() {
        if (this.initals == null) {
            this.initals = new byte[7];
            this.entryCount = 0;
        }
        this.initals[this.entryCount] = cUI._mUIoption != 37 ? this.optionToLetter(cUI._mUIoption) : (byte)0;
        this.drawOptionWheel(38, this.initals, cUI._mUIoption);
        int n = 120;
        n = cUI.mFont[0].print(this.g, cUI._mUIwidthCent, n, 124 + nameEntryPlayer);
        n = cUI.mFont[0].print(this.g, cUI._mUIwidthCent, n, 61);
    }

    private byte optionToLetter(int n) {
        byte by = 0;
        by = n < 26 ? (byte)(n + 65) : (n < 36 ? (byte)(n + 48 - 26) : (byte)32);
        return by;
    }

    private void drawHiscoreTable() {
        crlFont crlFont2 = cUI.mFont[0];
        crlFont2.setAlign(0);
        if (cUI._mUIoption != 4) {
            int n = cUI._mUIoption;
            int n2 = 120;
            for (int i = 0; i < this.canvas.scoreTable[n].length; ++i) {
                crlFont2.setAlign(0);
                crlFont2.print(this.g, 40, n2, this.canvas.initalTable[n][i]);
                crlFont2.setAlign(2);
                n2 = crlFont2.printNumber(this.g, this.canvas.screenWidth() - 40, n2, this.canvas.scoreTable[n][i], 6);
            }
        } else {
            int n = 120;
            for (int i = this.verticalScroll; i < this.verticalScroll + 5; ++i) {
                crlFont2.setAlign(0);
                crlFont2.print(this.g, 10, n, STATS_TEXT[i]);
                crlFont2.setAlign(2);
                n = i < 3 ? cBaseRenderer.printTime(crlFont2, this.g, this.canvas.screenWidth() - 10, n, this.canvas.statsTable[STATS_FIELDS[i]]) : crlFont2.printNumber(this.g, this.canvas.screenWidth() - 10, n, this.canvas.statsTable[STATS_FIELDS[i]], 5);
            }
            if (this.verticalScroll != 0) {
                cBaseRenderer.drawArrow(this.g, cUI._mUIwidth >> 1, 100, 0, 10);
            }
            if (this.verticalScroll + 5 != STATS_FIELDS.length) {
                cBaseRenderer.drawArrow(this.g, cUI._mUIwidth >> 1, n + 1, 0, 11);
            }
        }
    }

    private void drawButton(int n, int n2, boolean bl, int n3) {
        int[] nArray = this.getPageData();
        int n4 = nArray[9];
        int n5 = nArray[0];
        this.menuIconBase.draw(this.g, n, n2, bl ? 1 : 0);
        if (n3 == -1 || n5 == -16 && !crlCanvas._mUpsell && n3 == 6) {
            return;
        }
        if (n4 == -5) {
            int n6 = -3;
            int n7 = 5;
            if (bl) {
                n6 = cBaseRenderer.bob(0, n7, 20);
            }
            this.characters.draw(this.g, n, n2 + (n6 -= 3), n3);
            if (crlCanvas._mDemo && n3 >= 1) {
                this.drawButtonDecorator(n, n2, false, -1);
            }
        } else if (n5 == -33 || n5 == -1) {
            int n8 = this.toLevelId(n3, false);
            if (n8 == 5 || n8 == 14) {
                this.iconOverlay.draw(this.g, n, n2, 27);
            } else if (n8 >= 11) {
                this.iconOverlay.draw(this.g, n, n2, 28);
            } else {
                this.iconOverlay.draw(this.g, n, n2, 24 + this.worldSelect);
                this.drawButtonDecorator(n, n2, true, n3 + 1);
            }
            int n9 = this.canvas.getTypeStart(this.worldSelect);
            int n10 = n9 + this.toLevelId(n3, false);
            if (this.canvas.completed(n10) && (!crlCanvas._mDemo || n3 < 3)) {
                if (n5 == -33) {
                    this.drawButtonDecorator(n, n2, false, -2);
                }
            } else if (this.canvas.specialLocked() && n3 > 10 && n8 != 14 || (n8 == 5 || n8 == 14) && !this.canvas.completed(n10) && !this.canvas.cheat || crlCanvas._mDemo && n3 >= 3) {
                this.drawButtonDecorator(n, n2, false, -1);
            }
        } else {
            int n11 = 0;
            if (this.optionIdx.length > 0 && n3 < this.optionIdx.length) {
                boolean bl2;
                n11 = this.optionIdx[n3];
                this.iconOverlay.draw(this.g, n, n2, n11);
                boolean bl3 = bl2 = crlCanvas._mDemo && (n11 == 17 || n11 == 16);
                if (n11 >= 24 && n11 <= 26) {
                    this.drawButtonDecorator(n, n2, true, n11 - 24 + 1);
                    if (this.canvas.zoneLocked(n11 - 24)) {
                        this.drawButtonDecorator(n, n2, false, -1);
                    }
                } else if (n5 != -16) {
                    if (n11 == 20 && this.canvas.randomLocked() || bl2) {
                        this.drawButtonDecorator(n, n2, false, -1);
                    }
                    if (n11 == 28 && this.canvas.specialLocked() || bl2) {
                        this.drawButtonDecorator(n, n2, false, -1);
                    }
                }
            } else {
                cUI.mFont[0].setAlign(1);
                if (n3 != 37) {
                    cUI.mFont[0].print(this.g, n, n2 + -5, new byte[]{this.optionToLetter(n3), 0});
                } else {
                    cUI.mFont[0].print(this.g, n, n2 + -5, 4);
                }
            }
        }
    }

    private void drawButtonDecorator(int n, int n2, boolean bl, int n3) {
        int n4;
        int n5 = n4 = bl ? -8 : 8;
        if (n3 >= 0) {
            cUI.mFont[0].printNumber(this.g, n + n4, n2 - 5, n3, 0);
        } else if (n3 == -1) {
            cBaseRenderer.drawArrow(this.g, n + n4, n2 - 5 + 10, 0, 12);
        } else if (n3 == -2) {
            cBaseRenderer.drawArrow(this.g, n + n4, n2 - 5, 0, 13);
        }
    }

    private void drawMenuOptions(int[] nArray) {
        if (nArray[8] > 0) {
            int n = nArray[8];
            int n2 = nArray[0];
            if (!crlCanvas._mUpsell && n2 == -16) {
                --n;
            }
            crlString crlString2 = crlResourceManager.mLocaleText[this.getCurrentOptionData(0)];
            this.drawOptionWheel(n, crlString2.get(), cUI._mUIoption);
        }
    }

    private void drawOptionWheel(int n, byte[] byArray, int n2) {
        this.drawOptionWheel(n, byArray, n2, 80, 40);
    }

    private void drawOptionWheel(int n, byte[] byArray, int n2, int n3, int n4) {
        int n5;
        if (n <= 0) {
            return;
        }
        this.drawRainbow(n3);
        int[] nArray = this.getPageData();
        int n6 = nArray[0];
        int n7 = 1838;
        int n8 = (n2 + 1) * n7;
        int n9 = 0;
        if (this.getSelectDuration() < 150 && this.animate != 0) {
            n5 = 150 - this.getSelectDuration() << 12;
            n9 = cFixedPoint.mul(n7, n5 /= 150) * -this.animate;
            n9 = (n9 >> 4096) - n8;
        } else {
            n9 = -n8;
        }
        n5 = this.canvas.screenHeight() - -11;
        int n10 = Math.min(this.getScreenDuration() / 2, 152);
        int n11 = n9 - 6434;
        int n12 = n2 - 2;
        n11 += n7 * n12;
        for (int i = n12; i < n12 + 5; ++i) {
            int n13 = (cFixedPoint.cos(n11 += n7) * n10 >> 12) + (this.canvas.screenWidth() >> 1);
            int n14 = (cFixedPoint.sin(n11) * n10 >> 12) + n5;
            int n15 = i % n;
            if (n6 != -26) {
                n15 = i % n;
                if (i >= n || i < 0) {
                    n15 = -1;
                }
            } else if (i == -1) {
                n15 = 37;
            } else if (i > this.localOptions) {
                n15 = 0;
            } else if (i == -2) {
                n15 = 36;
            }
            this.drawButton(n13, n14, i % n == n2, n15);
        }
        if (this.animate == 0) {
            if (n2 < n - 1 || n6 == -26) {
                cBaseRenderer.drawArrow(this.g, (this.canvas.screenWidth() >> 1) + 28, 70, 0, 8);
            }
            if (n2 > 0 || n6 == -26) {
                cBaseRenderer.drawArrow(this.g, (this.canvas.screenWidth() >> 1) - 28, 70, 0, 9);
            }
        }
        cUI.mFont[0].setAlign(1);
        cUI.mFont[0].print(this.g, this.canvas.screenWidth() >> 1, n4, byArray);
    }

    private void drawRainbow(int n) {
        this.g.drawImage(this.rainbow, 0, n - 30, 20);
    }

    void usrDrawOptions(int[] nArray) {
    }

    void usrDrawPanel(int n) {
    }

    static {
        MENU_PARRALAX_X = new int[]{20, 110};
        MENU_PARRALAX_Y = new int[]{115, 115};
        MENU_PARRALAX_TYPE = new int[]{0, 1};
        helpTextColour = new int[]{9751292, 0, 0xFFFFFF};
    }

    public static interface cMenuTypes {
        public static final int UI_OPTIONS = -1;
        public static final int UI_VOLUME = -2;
        public static final int UI_LEVEL_SELECT = -3;
        public static final int UI_UNLOCKABLE = -4;
        public static final int UI_CHARACTER_SELECT = -5;
        public static final int UI_HIGH_SCORES = -6;
        public static final int UI_ENTER_NAME = -7;
        public static final int UI_TEXT = -8;
        public static final int UI_NONE = -9;
    }

    public static interface uiPanel {
        public static final int NULL = 0;
    }

    public static interface cMenuImages {
        public static final int NULL = 0;
    }

    public static interface cMenuModes {
        public static final int UI_TIME_ATTACK_STAGE_SELECT = -1;
        public static final int UI_OPTIONS_VOLUME = -2;
        public static final int UI_OPTIONS_SOUND_OR_MUSIC = -3;
        public static final int UI_ABOUT = -4;
        public static final int UI_CHALLENGE_SELECT_LEVEL = -5;
        public static final int UI_CHALLENGE_ROUND_OVER = -6;
        public static final int UI_OPTIONS_AUDIOTYPE = -7;
        public static final int UI_EXIT = -8;
        public static final int UI_CHALLENGE_CHARACTER_SELECT = -9;
        public static final int UI_START = -10;
        public static final int UI_GET_MORE_GAMES = -11;
        public static final int UI_NULL = -12;
        public static final int UI_ARCADE_PRACTICE_CONFIRM = -13;
        public static final int UI_OPTIONS_VIBRATE = -14;
        public static final int UI_RANDOM_SELECT_LEVEL = -15;
        public static final int UI_MAIN_MENU = -16;
        public static final int UI_OPTIONS = -17;
        public static final int UI_OPTIONS_SOUND_AND_MUSIC = -18;
        public static final int UI_CHALLENGE_START_GAME = -19;
        public static final int UI_TIME_ATTACK_SELECT_PLAYER_COUNT = -20;
        public static final int UI_INSTRUCTIONS = -21;
        public static final int UI_RANDOM_SELECT_PLAYER_COUNT = -22;
        public static final int UI_HIGH_SCORES = -23;
        public static final int UI_OPTIONS_MUSIC_VOLUME = -24;
        public static final int UI_ARCADE_CHARACTER_SELECT = -25;
        public static final int UI_ENTER_NAME = -26;
        public static final int UI_SELECT = -27;
        public static final int UI_PLAY = -28;
        public static final int UI_ARCADE_CHOOSE_ZONE = -29;
        public static final int UI_ENTER_NAME_DELETE = -30;
        public static final int UI_RANDOM_CHARACTER_SELECT = -31;
        public static final int UI_TEXT_BACK = -32;
        public static final int UI_ARCADE_STAGE_SELECT = -33;
        public static final int UI_EXIT_CONFIRMED = -34;
        public static final int UI_OPTIONS_EFFECTS_VOLUME = -35;
        public static final int UI_TIME_ATTACK_CHOOSE_ZONE = -36;
        public static final int UI_CHALLENGE_SELECT_PLAYER_COUNT = -37;
        public static final int UI_OPTIONS_RESET = -38;
        public static final int UI_OPTIONS_MUSIC = -39;
        public static final int UI_TIME_ATTACK_CHARACTER_SELECT = -40;
    }
}

