/*
 * Decompiled with CFR 0.152.
 */
package Coral.Math.Float;

import Coral.Math.Float.crlV4;

public class crlMath {
    public static final float TOL = 1.0E-6f;
    public static final double SQRT3 = 1.7320508075688772;
    public static final double LOG10 = 2.302585092994046;
    public static final double LOGdiv2 = -0.6931471805599453;
    public static final double PIdiv2 = 1.5707963267948966;
    public static final double PIdiv6 = 0.5235987755982988;
    public static final double PIdiv12 = 0.2617993877991494;
    public static final double PI2 = Math.PI * 2;
    public static final double PIinv = 0.3183098861837907;
    public static final double PI2inv = 0.15915494309189535;
    public static final double DEGTORAD = 0.017453292942564074;
    public static final double RADTODEG = 57.29577951308232;
    public static final float MPSTOMPH = 2.24f;
    public static final float MPSTOKMH = 3.6f;
    public static final float MPHTOMPS = 0.447f;
    public static final float PIf = (float)Math.PI;
    public static final float PI2f = (float)Math.PI * 2;
    public static final float PIdiv2f = 1.5707963f;
    public static final float PIdiv12f = 0.2617994f;
    public static final float PIdiv6f = 0.5235988f;
    public static final float PI2invf = 0.15915494f;
    public static final float SQRT3f = 1.7320508f;
    public static final float DEGTORADf = 0.017453294f;
    public static final float RADTODEGf = 57.295776f;

    public static double acos(double d) {
        double d2 = crlMath.asin(d);
        if (d2 == Double.NaN) {
            return d2;
        }
        return 1.5707963267948966 - d2;
    }

    public static double asin(double d) {
        if (d < -1.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d == -1.0) {
            return -1.5707963267948966;
        }
        if (d == 1.0) {
            return 1.5707963267948966;
        }
        return crlMath.atan(d / Math.sqrt(1.0 - d * d));
    }

    public static double atan(double d) {
        double d2;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (d < 0.0) {
            d = -d;
            bl = true;
        }
        if (d > 1.0) {
            d = 1.0 / d;
            bl2 = true;
        }
        while (d > 0.2617993877991494) {
            ++n;
            d2 = d + 1.7320508075688772;
            d2 = 1.0 / d2;
            d *= 1.7320508075688772;
            d -= 1.0;
            d *= d2;
        }
        double d3 = d * d;
        d2 = d3 + 1.4087812;
        d2 = 0.55913709 / d2;
        d2 += 0.60310579;
        d2 -= d3 * 0.05160454;
        d2 *= d;
        while (n > 0) {
            d2 += 0.5235987755982988;
            --n;
        }
        if (bl2) {
            d2 = 1.5707963267948966 - d2;
        }
        if (bl) {
            d2 = -d2;
        }
        return d2;
    }

    public static float acosf(float f) {
        float f2 = crlMath.asinf(f);
        if (f2 == Float.NaN) {
            return f2;
        }
        return 1.5707963f - f2;
    }

    public static float asinf(float f) {
        if (f < -1.0f || f > 1.0f) {
            return Float.NaN;
        }
        if (f == -1.0f) {
            return -1.5707963f;
        }
        if (f == 1.0f) {
            return 1.5707963f;
        }
        return crlMath.atanf(f / (float)Math.sqrt(1.0f - f * f));
    }

    public static float atanf(float f) {
        float f2;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (f < 0.0f) {
            f = -f;
            bl = true;
        }
        if (f > 1.0f) {
            f = 1.0f / f;
            bl2 = true;
        }
        while (f > 0.2617994f) {
            ++n;
            f2 = f + 1.7320508f;
            f2 = 1.0f / f2;
            f *= 1.7320508f;
            f -= 1.0f;
            f *= f2;
        }
        float f3 = f * f;
        f2 = f3 + 1.4087812f;
        f2 = 0.5591371f / f2;
        f2 += 0.6031058f;
        f2 -= f3 * 0.05160454f;
        f2 *= f;
        while (n > 0) {
            f2 += 0.5235988f;
            --n;
        }
        if (bl2) {
            f2 = 1.5707963f - f2;
        }
        if (bl) {
            f2 = -f2;
        }
        return f2;
    }

    public static double atan2(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return 0.0;
        }
        if (d2 > 0.0) {
            return crlMath.atan(d / d2);
        }
        if (d2 < 0.0) {
            if (d < 0.0) {
                return -(Math.PI - crlMath.atan(d / d2));
            }
            return Math.PI - crlMath.atan(-d / d2);
        }
        if (d < 0.0) {
            return -1.5707963267948966;
        }
        return 1.5707963267948966;
    }

    public static float fast_atan2(float f, float f2) {
        float f3;
        float f4;
        if (f2 == 0.0f) {
            if (f > 0.0f) {
                return 1.5707963f;
            }
            if (f == 0.0f) {
                return 0.0f;
            }
            return -1.5707963f;
        }
        float f5 = f / f2;
        float f6 = f4 = f5 < 0.0f ? -f5 : f5;
        if (f4 < 1.0f) {
            f3 = f5 / (1.0f + 0.28f * f5 * f5);
            if (f2 < 0.0f) {
                if (f < 0.0f) {
                    return f3 - (float)Math.PI;
                }
                return f3 + (float)Math.PI;
            }
        } else {
            f3 = 1.5707963f - f5 / (f5 * f5 + 0.28f);
            if (f < 0.0f) {
                return f3 - (float)Math.PI;
            }
        }
        return f3;
    }

    public static float invSqrt(float f) {
        float f2 = 0.5f * f;
        int n = Float.floatToIntBits(f);
        n = 1597463174 - (n >> 1);
        f = Float.intBitsToFloat(n);
        f *= 1.5f - f2 * f * f;
        return f;
    }

    public static double exp(double d) {
        boolean bl;
        if (d == 0.0) {
            return 1.0;
        }
        double d2 = 1.0;
        long l = 1L;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        double d3 = d / (double)l;
        for (long i = 2L; i < 50L; ++i) {
            d2 += d3;
            d3 = d3 * d / (double)i;
        }
        if (bl) {
            return 1.0 / d2;
        }
        return d2;
    }

    private static double _log(double d) {
        double d2;
        if (!(d > 0.0)) {
            return Double.NaN;
        }
        double d3 = 0.0;
        int n = 0;
        while (d > 0.0 && d <= 1.0) {
            d *= 2.0;
            ++n;
        }
        --n;
        double d4 = (d /= 2.0) - 1.0;
        double d5 = d + 1.0;
        double d6 = d2 = d4 / d5;
        d5 = d6 * d2;
        for (long i = 1L; i < 50L; i += 2L) {
            d3 += d6 / (double)i;
            d6 *= d5;
        }
        d3 *= 2.0;
        for (int i = 0; i < n; ++i) {
            d3 += -0.6931471805599453;
        }
        return d3;
    }

    public static double log(double d) {
        if (!(d > 0.0)) {
            return Double.NaN;
        }
        if (d == 1.0) {
            return 0.0;
        }
        if (d > 1.0) {
            d = 1.0 / d;
            return -crlMath._log(d);
        }
        return crlMath._log(d);
    }

    public static double log10(double d) {
        return crlMath.log(d) / 2.302585092994046;
    }

    public static final float round2dp(float f) {
        return (float)((int)((f + 0.005f) * 100.0f)) / 100.0f;
    }

    public static final double round2dp(double d) {
        return (float)((int)((d + 0.005) * 100.0)) / 100.0f;
    }

    public static final float clamp(float f, float f2, float f3) {
        return Math.min(Math.max(f, f2), f3);
    }

    public static final double clamp(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), d3);
    }

    public static final float lerp(float f, float f2, float f3) {
        return f2 + (f3 - f2) * f;
    }

    public static final double lerp(double d, double d2, double d3) {
        return d2 + (d3 - d2) * d;
    }

    public static final float sgn(float f) {
        if (f < 0.0f) {
            return -1.0f;
        }
        return 1.0f;
    }

    public static final void calcNorms(crlV4 crlV42, crlV4 crlV43, crlV4 crlV44, crlV4 crlV45, crlV4 crlV46, crlV4 crlV47) {
        float f = crlV43.x - crlV42.x;
        float f2 = crlV43.y - crlV42.y;
        float f3 = crlV43.z - crlV42.z;
        float f4 = crlV44.x - crlV42.x;
        float f5 = crlV44.y - crlV42.y;
        float f6 = crlV44.z - crlV42.z;
        crlV46.x = f2 * f6 - f3 * f5;
        crlV46.y = f3 * f4 - f * f6;
        crlV46.z = f * f5 - f2 * f4;
        float f7 = 1.0f / (float)Math.sqrt(crlV46.x * crlV46.x + crlV46.y * crlV46.y + crlV46.z * crlV46.z);
        crlV46.x *= f7;
        crlV46.y *= f7;
        crlV46.z *= f7;
        crlV47.x = crlV44.x - crlV42.x;
        crlV47.y = crlV44.y - crlV42.y;
        crlV47.z = crlV44.z - crlV42.z;
        f7 = 1.0f / (float)Math.sqrt(crlV47.x * crlV47.x + crlV47.y * crlV47.y + crlV47.z * crlV47.z);
        crlV47.x *= f7;
        crlV47.y *= f7;
        crlV47.z *= f7;
        crlV45.x = crlV46.y * crlV47.z - crlV46.z * crlV47.y;
        crlV45.y = crlV46.z * crlV47.x - crlV46.x * crlV47.z;
        crlV45.z = crlV46.x * crlV47.y - crlV46.y * crlV47.x;
    }
}

