/*
 * Decompiled with CFR 0.152.
 */
package Coral.Graphics2D;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class crlImagePacked {
    public static final int METRICS = 1;
    public static final int FRAME_OFFSET = 6;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 270;
    public static final int TRANS_ROT180 = 180;
    public static final int TRANS_ROT270 = 90;
    public static final int TRANS_MIRROR = 8192;
    public static final int TRANS_MIRROR_ROT90 = 8282;
    public static final int TRANS_MIRROR_ROT180 = 16384;
    public static final int TRANS_MIRROR_ROT270 = 8462;
    public static final int FRAME_X = 0;
    public static final int FRAME_Y = 1;
    public static final int FRAME_WIDTH = 2;
    public static final int FRAME_HEIGHT = 3;
    public static final int FRAME_ANCHOR_X = 4;
    public static final int FRAME_ANCHOR_Y = 5;
    private Image _mImage;
    private Image flipImage;
    private short[] _mMetrics;
    private int _frames;

    public void open(Image image, short[] sArray) {
        this._mImage = image;
        short s = sArray[0];
        if ((s & 0x3FF) == s) {
            this._mMetrics = sArray;
            this._frames = sArray[0];
        } else {
            this._frames = s & 0x3FF;
            this._mMetrics = new short[1 + 6 * this._frames];
            if (s >> 12 == 2) {
                boolean bl = (s >> 11 & 1) == 1;
                int n = 1;
                for (int i = 0; i < this._frames; ++i) {
                    if (sArray[n] == -1) {
                        ++n;
                        continue;
                    }
                    int n2 = 1 + 6 * i;
                    if (bl && sArray[n] != -2) {
                        this._mMetrics[n2] = (short)(sArray[n] >> 8 & 0xFF);
                        this._mMetrics[n2 + 1] = (short)(sArray[n] & 0xFF);
                        this._mMetrics[n2 + 2] = (short)(sArray[n + 1] >> 8 & 0xFF);
                        this._mMetrics[n2 + 3] = (short)(sArray[n + 1] & 0xFF);
                        this._mMetrics[n2 + 4] = (short)((sArray[n + 2] >> 8 & 0xFF) - 128);
                        this._mMetrics[n2 + 5] = (short)((sArray[n + 2] & 0xFF) - 128);
                        n += 3;
                        continue;
                    }
                    this._mMetrics[n2] = sArray[n];
                    this._mMetrics[n2 + 1] = sArray[n + 1];
                    this._mMetrics[n2 + 2] = sArray[n + 2];
                    this._mMetrics[n2 + 3] = sArray[n + 3];
                    this._mMetrics[n2 + 4] = sArray[n + 4];
                    this._mMetrics[n2 + 5] = sArray[n + 5];
                    n += 6;
                }
            }
        }
    }

    public void createFlip() {
        if (this.flipImage == null) {
            this.flipImage = Image.createImage((Image)this._mImage, (int)0, (int)0, (int)this._mImage.getWidth(), (int)this._mImage.getHeight(), (int)2);
        }
    }

    public void open(Image image, int n, int n2, int n3, int n4) {
        this._mImage = image;
        int n5 = image.getWidth() / n;
        int n6 = image.getHeight() / n2;
        this._frames = n5 * n6;
        this._mMetrics = new short[1 + 6 * this._frames];
        this._mMetrics[0] = (short)this._frames;
        for (int i = 0; i < this._frames; ++i) {
            int n7 = 1 + 6 * i;
            int n8 = i % n5 * n;
            int n9 = i / n5 * n2;
            this._mMetrics[n7++] = (short)n8;
            this._mMetrics[n7++] = (short)n9;
            this._mMetrics[n7++] = (short)n;
            this._mMetrics[n7++] = (short)n2;
            this._mMetrics[n7++] = (short)n3;
            this._mMetrics[n7] = (short)n4;
        }
    }

    public void open(Image image, int n) {
        this.open(image, n, 1);
    }

    public void open(Image image, int n, int n2) {
        int n3 = n / n2;
        int n4 = image.getWidth() / n3;
        int n5 = image.getHeight() / n2;
        int n6 = n4 >> 1;
        int n7 = n5 >> 1;
        this.open(image, n4, n5, n6, n7);
    }

    public void close() {
        this._mImage = null;
        this._mMetrics = null;
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        this.draw(graphics, n, n2, n3, 0);
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this._mImage == null) {
            return;
        }
        if (n3 >= this._frames) {
            n3 %= this._frames;
        } else if (n3 < 0) {
            n3 = 0;
        }
        int n5 = 1 + 6 * n3;
        int n6 = this._mMetrics[n5++];
        if (n6 == -2) {
            short s;
            for (int i = n5; i < n5 + 6 - 1 && (s = this._mMetrics[i]) != -1; ++i) {
                this.draw(graphics, n, n2, s);
            }
        } else {
            int n7 = this._mMetrics[n5++];
            short s = this._mMetrics[n5++];
            short s2 = this._mMetrics[n5++];
            short s3 = this._mMetrics[n5++];
            short s4 = this._mMetrics[n5];
            n -= s3;
            n2 -= s4;
            int n8 = n6;
            int n9 = n7;
            short s5 = s;
            short s6 = s2;
            int n10 = this._mImage.getWidth();
            int n11 = this._mImage.getHeight();
            switch (n4) {
                case 270: {
                    n8 = n11 - n7 - s2;
                    n9 = n6;
                    s5 = s2;
                    s6 = s;
                    break;
                }
                case 180: {
                    n8 = n10 - n6 - s;
                    n9 = n11 - n7 - s2;
                    break;
                }
                case 90: {
                    n8 = n7;
                    n9 = n10 - n6 - s;
                    s5 = s2;
                    s6 = s;
                    break;
                }
                case 8192: {
                    n8 = n10 - n6 - s;
                    n9 = n7;
                    break;
                }
                case 8282: {
                    n8 = n11 - n7 - s2;
                    n9 = n10 - n6 - s;
                    s5 = s2;
                    s6 = s;
                    break;
                }
                case 16384: {
                    n8 = n6;
                    n9 = n11 - n7 - s2;
                    break;
                }
                case 8462: {
                    n8 = n7;
                    n9 = n6;
                    s5 = s2;
                    s6 = s;
                }
            }
            int n12 = graphics.getClipX();
            int n13 = graphics.getClipY();
            int n14 = graphics.getClipWidth();
            int n15 = graphics.getClipHeight();
            graphics.clipRect(n, n2, (int)s5, (int)s6);
            if (n4 == 0) {
                graphics.drawImage(this._mImage, n - n8, n2 - n9, 20);
            } else {
                this.createFlip();
                graphics.drawImage(this.flipImage, n - n8, n2 - n9, 20);
            }
            graphics.setClip(n12, n13, n14, n15);
        }
    }

    public int getMetrics(int n) {
        return this._mMetrics[n];
    }

    public int getFrameCount() {
        return this._frames;
    }

    public Image getImage() {
        return this._mImage;
    }

    public int getFrameMetric(int n, int n2) {
        int n3 = 1 + 6 * n;
        int n4 = this._mMetrics[n3 + n2];
        if (this._mMetrics[n3] == -2) {
            switch (n2) {
                case 3: {
                    int n5 = -this.getFrameMetric(this._mMetrics[n3 + 1], 5);
                    int n6 = this.getFrameMetric(this._mMetrics[n3 + 1], 3) + n5;
                    for (int i = 2; i < 6 && this._mMetrics[n3 + i] != -1; ++i) {
                        int n7 = -this.getFrameMetric(this._mMetrics[n3 + i], 5);
                        int n8 = this.getFrameMetric(this._mMetrics[n3 + i], 3) + n7;
                        if (n5 == -1 || n7 < n5) {
                            n5 = n7;
                        }
                        if (n6 >= n8) continue;
                        n6 = n8;
                    }
                    n4 = n6 - n5;
                    break;
                }
                default: {
                    n4 = this.getFrameMetric(this._mMetrics[n3 + 1], n2);
                }
            }
        }
        return n4;
    }

    public int getWidth(int n) {
        return this.getFrameMetric(n, 2);
    }

    public int getHeight(int n) {
        return this.getFrameMetric(n, 3);
    }
}

