/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import Coral.Graphics2D.crlImagePacked;
import Coral.Util.crlUtil;
import javax.microedition.lcdui.Graphics;
import monkey.cBaseRenderer;
import monkey.cCanvas;

public final class cParralax {
    private static final int PLANET_Y_OFFS = 110;
    private static final int PLANET_Y_MIN = 27;
    private static final int MOUNTAIN_Y_MIN = 27;
    private static final int TREE_Y_MIN = -25;
    public static final int MOUNTAIN_ANCHOR_Y = 27;
    public static final int MOUNTAIN_ANCHOR_X = 0;
    public static final int MOUNTAIN_HEIGHT = 54;
    public static final int MOUNTAIN_WIDTH = 227;
    public static final int PLANET_ANCHOR_Y = 98;
    public static final int PLANET_ANCHOR_X = 0;
    public static final int PLANET_HEIGHT = 98;
    public static final int PLANET_WIDTH = 221;
    public static final int TREE_WIDTH = 142;
    public static final int TREE_HEIGHT = 119;
    public static final int RANGE_WIDTH = 180;
    public static final int RANGE_HEIGHT = 52;
    public static final int BEACH_WIDTH = 135;
    public static final int BEACH_HEIGHT = 84;
    public static final int RANGE_Y = 60;
    public static final int RANGE_Y_DRAW = 80;
    static final int MBOOSTER_MAX_INSTANCES = 1;
    public static final int WRAP_Y = 400;
    public static final int WRAP_X = 300;
    public static final int FLOATER_Z_MAX = 10;
    public static final int SPACE_PLANET = 0;
    public static final int SPACE_SATTELITE = 1;
    public static final int SPACE_NEBULA = 2;
    public static final int SPACE_GALAXY = 3;
    public static final int SPACE_UFO = 4;
    public static final int SKY_CLOUD_LARGE = 0;
    public static final int SKY_CLOUD_MEDIUM = 1;
    public static final int SKY_CLOUD_SMALL = 2;
    public static final int SKY_CLOUD_TINY = 3;
    public static final int SKY_EAGLE = 4;
    public static final int SKY_BIRD = 5;
    public static final int SKY_BALLOON_GREEN = 6;
    public static final int SKY_BALLOON_BLUE = 7;
    public static final int SKY_BALLOON_ORANGE = 8;
    public static final int SEA_ICEBIRG = 0;
    public static final int SEA_ISLAND_ROUND = 1;
    public static final int SEA_ISLAND_SPIKE = 2;
    public static final int SEA_SHARK = 3;
    public static final int SEA_BOUY = 4;
    public static final int SEA_WHALE = 5;
    public static final int SEA_BUBBLE = 6;
    public static final int BACKGROUND_SPACE = 0;
    public static final int BACKGROUND_SKY = 1;
    public static final int BACKGROUND_GROUND = 2;
    public static final int BACKGROUND_BONUS = 3;
    public static final int FLOATER_COUNT = 20;
    public static final int GRADIENT_DETAIL = 16;
    public static final int RANGE_SCALE = 1;
    public static final int BAND_HEIGHT = 10;
    public static final int[][] BACKGROUND_FADE_LENGTHS = new int[][]{{700, 400, 5000, 5000}, {40, 800, 5000, 5000}, {60, 8, 250, 5000, 5000}, {500, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750}};
    public static final int[][] BACKGROUND_FADE_COLOURS = new int[][]{{0, 4749567, 7332084, 0xFFFFFF}, {21226, 21226, 7332084, 0x8EEFEF, 0xFFFFFF}, {16768395, 16748372, 3952028, 2714549}, {8192, 65280, 255, 0xFF00FF, 0xFFFF00, 65535, 0xFF0000, 65280, 255, 0xFF0000, 65280, 255}};
    public static final int[][][] FLOATER_FRAMES = new int[][][]{new int[][]{{0}, {1}, {2}, {3}, {4}}, new int[][]{{0}, {1}, {2}, {3}, {5, 6, 7, 8}, {10, 11, 12, 13}, {4}, {9}, {14}}, new int[][]{{0}, {1}, {2}, {3, 4, 5}, {6, 7, 8}, {-1, -1, -1, 16, 16, 15, 15, 9, 10, 11, 12, 11, 12, 13, 13, 14, 15, 16, 16, 16, 16, -1, -1}, {17, 18, 19, 20, 21, 22}}};
    public static final int[][][] FLOATER_ZRANGE = new int[][][]{new int[][]{{7, 7}, {4, 6}, {10, 10}, {10, 10}, {4, 6}}, new int[][]{{2, 10}, {2, 10}, {2, 10}, {2, 10}, {2, 4}, {2, 3}, {6, 7}, {6, 7}, {6, 7}}, new int[][]{{10, 10}, {8, 8}, {8, 8}, {2, 2}, {3, 3}, {9, 9}, {2, 2}}};
    public static final int[][] FLOATER_DISTRIBUTION = new int[][]{{5, 2, 5, 5, 2}, {20, 20, 20, 20, 6, 6, 8, 8, 8}, {5, 8, 8, 2, 3, 6, 0}};
    public static final int[][] FLOATER_TIMES = new int[][]{{1, 1, 1, 1, 1}, {1, 1, 1, 1, 250, 150, 1, 1, 1}, {1, 1, 1, 250, 150, 300, 100}};
    private int[] parralaxX;
    private int[] parralaxY;
    private int[] parralaxZ;
    private int[] parralaxType;
    private int[] frame;
    private int[] transform;
    private int width;
    private int height;
    private int type;
    private crlImagePacked parralax;
    private crlImagePacked floaters;
    int timeStamp;
    int time;
    public static final int[] REDUCED_PARRALAX_FRAMES = new int[]{1, 2, 1};
    public static final int REDUCED_FLOATERS = 4;

    public cParralax(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.type = n3;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setImages(crlImagePacked crlImagePacked2, crlImagePacked crlImagePacked3) {
        this.parralax = crlImagePacked2;
        this.floaters = crlImagePacked3;
    }

    private boolean isFree(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < n6; ++i) {
            if (this.parralaxZ[n6] != n3 || this.parralaxX[n6] < n || this.parralaxX[n6] + n4 > n || this.parralaxY[n6] < n2 || this.parralaxY[n6] + n5 > n2) continue;
            return false;
        }
        return true;
    }

    private int[] getFreeCoord(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = crlUtil.randInt(-n2 * n, n2 * n);
        int n8 = crlUtil.randInt(-n3 * n, n3 * n);
        return new int[]{n7, n8};
    }

    private void createFloater(int n) {
        int n2;
        this.parralaxType[n] = n2 = crlUtil.randDist(FLOATER_DISTRIBUTION[this.type]);
        this.frame[n] = FLOATER_FRAMES[this.type][n2][0];
        this.transform[n] = 0;
        int n3 = this.width * 4 / 3;
        int n4 = this.height * 4 / 3;
        this.parralaxZ[n] = crlUtil.randInt(FLOATER_ZRANGE[this.type][n2][0], FLOATER_ZRANGE[this.type][n2][1]);
        int n5 = this.frame[n] != -1 ? this.floaters.getWidth(this.frame[n]) : 32;
        int n6 = this.frame[n] != -1 ? this.floaters.getHeight(this.frame[n]) : 32;
        int[] nArray = this.getFreeCoord(this.parralaxZ[n], n3, n4, n5, n6, n);
        this.parralaxX[n] = nArray[0];
        this.parralaxY[n] = nArray[1];
        block0 : switch (this.type) {
            case 2: {
                switch (n2) {
                    case 0: {
                        this.parralaxY[n] = 20;
                        break block0;
                    }
                    case 1: {
                        this.parralaxY[n] = 260;
                        this.parralaxX[n] = n * this.parralaxZ[n] * 110;
                        break block0;
                    }
                    case 2: {
                        this.parralaxY[n] = 40;
                        this.parralaxX[n] = n * this.parralaxZ[n] * 110;
                        break block0;
                    }
                    case 3: {
                        this.parralaxY[n] = 180;
                        break block0;
                    }
                    case 4: {
                        this.parralaxY[n] = 280;
                        break block0;
                    }
                    case 5: {
                        this.parralaxY[n] = 280;
                        break block0;
                    }
                    case 6: {
                        this.parralaxY[n] = 160;
                    }
                }
            }
        }
    }

    public void createParralax() {
        if (this.type != 3) {
            int n;
            this.parralaxX = new int[20];
            this.parralaxY = new int[20];
            this.parralaxZ = new int[20];
            this.parralaxType = new int[20];
            this.frame = new int[20];
            this.transform = new int[20];
            for (n = 0; n < 20; ++n) {
                this.createFloater(n);
            }
            for (n = 0; n < 20; ++n) {
                this.parralaxX[n] = this.parralaxX[n] << 12;
                this.parralaxY[n] = this.parralaxY[n] << 12;
            }
        }
        this.timeStamp = cCanvas.time;
    }

    private int getTime() {
        return cCanvas.time - this.timeStamp;
    }

    public void tick(int n) {
        int n2 = n;
        this.time += n;
        this.timeStamp = cCanvas.time;
        if (this.type == 3) {
            return;
        }
        block17: for (int i = 0; i < 20; ++i) {
            int n3 = this.parralaxType[i];
            this.frame[i] = FLOATER_FRAMES[this.type][n3][(this.time / FLOATER_TIMES[this.type][n3] + i) % FLOATER_FRAMES[this.type][n3].length];
            switch (this.type) {
                case 1: {
                    int n4;
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            this.parralaxX[i] = this.parralaxX[i] - 500 * n2;
                            this.transform[i] = 0;
                            if (i % 2 != 0) break;
                            this.transform[i] = 0;
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            this.parralaxY[i] = this.parralaxY[i] - 125 * n2;
                            break;
                        }
                        case 4: 
                        case 5: {
                            n4 = 625 * n2;
                            this.transform[i] = 8192;
                            if (i % 3 == 0) {
                                this.transform[i] = 0;
                                n4 = -n4;
                            }
                            this.parralaxX[i] = this.parralaxX[i] + n4;
                        }
                    }
                    continue block17;
                }
                case 0: {
                    int n4;
                    switch (n3) {
                        case 1: {
                            n4 = 50 * (i % 10) * n2;
                            if (i % 2 == 0) {
                                n4 = -n4;
                            }
                            this.parralaxX[i] = this.parralaxX[i] - n4;
                            this.parralaxY[i] = this.parralaxY[i] - n4;
                            break;
                        }
                        case 4: {
                            n4 = 500 * n2;
                            if (i % 2 == 0) {
                                n4 = -n4;
                            }
                            this.parralaxX[i] = this.parralaxX[i] - n4;
                            this.parralaxY[i] = this.parralaxY[i] + cBaseRenderer.bob(0, 20480, 1);
                        }
                    }
                    continue block17;
                }
                case 2: {
                    switch (n3) {
                        case 3: 
                        case 5: {
                            this.parralaxX[i] = this.parralaxX[i] - 310 * n2;
                        }
                    }
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (graphics == null) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        this.drawFill(graphics, n, n2);
        this.drawBackground(graphics, n, n2);
        if (this.type == 0) {
            this.drawForeground(graphics, n, n2);
            this.drawFloaters(graphics, n, n2);
        } else if (this.type == 2) {
            this.drawFloaters(graphics, n, n2);
            this.drawForeground(graphics, n, n2);
        } else if (this.type == 1) {
            this.drawForeground(graphics, n, n2);
            this.drawFloaters(graphics, n, n2);
        }
    }

    private void drawFloaters(Graphics graphics, int n, int n2) {
        if (this.floaters == null || this.parralax == null) {
            return;
        }
        int n3 = this.width * 4 / 3;
        int n4 = this.height * 4 / 3;
        if (this.type == 1) {
            // empty if block
        }
        if (this.type == 2) {
            n2 = 0;
        }
        for (int i = 10; i > 0; --i) {
            for (int j = 0; j < 20; ++j) {
                if (this.parralaxZ[j] != i || this.frame[j] == -1) continue;
                int n5 = ((this.parralaxX[j] >> 12) - n) / this.parralaxZ[j];
                int n6 = ((this.parralaxY[j] >> 12) - n2) / this.parralaxZ[j];
                if (this.type != 2) {
                    n6 = this.wrap(n6, n4) + (this.height >> 1);
                    n5 = this.wrap(n5, n3) + (this.width >> 1);
                } else {
                    n6 = this.wrap(n6, 200) + (this.height >> 1) + 200;
                    n5 = (this.wrap(n5, n3 * 6) + (this.width >> 1)) * 1;
                }
                if (this.type == 0) {
                    if (this.frame[j] != 1 && this.frame[j] != 4) continue;
                    this.floaters.draw(graphics, n5, n6, this.frame[j], this.transform[j]);
                    continue;
                }
                this.floaters.draw(graphics, n5, n6, this.frame[j], this.transform[j]);
            }
        }
    }

    private void drawForeground(Graphics graphics, int n, int n2) {
        if (this.floaters == null || this.parralax == null) {
            return;
        }
        switch (this.type) {
            case 0: {
                int n3 = Math.max(this.height + 27, this.height - n2 / 6 + 110);
                int n4 = 0;
                int n5 = Math.max(50, this.height - n2 / 5 + 50);
                int n6 = Math.max(-30, -(n / 5) + 150);
                this.parralax.draw(graphics, n4, n3, 0);
                this.parralax.draw(graphics, n6, n5, 1);
                break;
            }
            case 2: {
                int n7 = -(n >> 1) - 142;
                int n8 = Math.max(this.height + -25, this.height - n2 / 8 + 50);
                this.drawStrip(graphics, 0, 142, n7, n8);
            }
        }
    }

    private void drawBackground(Graphics graphics, int n, int n2) {
        if (this.floaters == null || this.parralax == null) {
            return;
        }
        switch (this.type) {
            case 0: {
                int n3 = this.width * 4 / 3;
                int n4 = this.height * 4 / 3;
                for (int i = 10; i > 0; --i) {
                    for (int j = 0; j < 20; ++j) {
                        if (this.parralaxZ[j] != i) continue;
                        int n5 = ((this.parralaxX[j] >> 12) - n) / this.parralaxZ[j];
                        int n6 = ((this.parralaxY[j] >> 12) - n2) / this.parralaxZ[j];
                        n5 = this.wrap(n5, n3) + (this.width >> 1);
                        n6 = this.wrap(n6, n4) + (this.height >> 1);
                        if (this.frame[j] == 1 || this.frame[j] == 4) continue;
                        this.floaters.draw(graphics, n5, n6, this.frame[j], this.transform[j]);
                    }
                }
                break;
            }
            case 1: {
                int n7 = -(n >> 3) - 20;
                int n8 = -(n >> 2);
                int n9 = -(n >> 1);
                int n10 = Math.max(this.height + 27, this.height - n2 / 5 + 54);
                int n11 = Math.max(this.height + 27, this.height - n2 / 15 + 54);
                int n12 = Math.max(this.height + 27, this.height - n2 / 20 + 54);
                this.drawStrip(graphics, 1, 227, n7, n10);
                this.drawStrip(graphics, 0, 227, n8, n11);
                this.drawStrip(graphics, 2, 227, n9, n12);
                break;
            }
            case 2: {
                this.drawStrip(graphics, 1, 180, -(n >> 4) - 180, 80);
                int n13 = Math.max(this.height - 10, this.height - n2 / 20 + 25);
                this.drawStrip(graphics, 2, 135, -(n >> 2) - 135, n13);
            }
        }
    }

    private void drawStrip(Graphics graphics, int n, int n2, int n3, int n4) {
        while (n3 < n2 + n2) {
            if (n3 > -n2) {
                this.parralax.draw(graphics, n3, n4, n);
            }
            n3 += n2;
        }
    }

    private void drawFill(Graphics graphics, int n, int n2) {
        int n3 = -n2;
        if (graphics == null) {
            return;
        }
        if (this.type == 3) {
            n3 *= 4;
        } else if (this.type == 0 || this.type == 2) {
            n3 = 0;
        }
        cBaseRenderer.fillMultiGradient(graphics, BACKGROUND_FADE_LENGTHS[this.type], BACKGROUND_FADE_COLOURS[this.type], 16, 0, this.width, 0, this.height, n3);
        if (this.type == 3) {
            this.drawBlocks(graphics, n >> 2, n2 >> 2, 60);
        }
    }

    private void drawBlocks(Graphics graphics, int n, int n2, int n3) {
        for (int i = 0; i < this.width / n3 + 2; ++i) {
            for (int j = -1; j < this.height / n3 + 2; ++j) {
                int n4 = i * n3 * 2 + n3 * (j % 2);
                int n5 = n3 * j - n2 % n3 * 2;
                graphics.fillRect(n4 -= n % n3 * 2, n5, n3, n3);
            }
        }
    }

    private int wrap(int n, int n2) {
        n = n > 0 ? n % (n2 * 2) - n2 : n % (n2 * 2) + n2;
        return n;
    }
}

