/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import Coral.Audio.crlAudioManager;
import Coral.crlCanvas;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import monkey.cBaseManager;
import monkey.cBaseRenderer;
import monkey.cCanvas;
import monkey.cFixedPoint;
import monkey.cGameRenderer;
import monkey.cMenu;
import monkey.cPhysicsManager;
import monkey.cSponge;
import monkey.cUI;

public final class cEntityManager
extends cPhysicsManager {
    static final int MBOOSTER_MAX_INSTANCES = 1;
    public static final int LEVEL_TYPE_SPACE = 0;
    public static final int LEVEL_TYPE_SKY = 1;
    public static final int LEVEL_TYPE_GROUND = 2;
    public static final int LEVEL_TYPE_BONUS = 3;
    public static final int GAME_TYPE_ARCADE = 0;
    public static final int GAME_TYPE_PRACTICE = 1;
    public static final int GAME_TYPE_CHALLENGE = 2;
    public static final int GAME_TYPE_TIME_ATTACK = 3;
    public static final int GAME_TYPE_RANDOM = 4;
    public static final int GOAL_TIME = 2000;
    public static final int FAIL_TIME = 7000;
    public static final int LEADIN_TIME = 3000;
    public static final int LEADOUT_TIME = 1000;
    public static final int SUMMARY_TIME = 8000;
    public static final int HURRY_UP_TIME = 10000;
    private static final int INPLAY_INTRO_TIME = 1000;
    public static final int RESTART_TIME = 0;
    public static final int PLAYER_FALLOUT_TIME = 30000;
    public static final int PLATFORM_COLLAPSE_TIME = 1000;
    public static final int PATH_NODE_VELOCITY = 0;
    public static final int PAUSE_PAGE_MAIN = 0;
    public static final int PAUSE_PAGE_EXIT_CONFIRM = 1;
    public static final int PAUSE_RESUME = 0;
    public static final int PAUSE_STAGE_SELECT = 1;
    public static final int PAUSE_AUDIOMODE = 2;
    public static final int PAUSE_VOLUME = 3;
    public static final int PAUSE_EXIT = 4;
    public static final int PAUSE_OPTIONS = 5;
    public static final int START_LIVES = 3;
    public static final int MULTIPLAY_CHARACTER = 0;
    public static final int MULTIPLAY_SCORE = 1;
    public static final int MULTIPLAY_LIVES = 2;
    public static final int MULTIPLAY_LEVEL = 3;
    public static final int MULTIPLAY_BANNANS = 4;
    public static final int MULTIPLAY_TIME = 5;
    public static final int GHOST_RATE = 250;
    public static final int GHOST_LIMIT = 400;
    public static final int COMPLETE_HISCORE = 10;
    public static final int COMPLETE_SPECIAL_HISCORE = 14;
    public static final int TELEPORT_DURATION = 500;
    boolean flyTrigger;
    public int pausePage;
    public int menuSelect;
    public int menuCount;
    public boolean loadedLevel;
    public int continueCount;
    private cBaseManager.Vector2d cam;
    int scaleAve;
    boolean panBack;
    boolean lastWas;
    public int gameType;
    public int flyTime;
    public static int continueLevel;
    public int totalTime;
    private int baseScore;
    public int freeFall;
    public int totalDistance;
    public int bestSessionTime = Integer.MAX_VALUE;
    public int ghostIdx;
    public short[] ghostX;
    public short[] ghostY;
    public short[] ghostRecordX;
    public short[] ghostRecordY;
    public int ghostPlayer = -1;
    public static int[][] multiplayTracking;
    public int[] levelList;
    private int oldState;
    private int oldTime;
    public boolean pauseNeeded;
    public int jumpTime;
    public int[] menuText;
    boolean newRandomUnlocked;
    int oldMove;
    int levelsComplete;
    int postBonusLevel = -1;
    public int currentPlayer;
    public int statsMode;
    public int gameExitMode;
    int oldTune = -1;
    int[] swingLengths;
    public static final int[][] LEVEL_ENDINGS;
    private static DataInputStream resourceStream;

    public cEntityManager(cCanvas cCanvas2) {
        cPhysicsManager.canvas = cCanvas2;
    }

    public void create() {
        this.timeStamp = cCanvas.time;
        this.initVars();
        this.setState(0);
        this.lifeCount = 3;
    }

    private void initVars() {
        cBaseManager.player = new cBaseManager.Vector2d();
        this.playerDelta = new cBaseManager.Vector2d();
        this.playerRealDelta = new cBaseManager.Vector2d();
        this.collision = new cBaseManager.Vector2d();
        this.playerOld = new cBaseManager.Vector2d();
        this.slide = new cBaseManager.Vector2d();
        this.bounce = new cBaseManager.Vector2d();
        this.gravity = new cBaseManager.Vector2d();
        this.kick = new cBaseManager.Vector2d();
        this.fanForce = new cBaseManager.Vector2d();
        this.timeup = false;
        this.fallout = false;
        this.hitGoal = false;
        this.pda = 0;
        this.realVelocity = 0;
        this.flyTime = 0;
        this.freeFall = 0;
        this.bannanaTotal = 0;
        this.levelBannaCount = 0;
        this.targetTime = 0;
        this.totalDistance = 0;
        this.collisionTimeStamp = 0;
        cBaseManager.collisionType = 0;
        this.closestIndex = -1;
        this.glideTime = 0;
        this.baseScore = cPhysicsManager.score;
        this.swingLengths = null;
        if (this.gameType == 3) {
            this.ghostRecordX = new short[400];
            this.ghostRecordY = new short[400];
        }
    }

    public void setRenderer(cGameRenderer cGameRenderer2) {
        this.renderer = cGameRenderer2;
    }

    public int getStateDuration() {
        return this.timeStamp - this.stateTimeStamp;
    }

    public int getState() {
        return cPhysicsManager.gameState;
    }

    public boolean update() {
        this.duration = cCanvas.time - this.timeStamp;
        if (cPhysicsManager.gameState != 10 && cPhysicsManager.gameState != 9) {
            if (this.duration > 4096) {
                this.duration = 4096;
            }
            this.gameDuration += this.duration;
        }
        this.timeStamp = cCanvas.time;
        if (this.duration == 0) {
            this.duration = 1;
        }
        int n = cFixedPoint.mul(this.duration, 50000);
        this.scaleAve = n = (n + this.scaleAve) / 2;
        n = cBaseManager.clamp(n, 1365);
        int n2 = 0;
        if (n > 0) {
            int n3 = this.duration;
            int n4 = n / 409 + 1;
            this.duration /= n4;
            while (n > 0) {
                this.scale = n > 409 ? 409 : n;
                if (cPhysicsManager.gameState != 10 && cPhysicsManager.gameState != 9) {
                    this.scaleDuration += this.scale;
                }
                n -= 409;
                cFixedPoint.objCount = 0;
                this.doCoreLogic();
                ++n2;
            }
            this.duration = n3;
            this.renderer.update(this.duration);
        }
        return this.getState() != 7;
    }

    public void setLevelId(int n) {
        this.levelId = n;
    }

    public int getLevelId() {
        return this.levelId;
    }

    public static int getLevelType() {
        return cPhysicsManager.levelType;
    }

    private void doPan() {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        cBaseManager.Vector2d vector2d = null;
        boolean bl = false;
        if (cCanvas.hasKey(256) || cCanvas.hasKey(16)) {
            this.panBack = true;
            crlCanvas.resetKeys();
        } else {
            for (int i = 0; i < cBaseManager.objectType.length; ++i) {
                if (cBaseManager.objectType[i] == 1) {
                    n2 = i;
                    continue;
                }
                if (cBaseManager.objectType[i] != 16) continue;
                n3 = i;
            }
        }
        if (this.panBack) {
            vector2d = cBaseManager.player.clone();
            n = 1228800;
        } else {
            n4 = this.getTargetNode(n2);
            if (n4 == -1) {
                bl = true;
                n4 = n3;
                n = 81920;
            } else {
                n = cBaseManager.clamp(81920, cBaseManager.objectField[n4][0] << 12, 245760);
            }
            if (cCanvas.hasKey(1) && !cCanvas.hasKey(9) && !cCanvas.hasKey(5)) {
                n *= 6;
            }
            if (n4 == -1) {
                this.startPlay();
                return;
            }
            vector2d = cBaseManager.objectLocations[n4];
            if (n == 0) {
                this.startPlay();
                return;
            }
        }
        cBaseManager.Vector2d vector2d2 = cBaseManager.sub(vector2d, this.cam);
        if (cBaseManager.inMag(vector2d2, 5) && bl) {
            this.panBack = true;
        }
        if (cBaseManager.inMag(vector2d2, cFixedPoint.mul(n, this.scale * 2))) {
            if (n4 != -1 && cBaseManager.objectType[n4] == 5) {
                this.targetNodes[n2] = this.targetNodes[n2] + 1;
            }
            if (this.panBack && this.teleportTimer == -1) {
                this.teleportTimer = this.gameDuration;
            }
            if (this.teleportTimer != -1 && this.gameDuration - this.teleportTimer > 500) {
                this.teleportTimer = -1;
                this.startPlay();
                return;
            }
        } else {
            cBaseManager.Vector2d vector2d3 = vector2d2.clone();
            int n5 = 1;
            do {
                vector2d2 = cBaseManager.normalise(vector2d2);
                if (cBaseManager.lastMag != Integer.MAX_VALUE) continue;
                vector2d2 = cBaseManager.scale(vector2d3, 4096 / ++n5);
            } while (cBaseManager.lastMag == Integer.MAX_VALUE);
            vector2d2 = cBaseManager.scale(vector2d2, cFixedPoint.mul(n, this.scale));
            cBaseManager.add(this.cam, vector2d2).copyTo(this.cam);
        }
        for (int i = 0; i < cBaseManager.objectType.length; ++i) {
            this.moveObjectAlongPath(i);
        }
    }

    private void startPlay() {
        this.panBack = false;
        this.setState(2);
        this.renderer.triggerEntry();
        this.renderer.triggerMessage(1);
    }

    private boolean allowHiscore() {
        return this.gameType == 2;
    }

    private void doCoreLogic() {
        switch (cPhysicsManager.gameState) {
            case 0: {
                if (!this.loadedLevel) {
                    this.processLevelData(this.levelId);
                } else if (this.getStateDuration() > 3000) {
                    if (this.pauseNeeded) {
                        this.pause();
                        this.pauseNeeded = false;
                    } else {
                        this.setState(1);
                        this.renderer.triggerMessage(51);
                    }
                }
                this.totalTime = 0;
                break;
            }
            case 8: {
                this.platformControlled = false;
                this.angleAcc = 0;
                if (this.getStateDuration() <= 0) break;
                cBaseRenderer.resetFade();
                this.setState(0);
                break;
            }
            case 10: {
                if (cCanvas.hasKey(256)) {
                    this.setState(2);
                    this.stateTimeStamp = this.timeStamp - this.oldTime;
                    crlCanvas.resetKeys();
                    return;
                }
                int n = cFixedPoint.mul(409600, this.scale);
                if (cCanvas.hasKey(1)) {
                    this.cam.y -= n;
                } else if (cCanvas.hasKey(2)) {
                    this.cam.y += n;
                } else if (cCanvas.hasKey(4)) {
                    this.cam.x -= n;
                } else if (cCanvas.hasKey(8)) {
                    this.cam.x += n;
                }
                if (!cPhysicsManager.canvas.cheat) break;
                this.cam.copyTo(cBaseManager.player);
                break;
            }
            case 9: {
                this.updatePauseControls();
                break;
            }
            case 1: {
                this.doPan();
                break;
            }
            case 2: {
                this.doInplay();
                break;
            }
            case 3: {
                this.flying = false;
                this.updateObjectData();
                this.updatePlayerPhysics();
                this.updateVelocites();
                if (this.getStateDuration() <= 7000) break;
                this.doFailLogic();
                break;
            }
            case 4: {
                if (this.getStateDuration() <= 2000) break;
                this.updateGlobalStats();
                this.setState(13);
                break;
            }
            case 13: {
                this.processPlayerCollision();
                cBaseManager.player.y -= cFixedPoint.mul(409600, this.scale);
                this.renderer.triggerEndStars();
                if (cBaseManager.player.y >= 0) break;
                this.calculateBonus();
                this.updateTimeAttackFields();
                this.setState(6);
                break;
            }
            case 6: {
                cBaseManager.player.y -= cFixedPoint.mul(409600, this.scale);
                this.renderer.triggerEndStars();
                if (cCanvas.hasKey(16) && crlCanvas.mPadDB == 1 && this.gameType != 3) {
                    this.stateTimeStamp -= 3000;
                    crlCanvas.mPadDB = 0;
                }
                this.doLevelEnd();
                break;
            }
            case 5: {
                if (this.getStateDuration() <= 1000) break;
                this.doGameExit(false, -16);
                break;
            }
            case 12: {
                this.updateStatControls();
                break;
            }
            case 14: {
                if (!this.updateMenuControls()) break;
                switch (this.menuText[this.menuSelect]) {
                    case 2: {
                        this.lifeCount = 3;
                        cPhysicsManager.score = 0;
                        this.loadedLevel = false;
                        this.bannaCount = 0;
                        this.setState(0);
                        break;
                    }
                    case 3: {
                        cBaseRenderer.fade = 255;
                        this.setState(15);
                    }
                }
                break;
            }
            case 15: {
                int n = cGameRenderer.GAME_MENU_EXIT[this.gameType][this.gameExitMode];
                if (this.gameType == 3) {
                    if (this.gameExitMode == 0) {
                        this.gotoStageSelect();
                    } else {
                        this.doGameExit(this.allowHiscore(), n);
                    }
                    return;
                }
                if (!this.updateMenuControls()) break;
                if (crlCanvas._mDemo && this.menuSelect == 1) {
                    cPhysicsManager.canvas.gameMidlet.exitToURL(crlCanvas._mDemoURL);
                    break;
                }
                if (this.gameExitMode == 0 && this.gameType != 2 && this.gameType != 4) {
                    this.gotoStageSelect();
                    break;
                }
                this.doGameExit(this.allowHiscore(), n);
                break;
            }
            case 11: {
                if (!this.updateMenuControls()) break;
                this.setState(12);
                this.newRandomUnlocked = false;
            }
        }
        if (cCanvas.hasKey(512) && cPhysicsManager.gameState != 9 && cPhysicsManager.gameState != 8 && cPhysicsManager.gameState != 0) {
            this.pause();
        }
        this.updateCamera();
        this.updateExternalVars();
    }

    private void updateStatControls() {
        if (this.updateMenuControls()) {
            switch (this.menuText[this.menuSelect]) {
                case 163: {
                    this.doNextArcadeLevel();
                    break;
                }
                case 4: 
                case 114: {
                    this.doNextLevel();
                    break;
                }
                case 165: {
                    this.doNextLevel();
                    break;
                }
                case 62: {
                    this.statsMode = 62;
                    this.menuSelect = 0;
                    break;
                }
                case 16: {
                    this.statsMode = 16;
                    this.menuSelect = 0;
                    break;
                }
                case 3: {
                    this.statsMode = 0;
                    break;
                }
                case 2: {
                    this.gameExitMode = 0;
                    this.statsMode = 0;
                    this.menuSelect = 0;
                    if (multiplayTracking != null && this.currentPlayer < multiplayTracking.length) {
                        cEntityManager.multiplayTracking[this.currentPlayer][1] = cPhysicsManager.score;
                    }
                    this.setState(15);
                    break;
                }
            }
        }
        crlCanvas.mPadDB = 0;
    }

    private void doLevelEnd() {
        if (this.gameType != 3 && this.getStateDuration() > 8000) {
            int n;
            int n2 = cPhysicsManager.canvas.completedCount(cPhysicsManager.levelType);
            if ((this.gameType == 0 || this.gameType == 1) && this.hitGoal) {
                cPhysicsManager.canvas.scoreLevel(cPhysicsManager.score - this.baseScore, this.levelId);
            }
            if (n2 < (n = cPhysicsManager.canvas.completedCount(cPhysicsManager.levelType)) && n == 8) {
                this.setState(11);
            } else if (this.levelIsEnd(this.levelId + 1, this.levelId) || this.allowHiscore() && n2 < n) {
                if (crlCanvas._mDemo) {
                    this.setState(15);
                    return;
                }
                if (this.gameType == 2 || this.gameType == 4) {
                    boolean bl = true;
                    for (int i = 0; i < multiplayTracking.length; ++i) {
                        int n3;
                        boolean bl2 = false;
                        bl2 = this.gameType == 4 ? (n3 = this.levelListIdx(multiplayTracking[i][3]) + 1) >= this.levelList.length - 1 : this.levelIsEnd(multiplayTracking[i][3] + 1, multiplayTracking[i][3]);
                        bl &= !bl2;
                        if (!bl2) continue;
                        cEntityManager.multiplayTracking[i][2] = 0;
                    }
                    if (bl) {
                        this.setState(12);
                    } else {
                        this.setState(15);
                    }
                } else {
                    int n4 = -16;
                    if (this.gameType == 0 || this.gameType == 1) {
                        n4 = -33;
                    }
                    this.doGameExit(this.allowHiscore(), n4);
                }
            } else {
                this.setState(12);
            }
        } else if (this.gameType == 3 && this.updateMenuControls()) {
            this.setState(12);
        }
    }

    private void updateTimeAttackFields() {
        this.totalTime = this.totalTime / 10 * 10;
        if (this.gameType == 3) {
            if (multiplayTracking[this.currentPlayer][5] == 0 || multiplayTracking[this.currentPlayer][5] > this.totalTime) {
                cEntityManager.multiplayTracking[this.currentPlayer][5] = this.totalTime;
            }
            if (this.totalTime < cPhysicsManager.canvas.timeAttack[this.levelId] || cPhysicsManager.canvas.timeAttack[this.levelId] == 0) {
                cPhysicsManager.canvas.timeAttack[this.levelId] = this.totalTime;
                cPhysicsManager.canvas.saveRmsData();
            }
        }
    }

    private void doGameExit(boolean bl, int n) {
        int n2;
        this.setState(7);
        if (cPhysicsManager.canvas.isSpecial(this.levelId) && bl) {
            cPhysicsManager.levelType = 3;
        }
        if (bl) {
            int n3;
            n2 = 0;
            int n4 = 0;
            for (n3 = 0; n3 < multiplayTracking.length; ++n3) {
                int n5 = multiplayTracking[n3][1];
                if (n2 >= n5) continue;
                n2 = n5;
                n4 = n3;
            }
            cMenu.nameEntryPlayer = n4;
            n3 = n2;
            if (cPhysicsManager.canvas.isHiScore(cPhysicsManager.levelType, n3) || cPhysicsManager.canvas.cheat) {
                cPhysicsManager.canvas.menuMode(-26);
                cPhysicsManager.score = n3;
            } else {
                cPhysicsManager.canvas.menuMode(n);
            }
        } else {
            cPhysicsManager.canvas.menuMode(n);
        }
        n2 = cPhysicsManager.levelType;
        if (n2 == 3) {
            n2 = cPhysicsManager.levelData[this.levelId - 1][0];
            cBaseRenderer.loadParralax(this.renderer.getWidth(), this.renderer.getHeight(), n2, false);
        }
        if (n == -1) {
            cUI._mUIoption = this.levelId - cPhysicsManager.canvas.getTypeStart(n2);
        }
    }

    private void updateGlobalStats() {
        int n = 0;
        for (int i = 0; i < cBaseManager.collisionTimer.length; ++i) {
            if (cBaseManager.collisionTimer[i] == 0) continue;
            ++n;
        }
        cPhysicsManager.canvas.incrementStat(0, cPhysicsManager.levelData[this.levelId][1] * 1000 - this.timeLeft);
        cPhysicsManager.canvas.incrementStat(2, this.flyTime);
        cPhysicsManager.canvas.incrementStat(4, this.goalAccuracy);
        cPhysicsManager.canvas.incrementStat(1, this.bannanaTotal);
        cPhysicsManager.canvas.incrementStat(3, 1);
        cPhysicsManager.canvas.incrementStat(7, n);
        cPhysicsManager.canvas.incrementStat(8, this.totalDistance / 10000);
        cPhysicsManager.canvas.incrementStat(5, this.freeFall);
        cPhysicsManager.canvas.statsTable[6] = cPhysicsManager.canvas.statsTable[0] / cPhysicsManager.canvas.statsTable[8] / 10;
    }

    private void gotoStageSelect() {
        if ((this.gameType == 0 || this.gameType == 1) && this.hitGoal) {
            cPhysicsManager.canvas.scoreLevel(cPhysicsManager.score - this.baseScore, this.levelId);
        }
        cPhysicsManager.canvas.saveRmsData();
        if (this.gameType == 0 || this.gameType == 1) {
            this.doGameExit(false, -33);
        } else if (this.gameType == 3) {
            this.doGameExit(false, -1);
        }
    }

    private void doInplay() {
        if (!this.hitGoal) {
            this.timeLeft -= this.duration;
        }
        if (this.gameType != 3) {
            if (this.timeLeft <= 0) {
                this.timeup = true;
                this.timeLeft = 0;
                this.setState(3);
                cPhysicsManager.canvas.playJingle(1);
                this.renderer.triggerMessage(48);
            } else if (this.timeLeft < 10000) {
                this.renderer.triggerMessage(95);
            }
        }
        if (cPhysicsManager.levelType == 3 && this.bannanaTotal >= this.levelBannaCount) {
            this.hitGoal = true;
            this.setState(13);
            cPhysicsManager.canvas.playJingle(2);
            this.calculateBonus();
            this.updateTimeAttackFields();
            this.renderer.triggerMessage(133);
        }
        if (this.getStateDuration() > 1000) {
            this.gravity.y = cPhysicsManager.charData[5];
            if (!this.hitGoal) {
                this.totalTime += this.duration;
            }
        } else {
            this.gravity.y = -8192;
            this.timeLeft += this.duration;
        }
        if (this.gameType == 3) {
            int n = this.totalTime / 250;
            int n2 = cFixedPoint.toInt(cBaseManager.player.x);
            int n3 = cFixedPoint.toInt(cBaseManager.player.y);
            if (n < 400) {
                this.ghostRecordX[n] = (short)n2;
                this.ghostRecordY[n] = (short)n3;
            }
        }
        this.calcStats();
        this.updateObjectData();
        this.updateVelocites();
        this.updateControls();
        this.updatePlayerPhysics();
    }

    private void calcStats() {
        if (this.flying) {
            this.flyTime += this.duration;
        } else if (cBaseManager.collisionType == 0) {
            this.freeFall += this.duration;
        }
        this.totalDistance += this.getRealSpeed() * this.duration;
    }

    private void doFailLogic() {
        this.updateGlobalStats();
        switch (this.gameType) {
            case 0: 
            case 1: {
                if (cPhysicsManager.levelType == 3) {
                    if (this.levelIsEnd(this.levelId + 1, this.levelId)) {
                        this.doGameExit(this.allowHiscore(), -16);
                    } else {
                        this.setState(12);
                    }
                    return;
                }
                if (this.lifeCount > 0) {
                    --this.lifeCount;
                    this.loadedLevel = false;
                    cBaseRenderer.resetFade();
                    this.setState(8);
                    break;
                }
                this.setState(14);
                break;
            }
            case 3: 
            case 4: {
                if (cPhysicsManager.levelType != 3) {
                    --this.lifeCount;
                }
                if (this.gameType == 4 && cPhysicsManager.levelType == 3) {
                    int n = this.levelListIdx(this.levelId);
                    cEntityManager.multiplayTracking[this.currentPlayer][3] = this.levelList[n + 1];
                }
                this.doNextMonkey();
                if (this.currentPlayer == -1) {
                    this.setState(15);
                    return;
                }
                cBaseRenderer.resetFade();
                this.setState(8);
                break;
            }
            case 2: {
                if (cPhysicsManager.levelType != 3) {
                    --this.lifeCount;
                    cEntityManager.multiplayTracking[this.currentPlayer][3] = this.levelId;
                } else {
                    cEntityManager.multiplayTracking[this.currentPlayer][3] = this.levelId + 1;
                }
                this.doNextMonkey();
                if (this.currentPlayer != -1) break;
                this.setState(15);
            }
        }
    }

    private int getNextPlayer() {
        int n;
        for (n = this.currentPlayer + 1; n < multiplayTracking.length; ++n) {
            if (multiplayTracking[n][2] < 0) continue;
            return n;
        }
        for (n = 0; n < this.currentPlayer; ++n) {
            if (multiplayTracking[n][2] < 0) continue;
            return n;
        }
        if (multiplayTracking[this.currentPlayer][2] >= 0) {
            return this.currentPlayer;
        }
        return -1;
    }

    private void doNextLevel() {
        switch (this.gameType) {
            case 0: {
                this.doNextArcadeLevel();
                break;
            }
            case 1: {
                cPhysicsManager.score = this.baseScore;
                this.lifeCount = 3;
                this.bannaCount = 0;
                this.loadedLevel = false;
                cBaseRenderer.resetFade();
                this.setState(8);
                break;
            }
            case 3: {
                if (this.totalTime < this.bestSessionTime) {
                    this.bestSessionTime = this.totalTime;
                    this.ghostX = this.ghostRecordX;
                    this.ghostY = this.ghostRecordY;
                    this.ghostIdx = this.totalTime / 250;
                    this.ghostPlayer = this.currentPlayer;
                }
                this.doNextMonkey();
                break;
            }
            case 2: {
                int n = this.levelId + 1;
                if (this.levelList != null) {
                    int n2 = 0;
                    for (int i = 0; i < cPhysicsManager.levelData.length; ++i) {
                        if (this.levelList[i] != this.levelId) continue;
                        n2 = i;
                        break;
                    }
                    n = this.levelList[n2 + 1];
                }
                cEntityManager.multiplayTracking[this.currentPlayer][3] = n;
                this.doNextMonkey();
                break;
            }
            case 4: {
                int n = this.levelListIdx(this.levelId);
                cEntityManager.multiplayTracking[this.currentPlayer][3] = this.levelList[n + 1];
                this.doNextMonkey();
            }
        }
    }

    private boolean levelIsEnd(int n, int n2) {
        if (this.gameType == 4) {
            int n3 = this.levelListIdx(n2);
            boolean bl = n3 + 1 >= this.levelList.length;
            return bl;
        }
        if (crlCanvas._mDemo && n >= 3 || n >= cPhysicsManager.levelData.length) {
            return true;
        }
        int n4 = cPhysicsManager.levelData[n][0];
        int n5 = cPhysicsManager.levelData[n2][0];
        if (n4 == 3) {
            n4 = cPhysicsManager.levelData[n - 1][0];
        }
        if (n5 == 3) {
            n5 = cPhysicsManager.levelData[n2 - 1][0];
        }
        if (n4 != n5) {
            return true;
        }
        return n >= LEVEL_ENDINGS[n4][cPhysicsManager.canvas.specialLocked() ? 0 : 1];
    }

    private int levelListIdx(int n) {
        int n2 = this.levelList.length - 1;
        for (int i = 0; i < this.levelList.length; ++i) {
            if (this.levelList[i] != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private void doNextArcadeLevel() {
        this.loadedLevel = false;
        int n = cPhysicsManager.canvas.completedCount(cPhysicsManager.levelType);
        boolean bl = cPhysicsManager.canvas.randomLocked();
        if (this.hitGoal) {
            cPhysicsManager.canvas.scoreLevel(cPhysicsManager.score - this.baseScore, this.levelId);
        }
        int n2 = cPhysicsManager.canvas.completedCount(cPhysicsManager.levelType);
        boolean bl2 = this.newRandomUnlocked = cPhysicsManager.canvas.randomLocked() && !bl;
        if (n < n2 && n2 == 8) {
            this.setState(11);
            cPhysicsManager.canvas.saveRmsData();
            return;
        }
        cPhysicsManager.canvas.saveRmsData();
        if (this.postBonusLevel != -1) {
            this.levelId = this.postBonusLevel;
            this.postBonusLevel = -1;
        } else {
            ++this.levelId;
        }
        if (this.levelIsEnd(this.levelId, this.levelId - 1)) {
            cPhysicsManager.canvas.saveRmsData();
            this.doGameExit(this.allowHiscore(), -23);
        } else {
            ++this.levelsComplete;
            if (cPhysicsManager.isBonus(this.levelId) && !cPhysicsManager.canvas.isSpecial(this.levelId)) {
                if (this.levelsComplete != 5) {
                    ++this.levelId;
                }
            } else if (this.levelsComplete == 5 && !this.levelIsEnd(this.levelId + 1, this.levelId)) {
                this.postBonusLevel = this.levelId;
                this.levelId = 5 + cPhysicsManager.canvas.getTypeStart(cEntityManager.getLevelType());
            }
            crlCanvas.gResourceManager.loadPack(new long[]{cSponge.PACK_LEVEL_FILES[this.levelId]});
            try {
                crlCanvas.gResourceManager.update();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cBaseRenderer.resetFade();
            this.setState(8);
        }
    }

    private void doNextMonkey() {
        cEntityManager.multiplayTracking[this.currentPlayer][2] = this.lifeCount;
        cEntityManager.multiplayTracking[this.currentPlayer][1] = cPhysicsManager.score;
        cEntityManager.multiplayTracking[this.currentPlayer][4] = this.bannaCount;
        this.currentPlayer = this.getNextPlayer();
        if (this.currentPlayer != -1) {
            try {
                if (this.levelId != multiplayTracking[this.currentPlayer][3]) {
                    this.levelId = multiplayTracking[this.currentPlayer][3];
                    crlCanvas.gResourceManager.loadPack(new long[]{cSponge.PACK_LEVEL_FILES[this.levelId]});
                    crlCanvas.gResourceManager.update();
                }
                if (this.character != multiplayTracking[this.currentPlayer][0]) {
                    this.character = multiplayTracking[this.currentPlayer][0];
                    long l = cSponge.PACK_CHARACTERS[this.character];
                    long l2 = cSponge.PACK_BALLS[this.currentPlayer];
                    crlCanvas.gResourceManager.loadPack(new long[]{l, l2});
                    crlCanvas.gResourceManager.update();
                    crlCanvas.gResourceManager.update();
                    this.renderer.monkey = crlCanvas.gResourceManager.getIMPByID(l);
                    this.renderer.ballImage = crlCanvas.gResourceManager.getIMPByID(l2);
                }
                cBaseRenderer.loadParralax(this.renderer.getWidth(), this.renderer.getHeight(), cPhysicsManager.levelData[this.levelId][0], false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cPhysicsManager.score = multiplayTracking[this.currentPlayer][1];
            this.lifeCount = multiplayTracking[this.currentPlayer][2];
            this.bannaCount = multiplayTracking[this.currentPlayer][4];
            this.loadedLevel = false;
            cBaseRenderer.resetFade();
            this.setState(8);
        }
    }

    public void setChallengeChars(int[] nArray) {
        multiplayTracking = new int[nArray.length][6];
        cPhysicsManager.score = 0;
        for (int i = 0; i < multiplayTracking.length; ++i) {
            cEntityManager.multiplayTracking[i][0] = nArray[i];
            cEntityManager.multiplayTracking[i][1] = 0;
            cEntityManager.multiplayTracking[i][2] = 3;
            cEntityManager.multiplayTracking[i][3] = this.levelId;
            cEntityManager.multiplayTracking[i][4] = 0;
            cEntityManager.multiplayTracking[i][5] = 0;
        }
    }

    public void setLevelList(int[] nArray) {
        this.levelList = nArray;
    }

    private static final short readShort() throws Throwable {
        return resourceStream.readShort();
    }

    private static final byte readByte() throws Throwable {
        return resourceStream.readByte();
    }

    private static final int read24Bits() throws Throwable {
        byte by = cEntityManager.readByte();
        byte by2 = cEntityManager.readByte();
        byte by3 = cEntityManager.readByte();
        int n = ((by & 0xFF) << 16) + ((by2 & 0xFF) << 8) + (by3 & 0xFF);
        return n;
    }

    private static final boolean readBoolean() throws Throwable {
        return resourceStream.readBoolean();
    }

    private static final int readInt() throws Throwable {
        return resourceStream.readInt();
    }

    private void processLevelData(int n) {
        try {
            int n2;
            int n3;
            Object object;
            InputStream inputStream;
            Object object2;
            this.initVars();
            if (cPhysicsManager.charData == null) {
                byte[] byArray = crlCanvas.gResourceManager.getBinBySpongeID(150352084075188L);
                object2 = new ByteArrayInputStream(byArray);
                inputStream = new DataInputStream((InputStream)object2);
                object = new int[1][23];
                for (n3 = 0; n3 < 23; ++n3) {
                    for (int i = 0; i < 1; ++i) {
                        object[i][n3] = (int)(((DataInputStream)inputStream).readLong() >> 12);
                    }
                }
                cPhysicsManager.charData = object[0];
                ((FilterInputStream)inputStream).close();
                ((ByteArrayInputStream)object2).close();
            }
            if (cPhysicsManager.levelData == null) {
                cPhysicsManager.loadLevelSettings();
            }
            this.timeLeft = cPhysicsManager.levelData[n][1] * 1000;
            cPhysicsManager.levelType = cPhysicsManager.levelData[n][0];
            this.glideBurnRate = cFixedPoint.toInt(cPhysicsManager.charData[20] * 1000);
            this.glideChunkTime = cFixedPoint.toInt(cPhysicsManager.charData[21] * 1000);
            this.glideMaxChunks = cFixedPoint.toInt(cPhysicsManager.charData[22]);
            this.glideChunkUnits = this.glideChunkTime / this.glideBurnRate;
            this.glideTimeLimit = this.glideChunkUnits * this.glideMaxChunks;
            this.platformRampUp = cPhysicsManager.charData[18];
            this.platformRampDown = cPhysicsManager.charData[19];
            this.gravity.x = 0;
            this.gravity.y = 0;
            int n4 = 0;
            object2 = crlCanvas.gResourceManager.getBinBySpongeID(cSponge.PACK_LEVEL_FILES[n]);
            inputStream = new ByteArrayInputStream((byte[])object2);
            object = new DataInputStream(inputStream);
            resourceStream = object;
            n3 = cEntityManager.readByte() & 0xFF;
            cBaseManager.objectType = new int[n3];
            cBaseManager.objectLocations = new cBaseManager.Vector2d[n3];
            cBaseManager.objectActive = new boolean[n3];
            cBaseManager.objectField = new int[n3][5];
            cBaseManager.collisionTimer = new int[n3];
            this.platformAngles = new int[n3];
            this.pathIndices = new int[n3];
            int[] nArray = new int[n3];
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                if (n6 == 0 && n2 < n3) {
                    n5 = cEntityManager.readByte();
                    n6 = cEntityManager.readByte();
                }
                cBaseManager.objectType[n2] = n5;
                --n6;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n7 = 0;
                int n8 = 0;
                short s = 0;
                short s2 = 0;
                int n9 = 0;
                this.pathIndices[n2] = -1;
                cBaseManager.objectActive[n2] = true;
                nArray[n2] = n2;
                switch (cBaseManager.objectType[n2]) {
                    case 8: {
                        cBaseManager.objectField[n2][3] = cEntityManager.readShort();
                        cBaseManager.objectField[n2][4] = cEntityManager.readShort();
                        cBaseManager.objectField[n2][2] = cEntityManager.readShort();
                        s2 = cEntityManager.readShort();
                        cEntityManager.readShort();
                        cEntityManager.readShort();
                        cEntityManager.readShort();
                        s = cEntityManager.readShort();
                        n7 = cEntityManager.readShort();
                        n8 = cEntityManager.readShort();
                        cBaseManager.objectField[n2][0] = s;
                        cBaseManager.objectField[n2][1] = s2;
                        break;
                    }
                    case 18: {
                        cBaseManager.objectField[n2][0] = cEntityManager.readShort();
                        cBaseManager.objectField[n2][4] = cEntityManager.readShort();
                        s2 = cEntityManager.readShort();
                        cBaseManager.objectField[n2][1] = cEntityManager.readShort();
                        n7 = cEntityManager.readShort() + cBaseManager.objectField[n2][1] / 2;
                        n8 = cEntityManager.readShort() + s2 / 2;
                        n4 += 2;
                        break;
                    }
                    case 16: {
                        cBaseManager.objectField[n2][2] = cEntityManager.readByte() & 0xFF;
                        cBaseManager.objectField[n2][0] = cEntityManager.readByte() & 0xFF;
                        cBaseManager.objectField[n2][4] = cEntityManager.readByte() & 0xFF;
                        cBaseManager.objectField[n2][1] = cEntityManager.readByte() & 0xFF;
                        cBaseManager.objectField[n2][3] = cEntityManager.readByte() & 0xFF;
                        n9 = cEntityManager.read24Bits();
                        n7 = n9 >> 12 & 0xFFF;
                        n8 = n9 & 0xFFF;
                        n4 += 2;
                        break;
                    }
                    case 15: {
                        if (cEntityManager.readBoolean()) {
                            cBaseManager.objectField[n2][2] = cBaseManager.objectField[n2][2] | 1;
                        }
                        if (cEntityManager.readBoolean()) {
                            cBaseManager.objectField[n2][2] = cBaseManager.objectField[n2][2] | 2;
                        }
                        cBaseManager.objectField[n2][3] = cEntityManager.readShort();
                        cBaseManager.objectField[n2][4] = cEntityManager.readShort();
                        cBaseManager.objectField[n2][1] = cEntityManager.readShort();
                        cBaseManager.objectField[n2][0] = cEntityManager.readShort();
                        n7 = cEntityManager.readShort() + (cBaseManager.objectField[n2][0] >> 1);
                        n8 = cEntityManager.readShort() + (cBaseManager.objectField[n2][1] >> 1);
                        break;
                    }
                    case 12: {
                        cBaseManager.objectField[n2][2] = cEntityManager.readShort();
                        s2 = cEntityManager.readShort();
                        cBaseManager.objectField[n2][1] = cEntityManager.readByte();
                        if (cEntityManager.readBoolean()) {
                            cBaseManager.objectField[n2][0] = cBaseManager.objectField[n2][0] | 1;
                        }
                        cBaseManager.objectField[n2][3] = cEntityManager.readShort();
                        s = cEntityManager.readShort();
                        n7 = cEntityManager.readShort() + s / 2;
                        n8 = cEntityManager.readShort() + s2 / 2;
                        n4 += 2;
                        break;
                    }
                    case 11: {
                        cBaseManager.objectField[n2][1] = cEntityManager.readShort();
                        cBaseManager.objectField[n2][0] = cEntityManager.readShort() / 2;
                        cEntityManager.readShort();
                        n7 = cEntityManager.readShort() + cBaseManager.objectField[n2][0] / 2;
                        n8 = cEntityManager.readShort() + cBaseManager.objectField[n2][0] / 2;
                        break;
                    }
                    case 7: {
                        n9 = cEntityManager.read24Bits();
                        int n10 = n9 >> 12 & 0xFFF;
                        int n11 = n9 & 0xFFF;
                        cBaseManager.objectField[n2][1] = n10;
                        cBaseManager.objectField[n2][0] = n11;
                        n7 = cEntityManager.readShort();
                        n8 = cEntityManager.readShort();
                        break;
                    }
                    case 6: {
                        cBaseManager.objectField[n2][1] = cEntityManager.readShort();
                        cBaseManager.objectField[n2][0] = cEntityManager.readShort() / 2;
                        cEntityManager.readShort();
                        n7 = cEntityManager.readShort() + cBaseManager.objectField[n2][0];
                        n8 = cEntityManager.readShort() + cBaseManager.objectField[n2][0];
                        break;
                    }
                    case 5: {
                        this.pathIndices[n2] = cEntityManager.readByte();
                        cBaseManager.objectField[n2][0] = cEntityManager.readByte();
                        n9 = cEntityManager.read24Bits();
                        n7 = n9 >> 12 & 0xFFF;
                        n8 = n9 & 0xFFF;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n9 = cEntityManager.read24Bits();
                        n7 = n9 >> 12 & 0xFFF;
                        n8 = n9 & 0xFFF;
                        if (cBaseManager.objectType[n2] == 4) {
                            this.levelBannaCount += 10;
                            break;
                        }
                        ++this.levelBannaCount;
                        break;
                    }
                    case 19: {
                        cBaseManager.objectField[n2][0] = cEntityManager.readShort();
                        s2 = cEntityManager.readShort();
                        cBaseManager.objectField[n2][1] = cEntityManager.readShort();
                        n7 = cEntityManager.readShort() + cBaseManager.objectField[n2][1];
                        n8 = cEntityManager.readShort() + (s2 >> 1);
                        n4 += 2;
                        break;
                    }
                    case 2: {
                        short s3 = cEntityManager.readShort();
                        int n12 = cEntityManager.readByte() & 0xFF;
                        byte by = cEntityManager.readByte();
                        int n13 = 0;
                        if (by > 1) {
                            n13 = cEntityManager.readInt();
                        }
                        short s4 = cEntityManager.readShort();
                        short s5 = cEntityManager.readShort();
                        short s6 = cEntityManager.readShort();
                        cBaseManager.objectField[n2][0] = s3;
                        this.platformAngles[n2] = cFixedPoint.mul(cBaseManager.objectField[n2][0] << 12, 71);
                        cBaseManager.objectField[n2][3] = 90;
                        cBaseManager.objectField[n2][1] = n12;
                        cBaseManager.objectField[n2][4] = n13;
                        n7 = s4;
                        n8 = s5;
                        cBaseManager.objectField[n2][2] = s6;
                        n4 += by + 1;
                        break;
                    }
                    case 1: {
                        this.flying = false;
                        this.playerX = cEntityManager.readShort();
                        this.playerY = cEntityManager.readShort();
                        cBaseManager.player = new cBaseManager.Vector2d();
                        cBaseManager.player.x = this.playerX << 12;
                        cBaseManager.player.y = this.playerY << 12;
                        this.cam = cBaseManager.player.clone();
                        break;
                    }
                    case 20: {
                        this.pathIndices[n2] = cEntityManager.readByte();
                        n7 = cEntityManager.readShort();
                        n8 = cEntityManager.readShort();
                        n4 += 2;
                        break;
                    }
                    case 21: {
                        cBaseManager.objectField[n2][2] = cEntityManager.readShort();
                        cBaseManager.objectField[n2][1] = cEntityManager.readShort();
                        cBaseManager.objectField[n2][0] = cEntityManager.readShort();
                        n7 = cEntityManager.readShort();
                        n8 = cEntityManager.readShort();
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        System.out.print("unknown");
                    }
                }
                cBaseManager.Vector2d vector2d = new cBaseManager.Vector2d();
                vector2d.x = n7 << 12;
                vector2d.y = n8 << 12;
                cBaseManager.objectLocations[n2] = vector2d;
            }
            cBaseManager.line = new cBaseManager.Vector2d[n4];
            cBaseManager.lineIndex = new int[n4];
            this.calculatePaths(nArray);
            this.calcluateLineSegments();
            this.renderer.setStageType(cPhysicsManager.levelType);
            this.renderer.loadImages();
            this.renderer.generateCamNodes();
            ((FilterInputStream)object).close();
            ((ByteArrayInputStream)inputStream).close();
            cCanvas.currentTune = cPhysicsManager.levelType + 1;
            if (!cPhysicsManager.canvas.appPaused) {
                cPhysicsManager.canvas.loadGameAudio();
                cPhysicsManager.canvas.playMusic();
                cPhysicsManager.canvas._audioManager.update();
            }
            this.loadedLevel = true;
        }
        catch (Throwable throwable) {
            this.loadedLevel = true;
        }
    }

    private void calculatePaths(int[] nArray) {
        this.targetNodes = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (cBaseManager.objectType[i] != 5 && cBaseManager.objectType[i] != 20) continue;
            int n = this.pathIndices[i];
            int n2 = -1;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != n) continue;
                n2 = j;
                break;
            }
            this.pathIndices[i] = n2;
        }
    }

    private void calcluateLineSegments() {
        int n = 0;
        block8: for (int i = 0; i < cBaseManager.objectType.length; ++i) {
            cBaseManager.Vector2d vector2d = cBaseManager.objectLocations[i];
            if (!cBaseManager.objectActive[i]) continue;
            switch (cBaseManager.objectType[i]) {
                case 2: {
                    n += this.updatePlatformInfo(i, n);
                    continue block8;
                }
                case 16: {
                    n += this.updateGoalInfo(i, n);
                    continue block8;
                }
                case 12: {
                    n += this.updateSwitchInfo(i, n);
                    continue block8;
                }
                case 20: {
                    int n2 = this.getTargetNode(i);
                    if (n2 == -1) continue block8;
                    cBaseManager.Vector2d vector2d2 = vector2d.clone();
                    cBaseManager.Vector2d vector2d3 = cBaseManager.objectLocations[n2].clone();
                    cBaseManager.setLineSegment(n, vector2d2, i);
                    cBaseManager.setLineSegment(n + 1, vector2d3, i);
                    n += 2;
                    continue block8;
                }
                case 19: {
                    n += this.updateHorizLine(i, n, vector2d, cBaseManager.objectField[i][1]);
                    continue block8;
                }
                case 18: {
                    n += this.updateHorizLine(i, n, vector2d, cBaseManager.objectField[i][1]);
                }
            }
        }
    }

    private int updateSwitchInfo(int n, int n2) {
        cBaseManager.Vector2d vector2d = cBaseManager.objectLocations[n];
        return this.updateHorizLine(n, n2, vector2d, 50);
    }

    private int updateGoalInfo(int n) {
        int n2 = cBaseManager.getSegmentStart(n);
        if (n2 == -1) {
            return 0;
        }
        return this.updateGoalInfo(n, n2);
    }

    private int updateGoalInfo(int n, int n2) {
        cBaseManager.Vector2d vector2d = cBaseManager.objectLocations[n];
        int n3 = cBaseManager.objectField[n][0] + cBaseManager.objectField[n][1] + cBaseManager.objectField[n][2] + cBaseManager.objectField[n][3] + cBaseManager.objectField[n][4];
        return this.updateHorizLine(n, n2, vector2d, n3);
    }

    private int updateHorizLine(int n, int n2, cBaseManager.Vector2d vector2d, int n3) {
        cBaseManager.Vector2d vector2d2 = new cBaseManager.Vector2d();
        cBaseManager.Vector2d vector2d3 = new cBaseManager.Vector2d();
        vector2d2.x = vector2d.x - (n3 >> 1 << 12);
        vector2d2.y = vector2d.y;
        vector2d3.x = vector2d.x + (n3 >> 1 << 12);
        vector2d3.y = vector2d.y;
        cBaseManager.setLineSegment(n2, vector2d2, n);
        cBaseManager.setLineSegment(n2 + 1, vector2d3, n);
        return 2;
    }

    private int updatePlatformInfo(int n) {
        int n2 = cBaseManager.getSegmentStart(n);
        if (n2 == -1) {
            return 0;
        }
        return this.updatePlatformInfo(n, n2);
    }

    private int updatePlatformInfo(int n, int n2) {
        int n3 = this.platformAngles[n];
        int n4 = this.angleChangeRate(n);
        this.setPlatformLineAngle(n, n2, n3 += n4);
        return this.segCount(n) + 1;
    }

    private boolean switchesActive(int n) {
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < cBaseManager.objectType.length; ++i) {
            if (cBaseManager.objectType[i] != 12 || cBaseManager.objectField[i][2] != n) continue;
            switch (cBaseManager.objectField[i][3]) {
                case 0: {
                    if (bl2) {
                        bl = true;
                    }
                    if (bl &= cBaseManager.objectField[i][0] > 0) break;
                    return false;
                }
                case 1: {
                    if (!(bl |= cBaseManager.objectField[i][0] > 0)) break;
                    return true;
                }
                case 2: {
                    bl ^= cBaseManager.objectField[i][0] > 0;
                }
            }
            bl2 = false;
        }
        if (!bl2) {
            return bl;
        }
        return true;
    }

    private void moveObjectAlongPath(int n) {
        int n2;
        int n3 = cBaseManager.objectType[n];
        if (!cBaseManager.objectActive[n] || n3 == 3 || n3 == 4 || n3 == 5 || n3 == 20 || n3 == 1) {
            return;
        }
        cBaseManager.Vector2d vector2d = cBaseManager.objectLocations[n];
        boolean bl = true;
        if (cBaseManager.objectType[n] == 2) {
            n2 = cBaseManager.objectField[n][2] >> 8;
            bl = this.switchesActive(n2);
        }
        if (!bl) {
            return;
        }
        if (cBaseManager.objectType[n] == 2 && cBaseManager.isFlag(cBaseManager.objectField[n][2], 64)) {
            if (cBaseManager.collisionTimer[n] != 0 && this.gameDuration - cBaseManager.collisionTimer[n] > 1000) {
                vector2d.y += cFixedPoint.mul(this.scale, cFixedPoint.mul(this.gravity.y, (this.gameDuration - cBaseManager.collisionTimer[n] - 1000) * 14));
                this.updatePlatformInfo(n);
                if (vector2d.y > this.cam.y + 2048000) {
                    cBaseManager.objectActive[n] = false;
                }
            }
            return;
        }
        n2 = this.getTargetNode(n);
        if (n2 == -1) {
            return;
        }
        cBaseManager.Vector2d vector2d2 = cBaseManager.objectLocations[n2];
        int n4 = cBaseManager.objectField[n2][0] << 12;
        if (n4 == 0) {
            return;
        }
        if (cBaseManager.objectType[n] == 2 && cBaseManager.isFlag(cBaseManager.objectField[n][2], 128)) {
            int n5;
            if (this.swingLengths == null) {
                this.swingLengths = new int[cBaseManager.objectActive.length];
            }
            if ((n5 = this.swingLengths[n]) == 0) {
                this.swingLengths[n] = n5 = cBaseManager.mag(cBaseManager.sub(vector2d2, vector2d));
            }
            int n6 = this.getSwingAngle(0, n4);
            cBaseManager.tempVect2.x = cFixedPoint.sin(n6);
            cBaseManager.tempVect2.y = cFixedPoint.cos(n6);
            cBaseManager.Vector2d vector2d3 = cBaseManager.scale(cBaseManager.tempVect2, n5);
            vector2d3 = cBaseManager.add(vector2d2, vector2d3);
            vector2d3.copyTo(cBaseManager.objectLocations[n]);
        } else {
            cBaseManager.Vector2d vector2d4 = cBaseManager.sub(vector2d2, vector2d);
            if (cBaseManager.inMag(vector2d4, cFixedPoint.mul(n4, this.scale * 2))) {
                this.targetNodes[n] = this.targetNodes[n] + 1;
            }
            vector2d4 = cBaseManager.normalise(vector2d4);
            vector2d4 = cBaseManager.scale(vector2d4, cFixedPoint.mul(n4, this.scale));
            vector2d4 = cBaseManager.add(vector2d, vector2d4);
            vector2d4.copyTo(cBaseManager.objectLocations[n]);
        }
        if (cBaseManager.objectType[n] == 16) {
            this.updateGoalInfo(n);
        } else if (cBaseManager.objectType[n] == 2) {
            this.updatePlatformInfo(n);
        }
    }

    private void updateCamera() {
        int n = cBaseManager.player.x - this.cam.x;
        int n2 = cBaseManager.player.y - this.cam.y;
        int n3 = 696320;
        int n4 = 696320;
        int n5 = 0;
        int n6 = 0;
        switch (this.getState()) {
            case 6: {
                n6 = -409600;
                break;
            }
            case 3: {
                if (!this.fallout) break;
                n6 = 409600;
                break;
            }
            case 2: {
                n5 = this.playerRealDelta.x >> 1;
                n6 = -(this.playerRealDelta.y * 2);
                if (Math.abs(n5) < 8192) {
                    n5 = 0;
                } else if (Math.abs(n5) < 40960) {
                    n3 = 32768;
                }
                if (Math.abs(n6) < 8192) {
                    n6 = 0;
                } else if (Math.abs(n6) < 40960) {
                    n4 = 32768;
                }
                n5 = cBaseManager.clamp(-61440, n5, 61440);
                n6 = cBaseManager.clamp(-204800, n6, 40960);
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 13: {
                break;
            }
            default: {
                return;
            }
        }
        n = cBaseManager.player.x + n5 - this.cam.x;
        n2 = cBaseManager.player.y + n6 - this.cam.y;
        switch (this.getState()) {
            case 1: 
            case 10: {
                n3 = 40960000;
                n4 = 40960000;
                n = 0;
                n2 = 0;
                break;
            }
            case 4: {
                n4 = 20480;
                break;
            }
            case 6: {
                n4 = 40960;
                break;
            }
            case 3: {
                n4 = 4096;
                break;
            }
            case 2: {
                if (Math.abs(n) <= 163840 && Math.abs(n2) <= 245760) break;
                n3 = cBaseManager.clamp(40960, Math.abs(n / 15), 409600);
                n4 = cBaseManager.clamp(40960, Math.abs(n2 / 15), 409600);
            }
        }
        n = cBaseManager.clamp(n, n3);
        n2 = cBaseManager.clamp(n2, n4);
        this.cam.x += n;
        this.cam.y += n2;
    }

    private void updateExternalVars() {
        this.playerBallAngle = cFixedPoint.toInt(this.pa);
        this.playerX = cFixedPoint.toInt(cBaseManager.player.x);
        this.playerY = cFixedPoint.toInt(cBaseManager.player.y);
        this.cameraX = cFixedPoint.toInt(this.cam.x);
        this.cameraY = cFixedPoint.toInt(this.cam.y);
        this.playerDx = cFixedPoint.toInt(this.playerDelta.x);
        this.playerDy = cFixedPoint.toInt(this.playerDelta.y);
    }

    public void pause() {
        cPhysicsManager.canvas._audioManager.stopAllAudio();
        cPhysicsManager.canvas._audioManager.update();
        if (cPhysicsManager.gameState != 9) {
            this.oldState = cPhysicsManager.gameState;
            this.menuSelect = 0;
            this.oldTime = this.getStateDuration();
            this.setState(9);
            this.pausePage = 0;
        }
    }

    private void updateControls() {
        if (cCanvas.hasKey(256)) {
            this.oldTime = this.getStateDuration();
            this.setState(10);
            crlCanvas.resetKeys();
            return;
        }
        if (cPhysicsManager.canvas.cheat && cCanvas.hasKey(32)) {
            this.setState(4);
        }
        if (this.fallout || this.timeup || this.hitGoal) {
            return;
        }
        if (this.getStateDuration() > 1000) {
            this.updatePlatformControls();
            this.updateFlyControls();
        }
    }

    private void updateFlyControls() {
        if (cCanvas.hasKey(16) && !this.flyTrigger) {
            this.flyTrigger = true;
            if (cBaseManager.collisionType == 0) {
                if (!this.flying && this.getStateDuration() > 1000) {
                    if (this.glideTime > 0) {
                        this.startFlying();
                    } else {
                        this.jumpTime = this.timeStamp;
                    }
                } else {
                    this.flying = false;
                }
            } else if (cBaseManager.collisionType == 1 && this.collisionIndex != -1) {
                this.playerDelta.y = -163840;
                if (this.glideTime > 0) {
                    this.startFlying();
                    cBaseManager.player.y -= 16384;
                } else {
                    this.jumpTime = this.timeStamp;
                }
            }
        } else if (!cCanvas.hasKey(16)) {
            this.flyTrigger = false;
        }
        if (this.flying) {
            if (cCanvas.hasKey(4)) {
                this.flyThrottle -= this.duration;
                if (this.flyThrottle > 0 && this.flyBrakeTimer == 0 || this.flyDir == 1) {
                    this.flyBrakeTimer = this.timeStamp;
                } else if (this.flyThrottle < 0) {
                    this.flyBrakeTimer = 0;
                }
                this.flyDir = -1;
            } else if (cCanvas.hasKey(8)) {
                this.flyThrottle += this.duration;
                if (this.flyThrottle < 0 && this.flyBrakeTimer == 0 || this.flyDir == -1) {
                    this.flyBrakeTimer = this.timeStamp;
                } else if (this.flyThrottle > 0) {
                    this.flyBrakeTimer = 0;
                }
                this.flyDir = 1;
            } else {
                this.flyBrakeTimer = 0;
                if (this.flyThrottle > 0) {
                    this.flyThrottle = this.target(this.flyThrottle, 375, this.duration);
                } else if (this.flyThrottle <= 0) {
                    this.flyThrottle = this.target(this.flyThrottle, -375, this.duration);
                }
            }
            if (cBaseManager.player.x < -40960) {
                this.flying = false;
            }
            this.collisionTimeStamp = this.timeStamp;
        } else if (cBaseManager.collisionType == 0 && this.getStateDuration() > 1000) {
            if (cCanvas.hasKey(4)) {
                this.playerDelta.x -= cFixedPoint.mul(61440, this.scale);
            } else if (cCanvas.hasKey(8)) {
                this.playerDelta.x += cFixedPoint.mul(61440, this.scale);
            }
        }
    }

    private void startFlying() {
        this.flying = true;
        this.flyTriggerTime = this.timeStamp;
        --this.glideTime;
        this.flyDir = this.playerDir;
        this.flySpeed = Math.max(Math.abs(this.playerDelta.x), 0);
        if (this.playerDelta.x > 0) {
            this.flyDir = 1;
            this.flyThrottle = 375;
        } else {
            this.flyDir = -1;
            this.flyThrottle = -375;
        }
        this.platformControlled = false;
    }

    private void updatePlatformControls() {
        if (this.closestIndex != -1 && cBaseManager.objectType[this.closestIndex] == 2 && !cBaseManager.isFlag(cBaseManager.objectField[this.closestIndex][2], 1)) {
            boolean bl = this.platformControlled;
            int n = 0;
            if (cCanvas.hasKey(4) && !this.flying) {
                this.moveDir = -1;
                n = -1;
                if (!this.platformControlled) {
                    this.controlTime = this.timeStamp;
                    this.platformControlled = true;
                    this.turn = 0;
                }
            } else if (cCanvas.hasKey(8) && !this.flying) {
                this.moveDir = 1;
                n = 1;
                if (!this.platformControlled) {
                    this.controlTime = this.timeStamp;
                    this.platformControlled = true;
                    this.turn = 0;
                }
            } else {
                if (this.platformControlled) {
                    this.controlTime = this.timeStamp;
                }
                this.platformControlled = false;
            }
            if (cBaseManager.isFlag(cBaseManager.objectField[this.closestIndex][2], 2)) {
                this.moveDir = -this.moveDir;
            }
            int n2 = this.timeStamp - this.controlTime;
            int n3 = n2 << 12;
            int n4 = cFixedPoint.mul(cFixedPoint.mul(n3, cPhysicsManager.charData[16]), this.scale);
            int n5 = this.maxTurnRate(this.totalLen(this.closestIndex), n4);
            if (cBaseManager.isFlag(cBaseManager.objectField[this.closestIndex][2], 8)) {
                int n6 = 0;
                int n7 = n2;
                n6 = !this.platformControlled ? -cFixedPoint.div(n7, this.platformRampDown >> 2) : cFixedPoint.div(n7, this.platformRampUp >> 2);
                if (this.oldMove != this.moveDir) {
                    this.turn = 0;
                }
                this.turn += n6;
                if (this.turn < 0) {
                    this.turn = 0;
                }
                this.turn = Math.min(this.turn, n5);
                this.angleAcc = this.moveDir * this.turn;
            } else {
                if (n != 0) {
                    this.turn = n5;
                } else {
                    this.platformControlled = false;
                    this.turn = 0;
                }
                this.angleAcc = this.moveDir * this.turn;
            }
            if (this.angleAcc != 0) {
                this.oldTurn = -this.angleAcc;
            }
            if (bl && !this.platformControlled) {
                this.kickActive = true;
            }
        } else if (this.closestIndex != -1 && !cBaseManager.isFlag(cBaseManager.objectField[this.closestIndex][2], 1)) {
            this.platformControlled = false;
        }
        this.oldMove = this.moveDir;
    }

    public final boolean musicAllowed() {
        boolean bl = cPhysicsManager.gameState == 2 || cPhysicsManager.gameState == 0 || cPhysicsManager.gameState == 1 || cPhysicsManager.gameState == 10;
        bl &= !this.hitGoal;
        return bl &= !this.fallout;
    }

    private void updatePauseControls() {
        if (this.updateMenuControls()) {
            if (this.pausePage == 0) {
                switch (this.menuText[this.menuSelect]) {
                    case 11: {
                        this.setState(this.oldState);
                        this.stateTimeStamp = this.timeStamp - this.oldTime;
                        cPhysicsManager.canvas.loadGameAudio();
                        if (this.musicAllowed()) {
                            cPhysicsManager.canvas.playMusic();
                        }
                        crlCanvas.resetKeys();
                        break;
                    }
                    case 40: {
                        this.gameExitMode = 0;
                        this.pausePage = 1;
                        this.menuSelect = 0;
                        break;
                    }
                    case 151: 
                    case 152: {
                        cPhysicsManager.canvas.setAudioMode(!cCanvas.isMusic);
                        break;
                    }
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: {
                        if (++cCanvas.audioVolume < crlAudioManager.VOLUME_LEVEL.length) break;
                        cCanvas.audioVolume = 0;
                        break;
                    }
                    case 16: {
                        this.pausePage = 1;
                        this.gameExitMode = 1;
                        this.menuSelect = 0;
                    }
                }
            } else {
                switch (this.menuText[this.menuSelect]) {
                    case 3: {
                        this.pausePage = 0;
                        break;
                    }
                    case 2: {
                        this.setState(15);
                    }
                }
            }
        }
        crlCanvas.mPadDB = 0;
    }

    private boolean updateMenuControls() {
        if (cCanvas.hasKey(1) && !cCanvas.hasKey(5) && !cCanvas.hasKey(9) && crlCanvas.mPadDB == 1) {
            --this.menuSelect;
            if (this.menuSelect < 0) {
                this.menuSelect = 0;
            }
            cPhysicsManager.canvas.repaintNeeded = true;
        } else if (cCanvas.hasKey(2) && !cCanvas.hasKey(6) && !cCanvas.hasKey(10) && crlCanvas.mPadDB == 1) {
            ++this.menuSelect;
            if (this.menuSelect >= this.menuCount) {
                this.menuSelect = this.menuCount - 1;
            }
            cPhysicsManager.canvas.repaintNeeded = true;
        }
        if ((cCanvas.hasKey(16) || cCanvas.hasKey(256)) && crlCanvas.mPadDB == 1) {
            crlCanvas.mPadDB = 0;
            cPhysicsManager.canvas.repaintNeeded = true;
            return true;
        }
        return false;
    }

    private void updateObjectData() {
        this.updatePlatformData();
        boolean bl = false;
        block6: for (int i = 0; i < cBaseManager.objectType.length; ++i) {
            if (!cBaseManager.objectActive[i]) continue;
            this.moveObjectAlongPath(i);
            int n = cBaseManager.objectType[i];
            switch (n) {
                case 8: {
                    if (!cBaseManager.inBox(cBaseManager.player, cBaseManager.objectLocations[i], cBaseManager.objectField[i][0] << 12, cBaseManager.objectField[i][1] << 12)) continue block6;
                    int n2 = (cBaseManager.objectField[i][3] - 90) * 71;
                    int n3 = cFixedPoint.mul(cBaseManager.objectField[i][2] << 12, this.scale);
                    n3 = !this.flying ? (n3 /= 4) : (n3 *= 2);
                    cBaseManager.tempVect2.x = cFixedPoint.cos(n2);
                    cBaseManager.tempVect2.y = cFixedPoint.sin(n2);
                    if (!this.flying) {
                        this.fanForce = cBaseManager.scale(cBaseManager.tempVect2, n3);
                        cBaseManager.add(this.playerDelta, this.fanForce).copyTo(this.playerDelta);
                        this.fanForce.clear();
                    } else {
                        cBaseManager.add(this.fanForce, cBaseManager.scale(cBaseManager.tempVect2, n3)).copyTo(this.fanForce);
                    }
                    bl = true;
                    continue block6;
                }
                case 15: {
                    int n2;
                    if (!cBaseManager.inRange(cBaseManager.player, cBaseManager.objectLocations[i], 69632)) continue block6;
                    if (cBaseManager.isFlag(cBaseManager.objectField[i][2], 1)) {
                        for (n2 = 0; n2 < cBaseManager.objectType.length; ++n2) {
                            if (n2 == i || cBaseManager.objectType[n2] != 15 || !cBaseManager.isFlag(cBaseManager.objectField[n2][2], 2) || cBaseManager.objectField[n2][4] != cBaseManager.objectField[i][4]) continue;
                            cBaseManager.objectLocations[n2].copyTo(cBaseManager.player);
                            this.playerDelta.clear();
                            this.teleportTimer = this.gameDuration;
                            break;
                        }
                    }
                    if (this.teleportTimer == -1 || this.gameDuration - this.teleportTimer <= 500) continue block6;
                    this.renderer.triggerTeleportParticles(cFixedPoint.toInt(cBaseManager.player.x), cFixedPoint.toInt(cBaseManager.player.y));
                    this.teleportTimer = -1;
                    continue block6;
                }
                case 2: {
                    this.updatePlatform(i);
                    continue block6;
                }
                case 7: {
                    if (!cBaseManager.inBox(cBaseManager.player, cBaseManager.objectLocations[i], cBaseManager.objectField[i][0] << 12, cBaseManager.objectField[i][1] << 12)) continue block6;
                    this.doFallout();
                }
            }
        }
        if (!bl) {
            this.fanForce.clear();
        }
    }

    private void updatePlatform(int n) {
        if (!cBaseManager.isFlag(cBaseManager.objectField[n][2], 8) && cBaseManager.isFlag(cBaseManager.objectField[n][2], 4) && (n != this.closestIndex || n == this.closestIndex && !this.platformControlled)) {
            int n2 = this.baseDiff(n);
            this.platformAngles[n] = Math.abs(n2) < 10 ? cBaseManager.objectField[n][0] * 71 : this.platformAngles[n] + this.resetRate(n2, n);
            if (n2 != 0) {
                this.updatePlatformInfo(n);
            }
        }
        if (cBaseManager.isFlag(cBaseManager.objectField[n][2], 1) && n == this.collisionIndex) {
            cBaseManager.Vector2d vector2d = cBaseManager.sub(this.collision, cBaseManager.objectLocations[n]);
            int n3 = this.totalLen(n);
            int n4 = this.maxTurnRate(n3, cFixedPoint.div(cPhysicsManager.charData[16], this.scale));
            int n5 = cBaseManager.mag(vector2d);
            int n6 = cFixedPoint.mul(cFixedPoint.div(n5, n3 <<= 12), n4) / 2;
            if (n6 > n4) {
                n6 = n4;
            }
            int n7 = 1;
            if (vector2d.x < 0) {
                n7 = -1;
            }
            this.angleAcc = n6 *= n7;
        }
    }

    private void updateChained(int n) {
        int n2;
        int n3 = cBaseManager.objectField[n][2] >> 8;
        for (n2 = 0; n2 < cBaseManager.objectField.length; ++n2) {
            if (cBaseManager.objectType[n2] != 2 || cBaseManager.objectField[n2][2] >> 8 != n3 || n2 >= n) continue;
            n = n2;
        }
        if (this.switchesActive(n3)) {
            this.processPlatformRotation(n);
            n2 = this.baseDiff(n);
            for (int i = 0; i < cBaseManager.objectField.length; ++i) {
                if (i == n || cBaseManager.objectType[i] != 2 || cBaseManager.objectField[i][2] >> 8 != n3) continue;
                int n4 = cBaseManager.objectField[i][0] * 71 - n2;
                this.setLineAngle(i, n4);
            }
        }
    }

    private void doFallout() {
        this.setState(3);
        this.renderer.triggerMessage(49);
        if (!this.fallout) {
            cPhysicsManager.canvas.vibrate(1000);
            cPhysicsManager.canvas.playJingle(1);
        }
        this.fallout = true;
    }

    private void updatePlatformData() {
        if (this.closestIndex != -1 && cBaseManager.objectType[this.closestIndex] == 2 && this.angleAcc != 0) {
            if (cBaseManager.isFlag(cBaseManager.objectField[this.closestIndex][2], 8)) {
                this.updateChained(this.closestIndex);
            } else {
                this.processPlatformRotation(this.closestIndex);
            }
        }
    }

    private void processPlatformRotation(int n) {
        int n2 = cFixedPoint.mul(this.angleAcc, this.scale);
        if (n2 != 0) {
            this.platformAngles[n] = this.platformAngles[n] + n2;
            int n3 = this.baseDiff(n);
            int n4 = cBaseManager.objectField[n][3] * 71 / 2;
            int n5 = cBaseManager.objectField[n][0] * 71;
            if (n3 > n4) {
                this.platformAngles[n] = n5 - n4;
            } else if (n3 < -n4) {
                this.platformAngles[n] = n5 + n4;
            }
            this.updatePlatformInfo(n);
        }
    }

    public void setGameType(int n) {
        this.gameType = n;
    }

    static {
        LEVEL_ENDINGS = new int[][]{{11, 15}, {26, 30}, {41, 45}};
    }
}

