/*
 * Decompiled with CFR 0.152.
 */
package Coral.Math.FP;

public abstract class crlFP64 {
    private static int _fbits = 24;
    private static int _digits = 8;
    private static long _one;
    private static long _fmask;
    private static long _dmul;
    private static long _flt;
    private static long _pi;
    private static long[] e;
    public static long PI;
    public static long E;
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final long MIN_VALUE = -9223372036854775807L;

    public static int setPrecision(int n) {
        if (n > 24 || n < 0) {
            return _digits;
        }
        _fbits = n;
        _one = 1L << n;
        _flt = 24 - n;
        _digits = 0;
        _dmul = 1L;
        _fmask = _one - 1L;
        PI = _pi >> (int)_flt;
        E = e[1] >> (int)_flt;
        long l = _one;
        while (l != 0L) {
            l /= 10L;
            ++_digits;
            _dmul *= 10L;
        }
        return _digits;
    }

    public static int getPrecision() {
        return _fbits;
    }

    public static long toLong(long l) {
        l = crlFP64.round(l, 0);
        return l >> _fbits;
    }

    public static long toFP(long l) {
        return l << _fbits;
    }

    public static long convert(long l, int n) {
        long l2;
        long l3 = l2 = l >= 0L ? 1L : -1L;
        if (crlFP64.abs(n) < 25L) {
            l = _fbits < n ? l + l2 * (1L << (n - _fbits >> 1)) >> n - _fbits : (l <<= _fbits - n);
        }
        return l;
    }

    public static long toFP(String string) {
        int n = 0;
        if (string.charAt(0) == '-') {
            n = 1;
        }
        String string2 = "-1";
        int n2 = string.indexOf(46);
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1, string.length());
            while (string2.length() < _digits) {
                if (string2.length() > _digits) {
                    string2 = string2.substring(0, _digits);
                }
                string2 = string2 + "0";
            }
        } else {
            n2 = string.length();
        }
        long l = 0L;
        if (n != n2) {
            l = Long.parseLong(string.substring(n, n2));
        }
        long l2 = Long.parseLong(string2) + 1L;
        long l3 = (l << _fbits) + (l2 << _fbits) / _dmul;
        if (n == 1) {
            l3 = -l3;
        }
        return l3;
    }

    public static String toString(long l) {
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        long l2 = l >> _fbits;
        long l3 = _dmul * (l & _fmask) >> _fbits;
        String string = Long.toString(l3);
        while (string.length() < _digits) {
            string = "0" + string;
        }
        return (bl ? "-" : "") + Long.toString(l2) + "." + string;
    }

    public static String toString(long l, int n) {
        if (n > _digits) {
            n = _digits;
        }
        String string = crlFP64.toString(crlFP64.round(l, n));
        return string.substring(0, string.length() - _digits + n);
    }

    public static long max(long l, long l2) {
        return l >= l2 ? l : l2;
    }

    public static long min(long l, long l2) {
        return l2 >= l ? l : l2;
    }

    public static long round(long l, int n) {
        long l2 = 10L;
        for (int i = 0; i < n; ++i) {
            l2 *= 10L;
        }
        l2 = crlFP64.div(crlFP64.toFP(5L), crlFP64.toFP(l2));
        if (l < 0L) {
            l2 = -l2;
        }
        return l + l2;
    }

    public static long mul(long l, long l2) {
        boolean bl = false;
        int n = _fbits;
        long l3 = _fmask;
        if ((l & l3) == 0L) {
            return (l >> n) * l2;
        }
        if ((l2 & l3) == 0L) {
            return l * (l2 >> n);
        }
        if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
            bl = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while (crlFP64.max(l, l2) >= 1L << 63 - n) {
            l >>= 1;
            l2 >>= 1;
            l3 >>= 1;
            --n;
        }
        long l4 = (l >> n) * (l2 >> n) << n;
        long l5 = (l & l3) * (l2 & l3) >> n;
        if ((l4 = l4 + (l5 += (l & (l3 ^ 0xFFFFFFFFFFFFFFFFL)) * (l2 & l3) >> n) + ((l & l3) * (l2 & (l3 ^ 0xFFFFFFFFFFFFFFFFL)) >> n) << _fbits - n) < 0L) {
            throw new ArithmeticException("Overflow");
        }
        return bl ? -l4 : l4;
    }

    public static long div(long l, long l2) {
        boolean bl = false;
        int n = _fbits;
        if (l2 == _one) {
            return l;
        }
        if ((l2 & _fmask) == 0L) {
            return l / (l2 >> n);
        }
        if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
            bl = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while (crlFP64.max(l, l2) >= 1L << 63 - n) {
            l >>= 1;
            l2 >>= 1;
            --n;
        }
        long l3 = (l << n) / l2 << _fbits - n;
        return bl ? -l3 : l3;
    }

    public static long add(long l, long l2) {
        return l + l2;
    }

    public static long sub(long l, long l2) {
        return l - l2;
    }

    public static long abs(long l) {
        if (l < 0L) {
            return -l;
        }
        return l;
    }

    public static long sqrt(long l, int n) {
        if (l < 0L) {
            throw new ArithmeticException("Bad Input ");
        }
        if (l == 0L) {
            return 0L;
        }
        long l2 = l + _one >> 1;
        for (int i = 0; i < n; ++i) {
            l2 = l2 + crlFP64.div(l, l2) >> 1;
        }
        if (l2 < 0L) {
            throw new ArithmeticException("Overflow");
        }
        return l2;
    }

    public static long sqrt(long l) {
        return crlFP64.sqrt(l, 24);
    }

    public static long sin(long l) {
        long l2 = crlFP64.mul(l, crlFP64.div(crlFP64.toFP(180L), PI));
        if ((l2 %= crlFP64.toFP(360L)) < 0L) {
            l2 = crlFP64.toFP(360L) + l2;
        }
        long l3 = l2;
        if (l2 >= crlFP64.toFP(90L) && l2 < crlFP64.toFP(270L)) {
            l3 = crlFP64.toFP(180L) - l2;
        } else if (l2 >= crlFP64.toFP(270L) && l2 < crlFP64.toFP(360L)) {
            l3 = -(crlFP64.toFP(360L) - l2);
        }
        long l4 = l3 / 90L;
        long l5 = crlFP64.mul(l4, l4);
        long l6 = crlFP64.mul(crlFP64.mul(crlFP64.mul(crlFP64.mul(-73190L >> (int)_flt, l5) + (1333581L >> (int)_flt), l5) - (10836755L >> (int)_flt), l5) + (long)(26353564 >> (int)_flt), l4);
        return l6;
    }

    public static long asin(long l) {
        if (crlFP64.abs(l) > _one) {
            throw new ArithmeticException("Bad Input");
        }
        boolean bl = l < 0L;
        l = crlFP64.abs(l);
        long l2 = crlFP64.mul(crlFP64.mul(crlFP64.mul(crlFP64.mul(145103 >> (int)_flt, l) - (long)(599880 >> (int)_flt), l) + (long)(1420468 >> (int)_flt), l) - (long)(3592413 >> (int)_flt), l) + (long)(26353447 >> (int)_flt);
        long l3 = PI / 2L - crlFP64.mul(crlFP64.sqrt(_one - l), l2);
        return bl ? -l3 : l3;
    }

    public static long cos(long l) {
        return crlFP64.sin(PI / 2L - l);
    }

    public static long acos(long l) {
        return PI / 2L - crlFP64.asin(l);
    }

    public static long tan(long l) {
        return crlFP64.div(crlFP64.sin(l), crlFP64.cos(l));
    }

    public static long cot(long l) {
        return crlFP64.div(crlFP64.cos(l), crlFP64.sin(l));
    }

    public static long atan(long l) {
        return crlFP64.asin(crlFP64.div(l, crlFP64.sqrt(_one + crlFP64.mul(l, l))));
    }

    public static long exp(long l) {
        if (l == 0L) {
            return _one;
        }
        boolean bl = l < 0L;
        l = crlFP64.abs(l);
        int n = (int)(l >> _fbits);
        long l2 = _one;
        for (int i = 0; i < n / 4; ++i) {
            l2 = crlFP64.mul(l2, e[4] >> (int)_flt);
        }
        if (n % 4 > 0) {
            l2 = crlFP64.mul(l2, e[n % 4] >> (int)_flt);
        }
        if ((l &= _fmask) > 0L) {
            long l3 = _one;
            long l4 = 0L;
            long l5 = 1L;
            for (int i = 0; i < 16; ++i) {
                l4 += l3 / l5;
                if ((l5 *= (long)(i + 1)) > (l3 = crlFP64.mul(l3, l)) || l3 <= 0L || l5 <= 0L) break;
            }
            l2 = crlFP64.mul(l2, l4);
        }
        if (bl) {
            l2 = crlFP64.div(_one, l2);
        }
        return l2;
    }

    public static long log(long l) {
        long l2;
        if (l <= 0L) {
            throw new ArithmeticException("Bad Input");
        }
        long l3 = 0L;
        int n = 0;
        while (l >= _one << 1) {
            l >>= 1;
            ++n;
        }
        long l4 = (long)n * (long)(11629080 >> (int)_flt);
        long l5 = 0L;
        if (l < _one) {
            return -crlFP64.log(crlFP64.div(_one, l));
        }
        l -= _one;
        for (int i = 1; i < 20 && (l2 = l3 == 0L ? l : crlFP64.mul(l3, l)) != 0L; ++i) {
            l5 += (i % 2 != 0 ? 1L : -1L) * l2 / (long)i;
            l3 = l2;
        }
        return l4 + l5;
    }

    public static long pow(long l, long l2) {
        boolean bl = l2 < 0L;
        long l3 = _one;
        l2 = crlFP64.abs(l2);
        int n = (int)l2 >> _fbits;
        while (n-- > 0) {
            l3 = crlFP64.mul(l3, l);
        }
        if (l3 < 0L) {
            throw new ArithmeticException("Overflow");
        }
        l3 = l != 0L ? crlFP64.mul(l3, crlFP64.exp(crlFP64.mul(crlFP64.log(l), l2 & _fmask))) : 0L;
        if (bl) {
            return crlFP64.div(_one, l3);
        }
        return l3;
    }

    public static long atan2(long l, long l2) {
        long l3 = 0L;
        if (l2 > 0L) {
            l3 = crlFP64.atan(crlFP64.div(l, l2));
        } else if (l2 < 0L) {
            l3 = (l2 >= 0L ? PI : -PI) - crlFP64.atan(crlFP64.abs(crlFP64.div(l, l2)));
        } else {
            if (l2 == 0L && l == 0L) {
                throw new ArithmeticException("Bad Input");
            }
            l3 = (l >= 0L ? PI : -PI) / 2L;
        }
        return l3;
    }

    static {
        _fmask = 0xFFFFFFL;
        _dmul = 100000000L;
        _flt = 0L;
        _one = 0x1000000L;
        _pi = 52707178L;
        e = new long[]{_one, 45605201L, 123967790L, 336979391L, 916004956L};
        PI = _pi;
        E = e[1];
    }
}

