/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import Coral.Util.crlUtil;
import Coral.crlCanvas;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import monkey.cBaseManager;
import monkey.cCanvas;
import monkey.cFixedPoint;
import monkey.cGameRenderer;

public class cPhysicsManager
extends cBaseManager {
    static final int MBOOSTER_MAX_INSTANCES = 1;
    public static final int CHARACTER_AIAI = 0;
    public static final int CHARACTER_MEEMEE = 1;
    public static final int CHARACTER_BABY = 2;
    public static final int CHARACTER_GONGON = 3;
    public static final int CH_MASS = 0;
    public static final int CH_SURFACE_FRICTION = 1;
    public static final int CH_AIR_VISCOSITY = 2;
    public static final int CH_FLYING_LIFT = 3;
    public static final int CH_FLYING_THRUST = 4;
    public static final int CH_GRAVITY = 5;
    public static final int CH_SLIDE_SCALE = 6;
    public static final int CH_GLIDE_TURN = 7;
    public static final int CH_BOUNCE_EFFICIENCY = 8;
    public static final int CH_BOUNCE_ANGLE = 9;
    public static final int CH_BOUNCE_THRESHOLD = 10;
    public static final int CH_KICK_FORCE = 11;
    public static final int CH_HARD_KICK_FORCE = 12;
    public static final int CH_KICK_THRESHOLD = 13;
    public static final int CH_PLATFORM_KICK_LIMIT = 14;
    protected static final int CH_PLATFORM_KICK_HARD_TIME = 15;
    public static final int CH_PLATFORM_TURN_RATE = 16;
    public static final int CH_PLATFORM_RESET_RATE = 17;
    public static final int CH_PLATFORM_RAMP_UP = 18;
    public static final int CH_PLATFORM_RAMP_DOWN = 19;
    public static final int CH_GLIDE_BURN_RATE = 20;
    public static final int CH_GLIDE_CHUNK_TIME = 21;
    public static final int CH_GLIDE_CHUNKS = 22;
    public static final int CH_FIELDS = 23;
    public static final int CH_CHARACTER_COUNT = 1;
    public static final int FLY_LIMITS = 819;
    public static final int FLY_INCREMENT = 409;
    private static final int CONVEYOR_GRIP = 10;
    public int character = 0;
    public static final int LEVEL_TUTORIAL = 2;
    public static final int LEVEL_TIME_LIMIT = 1;
    public static final int LEVEL_TYPE = 0;
    public static final int FIRE_BALL = 10;
    public static final int BUMPER = 6;
    public static final int BANANNA_BUNCH = 4;
    public static final int BANNANA = 3;
    public static final int BASIC_PLATFORM = 2;
    public static final int TRAMPOLINE = 19;
    public static final int CONVEYOR_BELT = 18;
    public static final int GOAL = 16;
    public static final int SWITCH = 12;
    public static final int SPIKES = 11;
    public static final int WALL = 20;
    public static final int FAN = 8;
    public static final int LEVEL_BOUNDARY = 7;
    public static final int PATH_NODE = 5;
    public static final int PLAYER_START = 1;
    public static final int TELEPORT = 15;
    public static final int ANNOTATION = 21;
    public static final int GOAL_GREEN = 0;
    public static final int GOAL_ORANGE = 1;
    public static final int GOAL_RED = 3;
    public static final int GOAL_SCORE_GREEN = 1000;
    public static final int GOAL_SCORE_ORANGE = 2000;
    public static final int GOAL_SCORE_RED = 5000;
    public static final int SWITCH_ORENTATION_UP = 0;
    public static final int SWITCH_ORENTATION_DOWN = 1;
    public static final int SWITCH_ORENTATION_LEFT = 2;
    public static final int SWITCH_ORENTATION_RIGHT = 3;
    public static final int SWITCH_PRESSED = 0;
    public static final int SWITCH_ORENTATION = 1;
    public static final short SWITCH_TYPE_AND = 0;
    public static final short SWITCH_TYPE_OR = 1;
    public static final short SWITCH_TYPE_XOR = 2;
    public static final int CONVEYOR_BELT_FORCE = 0;
    public static final int GOAL_MEDIUM_LEFT_WIDTH = 1;
    public static final int GOAL_CENTER_WIDTH = 2;
    public static final int GOAL_MEDIUM_RIGHT_WIDTH = 3;
    public static final int GOAL_EDGE_RIGHT_WIDTH = 4;
    public static final int GOAL_EDGE_LEFT_WIDTH = 0;
    public static final int BUMPER_RADIUS = 0;
    public static final int BUMPER_FORCE = 1;
    public static final int TRAMPOLINE_FORCE = 0;
    public static final int BASIC_PLATFORM_ANGLE = 0;
    public static final int BASIC_PLATFORM_LENGTH = 1;
    public static final int BASIC_PLATFORM_FLAGS = 2;
    public static final int BASIC_PLATFORM_ANGLE_LIMIT = 3;
    public static final int BASIC_PLATFORM_SEGMENTS = 4;
    public static final int TELEPORT_ENTER = 1;
    public static final int TELEPORT_EXIT = 2;
    public static final int FIRE_BALL_RADIUS = 0;
    public static final int FIRE_BALL_FORCE = 1;
    public static final int FIRE_BALL_GROUP = 2;
    public static final int FIRE_BALL_DELAY = 3;
    public static final int FAN_WIDTH = 0;
    public static final int FAN_HEIGHT = 1;
    public static final int FAN_FORCE = 2;
    public static final int FAN_ANGLE = 3;
    public static final int FAN_BLASTLEN = 4;
    public static final int CONVEYOR_BELT_WIDTH = 1;
    public static final int CONVEYOR_BELT_GROUP = 4;
    public static final int TELEPORT_WIDTH = 0;
    public static final int TELEPORT_HEIGHT = 1;
    public static final int TELEPORT_ACCESS = 2;
    public static final int TELEPORT_TYPE = 3;
    public static final int TELEPORT_GROUP = 4;
    public static final int SWITCH_GROUP = 2;
    public static final int SWITCH_TYPE = 3;
    public static final int SPIKES_HEIGHT = 0;
    public static final int SPIKES_FORCE = 1;
    public static final int LEVEL_BOUNDARY_WIDTH = 0;
    public static final int LEVEL_BOUNDARY_HEIGHT = 1;
    public static final int ANNOTATION_WIDTH = 0;
    public static final int ANNOTATION_HEIGHT = 1;
    public static final int ANNOTATION_INDEX = 2;
    public static final int TRAMPOLINE_WIDTH = 1;
    public static final int LIFE_COUNTER = 100;
    private static final int BANNANA_MULTIPLIER = 100;
    public static final int FIX_MARGIN = 1024;
    public static final int F_GLIDE_CLAMP = 696320;
    public static final int FLY_CONTROL = 1500;
    public static final int FLY_MINSPEED = 0;
    public static final int FLY_INITTHRUST = -122880;
    public static final int FLY_GRAV_LOWER = 1024;
    public static final int FLY_GRAV_UPPER = 12288;
    public static final int FLY_GRAV_FLOAT = -20480;
    public static final int THROTTLE_NEUTRAL = 375;
    public static final int FLY_SPEED_SCALE = 266240;
    public static final int FLY_FRICTION_SCALE = 2;
    public static final int FLY_JUMP_FORCE = -163840;
    public static final int FLY_CURVEBALL_THRUST = 61440;
    public static final int FLY_THRUST_START = 250;
    public static final int FLY_THRUST_END = 500;
    public static final int FLY_GRAV_BRAKE_CLAMP = -163840;
    public static final int FLY_GRAV_BRAKE_RAMP = 400;
    public static final int KICK_DISTANCE = 409600;
    public static final int KICK_DISTANCE_UPPER = 1024;
    public static final int KICK_DISTANCE_LOWER = 163;
    public static final int KICK_ANGLE_LOWER = 204;
    public static final int KICK_ANGLE_UPPER = 4096;
    public static final int KICK_FORCE_LIMIT = 409600;
    public static final int KICK_SCALE = 614400;
    public static final int KICK_X_SCALE = 4096;
    public static final int KICK_Y_SCALE = 4096;
    public static final int PLATFORM_INFO_SEESAW = 1;
    public static final int PLATFORM_INFO_REVERSED = 2;
    public static final int PLATFORM_INFO_ELASTIC = 4;
    public static final int PLATFORM_INFO_CHAINED = 8;
    public static final int PLATFORM_INFO_MOVING = 16;
    public static final int PLATFORM_INFO_STICKY = 32;
    public static final int PLATFORM_INFO_COLLAPSE = 64;
    public static final int PLATFORM_INFO_SWING = 128;
    public static final int STATE_LEADIN = 0;
    public static final int STATE_PAN = 1;
    public static final int STATE_INPLAY = 2;
    public static final int STATE_END_FAIL = 3;
    public static final int STATE_END_GOAL = 4;
    public static final int STATE_END_LEADOUT = 5;
    public static final int STATE_GOAL_SUMMARY = 6;
    public static final int STATE_EXIT = 7;
    public static final int STATE_RESTART_LEADIN = 8;
    public static final int STATE_PAUSED = 9;
    public static final int STATE_PAN_GAME = 10;
    public static final int STATE_UNLOCKED = 11;
    public static final int STATE_STATISTICS = 12;
    public static final int STATE_FLYUP = 13;
    public static final int STATE_CONTINUE = 14;
    public static final int STATE_GAMEOVER = 15;
    public static final int STATE_END_HITGOAL = 16;
    public static int score;
    public static int gameState;
    public static int[][] levelData;
    public static int[] charData;
    public static cCanvas canvas;
    protected int oldPad;
    protected int pad;
    protected int realVelocity;
    protected int playerX;
    protected int playerY;
    protected int cameraX;
    protected int cameraY;
    protected int[] pathIndices;
    protected int[] targetNodes;
    public boolean flying;
    public boolean hitGoal;
    public int bannaCount;
    public int bannanaTotal;
    public int levelBannaCount;
    public int glideTime;
    public int gameDuration;
    public boolean fallout;
    public boolean timeup;
    public int goalAccuracy;
    public int lifeCount;
    public int timeLeft;
    protected int playerDx;
    public int timeStamp;
    protected int duration;
    public cGameRenderer renderer;
    protected int[] platformAngles;
    protected int angleAcc;
    protected boolean platformControlled;
    protected int flyDir;
    private int flyPeriod;
    public int flyLift = 4096;
    public int flyThrust = 0;
    protected int playerDy;
    protected int stateTimeStamp;
    protected int newLifeCounter = 100;
    protected int segment;
    protected int oldCollision = -1;
    protected int lastCollision = -1;
    protected int scale;
    public int collisionTimeStamp;
    protected int levelId;
    public int bannanaRequirements;
    protected int banBonusMultiplier;
    protected int timeBonusMultiplier;
    protected int banScoreBonus;
    protected int timeScoreBonus;
    public int goalScoreBonus;
    protected int totalBonus;
    protected int playerBallAngle;
    private int[] segmentCollsionList = new int[10];
    private int[] segDist = new int[10];
    private int segPointer = 0;
    protected boolean hardKick;
    protected boolean kickActive;
    protected boolean bounced;
    public static int levelType;
    public int glideBurnRate;
    public int glideChunkTime;
    public int glideMaxChunks;
    public int glideChunkUnits;
    public int glideTimeLimit;
    public int platformRampUp;
    public int platformRampDown;
    public int moveDir = 0;
    public int controlTime;
    int flyThrottle;
    int flySpeed;
    int flyTriggerTime;
    int oldTurn;
    cBaseManager.Vector2d fanForce;
    protected int flyBrakeTimer;
    int teleportTimer = -1;
    public int scaleDuration;
    protected int turn;
    int targetTime;
    public static final int TARGET_TIMEOUT = 1500;
    cBaseManager.Vector2d slideI = new cBaseManager.Vector2d();
    cBaseManager.Vector2d lastFixLoc = new cBaseManager.Vector2d();

    public int getCameraX() {
        return this.cameraX;
    }

    public int getCameraY() {
        return this.cameraY;
    }

    public int getRealSpeed() {
        int n = cFixedPoint.toInt(this.realVelocity);
        if (n < 10 && n != 0) {
            n = 1;
        }
        if (this.hitGoal) {
            n = 0;
        }
        return n;
    }

    protected void setState(int n) {
        gameState = n;
        this.stateTimeStamp = this.timeStamp;
        cPhysicsManager.canvas.repaintNeeded = true;
    }

    protected int segCount(int n) {
        int n2 = 1;
        int n3 = cBaseManager.objectField[n][4];
        while (n3 != 0) {
            n3 >>= 16;
            ++n2;
        }
        return n2;
    }

    protected int totalLen(int n) {
        int n2 = this.segCount(n);
        int n3 = this.segLen(n, 0);
        if (n2 > 1) {
            n3 += this.segLen(n, 1);
        }
        if (n2 > 2) {
            n3 += this.segLen(n, 2);
        }
        return n3;
    }

    public int segLen(int n, int n2) {
        if (n2 == 0) {
            return cBaseManager.objectField[n][1];
        }
        if (n2 == 1) {
            return cBaseManager.objectField[n][4] >> 8 & 0xFF;
        }
        return cBaseManager.objectField[n][4] >> 24 & 0xFF;
    }

    private int associatedPath(int n) {
        for (int i = 0; i < this.pathIndices.length; ++i) {
            if (this.pathIndices[i] != n) continue;
            return i;
        }
        return -1;
    }

    protected void setLineAngle(int n, int n2) {
        int n3 = cBaseManager.getSegmentStart(n);
        if (n3 == -1) {
            return;
        }
        this.setPlatformLineAngle(n, n3, n2);
    }

    protected void setPlatformLineAngle(int n, int n2, int n3) {
        int n4 = this.segCount(n);
        cBaseManager.Vector2d vector2d = cBaseManager.objectLocations[n];
        int n5 = cBaseManager.objectField[n][1];
        if (n4 == 1) {
            cPhysicsManager.build1SegmentPlatform(n, n2, n3, vector2d, n5);
        } else {
            int n6 = (cBaseManager.objectField[n][4] & 0xFF) * 71;
            int n7 = cBaseManager.objectField[n][4] >> 8 & 0xFF;
            if (n4 == 2) {
                cPhysicsManager.build2SegmentPlatform(n, n2, n3, vector2d, n5, n6, n7);
            } else if (n4 == 3) {
                int n8 = (cBaseManager.objectField[n][4] >> 16 & 0xFF) * 71;
                int n9 = cBaseManager.objectField[n][4] >> 24 & 0xFF;
                cPhysicsManager.build3SegmentPlatform(n, n2, n3, vector2d, n5, n6, n7, n8, n9);
            }
        }
    }

    private static final void build3SegmentPlatform(int n, int n2, int n3, cBaseManager.Vector2d vector2d, int n4, int n5, int n6, int n7, int n8) {
        cBaseManager.Vector2d vector2d2;
        cBaseManager.Vector2d vector2d3;
        cBaseManager.Vector2d vector2d4;
        cBaseManager.Vector2d vector2d5 = cBaseManager.line[n2];
        if (vector2d5 == null) {
            vector2d5 = new cBaseManager.Vector2d();
        }
        if ((vector2d4 = cBaseManager.line[n2 + 1]) == null) {
            vector2d4 = new cBaseManager.Vector2d();
        }
        if ((vector2d3 = cBaseManager.line[n2 + 2]) == null) {
            vector2d3 = new cBaseManager.Vector2d();
        }
        if ((vector2d2 = cBaseManager.line[n2 + 3]) == null) {
            vector2d2 = new cBaseManager.Vector2d();
        }
        int n9 = cFixedPoint.cos(n3);
        int n10 = cFixedPoint.sin(n3);
        vector2d4.x = n9 * -n4 + vector2d.x;
        vector2d4.y = n10 * -n4 + vector2d.y;
        vector2d3.x = n9 * n4 + vector2d.x;
        vector2d3.y = n10 * n4 + vector2d.y;
        vector2d5.x = cFixedPoint.sin(n5 - n3) * -n6 + vector2d4.x;
        vector2d5.y = cFixedPoint.cos(n5 - n3) * -n6 + vector2d4.y;
        vector2d2.x = cFixedPoint.sin(12868 - n7 - n3) * n8 + vector2d3.x;
        vector2d2.y = cFixedPoint.cos(12868 - n7 - n3) * n8 + vector2d3.y;
        cBaseManager.setLineSegment(n2, vector2d5, n);
        cBaseManager.setLineSegment(n2 + 1, vector2d4, n);
        cBaseManager.setLineSegment(n2 + 2, vector2d3, n);
        cBaseManager.setLineSegment(n2 + 3, vector2d2, n);
    }

    private static final void build2SegmentPlatform(int n, int n2, int n3, cBaseManager.Vector2d vector2d, int n4, int n5, int n6) {
        cBaseManager.Vector2d vector2d2;
        cBaseManager.Vector2d vector2d3;
        cBaseManager.Vector2d vector2d4 = cBaseManager.line[n2];
        if (vector2d4 == null) {
            vector2d4 = new cBaseManager.Vector2d();
        }
        if ((vector2d3 = cBaseManager.line[n2 + 1]) == null) {
            vector2d3 = new cBaseManager.Vector2d();
        }
        if ((vector2d2 = cBaseManager.line[n2 + 2]) == null) {
            vector2d2 = new cBaseManager.Vector2d();
        }
        int n7 = n5 - n3;
        vector2d4.x = cFixedPoint.sin(n7) * -n4 + vector2d.x;
        vector2d4.y = cFixedPoint.cos(n7) * -n4 + vector2d.y;
        vector2d3.x = vector2d.x;
        vector2d3.y = vector2d.y;
        int n8 = 12868 - n5 - n3;
        vector2d2.x = cFixedPoint.sin(n8) * n6 + vector2d.x;
        vector2d2.y = cFixedPoint.cos(n8) * n6 + vector2d.y;
        cBaseManager.setLineSegment(n2, vector2d4, n);
        cBaseManager.setLineSegment(n2 + 1, vector2d3, n);
        cBaseManager.setLineSegment(n2 + 2, vector2d2, n);
    }

    private static final void build1SegmentPlatform(int n, int n2, int n3, cBaseManager.Vector2d vector2d, int n4) {
        cBaseManager.Vector2d vector2d2;
        cBaseManager.Vector2d vector2d3 = cBaseManager.line[n2];
        if (vector2d3 == null) {
            vector2d3 = new cBaseManager.Vector2d();
        }
        if ((vector2d2 = cBaseManager.line[n2 + 1]) == null) {
            vector2d2 = new cBaseManager.Vector2d();
        }
        int n5 = cFixedPoint.cos(n3);
        int n6 = cFixedPoint.sin(n3);
        vector2d3.x = n5 * -n4 + vector2d.x;
        vector2d3.y = n6 * -n4 + vector2d.y;
        vector2d2.x = n5 * n4 + vector2d.x;
        vector2d2.y = n6 * n4 + vector2d.y;
        cBaseManager.setLineSegment(n2, vector2d3, n);
        cBaseManager.setLineSegment(n2 + 1, vector2d2, n);
    }

    protected void processPlayerCollision() {
        this.segPointer = 0;
        int n = Integer.MAX_VALUE;
        this.oldCollision = this.collisionIndex;
        if (this.collisionIndex != -1) {
            this.lastCollision = this.oldCollision;
        }
        cBaseManager.oldCollisionType = cBaseManager.collisionType;
        this.collisionIndex = -1;
        int n2 = this.closestIndex;
        this.closestIndex = -1;
        cBaseManager.collisionType = 0;
        if (cBaseManager.player.y < 0) {
            return;
        }
        block4: for (int i = 0; i < cBaseManager.objectType.length; ++i) {
            if (!cBaseManager.objectActive[i]) continue;
            int n3 = cBaseManager.objectType[i];
            switch (n3) {
                case 2: 
                case 12: 
                case 16: 
                case 18: 
                case 19: 
                case 20: {
                    if (gameState == 13) continue block4;
                    n = this.processPlayerLineCollision(n, i, n3);
                    continue block4;
                }
                case 6: 
                case 11: {
                    if (gameState == 13) continue block4;
                    n = this.processPlayerCircleCollision(n, i);
                    continue block4;
                }
                default: {
                    this.processPlayerNonCollision(i);
                }
            }
        }
        if (n2 != this.closestIndex) {
            this.controlTime = this.timeStamp;
            this.angleAcc = 0;
            this.kick.clear();
            this.slide.clear();
        }
        this.doCollision();
    }

    private void processPlayerNonCollision(int n) {
        switch (cBaseManager.objectType[n]) {
            case 3: 
            case 4: {
                if (gameState == 3) {
                    return;
                }
                if (!cBaseManager.inRange(cBaseManager.objectLocations[n], cBaseManager.player, 139264)) break;
                int n2 = 1;
                if (cBaseManager.objectType[n] == 4) {
                    n2 = 10;
                    canvas.vibrate(300);
                }
                this.bannaCount += n2;
                this.bannanaTotal += n2;
                this.glideTime += n2;
                if (this.glideTime > this.glideTimeLimit) {
                    this.glideTime = this.glideTimeLimit;
                }
                int n3 = cFixedPoint.toInt(cBaseManager.objectLocations[n].x);
                int n4 = cFixedPoint.toInt(cBaseManager.objectLocations[n].y);
                this.renderer.triggerCollectStars(n3, n4);
                if (this.bannaCount >= 100) {
                    ++this.lifeCount;
                    this.renderer.triggerMessage(121);
                    canvas.playSfx(3);
                    this.bannaCount %= 100;
                }
                score += 100 * n2;
                cBaseManager.objectActive[n] = false;
            }
        }
    }

    private int processPlayerCircleCollision(int n, int n2) {
        int n3 = cBaseManager.objectField[n2][0];
        int n4 = (n3 << 12) + 69632;
        if (cBaseManager.inRange(cBaseManager.objectLocations[n2], cBaseManager.player, n4)) {
            this.collisionIndex = n2;
            n = n4;
            cBaseManager.collisionType = 2;
        }
        return n;
    }

    private int processPlayerLineCollision(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        boolean bl = true;
        if (n3 == 2) {
            n5 = (this.totalLen(n2) << 12) + 278528;
            bl = cBaseManager.inRange(cBaseManager.objectLocations[n2], cBaseManager.player, n5);
            if (bl && cBaseManager.isFlag(cBaseManager.objectField[n2][2], 64) && cBaseManager.collisionTimer[n2] != 0 && this.gameDuration - cBaseManager.collisionTimer[n2] > 1000) {
                bl = false;
            }
        } else if (n3 == 16 || n3 == 18) {
            n6 = cBaseManager.getSegmentStart(n2);
            n5 = cBaseManager.line[n6].x;
            n4 = cBaseManager.line[n6 + 1].x;
            int n7 = cBaseManager.line[n6].y;
            boolean bl2 = bl = cBaseManager.player.x < n4 + 139264 && cBaseManager.player.x > n5 - 139264 && cBaseManager.player.y < n7 + 139264 && cBaseManager.player.y > n7 - 139264;
        }
        if (bl) {
            if (n3 == 16) {
                n = this.testSegmentCollision(n, n2, n6);
            } else if (n3 == 20) {
                n6 = cBaseManager.getSegmentStart(n2);
                n5 = this.getTargetNode(n2);
                if (n5 != -1) {
                    n = this.testSegmentCollision(n, n2, n6);
                }
            } else {
                n6 = cBaseManager.getSegmentStart(n2);
                n5 = this.segCount(n2);
                for (n4 = 0; n4 < n5; ++n4) {
                    n = this.testSegmentCollision(n, n2, n4 + n6);
                }
            }
        }
        return n;
    }

    private void doCollision() {
        if (this.collisionIndex != this.oldCollision) {
            this.collisionTimeStamp = this.timeStamp;
        }
        if (this.collisionIndex != -1 && this.collisionIndex != this.lastCollision) {
            this.angleAcc = 0;
        }
        if (cBaseManager.collisionType == 1) {
            int n = this.timeStamp - this.flyTriggerTime;
            if (n > 250) {
                this.flying = false;
            }
            for (int i = 0; i < this.segPointer; ++i) {
                int n2 = this.segmentCollsionList[i];
                int n3 = cBaseManager.lineIndex[n2];
                this.doCollision(n2, n3);
            }
        } else if (cBaseManager.collisionType == 2) {
            this.flying = false;
            this.processCircleCollision(cBaseManager.objectType[this.collisionIndex] == 11);
        }
    }

    private void doCollision(int n, int n2) {
        this.collisionIndex = n2;
        this.collisionSegment = n;
        if (cBaseManager.collisionTimer[n2] == 0) {
            cBaseManager.collisionTimer[n2] = this.gameDuration;
        }
        switch (cBaseManager.objectType[this.collisionIndex]) {
            case 16: {
                this.processTargetCollision(this.collisionIndex);
                break;
            }
            case 12: {
                this.processSwitchCollision(this.collisionIndex);
                break;
            }
            case 18: {
                this.processConveyorCollision(this.collisionIndex, this.collisionSegment);
                break;
            }
            case 19: {
                this.processTrampolineCollision(this.collisionIndex, this.collisionSegment);
                break;
            }
            default: {
                this.processPlatformCollision(this.collisionIndex, this.collisionSegment);
            }
        }
    }

    private void processTrampolineCollision(int n, int n2) {
        if (this.collision.y < cBaseManager.player.y) {
            this.playerDelta.x = 0;
            this.playerDelta.y = this.gravity.y;
            return;
        }
        this.segment = n2;
        this.playerDelta.y = cFixedPoint.div((-cBaseManager.objectField[n][0] << 12) * 10, charData[0]);
    }

    private void processConveyorCollision(int n, int n2) {
        this.segment = n2;
        this.slide.clear();
        this.bounced = false;
        if (this.collision.y < cBaseManager.player.y) {
            this.playerDelta.y = this.gravity.y;
            return;
        }
        if (!this.bounce(n2, 40960)) {
            int n3 = cFixedPoint.div(cBaseManager.objectField[n][0] << 12, charData[0]) * 7;
            this.playerDelta.x = this.target(this.playerDelta.x, n3, this.scale * 10);
            if (this.playerDelta.y > 0) {
                this.playerDelta.y = 4096;
            }
        }
    }

    private void processSwitchCollision(int n) {
        if (this.lastCollision != n) {
            boolean bl = false;
            int n2 = cBaseManager.getDirectionFlags(cBaseManager.player, cBaseManager.objectLocations[n], 1, 1);
            switch (cBaseManager.objectField[n][1]) {
                case 0: {
                    bl = cBaseManager.isFlag(n2, 1);
                    break;
                }
                case 1: {
                    bl = cBaseManager.isFlag(n2, 2);
                    break;
                }
                case 2: {
                    bl = cBaseManager.isFlag(n2, 8);
                    break;
                }
                case 3: {
                    bl = cBaseManager.isFlag(n2, 4);
                }
            }
            if (bl) {
                cBaseManager.objectField[n][0] = 1;
            }
        }
        this.processPlatformCollision(this.collisionIndex, this.collisionSegment);
    }

    public boolean[] getObjectActive() {
        return cBaseManager.objectActive;
    }

    public int[] getObjectList() {
        return cBaseManager.objectType;
    }

    public int[] getFields(int n) {
        return cBaseManager.objectField[n];
    }

    private int testSegmentCollision(int n, int n2, int n3) {
        int n4 = cBaseManager.getLineDistance(n3);
        if (n4 < n - 40960 && n4 < this.totalLen(n2) * this.totalLen(n2) * 4096) {
            this.closestIndex = n2;
            n = n4;
        }
        this.segment = n3;
        if (n4 <= 0x121000) {
            this.registerSegmentCollision(n2, n3, n4);
            cBaseManager.getLineCollision(n3).copyTo(this.collision);
            this.lineFix();
        }
        return n;
    }

    private void registerSegmentCollision(int n, int n2, int n3) {
        this.collisionIndex = n;
        this.segmentCollsionList[this.segPointer] = n2;
        this.segDist[this.segPointer] = n3;
        ++this.segPointer;
        cBaseManager.collisionType = 1;
        this.collisionSegment = n2;
    }

    private void processCircleCollision(boolean bl) {
        int n = cBaseManager.objectField[this.collisionIndex][0];
        int n2 = cBaseManager.objectField[this.collisionIndex][1];
        cBaseManager.Vector2d vector2d = cBaseManager.sub(cBaseManager.player, cBaseManager.objectLocations[this.collisionIndex]);
        int n3 = cBaseManager.mag(vector2d);
        cBaseManager.Vector2d vector2d2 = cBaseManager.normalise(vector2d).clone();
        cBaseManager.Vector2d vector2d3 = cBaseManager.scale(vector2d2, (n << 12) + 69632 - n3).clone();
        cBaseManager.add(cBaseManager.player, vector2d3).copyTo(cBaseManager.player);
        if (bl) {
            cBaseManager.Vector2d vector2d4 = cBaseManager.Vector2d.getInstance(crlUtil.randInt(-1024, 1024), crlUtil.randInt(-1024, 1024), false);
            vector2d2 = cBaseManager.add(vector2d2, vector2d4);
        }
        this.playerDelta = cBaseManager.scale(vector2d2, cFixedPoint.div(n2 * 10 << 12, charData[0])).clone();
        if (n2 > charData[10]) {
            this.bounced = true;
        }
    }

    public cBaseManager.Vector2d[] getObjectLocations() {
        return cBaseManager.objectLocations;
    }

    private int processFlyData() {
        int n;
        this.playerDir = this.playerDelta.x > 0 ? 1 : -1;
        this.pda = 0;
        int n2 = cFixedPoint.div(this.flyThrottle, 1500);
        n2 = cBaseManager.clamp(-40960, n2, 40960);
        int n3 = cFixedPoint.mul(this.gravity.y, cBaseManager.clamp(1024, n2, 12288));
        if (Math.abs(this.flyThrottle) < 375) {
            n = (375 - Math.abs(this.flyThrottle) << 12) / 375;
            n3 = cFixedPoint.mul(-20480, n);
        } else if (this.flyBrakeTimer != 0) {
            n3 = cBaseManager.clamp(-163840, -(this.timeStamp - this.flyBrakeTimer) * 400, 0);
        }
        n = cFixedPoint.mul(266240, n2);
        this.playerDelta.x = this.target(this.playerDelta.x, n, this.scale * 20);
        int n4 = this.timeStamp - this.flyTriggerTime;
        this.playerDelta.y = n4 > 250 && n4 < 500 ? -122880 : (this.playerDelta.y += cFixedPoint.mul(n3, this.scale) / 2);
        this.playerDelta.x += this.fanForce.x / 4;
        this.playerDelta.y += this.fanForce.y;
        this.flyThrust = cFixedPoint.div(Math.abs(this.playerDelta.x), charData[4]);
        this.flyThrust = cBaseManager.clamp(0, this.flyThrust, 4096);
        int n5 = 4096 - cFixedPoint.mul(charData[1] * 2, this.scale);
        return n5;
    }

    public int getSwingAngle(int n, int n2) {
        int n3 = 400;
        return cFixedPoint.mul(cFixedPoint.sin(cFixedPoint.mul(this.gameDuration + n, n2 * n3) >> 12), 6328);
    }

    protected void updateVelocites() {
        if (this.teleportTimer != -1) {
            return;
        }
        int n = 4096;
        switch (cBaseManager.collisionType) {
            case 0: {
                if (cBaseManager.oldCollisionType != 0) {
                    this.kick.clear();
                    if (this.playerDelta.y > 0) {
                        this.playerDelta.y = 0;
                    }
                } else {
                    this.collision.clear();
                }
                if (this.flying) {
                    n = this.processFlyData();
                    break;
                }
                this.playerDelta.y += cFixedPoint.mul(this.gravity.y, this.scale);
                n = 4096 - cFixedPoint.mul(charData[2], this.scale);
                break;
            }
            case 1: {
                int n2;
                cBaseManager.Vector2d vector2d;
                if (cBaseManager.objectType[this.collisionIndex] != 19 && !this.bounced) {
                    vector2d = cBaseManager.line[this.collisionSegment];
                    cBaseManager.Vector2d vector2d2 = cBaseManager.line[this.collisionSegment + 1];
                    cBaseManager.Vector2d vector2d3 = cBaseManager.normalise(cBaseManager.sub(vector2d2, vector2d));
                    n2 = cFixedPoint.mul(this.gravity.y - cFixedPoint.mul(Math.abs(vector2d3.y), this.gravity.y), this.scale);
                    if (n2 < this.playerDelta.y && this.playerDelta.y > 0 && n2 > 0) {
                        this.playerDelta.y -= n2;
                    }
                }
                vector2d = cBaseManager.tempVect2;
                vector2d.clear();
                vector2d = cBaseManager.add(this.slide, this.playerDelta);
                vector2d = cBaseManager.add(vector2d, this.kick);
                vector2d.copyTo(this.playerDelta);
                if (cBaseManager.objectType[this.collisionIndex] == 2) {
                    int n3;
                    n = this.gameDuration - cBaseManager.collisionTimer[this.collisionIndex] < 250 ? 4096 - cFixedPoint.mul(409, this.scale) : 4096 - cFixedPoint.mul(charData[1], this.scale);
                    int n4 = cBaseManager.objectField[this.collisionIndex][2];
                    if ((cBaseManager.isFlag(n4, 16) || cBaseManager.isFlag(n4, 128)) && (n3 = this.getTargetNode(this.collisionIndex)) > 0) {
                        n2 = 0;
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = 0;
                        cBaseManager.Vector2d vector2d4 = cBaseManager.objectLocations[n3];
                        cBaseManager.Vector2d vector2d5 = cBaseManager.objectLocations[this.collisionIndex];
                        cBaseManager.Vector2d vector2d6 = cBaseManager.normalise(cBaseManager.sub(vector2d4, vector2d5));
                        int n8 = cBaseManager.objectField[n3][0] << 12;
                        if (cBaseManager.isFlag(n4, 128)) {
                            int n9 = cBaseManager.mag(cBaseManager.sub(vector2d4, vector2d5));
                            int n10 = this.getSwingAngle(10, n8);
                            cBaseManager.tempVect2.x = cFixedPoint.sin(n10);
                            cBaseManager.tempVect2.y = cFixedPoint.cos(n10);
                            cBaseManager.Vector2d vector2d7 = cBaseManager.scale(cBaseManager.tempVect2, n9);
                            vector2d7 = cBaseManager.add(vector2d4, vector2d7);
                            vector2d7 = cBaseManager.sub(vector2d7, vector2d5);
                            n2 = vector2d6.x * 20;
                            n5 = vector2d6.y * 30;
                            n6 = 40960;
                            n7 = 40960;
                            if (vector2d7.y > 0) {
                                n7 *= 30;
                                n5 *= 2;
                            }
                        } else {
                            vector2d6 = cBaseManager.scale(vector2d6, n8);
                            if (vector2d6.x != 0) {
                                n2 = vector2d6.x >> 1;
                                n6 = 40960;
                            }
                            n5 = vector2d6.y;
                            n7 = 40960;
                            if (n5 < 0) {
                                n5 >>= 1;
                            } else {
                                n7 *= 80;
                                n5 += 81920;
                            }
                        }
                        this.playerDelta.x = this.target(this.playerDelta.x, n2, cFixedPoint.mul(n6, this.scale));
                        this.playerDelta.y = this.target(this.playerDelta.x, n5, cFixedPoint.mul(n7, this.scale));
                    }
                } else {
                    n = 4096;
                }
                this.realVelocity = cBaseManager.mag(this.playerDelta);
                int n11 = 0;
                if (this.segPointer > 0) {
                    n11 = 2048;
                }
                if (this.playerRealDelta.x < -n11) {
                    this.playerDir = -1;
                    this.pda = this.realVelocity * 4;
                } else if (this.playerRealDelta.x > n11) {
                    this.playerDir = 1;
                    this.pda = -this.realVelocity * 4;
                } else {
                    this.pda = 0;
                }
                this.pda = cBaseManager.clamp(this.pda, 0x320000);
                if (this.collisionIndex == this.oldCollision || !this.bounced || (cBaseManager.collisionType != 1 || cBaseManager.lineCollisionType != 2) && cBaseManager.collisionType != 2) break;
                this.renderer.triggerSparks();
            }
        }
        this.playerDelta.x = cBaseManager.clamp(this.playerDelta.x, 696320);
        this.playerDelta.y = cBaseManager.clamp(this.playerDelta.y, 696320);
        this.playerDelta.x = cFixedPoint.mul(n, this.playerDelta.x);
        this.playerDelta.y = cFixedPoint.mul(n, this.playerDelta.y);
        this.incPlayerPos();
        cBaseManager.sub(cBaseManager.player, this.playerOld).copyTo(this.playerRealDelta);
        cBaseManager.player.copyTo(this.playerOld);
        this.pa += cFixedPoint.mul(this.pda, this.scale);
    }

    private void incPlayerPos() {
        cBaseManager.player.x += cBaseManager.clamp(cFixedPoint.mul(this.playerDelta.x, this.scale), 34816);
        cBaseManager.player.y += cBaseManager.clamp(cFixedPoint.mul(this.playerDelta.y, this.scale), 34816);
    }

    private boolean bounce(int n, int n2) {
        cBaseManager.Vector2d vector2d;
        if (cBaseManager.inMag(this.playerDelta, 10) || cBaseManager.oldCollisionType == 1) {
            return false;
        }
        this.bounce.clear();
        cBaseManager.getNormal(n);
        switch (cBaseManager.lineCollisionType) {
            case 0: {
                if (this.playerDelta.x < 10) {
                    return false;
                }
                vector2d = cBaseManager.getNormal(n);
                break;
            }
            case 1: {
                if (this.playerDelta.x > -10) {
                    return false;
                }
                vector2d = cBaseManager.getNormal(n);
                break;
            }
            case 2: {
                if (this.collision.y < cBaseManager.player.y) {
                    return false;
                }
                vector2d = cBaseManager.getNormal(n);
                break;
            }
            default: {
                return false;
            }
        }
        if (cBaseManager.lineCollisionType == 2) {
            return this.implementBounce(vector2d, charData[8], n2);
        }
        if (cBaseManager.oldCollisionType == 0) {
            return this.implementBounce(vector2d, charData[8], n2);
        }
        return false;
    }

    private boolean implementBounce(cBaseManager.Vector2d vector2d, int n, int n2) {
        int n3 = cBaseManager.dot(vector2d, this.playerDelta);
        this.bounce.x = this.playerDelta.x - 2 * cFixedPoint.mul(vector2d.x, n3);
        this.bounce.y = this.playerDelta.y - 2 * cFixedPoint.mul(vector2d.y, n3);
        this.bounce.x = cFixedPoint.mul(this.bounce.x, cFixedPoint.mul(vector2d.x, n + 4096));
        this.bounce.y = cFixedPoint.mul(this.bounce.y, cFixedPoint.mul(vector2d.y, n + 4096));
        if (cBaseManager.lineCollisionType != 2) {
            return false;
        }
        if (!(cBaseManager.inMag(this.bounce, n2) || Math.abs(this.bounce.x) <= Math.abs(this.playerDelta.x) && Math.abs(this.bounce.y) <= Math.abs(this.playerDelta.y) || cBaseManager.magSqr(this.bounce) <= cBaseManager.magSqr(this.playerDelta) && cBaseManager.lineCollisionType == 2)) {
            cBaseManager.sub(this.playerDelta, this.bounce).copyTo(this.playerDelta);
            int n4 = cFixedPoint.mul(122880, 122880);
            if (cBaseManager.magSqr(this.playerDelta) > n4) {
                this.bounced = true;
                if (cBaseManager.objectType[this.collisionIndex] != 16) {
                    // empty if block
                }
                canvas.vibrate(300);
            } else if (cBaseManager.magSqr(this.playerDelta) > n4 / 2) {
                canvas.vibrate(100);
            }
            return true;
        }
        return false;
    }

    private void processTargetCollision(int n) {
        if (this.timeup || this.fallout) {
            return;
        }
        this.flying = false;
        if (this.collision.y < cBaseManager.player.y) {
            this.playerDelta.x = 0;
            this.playerDelta.y = this.gravity.y;
            return;
        }
        int n2 = cBaseManager.getSegmentStart(n);
        int n3 = cBaseManager.objectLocations[n].x;
        if (this.slideOffLine(n3)) {
            return;
        }
        if (!this.hitGoal) {
            this.renderer.triggerGoal();
            int n4 = cFixedPoint.toInt(cBaseManager.player.x - cBaseManager.line[n2].x);
            int n5 = cBaseManager.objectField[n][0];
            int n6 = n5 + cBaseManager.objectField[n][1];
            int n7 = n6 + cBaseManager.objectField[n][2];
            int n8 = n7 + cBaseManager.objectField[n][3];
            if (n4 < n5) {
                this.goalAccuracy = 0;
                score += 1000;
            } else if (n4 < n6) {
                this.goalAccuracy = 1;
                score += 2000;
            } else if (n4 < n7) {
                this.goalAccuracy = 3;
                score += 5000;
            } else if (n4 < n8) {
                this.goalAccuracy = 1;
                score += 2000;
            } else {
                score += 1000;
                this.goalAccuracy = 0;
            }
            this.renderer.triggerMessage(50);
            canvas.playJingle(2);
        }
        this.hitGoal = true;
        this.segment = cBaseManager.getSegmentStart(n);
        if (this.targetTime == 0) {
            this.targetTime = this.timeStamp;
        }
        this.bounce(this.segment, 40960);
        this.playerDelta.x = 0;
        this.bounce.x = 0;
        this.kick.clear();
        this.slide.clear();
        if (cBaseManager.lineCollisionType == 2 && cBaseManager.magSqr(this.playerDelta) < 102400 || this.timeStamp - this.targetTime > 1500) {
            this.setState(4);
        }
    }

    private boolean slideOffLine(int n) {
        if (cBaseManager.lineCollisionType != 2) {
            if (cBaseManager.lineCollisionType == 0 && cBaseManager.player.x < n) {
                this.playerDelta.x += -4096;
                return true;
            }
            if (cBaseManager.lineCollisionType == 1 && cBaseManager.player.x > n) {
                this.playerDelta.x += 6144;
                return true;
            }
            return true;
        }
        return false;
    }

    protected void calculateBonus() {
        this.banBonusMultiplier = 1;
        this.timeBonusMultiplier = 1;
        if (this.bannanaTotal == this.levelBannaCount) {
            this.banBonusMultiplier = 4;
        } else if (this.bannanaTotal > this.levelBannaCount / 4 * 3) {
            this.banBonusMultiplier = 2;
        }
        int n = this.timeLeft / 100 * 100;
        int n2 = levelData[this.levelId][1];
        if (n > n2 * 750) {
            this.timeBonusMultiplier = 4;
        } else if (n > n2 * 500) {
            this.timeBonusMultiplier = 2;
        }
        if (levelType != 3) {
            this.goalScoreBonus = 1;
            switch (this.goalAccuracy) {
                case 1: {
                    this.goalScoreBonus = 2;
                    break;
                }
                case 3: {
                    this.goalScoreBonus = 5;
                }
            }
        } else {
            this.goalScoreBonus = 0;
        }
        this.banScoreBonus = this.bannanaTotal * 100 * this.banBonusMultiplier;
        this.timeScoreBonus = n * this.timeBonusMultiplier / 20;
        this.totalBonus = this.banScoreBonus + this.timeScoreBonus + this.goalScoreBonus * 1000;
        score += this.totalBonus;
    }

    public int getCollisionTime() {
        return this.timeStamp - this.collisionTimeStamp;
    }

    private void processPlatformCollision(int n, int n2) {
        this.segment = n2;
        if (cBaseManager.objectType[n] == 2) {
            this.bounced = false;
            if (!this.kick(n) || this.angleChangeRate(n) != 0 || cBaseManager.isFlag(cBaseManager.objectField[n][2], 1) || !this.bounce(this.segment, 40960)) {
                this.slide(this.segment, n);
            }
        }
        if (!this.bounce(this.segment, 4096)) {
            this.slide(this.segment, n);
        }
    }

    private void slide(int n, int n2) {
        try {
            cBaseManager.Vector2d vector2d = cBaseManager.line[n];
            cBaseManager.Vector2d vector2d2 = cBaseManager.line[n + 1];
            if (vector2d.x == vector2d2.x) {
                this.playerDelta.x = -this.playerDelta.x;
                return;
            }
            if (this.collision.y < cBaseManager.player.y - 10) {
                if (cBaseManager.lineCollisionType == 2) {
                    this.playerDelta.y = this.gravity.y;
                    if (Math.abs(this.platformAngles[n2]) > 2048 || cBaseManager.objectType[n2] == 20) {
                        this.playerDelta.x = 0;
                    }
                    cBaseManager.player.y += 16384;
                    return;
                }
                this.playerDelta.y = 0;
                if (cBaseManager.lineCollisionType == 0 && this.playerDelta.x > 0 || cBaseManager.lineCollisionType == 1 && this.playerDelta.x < 0) {
                    this.playerDelta.x = -this.playerDelta.x;
                }
                if (cBaseManager.objectType[n2] == 20 && cBaseManager.lineCollisionType != 2) {
                    this.playerDelta.x = 0;
                    cBaseManager.player.y += 16384;
                }
            }
            if (this.slideOffLine(vector2d.x)) {
                return;
            }
            cBaseManager.Vector2d vector2d3 = cBaseManager.add(cBaseManager.player, this.gravity);
            cBaseManager.Vector2d vector2d4 = cBaseManager.findLineIntersection(vector2d, vector2d2, cBaseManager.player, vector2d3);
            if (vector2d4 == null) {
                return;
            }
            cBaseManager.Vector2d vector2d5 = cBaseManager.sub(this.collision, vector2d4);
            int n3 = cFixedPoint.mul(cBaseManager.mag(vector2d5), this.scale);
            n3 = cFixedPoint.mul(n3, charData[6]);
            cBaseManager.Vector2d vector2d6 = cBaseManager.getNormal(vector2d2, vector2d);
            vector2d6.x = -vector2d6.x;
            vector2d6 = cBaseManager.scale(vector2d6, n3).clone();
            cBaseManager.Vector2d vector2d7 = cBaseManager.normalise(cBaseManager.sub(vector2d2, vector2d)).clone();
            vector2d7 = cBaseManager.scale(vector2d7, 8192).clone();
            if (this.platformControlled && this.collision.x > cBaseManager.objectLocations[n2].x && this.moveDir == -1 && this.playerDelta.x > 0 && vector2d6.x > 0) {
                vector2d6 = cBaseManager.add(vector2d6, vector2d7);
            } else if (this.platformControlled && this.collision.x < cBaseManager.objectLocations[n2].x && this.moveDir == 1 && this.playerDelta.x < 0 && vector2d6.x < 0) {
                vector2d6 = cBaseManager.sub(vector2d6, vector2d7);
            }
            vector2d6.copyTo(this.slide);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getPlayerDirection() {
        return this.playerDir;
    }

    private cBaseManager.Vector2d lineFix() {
        cBaseManager.Vector2d vector2d = cBaseManager.sub(cBaseManager.player, this.collision).clone();
        cBaseManager.Vector2d vector2d2 = cBaseManager.normalise(vector2d);
        if (cBaseManager.lastMag > 70656) {
            vector2d.clear();
            return vector2d;
        }
        int n = 68608 - cBaseManager.lastMag;
        if (n < 0) {
            vector2d.clear();
            return vector2d;
        }
        if (vector2d2.y > 0) {
            vector2d.clear();
            return vector2d;
        }
        vector2d2 = cBaseManager.scale(vector2d2, n);
        cBaseManager.add(cBaseManager.player, vector2d2).copyTo(cBaseManager.player);
        return vector2d2;
    }

    protected void updatePlayerPhysics() {
        if (this.flying) {
            this.flyPeriod += this.duration;
            while (this.flyPeriod > this.glideBurnRate && !cPhysicsManager.canvas.cheat) {
                --this.glideTime;
                this.flyPeriod -= this.glideBurnRate;
            }
            if (this.glideTime <= 0) {
                this.glideTime = 0;
                this.flying = false;
            }
        } else {
            this.flyPeriod = 0;
        }
        this.processPlayerCollision();
    }

    public int getTargetNode(int n) {
        int n2 = this.associatedPath(n);
        if (n2 == -1) {
            return -1;
        }
        for (int i = 0; i < this.targetNodes[n]; ++i) {
            if ((n2 = this.associatedPath(n2)) != -1) continue;
            n2 = this.associatedPath(n);
            this.targetNodes[n] = 0;
            return n2;
        }
        return n2;
    }

    protected int resetRate(int n, int n2) {
        int n3 = cFixedPoint.mul(cFixedPoint.mul(n, charData[17]), this.scale);
        int n4 = this.maxTurnRate(this.totalLen(n2), n3);
        if (Math.abs(n) < Math.abs(n4)) {
            n4 = n;
        }
        return n4;
    }

    protected int angleChangeRate(int n) {
        if (n == this.closestIndex && (this.platformControlled || cBaseManager.isFlag(cBaseManager.objectField[n][2], 1))) {
            return cFixedPoint.mul(this.angleAcc, this.scale);
        }
        if (cBaseManager.isFlag(cBaseManager.objectField[n][2], 4)) {
            int n2 = this.baseDiff(n);
            return this.resetRate(n2, n);
        }
        return 0;
    }

    protected int baseDiff(int n) {
        return cBaseManager.objectField[n][0] * 71 - this.platformAngles[n];
    }

    protected int maxTurnRate(int n, int n2) {
        int n3 = n2;
        if (n == 0) {
            return n2;
        }
        int n4 = 12868 * n;
        int n5 = cFixedPoint.div(69632, n4);
        n3 = cFixedPoint.mul(n5, 25736);
        n3 += n3 / 7;
        int n6 = Math.min(n2, n3);
        return n6;
    }

    public int getPlayerBallAngle() {
        return this.playerBallAngle;
    }

    private boolean kick(int n) {
        if (!this.kickActive || cBaseManager.isFlag(cBaseManager.objectField[this.closestIndex][2], 8) || cBaseManager.collisionTimer[this.collisionIndex] < 500 || this.platformControlled || this.moveDir == 1 && this.collision.x > cBaseManager.objectLocations[n].x || this.moveDir == -1 && this.collision.x < cBaseManager.objectLocations[n].x) {
            this.kick.clear();
            return true;
        }
        this.kick.clear();
        this.kickActive = false;
        int n2 = cBaseManager.len(this.collision, cBaseManager.objectLocations[n]);
        int n3 = this.baseDiff(n) * 10;
        int n4 = this.calcKickForce(n3, n2);
        cBaseManager.sub(cBaseManager.player, this.collision).copyTo(cBaseManager.tempVect2);
        cBaseManager.Vector2d vector2d = cBaseManager.normalise(cBaseManager.tempVect2).clone();
        cBaseManager.Vector2d vector2d2 = cBaseManager.Vector2d.getInstance();
        int n5 = this.platformAngles[n] - 1608;
        if (n5 != 0) {
            vector2d2.x = cFixedPoint.cos(n5);
            vector2d2.y = cFixedPoint.sin(n5);
            vector2d2 = cBaseManager.scale(vector2d2, 2048).clone();
            vector2d = cBaseManager.normalise(cBaseManager.add(vector2d, vector2d2));
        }
        cBaseManager.Vector2d vector2d3 = cBaseManager.scale(vector2d, n4);
        vector2d3.copyTo(this.kick);
        this.kick.x = cFixedPoint.mul(this.kick.x, 4096);
        this.kick.y = cFixedPoint.mul(this.kick.y, 4096);
        return false;
    }

    public static boolean isBonus(int n) {
        return levelData[n][0] == 3;
    }

    private int calcKickForce(int n, int n2) {
        int n3;
        int n4 = cFixedPoint.div(n2, 409600);
        if ((n4 = cBaseManager.clamp(163, n4, 1024)) == 163) {
            n4 = 0;
        }
        if ((n3 = cBaseManager.clamp(204, Math.abs(n), 4096)) == 204) {
            n3 = 0;
        }
        n4 = cFixedPoint.mul(n4, n3);
        n4 = cFixedPoint.mul(n4, 614400);
        n4 = Math.min(n4, 409600);
        return n4;
    }

    public int target(int n, int n2, int n3) {
        n = n < n2 - n3 ? (n += n3) : (n > n2 + n3 ? (n -= n3) : n2);
        return n;
    }

    public int getCharacter() {
        return this.character;
    }

    public void setCharacter(int n) {
        this.character = n;
    }

    public static void loadLevelSettings() {
        byte[] byArray = crlCanvas.gResourceManager.getBinBySpongeID(151178622354406L);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = byArray.length / 2;
        levelData = new int[n][3];
        try {
            for (int i = 0; i < n; ++i) {
                cPhysicsManager.levelData[i][0] = dataInputStream.readByte();
                cPhysicsManager.levelData[i][1] = 60;
                cPhysicsManager.levelData[i][2] = dataInputStream.readByte();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        gameState = 0;
    }
}

