/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import Coral.Util.crlUtil;
import javax.microedition.lcdui.Graphics;
import monkey.cBaseRenderer;

public class cParticleHandler {
    static final int MBOOSTER_MAX_INSTANCES = 1;
    private int particleCount;
    public static final int SPAWN_LIMIT = 10;
    protected int[] xPos;
    protected int[] yPos;
    protected int[] xDelta;
    protected int[] yDelta;
    protected int[] lifeLeft;
    protected int[] spawnIndex;
    protected int[] type;
    protected int[] spawnX = new int[10];
    protected int[] spawnY = new int[10];
    protected int[] spawnW = new int[10];
    protected int[] spawnH = new int[10];
    protected int[] spawnFrequency = new int[10];
    protected int[] spawnLife = new int[10];
    protected int[] nextSpawn = new int[10];
    protected int[] spawnType = new int[10];
    protected boolean[] spawnActive = new boolean[10];
    protected int[] spawnCount = new int[10];
    private int spawnCounter;
    private int lifeTime;

    public cParticleHandler(int n) {
        this.particleCount = n;
        this.xPos = new int[n];
        this.yPos = new int[n];
        this.xDelta = new int[n];
        this.yDelta = new int[n];
        this.lifeLeft = new int[n];
        this.spawnIndex = new int[n];
        this.type = new int[n];
    }

    public int createSpawn(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.createSpawn(n, n2, 5, 5, n3, n4, n5, n6);
    }

    public int createSpawn(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ++this.spawnCounter;
        this.spawnCounter %= 10;
        this.spawnX[this.spawnCounter] = n;
        this.spawnY[this.spawnCounter] = n2;
        this.spawnW[this.spawnCounter] = n3;
        this.spawnH[this.spawnCounter] = n4;
        this.spawnLife[this.spawnCounter] = n5;
        this.spawnFrequency[this.spawnCounter] = n6;
        this.nextSpawn[this.spawnCounter] = this.lifeTime + n6;
        this.spawnType[this.spawnCounter] = n8;
        this.spawnActive[this.spawnCounter] = true;
        this.spawnCount[this.spawnCounter] = n7;
        return this.spawnCounter;
    }

    public void setSpawnLocation(int n, int n2, int n3) {
        this.spawnX[n] = n2;
        this.spawnY[n] = n3;
    }

    public void killSpawn(int n, boolean bl) {
        this.spawnActive[n] = false;
        if (bl) {
            for (int i = 0; i < this.particleCount; ++i) {
                if (this.spawnIndex[i] != n) continue;
                this.lifeLeft[i] = 0;
            }
        }
    }

    public void tick(int n) {
        int n2;
        this.lifeTime += n;
        for (n2 = 0; n2 < this.particleCount; ++n2) {
            if (this.lifeLeft[n2] <= 0) continue;
            this.tickParticle(n2, n);
        }
        for (n2 = 0; n2 < 10; ++n2) {
            if (!this.spawnActive[n2] || this.nextSpawn[n2] > this.lifeTime) continue;
            int n3 = this.lifeTime - this.nextSpawn[n2];
            int n4 = this.spawnFrequency[n2];
            int n5 = n3 / n4;
            if (n5 == 0) {
                n5 = 1;
            }
            for (int i = 0; i < n5; ++i) {
                int n6 = this.getFreeParticle();
                if (n6 == -1) continue;
                this.spawnParticle(n6, n2);
            }
            this.nextSpawn[n2] = this.lifeTime + this.spawnFrequency[n2];
        }
    }

    protected final int getFreeParticle() {
        for (int i = 0; i < this.particleCount; ++i) {
            if (this.lifeLeft[i] > 0) continue;
            return i;
        }
        return -1;
    }

    protected void tickParticle(int n, int n2) {
        this.xPos[n] = this.xPos[n] + this.xDelta[n] * n2 / 1000;
        this.yPos[n] = this.yPos[n] + this.yDelta[n] * n2 / 1000;
        this.lifeLeft[n] = this.lifeLeft[n] - n2;
    }

    protected void spawnParticle(int n, int n2) {
        if (this.spawnCount[n2] != -1) {
            if (this.spawnCount[n2] == 0) {
                this.killSpawn(n2, false);
                return;
            }
            this.spawnCount[n2] = this.spawnCount[n2] - 1;
        }
        int n3 = this.spawnX[n2] << 12;
        int n4 = this.spawnY[n2] << 12;
        int n5 = this.spawnW[n2] << 12;
        int n6 = this.spawnH[n2] << 12;
        int n7 = 20480;
        int n8 = 20480;
        int n9 = this.spawnLife[n2];
        this.xPos[n] = crlUtil.randInt(n3, n3 + n5);
        this.yPos[n] = crlUtil.randInt(n4, n4 + n6);
        this.lifeLeft[n] = crlUtil.randInt(n9 - 50, n9);
        this.xDelta[n] = crlUtil.randInt(-n7, n7);
        this.yDelta[n] = crlUtil.randInt(-n8, n8);
        this.spawnIndex[n] = n2;
        this.type[n] = this.spawnType[n2];
    }

    public void paint(Graphics graphics) {
        for (int i = 0; i < this.particleCount; ++i) {
            if (this.lifeLeft[i] <= 0) continue;
            int n = cBaseRenderer.toScreenCoord(this.xPos[i]);
            int n2 = cBaseRenderer.toScreenCoord(this.yPos[i]);
            this.drawParticle(graphics, i, n, n2);
        }
    }

    protected void drawParticle(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(0xFF0000);
        graphics.drawRect(n2, n3, 5, 5);
    }
}

