/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import Coral.Graphics2D.crlFont;
import Coral.Graphics2D.crlImagePacked;
import Coral.Util.crlResourceManager;
import Coral.Util.crlString;
import Coral.crlCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import monkey.cBaseManager;
import monkey.cBaseRenderer;
import monkey.cCanvas;
import monkey.cEntityManager;
import monkey.cFixedPoint;
import monkey.cMonkeyParticle;
import monkey.cPhysicsManager;
import monkey.cSponge;

public final class cGameRenderer
extends cBaseRenderer {
    static final int MBOOSTER_MAX_INSTANCES = 1;
    public static final int CHAR_WALK_SEQUENCE = 0;
    public static final int CHAR_RUN_SEQUENCE = 1;
    public static final int CHAR_FALL_SEQUENCE = 2;
    public static final int CHAR_FALLOUT_SEQUENCE = 3;
    public static final int CHAR_GOAL_SEQUENCE = 4;
    public static final int CHAR_FLYUP_SEQUENCE = 5;
    public static final int CHAR_FLY_SEQUENCE = 6;
    public static final int CHAR_SEQUENCE_LENGTH = 8;
    public static final int PLATFORM_NULL = -1;
    public static final int PLATFORM_MAUVE = 0;
    public static final int PLATFORM_BLUE = 1;
    public static final int PLATFORM_CYAN = 2;
    public static final int PLATFORM_GREEN = 3;
    public static final int PLATFORM_YELLOW = 4;
    public static final int PLATFORM_ORANGE = 5;
    public static final int PLATFORM_RED = 6;
    public static final int REDUCED_HUD_FONT_WIDTH = 7;
    public static final int BUMPER_FRAMES = 2;
    public static final int LIVE_FRAMES = 4;
    public static final int WORMHOLE_FRAMES = 4;
    public static final int BALL_FRAMES = 16;
    public static final int PLATFORM_FRAMES = 14;
    public static final int PLATFORM_ROWS = 2;
    public static final int SPIKE_FRAMES = 2;
    public static final int FAN_FRAMES = 4;
    public static final int CONVEYOR_FRAMES = 3;
    public static final int HUD_SOFTKEY_FRAMES = 2;
    public static final int TIME_ATTACK_MARGIN = 10;
    public static final int PLATFORM_WIDTH = 8;
    public static final int PLATFORM_HEIGHT = 13;
    public static final int BALL_SIZE = 26;
    public static final int SPRING_WIDTH = 39;
    public static final int SPRING_HEIGHT = 9;
    public static final int SPRING_ANCHOR_X = 20;
    public static final int SPRING_ANCHOR_Y = 5;
    public static final int ARROW_ANCHOR_X = 5;
    public static final int ARROW_ANCHOR_Y = 10;
    public static final int HUD_TOP_LINE = 10;
    public static final int HUD_SECOND_LINE = 30;
    public static final int HUD_BONUS_LINE = 180;
    public static final int HUD_LEFT_MARGIN = 5;
    public static final int HUD_RIGHT_MARGIN = 5;
    public static final int HUD_CLOCK_TOP = 1;
    public static final int HUD_CLOCK_MAJOR = 15;
    public static final int HUD_CLOCK_MINOR = 29;
    public static final int HUD_BEVEL_SIZE = 16;
    public static final int HUD_HEIGHT = 16;
    public static final int HUD_IMAGE_SIZE = 128;
    public static final int PLATFORM_ANCHOR_X = 5;
    public static final int PLATFORM_ANCHOR_Y = 4;
    public static final int PLATFORM_BEVEL_Y = 1;
    public static final int HUD_HEAD_OFFSET = 40;
    private static final int GLIDE_BAR_Y = 10;
    private static final int GLIDE_BAR_WIDTH = 100;
    private static final int RESULT_SCORE_X = 110;
    private static final int RESULT_EQUAL_X = 95;
    private static final int RESULT_MUL_VAL_X = 80;
    private static final int COUNT_VAL_X = 20;
    private static final int RESULT_MUL_X = 60;
    private static final int RESULT_GAP_Y = 10;
    private static final int RESULT_Y = 20;
    private static final int RESULT_TIMER = 750;
    public static final int SWITCH_WIDTH = 36;
    public static final int SWITCH_HEIGHT = 11;
    public static final int SWITCH_ANCHOR_X = 18;
    public static final int SWITCH_ANCHOR_Y = 5;
    private static final int INTRO_LEVEL_Y = 65;
    public static final int INTRO_COMPLETION_Y = 120;
    public static final int PAUSE_BACKGROUND_Y = 55;
    public static final int TUTORIAL_LINES = 6;
    public static final int MENU_TEXT_START = 20;
    public static final int MENU_BOTTOM_MARGIN = 5;
    public static final int MENU_HEADER_GAP = 3;
    public static final int MENU_BACKGROUND_MARGIN = 5;
    public static final int MENU_BACKGROUND_BEVEL = 20;
    public static final int MENU_TRIM_GAP = 5;
    public static final int MENU_BACKGROUND_COLOUR = 6834208;
    public static final int MENU_TRIM_COLOUR = 11042880;
    public static final int GOAL_WIDTH = 12;
    public static final int GOAL_HEIGHT = 14;
    public static final int GOAL_ANCHOR_X = 6;
    public static final int GOAL_ANCHOR_Y = 4;
    public static final int GOAL_BEVEL_WIDTH = 12;
    public static final int STATS_RIGHT_MARGIN = 10;
    public static final int STATS_LEFT_MARGIN = 10;
    public static final int STATS_Y_START = 50;
    public static final int STATS_HEADER_Y = 10;
    private static final int STATS_MENU_GAP = 5;
    private static final int STATS_Y_OFFS = 0;
    public static final int CHAR_INDICATOR_X = 15;
    public static final int CHAR_INDICATOR_Y = 50;
    public static final int GOAL_RENDER_MARGIN = 20;
    public static final int GOAL_HUD_MARGIN = 40;
    private static final int ANNOTATION_TEXT_HEIGHT = 100;
    private static final int SPRING_GAP = 4;
    private static final int SPRING_OFFSET = 5;
    public static final int HUD_TOP_BAR_WIDTH = 60;
    public static final int HUD_BOTTOM_BAR_WIDTH = 60;
    public static final int HUD_BANNANA_MARGIN = 37;
    public static final int HUD_SPEED_MARGIN = 31;
    public static final int TUTORIAL_MARGIN = 25;
    public static final int INTRO_MARGIN = 20;
    public static final int GLIDE_FILL_X = 15;
    public static final int GLIDE_FILL_HEIGHT = 10;
    private static final int SPRING_TIMER = 50;
    private static final int CONVEYOR_SPEED = 100;
    private static final int PATH_INNER_COLOUR = 0x808080;
    private static final int PATH_EDGE_COLOUR = 0xC0C0C0;
    public static final int CHALLENGE_SUMMARY_MARGIN = 20;
    public static final int HUD_BONUS_BANTOTAL = -30;
    public static final int HUD_BONUS_SLASH = -8;
    public static final int HUD_BONUS_COUNT = 24;
    public static final int PAN_X_MARGIN = 10;
    public static final int PAN_Y_MARGIN = 10;
    public static final int PAUSE_X_MARGIN = 10;
    public static final int PAUSE_Y_MARGIN = 10;
    public static final int SOFTKEY_MARGIN = 12;
    public static final int[] STATS_TEXT = new int[]{107, 166, 167, 168, 169, 106};
    public static final int[][] GAME_MENU_DATA = new int[][]{{163, 62}, {165, 163, 62}, {114, 16}, {114, 62}, {114, 16}};
    public static final int[][] GAME_MENU_EXIT = new int[][]{{-33, -16}, {-33, -16}, {-16, -16}, {-1, -16}, {-16, -16}};
    public static final int EXIT_MODE_SELECT = 0;
    public static final int EXIT_MODE_MAIN = 1;
    private static final int TELEPORT_ANIM_SPEED = 200;
    public static final int PLAYER_FRAME_TICK = 100;
    private crlFont hudFont;
    public crlImagePacked ballImage;
    public crlImagePacked monkey;
    private crlImagePacked bannana;
    private crlImagePacked bunch;
    private crlImagePacked platform;
    private crlImagePacked goal;
    private crlImagePacked softkeys;
    private crlImagePacked switches;
    private crlImagePacked conveyor;
    private crlImagePacked trampoline;
    private crlImagePacked bumper;
    private crlImagePacked teleport;
    private crlImagePacked spike;
    private crlImagePacked fan;
    private crlImagePacked[] ballStore;
    private crlImagePacked face;
    private Image pivot;
    private Image clockImage;
    private Image playerStart;
    private Image hud;
    private int cameraX;
    private int cameraY;
    private int oldCameraX;
    private int oldCameraY;
    private int centerX;
    private int centerY;
    private int goalX;
    private int goalY;
    private int[] camNodes = new int[16];
    private Graphics g;
    private int sparkParticle = -1;
    private int starParticle = -1;
    private int duration;
    private int lifespan;
    public int stageType;
    int playerAnimFrame;
    int frameTick;
    int drawType;
    boolean msgRendered;
    int oldOldCameraX;
    int oldOldCameraY;
    int messageTimer;
    int messageIdx;
    public static final int MENU_OPTION_GAP = 0;
    public static final int PLATFORM_PRECISION = 12;

    public void update(int n) {
        this.duration = 0;
        this.lifespan = this.manager.gameDuration;
        if (this.manager.getState() != 9) {
            this.duration = n;
            this.particles.tick(this.duration);
        }
    }

    public void setMonkey(crlImagePacked crlImagePacked2, long l) {
    }

    public void loadImages() {
        this.particles.setParticleImage(crlCanvas.gResourceManager.getIMPByID(134639832959601L));
        cBaseRenderer.loadParralax(this.getWidth(), this.getHeight(), this.stageType, false);
        if (this.hudFont == null) {
            this.hudFont = new crlFont();
            this.hudFont.open(crlCanvas.gResourceManager.getIMPByID(122206067805956L), 1, 0);
            this.switches = new crlImagePacked();
            this.switches.open(crlCanvas.gResourceManager.getImageByID(142263548055660L), 36, 11, 18, 5);
            this.goal = new crlImagePacked();
            this.goal.open(crlCanvas.gResourceManager.getImageByID(120373871376329L), 12, 14, 6, 4);
            this.trampoline = new crlImagePacked();
            this.trampoline.open(crlCanvas.gResourceManager.getImageByID(146210346546365L), 39, 9, 20, 5);
            this.pivot = crlCanvas.gResourceManager.getImageByID(133790965888689L);
            this.bumper = new crlImagePacked();
            this.bumper.open(crlCanvas.gResourceManager.getImageByID(147462830902491L), 2);
            this.spike = new crlImagePacked();
            this.spike.open(crlCanvas.gResourceManager.getImageByID(162459194125104L), 2);
            this.fan = new crlImagePacked();
            this.fan.open(crlCanvas.gResourceManager.getImageByID(166851858311265L), 4);
            this.face = new crlImagePacked();
            this.face.open(crlCanvas.gResourceManager.getImageByID(126801632393487L), 4);
            this.teleport = new crlImagePacked();
            this.teleport.open(crlCanvas.gResourceManager.getImageByID(152775507041520L), 4);
            this.softkeys = new crlImagePacked();
            this.softkeys.open(crlCanvas.gResourceManager.getImageByID(165809921612034L), 2);
            this.platform = new crlImagePacked();
            this.platform.open(crlCanvas.gResourceManager.getImageByID(111618203167490L), 8, 13, 5, 4);
            this.bannana = crlCanvas.gResourceManager.getIMPByID(115273875435972L);
            this.bunch = crlCanvas.gResourceManager.getIMPByID(117401369325907L);
            this.conveyor = crlCanvas.gResourceManager.getIMPByID(143881208738455L);
            this.clockImage = crlCanvas.gResourceManager.getImageByID(130366506885761L);
            this.playerStart = crlCanvas.gResourceManager.getImageByID(151604516804424L);
            this.hud = crlCanvas.gResourceManager.getImageByID(164997633786923L);
        }
        if (this.ballStore == null) {
            this.ballStore = new crlImagePacked[4];
        }
        if (this.ballStore[this.manager.currentPlayer] == null) {
            this.ballImage = new crlImagePacked();
            this.ballImage.open(crlCanvas.gResourceManager.getImageByID(cSponge.PACK_BALLS[this.manager.currentPlayer]), 16);
            this.ballStore[this.manager.currentPlayer] = this.ballImage;
        }
        this.ballImage = this.ballStore[this.manager.currentPlayer];
        this.monkey = crlCanvas.gResourceManager.getIMPByID(cSponge.PACK_CHARACTERS[this.manager.getCharacter()]);
    }

    public void setStageType(int n) {
        this.stageType = n;
    }

    public void render(Graphics graphics) {
        if (graphics == null || this.manager == null || !this.manager.loadedLevel) {
            return;
        }
        this.g = graphics;
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.updateCamera();
        this.renderWorld();
        switch (this.manager.getState()) {
            case 0: 
            case 5: {
                cBaseRenderer.doFade(this.g, this.manager.getState() == 0, 0xFFFFFF);
                break;
            }
            case 8: {
                cBaseRenderer.doFade(this.g, true, 0xFFFFFF);
                break;
            }
            case 6: {
                this.renderMessage();
                this.renderScoreSummary();
                break;
            }
            case 9: {
                this.renderHud();
                this.renderPauseMenu();
                cBaseRenderer.fade = 0;
                break;
            }
            case 1: {
                this.renderLevelIntroMessage();
                this.renderPlayerIndicator();
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                this.renderPostGoalScreen();
                break;
            }
            case 13: {
                this.renderMessage();
                break;
            }
            default: {
                this.renderHud();
                this.renderPlayerIndicator();
            }
        }
        this.renderSoftKeys();
    }

    private void updateCamera() {
        if (cPhysicsManager.gameState != 9) {
            this.oldOldCameraX = this.oldCameraX;
            this.oldOldCameraY = this.oldCameraY;
            this.oldCameraX = this.cameraX;
            this.oldCameraY = this.cameraY;
            int n = this.manager.getCameraX();
            int n2 = this.manager.getCameraY();
            if (n2 < 0) {
                n2 = 0;
            }
            this.cameraX = cBaseRenderer.toScreenCoord(n << 12) - this.centerX;
            this.cameraY = cBaseRenderer.toScreenCoord(n2 << 12) - this.getHeight() / 3;
            this.cameraX = (this.cameraX + this.oldCameraX + this.oldOldCameraX) / 3;
            this.cameraY = (this.cameraY + this.oldCameraY + this.oldOldCameraY) / 3;
        }
    }

    private void renderWorld() {
        this.renderBackground();
        this.g.translate(-this.cameraX, -this.cameraY);
        this.renderObjecBackgrounds();
        this.renderGameObjects();
        if (this.manager.getState() != 5 && this.manager.getState() != 0 && this.manager.getState() != 1) {
            if (this.manager.gameType == 3) {
                this.renderGhost();
            }
            try {
                if (cPhysicsManager.gameState != 12) {
                    this.renderPlayer();
                }
            }
            catch (Throwable throwable) {}
        } else {
            int n = cBaseRenderer.scaleCoord(this.manager.playerX);
            int n2 = cBaseRenderer.scaleCoord(this.manager.playerY);
            this.g.drawImage(this.playerStart, n, n2 - 30 + cBaseRenderer.bob(0, 10, 15), 3);
        }
        this.renderParticles();
        this.g.translate(this.cameraX, this.cameraY);
    }

    private void renderGhost() {
        if (this.manager.ghostX != null) {
            int n = Math.min(this.manager.ghostIdx, (this.manager.totalTime - 250) / 250);
            if (n > 399) {
                n = 399;
            } else if (n < 0) {
                return;
            }
            if (this.manager.ghostPlayer != -1) {
                if (this.ballStore == null) {
                    this.ballStore = new crlImagePacked[4];
                }
                if (this.ballStore[this.manager.ghostPlayer] == null) {
                    this.ballStore[this.manager.ghostPlayer] = new crlImagePacked();
                    this.ballStore[this.manager.ghostPlayer].open(crlCanvas.gResourceManager.getImageByID(cSponge.PACK_BALLS[this.manager.ghostPlayer]), 16);
                }
            }
            int n2 = this.manager.ghostX[n];
            int n3 = this.manager.ghostY[n];
            if (n != this.manager.ghostIdx) {
                short s = this.manager.ghostX[n + 1];
                short s2 = this.manager.ghostY[n + 1];
                int n4 = (this.manager.totalTime - 250) % 250;
                int n5 = s - n2;
                int n6 = s2 - n3;
                n5 *= n4;
                n6 *= n4;
                n2 += (n5 /= 250);
                n3 += (n6 /= 250);
            }
            n2 = cBaseRenderer.scaleCoord(n2);
            n3 = cBaseRenderer.scaleCoord(n3);
            this.ballStore[this.manager.ghostPlayer].draw(this.g, n2, n3, this.manager.totalTime / 100);
        }
    }

    private int renderBonusScore(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.manager.getStateDuration() > n6) {
            n = cBaseRenderer.headerFont.print(this.g, this.centerX, n, n2);
            n = this.renderScore(n, n3, n4, n5);
            n += cBaseRenderer.textFont.getHeight();
        }
        return n;
    }

    private int renderScore(int n, int n2, int n3, int n4) {
        cBaseRenderer.textFont.setAlign(0);
        cBaseRenderer.textFont.printNumber(this.g, 20, n, n2, 1);
        cBaseRenderer.textFont.setAlign(0);
        cBaseRenderer.textFont.print(this.g, 60, n, 97);
        cBaseRenderer.textFont.printNumber(this.g, 80, n, n3, 1);
        cBaseRenderer.textFont.print(this.g, 95, n, 98);
        return cBaseRenderer.textFont.printNumber(this.g, 110, n, n4, 6);
    }

    private void renderScoreSummary() {
        int n = 20;
        cBaseRenderer.headerFont.setAlign(1);
        if (this.manager.gameType != 3) {
            n = this.renderBonusScore(n, 87, this.manager.bannanaTotal * 100, this.manager.banBonusMultiplier, this.manager.banScoreBonus, 750);
            n = this.renderBonusScore(n, 90, this.manager.timeScoreBonus / this.manager.timeBonusMultiplier, this.manager.timeBonusMultiplier, this.manager.timeScoreBonus, 1500);
            if (cPhysicsManager.levelType != 3) {
                n = this.renderBonusScore(n, 99, 1000, this.manager.goalScoreBonus, this.manager.goalScoreBonus * 1000, 2250);
            }
            if (this.manager.getStateDuration() > 3000) {
                n = cBaseRenderer.headerFont.print(this.g, this.centerX, n, 100);
                int n2 = this.manager.getStateDuration() - 3000;
                int n3 = Math.min(this.manager.totalBonus, this.manager.totalBonus * n2 / 1500);
                cBaseRenderer.headerFont.printNumber(this.g, this.centerX, n, n3, 0);
            }
        } else {
            this.renderTimeAttackSummary();
        }
    }

    private void renderPostGoalScreen() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        for (n5 = 0; n5 < cBaseManager.collisionTimer.length; ++n5) {
            if (cBaseManager.collisionTimer[n5] == 0) continue;
            ++n6;
        }
        n5 = 103;
        switch (cPhysicsManager.gameState) {
            case 14: {
                n5 = 8;
                break;
            }
            case 15: {
                n5 = 85;
                if (this.manager.gameType != 3) break;
                return;
            }
            case 11: {
                n5 = cPhysicsManager.levelType + 1 < 3 ? 59 : (this.manager.newRandomUnlocked ? 38 : 38);
            }
        }
        cBaseRenderer.headerFont.setAlign(1);
        int n7 = cBaseRenderer.headerFont.print(this.g, this.centerX, 10, n5);
        int n8 = n7 += 0;
        switch (cPhysicsManager.gameState) {
            case 14: {
                break;
            }
            case 11: {
                cBaseRenderer.textFont.setAlign(1);
                if (cPhysicsManager.levelType + 1 < 3) {
                    n7 = cBaseRenderer.textFont.print(this.g, this.centerX, n7, 38);
                    n7 = cBaseRenderer.textFont.print(this.g, this.centerX, n7, 32 + cPhysicsManager.levelType + 1);
                    break;
                }
                if (this.manager.newRandomUnlocked) {
                    n7 = cBaseRenderer.textFont.print(this.g, this.centerX, n7, 35);
                    break;
                }
                n7 = cBaseRenderer.textFont.print(this.g, this.centerX, n7, 37);
                break;
            }
            case 15: {
                if (this.manager.gameType == 2 || this.manager.gameType == 4) {
                    n4 = 0;
                    n3 = 0;
                    for (n2 = 0; n2 < cEntityManager.multiplayTracking.length; ++n2) {
                        n = cEntityManager.multiplayTracking[n2][1];
                        if (n4 >= n) continue;
                        n4 = n;
                        n3 = n2;
                    }
                    if (n4 != 0) {
                        n7 = cBaseRenderer.headerFont.print(this.g, this.centerX, n7, 124 + n3);
                        n7 = cBaseRenderer.headerFont.print(this.g, this.centerX, n7, 17);
                        for (n2 = 0; n2 < cEntityManager.multiplayTracking.length; ++n2) {
                            cBaseRenderer.textFont.setAlign(0);
                            cBaseRenderer.textFont.print(this.g, 20, n7, 124 + n2);
                            cBaseRenderer.textFont.setAlign(2);
                            n7 = cBaseRenderer.textFont.printNumber(this.g, this.getWidth() - 20, n7, cEntityManager.multiplayTracking[n2][1], 6);
                        }
                    }
                }
                if (!crlCanvas._mDemo) break;
                cBaseRenderer.textFont.setAlign(1);
                n4 = cGameRenderer.getPrintHeight(cBaseRenderer.textFont, 173, this.getWidth() - 20);
                crlString crlString2 = crlResourceManager.mLocaleText[173];
                cBaseRenderer.textFont.printWrapped(this.g, 10, n7, this.getWidth() - 20, n4, crlString2.get(), null, 0);
                n7 += n4;
                break;
            }
            default: {
                n4 = 10;
                cBaseRenderer.textFont.setAlign(0);
                for (int i = 0; i < STATS_TEXT.length; ++i) {
                    n7 = cBaseRenderer.textFont.print(this.g, n4, n7, STATS_TEXT[i]);
                }
                n4 = this.getWidth() - 10;
                n7 = n8;
                cBaseRenderer.textFont.setAlign(2);
                n7 = cBaseRenderer.printReallyShortTime(cBaseRenderer.textFont, this.g, n4, n7, this.manager.flyTime);
                n7 = cBaseRenderer.printReallyShortTime(cBaseRenderer.textFont, this.g, n4, n7, this.manager.freeFall);
                n7 = cBaseRenderer.textFont.printNumber(this.g, n4, n7, this.manager.totalDistance / 10000, 4);
                n7 = cBaseRenderer.textFont.printNumber(this.g, n4, n7, this.manager.totalDistance / this.manager.totalTime, 4);
                n7 = cBaseRenderer.textFont.printNumber(this.g, n4, n7, n6, 4);
                n7 = cBaseRenderer.textFont.printNumber(this.g, n4, n7, this.manager.bannanaTotal, 4);
            }
        }
        this.manager.menuText = new int[GAME_MENU_DATA[this.manager.gameType].length];
        n4 = -1;
        n3 = n7 + 5;
        if (this.manager.statsMode == 0) {
            for (n2 = 0; n2 < this.manager.menuText.length; ++n2) {
                this.manager.menuText[n2] = n = GAME_MENU_DATA[this.manager.gameType][n2];
            }
            if (this.manager.gameType == 3 && cEntityManager.multiplayTracking.length == 1) {
                this.manager.menuText[0] = 165;
            }
            if (cPhysicsManager.gameState == 14) {
                this.manager.menuText = new int[2];
                this.manager.menuText[0] = 2;
                this.manager.menuText[1] = 3;
            } else if (cPhysicsManager.gameState == 15 || cPhysicsManager.gameState == 11 || (this.manager.gameType == 2 || this.manager.gameType == 4) && cPhysicsManager.gameState == 15) {
                this.manager.menuText = new int[1];
                this.manager.menuText[0] = 4;
                if (crlCanvas._mDemo) {
                    n4 = 175;
                    this.manager.menuText = new int[2];
                    this.manager.menuText[0] = 3;
                    this.manager.menuText[1] = 2;
                }
            }
        } else {
            this.manager.menuText = new int[2];
            this.manager.menuText[0] = 3;
            this.manager.menuText[1] = 2;
            n4 = 14;
        }
        this.renderOptionsMenu(n4, n3);
    }

    private void renderTimeAttackSummary() {
        int n;
        int n2 = 20;
        cBaseRenderer.headerFont.setAlign(1);
        if (this.manager.totalTime < cPhysicsManager.canvas.timeAttack[this.manager.levelId] || cPhysicsManager.canvas.timeAttack[this.manager.levelId] == 0) {
            n2 = cBaseRenderer.headerFont.print(this.g, this.centerX, n2, 134);
            n2 = cBaseRenderer.printShortTime(cBaseRenderer.headerFont, this.g, this.centerX, n2, this.manager.totalTime);
        } else {
            n2 = cBaseRenderer.headerFont.print(this.g, this.centerX, n2, 135);
            n2 = cBaseRenderer.printShortTime(cBaseRenderer.headerFont, this.g, this.centerX, n2, cPhysicsManager.canvas.timeAttack[this.manager.levelId]);
            int n3 = this.manager.totalTime - cPhysicsManager.canvas.timeAttack[this.manager.levelId];
            cBaseRenderer.headerFont.setAlign(2);
            cBaseRenderer.printReallyShortTime(cBaseRenderer.headerFont, this.g, this.getWidth() - 10, n2 += 10, n3);
            cBaseRenderer.headerFont.setAlign(0);
            n2 = cBaseRenderer.printShortTime(cBaseRenderer.headerFont, this.g, 10, n2, this.manager.totalTime);
        }
        n2 += 10;
        int[] nArray = new int[cEntityManager.multiplayTracking.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n;
        }
        for (n = 0; n < cEntityManager.multiplayTracking.length; ++n) {
            int n4 = nArray[n];
            cBaseRenderer.textFont.setAlign(0);
            cBaseRenderer.textFont.print(this.g, 10, n2, 137 + n);
            cBaseRenderer.textFont.setAlign(1);
            if (cEntityManager.multiplayTracking[n4][5] != 0) {
                cBaseRenderer.printShortTime(cBaseRenderer.textFont, this.g, this.centerX, n2, cEntityManager.multiplayTracking[n4][5]);
                cBaseRenderer.textFont.setAlign(2);
                int n5 = cEntityManager.multiplayTracking[n4][5] - cPhysicsManager.canvas.timeAttack[this.manager.levelId];
                if (n5 == cEntityManager.multiplayTracking[n4][5]) {
                    n5 = 0;
                }
                n2 = cBaseRenderer.printReallyShortTime(cBaseRenderer.textFont, this.g, this.getWidth() - 10, n2, n5);
                continue;
            }
            cBaseRenderer.textFont.print(this.g, this.getWidth() - 10, n2, new byte[]{45, 0});
            n2 = cBaseRenderer.textFont.print(this.g, this.centerX, n2, new byte[]{45, 0});
        }
        this.manager.menuText = new int[1];
        this.manager.menuText[0] = 4;
        this.renderOptionsMenu(-1, n2 + 5);
    }

    private void renderHudBorder(int n, int n2, int n3) {
        this.g.setClip(n, n2 -= 8, n3 - 16, 16);
        this.g.drawImage(this.hud, n, n2, 20);
        this.g.setClip(n + n3 - 16, n2, 17, 16);
        this.g.drawImage(this.hud, n + n3 - 16 - 112, n2, 20);
        this.g.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    private void renderHud() {
        this.renderGameInfo();
        this.renderGoalArrow();
        this.renderMessage();
    }

    private void renderGameInfo() {
        int n = this.getWidth() - 5;
        this.g.drawImage(this.clockImage, this.centerX, 1, 17);
        cBaseRenderer.headerFont.setAlign(1);
        if (this.manager.gameType != 3) {
            int n2 = this.manager.timeLeft;
            if (n2 < 100) {
                n2 = 0;
            }
            if (n2 > 10000 || n2 / 200 % 2 == 0) {
                cBaseRenderer.headerFont.printNumber(this.g, this.centerX, 15, n2 / 1000, 2);
            }
            this.printHudNumber(this.centerX, 29, n2 / 10 % 100, 2, 1);
            this.renderHudBorder(this.getWidth() - 61, 10, 60);
            this.renderHudBorder(this.getWidth() - 61, 30, 60);
            this.face.draw(this.g, this.getWidth() - 40, 10, this.manager.getCharacter());
            this.printHudNumber(n, 10, this.manager.lifeCount, 2, 2);
            this.printHudNumber(n, 30, cPhysicsManager.score, 6, 2);
            this.renderHudBorder(1, 10, 60);
            this.renderHudBorder(1, 30, 60);
            this.printHudNumber(5, 30, this.manager.getRealSpeed(), 3, 0);
            this.hudFont.setAlign(0);
            this.hudFont.print(this.g, 31, 30, 101);
            this.printHudNumber(5, 10, this.manager.bannaCount, 3, 0);
            this.bunch.draw(this.g, 37, 10, 0);
        } else {
            cBaseRenderer.headerFont.printNumber(this.g, this.centerX, 15, this.manager.totalTime / 1000, 3);
            this.printHudNumber(this.centerX, 29, this.manager.totalTime / 10 % 100, 2, 1);
        }
        if (cEntityManager.getLevelType() == 3) {
            cBaseRenderer.headerFont.printNumber(this.g, this.centerX + -30, 180, this.manager.bannanaTotal, 3);
            cBaseRenderer.headerFont.printChar(this.g, this.centerX + -8, 180, (byte)47);
            cBaseRenderer.headerFont.printNumber(this.g, this.centerX + 24, 180, this.manager.levelBannaCount, 3);
        }
        if (this.manager.getState() != 9) {
            this.renderGlideBar();
        }
    }

    private void renderPlayerIndicator() {
        if (this.manager.gameType == 2 || this.manager.gameType == 3 || this.manager.gameType == 4) {
            cBaseRenderer.textFont.setAlign(0);
            cBaseRenderer.textFont.print(this.g, 15, 50, 137 + this.manager.currentPlayer);
        }
    }

    private void printHudNumber(int n, int n2, int n3, int n4, int n5) {
        this.hudFont.setAlign(n5);
        this.hudFont.printNumber(this.g, n, n2, n3, n4);
    }

    private void renderSoftKeys() {
        if (this.manager.getState() == 2 || this.manager.getState() == 10) {
            this.softkeys.draw(this.g, 10, this.getHeight() - 10, 1);
        }
        if (this.manager.getState() != 9) {
            this.softkeys.draw(this.g, this.getWidth() - 10, this.getHeight() - 10, 0);
        }
        if (this.manager.getState() == 1) {
            cBaseRenderer.textFont.setAlign(0);
            cBaseRenderer.textFont.print(this.g, 5, this.getHeight() - 12, 58);
        } else if (this.manager.getState() == 12 || this.manager.getState() == 15 || this.manager.getState() == 11 || this.manager.getState() == 14 || this.manager.getState() == 6 && this.manager.gameType == 3 || this.manager.getState() == 9) {
            cBaseRenderer.textFont.setAlign(0);
            cBaseRenderer.textFont.print(this.g, 5, this.getHeight() - 12, 7);
        }
    }

    private void renderGlideBar() {
        int n = this.manager.glideTime * 100 / this.manager.glideTimeLimit;
        int n2 = (this.getWidth() >> 1) - 50;
        this.renderHudBorder(n2 - 10, this.getHeight() - 10, 120);
        int n3 = 4;
        for (int i = 0; i < n / n3; ++i) {
            int n4 = (i << 8) / 100 * n3;
            int n5 = cBaseRenderer.getFade(0xBB0000, 65280, n4);
            this.g.setColor(n5);
            this.g.fillRect(i * n3 + n2, this.getHeight() - 15, n3, 10);
        }
        this.g.setColor(0xFFFFFF);
    }

    public void triggerMessage(int n) {
        if (n != this.messageIdx) {
            this.messageTimer = cCanvas.time;
            this.messageIdx = n;
            this.msgRendered = false;
        }
    }

    public int getMessageDuration() {
        return cCanvas.time - this.messageTimer;
    }

    private void renderMessage() {
        int n;
        if (this.msgRendered) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getMessageDuration();
        if (n4 >= 4500) {
            this.msgRendered = true;
            return;
        }
        n2 = this.centerX;
        n3 = cFixedPoint.toInt(cFixedPoint.sin(n4 * 7 * 3000 >> 12) * (this.getHeight() >> 1));
        cBaseRenderer.headerFont.setAlign(1);
        switch (this.manager.getState()) {
            case 9: {
                return;
            }
            case 1: {
                break;
            }
            case 2: 
            case 4: 
            case 13: {
                if (this.manager.gameType == 3 || n4 >= 2000 || !this.manager.hitGoal || cEntityManager.getLevelType() == 3) break;
                n = 130;
                if (this.manager.goalAccuracy == 1) {
                    n = 131;
                } else if (this.manager.goalAccuracy == 3) {
                    n = 132;
                }
                cBaseRenderer.headerFont.print(this.g, this.centerX, this.centerY + 25, n);
            }
        }
        n = n3;
        if ((this.manager.gameType == 2 || this.manager.gameType == 3 || this.manager.gameType == 4) && this.messageIdx == 51) {
            n = cBaseRenderer.headerFont.print(this.g, n2, n, 124 + this.manager.currentPlayer);
        }
        cBaseRenderer.headerFont.print(this.g, n2, n, this.messageIdx);
    }

    private void renderLevelIntroMessage() {
        crlString crlString2 = crlResourceManager.mLocaleText[177 + this.manager.getLevelId()];
        cBaseRenderer.headerFont.setAlign(1);
        cBaseRenderer.headerFont.printWrapped(this.g, 20, 65, this.getWidth() - 40, cBaseRenderer.headerFont.getHeight() * 3, crlString2.get(), null, 0);
        if (cPhysicsManager.levelData[this.manager.levelId][2] != -1) {
            this.renderTutorial();
        }
        this.renderMessage();
    }

    private void renderTutorial() {
        int n = this.getWidth() - 10 - 10 - 4;
        int n2 = cPhysicsManager.levelData[this.manager.levelId][2];
        crlString crlString2 = crlResourceManager.mLocaleText[n2 + 238];
        int n3 = 1;
        int n4 = cBaseRenderer.textFont.getHeight();
        int n5 = crlString2.length() - 1;
        byte[] byArray = crlString2.get();
        while (cBaseRenderer.textFont.printWrapped(null, 0, 0, n, n3 * n4, byArray, null, 0) < n5) {
            ++n3;
        }
        int n6 = n4 * n3;
        int n7 = this.getHeight() - n6 - 25;
        this.renderMenuBackground(n7, n6);
        int n8 = 10;
        cBaseRenderer.textFont.printWrapped(this.g, n8, n7 + n4, n, n6, crlString2.get(), null, 0);
    }

    private void renderGoalArrow() {
        int n = -1;
        int n2 = this.goalX - this.cameraX;
        int n3 = this.goalY - this.cameraY;
        int n4 = this.getWidth() - 5 - 20;
        int n5 = this.getHeight() - 10 - 20;
        int n6 = 25;
        int n7 = 50;
        if (n2 > n4) {
            n2 = n4;
            n = 0;
        }
        if (n3 > n5) {
            n3 = n5;
            n = 2;
        }
        if (n2 < n6) {
            n2 = n6;
            n = 4;
        }
        if (n3 < n7) {
            n3 = n7;
            n = 6;
        }
        if (n3 >= n5 && n2 >= n4) {
            n = 1;
        }
        if (n3 >= n5 && n2 <= n6) {
            n = 3;
        }
        if (n3 <= n7 && n2 <= n6) {
            n = 5;
        }
        if (n3 <= n7 && n2 >= n4) {
            n = 7;
        }
        if (n != -1) {
            int n8 = Math.max(Math.abs(this.goalX - this.cameraX), Math.abs(this.goalY - this.cameraY));
            int n9 = 255 - (n8 >> 2);
            if (n9 < 0) {
                n9 = 0;
            }
            int n10 = cBaseRenderer.getFade(0xFF0000, 65280, n9 + cBaseRenderer.bob(0, 60, 20));
            if (cEntityManager.getLevelType() != 3) {
                cBaseRenderer.drawArrow(this.g, n2, n3, n10, n);
            }
        }
        if (this.manager.getState() == 10) {
            cBaseRenderer.drawArrow(this.g, n6, this.getHeight() >> 1, 65280, 9);
            cBaseRenderer.drawArrow(this.g, n4, this.getHeight() >> 1, 65280, 8);
            cBaseRenderer.drawArrow(this.g, this.getWidth() >> 1, n7, 65280, 10);
            cBaseRenderer.drawArrow(this.g, this.getWidth() >> 1, n5, 65280, 11);
        }
    }

    private void renderParticles() {
        this.particles.paint(this.g);
    }

    public void renderOptionsMenu(int n, int n2) {
        if (this.manager.menuSelect > this.manager.menuText.length - 1) {
            this.manager.menuSelect = 0;
        }
        this.renderOptionsMenu(n, this.manager.menuText, this.manager.menuSelect, n2);
    }

    private void renderPauseMenu() {
        if (this.manager.pausePage == 0) {
            int[] nArray = new int[6];
            int n = 0;
            nArray[n++] = 11;
            if (this.manager.gameType == 0 || this.manager.gameType == 3 || this.manager.gameType == 1) {
                nArray[n++] = 40;
            }
            nArray[n++] = 151 + (cCanvas.isMusic ? 0 : 1);
            nArray[n++] = 155 + cCanvas.audioVolume;
            nArray[n++] = 16;
            this.manager.menuText = new int[n];
            System.arraycopy(nArray, 0, this.manager.menuText, 0, n);
            this.renderOptionsMenu(79, 55);
        } else {
            this.manager.menuText = new int[2];
            this.manager.menuText[0] = 3;
            this.manager.menuText[1] = 2;
            this.renderOptionsMenu(14, 55);
        }
    }

    public static int getPrintHeight(crlFont crlFont2, int n, int n2) {
        int n3 = 1;
        crlString crlString2 = crlResourceManager.mLocaleText[n];
        while (crlFont2.printWrapped(null, 0, 0, n2, n3, crlString2.get(), null, 0) < crlString2.length() - 1) {
            n3 += cBaseRenderer.headerFont.getHeight();
        }
        return n3;
    }

    private void renderOptionsMenu(int n, int[] nArray, int n2, int n3) {
        this.manager.menuCount = nArray.length;
        int n4 = (cBaseRenderer.textFont.getHeight() + 0) * nArray.length + 20 + 5;
        int n5 = this.getWidth() - 10 - 10 - 1;
        int n6 = 0;
        if (n != -1) {
            n6 = cGameRenderer.getPrintHeight(cBaseRenderer.headerFont, n, n5);
            n4 += n6 + 3;
        }
        this.renderMenuBackground(n3, n4);
        int n7 = n3 + 20;
        if (n != -1) {
            crlString crlString2 = crlResourceManager.mLocaleText[n];
            cBaseRenderer.headerFont.setAlign(1);
            cBaseRenderer.headerFont.printWrapped(this.g, 10, n7, n5, n6, crlString2.get(), null, 0);
            n7 += 3 + n6;
        }
        cBaseRenderer.textFont.setAlign(1);
        for (int i = 0; i < nArray.length; ++i) {
            if (i == n2) {
                cBaseRenderer.drawArrow(this.g, 25, n7, 0, 8);
                cBaseRenderer.drawArrow(this.g, this.getWidth() - 5 - 20, n7, 0, 9);
            }
            n7 = cBaseRenderer.textFont.print(this.g, this.centerX, n7, nArray[i]) + 0;
        }
    }

    private void renderMenuBackground(int n, int n2) {
        this.g.setColor(6834208);
        this.g.fillRoundRect(5, n, this.getWidth() - 10, n2, 20, 20);
        this.g.setColor(11042880);
        this.g.drawRoundRect(10, n + 5, this.getWidth() - 10 - 10 - 1, n2 - 10 - 1, 15, 15);
    }

    private void renderBackground() {
        if (cPhysicsManager.gameState != 9) {
            cBaseRenderer.parralax.tick(this.duration);
        }
        cBaseRenderer.parralax.draw(this.g, this.cameraX, this.cameraY);
    }

    private void renderPlayer() {
        boolean bl;
        if (this.manager.teleportTimer != -1) {
            return;
        }
        int n = this.manager.playerX;
        int n2 = this.manager.playerY;
        n = cBaseRenderer.toScreenCoord(n << 12);
        n2 = cBaseRenderer.toScreenCoord(n2 << 12);
        int n3 = this.manager.getPlayerBallAngle() % 360;
        if (n3 < 0) {
            n3 += 360;
        }
        int n4 = this.manager.getPlayerDirection();
        int n5 = 0;
        if (n4 == -1) {
            n5 = 8192;
        }
        int n6 = this.drawType;
        this.frameTick += this.duration;
        while (this.frameTick > 100) {
            this.frameTick -= 100;
            ++this.playerAnimFrame;
        }
        boolean bl2 = this.manager.timeStamp - this.manager.jumpTime < 300 && this.manager.timeStamp - this.manager.jumpTime > 100;
        boolean bl3 = bl = bl2 || this.manager.flying;
        if (bl) {
            this.drawType = 6;
            this.playerAnimFrame = this.lifespan / 100 % 2;
            if (!bl2) {
                if (this.manager.flyThrust < 819) {
                    this.playerAnimFrame += 3;
                } else if (this.manager.flyThrust < 1365) {
                    this.playerAnimFrame = 2;
                }
            } else {
                this.playerAnimFrame = 2;
            }
        } else if (this.manager.fallout || this.manager.timeup) {
            this.drawType = 3;
            this.playerAnimFrame = this.lifespan / 200;
            n5 = 0;
        } else if (this.manager.getState() == 6 || this.manager.getState() == 13 || cBaseManager.collisionType == 0 && this.manager.getStateDuration() < 2000 && this.manager.getState() == 2) {
            this.drawType = 5;
        } else if (cBaseManager.collisionType == 0 && this.manager.getCollisionTime() > 300) {
            this.drawType = 2;
        } else if (this.manager.getState() == 4) {
            this.drawType = 4;
            this.playerAnimFrame = this.lifespan / 200;
        } else {
            if (this.drawType == 1) {
                this.playerAnimFrame = this.lifespan / 100 % 8;
                if (n4 == -1) {
                    if (this.manager.character == 2) {
                        n5 = 0;
                    }
                    this.playerAnimFrame = 8 - this.playerAnimFrame;
                }
            } else {
                this.playerAnimFrame = n3 / 60;
            }
            if (this.manager.getRealSpeed() > 60 && this.playerAnimFrame % 8 == 0) {
                this.drawType = 1;
            } else if (this.manager.getRealSpeed() < 30 && this.playerAnimFrame % 8 == 0) {
                this.drawType = 0;
            } else if (this.drawType != 1 && this.drawType != 0) {
                this.drawType = 0;
            }
        }
        if (n6 != this.drawType) {
            this.playerAnimFrame = 0;
        }
        int n7 = Math.abs(this.playerAnimFrame % 8) + this.drawType * 8;
        if (this.manager.character == 2) {
            if (this.drawType == 0 && n4 == -1) {
                this.monkey.draw(this.g, n + 2, n2 + 4, n7, n5);
            } else {
                this.monkey.draw(this.g, n + 3, n2 + 4, n7, n5);
            }
        } else {
            this.monkey.draw(this.g, n, n2, n7, n5);
        }
        if (bl) {
            Image image = this.ballImage.getImage();
            int n8 = 4;
            int n9 = 4;
            this.g.drawRegion(image, n8 * 26, 0, 26, 13, 0, n - 13, n2 - 13, 3);
            this.g.drawRegion(image, n9 * 26, 0, 26, 13, 0, n + 13, n2 - 13, 3);
        } else {
            int n10 = 16 - n3 / 23;
            this.ballImage.draw(this.g, n, n2, n10);
        }
    }

    private void renderPlatformLine(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7) {
        int n8 = n5 / 8;
        if (n8 * 8 < n5) {
            ++n8;
        }
        if (n8 <= 0) {
            return;
        }
        int n9 = (n3 - n << 12) / n8;
        int n10 = (n4 - n2 << 12) / n8;
        ++n8;
        int n11 = n << 12;
        int n12 = n2 << 12;
        int n13 = bl ? n6 : n6 + 7;
        for (int i = 0; i < n8; ++i) {
            this.platform.draw(this.g, n11 >> 12, n12 >> 12, n13);
            n11 += n9;
            n12 += n10;
            if (n7 <= 0) continue;
            n12 = cFixedPoint.mul(n12, n7 + 4096);
        }
    }

    private boolean hasFlag(int n, int n2) {
        return (n & n2) > 0;
    }

    public void generateCamNodes() {
        int n;
        int n2 = 0;
        int[] nArray = this.manager.getObjectList();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != 1) continue;
            n2 = n;
            break;
        }
        n = n2;
        for (int i = 0; i < this.camNodes.length; ++i) {
            this.camNodes[i] = n;
            if (n == -1) continue;
            n = this.manager.getTargetNode(n);
        }
    }

    private void renderObjecBackgrounds() {
        int[] nArray = this.manager.getObjectList();
        cBaseManager.Vector2d[] vector2dArray = this.manager.getObjectLocations();
        block4: for (int i = 0; i < nArray.length; ++i) {
            int n = cBaseRenderer.toScreenCoord(vector2dArray[i].x);
            int n2 = cBaseRenderer.toScreenCoord(vector2dArray[i].y);
            int[] nArray2 = this.manager.getFields(i);
            int n3 = nArray[i];
            switch (n3) {
                case 2: {
                    int n4;
                    int n5;
                    int n6;
                    int n7 = nArray2[2];
                    if (this.hasFlag(n7, 8)) {
                        n6 = nArray2[2] >> 8;
                        for (n5 = i + 1; n5 < nArray.length; ++n5) {
                            int[] nArray3;
                            if (n5 == i || nArray[n5] != 2 || (nArray3 = this.manager.getFields(n5))[2] >> 8 != n6) continue;
                            n4 = cBaseRenderer.toScreenCoord(vector2dArray[n5].x);
                            int n8 = cBaseRenderer.toScreenCoord(vector2dArray[n5].y);
                            cBaseRenderer.drawFatLine(this.g, n - 10, n2, n4 - 10, n8, 0xC0C0C0, 0x808080);
                            cBaseRenderer.drawFatLine(this.g, n + 10, n2, n4 + 10, n8, 0xC0C0C0, 0x808080);
                            continue block4;
                        }
                        continue block4;
                    }
                    if (!this.hasFlag(n7, 128) || (n6 = this.manager.getTargetNode(i)) == -1) continue block4;
                    n5 = cBaseRenderer.toScreenCoord(vector2dArray[n6].x);
                    int n9 = cBaseRenderer.toScreenCoord(vector2dArray[n6].y);
                    cBaseRenderer.drawFatLine(this.g, n, n2, n5, n9, 0xC0C0C0, 0x808080);
                    continue block4;
                }
                case 5: {
                    int n5;
                    int n6 = 1;
                    for (n5 = 0; n5 < this.camNodes.length; ++n5) {
                        if (this.camNodes[n5] != i) continue;
                        n6 = 0;
                        break;
                    }
                    if (n6 == 0 || (n5 = this.manager.getTargetNode(i)) == -1) continue block4;
                    int n10 = cBaseRenderer.toScreenCoord(vector2dArray[n5].x);
                    int n4 = cBaseRenderer.toScreenCoord(vector2dArray[n5].y);
                    cBaseRenderer.drawFatLine(this.g, n, n2, n10, n4, 0xC0C0C0, 0x808080);
                }
            }
        }
    }

    private boolean onScreen(int n, int n2, int n3, int n4) {
        int n5 = n - this.cameraX;
        int n6 = n2 - this.cameraY;
        switch (n3) {
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 15: {
                return n5 >= -50 && n6 >= -50 && n5 <= this.width + 50 && n6 <= this.height + 50;
            }
            case 16: {
                this.goalX = n;
                this.goalY = n2;
            }
            case 18: {
                return n6 >= -50 && n6 <= this.height + 50;
            }
            case 2: {
                int[] nArray = this.manager.getFields(n4);
                int n7 = nArray[4];
                if (n7 != 0 || this.manager.platformAngles[n4] != 0 || n6 >= -50 && n6 <= this.height + 50) break;
                return false;
            }
        }
        return true;
    }

    private void renderGameObjects() {
        int[] nArray = this.manager.getObjectList();
        cBaseManager.Vector2d[] vector2dArray = this.manager.getObjectLocations();
        int n = cBaseRenderer.scaleCoord(cBaseRenderer.bob(0, 5, 20, this.manager.gameDuration));
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block16: for (int i = 0; i < nArray.length; ++i) {
            boolean bl = this.manager.getObjectActive()[i];
            if (bl) {
                n2 = cBaseRenderer.toScreenCoord(vector2dArray[i].x);
                n3 = cBaseRenderer.toScreenCoord(vector2dArray[i].y);
                bl = this.onScreen(n2, n3, nArray[i], i);
            }
            if (!bl) continue;
            int[] nArray2 = this.manager.getFields(i);
            int n5 = nArray[i];
            ++n4;
            switch (n5) {
                case 3: {
                    this.bannana.draw(this.g, n2, n3 + n, this.lifespan / 200);
                    continue block16;
                }
                case 4: {
                    this.bunch.draw(this.g, n2, n3 + n, this.lifespan / 200);
                    continue block16;
                }
                case 2: {
                    this.renderPlatform(i, n2, n3, nArray2);
                    continue block16;
                }
                case 20: {
                    this.renderWall(i);
                    continue block16;
                }
                case 16: {
                    this.renderGoal(i, nArray2);
                    continue block16;
                }
                case 7: {
                    continue block16;
                }
                case 11: {
                    if (i == this.manager.lastCollision && (this.manager.collisionIndex == -1 || this.manager.collisionIndex == this.manager.lastCollision) && this.manager.getCollisionTime() < 300) {
                        this.spike.draw(this.g, n2, n3, 1);
                        continue block16;
                    }
                    this.spike.draw(this.g, n2, n3, 0);
                    continue block16;
                }
                case 6: {
                    if (i == this.manager.lastCollision && (this.manager.collisionIndex == -1 || this.manager.collisionIndex == this.manager.lastCollision) && this.manager.getCollisionTime() < 300) {
                        this.bumper.draw(this.g, n2, n3, 1);
                        continue block16;
                    }
                    this.bumper.draw(this.g, n2, n3, 0);
                    continue block16;
                }
                case 12: {
                    this.renderSwitch(n2, n3, nArray2);
                    continue block16;
                }
                case 18: {
                    this.renderConveyor(i, nArray2);
                    continue block16;
                }
                case 19: {
                    this.renderTrampoline(i, n2, n3);
                    continue block16;
                }
                case 8: {
                    this.renderFan(n2, n3, nArray2);
                    continue block16;
                }
                case 15: {
                    this.teleport.draw(this.g, n2, n3, this.lifespan / 200);
                    continue block16;
                }
                case 21: {
                    int n6 = this.getWidth() - 100;
                    crlString crlString2 = crlResourceManager.mLocaleText[249 + nArray2[2]];
                    cBaseRenderer.textFont.printWrapped(this.g, n2 - n6 / 2, n3 + n, n6, 100, crlString2.get(), null, 0);
                }
            }
        }
    }

    private void renderFan(int n, int n2, int[] nArray) {
        int n3;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = nArray[3];
        int n8 = n;
        int n9 = n2;
        if (n7 < 45 || n7 > 315) {
            n3 = 2;
            n4 = nArray[0] / this.fan.getWidth(n3);
            n5 = this.fan.getHeight(n3);
            n9 += nArray[1];
        } else if (n7 < 135) {
            n3 = 1;
            n4 = nArray[1] / this.fan.getHeight(n3);
            n6 = this.fan.getWidth(n3);
        } else if (n7 < 225) {
            n3 = 3;
            n4 = nArray[0] / this.fan.getWidth(n3);
            n5 = this.fan.getHeight(n3);
            n8 += nArray[0];
        } else {
            n3 = 0;
            n4 = nArray[1] / this.fan.getHeight(n3);
            n6 = this.fan.getWidth(n3);
            n8 += nArray[0];
        }
        ++n4;
        for (int i = 0; i < n4; ++i) {
            this.fan.draw(this.g, n8, n9, n3);
            n8 += n5;
            n9 += n6;
        }
    }

    private void renderWall(int n) {
        int n2 = this.manager.getTargetNode(n);
        if (n2 != -1) {
            int n3 = cBaseManager.getSegmentStart(n);
            cBaseManager.Vector2d vector2d = cBaseManager.line[n3];
            cBaseManager.Vector2d vector2d2 = cBaseManager.line[n3 + 1];
            if (vector2d != null && vector2d2 != null) {
                int n4 = cBaseRenderer.toScreenCoord(vector2d.x);
                int n5 = cBaseRenderer.toScreenCoord(vector2d.y);
                int n6 = cBaseRenderer.toScreenCoord(vector2d2.x);
                int n7 = cBaseRenderer.toScreenCoord(vector2d2.y);
                cBaseRenderer.drawFatLine(this.g, n4, n5, n6, n7, 0xAAAAAA, 0x505050);
            }
        }
    }

    private void renderTrampoline(int n, int n2, int n3) {
        int n4 = 0;
        if (n == this.manager.lastCollision && (this.manager.collisionIndex == -1 || this.manager.collisionIndex == this.manager.lastCollision) && (n4 = 4 - this.manager.getCollisionTime() / 50) < 0) {
            n4 = 0;
        }
        this.trampoline.draw(this.g, n2, n3 + 5, 1);
        this.trampoline.draw(this.g, n2, n3 - n4, 0);
    }

    private void renderSwitch(int n, int n2, int[] nArray) {
        int n3 = 0;
        switch (nArray[1]) {
            case 1: {
                n3 = 180;
                break;
            }
            case 2: {
                n3 = 270;
                break;
            }
            case 3: {
                n3 = 90;
            }
        }
        this.switches.draw(this.g, n, n2, nArray[0], n3);
    }

    private void renderConveyor(int n, int[] nArray) {
        int n2 = cBaseManager.getSegmentStart(n);
        int n3 = cBaseRenderer.toScreenCoord(cBaseManager.line[n2].x);
        int n4 = cBaseRenderer.toScreenCoord(cBaseManager.line[n2].y);
        int n5 = cBaseRenderer.toScreenCoord(cBaseManager.line[n2 + 1].x);
        int n6 = this.lifespan * (nArray[0] > 0 ? 1 : -1) / 100;
        int n7 = -n6 % 3;
        if (n7 < 0) {
            n7 += 3;
        }
        int n8 = n7 = 2 - n7;
        int n9 = 6 + n7;
        int n10 = this.conveyor.getWidth(n9);
        int n11 = n3;
        this.conveyor.draw(this.g, n11, n4, n8);
        n11 += this.conveyor.getWidth(n8);
        int n12 = n7 % 3 + 3;
        int n13 = this.conveyor.getWidth(n12);
        while (n11 < n5 - n10) {
            this.conveyor.draw(this.g, n11, n4, n12);
            n11 += n13;
        }
        this.conveyor.draw(this.g, n11, n4, n9);
    }

    private void renderGoal(int n, int[] nArray) {
        int n2;
        int n3;
        int n4 = cBaseManager.getSegmentStart(n);
        int n5 = cBaseRenderer.toScreenCoord(cBaseManager.line[n4].y) + 4;
        int n6 = nArray[0];
        int n7 = nArray[1];
        int n8 = n3 = nArray[2] >> 1;
        int n9 = nArray[3];
        int n10 = nArray[4];
        int n11 = n2 = cBaseManager.line[n4].x >> 12;
        int n12 = n2 + n6;
        int n13 = n2 + n6 + n7;
        int n14 = n2 + n6 + n7 + n3;
        int n15 = n2 + n6 + n7 + n3 + n8;
        int n16 = n2 + n6 + n7 + n3 + n8 + n9;
        this.renderGoalChunk(n13, n5, n3, 2);
        this.renderGoalChunk(n12, n5, n7, 1);
        this.renderGoalChunk(n11, n5, n6, 0);
        this.renderGoalChunk(n14, n5, n8, 3);
        this.renderGoalChunk(n15, n5, n9, 4);
        this.renderGoalChunk(n16, n5, n10, 5);
    }

    private void renderPlatform(int n, int n2, int n3, int[] nArray) {
        int n4 = nArray[2];
        int n5 = -1;
        boolean bl = false;
        int n6 = cBaseManager.getSegmentStart(n);
        int n7 = this.manager.segCount(n);
        int n8 = 0;
        if (cBaseManager.isFlag(n4, 64) && cBaseManager.collisionTimer[n] != 0 && this.manager.gameDuration - cBaseManager.collisionTimer[n] > 1000) {
            n8 = (this.manager.gameDuration - cBaseManager.collisionTimer[n] - 1000) / 4;
        }
        for (int i = 0; i < n7; ++i) {
            if (n5 == -1) {
                n5 = 2;
                if (this.hasFlag(n4, 8)) {
                    n5 = 6;
                } else if (this.hasFlag(n4, 64)) {
                    n5 = 5;
                } else if (this.hasFlag(n4, 1)) {
                    n5 = 0;
                } else if (this.hasFlag(n4, 16)) {
                    n5 = 3;
                } else if (this.hasFlag(n4, 2)) {
                    n5 = 4;
                } else if (this.hasFlag(n4, 128)) {
                    n5 = 1;
                }
                bl = n == this.manager.closestIndex;
            }
            int n9 = cBaseRenderer.toScreenCoord(cBaseManager.line[n6].x);
            int n10 = cBaseRenderer.toScreenCoord(cBaseManager.line[n6].y);
            int n11 = cBaseRenderer.toScreenCoord(cBaseManager.line[n6 + 1].x);
            int n12 = cBaseRenderer.toScreenCoord(cBaseManager.line[n6 + 1].y);
            int n13 = (this.manager.segLen(n, i) << 12) * (i == 0 && n7 != 2 ? 2 : 1);
            int n14 = cBaseRenderer.toScreenCoord(n13);
            this.renderPlatformLine(n9, n10, n11, n12, n14, n5, bl, n8);
            ++n6;
        }
        if (n5 != -1 && n8 == 0) {
            this.g.drawImage(this.pivot, n2, n3 + 1, 3);
        }
    }

    private void renderCharVector(int n, cBaseManager.Vector2d vector2d, int n2) {
        cBaseManager.Vector2d vector2d2 = cBaseManager.scale(vector2d, n2 << 12);
        vector2d2 = cBaseManager.add(vector2d2, cBaseManager.player);
        this.renderVector(n, vector2d2, cBaseManager.player);
    }

    private void renderVector(int n, cBaseManager.Vector2d vector2d, cBaseManager.Vector2d vector2d2) {
        this.g.setColor(n);
        int n2 = cBaseRenderer.toScreenCoord(vector2d.x);
        int n3 = cBaseRenderer.toScreenCoord(vector2d.y);
        int n4 = cBaseRenderer.toScreenCoord(vector2d2.x);
        int n5 = cBaseRenderer.toScreenCoord(vector2d2.y);
        this.g.drawLine(n2, n3, n4, n5);
    }

    private void renderGoalChunk(int n, int n2, int n3, int n4) {
        n = cBaseRenderer.scaleCoord(n);
        n3 = cBaseRenderer.scaleCoord(n3);
        int n5 = n3 / 12;
        int n6 = n3 - 12 * n5;
        if (n5 < 2) {
            n5 = 2;
        }
        if (n4 > 2) {
            int n7 = n5 + 1;
            if (n4 == 5) {
                ++n7;
            }
            n4 = 3 - n4 + 2;
            for (int i = 0; i < n7; ++i) {
                int n8 = n + 12 * i;
                if (n8 > this.width + this.cameraX + 6) {
                    return;
                }
                int n9 = n4 * 3;
                if (i == 0) {
                    n9 += 2;
                } else if (i != n7 - 1) {
                    ++n9;
                }
                this.goal.draw(this.g, n8, n2, n9, 8192);
            }
        } else {
            int n10 = 0;
            if (n4 == 0) {
                --n10;
            }
            for (int i = n5; i >= n10; --i) {
                int n11 = n + 12 * i;
                if (n11 < this.cameraX - 6) {
                    return;
                }
                int n12 = n4 * 3;
                if (i == n5) {
                    n12 += 2;
                } else if (i != n10) {
                    ++n12;
                }
                this.goal.draw(this.g, n11, n2, n12, 0);
            }
        }
    }

    public void triggerGoal() {
        this.particles.createSpawn(this.manager.playerX - 20, this.manager.playerY - 30, 0);
        this.particles.createSpawn(this.manager.playerX + 20, this.manager.playerY - 30, 0);
    }

    public void triggerEntry() {
        this.particles.createSpawn(this.manager.playerX - 20, this.manager.playerY - 20, 4);
    }

    public void triggerEndStars() {
        int n = this.manager.playerX - 17;
        int n2 = this.manager.playerY - 17;
        if (this.starParticle == -1 || !this.particles.spawnActive[this.starParticle]) {
            this.starParticle = this.particles.createSpawn(n, n2, 1);
        } else if (this.starParticle != -1) {
            this.particles.setSpawnLocation(this.starParticle, n, n2);
        }
    }

    public void triggerCollectStars(int n, int n2) {
        this.particles.createSpawn(n, n2, 2);
    }

    public void triggerTeleportParticles(int n, int n2) {
        int n3 = n - (cMonkeyParticle.TYPE_INFO[5][0] >> 1);
        int n4 = n2 - (cMonkeyParticle.TYPE_INFO[5][1] >> 1);
        this.particles.createSpawn(n3, n4, 5);
    }

    public void triggerSparks() {
        if (this.sparkParticle == -1 || !this.particles.spawnActive[this.sparkParticle]) {
            this.sparkParticle = this.particles.createSpawn(this.manager.playerX, this.manager.playerY + 17, 3);
        }
    }
}

