/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import Coral.Audio.crlAudioManager;
import Coral.Graphics2D.crlFont;
import Coral.Graphics2D.crlImagePacked;
import Coral.Util.crlResourceManager;
import Coral.Util.crlString;
import Coral.Util.crlUtil;
import Coral.crlCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import monkey.Monkey;
import monkey.cBaseManager;
import monkey.cBaseRenderer;
import monkey.cEntityManager;
import monkey.cGameRenderer;
import monkey.cMenu;
import monkey.cPhysicsManager;
import monkey.cSponge;

public class cCanvas
extends crlCanvas {
    static final int MBOOSTER_MAX_INSTANCES = 1;
    public static final boolean GAME_JUMP = false;
    public static final int JUMP_LEVEL = 32;
    public static final int DEBUG_PLAYERX = -1;
    public static final int DEBUG_PLAYERY = 400;
    public static final boolean DEBUG_FLYING = false;
    public static final int DEBUG_PLAYER_DELTAX = -1;
    public static final int DEBUG_PLAYER_DELTAY = 0;
    public static final boolean DEFAULT_CHEAT = false;
    public static final boolean GRAPHICS_DEBUG = false;
    public static final boolean LEVEL_DEBUG = false;
    public static final boolean PERF_DEBUG = false;
    public static final boolean KEY_DEBUG = false;
    public static final boolean HEAP_DEBUG = false;
    public static final boolean CUSTOM_DEBUG = false;
    public static final int TITLE_LOGO_X = 88;
    public static final int TITLE_LOGO_Y = 184;
    public static final String RMS_NAME = "a";
    public static final String[] LANGUAGE_STRINGS = new String[]{"en", "fr", "it", "de", "es"};
    public static final int INITAL_CHARS = 6;
    public static final int TABLE_ENTRIES = 6;
    public static final int VERSION_LANG_MASK = 31;
    public static final long[][] FRONTEND_PACKS = new long[][]{cSponge.PACK_FRONTEND, cSponge.PACK_BACKGROUND_GROUND, cSponge.PACK_BACKGROUND_SKY, cSponge.PACK_BACKGROUND_SPACE, cSponge.PACK_BALLS, cSponge.PACK_CHARACTERS, cSponge.PACK_IN_GAME_GRAPHICS, cSponge.PACK_LEVEL_FILES, cSponge.PACK_FRONTEND_SFX, cSponge.PACK_IN_GAME_SFX, cSponge.PACK_MUSIC};
    public static final long[][] KEEP_PACKS = new long[][]{cSponge.PACK_COMMON, cSponge.PACK_MUSIC, cSponge.PACK_IN_GAME_SFX, cSponge.PACK_FRONTEND_SFX};
    public static final byte[] DEFAULT_INITALS = new byte[]{65, 73, 65, 73, 0, 0, 0};
    public static final int[] DEFAULT_SCORES = new int[]{300000, 200000, 100000, 50000, 25000, 10000};
    public static final int LEVEL_SPACE = 0;
    public static final int LEVEL_SKY = 1;
    public static final int LEVEL_GROUND = 2;
    public static final int LEVEL_SPECIAL = 3;
    public static final int MUSIC_CHANNEL = 0;
    public static final int SFX_FRONTEND_AIAI = 1;
    public static final int SFX_FRONTEND_MEEMEE = 2;
    public static final int SFX_FRONTEND_BABY = 3;
    public static final int SFX_FRONTEND_GONGON = 4;
    public static final int SFX_FRONTEND_SELECT = 5;
    public static final int JINGLE_INGAME_FAIL = 1;
    public static final int JINGLE_INGAME_SUCCEED = 2;
    public static final int SFX_INGAME_1UP = 3;
    public static final int SFX_INGAME_BOUNCE = 4;
    public static final int AUDIO_CHANNELS = 6;
    public static final int MUSIC_FRONTEND = 0;
    public static final int MUSIC_SPACE = 1;
    public static final int MUSIC_SKY = 2;
    public static final int MUSIC_GROUND = 3;
    public static final int MUSIC_BONUS = 4;
    public static final int[] GAME_AUDIO_TYPES = new int[]{1, 1, 1, 3, 3};
    public static final int[] FRONTEND_AUDIO_TYPES = new int[]{1, 3, 3, 3, 3, 3};
    public static final int VIBRATE_BOUNCE_HARD = 300;
    public static final int VIBRATE_BOUNCE_SOFT = 100;
    public static final int VIBRATE_FALLOUT_LENGTH = 1000;
    public static final int VIBRATE_UI_TEST = 500;
    public static final int VIBRATE_BUNCH = 250;
    public static final int NUM_CHARS = 4;
    public static final int COMPLETE_LEVELS = 8;
    public static final int SPECIAL_START = 11;
    public static final int SCORE_TABLES = 4;
    public static final int STATS_PLAYTIME = 0;
    public static final int STATS_BANANAS_COLLECTED = 1;
    public static final int STATS_GLIDE_TIME = 2;
    public static final int STATS_LEVELS_ATTEMPTED = 3;
    public static final int STATS_TARGETSCORE = 4;
    public static final int STATS_FREEFALL_TIME = 5;
    public static final int STATS_AVE_SPEED = 6;
    public static final int STATS_OBJECTS_HIT = 7;
    public static final int STATS_DISTANCE = 8;
    public static final int STATS_TOTAL_ENTRIES = 9;
    public Monkey gameMidlet;
    public cMenu _menu;
    public crlAudioManager _audioManager;
    boolean repaintNeeded;
    private cGameRenderer renderer;
    private cEntityManager entityManager;
    public int frameCounter;
    private int postLoadState;
    private int stateTime;
    public int[][] scoreTable;
    public byte[][][] initalTable;
    public int[] timeAttack;
    public int[] levelScores;
    public int[] statsTable;
    public int charLock;
    public static int time;
    public static long longTime;
    public boolean cheat = false;
    long[] totalPack;
    int loadState;
    public static int audioVolume;
    public static boolean isMusic;
    public static int currentTune;
    int timeSum = 0;
    int lastFps = 0;
    Image logo;
    Image loading;
    Image title;
    boolean appPaused;
    public static int totalHeap;
    public static int peakHeap;
    public static String customString;
    boolean playPending;
    int pause = 0;
    int resume = 0;
    public static final long[][] PARRALAX;
    public static final int ANY_KEY_Y = 20;

    public cCanvas(Monkey monkey) {
        this.gameMidlet = monkey;
    }

    public void pause() {
        try {
            if (!this.appPaused) {
                this.appPaused = true;
                ++this.pause;
                if (crlCanvas.mGameState == 9) {
                    this.entityManager.pause();
                } else if (crlCanvas.mGameState == 5) {
                    this.entityManager.pauseNeeded = true;
                }
                if (this._audioManager != null && crlCanvas.mGameState != 9) {
                    this._audioManager.stopAllAudio();
                    this._audioManager.update();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void reset() {
    }

    public void resume() {
        try {
            if (this.appPaused) {
                ++this.resume;
                if (this._audioManager != null && (crlCanvas.mGameState == 8 || crlCanvas.mGameState == 7)) {
                    this.playPending = true;
                }
            }
            crlUtil.wait(500);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void quitApp() {
        if (this._audioManager != null) {
            this._audioManager.close();
        }
        this.saveRmsData();
        this.gameMidlet.quitApp();
    }

    private void setState(int n) {
        this.repaintNeeded = true;
        crlCanvas.mGameState = n;
        this.stateTime = time;
        cBaseRenderer.resetFade();
    }

    private boolean handlePostInterrupts() {
        if (crlCanvas.mGameState == 9) {
            this.appPaused = false;
            this.playPending = false;
            if (this._audioManager != null) {
                this._audioManager.update();
            }
            return false;
        }
        if (this.appPaused && this.playPending) {
            if (cCanvas.hasKey(256) || cCanvas.hasKey(16)) {
                this.appPaused = false;
                crlCanvas.resetKeys();
                this.loadMenuAudio();
            } else if (this._audioManager != null) {
                this._audioManager.stopAllAudio();
            }
            return true;
        }
        if (this._audioManager != null) {
            this._audioManager.update();
        }
        if (this.playPending && !this.appPaused) {
            this.playMusic();
            this._audioManager.update();
            this.playPending = !this._audioManager.isStarted(0);
        }
        return false;
    }

    protected void cnvsUpdate() {
        this.repaintNeeded = true;
        try {
            longTime = crlCanvas._mStartTime;
            time = (int)crlCanvas._mStartTime;
            if (time < 0) {
                time += Integer.MAX_VALUE;
            }
            if (this.handlePostInterrupts()) {
                return;
            }
            switch (crlCanvas.mGameState) {
                case 2: {
                    crlCanvas.setPaintReady(true);
                    this.setState(4);
                    break;
                }
                case 0: {
                    this.init();
                    this.setState(2);
                    break;
                }
                case 9: {
                    this.renderer.setWidth(crlCanvas._mWidth);
                    this.renderer.setHeight(crlCanvas._mHeight);
                    this.renderer.manager = this.entityManager;
                    this.entityManager.renderer = this.renderer;
                    this.updateGame();
                    break;
                }
                case 8: {
                    this._menu.update(crlCanvas.mPad);
                    break;
                }
                case 7: {
                    if (crlCanvas.mPad != 0) {
                        this.setState(8);
                        crlCanvas.resetKeys();
                    }
                    break;
                }
                case 15: {
                    this.repaintNeeded = true;
                    if (cBaseRenderer.fadeComplete()) {
                        this.setState(this.loadState);
                        crlCanvas.gResourceManager.loadPack(this.totalPack);
                    }
                    crlCanvas._mTriggerPaintUI = true;
                    break;
                }
                case 14: {
                    long l;
                    this.repaintNeeded = true;
                    crlCanvas._mTriggerPaintUI = true;
                    if (crlCanvas.gResourceManager.currentPackPos > 0 && ((l = crlCanvas.gResourceManager.currentPack[crlCanvas.gResourceManager.currentPackPos - 1]) == 950920350031903L || l == 965431950256062L || l == 981028516547753L || l == 992811229569321L || l == 170623864237402L)) {
                        crlImagePacked crlImagePacked2 = crlCanvas.gResourceManager.getIMPByID(l);
                        crlImagePacked2.createFlip();
                    }
                    if (crlCanvas.gResourceManager.getStatus() == 2 && crlCanvas.gResourceManager.currentPack.length >= crlCanvas.gResourceManager.currentPackPos && crlCanvas.gResourceManager.currentPack.length > 0) {
                        this.setState(this.postLoadState);
                        this.postMenuLoad();
                        this.playPending = true;
                    }
                    break;
                }
                case 5: {
                    if (crlCanvas.gResourceManager.getStatus() == 2) {
                        this.setState(this.postLoadState);
                        cBaseRenderer.resetFade();
                    }
                    break;
                }
                default: {
                    crlCanvas.setPaintReady(true);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        crlCanvas._mPaintReady = true;
        crlUtil.wait(5);
    }

    private void postMenuLoad() {
        this._menu.postLoadSetup();
        this.loadMenuAudio();
        if (cBaseRenderer.parralax == null) {
            int n = 2;
            while (this.zoneLocked(n)) {
                --n;
            }
            cBaseRenderer.loadParralax(this.screenWidth(), this.screenHeight(), n, true);
        }
    }

    public void doMenuLoading(boolean bl) {
        int n;
        long[][] lArrayArray = new long[FRONTEND_PACKS.length + 1][];
        int n2 = 8;
        if (bl) {
            n2 = 7;
        }
        for (n = 0; n < FRONTEND_PACKS.length; ++n) {
            lArrayArray[n] = FRONTEND_PACKS[n];
        }
        if (bl || cBaseRenderer.parralax == null) {
            n = 2;
            while (this.zoneLocked(n)) {
                --n;
            }
            lArrayArray[cCanvas.FRONTEND_PACKS.length] = PARRALAX[n];
        } else {
            lArrayArray[cCanvas.FRONTEND_PACKS.length] = PARRALAX[cBaseRenderer.parralax.getType()];
        }
        this.doLoading(lArrayArray, n2, 14);
    }

    public void doLoading(long[][] lArray, int n, int n2) {
        this.pauseAudio();
        if (this.entityManager != null) {
            this.entityManager = null;
        }
        if (this.renderer != null) {
            this.renderer.destroy();
            this.renderer = null;
        }
        this.postLoadState = n;
        this.loadState = n2;
        this.setState(this.loadState);
        this.totalPack = this.mergePacks(lArray);
        cBaseRenderer.resetFade();
        crlCanvas.gResourceManager.loadPack(this.totalPack);
    }

    private long[] mergePacks(long[][] lArray) {
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == null) continue;
            n += lArray[i].length;
        }
        long[] lArray2 = new long[n];
        int n2 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == null) continue;
            for (int j = 0; j < lArray[i].length; ++j) {
                lArray2[n2] = lArray[i][j];
                ++n2;
            }
        }
        return lArray2;
    }

    private void updateGame() {
        if (!this.entityManager.update()) {
            this.saveRmsData();
            this.doMenuLoading(false);
        }
    }

    private void renderGame(Graphics graphics) {
        this.renderer.render(graphics);
    }

    public void menuMode(int n) {
        this._menu.pushMode(n);
    }

    public int getStateDuration() {
        return time - this.stateTime;
    }

    protected void render(Graphics graphics) {
        try {
            ++this.frameCounter;
            if (this.appPaused && this.playPending && graphics != null) {
                this.renderResumeScreen(graphics);
                this.printDebugInfo(graphics);
                return;
            }
            switch (crlCanvas.mGameState) {
                case 8: 
                case 10: 
                case 11: {
                    this._menu.render(graphics);
                    break;
                }
                case 4: {
                    this._menu.setGraphics(graphics);
                    crlCanvas._mTriggerPaintUI = true;
                    switch (this._menu.renderLanguageSelect(31, crlCanvas.mPad)) {
                        case 1: {
                            crlCanvas.gResourceManager.initStrings(250, 223, 222, 223);
                            this.setState(3);
                            break;
                        }
                        case 0: {
                            this.quitApp();
                        }
                    }
                    break;
                }
                case 3: {
                    this._menu.setGraphics(graphics);
                    crlCanvas._mTriggerPaintUI = true;
                    int n = this._menu.renderAudioEnable(crlCanvas.mPad);
                    if (n == -1) break;
                    if (n == 0) {
                        audioVolume = 0;
                    } else if (audioVolume == 0) {
                        audioVolume = 2;
                    }
                    this.setState(6);
                    break;
                }
                case 6: {
                    this._menu.setGraphics(graphics);
                    if (!this._menu.renderSplash(cSponge.PACK_SPLASH_SCREENS, new int[]{0xFFFFFF, 0xFFFFFF}, 3)) break;
                    this.doMenuLoading(true);
                    break;
                }
                case 7: {
                    this.drawTitleScreen(graphics);
                    break;
                }
                case 15: {
                    crlCanvas._mTriggerPaintUI = true;
                    graphics.setColor(0xFFFFFF);
                    graphics.fillRect(0, 0, this.screenWidth(), this.screenHeight());
                    break;
                }
                case 14: {
                    this.drawProgress(graphics, crlCanvas.gResourceManager.getCurrentPackProgress());
                    break;
                }
                case 5: {
                    this.drawProgress(graphics, crlCanvas.gResourceManager.getCurrentPackProgress());
                    break;
                }
                case 9: {
                    this.renderGame(graphics);
                    break;
                }
            }
            if (!(cBaseRenderer.fadeComplete() && crlCanvas.mGameState != 6 || crlCanvas.mGameState == 5 || crlCanvas.mGameState == 14)) {
                cBaseRenderer.doFade(graphics, true, 0xFFFFFF);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.printDebugInfo(graphics);
    }

    private void renderResumeScreen(Graphics graphics) {
        try {
            if (graphics == null || cBaseRenderer.textFont == null || cBaseRenderer.headerFont == null || crlResourceManager.mLocaleText == null) {
                return;
            }
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.screenWidth(), this.screenHeight());
            if (this.logo != null) {
                graphics.drawImage(this.logo, this.screenWidth() >> 1, this.screenHeight() >> 2, 3);
            }
            cBaseRenderer.textFont.setAlign(0);
            cBaseRenderer.textFont.print(graphics, 0, this.screenHeight() - 10, 7);
            int[] nArray = new int[]{11};
            int n = cBaseRenderer.textFont.getHeight() * nArray.length + 20 + 5;
            int n2 = this.screenWidth() - 10 - 10 - 1;
            int n3 = 79;
            int n4 = 0;
            if (n3 != -1) {
                n4 = cGameRenderer.getPrintHeight(cBaseRenderer.headerFont, n3, n2);
                n += n4 + 3;
            }
            graphics.setColor(6834208);
            graphics.fillRoundRect(5, this.screenHeight() >> 1, this.screenWidth() - 10, n, 20, 20);
            graphics.setColor(11042880);
            graphics.drawRoundRect(10, (this.screenHeight() >> 1) + 5, this.screenWidth() - 10 - 10 - 1, n - 10 - 1, 15, 15);
            int n5 = (this.screenHeight() >> 1) + 20;
            crlString crlString2 = crlResourceManager.mLocaleText[n3];
            cBaseRenderer.headerFont.setAlign(1);
            cBaseRenderer.headerFont.printWrapped(graphics, 10, n5, n2, n4, crlString2.get(), null, 0);
            cBaseRenderer.textFont.setAlign(1);
            cBaseRenderer.drawArrow(graphics, 25, n5 += 3 + n4, 0, 8);
            cBaseRenderer.drawArrow(graphics, this.screenWidth() - 5 - 20, n5, 0, 9);
            n5 = cBaseRenderer.textFont.print(graphics, this.screenWidth() >> 1, n5, nArray[0]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void checkHeap() {
        totalHeap = (int)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        if (totalHeap > peakHeap) {
            peakHeap = totalHeap;
        }
    }

    public static String getHeapString() {
        return totalHeap / 1024 + "/" + peakHeap / 1024 + "/" + Runtime.getRuntime().totalMemory() / 1024L + " kb";
    }

    private void printDebugInfo(Graphics graphics) {
        int n = 20;
    }

    private void debugString(Graphics graphics, String string, int n, int n2) {
        graphics.setColor(0);
        graphics.drawString(string, n, n2, 20);
        graphics.setColor(65280);
        graphics.drawString(string, n + 1, n2 + 1, 20);
    }

    private void drawProgress(Graphics graphics, int n) {
        int n2;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.screenWidth(), this.screenHeight());
        int n3 = 1;
        int n4 = this.screenWidth() * n / 100 / n3;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = n2 * n3;
            int n6 = cBaseRenderer.getFade(13755638, 5217472, n5);
            graphics.setColor(n6);
            graphics.fillRect(n2 * n3, this.screenHeight() / 2, n3, 16);
        }
        if (this.loading == null) {
            this.loading = crlCanvas.gResourceManager.getImageByID(949868374678751L);
        }
        n2 = 0;
        while (n2 - this.loading.getWidth() < this.screenWidth()) {
            graphics.drawImage(this.loading, n2, this.screenHeight() / 2, 20);
            n2 += this.loading.getWidth();
        }
        if (this.logo == null) {
            this.logo = crlCanvas.gResourceManager.getImageByID(937994450610060L);
        }
        if (this.logo != null) {
            graphics.drawImage(this.logo, this.screenWidth() >> 1, this.screenHeight() >> 2, 3);
        }
        if (crlResourceManager.mLocaleText != null) {
            crlString crlString2 = crlResourceManager.mLocaleText[9];
            if (cBaseRenderer.textFont == null) {
                graphics.drawString(crlString2.toString(), this.screenWidth() >> 1, (this.screenHeight() >> 1) + 25, 17);
            } else {
                cBaseRenderer.textFont.setAlign(1);
                cBaseRenderer.textFont.print(graphics, this.screenWidth() >> 1, (this.screenHeight() >> 1) + 25, 9);
            }
        }
    }

    private void drawTitleScreen(Graphics graphics) {
        if (this.title == null) {
            this.title = crlCanvas.gResourceManager.getImageByID(25546854654196L);
        }
        if (this.logo == null) {
            this.logo = crlCanvas.gResourceManager.getImageByID(937994450610060L);
        }
        if (this.title != null && this.logo != null) {
            graphics.drawImage(this.title, 0, 0, 20);
            graphics.drawImage(this.logo, 88, 184, 33);
        }
        crlFont crlFont2 = cBaseRenderer.textFont;
        crlFont2.setAlign(1);
        if (time / 300 % 2 == 0) {
            crlFont2.print(graphics, this.screenWidth() >> 1, this.screenHeight() - 20, 96);
        }
    }

    private void init() {
        try {
            cCanvas.checkHeap();
            this._menu = new cMenu(this);
            this.loadRmsData();
            this.loadBaseAssets();
            cBaseRenderer.initCommonAssets();
            this._menu.open(this, 3, cMenu.uiDesign, 5);
            this._menu.setMode(-16);
            this._menu.pushMode(-16);
            if (this._audioManager == null) {
                this.initAudio();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void loadBaseAssets() throws Exception {
        int n;
        crlCanvas.gResourceManager.setFileData("/", "");
        crlCanvas.gResourceManager.open(237802, 108, 18518, "data.spg");
        long[] lArray = new long[cSponge.PACK_SPLASH_SCREENS.length + 1 + cSponge.PACK_COMMON.length];
        lArray[0] = -4294967296L;
        for (n = 0; n < cSponge.PACK_SPLASH_SCREENS.length; ++n) {
            lArray[n + 1] = cSponge.PACK_SPLASH_SCREENS[n];
        }
        for (n = 0; n < cSponge.PACK_COMMON.length; ++n) {
            lArray[n + 1 + cSponge.PACK_SPLASH_SCREENS.length] = cSponge.PACK_COMMON[n];
        }
        crlCanvas.gResourceManager.loadPack(lArray);
        for (n = 0; n < lArray.length; ++n) {
            crlCanvas.gResourceManager.update();
        }
        cPhysicsManager.loadLevelSettings();
    }

    private int[] getRandomList() {
        int n;
        int[] nArray = new int[15];
        int n2 = 3;
        int n3 = nArray.length / n2;
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < n2; ++n) {
            int n4 = this.getTypeStart(n);
            int n5 = this.getTypeEnd(n, n4);
            for (int i = 0; i < n3; ++i) {
                int n6 = n * n3 + i;
                int n7 = 0;
                boolean bl = false;
                block3: do {
                    bl = false;
                    n7 = crlUtil.randInt(n4, n5);
                    for (int j = 0; j < nArray.length; ++j) {
                        if (nArray[j] != n7) continue;
                        bl = true;
                        continue block3;
                    }
                } while (bl);
                nArray[n6] = n7;
            }
        }
        return nArray;
    }

    public void startLevel(int n, int n2, int n3) {
        this._menu.multiCharSelect = 0;
        long[] lArray = new long[]{cSponge.PACK_CHARACTERS[n2]};
        int[] nArray = null;
        if (n3 == 4) {
            nArray = this.getRandomList();
            n = nArray[0];
        }
        long[] lArray2 = new long[]{};
        switch (cPhysicsManager.levelData[n][0]) {
            case 0: {
                currentTune = 1;
                lArray2 = cSponge.PACK_BACKGROUND_SPACE;
                break;
            }
            case 1: {
                currentTune = 2;
                lArray2 = cSponge.PACK_BACKGROUND_SKY;
                break;
            }
            case 2: {
                currentTune = 3;
                lArray2 = cSponge.PACK_BACKGROUND_GROUND;
            }
        }
        long[] lArray3 = new long[]{cSponge.PACK_LEVEL_FILES[n]};
        long[][] lArrayArray = new long[][]{lArray, cSponge.PACK_IN_GAME_GRAPHICS, {cSponge.PACK_BALLS[0]}, lArray2, lArray3, cSponge.PACK_IN_GAME_SFX, {cSponge.PACK_MUSIC[currentTune]}};
        if (n3 == 2 || n3 == 3 || n3 == 4) {
            lArrayArray = new long[][]{lArray, cSponge.PACK_IN_GAME_GRAPHICS, cSponge.PACK_BALLS, lArray2, lArray3, cSponge.PACK_IN_GAME_SFX, {cSponge.PACK_MUSIC[currentTune]}};
        }
        lArrayArray = new long[][]{lArray3, lArray2};
        this.doLoading(lArrayArray, 9, 5);
        this.renderer = new cGameRenderer();
        this.renderer.create();
        this.entityManager = new cEntityManager(this);
        this.entityManager.create();
        this.entityManager.setGameType(n3);
        this.entityManager.setCharacter(n2);
        if (n3 == 4) {
            this.entityManager.setLevelList(nArray);
        } else if (n3 == 2 && n == cMenu.SPECIAL_MENU_LEVEL_MAP[0]) {
            this.entityManager.setLevelList(cMenu.SPECIAL_MENU_LEVEL_MAP);
        }
        this.entityManager.setLevelId(n);
        if (n3 == 2 || n3 == 3 || n3 == 4) {
            this.entityManager.setChallengeChars(cMenu.multiPlayerCharacters);
        }
    }

    public void resetRmsData(boolean bl) {
        this.statsTable = new int[9];
        this.levelScores = new int[cSponge.PACK_LEVEL_FILES.length];
        this.timeAttack = new int[cSponge.PACK_LEVEL_FILES.length];
        this.scoreTable = new int[4][6];
        this.initalTable = new byte[4][6][7];
        for (int i = 0; i < DEFAULT_SCORES.length; ++i) {
            this.setTypeScore(1, DEFAULT_SCORES[i], DEFAULT_INITALS);
            this.setTypeScore(0, DEFAULT_SCORES[i], DEFAULT_INITALS);
            this.setTypeScore(2, DEFAULT_SCORES[i], DEFAULT_INITALS);
            this.setTypeScore(3, DEFAULT_SCORES[i], DEFAULT_INITALS);
        }
    }

    public void loadRmsData() {
        byte[] byArray = this.loadRmsData(RMS_NAME);
        if (byArray == null) {
            this.resetRmsData(true);
            audioVolume = 2;
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            try {
                int n;
                this.statsTable = new int[9];
                this.scoreTable = new int[4][6];
                this.initalTable = new byte[4][6][7];
                this.timeAttack = new int[cSponge.PACK_LEVEL_FILES.length];
                this.levelScores = new int[cSponge.PACK_LEVEL_FILES.length];
                for (n = 0; n < this.statsTable.length; ++n) {
                    this.statsTable[n] = dataInputStream.readInt();
                }
                for (n = 0; n < this.scoreTable.length; ++n) {
                    for (int i = 0; i < 6; ++i) {
                        this.scoreTable[n][i] = dataInputStream.readInt();
                        dataInputStream.read(this.initalTable[n][i], 0, 7);
                    }
                }
                for (n = 0; n < this.timeAttack.length; ++n) {
                    this.timeAttack[n] = dataInputStream.readInt();
                    this.levelScores[n] = dataInputStream.readInt();
                }
                audioVolume = dataInputStream.readInt();
                isMusic = dataInputStream.readBoolean();
                dataInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Throwable throwable) {
                this.resetRmsData(true);
                audioVolume = 2;
                this.saveRmsData();
            }
        }
    }

    public void saveRmsData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n;
            for (n = 0; n < this.statsTable.length; ++n) {
                dataOutputStream.writeInt(this.statsTable[n]);
            }
            for (n = 0; n < this.scoreTable.length; ++n) {
                for (int i = 0; i < 6; ++i) {
                    dataOutputStream.writeInt(this.scoreTable[n][i]);
                    ((OutputStream)dataOutputStream).write(this.initalTable[n][i]);
                }
            }
            for (n = 0; n < this.timeAttack.length; ++n) {
                dataOutputStream.writeInt(this.timeAttack[n]);
                dataOutputStream.writeInt(this.levelScores[n]);
            }
            dataOutputStream.writeInt(audioVolume);
            dataOutputStream.writeBoolean(isMusic);
            dataOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.saveRmsData(RMS_NAME, byArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private byte[] loadRmsData(String string) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            recordStore.closeRecordStore();
            return byArray;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void saveRmsData(String string, byte[] byArray) {
        try {
            try {
                RecordStore.deleteRecordStore((String)string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            try {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            catch (Throwable throwable) {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void incrementStat(int n, int n2) {
        int n3 = n;
        this.statsTable[n3] = this.statsTable[n3] + n2;
    }

    public boolean isHiScore(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < 6 && n2 < this.scoreTable[n][n3]; ++n3) {
        }
        return n3 < 6;
    }

    public int sumScore(int n) {
        int n2 = this.getTypeStart(n);
        int n3 = this.getTypeEnd(n);
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            n4 += this.levelScores[i];
        }
        return n4;
    }

    public boolean isSpecial(int n) {
        for (int i = 0; i < cMenu.SPECIAL_MENU_LEVEL_MAP.length; ++i) {
            if (cMenu.SPECIAL_MENU_LEVEL_MAP[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean completed(int n) {
        return n >= 0 && n < this.levelScores.length && this.levelScores[n] != 0;
    }

    public boolean scoreLevel(int n, int n2) {
        if (this.levelScores[n2] < n) {
            this.levelScores[n2] = n;
            return true;
        }
        return false;
    }

    public boolean randomLocked() {
        if (!crlCanvas._mDemo && this.cheat) {
            return false;
        }
        if (this.specialLocked()) {
            return true;
        }
        for (int i = 0; i < this.levelScores.length; ++i) {
            if (this.completed(i)) continue;
            return true;
        }
        return false;
    }

    public boolean zoneLocked(int n) {
        if (n == 0 || this.cheat) {
            return false;
        }
        if (crlCanvas._mDemo && n > 0) {
            return true;
        }
        return this.completedCount(n - 1) < 8;
    }

    public boolean specialLocked() {
        return this.zoneLocked(3);
    }

    public int completedCount(int n) {
        int n2 = this.getTypeStart(n);
        int n3 = this.getTypeEnd(n);
        int n4 = 0;
        for (int i = n2; i < Math.min(n3, this.levelScores.length); ++i) {
            if (this.levelScores[i] == 0 || i - n2 == 5) continue;
            ++n4;
        }
        return n4;
    }

    public int getTypeEnd(int n) {
        int n2 = this.getTypeStart(n);
        return this.getTypeEnd(n, n2);
    }

    public int getTypeEnd(int n, int n2) {
        for (int i = n2; i < cPhysicsManager.levelData.length; ++i) {
            if (cPhysicsManager.levelData[i][0] == n || cPhysicsManager.levelData[i][0] == 3) continue;
            return i - 1;
        }
        return cPhysicsManager.levelData.length - 1;
    }

    public int getTypeStart(int n) {
        for (int i = 0; i < cPhysicsManager.levelData.length; ++i) {
            if (cPhysicsManager.levelData[i][0] != n) continue;
            return i;
        }
        return -1;
    }

    public boolean setTypeScore(int n, int n2, byte[] byArray) {
        int n3;
        int n4;
        for (n4 = 0; n4 < 6 && n2 < this.scoreTable[n][n4]; ++n4) {
        }
        if (n4 >= 6) {
            return false;
        }
        int[] nArray = new int[6];
        byte[][] byArray2 = new byte[6][7];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = this.scoreTable[n][n3];
            byArray2[n3] = this.initalTable[n][n3];
        }
        for (n3 = n4; n3 < 5; ++n3) {
            nArray[n3 + 1] = this.scoreTable[n][n3];
            byArray2[n3 + 1] = this.initalTable[n][n3];
        }
        nArray[n4] = n2;
        System.arraycopy(byArray, 0, byArray2[n4], 0, byArray.length);
        this.scoreTable[n] = nArray;
        this.initalTable[n] = byArray2;
        return true;
    }

    private void initAudioAssets(long[] lArray, int[] nArray, int n) {
        this._audioManager.stopAllAudio();
        this._audioManager.removeAudioBank();
        long[] lArray2 = new long[lArray.length * 2 + 2];
        if (cSponge.PACK_MUSIC.length == 0) {
            return;
        }
        lArray2[0] = cSponge.PACK_MUSIC[n];
        lArray2[1] = nArray[0];
        for (int i = 1; i < lArray.length + 1; ++i) {
            lArray2[i * 2] = lArray[i - 1];
            lArray2[i * 2 + 1] = nArray[i];
        }
        this._audioManager.loadAudioBank(lArray2);
        this._audioManager.setForceStop(false);
    }

    public void loadGameAudio() {
        this.initAudioAssets(cSponge.PACK_IN_GAME_SFX, GAME_AUDIO_TYPES, currentTune);
    }

    private void loadMenuAudio() {
        this.initAudioAssets(cSponge.PACK_FRONTEND_SFX, FRONTEND_AUDIO_TYPES, 0);
    }

    private void initAudio() {
        this._audioManager = new crlAudioManager();
        this._audioManager.open(crlCanvas.gResourceManager, 6, 1, 1);
    }

    public void setVolume(int n) {
        audioVolume = n;
    }

    public void playSfx(int n) {
        if (!isMusic && audioVolume != 0) {
            System.out.println("play sfx");
            this._audioManager.playAudio(n, crlAudioManager.VOLUME_LEVEL[audioVolume], 1);
        }
    }

    public void playJingle(int n) {
        if (audioVolume != 0) {
            this._audioManager.stopAllAudio();
            this._audioManager.playAudio(n, crlAudioManager.VOLUME_LEVEL[audioVolume], 1);
        }
    }

    public void playMusic() {
        if (isMusic && !this.appPaused && audioVolume != 0) {
            try {
                this._audioManager.playAudio(0, crlAudioManager.VOLUME_LEVEL[audioVolume], 255);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void resumeMusic() {
        if (isMusic) {
            this._audioManager.resumeAudio();
        }
    }

    public void pauseAudio() {
        try {
            if (this._audioManager != null) {
                this._audioManager.pauseAudio();
                this._audioManager.update();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setAudioMode(boolean bl) {
        isMusic = bl;
        if (!bl) {
            this._audioManager.stopAllAudio();
            this._audioManager.stopAudio(0);
        }
    }

    public void vibrate(int n) {
    }

    public static final boolean hasKey(int n) {
        return cBaseManager.isFlag(crlCanvas.mPad, n);
    }

    static {
        isMusic = true;
        PARRALAX = new long[][]{cSponge.PACK_BACKGROUND_SPACE, cSponge.PACK_BACKGROUND_SKY, cSponge.PACK_BACKGROUND_GROUND};
    }

    public static interface GameStates
    extends crlCanvas.gGameStates {
        public static final int LOADING_UI = 14;
        public static final int LOADING_INIT = 15;
    }
}

