/*
 * Decompiled with CFR 0.152.
 */
package Coral.Math.FP;

public abstract class crlFP32 {
    private static int _fbits = 12;
    private static int _digits = 4;
    private static int _one;
    private static int _fmask;
    private static int _dmul;
    private static int _flt;
    private static int _pi;
    private static int[] e;
    public static int PI;
    public static int E;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = -2147483647;

    public static int setPrecision(int n) {
        if (n > 12 || n < 0) {
            return _digits;
        }
        _fbits = n;
        _one = 1 << n;
        _flt = 12 - n;
        _digits = 0;
        _dmul = 1;
        _fmask = _one - 1;
        PI = _pi >> _flt;
        E = e[1] >> _flt;
        int n2 = _one;
        while (n2 != 0) {
            n2 /= 10;
            ++_digits;
            _dmul *= 10;
        }
        return _digits;
    }

    public static int getPrecision() {
        return _fbits;
    }

    public static int toInt(int n) {
        n = crlFP32.round(n, 0);
        return n >> _fbits;
    }

    public static int toFP(int n) {
        return n << _fbits;
    }

    public static int convert(int n, int n2) {
        byte by = (byte)(n >= 0 ? 1 : -1);
        if (crlFP32.abs(n2) < 13) {
            n = _fbits < n2 ? n + by * (1 << (n2 - _fbits >> 1)) >> n2 - _fbits : (n <<= _fbits - n2);
        }
        return n;
    }

    public static int toFP(String string) {
        int n = 0;
        if (string.charAt(0) == '-') {
            n = 1;
        }
        String string2 = "-1";
        int n2 = string.indexOf(46);
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1, string.length());
            while (string2.length() < _digits) {
                string2 = string2 + "0";
            }
            if (string2.length() > _digits) {
                string2 = string2.substring(0, _digits);
            }
        } else {
            n2 = string.length();
        }
        int n3 = 0;
        if (n != n2) {
            n3 = Integer.parseInt(string.substring(n, n2));
        }
        int n4 = Integer.parseInt(string2) + 1;
        int n5 = (n3 << _fbits) + (n4 << _fbits) / _dmul;
        if (n == 1) {
            n5 = -n5;
        }
        return n5;
    }

    public static String toString(int n) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        int n2 = n >> _fbits;
        int n3 = _dmul * (n & _fmask) >> _fbits;
        String string = Integer.toString(n3);
        while (string.length() < _digits) {
            string = "0" + string;
        }
        return (bl ? "-" : "") + Integer.toString(n2) + "." + string;
    }

    public static String toString(int n, int n2) {
        if (n2 > _digits) {
            n2 = _digits;
        }
        String string = crlFP32.toString(crlFP32.round(n, n2));
        return string.substring(0, string.length() - _digits + n2);
    }

    public static int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    public static int min(int n, int n2) {
        return n2 >= n ? n : n2;
    }

    public static int round(int n, int n2) {
        int n3 = 10;
        for (int i = 0; i < n2; ++i) {
            n3 *= 10;
        }
        n3 = crlFP32.div(crlFP32.toFP(5), crlFP32.toFP(n3));
        if (n < 0) {
            n3 = -n3;
        }
        return n + n3;
    }

    public static int mul(int n, int n2) {
        boolean bl = false;
        int n3 = _fbits;
        int n4 = _fmask;
        if ((n & n4) == 0) {
            return (n >> n3) * n2;
        }
        if ((n2 & n4) == 0) {
            return n * (n2 >> n3);
        }
        if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
            bl = true;
        }
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        while (crlFP32.max(n, n2) >= 1 << 31 - n3) {
            n >>= 1;
            n2 >>= 1;
            n4 >>= 1;
            --n3;
        }
        int n5 = (n >> n3) * (n2 >> n3) << n3;
        int n6 = (n & n4) * (n2 & n4) >> n3;
        if ((n5 = n5 + (n6 += (n & ~n4) * (n2 & n4) >> n3) + ((n & n4) * (n2 & ~n4) >> n3) << _fbits - n3) < 0) {
            throw new ArithmeticException("Overflow");
        }
        return bl ? -n5 : n5;
    }

    public static int div(int n, int n2) {
        boolean bl = false;
        int n3 = _fbits;
        if (n2 == _one) {
            return n;
        }
        if ((n2 & _fmask) == 0) {
            return n / (n2 >> n3);
        }
        if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
            bl = true;
        }
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        while (crlFP32.max(n, n2) >= 1 << 31 - n3) {
            n >>= 1;
            n2 >>= 1;
            --n3;
        }
        int n4 = (n << n3) / n2 << _fbits - n3;
        return bl ? -n4 : n4;
    }

    public static int add(int n, int n2) {
        return n + n2;
    }

    public static int sub(int n, int n2) {
        return n - n2;
    }

    public static int abs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static int sqrt(int n, int n2) {
        if (n < 0) {
            throw new ArithmeticException("Bad Input");
        }
        if (n == 0) {
            return 0;
        }
        int n3 = n + _one >> 1;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 + crlFP32.div(n, n3) >> 1;
        }
        if (n3 < 0) {
            throw new ArithmeticException("Overflow");
        }
        return n3;
    }

    public static int sqrt(int n) {
        return crlFP32.sqrt(n, 16);
    }

    public static int sin(int n) {
        int n2 = crlFP32.mul(n, crlFP32.div(crlFP32.toFP(180), PI));
        if ((n2 %= crlFP32.toFP(360)) < 0) {
            n2 = crlFP32.toFP(360) + n2;
        }
        int n3 = n2;
        if (n2 >= crlFP32.toFP(90) && n2 < crlFP32.toFP(270)) {
            n3 = crlFP32.toFP(180) - n2;
        } else if (n2 >= crlFP32.toFP(270) && n2 < crlFP32.toFP(360)) {
            n3 = -(crlFP32.toFP(360) - n2);
        }
        int n4 = n3 / 90;
        int n5 = crlFP32.mul(n4, n4);
        int n6 = crlFP32.mul(crlFP32.mul(crlFP32.mul(crlFP32.mul(-18 >> _flt, n5) + (326 >> _flt), n5) - (2646 >> _flt), n5) + (6434 >> _flt), n4);
        return n6;
    }

    public static int asin(int n) {
        boolean bl;
        if (crlFP32.abs(n) > _one) {
            throw new ArithmeticException("Bad Input");
        }
        boolean bl2 = bl = n < 0;
        if (n < 0) {
            n = -n;
        }
        int n2 = crlFP32.mul(crlFP32.mul(crlFP32.mul(crlFP32.mul(35 >> _flt, n) - (146 >> _flt), n) + (347 >> _flt), n) - (877 >> _flt), n) + (6434 >> _flt);
        int n3 = PI / 2 - crlFP32.mul(crlFP32.sqrt(_one - n), n2);
        return bl ? -n3 : n3;
    }

    public static int cos(int n) {
        return crlFP32.sin(PI / 2 - n);
    }

    public static int acos(int n) {
        return PI / 2 - crlFP32.asin(n);
    }

    public static int tan(int n) {
        return crlFP32.div(crlFP32.sin(n), crlFP32.cos(n));
    }

    public static int cot(int n) {
        return crlFP32.div(crlFP32.cos(n), crlFP32.sin(n));
    }

    public static int atan(int n) {
        return crlFP32.asin(crlFP32.div(n, crlFP32.sqrt(_one + crlFP32.mul(n, n))));
    }

    public static int exp(int n) {
        int n2;
        if (n == 0) {
            return _one;
        }
        boolean bl = n < 0;
        n = crlFP32.abs(n);
        int n3 = n >> _fbits;
        int n4 = _one;
        for (n2 = 0; n2 < n3 / 4; ++n2) {
            n4 = crlFP32.mul(n4, e[4] >> _flt);
        }
        if (n3 % 4 > 0) {
            n4 = crlFP32.mul(n4, e[n3 % 4] >> _flt);
        }
        if ((n &= _fmask) > 0) {
            n2 = _one;
            int n5 = 0;
            int n6 = 1;
            for (int i = 0; i < 16; ++i) {
                n5 += n2 / n6;
                if ((n6 *= i + 1) > (n2 = crlFP32.mul(n2, n)) || n2 <= 0 || n6 <= 0) break;
            }
            n4 = crlFP32.mul(n4, n5);
        }
        if (bl) {
            n4 = crlFP32.div(_one, n4);
        }
        return n4;
    }

    public static int log(int n) {
        int n2;
        if (n <= 0) {
            throw new ArithmeticException("Bad Input");
        }
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        while (n >= _one << 1) {
            n >>= 1;
            ++n4;
        }
        int n5 = n4 * (2839 >> _flt);
        int n6 = 0;
        if (n < _one) {
            return -crlFP32.log(crlFP32.div(_one, n));
        }
        n -= _one;
        for (int i = 1; i < 20 && (n2 = n3 == 0 ? n : crlFP32.mul(n3, n)) != 0; ++i) {
            n6 += (i % 2 != 0 ? 1 : -1) * n2 / i;
            n3 = n2;
        }
        return n5 + n6;
    }

    public static int pow(int n, int n2) {
        boolean bl = n2 < 0;
        int n3 = _one;
        n2 = crlFP32.abs(n2);
        int n4 = n2 >> _fbits;
        while (n4-- > 0) {
            n3 = crlFP32.mul(n3, n);
        }
        if (n3 < 0) {
            throw new ArithmeticException("Overflow");
        }
        n3 = n != 0 ? crlFP32.mul(n3, crlFP32.exp(crlFP32.mul(crlFP32.log(n), n2 & _fmask))) : 0;
        if (bl) {
            return crlFP32.div(_one, n3);
        }
        return n3;
    }

    public static int atan2(int n, int n2) {
        int n3 = 0;
        if (n2 > 0) {
            n3 = crlFP32.atan(crlFP32.div(n, n2));
        } else if (n2 < 0) {
            n3 = (n2 >= 0 ? PI : -PI) - crlFP32.atan(crlFP32.abs(crlFP32.div(n, n2)));
        } else {
            if (n2 == 0 && n == 0) {
                throw new ArithmeticException("Bad Input");
            }
            n3 = (n2 >= 0 ? PI : -PI) / 2;
        }
        return n3;
    }

    static {
        _fmask = 4095;
        _dmul = 10000;
        _flt = 0;
        _one = 4096;
        _pi = 12868;
        e = new int[]{_one, 11134, 30266, 82270, 223636};
        PI = _pi;
        E = e[1];
    }
}

