/*
 * Decompiled with CFR 0.152.
 */
package Coral.Graphics2D;

import Coral.Graphics2D.crlImagePacked;
import Coral.Util.crlResourceManager;
import Coral.Util.crlString;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class crlFont {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final char CHAR_LINE_BREAK = '|';
    public static final char CHAR_ALIGN_LEFT = '{';
    public static final char CHAR_ALIGN_RIGHT = '}';
    public static final char CHAR_ALIGN_CENTER = '~';
    public static final char CHAR_SPACE = ' ';
    public static final int SHADOW_ALL = 255;
    public static final int SHADOW_DIAGONAL = 85;
    public static final int SHADOW_UDLR = 170;
    public static final int SHADOW_UP = 1;
    public static final int SHADOW_UP_RIGHT = 2;
    public static final int SHADOW_RIGHT = 4;
    public static final int SHADOW_DOWN_RIGHT = 8;
    public static final int SHADOW_DOWN = 16;
    public static final int SHADOW_DOWN_LEFT = 32;
    public static final int SHADOW_LEFT = 64;
    public static final int SHADOW_UP_LEFT = 128;
    public static final int[][] DROP_SHADOW_OFFSETS = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    public int mLastLineWidth;
    public int mFirstLineWidth;
    public int mLongestLineWidth;
    public int mLinesDrawn;
    public static int mClipTop;
    public static int mClipBottom;
    private crlImagePacked _mImagePacked;
    private int _mFontWidth;
    private int _mFontHeight;
    private int _mRotate;
    private int _mAlign;
    public int mCharSpacing = 0;
    private boolean _mProportional = true;
    private byte[] rWork = new byte[128];
    private int _mFontColour;
    private Font _font;
    private int _yAnchor;
    private int dropShadowColour;
    private byte dropShadowDirections;
    private byte[] charWidthCache;

    public void open(int n, int n2, int n3, int n4) {
        this.setFont(n, n2, n3, n4);
        this._yAnchor = this._mFontHeight >> 1;
        this.charWidthCache = new byte[256];
        for (int i = 0; i < this.charWidthCache.length; ++i) {
            this.charWidthCache[i] = -1;
        }
    }

    public void setFont(int n, int n2, int n3, int n4) {
        this._font = Font.getFont((int)n, (int)n2, (int)n3);
        this._mFontColour = n4;
        this._mFontHeight = this._font.getHeight();
    }

    public void setAnchor(int n, int n2) {
        this._mFontHeight += n2;
        this._yAnchor = n;
    }

    public void setDropshadow(byte by, int n) {
        this.dropShadowDirections = by;
        this.dropShadowColour = n;
    }

    public void open(crlImagePacked crlImagePacked2, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        for (int i = 0; i < crlImagePacked2.getFrameCount(); ++i) {
            int n5 = crlImagePacked2.getFrameMetric(i, 2);
            int n6 = crlImagePacked2.getFrameMetric(i, 3);
            if (n5 > n3) {
                n3 = n5;
            }
            if (n6 <= n4) continue;
            n4 = n6;
        }
        this.open(crlImagePacked2, n3, n4, n2);
    }

    public void open(crlImagePacked crlImagePacked2, int n, int n2, int n3) {
        this._mImagePacked = crlImagePacked2;
        this._mRotate = n3 & 0xF;
        this._mFontWidth = n;
        this._mFontHeight = n2;
        this.mLastLineWidth = 0;
    }

    public void setRotate(int n) {
        this._mRotate = n & 0xF;
    }

    public void setAlign(int n) {
        this._mAlign = n;
    }

    public void close() {
    }

    private final int _B2I(byte by) {
        int n = 0;
        int n2 = by & 0xFF;
        if (n2 >= 32 && n2 != 124) {
            return n2 - 32;
        }
        return n;
    }

    public final int getWidth(crlString crlString2) {
        if (this._font != null) {
            return this._font.stringWidth(crlString2.toString());
        }
        return this.getWidth(crlString2.get());
    }

    public final int getWidth(byte[] byArray) {
        if (this._font != null) {
            return this._font.stringWidth(crlString.toString(byArray));
        }
        int n = 0;
        int n2 = 0;
        while (byArray[n2] != 0) {
            int n3 = this._B2I(byArray[n2]);
            int n4 = this._mImagePacked.getWidth(n3);
            n = n4 == 0 && this._mProportional ? (n += this._mFontWidth / 2 + this.mCharSpacing) : (n += n4 + this.mCharSpacing);
            ++n2;
        }
        return n;
    }

    public final int getWidth(byte by) {
        if (this._font != null) {
            if (this.charWidthCache[by & 0xFF] == -1) {
                this.charWidthCache[by & 0xFF] = (byte)this._font.charWidth((char)by);
            }
            return this.charWidthCache[by & 0xFF];
        }
        int n = this._B2I(by);
        return this._mImagePacked.getWidth(n);
    }

    public final int getHeight() {
        return this._mFontHeight;
    }

    public final int getHeight(crlString crlString2) {
        return this.getHeight(crlString2.get());
    }

    public final int getHeight(byte[] byArray) {
        if (this._font != null) {
            return this._mFontHeight;
        }
        int n = 0;
        int n2 = 0;
        while (byArray[n2] != 0) {
            int n3 = this._B2I(byArray[n2]);
            int n4 = this._mImagePacked.getHeight(n3);
            if (n < n4) {
                n = n4;
            }
            ++n2;
        }
        return n;
    }

    public final int getHeight(byte by) {
        if (this._font != null) {
            return this._mFontHeight;
        }
        int n = this._B2I(by);
        return this._mImagePacked.getHeight(n);
    }

    public int printChar(Graphics graphics, int n, int n2, byte by) {
        if (this._font != null) {
            graphics.setFont(this._font);
            int n3 = n2 - this._yAnchor;
            if (this.dropShadowDirections != 0) {
                graphics.setColor(this.dropShadowColour);
                int n4 = 1;
                for (int i = 0; i < 8; ++i) {
                    if ((this.dropShadowDirections & n4) > 0) {
                        graphics.drawChar((char)by, n + DROP_SHADOW_OFFSETS[i][0], n3 + DROP_SHADOW_OFFSETS[i][1], 20);
                    }
                    n4 <<= 1;
                }
            }
            graphics.setColor(this._mFontColour);
            graphics.drawChar((char)by, n, n3, 20);
            return this.getWidth(by);
        }
        int n5 = this._B2I(by);
        this._mImagePacked.draw(graphics, n, n2, n5, this._mRotate);
        if (this._mProportional) {
            int n6 = this._mImagePacked.getWidth(n5);
            if (n6 == 0) {
                n6 = this._mFontWidth / 2;
            }
            return n6 + this.mCharSpacing;
        }
        return this._mFontWidth;
    }

    public int printNumber(Graphics graphics, int n, int n2, int n3, int n4) {
        return this.printNumber(graphics, n, n2, n3, n4, '0');
    }

    public int printNumber(Graphics graphics, int n, int n2, int n3, int n4, char c) {
        int n5;
        int n6;
        int n7 = 0;
        for (n6 = 1; n6 <= n3; n6 *= 10) {
            ++n7;
        }
        if (n7 == 0) {
            n7 = 1;
        }
        int n8 = 0;
        if (n7 < n4) {
            n8 = n4 - n7;
        }
        for (n5 = 0; n5 < n8; ++n5) {
            this.rWork[n5] = (byte)c;
        }
        for (n5 = n8; n5 < n7 + n8; ++n5) {
            if ((n6 /= 10) == 0) {
                n6 = 1;
            }
            int n9 = n3 / n6 % 10;
            this.rWork[n5] = (byte)(n9 + 48);
        }
        this.rWork[n7 + n8] = 0;
        return this.print(graphics, n, n2, this.rWork);
    }

    public int print(Graphics graphics, int n, int n2, crlString crlString2) {
        return this.print(graphics, n, n2, crlString2.get());
    }

    public int print(Graphics graphics, int n, int n2, int n3) {
        crlString crlString2 = crlResourceManager.mLocaleText[n3];
        return this.print(graphics, n, n2, crlString2.get());
    }

    public int print(Graphics graphics, int n, int n2, byte[] byArray) {
        this.mLastLineWidth = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        switch (this._mAlign) {
            case 1: {
                n5 = this.getWidth(byArray);
                n4 = -(n5 >> 1);
                break;
            }
            case 2: {
                n5 = this.getWidth(byArray);
                n4 = -n5;
            }
        }
        switch (this._mRotate) {
            default: {
                if (this._font != null) {
                    this.printString(graphics, n + this.mLastLineWidth + n4, n2, byArray);
                } else {
                    while (byArray[n3] != 0) {
                        this.mLastLineWidth = byArray[n3] == 124 ? (this.mLastLineWidth += 0) : (this.mLastLineWidth += this.printChar(graphics, n + this.mLastLineWidth + n4, n2, byArray[n3]));
                        ++n3;
                    }
                }
                return n2 + this._mFontHeight;
            }
            case 270: {
                while (byArray[n3] != 0) {
                    if (byArray[n3] != 124) {
                        n2 += this.printChar(graphics, n + n4, n2, byArray[n3]);
                    }
                    ++n3;
                }
                return n - this._mFontHeight;
            }
            case 180: {
            }
            case 90: 
        }
        return 0;
    }

    private void printString(Graphics graphics, int n, int n2, byte[] byArray) {
        int n3 = 0;
        for (n3 = 0; n3 < byArray.length && byArray[n3] != 0 && byArray[n3] != 124; ++n3) {
        }
        String string = new String(byArray, 0, n3);
        graphics.setFont(this._font);
        int n4 = n2 - this._yAnchor;
        if (this.dropShadowDirections != 0) {
            graphics.setColor(this.dropShadowColour);
            int n5 = 1;
            for (int i = 0; i < 8; ++i) {
                if ((this.dropShadowDirections & n5) > 0) {
                    graphics.drawString(string, n + DROP_SHADOW_OFFSETS[i][0], n4 + DROP_SHADOW_OFFSETS[i][1], 20);
                }
                n5 <<= 1;
            }
        }
        graphics.setColor(this._mFontColour);
        graphics.drawString(string, n, n4, 20);
    }

    public final int printCentered(Graphics graphics, int n, int n2, byte[] byArray) {
        this.mLastLineWidth = this.getWidth(byArray);
        this.print(graphics, n - (this.mLastLineWidth >> 1), n2, byArray);
        return n2 + this._mFontHeight;
    }

    public final int printCentred(Graphics graphics, int n, int n2, byte[] byArray) {
        this.mLastLineWidth = this.getWidth(byArray);
        this.print(graphics, n - this.mLastLineWidth >> 1, n2, byArray);
        return n2 + this._mFontHeight;
    }

    public final int printStringsCentred(Graphics graphics, int n, int n2, byte[] byArray, byte[] byArray2) {
        int n3 = this.getWidth(byArray);
        int n4 = 0;
        this.mLastLineWidth = n3 + this._mFontWidth + this.getWidth(byArray2);
        n4 = n - this.mLastLineWidth >> 1;
        this.print(graphics, n4, n2, byArray);
        this.print(graphics, n4 + n3 + (this._mFontWidth >> 2), n2, byArray2);
        this.mLastLineWidth = n3 + this._mFontWidth + this.getWidth(byArray2);
        return n2 + this._mFontHeight;
    }

    public int printTime(Graphics graphics, int n, int n2, long l) {
        int n3 = (int)(l / 1000L % 60L);
        int n4 = (int)(l / 60000L % 60L);
        int n5 = (int)(l / 3600000L);
        byte[] byArray = new byte[10];
        byArray[0] = (byte)(n5 / 100 % 10 + 48);
        byArray[1] = (byte)(n5 / 10 % 10 + 48);
        byArray[2] = (byte)(n5 % 10 + 48);
        byArray[3] = 58;
        byArray[4] = (byte)(n4 / 10 % 10 + 48);
        byArray[5] = (byte)(n4 % 10 + 48);
        byArray[6] = 58;
        byArray[7] = (byte)(n3 / 10 % 10 + 48);
        byArray[8] = (byte)(n3 % 10 + 48);
        return this.print(graphics, n, n2, byArray);
    }

    public int printShortTime(Graphics graphics, int n, int n2, long l) {
        int n3 = (int)(l / 1000L % 60L);
        int n4 = (int)(l / 60000L % 60L);
        byte[] byArray = new byte[10];
        byArray[0] = (byte)(n4 / 10 % 10 + 48);
        byArray[1] = (byte)(n4 % 10 + 48);
        byArray[2] = 58;
        byArray[3] = (byte)(n3 / 10 % 10 + 48);
        byArray[4] = (byte)(n3 % 10 + 48);
        byArray[5] = 46;
        byArray[6] = (byte)(l / 100L % 10L + 48L);
        byArray[7] = (byte)(l / 10L % 10L + 48L);
        return this.print(graphics, n, n2, byArray);
    }

    private boolean isControlChar(byte by) {
        return by == 124 || by == 123 || by == 125 || by == 126;
    }

    public int printWrapped(Graphics graphics, int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, int n5) {
        int n6;
        int n7 = n5;
        int n8 = n5;
        int n9 = n5;
        int n10 = n2;
        this.mLinesDrawn = 0;
        this.mLongestLineWidth = 0;
        for (n6 = 0; n6 < n5; ++n6) {
            n9 = byArray[n6];
            if (n9 == 123) {
                this.setAlign(0);
                continue;
            }
            if (n9 == 125) {
                this.setAlign(2);
                continue;
            }
            if (n9 != 126) continue;
            this.setAlign(1);
        }
        n9 = n5;
        while (byArray[n9++] != 0) {
            ++n7;
        }
        while (n8 < n7) {
            int n11;
            int n12;
            n6 = 0;
            int n13 = 0;
            int n14 = n8;
            while (n13 < n3) {
                if (n14 >= n7) {
                    n9 = 32;
                    n6 = n14 - n8;
                    break;
                }
                n9 = byArray[n14];
                n12 = 0;
                if (n9 == 123) {
                    this.setAlign(0);
                    n12 = 1;
                } else if (n9 == 125) {
                    this.setAlign(2);
                    n12 = 1;
                } else if (n9 == 126) {
                    this.setAlign(1);
                    n12 = 1;
                } else {
                    if (n9 == 124) {
                        n6 = n14 - n8;
                        break;
                    }
                    if (n9 == 32) {
                        n6 = n14 - n8;
                    }
                }
                if (n12 == 0) {
                    n11 = this.getWidth((byte)n9);
                    n13 = n11 == 0 && this._mProportional ? (n13 += this._mFontWidth / 2 + this.mCharSpacing) : (n13 += n11 + this.mCharSpacing);
                }
                ++n14;
            }
            n12 = 0;
            for (n11 = n8; n11 < n8 + n6; ++n11) {
                if (n11 >= n7 || this.isControlChar(byArray[n11])) continue;
                this.rWork[n12] = byArray[n11];
                ++n12;
            }
            this.rWork[n12] = 0;
            if ((n8 += n6) < n7 && (byArray[n8] == 32 || this.isControlChar(byArray[n8]))) {
                ++n8;
            }
            if (n10 + this._mFontHeight < n2 + n4) {
                n11 = this._mAlign == 0 ? n : (this._mAlign == 1 ? n + (n3 >> 1) : n + n3);
                if (graphics != null) {
                    this.print(graphics, n11, n10, this.rWork);
                }
            } else {
                return n8 - n6 - 1;
            }
            n10 += this._mFontHeight;
        }
        return n8;
    }

    public final int printWrapped(Graphics graphics, int n, int n2, byte[] byArray, byte[] byArray2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = n2;
        this.mLinesDrawn = 0;
        this.mLongestLineWidth = 0;
        int n6 = n3 / this._mFontWidth;
        boolean bl2 = false;
        int n7 = 0;
        int n8 = 0;
        while (byArray[n7++] != 0) {
            ++n8;
        }
        if (n8 <= n6) {
            if (n2 >= mClipTop && n2 + this._mFontHeight < mClipBottom) {
                if (bl) {
                    this.print(graphics, n, n2, byArray);
                } else {
                    this.printCentred(graphics, n, n2, byArray);
                }
                this.mFirstLineWidth = this.mLastLineWidth = this.getWidth(byArray);
                this.mLongestLineWidth = this.mLastLineWidth;
                this.mLinesDrawn = 1;
            }
        } else {
            while (n4 < n8) {
                int n9;
                int n10 = n4 + n6;
                for (n9 = n4; n9 < n4 + n6; ++n9) {
                    n7 = n9 >= n8 ? 32 : byArray[n9];
                    if (n7 != 32) continue;
                    n10 = n9;
                }
                int n11 = 0;
                for (n9 = n4; n9 < n10; ++n9) {
                    if (n9 >= n8) continue;
                    byArray2[n11] = byArray[n9];
                    ++n11;
                }
                byArray2[n11] = 0;
                n4 = n10;
                if (n10 < n8 && byArray[n10] == 32) {
                    ++n4;
                }
                if ((n5 = n2 + (this._mFontHeight + 1) * this.mLinesDrawn) >= mClipTop && n5 + this._mFontHeight < mClipBottom) {
                    if (bl) {
                        this.print(graphics, n, n5, byArray2);
                    } else {
                        this.printCentred(graphics, n, n5, byArray2);
                    }
                    if (!bl2) {
                        this.mFirstLineWidth = this.getWidth(byArray2);
                        bl2 = true;
                    }
                    this.mLastLineWidth = this.getWidth(byArray2);
                    if (this.mLastLineWidth > this.mLongestLineWidth) {
                        this.mLongestLineWidth = this.mLastLineWidth;
                    }
                }
                ++this.mLinesDrawn;
            }
        }
        return n5 + this._mFontHeight;
    }
}

