/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKString;
import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Camera;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.SimWorld;
import dk.progressivemedia.skeleton.state.StateInGame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SimData {
    public boolean GSEndOfGameHasBeenScreenShown;
    private short[] d_skillDescStrings;
    private int[][] d_skillConsumables;
    private int[][] d_skillConsumablesUses;
    private int[][] d_skillRates;
    public short[][] d_skillIconAnims;
    private short[][] d_skillLevelDescStrings;
    private short[] d_careerDescStrings;
    private short[] d_careerStreamers;
    private short[] d_careerRabbitHoles;
    private byte[] d_careerBosses;
    private short[] d_careerFreakDeath1s;
    private short[] d_careerFreakDeath2s;
    private short[] d_careerRaiseFail1;
    private short[] d_careerRaiseFail2;
    private short[] d_careerProducible1 = new short[]{5, 19, 12, 26};
    private byte[] d_careerProducible1Chance = new byte[]{25, 24, 27, 28};
    private short[] d_careerProducible2 = new short[]{6, 20, 13, 27};
    private byte[] d_careerProducible2Chance = new byte[]{10, 11, 8, 7};
    public short[][] d_careerLevelDescStrings;
    private short[][] d_careerLevelIncomes;
    private short[][] d_careerLevelFlags;
    private short[][] d_careerLevelHoursStarts;
    private short[][] d_careerLevelHoursEnds;
    private byte[][][] d_careerLevelRequirements;
    public short[] d_personaDescStrings;
    public short[] d_personaLongDescStrings;
    private short[] d_personaIcons;
    private short[] d_personaFlags;
    private short[] d_dreamDescStrings;
    private short[] d_dreamFlags;
    private int d_motiveCount = 0;
    private short[] d_motiveDescStrings;
    private int[] d_motiveStartLevel;
    private int[] d_motiveDecayRate;
    private short[] d_motiveTriggersNeeds;
    private int[] d_motiveTriggersNeedLevels;
    private short[] d_motiveAnimHighs;
    private short[] d_motiveAnimLows;
    public int d_buffCount = 0;
    public short[] d_buffDescStringIds;
    public int[] d_buffTimeouts;
    public byte[] d_buffTimeoutChains;
    public byte[] d_buffFlags;
    public byte[][] d_buffTriggerMotives;
    public int[][] d_buffTriggerMotiveLevels;
    public byte[][] d_buffEffectMood;
    public byte[][] d_buffEffectMoodAmount;
    public byte[][] d_buffEffectMotive;
    public int[][] d_buffEffectMotiveFactors;
    public short[] d_traitDescStrings;
    public short[] d_traitExcludes;
    private int d_numRelLevels = 0;
    private short[] d_relStateDescStrings;
    private byte[] d_relStateFlags;
    private short[] d_relStateEffectAnims;
    private short[] d_relStateToStrings;
    private byte[][] d_relStateTriggerToStates;
    private byte[][] d_relStateTriggerLevels;
    private short[][] d_relStateTriggerLevelValues;
    private int d_numSims = 0;
    private short[] d_simNameStrings;
    private byte[] d_simMacromapColors;
    public byte[][] d_simAttributes;
    private short[] d_simHomes;
    private byte[] d_simFlags;
    private byte[] d_simPartners;
    public byte[] d_simCareers;
    private byte[] d_simCareerLevels;
    private byte[][] d_simTraits;
    private byte[][] d_simQuests;
    private int d_numPresets = 0;
    private byte[][] d_simPresets;
    public short[] d_commodityStringIds;
    public int d_numActions = 0;
    public short[] d_actionStringIds;
    public short[] d_actionGroupStringIds;
    public int[] d_actionFlags;
    public short[] d_actionWorldArgs;
    public byte[][] d_actionConditionCommodities;
    public byte[][] d_actionConditionTraits;
    public int[][] d_actionConditionRelStates;
    public short[][] d_actionEffectFlags;
    public byte[][] d_actionAffectFriendships;
    public byte[][] d_actionAffectRomances;
    public byte[][] d_actionAffectCommodities;
    public byte[][] d_actionAffectCommodityAmounts;
    public short[][] d_actionResponseActions;
    public byte[][] d_actionPhases;
    private short[] d_chanceCardPrompts;
    private byte[] d_chanceCardYesPercents;
    private byte[] d_chanceCardNoPercents;
    private byte[] d_chanceCardResultYes1s;
    private short[] d_chanceCardResultYes1Strings;
    private byte[] d_chanceCardResultYes2s;
    private short[] d_chanceCardResultYes2Strings;
    private byte[] d_chanceCardResultNo1s;
    private short[] d_chanceCardResultNo1Strings;
    private byte[] d_chanceCardResultNo2s;
    private short[] d_chanceCardResultNo2Strings;
    private short[] d_questPrompts;
    private short[] d_questMessages;
    private short[] d_questFinishActions;
    private short[] d_questGiveItem;
    private short[] d_questRewardCash;
    private short[][] d_questTriggerActions;
    private short[] objectActions = new short[20];
    public static final int[] DAY_FLAGS = new int[]{64, 128, 256, 512, 1024, 2048, 4096};
    public static final int[] DAY_STRINGS = new int[]{253, 258, 259, 256, 252, 254, 255};
    public int m_timeTimer = 0;
    private int m_timeTotal = 0;
    private int m_money = 0;
    public int m_moneySpent = 0;
    public int m_moneySpentOnGearMaintenance = 0;
    public int m_moneySpentOnSnacks = 0;
    public int m_moneyEarned = 0;
    public int m_moneyEarnedOnProducibles = 0;
    private boolean m_fastForward = false;
    private byte[] m_inventory;
    private int m_activeRecipe;
    private int[] m_skillLevelsF;
    private int[][] consumablesCounter;
    public static final int[] PERK_FLAGS = new int[]{16, 32, 1, 2, 4, 8};
    public static final int[] PERK_STRINGS = new int[]{626, 632, 627, 628, 629, 630};
    public byte m_careerAcceptDay = 0;
    public short m_careerDaysWorked = 0;
    public short m_careerDaysMissed = 0;
    public byte[] m_careerLevelsAttained;
    public int m_numTimesPromoted = 0;
    public int m_numTimesFired = 0;
    public boolean isCurrentWorkSearchRehire = false;
    public int m_persona = 0;
    public int m_personaAmount = 0;
    private byte m_dream = 0;
    private int m_dreamTimer = 0;
    private byte[] m_promises;
    private int m_personaGoalsCompleted = 0;
    private boolean m_personaGoalsCompletedAll = false;
    public boolean m_personaGoalsCompletedAllShown = false;
    private int[] m_woohooTimes;
    private int[] m_woohooPartners;
    private int m_quickLinkFlags = 0;
    private int m_motiveTimer;
    private int[] m_motiveLevelsF;
    private int[] m_motiveDecaysF;
    private int[] m_motiveDecayFactorsF;
    private int[] m_motiveDecayAdjustsF;
    public short[] m_buffsActive;
    public int[] m_buffTimers;
    private int[] m_moodLevelsF;
    public int m_moodDesc = 478;
    private int m_moodLevel;
    public byte[] m_currentRelStates;
    private short[] m_currentRelStateFlags;
    private int[][] m_currentRelLevelsF;
    private int[][] m_commodityLevelsF;
    private short[][] m_actionHistories;
    private byte[][] m_knownTraits;
    private int m_commodityTimer;
    private int m_lastNPC = 0;
    public int m_lastNPCTimer = 0;
    public int numKissesGiven = 0;
    public int numSlapsGiven = 0;
    private static final short[] SPEECHICONS = new short[]{2, 5, 5, 9, 10, 1, 11, 289, 13, 321, 15, 1, 16, 289, 18, 257, 19, 261, 20, 257, 21, 257, 22, 1, 23, 513, 24, 257, 25, 257, 27, 257, 28, 305, 29, 1073, 30, 257, 359, 2};
    private byte[] m_questSims;
    private int[] m_questTimes;
    public int m_timeoutDelay = 0;
    public short[] m_objectStateIds;
    public int[] m_objectStateValues;
    public int[] m_objectStateTimes;
    public int numProduciblesProduced = 0;

    public SimData() {
        this.initData();
        this.resetRMSGameData();
    }

    public int determinePotentialVisitor() {
        int n;
        int n2;
        if (StateInGame.nextAvailableBank() == -1) {
            return -1;
        }
        int[] nArray = new int[]{5, 6, 7, 8, 9, 10};
        int[] nArray2 = new int[]{1, 3, 5, 7, 9, 11};
        int n3 = 0;
        int n4 = nArray.length;
        for (n2 = 1; n2 < this.d_numSims; ++n2) {
            if (this.getSimHome(n2) == 0) continue;
            for (n = 0; n < n4; ++n) {
                if (this.m_currentRelStates[n2] != nArray[n]) continue;
                n3 += nArray2[n];
                n = n4;
            }
        }
        if (n3 == 0) {
            return -1;
        }
        int[] nArray3 = new int[n3];
        n2 = 0;
        n = nArray.length;
        for (n4 = 1; n4 < this.d_numSims; ++n4) {
            if (this.getSimHome(n4) == 0) continue;
            for (int i = 0; i < n; ++i) {
                if (this.m_currentRelStates[n4] != nArray[i]) continue;
                for (int j = 0; j < nArray2[i]; ++j) {
                    if (n2 < n3) {
                        nArray3[n2] = n4;
                    }
                    ++n2;
                }
                i = n;
            }
        }
        return nArray3[Main.rand(0, nArray3.length - 1)];
    }

    public boolean placeNewFurnitureOnLawn(int n) {
        if (ArrayHandler.indexOf(-1, Main.m_simWorld.m_playerHouseObjectTypes) == -1) {
            return false;
        }
        for (int i = 0; i < Main.m_simWorld.m_playerHouseObjectTypes.length; ++i) {
            int n2;
            if (Main.m_simWorld.m_playerHouseObjectTypes[i] != 16) continue;
            boolean bl = true;
            for (n2 = 0; n2 < Main.m_simWorld.m_playerHouseObjectTypes.length; ++n2) {
                if (i == n2 || Main.m_simWorld.m_playerHouseObjectTypes[n2] == -1 || Main.m_simWorld.m_playerHouseObjectXs[i] != Main.m_simWorld.m_playerHouseObjectXs[n2] || Main.m_simWorld.m_playerHouseObjectZs[i] != Main.m_simWorld.m_playerHouseObjectZs[n2]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            n2 = Main.m_simWorld.d_objectFlags[n];
            for (int j = 0; j < 4; ++j) {
                if ((n2 & SimWorld.ROTATION_FLAGS[j]) == 0) continue;
                Main.m_simWorld.objectBuyNoRecalc(n, Main.m_simWorld.m_playerHouseObjectXs[i], Main.m_simWorld.m_playerHouseObjectZs[i], j);
                return true;
            }
        }
        return false;
    }

    private void initData() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        Cursor.ResourceManager_loadBinaryFile(86);
        int n11 = GameConstants.PMFile_readByte();
        this.d_skillDescStrings = new short[n11];
        this.d_skillConsumables = new int[n11][2];
        this.d_skillConsumablesUses = new int[n11][2];
        this.d_skillRates = new int[n11][5];
        this.d_skillIconAnims = new short[n11][3];
        this.d_skillLevelDescStrings = new short[n11][6];
        for (n10 = 0; n10 < n11; ++n10) {
            this.d_skillDescStrings[n10] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            for (n9 = 0; n9 < 2; ++n9) {
                this.d_skillConsumables[n10][n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
                this.d_skillConsumablesUses[n10][n9] = GameConstants.PMFile_readByte();
            }
            for (n9 = 0; n9 < 3; ++n9) {
                this.d_skillIconAnims[n10][n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            }
            for (n9 = 0; n9 < 5; ++n9) {
                this.d_skillRates[n10][n9] = GameConstants.PMFile_readInt();
            }
            for (n9 = 0; n9 < 6; ++n9) {
                this.d_skillLevelDescStrings[n10][n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            }
        }
        n10 = GameConstants.PMFile_readByte();
        this.d_careerDescStrings = new short[n10];
        this.d_careerStreamers = new short[n10];
        this.d_careerRabbitHoles = new short[n10];
        this.d_careerBosses = new byte[n10];
        this.d_careerFreakDeath1s = new short[n10];
        this.d_careerFreakDeath2s = new short[n10];
        this.d_careerRaiseFail1 = new short[n10];
        this.d_careerRaiseFail2 = new short[n10];
        this.d_careerLevelDescStrings = new short[n10][];
        this.d_careerLevelIncomes = new short[n10][];
        this.d_careerLevelFlags = new short[n10][];
        this.d_careerLevelHoursStarts = new short[n10][];
        this.d_careerLevelHoursEnds = new short[n10][];
        this.d_careerLevelRequirements = new byte[n10][][];
        for (n9 = 0; n9 < n10; ++n9) {
            this.d_careerDescStrings[n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_careerStreamers[n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_careerRabbitHoles[n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_careerBosses[n9] = GameConstants.PMFile_readByte();
            this.d_careerFreakDeath1s[n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_careerFreakDeath2s[n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_careerRaiseFail1[n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_careerRaiseFail2[n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            n8 = GameConstants.PMFile_readByte();
            this.d_careerLevelDescStrings[n9] = new short[n8];
            this.d_careerLevelIncomes[n9] = new short[n8];
            this.d_careerLevelFlags[n9] = new short[n8];
            this.d_careerLevelHoursStarts[n9] = new short[n8];
            this.d_careerLevelHoursEnds[n9] = new short[n8];
            this.d_careerLevelRequirements[n9] = new byte[n8][6];
            for (n7 = 0; n7 < n8; ++n7) {
                this.d_careerLevelDescStrings[n9][n7] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
                this.d_careerLevelIncomes[n9][n7] = GameConstants.PMFile_readShort();
                this.d_careerLevelFlags[n9][n7] = GameConstants.PMFile_readShort();
                n6 = GameConstants.PMFile_readShort();
                n5 = GameConstants.PMFile_readShort();
                n6 = n6 % 100 + n6 / 100 * 60;
                n5 = n5 % 100 + n5 / 100 * 60;
                this.d_careerLevelHoursStarts[n9][n7] = (short)n6;
                this.d_careerLevelHoursEnds[n9][n7] = (short)n5;
                this.d_careerLevelRequirements[n9][n7][0] = (byte)GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
                this.d_careerLevelRequirements[n9][n7][1] = GameConstants.PMFile_readByte();
                this.d_careerLevelRequirements[n9][n7][2] = (byte)GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
                this.d_careerLevelRequirements[n9][n7][3] = GameConstants.PMFile_readByte();
                this.d_careerLevelRequirements[n9][n7][4] = (byte)GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
                this.d_careerLevelRequirements[n9][n7][5] = GameConstants.PMFile_readByte();
            }
        }
        this.d_careerLevelDescStrings = ArrayOptimizer.Optimize(this.d_careerLevelDescStrings);
        this.d_careerLevelIncomes = ArrayOptimizer.Optimize(this.d_careerLevelIncomes);
        this.d_careerLevelFlags = ArrayOptimizer.Optimize(this.d_careerLevelFlags);
        this.d_careerLevelHoursStarts = ArrayOptimizer.Optimize(this.d_careerLevelHoursStarts);
        this.d_careerLevelHoursEnds = ArrayOptimizer.Optimize(this.d_careerLevelHoursEnds);
        this.d_careerLevelRequirements = ArrayOptimizer.Optimize(this.d_careerLevelRequirements);
        this.m_personaAmount = GameConstants.PMFile_readByte();
        this.d_personaDescStrings = new short[this.m_personaAmount];
        this.d_personaLongDescStrings = new short[this.m_personaAmount];
        this.d_personaIcons = new short[this.m_personaAmount];
        this.d_personaFlags = new short[this.m_personaAmount];
        for (n9 = 0; n9 < this.m_personaAmount; ++n9) {
            this.d_personaDescStrings[n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_personaLongDescStrings[n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_personaIcons[n9] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_personaFlags[n9] = GameConstants.PMFile_readShort();
        }
        n9 = GameConstants.PMFile_readByte();
        this.d_dreamDescStrings = new short[n9];
        this.d_dreamFlags = new short[n9];
        for (n8 = 0; n8 < n9; ++n8) {
            this.d_dreamDescStrings[n8] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_dreamFlags[n8] = GameConstants.PMFile_readShort();
        }
        this.d_motiveCount = GameConstants.PMFile_readByte();
        this.d_motiveDescStrings = new short[this.d_motiveCount];
        this.d_motiveStartLevel = new int[this.d_motiveCount];
        this.d_motiveDecayRate = new int[this.d_motiveCount];
        this.d_motiveTriggersNeeds = new short[this.d_motiveCount];
        this.d_motiveTriggersNeedLevels = new int[this.d_motiveCount];
        this.d_motiveAnimHighs = new short[this.d_motiveCount];
        this.d_motiveAnimLows = new short[this.d_motiveCount];
        for (n8 = 0; n8 < this.d_motiveCount; ++n8) {
            this.d_motiveDescStrings[n8] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_motiveStartLevel[n8] = GameConstants.PMFile_readInt();
            this.d_motiveDecayRate[n8] = GameConstants.PMFile_readInt();
            this.d_motiveTriggersNeeds[n8] = GameConstants.PMFile_readShort();
            this.d_motiveTriggersNeedLevels[n8] = GameConstants.PMFile_readInt();
            this.d_motiveAnimHighs[n8] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_motiveAnimLows[n8] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
        }
        this.d_buffCount = GameConstants.PMFile_readByte();
        this.d_buffDescStringIds = new short[this.d_buffCount];
        this.d_buffTimeouts = new int[this.d_buffCount];
        this.d_buffTimeoutChains = new byte[this.d_buffCount];
        this.d_buffFlags = new byte[this.d_buffCount];
        this.d_buffTriggerMotives = new byte[this.d_buffCount][];
        this.d_buffTriggerMotiveLevels = new int[this.d_buffCount][];
        this.d_buffEffectMood = new byte[this.d_buffCount][];
        this.d_buffEffectMoodAmount = new byte[this.d_buffCount][];
        this.d_buffEffectMotive = new byte[this.d_buffCount][];
        this.d_buffEffectMotiveFactors = new int[this.d_buffCount][];
        for (n8 = 0; n8 < this.d_buffCount; ++n8) {
            this.d_buffDescStringIds[n8] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_buffTimeouts[n8] = GameConstants.PMFile_readInt();
            this.d_buffTimeoutChains[n8] = GameConstants.PMFile_readByte();
            this.d_buffFlags[n8] = GameConstants.PMFile_readByte();
            n7 = GameConstants.PMFile_readByte();
            this.d_buffTriggerMotives[n8] = new byte[n7];
            this.d_buffTriggerMotiveLevels[n8] = new int[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                this.d_buffTriggerMotives[n8][n6] = GameConstants.PMFile_readByte();
                this.d_buffTriggerMotiveLevels[n8][n6] = GameConstants.PMFile_readInt();
            }
            n6 = GameConstants.PMFile_readByte();
            this.d_buffEffectMood[n8] = new byte[n6];
            this.d_buffEffectMoodAmount[n8] = new byte[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                this.d_buffEffectMood[n8][n5] = (byte)GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
                this.d_buffEffectMoodAmount[n8][n5] = GameConstants.PMFile_readByte();
            }
            n6 = GameConstants.PMFile_readByte();
            this.d_buffEffectMotive[n8] = new byte[n6];
            this.d_buffEffectMotiveFactors[n8] = new int[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                this.d_buffEffectMotive[n8][n5] = GameConstants.PMFile_readByte();
                this.d_buffEffectMotiveFactors[n8][n5] = GameConstants.PMFile_readInt();
            }
        }
        this.d_buffTriggerMotives = ArrayOptimizer.Optimize(this.d_buffTriggerMotives);
        this.d_buffTriggerMotiveLevels = ArrayOptimizer.Optimize(this.d_buffTriggerMotiveLevels);
        this.d_buffEffectMood = ArrayOptimizer.Optimize(this.d_buffEffectMood);
        this.d_buffEffectMoodAmount = ArrayOptimizer.Optimize(this.d_buffEffectMoodAmount);
        this.d_buffEffectMotive = ArrayOptimizer.Optimize(this.d_buffEffectMotive);
        this.d_buffEffectMotiveFactors = ArrayOptimizer.Optimize(this.d_buffEffectMotiveFactors);
        n8 = GameConstants.PMFile_readByte();
        this.d_traitDescStrings = new short[n8];
        this.d_traitExcludes = new short[n8];
        for (n7 = 0; n7 < n8; ++n7) {
            this.d_traitDescStrings[n7] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_traitExcludes[n7] = GameConstants.PMFile_readByte();
        }
        this.d_numRelLevels = GameConstants.PMFile_readByte();
        n7 = GameConstants.PMFile_readByte();
        this.d_relStateDescStrings = new short[n7];
        this.d_relStateFlags = new byte[n7];
        this.d_relStateEffectAnims = new short[n7];
        this.d_relStateToStrings = new short[n7];
        this.d_relStateTriggerToStates = new byte[n7][];
        this.d_relStateTriggerLevels = new byte[n7][];
        this.d_relStateTriggerLevelValues = new short[n7][];
        for (n6 = 0; n6 < n7; ++n6) {
            this.d_relStateDescStrings[n6] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_relStateFlags[n6] = GameConstants.PMFile_readByte();
            this.d_relStateEffectAnims[n6] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_relStateToStrings[n6] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            n5 = GameConstants.PMFile_readUnsignedByte();
            this.d_relStateTriggerToStates[n6] = new byte[n5];
            this.d_relStateTriggerLevels[n6] = new byte[n5];
            this.d_relStateTriggerLevelValues[n6] = new short[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                this.d_relStateTriggerToStates[n6][n4] = GameConstants.PMFile_readByte();
                this.d_relStateTriggerLevels[n6][n4] = GameConstants.PMFile_readByte();
                this.d_relStateTriggerLevelValues[n6][n4] = GameConstants.PMFile_readShort();
            }
        }
        this.d_relStateTriggerToStates = ArrayOptimizer.Optimize(this.d_relStateTriggerToStates);
        this.d_relStateTriggerLevels = ArrayOptimizer.Optimize(this.d_relStateTriggerLevels);
        this.d_relStateTriggerLevelValues = ArrayOptimizer.Optimize(this.d_relStateTriggerLevelValues);
        this.d_numSims = GameConstants.PMFile_readByte();
        this.d_simNameStrings = new short[this.d_numSims];
        this.d_simMacromapColors = new byte[this.d_numSims];
        this.d_simAttributes = new byte[this.d_numSims][10];
        this.d_simHomes = new short[this.d_numSims];
        this.d_simFlags = new byte[this.d_numSims];
        this.d_simPartners = new byte[this.d_numSims];
        this.d_simCareers = new byte[this.d_numSims];
        this.d_simCareerLevels = new byte[this.d_numSims];
        this.d_simTraits = new byte[this.d_numSims][];
        this.d_simQuests = new byte[this.d_numSims][];
        for (n6 = 0; n6 < this.d_numSims; ++n6) {
            this.d_simNameStrings[n6] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_simMacromapColors[n6] = GameConstants.PMFile_readByte();
            if (this.d_simMacromapColors[n6] == 2) {
                // empty if block
            }
            if (this.d_simMacromapColors[n6] == 3) {
                // empty if block
            }
            for (n5 = 0; n5 < 10; ++n5) {
                this.d_simAttributes[n6][n5] = GameConstants.PMFile_readByte();
            }
            this.d_simHomes[n6] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_simFlags[n6] = GameConstants.PMFile_readByte();
            this.d_simPartners[n6] = GameConstants.PMFile_readByte();
            this.d_simCareers[n6] = GameConstants.PMFile_readByte();
            this.d_simCareerLevels[n6] = GameConstants.PMFile_readByte();
            n5 = GameConstants.PMFile_readByte();
            this.d_simTraits[n6] = new byte[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                this.d_simTraits[n6][n4] = GameConstants.PMFile_readByte();
            }
            n4 = GameConstants.PMFile_readByte();
            this.d_simQuests[n6] = new byte[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.d_simQuests[n6][n3] = GameConstants.PMFile_readByte();
            }
        }
        ArrayOptimizer.Optimize(this.d_simTraits);
        ArrayOptimizer.Optimize(this.d_simQuests);
        this.d_numPresets = GameConstants.PMFile_readByte();
        this.d_simPresets = new byte[this.d_numPresets][12];
        for (n6 = 0; n6 < this.d_numPresets; ++n6) {
            for (n5 = 0; n5 < 12; ++n5) {
                this.d_simPresets[n6][n5] = GameConstants.PMFile_readByte();
            }
        }
        n6 = GameConstants.PMFile_readByte();
        this.d_commodityStringIds = new short[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            this.d_commodityStringIds[n5] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
        }
        this.d_numActions = GameConstants.PMFile_readShort();
        this.d_actionStringIds = new short[this.d_numActions];
        this.d_actionGroupStringIds = new short[this.d_numActions];
        this.d_actionFlags = new int[this.d_numActions];
        this.d_actionWorldArgs = new short[this.d_numActions];
        this.d_actionPhases = new byte[this.d_numActions][];
        this.d_actionConditionCommodities = new byte[this.d_numActions][];
        this.d_actionConditionTraits = new byte[this.d_numActions][];
        this.d_actionConditionRelStates = new int[this.d_numActions][];
        this.d_actionEffectFlags = new short[this.d_numActions][];
        this.d_actionAffectFriendships = new byte[this.d_numActions][];
        this.d_actionAffectRomances = new byte[this.d_numActions][];
        this.d_actionAffectCommodities = new byte[this.d_numActions][];
        this.d_actionAffectCommodityAmounts = new byte[this.d_numActions][];
        this.d_actionResponseActions = new short[this.d_numActions][];
        for (n5 = 0; n5 < this.d_numActions; ++n5) {
            this.d_actionStringIds[n5] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_actionGroupStringIds[n5] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_actionFlags[n5] = GameConstants.PMFile_readInt();
            this.d_actionWorldArgs[n5] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            n4 = GameConstants.PMFile_readByte();
            this.d_actionConditionCommodities[n5] = new byte[n4];
            this.d_actionConditionTraits[n5] = new byte[n4];
            this.d_actionConditionRelStates[n5] = new int[n4];
            this.d_actionEffectFlags[n5] = new short[n4];
            this.d_actionAffectFriendships[n5] = new byte[n4];
            this.d_actionAffectRomances[n5] = new byte[n4];
            this.d_actionAffectCommodities[n5] = new byte[n4];
            this.d_actionAffectCommodityAmounts[n5] = new byte[n4];
            this.d_actionResponseActions[n5] = new short[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.d_actionConditionCommodities[n5][n3] = GameConstants.PMFile_readByte();
                this.d_actionConditionTraits[n5][n3] = GameConstants.PMFile_readByte();
                n2 = GameConstants.PMFile_readInt();
                this.d_actionConditionRelStates[n5][n3] = (n2 & 1) != 0 ? ~n2 : n2;
                this.d_actionEffectFlags[n5][n3] = GameConstants.PMFile_readShort();
                this.d_actionAffectFriendships[n5][n3] = GameConstants.PMFile_readByte();
                this.d_actionAffectRomances[n5][n3] = GameConstants.PMFile_readByte();
                this.d_actionAffectCommodities[n5][n3] = GameConstants.PMFile_readByte();
                this.d_actionAffectCommodityAmounts[n5][n3] = GameConstants.PMFile_readByte();
                this.d_actionResponseActions[n5][n3] = GameConstants.PMFile_readShort();
            }
            n3 = GameConstants.PMFile_readByte();
            if ((this.d_actionFlags[n5] & 0x10000000) != 0) {
                this.d_actionPhases[n5] = this.d_actionPhases[26];
                continue;
            }
            this.d_actionPhases[n5] = new byte[n3];
            n = this.d_actionPhases[n5].length;
            for (n2 = 0; n2 < n; ++n2) {
                this.d_actionPhases[n5][n2] = GameConstants.PMFile_readByte();
            }
        }
        this.d_actionPhases = ArrayOptimizer.Optimize(this.d_actionPhases);
        this.d_actionConditionCommodities = ArrayOptimizer.Optimize(this.d_actionConditionCommodities);
        this.d_actionConditionTraits = ArrayOptimizer.Optimize(this.d_actionConditionTraits);
        this.d_actionConditionRelStates = ArrayOptimizer.Optimize(this.d_actionConditionRelStates);
        this.d_actionEffectFlags = ArrayOptimizer.Optimize(this.d_actionEffectFlags);
        this.d_actionAffectFriendships = ArrayOptimizer.Optimize(this.d_actionAffectFriendships);
        this.d_actionAffectRomances = ArrayOptimizer.Optimize(this.d_actionAffectRomances);
        this.d_actionAffectCommodities = ArrayOptimizer.Optimize(this.d_actionAffectCommodities);
        this.d_actionAffectCommodityAmounts = ArrayOptimizer.Optimize(this.d_actionAffectCommodityAmounts);
        this.d_actionResponseActions = ArrayOptimizer.Optimize(this.d_actionResponseActions);
        n5 = GameConstants.PMFile_readByte();
        this.d_chanceCardPrompts = new short[n5];
        this.d_chanceCardYesPercents = new byte[n5];
        this.d_chanceCardNoPercents = new byte[n5];
        this.d_chanceCardResultYes1s = new byte[n5];
        this.d_chanceCardResultYes1Strings = new short[n5];
        this.d_chanceCardResultYes2s = new byte[n5];
        this.d_chanceCardResultYes2Strings = new short[n5];
        this.d_chanceCardResultNo1s = new byte[n5];
        this.d_chanceCardResultNo1Strings = new short[n5];
        this.d_chanceCardResultNo2s = new byte[n5];
        this.d_chanceCardResultNo2Strings = new short[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            this.d_chanceCardPrompts[n4] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_chanceCardYesPercents[n4] = GameConstants.PMFile_readByte();
            this.d_chanceCardNoPercents[n4] = GameConstants.PMFile_readByte();
            this.d_chanceCardResultYes1s[n4] = GameConstants.PMFile_readByte();
            this.d_chanceCardResultYes1Strings[n4] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_chanceCardResultYes2s[n4] = GameConstants.PMFile_readByte();
            this.d_chanceCardResultYes2Strings[n4] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_chanceCardResultNo1s[n4] = GameConstants.PMFile_readByte();
            this.d_chanceCardResultNo1Strings[n4] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_chanceCardResultNo2s[n4] = GameConstants.PMFile_readByte();
            this.d_chanceCardResultNo2Strings[n4] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
        }
        n4 = GameConstants.PMFile_readByte();
        this.d_questPrompts = new short[n4];
        this.d_questMessages = new short[n4];
        this.d_questFinishActions = new short[n4];
        this.d_questGiveItem = new short[n4];
        this.d_questRewardCash = new short[n4];
        this.d_questTriggerActions = new short[n4][];
        for (n3 = 0; n3 < n4; ++n3) {
            this.d_questPrompts[n3] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_questMessages[n3] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_questFinishActions[n3] = GameConstants.PMFile_readShort();
            this.d_questGiveItem[n3] = GameConstants.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_questRewardCash[n3] = GameConstants.PMFile_readShort();
            n2 = GameConstants.PMFile_readByte();
            this.d_questTriggerActions[n3] = new short[n2];
            for (n = 0; n < n2; ++n) {
                this.d_questTriggerActions[n3][n] = GameConstants.PMFile_readShort();
            }
        }
        GameConstants.PMFile_closeFile();
    }

    public int getGameTimeAbs() {
        return this.m_timeTotal;
    }

    public int getGameTime() {
        return this.getGameTime(this.m_timeTotal);
    }

    public int getGameTime(int n) {
        return n % 1440;
    }

    public int getGameDay() {
        return this.getGameDay(this.m_timeTotal);
    }

    public int getGameDay(int n) {
        return n / 1440 % 7;
    }

    public int getGameMidnight(int n) {
        return n / 1440 * 1440;
    }

    public int getTotalDays() {
        return (this.getGameTimeAbs() - 840) / 1440;
    }

    public int getMoney() {
        return this.m_money;
    }

    public void adjustMoney(int n, int n2) {
        this.m_money += n;
        if (n < 0) {
            this.m_moneySpent -= n;
        }
        switch (n2) {
            default: {
                break;
            }
            case 0: {
                this.m_moneyEarned += n;
                break;
            }
            case 1: {
                this.m_moneySpentOnGearMaintenance -= n;
                break;
            }
            case 2: {
                this.m_moneySpentOnSnacks -= n;
                break;
            }
            case 3: {
                this.m_moneyEarnedOnProducibles += n;
            }
        }
    }

    private void initGameTimeMoney() {
        this.m_timeTotal = 840;
        this.m_money = 700;
        this.m_moneySpent = 0;
        this.m_moneySpentOnGearMaintenance = 0;
        this.m_moneySpentOnSnacks = 0;
        this.m_moneyEarned = 0;
        this.m_moneyEarnedOnProducibles = 0;
        this.m_fastForward = false;
    }

    public void setFastforward(boolean bl) {
        this.m_fastForward = bl;
    }

    public boolean getFastforward() {
        return this.m_fastForward;
    }

    private void updateGameTime(int n) {
        this.m_timeTimer += n;
        if (this.m_timeTimer > 1000) {
            int n2 = this.m_timeTimer / 1000;
            this.m_timeTimer -= n2 * 1000;
            int n3 = this.m_timeTotal;
            this.m_timeTotal += n2;
            StateInGame.checkGameTimeTriggers(n3, this.m_timeTotal);
        }
    }

    public int getCostForAction(int n) {
        if (n == 132) {
            return 10;
        }
        if (n == 174) {
            return 30;
        }
        if (n == 175) {
            return 2;
        }
        if (n == 177) {
            return 4;
        }
        return 0;
    }

    public int getDesiredWakeupTime(int n) {
        int n2 = 480;
        if (this.hasSimGotTrait(n, 10) != -1) {
            n2 = 540;
        } else if (this.hasSimGotTrait(n, 11) != -1) {
            n2 = 420;
        }
        return n2;
    }

    public int getWakeupTime(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getGameTimeAbs();
        if (n == 0) {
            n5 = this.m_motiveLevelsF[1];
            n4 = 65536 - Camera.MathExt_Fdiv(n5, 0x640000);
            n3 = n6 + Camera.MathExt_Fmul(n4, 600);
        } else {
            n3 = n6 + 600;
        }
        n5 = this.getSimCareer(n);
        if (n5 != -1 && (n2 = (n4 = this.getNextJobStartTime(n, n6)) - 60) > n6 && n2 - n6 < 1440) {
            n3 = Math.min(n2, n3);
        }
        return n3;
    }

    public void updateSkipWorking() {
        int n;
        int n2;
        int n3 = this.getSimCareer(0);
        int n4 = this.getCareerLevelHoursEnd(n3, n2 = this.getSimCareerLevel(0));
        int n5 = n4 - (n = this.getGameTime());
        if (n5 < 0) {
            n5 += 1440;
        }
        int n6 = n5 * 1000;
        this.updateGameTime(n6);
        this.adjustMotiveLevel(1, -2621440);
        this.adjustMotiveLevel(0, -1310720);
        this.adjustMotiveLevel(3, -1310720);
        this.adjustMotiveLevel(5, -1638400);
        this.adjustMotiveLevel(2, this.getMotiveLevel(2) < 0x230000 ? 0x320000 : -983040);
        this.delayAlerts();
    }

    public void updateSkipSleeping(int n) {
        int n2 = this.getGameTimeAbs();
        int n3 = (n - n2) * 1000;
        this.updateGameTime(n3);
        this.adjustMotiveLevel(1, 0x640000);
        this.adjustMotiveLevel(2, -655360);
        this.adjustMotiveLevelWithBuffCheck(0, -1310720, 0);
        this.adjustMotiveLevelWithBuffCheck(3, -983040, 8);
        this.delayAlerts();
    }

    private void initInventory() {
        if (this.m_inventory == null) {
            this.m_inventory = new byte[Main.m_simWorld.d_itemDescStringIds.length];
        }
        ArrayHandler.fillArray(this.m_inventory, 0);
    }

    public int getInventoryCount(int n) {
        return this.m_inventory[n];
    }

    public int getInventoryNthCount() {
        return this.m_inventory.length - ArrayHandler.countOf(0, this.m_inventory);
    }

    public int getInventoryNthItem(int n) {
        return ArrayHandler.indexOfNthElement(n, this.m_inventory, 0);
    }

    public int adjustInventory(int n, int n2) {
        int n3 = Math.min(n2, Main.m_simWorld.d_itemMaxInventory[n] - this.m_inventory[n]);
        int n4 = n;
        this.m_inventory[n4] = (byte)(this.m_inventory[n4] + (byte)n3);
        return n3;
    }

    public void createPlantContextMenu(short[] sArray, short[] sArray2, int n) {
        short s = this.d_actionStringIds[n];
        Main.menuClear(sArray, s);
        Main.menuClear(sArray2, s);
        byte[] byArray = this.m_inventory;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] <= 0 || (Main.m_simWorld.d_itemFlags[i] & 0x20) == 0) continue;
            Main.menuAppendItem(sArray, Main.m_simWorld.d_itemDescStringIds[i]);
            Main.menuAppendItem(sArray2, n);
        }
    }

    public void createCookContextMenu(short[] sArray, short[] sArray2, int n) {
        short s = this.d_actionStringIds[n];
        Main.menuClear(sArray, s);
        Main.menuClear(sArray2, s);
        byte[] byArray = this.m_inventory;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] <= 0 || (Main.m_simWorld.d_itemFlags[i] & 0x400) == 0) continue;
            Main.menuAppendItem(sArray, Main.m_simWorld.d_itemDescStringIds[i]);
            Main.menuAppendItem(sArray2, n);
        }
    }

    public boolean startRecipe(int n) {
        int n2;
        int n3 = Main.m_simWorld.d_recipeIngredients[n].length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.getInventoryCount(Main.m_simWorld.d_recipeIngredients[n][n2]) >= 1) continue;
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.adjustInventory(Main.m_simWorld.d_recipeIngredients[n][n2], -1);
        }
        this.m_activeRecipe = n;
        return true;
    }

    private void initSkills() {
        int n = this.getSkillCount();
        if (this.m_skillLevelsF == null) {
            this.m_skillLevelsF = new int[n];
        }
        ArrayHandler.fillArray(this.m_skillLevelsF, 0);
        this.consumablesCounter = new int[n][2];
        for (int i = 0; i < this.consumablesCounter.length; ++i) {
            ArrayHandler.fillArray(this.consumablesCounter[i], 0);
        }
    }

    public int getSkillLevel(int n) {
        return this.m_skillLevelsF[n];
    }

    public int getSkillCount() {
        return this.d_skillDescStrings.length;
    }

    public int getSkillDesc(int n) {
        return this.d_skillDescStrings[n];
    }

    public int[] getSkillConsumables(int n) {
        return this.d_skillConsumables[n];
    }

    public void consumeTools(int n) {
        if (this.getSkillRank(n) <= 1 || this.getSkillRank(n) == 5) {
            return;
        }
        int n2 = 0;
        if (this.getSkillRank(n) == 3) {
            n2 = 1;
        } else if (this.getSkillRank(n) == 4) {
            n2 = 2;
        }
        for (int i = 0; i < 2; ++i) {
            int[] nArray = this.consumablesCounter[n];
            int n3 = i;
            nArray[n3] = nArray[n3] + 1;
            if (this.consumablesCounter[n][i] < this.d_skillConsumablesUses[n][i] + n2) continue;
            this.consumablesCounter[n][i] = 0;
            this.adjustInventory(this.d_skillConsumables[n][i], -1);
        }
    }

    public int getSkillLevelDesc(int n) {
        return this.d_skillLevelDescStrings[n][this.getSkillRank(n)];
    }

    public int getSkillRank(int n) {
        return this.m_skillLevelsF[n] / 65536;
    }

    public void increaseSkill(int n) {
        int[] nArray = this.m_skillLevelsF;
        int n2 = this.getSkillRank(n);
        if (n2 < 5) {
            if (GameConstants.Minigame_inspired) {
                int n3 = n;
                nArray[n3] = nArray[n3] + this.d_skillRates[n][n2] * 200 / 100;
                GameConstants.Minigame_inspired = false;
            } else if (StateInGame.m_mapMode == 0) {
                int n4 = n;
                nArray[n4] = nArray[n4] + this.d_skillRates[n][n2] * 50 / 100;
            } else {
                int n5 = n;
                nArray[n5] = nArray[n5] + this.d_skillRates[n][n2];
            }
            nArray[n] = Math.min(nArray[n], 65536 * (n2 + 1));
        }
    }

    private void initCareer() {
        this.d_simCareers[0] = -1;
        this.d_simCareerLevels[0] = 0;
        this.m_careerAcceptDay = (byte)-1;
        this.m_careerDaysWorked = 0;
        this.m_careerDaysMissed = 0;
        if (this.m_careerLevelsAttained == null) {
            this.m_careerLevelsAttained = new byte[this.d_careerDescStrings.length];
        }
        ArrayHandler.fillArray(this.m_careerLevelsAttained, 0);
    }

    public void careerAcceptJob(int n, int n2) {
        byte by = this.d_simCareers[0];
        byte by2 = this.d_simCareerLevels[0];
        this.d_simCareers[0] = (byte)n;
        this.d_simCareerLevels[0] = (byte)n2;
        if (n != -1) {
            this.m_careerLevelsAttained[n] = (byte)n2;
        }
        this.m_careerDaysWorked = 0;
        this.m_careerDaysMissed = 0;
        if (n != -1) {
            if (by != n) {
                this.m_careerAcceptDay = (byte)this.getGameDay();
            }
            int n3 = by == n ? (n2 > by2 ? 647 : 265) : 417;
            int n4 = this.getNextJobStartTime(0, this.getGameTimeAbs());
            int n5 = this.getGameDay(n4);
            int n6 = this.getGameDay(this.getGameTimeAbs() + 1440) == n5 ? 257 : DAY_STRINGS[n5];
            SDKString sDKString = AnimationManager.TextHandler_getString(n6);
            SDKString sDKString2 = AnimationManager.TextHandler_clearStringBuffer();
            AnimationManager.TextHandler_appendTimeToBuffer24Hour(this.d_careerLevelHoursStarts[n][n2]);
            SDKString sDKString3 = AnimationManager.TextHandler_getString(Main.m_simWorld.d_objectStringIds[this.d_careerRabbitHoles[n]]);
            AnimationManager.TextHandler_dynamicString(-11, n3, sDKString, sDKString2, sDKString3);
            int n7 = 0;
            if (by == n) {
                if (n2 > by2) {
                    n7 = 4;
                    Main.m_simData.dreamCompleteEvent(18);
                    if (n2 == this.d_careerLevelDescStrings[n].length - 1) {
                        if (this.m_persona == 0 && n == 0) {
                            this.dreamCompleteEvent(19);
                        }
                        if (this.m_persona == 2 && n == 2) {
                            this.dreamCompleteEvent(36);
                        }
                        if (this.m_persona == 1 && n == 1) {
                            this.dreamCompleteEvent(25);
                        }
                        if (this.m_persona == 3 && n == 3) {
                            this.dreamCompleteEvent(48);
                        }
                    }
                }
            } else if (n != -1) {
                n7 = 3;
            }
            int n8 = this.getCareerLevelDescString(n, n2);
            StateInGame.showMessageBox(-11, n8, n7);
        }
    }

    public int careerDayWorked() {
        int n = this.getSimCareer(0);
        int n2 = this.getSimCareerLevel(0);
        int n3 = this.getCareerLevelIncome(n, n2);
        this.adjustMoney(n3, -1);
        this.m_careerDaysWorked = (short)(this.m_careerDaysWorked + 1);
        if (this.m_careerDaysWorked % 3 == 2 && this.m_careerDaysMissed > 0) {
            this.m_careerDaysMissed = (short)(this.m_careerDaysMissed - 1);
        }
        return n3;
    }

    public void careerDayMissed() {
        this.m_careerDaysMissed = (short)(this.m_careerDaysMissed + 1);
        if (this.m_careerDaysMissed >= 3) {
            this.careerAcceptJob(-1, 0);
            ++this.m_numTimesFired;
        }
    }

    public int getRequirementValue(int n, int n2) {
        int n3 = 0;
        switch (n) {
            default: {
                return this.getSkillRank(0);
            }
            case 1: {
                return this.getSkillRank(2);
            }
            case 2: {
                return this.getSkillRank(1);
            }
            case 3: {
                return this.getSkillRank(3);
            }
            case 4: {
                for (int i = 1; i < this.d_numSims; ++i) {
                    if ((this.getRelStateFlags(this.m_currentRelStates[i]) & 0x10) == 0) continue;
                    ++n3;
                }
                return n3;
            }
            case 5: {
                switch (n2) {
                    case 0: {
                        for (int i = 1; i < this.d_numSims; ++i) {
                            if ((this.getRelStateFlags(this.m_currentRelStates[i]) & 0x10) == 0 || !this.isTraitDiscovered(i, 17)) continue;
                            ++n3;
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 1; i < this.d_numSims; ++i) {
                            if ((this.getRelStateFlags(this.m_currentRelStates[i]) & 0x10) == 0 || !this.isTraitDiscovered(i, 19)) continue;
                            ++n3;
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 1; i < this.d_numSims; ++i) {
                            if ((this.getRelStateFlags(this.m_currentRelStates[i]) & 0x10) == 0 || !this.isTraitDiscovered(i, 18)) continue;
                            ++n3;
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 1; i < this.d_numSims; ++i) {
                            if ((this.getRelStateFlags(this.m_currentRelStates[i]) & 0x10) == 0 || !this.isTraitDiscovered(i, 20)) continue;
                            ++n3;
                        }
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                return n3;
            }
            case 6: {
                switch (n2) {
                    case 0: {
                        if (this.getInventoryCount(2) > 0) {
                            return 3;
                        }
                        if (this.getInventoryCount(1) > 0) {
                            return 2;
                        }
                        if (this.getInventoryCount(0) > 0) {
                            return 1;
                        }
                        return 0;
                    }
                    case 2: {
                        if (this.getInventoryCount(9) > 0) {
                            return 3;
                        }
                        if (this.getInventoryCount(8) > 0) {
                            return 2;
                        }
                        if (this.getInventoryCount(7) > 0) {
                            return 1;
                        }
                        return 0;
                    }
                    case 1: {
                        if (this.getInventoryCount(16) > 0) {
                            return 3;
                        }
                        if (this.getInventoryCount(15) > 0) {
                            return 2;
                        }
                        if (this.getInventoryCount(14) > 0) {
                            return 1;
                        }
                        return 0;
                    }
                    case 3: {
                        if (this.getInventoryCount(23) > 0) {
                            return 3;
                        }
                        if (this.getInventoryCount(22) > 0) {
                            return 2;
                        }
                        if (this.getInventoryCount(21) > 0) {
                            return 1;
                        }
                        return 0;
                    }
                }
                return 0;
            }
            case 7: 
        }
        return this.m_careerDaysWorked;
    }

    public int getRequirementName(int n, int n2) {
        switch (n) {
            case 0: {
                return 818;
            }
            case 1: {
                return 825;
            }
            case 2: {
                return 832;
            }
            case 3: {
                return 839;
            }
            case 4: {
                return 346;
            }
            case 5: {
                switch (n2) {
                    case 0: {
                        return 185;
                    }
                    case 2: {
                        return 183;
                    }
                    case 1: {
                        return 184;
                    }
                    case 3: {
                        return 186;
                    }
                }
                return 557;
            }
            case 6: {
                switch (n2) {
                    case 0: {
                        return 181;
                    }
                    case 2: {
                        return 180;
                    }
                    case 1: {
                        return 179;
                    }
                    case 3: {
                        return 182;
                    }
                }
                return 557;
            }
            case 7: {
                return 178;
            }
        }
        return 557;
    }

    public boolean careerRequirementsMet(int n, int n2) {
        byte by;
        int n3;
        int n4;
        int n5;
        byte[] byArray = this.d_careerLevelRequirements[n][n2];
        byte by2 = byArray[0];
        byte by3 = byArray[1];
        if (by2 != -1 && (n5 = this.getRequirementValue(by2, n)) < by3) {
            return false;
        }
        n5 = byArray[2];
        byte by4 = byArray[3];
        if (n5 != -1 && (n4 = this.getRequirementValue(n5, n)) < by4) {
            return false;
        }
        n4 = byArray[4];
        byte by5 = byArray[5];
        if (!(n4 == -1 || this.isCurrentWorkSearchRehire && n4 == 7 || (n3 = this.getRequirementValue(n4, n)) >= by5)) {
            return false;
        }
        if (n2 >= 1 && (this.getRelStateFlags(by = this.m_currentRelStates[n3 = this.getCareerBoss(n)]) & 2) != 0) {
            return false;
        }
        this.isCurrentWorkSearchRehire = false;
        return true;
    }

    public int getJobSearchCareerFromObject(MapObject mapObject) {
        return ArrayHandler.indexOf(mapObject.getType(), this.d_careerRabbitHoles);
    }

    public int getJobSearchLevel(int n) {
        if (n == -1) {
            return 0;
        }
        if (this.m_careerLevelsAttained[n] != 0) {
            this.isCurrentWorkSearchRehire = true;
        }
        int n2 = Math.max(this.m_careerLevelsAttained[n] - 1, 0);
        return n2;
    }

    public boolean isItAWorkDayToday() {
        int n = 0;
        if (this.d_simCareers[n] == -1) {
            return false;
        }
        short s = this.d_careerLevelFlags[this.d_simCareers[n]][this.d_simCareerLevels[n]];
        int n2 = DAY_FLAGS[this.getGameDay(this.getGameTimeAbs())];
        return (s & n2) != 0;
    }

    public boolean isTimeInRange(int n, int n2, int n3) {
        if ((n2 = (n2 + 1440) % 1440) < (n3 = (n3 + 1440) % 1440)) {
            return n >= n2 && n <= n3;
        }
        return n >= n2 || n <= n3;
    }

    public int getTimeFlags(int n) {
        return this.getTimeFlags(n, this.getGameTimeAbs());
    }

    public int getTimeFlags(int n, int n2) {
        int n3 = 0;
        int n4 = this.getGameDay(n2);
        int n5 = this.getGameTime(n2);
        int n6 = this.getDesiredWakeupTime(n);
        int n7 = n6 - 600;
        byte by = this.d_simCareers[n];
        if (by == -1) {
            n3 |= 8;
        } else {
            byte by2 = this.d_simCareerLevels[n];
            short s = this.d_careerLevelHoursStarts[by][by2];
            if (n == 0 && n4 == this.m_careerAcceptDay) {
                n3 |= 8;
            } else {
                int n8;
                short s2;
                if (n == 0) {
                    this.m_careerAcceptDay = (byte)-1;
                }
                if (((s2 = this.d_careerLevelFlags[by][by2]) & (n8 = DAY_FLAGS[n4])) != 0) {
                    short s3 = this.d_careerLevelHoursEnds[by][by2];
                    n3 = n5 < s - 30 ? (n3 |= 8) : (n5 < s ? (n3 |= 1) : (n5 < s + 60 ? (n3 |= 2) : (n5 < s3 ? (n3 |= 4) : (n3 |= 8))));
                } else {
                    n3 |= 8;
                }
            }
            n7 = s - 660;
            n6 = s - 60;
        }
        if (this.isTimeInRange(n5, n7, n6)) {
            n3 |= 0x10;
        }
        return n3;
    }

    public int getNextJobStartTime(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getSimCareer(n);
        int n6 = this.getSimCareerLevel(n);
        int n7 = this.getCareerLevelFlags(n5, n6);
        int n8 = this.getCareerLevelHoursStart(n5, n6);
        int n9 = this.getGameTime(n2);
        int n10 = n4 = this.getGameDay(n2);
        for (n3 = 0; n3 < 7 && ((n7 & DAY_FLAGS[n10 = (n4 + n3) % 7]) == 0 || n == 0 && n10 == this.m_careerAcceptDay || n10 == n4 && n9 >= n8); ++n3) {
        }
        n3 = this.getGameMidnight(this.getGameTimeAbs()) + n8;
        if (n10 != n4) {
            n3 += (n10 - n4 + 7) % 7 * 1440;
        }
        return n3;
    }

    private boolean isPlaceForWork(MapObject mapObject, int n) {
        byte by = this.d_simCareers[n];
        if (by == -1) {
            return false;
        }
        if (mapObject != null) {
            int n2 = this.getCareerRabbitHole(by);
            return mapObject.getType() == n2;
        }
        return false;
    }

    public boolean isTimeForWork(MapObject mapObject, int n) {
        if (mapObject != null && !this.isPlaceForWork(mapObject, n)) {
            return false;
        }
        int n2 = this.getTimeFlags(n);
        return (n2 & 3) != 0;
    }

    public int getCareerLevelCount(int n) {
        return this.d_careerLevelDescStrings[n].length;
    }

    public int getCareerDescString(int n) {
        if (n == -1) {
            return 203;
        }
        return this.d_careerDescStrings[n];
    }

    public int getCareerStreamer(int n) {
        return this.d_careerStreamers[n];
    }

    public int getCareerRabbitHole(int n) {
        return this.d_careerRabbitHoles[n];
    }

    public int getCareerBoss(int n) {
        return this.d_careerBosses[n];
    }

    public int getCareerDeathString() {
        byte by = this.d_simCareers[0];
        if (Main.randPercent() < 50) {
            return this.d_careerFreakDeath1s[by];
        }
        return this.d_careerFreakDeath2s[by];
    }

    public int getCareerFailString(int n, int n2) {
        if (n2 == Main.m_simData.getCareerLevelCount(n) - 1) {
            return this.d_careerRaiseFail2[n];
        }
        return this.d_careerRaiseFail1[n];
    }

    public int getCareerLevelDescString(int n, int n2) {
        return this.d_careerLevelDescStrings[n][n2];
    }

    public int getCareerLevelIncome(int n, int n2) {
        return this.d_careerLevelIncomes[n][n2];
    }

    public int getCareerLevelFlags(int n, int n2) {
        return this.d_careerLevelFlags[n][n2];
    }

    public int getCareerLevelFlagsPlayer() {
        int n = this.getSimCareer(0);
        int n2 = this.getSimCareerLevel(0);
        if (n >= 0 && n2 >= 0) {
            return this.d_careerLevelFlags[n][n2];
        }
        return 0;
    }

    public int getCareerLevelHoursStart(int n, int n2) {
        return this.d_careerLevelHoursStarts[n][n2];
    }

    public int getCareerLevelHoursEnd(int n, int n2) {
        return this.d_careerLevelHoursEnds[n][n2];
    }

    public byte[] getCareerLevelRequirements(int n, int n2) {
        return this.d_careerLevelRequirements[n][n2];
    }

    public int getPersonaIcon() {
        if (this.m_persona == -1) {
            return this.d_personaIcons[0];
        }
        return this.d_personaIcons[this.m_persona];
    }

    public int getPersonaFlags() {
        if (this.m_persona == -1) {
            return 0;
        }
        return this.d_personaFlags[this.m_persona];
    }

    public int getPersonaNthGoalCount() {
        return ArrayHandler.countOfFlags(this.getPersonaFlags(), this.d_dreamFlags);
    }

    public int getPersonaNthGoalItem(int n) {
        return ArrayHandler.indexOfNthElementFlags(n, this.d_dreamFlags, this.getPersonaFlags());
    }

    private int getPersonaActionFlags() {
        switch (this.m_persona) {
            default: {
                return 0;
            }
            case 0: {
                return 0x1000000;
            }
            case 1: {
                return 0x2000000;
            }
            case 2: 
        }
        return 0x4000000;
    }

    public boolean showPersonaComplete() {
        return this.m_personaGoalsCompletedAll && !this.m_personaGoalsCompletedAllShown;
    }

    private void initDreams() {
        this.m_dream = (byte)-1;
        this.m_dreamTimer = 115000;
        if (this.m_promises == null) {
            this.m_promises = new byte[4];
            this.m_woohooTimes = new int[10];
            this.m_woohooPartners = new int[10];
        }
        ArrayHandler.fillArray(this.m_promises, -1);
        this.m_personaGoalsCompleted = 0;
        this.m_personaGoalsCompletedAll = false;
        this.m_personaGoalsCompletedAllShown = false;
        ArrayHandler.fillArray(this.m_woohooTimes, -1);
        ArrayHandler.fillArray(this.m_woohooPartners, -1);
        this.m_quickLinkFlags = 0;
    }

    private void updateDreams(int n) {
        this.m_dreamTimer += n;
        if (this.m_dream != -1) {
            if (this.m_dreamTimer > 240000) {
                StateInGame.showExpiredDream(this.m_dream);
                this.m_dream = (byte)-1;
                this.m_dreamTimer = 0;
            }
        } else if (this.m_dreamTimer > 120000) {
            this.m_dream = (byte)this.dreamNew();
            this.m_dreamTimer = 0;
            StateInGame.showNewDream();
        }
    }

    private int dreamNew() {
        int n;
        int n2 = this.d_dreamFlags.length;
        int n3 = -1;
        int n4 = -1;
        boolean bl = true;
        int[] nArray = null;
        switch (this.m_persona) {
            case 0: {
                nArray = new int[]{8, 0, 14};
                break;
            }
            case 2: {
                nArray = new int[]{32, 30, 31};
                break;
            }
            case 1: {
                nArray = new int[]{7, 1, 2};
                break;
            }
            case 3: {
                nArray = new int[]{45, 41, 46};
                break;
            }
        }
        if (nArray != null) {
            for (n = 0; n < nArray.length; ++n) {
                if (ArrayHandler.Rms_isGoalCompleted((int)nArray[n]) || this.getDreamSlot(nArray[n]) != -1) continue;
                n3 = nArray[n];
                bl = false;
                break;
            }
        }
        nArray = null;
        if (bl) {
            for (n = 0; n < n2; ++n) {
                n4 = Main.rand(0, n2 - 1);
                if (ArrayHandler.Rms_isGoalCompleted(n4) || this.getDreamSlot(n4) != -1 || (this.d_dreamFlags[n4] & 2) != 0 || !this.dreamSuitable(n4)) continue;
                n3 = n4;
                break;
            }
        }
        if (n3 != -1) {
            ArrayHandler.Rms_setGoalDiscovered(n3);
        }
        return n3;
    }

    public void dreamToPromise() {
        int n = this.getDreamSlot(-1);
        if (n != -1 && this.m_dream != -1) {
            this.m_promises[n] = this.m_dream;
            this.m_dream = (byte)-1;
            this.m_dreamTimer = 0;
            StateInGame.showNewPromise(n);
        }
    }

    public boolean isDreamToPromisePossible() {
        return ArrayHandler.indexOf(-1, this.m_promises) != -1;
    }

    private boolean dreamSuitable(int n) {
        switch (n) {
            case 24: {
                return this.d_simCareers[0] == 0;
            }
            case 40: {
                return this.d_simCareers[0] == 2;
            }
            case 29: {
                return this.d_simCareers[0] == 1;
            }
            case 52: {
                return this.d_simCareers[0] == 3;
            }
            case 18: {
                if (this.d_simCareers[0] != -1) {
                    return this.d_simCareerLevels[0] < this.d_careerLevelDescStrings[this.d_simCareers[0]].length - 1;
                }
                return false;
            }
            case 3: {
                return Main.m_simWorld.areThereAnyRecipesLeftToBuy();
            }
            case 22: {
                GameConstants.Minigame_numSuccessfulPracticesConsecutive = 0;
                return true;
            }
        }
        return true;
    }

    public int getDreamSlot(int n) {
        return ArrayHandler.indexOf(n, this.m_promises);
    }

    public int getDream() {
        return this.m_dream;
    }

    public int getPromise(int n) {
        return this.m_promises[n];
    }

    public int getDreamDescString(int n) {
        if (n < 0 || n >= this.d_dreamDescStrings.length) {
            return 323;
        }
        return this.d_dreamDescStrings[n];
    }

    public int getTaskCount() {
        return this.d_dreamDescStrings.length;
    }

    public int getTaskFlags(int n) {
        return this.d_dreamFlags[n];
    }

    public void dreamCompleteEvent(int n) {
        int n2;
        int n3;
        boolean bl = false;
        int n4 = this.getDreamSlot(n);
        if (n4 != -1) {
            bl = true;
            this.m_promises[n4] = -1;
        } else if (this.m_dream == n) {
            bl = true;
            this.m_dream = (byte)-1;
            this.m_dreamTimer = 0;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = this.getTaskCount();
        int n8 = this.getPersonaFlags();
        for (n3 = 0; n3 < n7; ++n3) {
            if ((this.getTaskFlags(n3) & n8) == 0) continue;
            n2 = 1 << n5;
            if (n == n3 && (this.m_personaGoalsCompleted & n2) == 0) {
                this.m_personaGoalsCompleted |= n2;
                bl = true;
            }
            if ((this.m_personaGoalsCompleted & n2) != 0) {
                ++n6;
            }
            ++n5;
        }
        if (bl) {
            ArrayHandler.Rms_setGoalCompleted(n);
            StateInGame.showGoalCompleted(n, n4);
        }
        if (n6 == n5) {
            this.m_personaGoalsCompletedAll = true;
            if (!this.GSEndOfGameHasBeenScreenShown && !StateInGame.m_showEndOfGameScreen) {
                n3 = 1;
                for (n2 = 0; n2 < this.getTaskCount(); ++n2) {
                    if ((this.getTaskFlags(n2) & 2) != 0 || ArrayHandler.Rms_isGoalCompleted(n2)) continue;
                    n3 = 0;
                    break;
                }
                if (n3 != 0) {
                    StateInGame.m_showEndOfGameScreen = true;
                    this.adjustMoney(5000, -1);
                }
            }
        }
        if (bl && !StateInGame.m_showEndOfGameScreen && !this.showPersonaComplete()) {
            PMAudio.play(1, 1);
        }
        if (bl) {
            n3 = 0;
            switch (n) {
                default: {
                    break;
                }
                case 24: {
                    n3 = 1;
                    break;
                }
                case 40: {
                    n3 = 1;
                    break;
                }
                case 29: {
                    n3 = 1;
                    break;
                }
                case 52: {
                    n3 = 1;
                }
            }
            if (n3 != 0) {
                this.adjustMoney(600, 0);
            }
        }
    }

    public boolean registerWooHoo() {
        StateInGame.m_timeHit = 60;
        int[] nArray = this.m_woohooTimes;
        int n = this.getGameTimeAbs();
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < 10; ++i) {
            int n4 = nArray[i];
            if (n - n4 > 1440) {
                nArray[i] = -1;
                n4 = -1;
            }
            if (n4 == -1 && n3 == -1) {
                n3 = i;
                nArray[i] = n;
                n4 = n;
            }
            if (n4 == -1) continue;
            ++n2;
        }
        return n3 == -1 || n2 >= 10;
    }

    public boolean isPersonaGoalsCompleted(int n) {
        return (this.m_personaGoalsCompleted & 1 << n) != 0;
    }

    public boolean isQuickLinkVisited(int n) {
        int n2 = Main.m_simWorld.getObjectQuickLinkIndex(n);
        if (n2 != -1) {
            return (this.m_quickLinkFlags & 1 << n2) != 0;
        }
        return false;
    }

    public void setQuickLinkVisited(int n) {
        int n2 = Main.m_simWorld.getObjectQuickLinkIndex(n);
        if (n2 != -1) {
            this.m_quickLinkFlags |= 1 << n2;
        }
    }

    public int getMotiveCount() {
        return this.d_motiveCount;
    }

    public short getMotiveDescString(int n) {
        return this.d_motiveDescStrings[n];
    }

    public short getMotiveHighAnim(int n) {
        return this.d_motiveAnimHighs[n];
    }

    public short getMotiveLowAnim(int n) {
        return this.d_motiveAnimLows[n];
    }

    public int getMotiveLevel(int n) {
        return this.m_motiveLevelsF[n];
    }

    private void initMotives() {
        if (this.m_motiveLevelsF == null) {
            this.m_motiveLevelsF = new int[this.d_motiveCount];
            this.m_motiveDecaysF = new int[this.d_motiveCount];
            this.m_motiveDecayAdjustsF = new int[this.d_motiveCount];
            this.m_motiveDecayFactorsF = new int[this.d_motiveCount];
        }
        System.arraycopy(this.d_motiveStartLevel, 0, this.m_motiveLevelsF, 0, this.d_motiveCount);
        System.arraycopy(this.d_motiveDecayRate, 0, this.m_motiveDecaysF, 0, this.d_motiveCount);
        ArrayHandler.fillArray(this.m_motiveDecayAdjustsF, 0);
        ArrayHandler.fillArray(this.m_motiveDecayFactorsF, 65536);
        this.m_motiveTimer = 0;
    }

    private void updateMotives(int n) {
        this.m_motiveTimer += n;
        if (this.m_motiveTimer > 500) {
            this.m_motiveTimer = 0;
            int[] nArray = this.m_motiveDecaysF;
            int[] nArray2 = this.m_motiveDecayFactorsF;
            int[] nArray3 = this.m_motiveDecayAdjustsF;
            for (int i = 0; i < this.d_motiveCount; ++i) {
                int n2 = Camera.MathExt_Fmul(nArray2[i], nArray[i]);
                this.adjustMotiveLevel(i, n2 + nArray3[i] >> 1);
            }
            ArrayHandler.fillArray(this.m_motiveDecayAdjustsF, 0);
        }
    }

    public void adjustMotiveLevel(int n, int n2) {
        int[] nArray = this.m_motiveLevelsF;
        int n3 = n;
        nArray[n3] = nArray[n3] + n2;
        nArray[n] = Camera.MathExt_clip(nArray[n], 0, 0x640000);
    }

    private void adjustMotiveLevelWithBuffCheck(int n, int n2, int n3) {
        if (this.buffGetActiveSlot(n3) == -1) {
            this.adjustMotiveLevel(n, n2);
        }
    }

    public void setMotiveAdjust(int n, int n2) {
        this.m_motiveDecayAdjustsF[n] = n2;
    }

    public int getPlayerNeedFlags() {
        int n = 0;
        int[] nArray = this.m_motiveLevelsF;
        short[] sArray = this.d_motiveTriggersNeeds;
        int[] nArray2 = this.d_motiveTriggersNeedLevels;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= nArray2[i]) continue;
            n |= sArray[i];
        }
        return n;
    }

    private void initBuffs() {
        if (this.m_buffsActive == null) {
            this.m_buffsActive = new short[6];
            this.m_buffTimers = new int[6];
        }
        ArrayHandler.fillArray(this.m_buffsActive, -1);
        ArrayHandler.fillArray(this.m_buffTimers, 0);
    }

    private void updateBuffs(int n) {
        int n2;
        int n3;
        int n4;
        short[] sArray = this.m_buffsActive;
        int[] nArray = this.m_buffTimers;
        byte[] byArray = this.d_buffFlags;
        int[] nArray2 = this.d_buffTimeouts;
        byte[] byArray2 = this.d_buffTimeoutChains;
        block5: for (n4 = 0; n4 < 6; ++n4) {
            n3 = sArray[n4];
            if (n3 == -1) continue;
            if ((byArray[n3] & 2) == 0 && !this.buffTriggerConditionsExist(n3)) {
                this.removeActiveBuff(n3);
                continue;
            }
            n2 = nArray2[n3] * 1000;
            int n5 = n4;
            nArray[n5] = nArray[n5] + n;
            if (nArray[n4] <= n2) continue;
            nArray[n4] = n2;
            if (byArray2[n3] != -1) {
                this.setBuff(n4, byArray2[n3]);
                continue;
            }
            if (!this.buffTriggerConditionsExist(n3)) {
                this.removeActiveBuff(n3);
                continue;
            }
            switch (n3) {
                default: {
                    continue block5;
                }
                case 2: {
                    AnimationManager.TextHandler_dynamicString(-11, 814, ArrayHandler.Rms_getSimName());
                    StateInGame.killPlayer(-11);
                    this.delayAlerts();
                    return;
                }
                case 5: {
                    StateInGame.passOut();
                    this.delayAlerts();
                    this.setBuff(n4, 4);
                    return;
                }
                case 10: {
                    this.adjustMotiveLevel(2, 0x320000);
                    this.removeActiveBuff(n3);
                    if (!StateInGame.isMapMode()) {
                        if (!StateInGame.m_playerSim.isReady()) {
                            StateInGame.m_playerSim.interrupt();
                        }
                        StateInGame.m_playerSim.queueSimAction(4, null, 0, 0);
                    } else {
                        Main.m_simData.adjustMotiveLevel(3, -6553600);
                    }
                    this.delayAlerts();
                    return;
                }
            }
        }
        if (StateInGame.m_state != 9) {
            n4 = this.d_buffCount;
            for (n3 = 0; n3 < n4; ++n3) {
                int n6;
                n2 = n3;
                if ((byArray[n2] & 8) != 0 || !this.buffTriggerConditionsExist(n2)) continue;
                if (n2 == 3 && (StateInGame.m_playerSim.getSimPhase() == 48 || this.buffGetActiveSlot(6) != -1)) {
                    n2 = 6;
                }
                if ((n6 = this.buffGetActiveSlot(n2)) == -1) {
                    this.addActiveBuff(n2);
                    this.delayAlerts();
                    return;
                }
                if (n2 != 6) continue;
                this.m_buffTimers[n6] = 0;
            }
        }
    }

    private void applyBuffsToMood() {
        int n;
        int[] nArray = this.m_moodLevelsF;
        ArrayHandler.fillArray(nArray, 0);
        for (n = 0; n < 6; ++n) {
            short s = this.m_buffsActive[n];
            if (s == -1) continue;
            byte[] byArray = this.d_buffEffectMood[s];
            byte[] byArray2 = this.d_buffEffectMoodAmount[s];
            int n2 = byArray.length;
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[i];
                nArray[by] = nArray[by] + (byArray2[i] << 16);
            }
        }
        for (n = 0; n < 2; ++n) {
            nArray[n] = Camera.MathExt_clip(nArray[n], -6553600, 0x640000);
        }
        this.updateMood();
    }

    private void setBuff(int n, int n2) {
        int n3;
        short s = this.m_buffsActive[n];
        this.m_buffsActive[n] = (short)n2;
        this.m_buffTimers[n] = 0;
        StateInGame.m_playerSim.endBuff(s);
        StateInGame.m_playerSim.startBuff(n2);
        byte[][] byArray = this.d_buffEffectMotive;
        int[][] nArray = this.d_buffEffectMotiveFactors;
        int[] nArray2 = this.m_motiveDecayFactorsF;
        if (s != -1) {
            for (n3 = 0; n3 < byArray[s].length; ++n3) {
                byte by = byArray[s][n3];
                nArray2[by] = nArray2[by] + nArray[s][n3];
            }
        }
        if (n2 != -1) {
            for (n3 = 0; n3 < byArray[n2].length; ++n3) {
                byte by = byArray[n2][n3];
                nArray2[by] = nArray2[by] - nArray[n2][n3];
            }
            if (n2 == 9) {
                this.removeActiveBuff(8);
            } else if (n2 == 8) {
                this.removeActiveBuff(9);
            } else if (n2 == 3) {
                this.removeActiveBuff(6);
                this.removeActiveBuff(7);
                this.removeActiveBuff(4);
            } else if (n2 == 4) {
                this.removeActiveBuff(3);
            } else if (n2 == 6) {
                this.removeActiveBuff(3);
                this.removeActiveBuff(7);
            } else if (n2 == 1) {
                this.removeActiveBuff(0);
            } else if (n2 == 0) {
                this.removeActiveBuff(1);
            }
            if (n2 == 2) {
                StateInGame.showMessageBox(815, 155);
            } else if (n2 == 1) {
                StateInGame.showTutorialMessage((byte)11, 149, 921);
            } else if (n2 == 4) {
                StateInGame.showTutorialMessage((byte)12, 152, 932);
            } else if (n2 == 5) {
                StateInGame.showTutorialMessage((byte)13, 148, 912);
            } else if (n2 == 10) {
                StateInGame.showTutorialMessage((byte)14, 151, 929);
            } else if (n2 == 9) {
                StateInGame.showTutorialMessage((byte)15, 153, 933);
            } else if (n2 == 11) {
                StateInGame.showTutorialMessage((byte)16, 145, 899);
            }
        }
        this.applyBuffsToMood();
    }

    private void addActiveBuff(int n) {
        int n2 = ArrayHandler.indexOf(-1, this.m_buffsActive);
        if (n2 != -1) {
            this.setBuff(n2, n);
        }
    }

    public void removeActiveBuff(int n) {
        int n2 = ArrayHandler.indexOf(n, this.m_buffsActive);
        if (n2 != -1) {
            this.setBuff(n2, -1);
        }
    }

    private boolean buffTriggerConditionsExist(int n) {
        byte by = this.d_buffTimeoutChains[n];
        if (by != -1 && this.buffGetActiveSlot(by) != -1) {
            return false;
        }
        int[] nArray = this.m_motiveLevelsF;
        byte[] byArray = this.d_buffTriggerMotives[n];
        int[] nArray2 = this.d_buffTriggerMotiveLevels[n];
        int n2 = byArray.length;
        if (n2 == 0) {
            return true;
        }
        for (int i = 0; i < n2; ++i) {
            byte by2 = byArray[i];
            int n3 = nArray2[i];
            int n4 = nArray[by2];
            if (n3 > 0 && n4 > n3) {
                return true;
            }
            if (n3 >= 0 || n4 >= -n3) continue;
            return true;
        }
        return false;
    }

    public int buffGetActiveSlot(int n) {
        short[] sArray = this.m_buffsActive;
        for (int i = 0; i < 6; ++i) {
            if (sArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int getTraitCount() {
        return 17;
    }

    private void initMoods() {
        if (this.m_moodLevelsF == null) {
            this.m_moodLevelsF = new int[4];
        }
        ArrayHandler.fillArray(this.m_moodLevelsF, 0x190000);
    }

    private void updateMood() {
        int n;
        int[] nArray = this.m_moodLevelsF;
        int n2 = Integer.MIN_VALUE;
        int n3 = -1;
        int n4 = Integer.MAX_VALUE;
        for (n = 0; n < 4; ++n) {
            if (nArray[n] > n2) {
                n2 = nArray[n];
            }
            if (nArray[n] >= n4) continue;
            n3 = n;
            n4 = nArray[n];
        }
        n = 478;
        int n5 = n2;
        if (n4 < -655360) {
            if (n4 < -3276800) {
                switch (n3) {
                    default: {
                        n = 476;
                        break;
                    }
                    case 1: {
                        n = 483;
                        break;
                    }
                    case 2: {
                        n = 481;
                        break;
                    }
                    case 3: {
                        n = 479;
                        break;
                    }
                }
            } else {
                switch (n3) {
                    default: {
                        n = 482;
                        break;
                    }
                    case 1: {
                        n = 484;
                        break;
                    }
                    case 2: {
                        n = 485;
                        break;
                    }
                    case 3: {
                        n = 475;
                    }
                }
            }
            n5 = n4;
        } else if (n2 > 655360) {
            n = n2 > 0x4B0000 ? 477 : (n2 > 0x280000 ? 486 : 480);
            n5 = n2;
        }
        this.m_moodDesc = n;
        this.m_moodLevel = n5;
    }

    public int getMoodLevel() {
        return this.m_moodLevel;
    }

    private void initRelationships() {
        int n = this.d_numSims;
        if (this.m_currentRelStates == null) {
            byte[] byArray = new byte[n];
            short[] sArray = new short[n];
            int[][] nArrayArray = new int[n][];
            int[][] nArrayArray2 = new int[n][];
            short[][] sArrayArray = new short[n][];
            byte[][] byArrayArray = new byte[n][];
            for (int i = 1; i < n; ++i) {
                nArrayArray[i] = new int[this.d_numRelLevels];
                nArrayArray2[i] = new int[this.d_commodityStringIds.length];
                sArrayArray[i] = new short[10];
                byArrayArray[i] = new byte[this.d_simTraits[i].length];
            }
            this.m_currentRelStates = byArray;
            this.m_currentRelStateFlags = sArray;
            this.m_currentRelLevelsF = nArrayArray;
            this.m_commodityLevelsF = nArrayArray2;
            this.m_actionHistories = sArrayArray;
            this.m_knownTraits = byArrayArray;
        }
        for (int i = 1; i < n; ++i) {
            this.m_currentRelStates[i] = 0;
            this.m_currentRelStateFlags[i] = 0;
            ArrayHandler.fillArray(this.m_currentRelLevelsF[i], 0);
            ArrayHandler.fillArray(this.m_actionHistories[i], -1);
            ArrayHandler.fillArray(this.m_knownTraits[i], 0);
        }
        this.m_commodityTimer = 0;
        this.m_lastNPC = -1;
        this.m_lastNPCTimer = 0;
    }

    private void updateRelationships(int n) {
        if (this.m_lastNPCTimer < 6000) {
            this.m_lastNPCTimer += StateInGame.getNormalTimeStep();
            if (this.m_lastNPCTimer >= 6000) {
                this.m_lastNPC = -1;
            }
        }
        this.m_commodityTimer += n;
        if (this.m_commodityTimer > 3000) {
            this.m_commodityTimer = 0;
        }
        int n2 = this.d_numSims;
        for (int i = 1; i < n2; ++i) {
            this.checkRelationshipTriggers(i);
            if (this.m_commodityTimer != 0) continue;
            int n3 = this.getDominantCommodity(i);
            this.decayCommodities(i, 327680);
            int n4 = this.getDominantCommodity(i);
            if (this.m_lastNPC != i || this.m_lastNPCTimer >= 6000 || n3 == n4) continue;
            short s = this.d_commodityStringIds[n4];
            int n5 = this.getSimName(i);
            AnimationManager.TextHandler_dynamicString(-12, (int)s, n5);
            StateInGame.showTickerMessage(-12, -1);
        }
    }

    public void setLastNPC(int n) {
        this.m_lastNPC = n;
        this.m_lastNPCTimer = 0;
    }

    public int getLastNPC() {
        return this.m_lastNPC;
    }

    public boolean isLastNPCStillRelevant() {
        return this.m_lastNPCTimer < 6000;
    }

    private void decayCommodities(int n, int n2) {
        int[] nArray = this.m_commodityLevelsF[n];
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = i;
            nArray[n3] = nArray[n3] - n2;
            if (nArray[i] >= 0) continue;
            nArray[i] = 0;
        }
    }

    private boolean checkRelationshipStranger(int n) {
        if (this.m_currentRelStates[n] == 0) {
            int n2 = 1;
            if (this.m_currentRelLevelsF[n][0] < 0) {
                n2 = 2;
            }
            this.relationshipStateTransition(n, n2);
            return true;
        }
        return false;
    }

    public void adjustRelLevels(int n, int n2, int n3) {
        int[] nArray = this.m_currentRelLevelsF[n];
        int n4 = nArray[0] + (n2 << 16);
        int n5 = nArray[1] + (n3 << 16);
        nArray[0] = Camera.MathExt_clip(n4, -1966080, 0x1E0000);
        nArray[1] = Camera.MathExt_clip(n5, -327680, 0x1E0000);
    }

    private boolean checkRelationshipTriggers(int n) {
        byte by = this.m_currentRelStates[n];
        int[] nArray = this.m_currentRelLevelsF[n];
        byte[] byArray = this.d_relStateTriggerToStates[by];
        byte[] byArray2 = this.d_relStateTriggerLevels[by];
        short[] sArray = this.d_relStateTriggerLevelValues[by];
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            boolean bl = true;
            byte by2 = byArray2[i];
            short s = sArray[i];
            int n3 = nArray[by2];
            boolean bl2 = s < 0;
            int n4 = s << 16;
            if (bl2 && n3 > n4 || !bl2 && n3 < n4) {
                bl = false;
            }
            if (!bl) continue;
            int n5 = byArray[i];
            if (n5 == 1 && nArray[0] < 0) {
                n5 = 2;
            }
            this.relationshipStateTransition(n, n5);
            return true;
        }
        return false;
    }

    public int[] gatherSocialInfo() {
        int[] nArray = new int[]{0, 0, 0, 0};
        for (int i = 1; i < this.m_currentRelStates.length; ++i) {
            if ((this.d_relStateFlags[this.m_currentRelStates[i]] & 1) != 0) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            if ((this.d_relStateFlags[this.m_currentRelStates[i]] & 2) == 0) continue;
            nArray[1] = nArray[1] + 1;
        }
        nArray[2] = this.numKissesGiven;
        nArray[3] = this.numSlapsGiven;
        return nArray;
    }

    public void checkFriendGoals(int n) {
        if (this.isTraitDiscovered(n, 17)) {
            this.dreamCompleteEvent(14);
        }
        if (this.isTraitDiscovered(n, 19)) {
            this.dreamCompleteEvent(34);
        }
        if (this.isTraitDiscovered(n, 20)) {
            this.dreamCompleteEvent(46);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = this.m_currentRelStates;
        for (int i = 1; i < byArray.length; ++i) {
            if ((this.d_relStateFlags[byArray[i]] & 1) == 0) continue;
            if (this.isTraitDiscovered(i, 17) && ++n2 >= 2) {
                Main.m_simData.dreamCompleteEvent(23);
            }
            if (this.isTraitDiscovered(i, 19) && ++n4 >= 2) {
                Main.m_simData.dreamCompleteEvent(39);
            }
            if (this.isTraitDiscovered(i, 18) && ++n3 >= 2) {
                Main.m_simData.dreamCompleteEvent(28);
            }
            if (!this.isTraitDiscovered(i, 20) || ++n5 < 2) continue;
            Main.m_simData.dreamCompleteEvent(51);
        }
    }

    private void relationshipStateTransition(int n, int n2) {
        byte[] byArray = this.m_currentRelStates;
        byte by = byArray[n];
        byArray[n] = (byte)n2;
        ArrayHandler.fillArray(this.m_currentRelLevelsF[n], 0);
        if ((this.getRelStateFlags(by) & 0x10) == 0 && (this.getRelStateFlags(n2) & 0x10) != 0) {
            this.checkFriendGoals(n);
        }
        if ((this.getRelStateFlags(by) & 8) == 0 && (this.getRelStateFlags(n2) & 8) != 0 && StateInGame.m_mapMode == 1 && Main.m_nextZoomMapId == 81) {
            this.dreamCompleteEvent(5);
        }
        if (n2 == 12) {
            Event.triggerEvent(1, -1, n, 142, -1);
        } else {
            short s = this.d_relStateToStrings[n2];
            short s2 = this.d_simNameStrings[n];
            AnimationManager.TextHandler_dynamicString(-11, (int)s, s2);
            StateInGame.showMessageBox(-11, this.getRelStateDescString(n2));
        }
    }

    private boolean actionEffectEvent(int n, int n2, int n3) {
        byte by = this.m_currentRelStates[n];
        int n4 = -1;
        if (n2 == 90) {
            n4 = 11;
        } else if (n2 == 91) {
            n4 = 12;
        } else if (n2 == 101) {
            n4 = 13;
        } else if (n2 == 100) {
            n4 = 14;
        } else if (n2 == 102) {
            this.setSimCurRelStateFlags(n, 2);
            StateInGame.showMessageBox(507, 523);
        } else if (n2 == 103) {
            this.unsetSimCurRelStateFlags(n, 2);
            StateInGame.showMessageBox(508, 419);
        } else if (n2 == 104) {
            if ((n3 & 0x800) != 0) {
                StateInGame.showMessageBox(648, this.getSimName(n));
            } else {
                byte by2 = this.d_simCareerLevels[0];
                byte by3 = this.d_simCareers[0];
                if (by2 < this.d_careerLevelFlags[by3].length - 1) {
                    StateInGame.showJobOffer(by3, by2 + 1);
                }
            }
        } else if (n2 == 105) {
            StateInGame.showQuitJob();
        }
        if (n4 != -1) {
            this.relationshipStateTransition(n, n4);
            return true;
        }
        return false;
    }

    public void applyCommodity(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = this.getDominantCommodity(n);
        int[] nArray = this.m_commodityLevelsF[n];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (n4 == n2) {
                int n6 = n2;
                nArray[n6] = nArray[n6] + (n3 << 16);
                if (nArray[n2] <= 0xC80000) continue;
                nArray[n2] = 0xC80000;
                continue;
            }
            int n7 = n4;
            nArray[n7] = nArray[n7] - 655360;
            if (nArray[n4] >= 0) continue;
            nArray[n4] = 0;
        }
        n4 = this.getDominantCommodity(n);
        if (n4 != n5 && !bl) {
            short s = this.d_commodityStringIds[n4];
            int n8 = this.getSimName(n);
            AnimationManager.TextHandler_dynamicString(-12, (int)s, n8);
            StateInGame.showTickerMessage(-12, -1);
            if (n4 == 1 || n4 == 2 || n4 == 8) {
                this.setSimCurRelStateFlags(n, 16);
            }
        }
    }

    public void relationshipAction(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        boolean bl = false;
        int n9 = this.d_actionFlags[n3];
        if (n2 == 0) {
            if ((n9 & 0x80000) == 0) {
                if (n3 == 19) {
                    n5 = 35;
                    n6 = 11;
                } else {
                    n5 = 19;
                    n6 = 10;
                }
            }
            this.setSimCurRelStateFlags(n, 1);
            this.setSimCurRelStateFlags(0, 1);
            if (this.checkRelationshipStranger(n)) {
                bl = true;
            }
        } else if (n != 0) {
            if ((n9 & 0x80000) == 0) {
                n5 = 20;
                n6 = 10;
            }
        } else {
            n4 = this.calcActionEffect(n2, n3);
            if (n4 == -1) {
                n6 = (n9 & 0x200000) != 0 ? -1 : -1;
            } else {
                byte by;
                int n10;
                int n11;
                boolean bl2 = false;
                byte by2 = this.d_actionConditionTraits[n3][n4];
                if (by2 != -1) {
                    bl2 = this.tryDiscoverTrait(n2, by2);
                }
                short[] sArray = this.m_actionHistories[n2];
                for (n11 = 9; n11 > 0; --n11) {
                    sArray[n11] = sArray[n11 - 1];
                }
                sArray[0] = (short)n3;
                if ((n9 & 0x10) != 0) {
                    this.unsetSimCurRelStateFlags(n2, 1);
                } else {
                    this.setSimCurRelStateFlags(n2, 1);
                    this.setSimCurRelStateFlags(0, 1);
                }
                n6 = this.d_actionResponseActions[n3][n4];
                n11 = 1;
                MapObjectSim mapObjectSim = StateInGame.findSim(n2);
                if (n6 == -1 && mapObjectSim != null && mapObjectSim.isSleeping()) {
                    n11 = 0;
                }
                int n12 = 0;
                if (n11 != 0) {
                    n10 = this.d_actionAffectFriendships[n3][n4];
                    by = this.d_actionAffectRomances[n3][n4];
                    this.adjustRelLevels(n2, n10, by);
                    n12 = n10 + by;
                    if (by > 0) {
                        n5 |= 0x40;
                    }
                    this.applyCommodity(n2, this.d_actionAffectCommodities[n3][n4], this.d_actionAffectCommodityAmounts[n3][n4], bl2);
                }
                if (((n8 = this.d_actionEffectFlags[n3][n4]) & 8) != 0) {
                    if (this.actionEffectEvent(n2, n3, n8)) {
                        bl = true;
                    }
                } else if (n3 == 104 && (by = this.d_simCareerLevels[0]) < this.d_careerLevelFlags[n10 = this.d_simCareers[0]].length - 1) {
                    StateInGame.showJobRaiseFail(n10, by + 1);
                }
                if (this.checkRelationshipTriggers(n2)) {
                    bl = true;
                } else if ((n9 & 0x200000) == 0 && this.checkRelationshipStranger(n2)) {
                    bl = true;
                }
                if (bl) {
                    n7 = this.d_relStateEffectAnims[this.m_currentRelStates[n2]];
                }
                if (n7 != -1) {
                    n5 |= 3;
                } else {
                    n10 = 3 + n12;
                    n10 = Camera.MathExt_clip(n10, 0, 6);
                    n5 |= n10;
                }
                n5 = n5 < 3 ? (n5 |= 0x20) : (n5 |= 0x10);
            }
        }
        if (n6 != -1) {
            n4 = -1;
            if (n == 0) {
                n4 = n2;
            } else if (n2 == 0) {
                n4 = n;
            }
            if (n4 != -1) {
                this.adjustMotiveLevel(4, 983040);
                this.setLastNPC(n4);
            }
        }
        if (n == 0 && (n8 & 0x1000) != 0) {
            this.questCheckTriggers(n2, n3, !bl);
        }
        nArray[0] = n5;
        nArray[1] = n6;
        nArray[2] = n7;
    }

    public int getRelStateDescString(int n) {
        return this.d_relStateDescStrings[n];
    }

    public int getRelStateFlags(int n) {
        return this.d_relStateFlags[n];
    }

    public int getRelState(int n) {
        return this.m_currentRelStates[n];
    }

    public void getRelationshipLevels(int n, int[] nArray) {
        int n2 = this.getRelState(n);
        int[] nArray2 = this.m_currentRelLevelsF[n];
        byte[] byArray = this.d_relStateTriggerToStates[n2];
        byte[] byArray2 = this.d_relStateTriggerLevels[n2];
        short[] sArray = this.d_relStateTriggerLevelValues[n2];
        int n3 = 0;
        int n4 = byArray.length;
        for (int i = 0; i < n4; ++i) {
            byte by = byArray2[i];
            short s = sArray[i];
            int n5 = nArray2[by] >> 16;
            if ((s <= 0 || n5 <= 0) && (s >= 0 || n5 >= 0)) continue;
            nArray[n3 + 0] = byArray[i];
            nArray[n3 + 1] = Camera.MathExt_Fdiv(n5 << 16, s << 16);
            n3 += 2;
        }
        nArray[n3] = -1;
    }

    public boolean isWelcome() {
        if (!StateInGame.isHouseMode()) {
            return true;
        }
        int n = Main.m_simWorld.m_houseId;
        int n2 = this.getSimCount();
        for (int i = 1; i < n2; ++i) {
            int n3;
            int n4;
            if (this.getSimHome(i) != n || ((n4 = this.getRelStateFlags(n3 = this.getRelState(i))) & 0x20) == 0) continue;
            return true;
        }
        return n == 0;
    }

    public void setSimCurRelStateFlags(int n, int n2) {
        int n3 = n;
        this.m_currentRelStateFlags[n3] = (short)(this.m_currentRelStateFlags[n3] | n2);
    }

    private void unsetSimCurRelStateFlags(int n, int n2) {
        int n3 = n;
        this.m_currentRelStateFlags[n3] = (short)(this.m_currentRelStateFlags[n3] & ~n2);
    }

    public boolean getSimCurRelStateFlags(int n, int n2) {
        return (this.m_currentRelStateFlags[n] & n2) != 0;
    }

    public int getRelationshipNthCount() {
        return this.m_currentRelStates.length - ArrayHandler.countOf(0, this.m_currentRelStates);
    }

    public int getRelationshipNthItem(int n) {
        return ArrayHandler.indexOfNthElement(n, this.m_currentRelStates, 0);
    }

    public static int getNumQueuedMinigames() {
        int n = 0;
        for (int i = 0; i < StateInGame.m_actionQueueActions.length; ++i) {
            int n2 = StateInGame.m_actionQueueActions[i];
            if (n2 != 159 && n2 != 167 && n2 != 163 && n2 != 160 && n2 != 168 && n2 != 164 && n2 != 161 && n2 != 169 && n2 != 165 && n2 != 162 && n2 != 170 && n2 != 166) continue;
            ++n;
        }
        return n;
    }

    public void createContextMenu(MapObject mapObject, short[] sArray, short[] sArray2) {
        if (mapObject.getFlag(16384)) {
            MapObjectSim mapObjectSim = (MapObjectSim)mapObject;
            this.createSimContextMenu(mapObjectSim, sArray, sArray2);
        } else {
            this.createObjectContextMenu(mapObject, sArray, sArray2);
        }
    }

    private void createSimContextMenu(MapObjectSim mapObjectSim, short[] sArray, short[] sArray2) {
        int n = this.d_numActions;
        short[] sArray3 = this.d_actionStringIds;
        int[] nArray = this.d_actionFlags;
        int n2 = mapObjectSim.getId();
        boolean bl = mapObjectSim.isSleeping();
        this.setLastNPC(n2);
        short s = this.d_simNameStrings[n2];
        Main.menuClear(sArray, s);
        Main.menuClear(sArray2, s);
        if (StateInGame.isMapMode()) {
            int n3 = 171;
            Main.menuAppendItem(sArray, sArray3[n3]);
            Main.menuAppendItem(sArray2, n3);
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            if ((nArray[i] & 1) == 0 || (nArray[i] & 4) == 0 && bl || (nArray[i] & 4) != 0 && !bl || sArray3[i] == 557 || sArray3[i] == 38 && !StateInGame.isHouseMode()) continue;
            boolean bl2 = true;
            int n6 = nArray[i];
            if (bl2) {
                if ((n6 & 8) != 0) {
                    bl2 = !this.getSimCurRelStateFlags(n2, 1);
                } else if ((n6 & 0x10) != 0) {
                    bl2 = this.getSimCurRelStateFlags(n2, 1);
                }
            }
            if ((n6 & 0xF000000) != 0) {
                n5 = this.getPersonaActionFlags();
                boolean bl3 = bl2 = (n6 & n5) != 0;
            }
            if (bl2) {
                n5 = this.calcActionEffect(n2, i);
                boolean bl4 = bl2 = n5 != -1;
            }
            if (bl2) {
                n5 = this.d_simCareers[0];
                if ((n6 & 0x4000) != 0) {
                    bl2 = n5 != -1 ? (n4 = this.getCareerBoss(n5)) == n2 : false;
                }
                if (bl2 && (n6 & 0x8000) != 0) {
                    bl2 = n5 != -1 ? this.getSimCareer(n2) == n5 : false;
                }
            }
            if (bl2) {
                n5 = Main.m_simWorld.m_houseId;
                n4 = this.getSimHome(n2);
                if ((n6 & 0x30000) == 196608) {
                    bl2 = this.getSimCurRelStateFlags(n2, 2);
                } else if ((n6 & 0x10000) != 0) {
                    bl2 = n5 == 0 && n4 != 0;
                } else if ((n6 & 0x20000) != 0) {
                    boolean bl5 = bl2 = n5 != 0 && n4 == n5;
                }
            }
            if (bl2 && (n6 & 0x800000) != 0) {
                n5 = this.getQuestForActionFinish(i);
                bl2 = n5 >= 0 && n5 < this.m_questSims.length ? this.m_questSims[n5] == n2 && this.questConditionsSatisfied(n5) : false;
            }
            if (bl2) {
                switch (i) {
                    default: {
                        break;
                    }
                    case 104: {
                        bl2 = this.d_simCareerLevels[0] < this.d_careerLevelFlags[this.d_simCareers[0]].length - 1;
                        break;
                    }
                    case 102: {
                        bl2 = ArrayHandler.indexOfFlags(2, this.m_currentRelStateFlags) == -1;
                        break;
                    }
                    case 103: {
                        bl2 = this.m_currentRelStates[n2] != 12;
                        break;
                    }
                    case 90: {
                        bl2 = ArrayHandler.indexOf(12, this.m_currentRelStates) == -1;
                        break;
                    }
                    case 99: {
                        MapObjectSim mapObjectSim2 = StateInGame.getPlayerSim();
                        n4 = Math.abs(mapObjectSim.getPosX() - mapObjectSim2.getPosX());
                        int n7 = Math.abs(mapObjectSim.getPosZ() - mapObjectSim2.getPosZ());
                        int n8 = 524288 << 2;
                        bl2 = n4 + n7 > n8;
                        break;
                    }
                    case 163: {
                        bl2 = this.m_skillLevelsF[0] >= 131072 && this.m_currentRelStates[n2] > 0 && SimData.getNumQueuedMinigames() == 0;
                        break;
                    }
                    case 164: {
                        bl2 = this.m_skillLevelsF[2] >= 131072 && this.m_currentRelStates[n2] > 0 && SimData.getNumQueuedMinigames() == 0;
                        break;
                    }
                    case 165: {
                        bl2 = this.m_skillLevelsF[1] >= 131072 && this.m_currentRelStates[n2] > 0 && SimData.getNumQueuedMinigames() == 0;
                        break;
                    }
                    case 166: {
                        bl2 = this.m_skillLevelsF[3] >= 131072 && this.m_currentRelStates[n2] > 0 && SimData.getNumQueuedMinigames() == 0;
                        break;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: {
                        boolean bl6 = bl2 = SimData.getNumQueuedMinigames() == 0;
                    }
                }
            }
            if (!bl2) continue;
            Main.menuAppendItem(sArray, sArray3[i]);
            Main.menuAppendItem(sArray2, i);
        }
    }

    private void createObjectContextMenu(MapObject mapObject, short[] sArray, short[] sArray2) {
        MapObject mapObject2;
        int n;
        MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
        short[] sArray3 = this.d_actionStringIds;
        int[] nArray = this.d_actionFlags;
        int n2 = mapObject.getTypeString();
        Main.menuClear(sArray, n2);
        Main.menuClear(sArray2, n2);
        int n3 = mapObject.getType();
        int n4 = Main.m_simWorld.getObjectActions(n3, this.objectActions);
        int n5 = Main.m_simWorld.d_objectFlags[n3];
        if ((n5 & 0x2000000) != 0 && mapObject.getRuntimeFlag(256)) {
            Main.menuAppendItem(sArray, sArray3[118]);
            Main.menuAppendItem(sArray2, 118);
        }
        if ((n5 & 0x4000000) != 0 && mapObject.getRuntimeFlag(512)) {
            Main.menuAppendItem(sArray, sArray3[117]);
            Main.menuAppendItem(sArray2, 117);
        }
        for (int i = 0; i < n4; ++i) {
            int n6;
            n = this.objectActions[i];
            int n7 = nArray[n];
            if ((n7 & 1) != 0 || n3 == 48 && (n == 128 || n == 129 || n == 130 || n == 149) && !mapObject.occupiedIsAnyAvailable() || (n7 & 0x20) != 0 && !mapObject.getRuntimeFlag(64) || (n7 & 0x40) != 0 && mapObject.getRuntimeFlag(64) || (n7 & 0x80) != 0 && !mapObject.isIdle() || (n7 & 0x100) != 0 && !mapObject.isActive() || (n7 & 0x200) != 0 && mapObject.getRuntimeFlag(256) || (n7 & 0x400) != 0 && mapObject.getRuntimeFlag(512) || (n7 & 0x1000) != 0 && !this.isPlaceForWork(mapObject, 0) || (n7 & 0x2000) != 0 && !this.isTimeForWork(mapObject, 0) || (n7 & 0x800) != 0 && this.isPlaceForWork(mapObject, 0) || (n7 & 0x20000) != 0 && Main.m_simWorld.m_houseId != 0 || (n7 & 0x10000) != 0 && Main.m_simWorld.m_houseId == 0 || (n7 & 0xF000000) != 0 && (n7 & (n6 = this.getPersonaActionFlags())) == 0 || n == 137 && mapObject.getRuntimeFlag(16384) || n == 138 && mapObject.getRuntimeFlag(32768) || mapObject.isInteractivity() && mapObject.m_switchToIdleTimer > -1) continue;
            n6 = SimData.getNumQueuedMinigames();
            if (n == 159 && this.m_skillLevelsF[0] < 65536 && n6 > 0 || n == 160 && this.m_skillLevelsF[2] < 65536 && n6 > 0 || n == 161 && this.m_skillLevelsF[1] < 65536 && n6 > 0 || n == 162 && this.m_skillLevelsF[3] < 65536 && n6 > 0 || (n == 163 || n == 167 || n == 159) && n6 > 0 || (n == 164 || n == 168 || n == 160) && n6 > 0 || (n == 165 || n == 169 || n == 161) && n6 > 0 || (n == 166 || n == 170 || n == 162) && n6 > 0 || n == 158 && (this.getSimCurRelStateFlags(0, 1) || Main.m_simWorld.m_houseId == 0)) continue;
            if (n == 157) {
                int n8 = Main.m_simWorld.coordWorldToWorldTileX(mapObjectSim.getPosX());
                int n9 = Main.m_simWorld.coordWorldToWorldTileZ(mapObjectSim.getPosZ());
                if ((Main.m_simWorld.getAttribute(n8, n9) & 0x10) != 0) continue;
            }
            Main.menuAppendItem(sArray, sArray3[n]);
            Main.menuAppendItem(sArray2, n);
        }
        if ((n5 & 0x1000) != 0 && ((mapObject2 = mapObjectSim.getOccupiedObject()) == null || mapObject2 != null && !mapObject2.equals(mapObject) || StateInGame.m_mapMode == 2)) {
            n = 111;
            Main.menuAppendItem(sArray, sArray3[n]);
            Main.menuAppendItem(sArray2, n);
        }
        if (sArray[0] == 0) {
            Main.menuAppendItem(sArray, 43);
            Main.menuAppendItem(sArray2, -4);
        }
    }

    public void compactContextMenu(short[] sArray, short[] sArray2, short[] sArray3) {
        Main.menuClear(sArray, sArray3[1]);
        Main.menuClear(sArray2, 557);
        short[] sArray4 = this.d_actionStringIds;
        short[] sArray5 = this.d_actionGroupStringIds;
        int n = sArray3[0];
        for (int i = 0; i < n; ++i) {
            short s = sArray3[5 + i];
            short s2 = sArray5[s];
            if (s2 != 557 && this.countContextMenuGroup(sArray3, s2) >= 2) {
                if (Main.menuContains(sArray, s2)) continue;
                Main.menuAppendItem(sArray, s2);
                Main.menuAppendItem(sArray2, -2);
                continue;
            }
            Main.menuAppendItem(sArray, sArray4[s]);
            Main.menuAppendItem(sArray2, s);
        }
    }

    private int countContextMenuGroup(short[] sArray, int n) {
        short[] sArray2 = this.d_actionGroupStringIds;
        int n2 = 0;
        int n3 = sArray[0];
        for (int i = 0; i < n3; ++i) {
            short s = sArray[i + 5];
            short s2 = sArray2[s];
            if (s2 != n) continue;
            ++n2;
        }
        return n2;
    }

    public void filterContextMenu(short[] sArray, short[] sArray2, short[] sArray3, int n) {
        Main.menuClear(sArray, n);
        Main.menuClear(sArray2, n);
        short[] sArray4 = this.d_actionStringIds;
        short[] sArray5 = this.d_actionGroupStringIds;
        int n2 = sArray3[0];
        for (int i = 0; i < n2; ++i) {
            short s = sArray3[5 + i];
            short s2 = sArray5[s];
            if (s2 != n) continue;
            Main.menuAppendItem(sArray, sArray4[s]);
            Main.menuAppendItem(sArray2, s);
        }
    }

    public void createCallContextMenu(short[] sArray, short[] sArray2, int n) {
        short s = this.d_actionStringIds[n];
        Main.menuClear(sArray, s);
        Main.menuClear(sArray2, s);
        for (int i = 1; i < this.d_numSims; ++i) {
            if (this.m_currentRelStates[i] == 0 || this.getSimHome(i) == Main.m_simWorld.m_houseId) continue;
            Main.menuAppendItem(sArray, this.d_simNameStrings[i]);
            Main.menuAppendItem(sArray2, n);
        }
    }

    public int getDominantCommodity(int n) {
        int[] nArray = this.m_commodityLevelsF[n];
        int n2 = nArray.length;
        int n3 = 3;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] <= n4) continue;
            n4 = nArray[i];
            n3 = i;
        }
        return n3;
    }

    private int relStateToRelStateBit(int n) {
        return 1 << n + 1;
    }

    private boolean checkActionHistory(int n, int n2, int n3, int n4) {
        short[] sArray = this.m_actionHistories[n];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            if (sArray[i] != n2 || ++n5 < n3) continue;
            return true;
        }
        return false;
    }

    private int calcActionEffect(int n, int n2) {
        int n3 = this.getDominantCommodity(n);
        byte by = this.m_currentRelStates[n];
        int n4 = this.relStateToRelStateBit(by);
        byte[] byArray = this.d_actionConditionCommodities[n2];
        byte[] byArray2 = this.d_actionConditionTraits[n2];
        int[] nArray = this.d_actionConditionRelStates[n2];
        short[] sArray = this.d_actionEffectFlags[n2];
        for (int i = byArray.length - 1; i >= 0; --i) {
            byte by2;
            byte by3;
            int n5;
            int n6;
            int n7;
            byte by4;
            byte by5 = byArray[i];
            if (by5 != -1 && by5 != n3 || (by4 = byArray2[i]) != -1 && this.hasSimGotTrait(n, by4) == -1 || (n7 = nArray[i]) != 0 && (n7 & n4) == 0) continue;
            short s = sArray[i];
            if ((s & 7) != 0) {
                n6 = 3;
                n5 = 6;
                if ((s & 1) != 0) {
                    n6 = 2;
                    n5 = 4;
                } else if ((s & 4) != 0) {
                    n6 = 6;
                    n5 = 10;
                }
                if (!this.checkActionHistory(n, n2, n6, n5)) continue;
            }
            n6 = -1;
            if ((s & 0x10) != 0) {
                n6 = 0;
            }
            if ((s & 0x20) != 0) {
                n6 = 2;
            }
            if ((s & 0x40) != 0) {
                n6 = 1;
            }
            if ((s & 0x80) != 0) {
                n6 = 3;
            }
            if (n6 != -1) {
                n5 = 65536;
                if ((s & 0x100) != 0) {
                    n5 = 196608;
                }
                if (this.m_skillLevelsF[n6] < n5) continue;
            }
            if ((s & 0x600) != 0 && ((s & 0x400) == 0 ? !this.buffTriggerConditionsExist(1) : !this.buffTriggerConditionsExist(4))) continue;
            if (n2 == 104 && (s & 8) != 0 && (s & 0x800) == 0 && ((by3 = this.d_simCareers[0]) == -1 || (by2 = this.d_simCareerLevels[0]) >= this.d_careerLevelDescStrings[by3].length - 1 || !this.careerRequirementsMet(by3, by2 + 1))) continue;
            return i;
        }
        return -1;
    }

    public boolean actionAccept(int n, int n2, int n3) {
        if (n == 0) {
            int n4 = this.calcActionEffect(n2, n3);
            return (this.d_actionEffectFlags[n3][n4] & 0x800) == 0;
        }
        return true;
    }

    public int getActionTalkIcon(int n) {
        int n2;
        int n3 = 1;
        switch (n) {
            default: {
                break;
            }
            case 19: 
            case 20: 
            case 28: 
            case 95: 
            case 96: 
            case 97: {
                n3 = 16;
                break;
            }
            case 65: {
                n3 = 4;
                break;
            }
            case 66: {
                n3 = 64;
                break;
            }
            case 145: {
                n3 = 256;
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                n3 = 32;
                break;
            }
            case 99: {
                n3 = 8;
            }
        }
        int n4 = 0;
        for (n2 = 0; n2 < SPEECHICONS.length; n2 += 2) {
            if ((n3 & SPEECHICONS[n2 + 1]) == 0) continue;
            ++n4;
        }
        if (n4 <= 0) {
            return 359;
        }
        n2 = Main.rand(0, n4 - 1);
        n4 = 0;
        for (int i = 0; i < SPEECHICONS.length; i += 2) {
            if ((n3 & SPEECHICONS[i + 1]) == 0) continue;
            if (n4 == n2) {
                return SPEECHICONS[i];
            }
            ++n4;
        }
        return 359;
    }

    private boolean chanceCardAppropriate(int n) {
        byte by = this.d_chanceCardResultNo1s[n];
        byte by2 = this.d_chanceCardResultNo2s[n];
        byte by3 = this.d_chanceCardResultYes1s[n];
        byte by4 = this.d_chanceCardResultYes2s[n];
        int n2 = this.getSimCareer(0);
        int n3 = this.getSimCareerLevel(0);
        if ((by == 2 || by2 == 2 || by3 == 2 || by4 == 2) && n3 == 0) {
            GlobalConstants.PMDebug_println("avoiding demotion card");
            return false;
        }
        if ((by == 1 || by2 == 1 || by3 == 1 || by4 == 1) && n3 >= this.d_careerLevelDescStrings[n2].length - 3) {
            GlobalConstants.PMDebug_println("avoiding promotion card");
            return false;
        }
        return true;
    }

    public int getChanceCardForWork() {
        int n;
        do {
            n = Main.rand(0, this.d_chanceCardPrompts.length - 1);
            GlobalConstants.PMDebug_println(2, "trying card: {0}", n);
        } while (!this.chanceCardAppropriate(n));
        GlobalConstants.PMDebug_println(2, "final card: {0}", n);
        return n;
    }

    public int getChanceCardOutcome(int n, boolean bl) {
        int n2 = Main.randPercent();
        if (bl) {
            return n2 < this.d_chanceCardYesPercents[n] ? 0 : 1;
        }
        return n2 < this.d_chanceCardNoPercents[n] ? 2 : 3;
    }

    public int getChanceCardPromptString(int n) {
        return this.d_chanceCardPrompts[n];
    }

    public int getChanceCardOutcomeString(int n, int n2) {
        switch (n2) {
            default: {
                return this.d_chanceCardResultYes1Strings[n];
            }
            case 1: {
                return this.d_chanceCardResultYes2Strings[n];
            }
            case 2: {
                return this.d_chanceCardResultNo1Strings[n];
            }
            case 3: 
        }
        return this.d_chanceCardResultNo2Strings[n];
    }

    public void performChanceCardOutcome(int n, int n2) {
        byte by = 0;
        switch (n2) {
            default: {
                by = this.d_chanceCardResultYes1s[n];
                break;
            }
            case 1: {
                by = this.d_chanceCardResultYes2s[n];
                break;
            }
            case 2: {
                by = this.d_chanceCardResultNo1s[n];
                break;
            }
            case 3: {
                by = this.d_chanceCardResultNo2s[n];
            }
        }
        byte by2 = this.d_simCareers[0];
        byte by3 = this.d_simCareerLevels[0];
        int n3 = by3 + 1;
        switch (by) {
            default: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this.careerAcceptJob(by2, n3);
                ++this.m_numTimesPromoted;
                break;
            }
            case 2: {
                this.careerAcceptJob(by2, by3 - 1);
                break;
            }
            case 3: {
                this.careerAcceptJob(-1, 0);
                ++this.m_numTimesFired;
                break;
            }
            case 4: {
                int n4 = -1;
                int n5 = 1;
                switch (by2) {
                    default: {
                        break;
                    }
                    case 0: {
                        n4 = 43;
                        break;
                    }
                    case 2: {
                        n4 = 52;
                        break;
                    }
                    case 1: {
                        n4 = 36;
                        break;
                    }
                    case 3: {
                        n4 = 57;
                    }
                }
                this.adjustInventory(n4, n5);
                break;
            }
            case 5: {
                this.adjustMoney(1000, 0);
            }
        }
    }

    private void initQuests() {
        if (this.m_questSims == null) {
            this.m_questSims = new byte[this.d_questPrompts.length];
            this.m_questTimes = new int[this.d_questPrompts.length];
        }
        ArrayHandler.fillArray(this.m_questSims, -1);
        ArrayHandler.fillArray(this.m_questTimes, -1);
    }

    public int getQuestPromptString(int n) {
        return this.d_questPrompts[n];
    }

    public int getQuestMessageString(int n) {
        return this.d_questMessages[n];
    }

    private int getQuestForActionFinish(int n) {
        return ArrayHandler.indexOf(n, this.d_questFinishActions);
    }

    /*
     * Unable to fully structure code
     */
    private void questCheckTriggers(int var1_1, int var2_2, boolean var3_3) {
        var6_4 = this.getGameTimeAbs();
        var7_5 = this.d_simQuests[var1_1];
        for (var8_6 = 0; var8_6 < var7_5.length; ++var8_6) {
            var9_7 = var7_5[var8_6];
            var10_8 = this.m_questTimes[var9_7];
            var11_9 = false;
            if (this.m_questSims[var9_7] != var1_1) ** GOTO lbl17
            if (this.d_questFinishActions[var9_7] == var2_2) {
                StateInGame.triggerFetchQuestEnd(var9_7, var1_1);
                break;
            }
            if (var6_4 - var10_8 >= 1440) {
                var11_9 = true;
                GlobalConstants.PMDebug_println("retrigger?");
            } else {
                GlobalConstants.PMDebug_println("skip sim currently active");
                continue;
lbl17:
                // 1 sources

                if (this.m_questSims[var9_7] != -1) {
                    GlobalConstants.PMDebug_println("skip active");
                    continue;
                }
            }
            if (!var3_3) {
                GlobalConstants.PMDebug_println("skip supressed");
                continue;
            }
            if (ArrayHandler.indexOf(var2_2, this.d_questTriggerActions[var9_7]) == -1) continue;
            if (!var11_9) {
                if (ArrayHandler.indexOf(var1_1, this.m_questSims) != -1) {
                    GlobalConstants.PMDebug_println("other active");
                    continue;
                }
                if (var10_8 != -1 && var6_4 - var10_8 < 1440) {
                    GlobalConstants.PMDebug_println("skip time");
                    continue;
                }
                if (Main.randPercent() < 70) {
                    GlobalConstants.PMDebug_println("skip chance");
                    continue;
                }
            }
            this.m_questTimes[var9_7] = this.getGameTimeAbs();
            this.questStart(var9_7, var1_1);
            break;
        }
    }

    private void questStart(int n, int n2) {
        this.m_questSims[n] = (byte)n2;
        StateInGame.triggerFetchQuest(n, n2);
        switch (n) {
            default: {
                break;
            }
            case 7: {
                this.unsetSimCurRelStateFlags(4, 16);
                break;
            }
            case 8: {
                this.unsetSimCurRelStateFlags(4, 4);
                break;
            }
            case 10: {
                this.unsetSimCurRelStateFlags(6, 16);
                break;
            }
            case 11: {
                this.unsetSimCurRelStateFlags(6, 4);
                break;
            }
            case 15: {
                this.unsetSimCurRelStateFlags(11, 16);
                break;
            }
            case 16: {
                this.unsetSimCurRelStateFlags(11, 4);
                break;
            }
            case 18: {
                this.unsetSimCurRelStateFlags(12, 8);
                break;
            }
            case 25: {
                this.unsetSimCurRelStateFlags(19, 32);
                break;
            }
            case 26: {
                this.unsetSimCurRelStateFlags(20, 64);
                break;
            }
            case 27: {
                this.unsetSimCurRelStateFlags(15, 8);
                break;
            }
            case 28: {
                this.unsetSimCurRelStateFlags(20, 4);
                break;
            }
            case 29: {
                this.unsetSimCurRelStateFlags(19, 16);
                break;
            }
            case 30: {
                this.unsetSimCurRelStateFlags(15, 4);
                break;
            }
            case 31: {
                this.unsetSimCurRelStateFlags(21, 32);
                break;
            }
            case 33: {
                this.unsetSimCurRelStateFlags(14, 32);
                break;
            }
            case 34: {
                this.unsetSimCurRelStateFlags(18, 4);
                break;
            }
            case 35: {
                this.unsetSimCurRelStateFlags(18, 16);
                break;
            }
            case 5: {
                this.unsetSimCurRelStateFlags(5, 4);
            }
        }
    }

    public void questCompleted(int n) {
        short s;
        short s2 = this.d_questRewardCash[n];
        if (s2 != 0) {
            this.adjustMoney(s2, -1);
        }
        if ((s = this.d_questGiveItem[n]) != -1) {
            this.adjustInventory(s, -1);
        }
        this.m_questSims[n] = -1;
        this.m_questTimes[n] = this.getGameTimeAbs();
    }

    private boolean questConditionsSatisfied(int n) {
        short[] sArray = this.m_currentRelStateFlags;
        switch (n) {
            default: {
                break;
            }
            case 7: {
                return (sArray[4] & 0x10) != 0;
            }
            case 8: {
                return (sArray[4] & 4) != 0;
            }
            case 10: {
                return (sArray[6] & 0x10) != 0;
            }
            case 11: {
                return (sArray[6] & 4) != 0;
            }
            case 15: {
                return (sArray[11] & 0x10) != 0;
            }
            case 16: {
                return (sArray[11] & 4) != 0;
            }
            case 18: {
                return (sArray[12] & 8) != 0;
            }
            case 25: {
                return (sArray[19] & 0x20) != 0;
            }
            case 26: {
                return (sArray[20] & 0x40) != 0;
            }
            case 27: {
                return (sArray[15] & 8) != 0;
            }
            case 28: {
                return (sArray[20] & 4) != 0;
            }
            case 29: {
                return (sArray[19] & 0x10) != 0;
            }
            case 30: {
                return (sArray[15] & 4) != 0;
            }
            case 31: {
                return (sArray[21] & 0x20) != 0;
            }
            case 33: {
                return (sArray[14] & 0x20) != 0;
            }
            case 34: {
                return (sArray[18] & 4) != 0;
            }
            case 35: {
                return (sArray[18] & 0x10) != 0;
            }
            case 5: {
                return (sArray[5] & 4) != 0;
            }
        }
        return this.getInventoryCount(this.d_questGiveItem[n]) > 0;
    }

    private void initSims() {
        if (this.d_simTraits[0].length != 5) {
            this.d_simTraits[0] = new byte[5];
            ArrayHandler.fillArray(this.d_simTraits[0], -1);
        }
    }

    public int getSimCount() {
        return this.d_numSims;
    }

    public int getSimName(int n) {
        return this.d_simNameStrings[n];
    }

    public int getSimPartner(int n) {
        return this.d_simPartners[n];
    }

    public int getSimMacromapColor(int n) {
        return this.d_simMacromapColors[n];
    }

    public int getSimAttribute(int n, int n2) {
        if (n == -1) {
            n = 0;
        }
        return this.d_simAttributes[n][n2];
    }

    public int getSimHome(int n) {
        if (this.getSimCurRelStateFlags(n, 2)) {
            return 0;
        }
        return this.d_simHomes[n];
    }

    public int getSimCareer(int n) {
        return this.d_simCareers[n];
    }

    public int getSimCareerLevel(int n) {
        return this.d_simCareerLevels[n];
    }

    public void setPlayerSimAttribute(int n, int n2) {
        this.d_simAttributes[0][n] = (byte)n2;
    }

    public boolean hasSimGotFlag(int n, int n2) {
        return (this.d_simFlags[n] & n2) != 0;
    }

    public int hasSimGotTrait(int n, int n2) {
        return ArrayHandler.indexOf(n2, this.d_simTraits[n]);
    }

    public boolean isTraitDiscovered(int n, int n2) {
        int n3 = this.hasSimGotTrait(n, n2);
        if (n3 != -1) {
            return this.m_knownTraits[n][n3] >= 3;
        }
        return false;
    }

    public boolean tryDiscoverTrait(int n, int n2) {
        byte[] byArray = this.m_knownTraits[n];
        int n3 = this.hasSimGotTrait(n, n2);
        if (n3 != -1 && byArray[n3] < 3) {
            int n4 = n3;
            byArray[n4] = (byte)(byArray[n4] + 1);
            if (byArray[n3] == 3) {
                int n5 = this.getSimName(n);
                short s = this.d_traitDescStrings[n2];
                AnimationManager.TextHandler_dynamicString(-12, 266, n5, s);
                StateInGame.showTickerMessage(-12, -1);
                this.dreamCompleteEvent(16);
                if ((this.getRelStateFlags(this.m_currentRelStates[n]) & 1) != 0) {
                    this.checkFriendGoals(n);
                }
                return true;
            }
        }
        return false;
    }

    public int getSimTraitCount(int n) {
        return this.d_simTraits[n].length;
    }

    public int getSimTrait(int n, int n2) {
        return this.d_simTraits[n][n2];
    }

    public int getNumPlayerTraits() {
        byte[] byArray = this.d_simTraits[0];
        return byArray.length - ArrayHandler.countOf(-1, byArray);
    }

    public void traitPlayerAdd(int n) {
        if (this.hasSimGotTrait(0, n) == -1) {
            int n2;
            short s = this.d_traitExcludes[n];
            if (s != -1) {
                this.traitPlayerRemove(s);
            }
            if ((n2 = this.hasSimGotTrait(0, -1)) != -1) {
                this.d_simTraits[0][n2] = (byte)n;
            }
        }
    }

    public void traitPlayerRemove(int n) {
        int n2 = this.hasSimGotTrait(0, n);
        if (n2 != -1) {
            this.d_simTraits[0][n2] = -1;
        }
    }

    public int getSimByName(int n) {
        return ArrayHandler.indexOf(n, this.d_simNameStrings, 1);
    }

    public boolean acceptInvitation(int n) {
        return (this.getRelStateFlags(this.m_currentRelStates[n]) & 1) != 0 && (this.getTimeFlags(n) & 0x10) == 0 && (this.getTimeFlags(n) & 8) != 0;
    }

    public void update(int n, boolean bl) {
        this.updateGameTime(n);
        if (!this.isDelayed()) {
            this.updateMotives(n);
            this.updateBuffs(n);
            this.updateRelationships(n);
            this.updateDreams(n);
        }
        if (this.isDelayed()) {
            this.m_timeoutDelay = Math.max(this.m_timeoutDelay - n, 0);
        }
    }

    public void newScene() {
        this.setFastforward(false);
        this.setLastNPC(-1);
        ArrayHandler.fillArray(this.m_motiveDecayAdjustsF, 0);
        for (int i = 1; i < this.d_numSims; ++i) {
            this.unsetSimCurRelStateFlags(i, 1);
            ArrayHandler.fillArray(this.m_commodityLevelsF[i], 0);
            ArrayHandler.fillArray(this.m_actionHistories[i], -1);
        }
        this.unsetSimCurRelStateFlags(0, 1);
        this.delayAlerts();
    }

    public void delayAlerts() {
        this.m_timeoutDelay = 2500;
    }

    public boolean isDelayed() {
        return this.m_timeoutDelay != 0;
    }

    public void newGame() {
        int n;
        int n2 = this.getTaskCount();
        int n3 = this.getPersonaFlags();
        for (n = 0; n < n2; ++n) {
            if ((this.getTaskFlags(n) & n3) == 0) continue;
            ArrayHandler.Rms_setGoalDiscovered(n);
        }
        n = -1;
        int n4 = -1;
        switch (this.m_persona) {
            case 0: {
                n = 0;
                n4 = 0;
                break;
            }
            case 2: {
                n = 2;
                n4 = 7;
                break;
            }
            case 1: {
                n = 1;
                n4 = 14;
                break;
            }
            case 3: {
                n = 3;
                n4 = 21;
            }
        }
        if (n > -1 && n4 > -1) {
            this.m_skillLevelsF[n] = 65536;
            this.adjustInventory(n4, 1);
        }
        this.setQuickLinkVisited(100);
    }

    private void initObjectValues() {
        if (this.m_objectStateIds == null) {
            this.m_objectStateIds = new short[100];
            this.m_objectStateValues = new int[100];
            this.m_objectStateTimes = new int[100];
        }
        ArrayHandler.fillArray(this.m_objectStateIds, -1);
        ArrayHandler.fillArray(this.m_objectStateValues, 0);
        ArrayHandler.fillArray(this.m_objectStateTimes, 0);
    }

    public void saveObjectValue(int n, int n2, int n3) {
        if (StateInGame.m_mapMode == 1) {
            n = Main.m_nextZoomMapId;
        } else if (StateInGame.m_mapMode == 2) {
            n = 83;
        }
        int n4 = n << 8 | n2;
        int n5 = ArrayHandler.indexOf(n4, this.m_objectStateIds);
        if (n3 == 0 && n5 != -1) {
            this.removeObjectValue(n, n2);
        } else {
            if (n5 == -1) {
                n5 = ArrayHandler.indexOf(-1, this.m_objectStateIds);
            }
            this.m_objectStateIds[n5] = (short)n4;
            this.m_objectStateValues[n5] = n3;
            this.m_objectStateTimes[n5] = this.getGameTimeAbs();
        }
    }

    public int getObjectValue(int n, int n2) {
        if (StateInGame.m_mapMode == 1) {
            n = Main.m_nextZoomMapId;
        } else if (StateInGame.m_mapMode == 2) {
            n = 83;
        }
        int n3 = n << 8 | n2;
        int n4 = ArrayHandler.indexOf(n3, this.m_objectStateIds);
        if (n4 == -1) {
            return 0;
        }
        return this.m_objectStateValues[n4];
    }

    public int getObjectValueTime(int n, int n2) {
        if (StateInGame.m_mapMode == 1) {
            n = Main.m_nextZoomMapId;
        } else if (StateInGame.m_mapMode == 2) {
            n = 83;
        }
        int n3 = n << 8 | n2;
        int n4 = ArrayHandler.indexOf(n3, this.m_objectStateIds);
        if (n4 == -1) {
            return -1;
        }
        return this.m_objectStateTimes[n4];
    }

    public void removeObjectValue(int n, int n2) {
        if (StateInGame.m_mapMode == 1) {
            n = Main.m_nextZoomMapId;
        } else if (StateInGame.m_mapMode == 2) {
            n = 83;
        }
        int n3 = n << 8 | n2;
        int n4 = ArrayHandler.indexOf(n3, this.m_objectStateIds);
        if (n4 != -1) {
            this.m_objectStateIds[n4] = -1;
            this.m_objectStateValues[n4] = 0;
            this.m_objectStateTimes[n4] = 0;
        }
    }

    public void chooseProducible() {
        int n = this.getSimCareer(0);
        if ((this.getCareerLevelFlagsPlayer() & 0x20) == 0) {
            StateInGame.stateTransition(5);
            return;
        }
        int n2 = Main.randPercent();
        int n3 = -1;
        if (n2 < this.d_careerProducible1Chance[n]) {
            n3 = this.adjustInventory(this.d_careerProducible1[n], 1) > 0 ? this.d_careerProducible1[n] : -1;
        } else if (n2 < this.d_careerProducible1Chance[n] + this.d_careerProducible2Chance[n]) {
            n3 = this.adjustInventory(this.d_careerProducible2[n], 1) > 0 ? this.d_careerProducible2[n] : -1;
        }
        if (n3 != -1) {
            AnimationManager.TextHandler_dynamicString(-11, 941, Main.m_simWorld.d_itemDescStringIds[n3]);
            StateInGame.showMessageBox(-11, 942, 7);
            ++this.numProduciblesProduced;
        } else {
            StateInGame.stateTransition(5);
        }
    }

    public void resetRMSGameData() {
        this.initGameTimeMoney();
        this.initInventory();
        this.initSkills();
        this.initCareer();
        this.m_persona = -1;
        ArrayHandler.fillArray(this.d_simTraits[0], -1);
        this.initDreams();
        this.initMotives();
        this.initBuffs();
        this.initMoods();
        this.initQuests();
        this.initSims();
        this.initRelationships();
        this.initObjectValues();
        ArrayHandler.fillArray(this.d_simAttributes[0], 0);
        this.GSEndOfGameHasBeenScreenShown = false;
        GameConstants.Minigame_numSuccessfulPracticesConsecutive = 0;
        GameConstants.Minigame_numSuccessfulPractices = 0;
        this.m_moneySpent = 0;
        this.m_moneySpentOnGearMaintenance = 0;
        this.m_moneySpentOnSnacks = 0;
        this.m_moneyEarned = 0;
        this.m_moneyEarnedOnProducibles = 0;
        StateInGame.amountSpentOnFurniture = 0;
        StateInGame.amountSpentOnHobbyRoom = 0;
        StateInGame.numItemsSoldArt = 0;
        StateInGame.numItemsSoldFashion = 0;
        StateInGame.numItemsSoldMusic = 0;
        StateInGame.numItemsSoldSport = 0;
        this.numKissesGiven = 0;
        this.numSlapsGiven = 0;
        this.m_numTimesPromoted = 0;
        this.m_numTimesFired = 0;
        StateInGame.numMessagesRead = 0;
        StateInGame.numShowers = 0;
        StateInGame.numTimesPassedOut = 0;
    }

    public void loadRMSGameData(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        GameConstants.Minigame_inspired = false;
        for (int i = 0; i < 10; ++i) {
            this.d_simAttributes[0][i] = dataInputStream.readByte();
        }
        byte[] byArray = this.d_simTraits[0];
        for (n2 = 0; n2 < 5; ++n2) {
            byArray[n2] = dataInputStream.readByte();
        }
        this.m_timeTimer = dataInputStream.readInt();
        this.m_timeTotal = dataInputStream.readInt();
        this.m_money = dataInputStream.readInt();
        this.m_moneySpent = dataInputStream.readInt();
        this.m_moneySpentOnGearMaintenance = dataInputStream.readInt();
        this.m_moneySpentOnSnacks = dataInputStream.readInt();
        this.m_moneyEarned = dataInputStream.readInt();
        this.m_moneyEarnedOnProducibles = dataInputStream.readInt();
        for (n2 = 0; n2 < this.m_inventory.length; ++n2) {
            this.m_inventory[n2] = dataInputStream.readByte();
        }
        for (n2 = 0; n2 < this.m_skillLevelsF.length; ++n2) {
            this.m_skillLevelsF[n2] = dataInputStream.readInt();
        }
        this.d_simCareers[0] = dataInputStream.readByte();
        this.d_simCareerLevels[0] = dataInputStream.readByte();
        this.m_careerAcceptDay = dataInputStream.readByte();
        this.m_careerDaysWorked = dataInputStream.readShort();
        this.m_careerDaysMissed = dataInputStream.readShort();
        for (n2 = 0; n2 < this.m_careerLevelsAttained.length; ++n2) {
            this.m_careerLevelsAttained[n2] = dataInputStream.readByte();
        }
        this.m_persona = dataInputStream.readByte();
        this.m_dream = dataInputStream.readByte();
        this.m_dreamTimer = dataInputStream.readInt();
        for (n2 = 0; n2 < this.m_promises.length; ++n2) {
            this.m_promises[n2] = dataInputStream.readByte();
        }
        this.m_personaGoalsCompleted = dataInputStream.readInt();
        this.m_personaGoalsCompletedAll = dataInputStream.readBoolean();
        this.m_personaGoalsCompletedAllShown = dataInputStream.readBoolean();
        for (n2 = 0; n2 < this.m_woohooTimes.length; ++n2) {
            this.m_woohooTimes[n2] = dataInputStream.readInt();
        }
        for (n2 = 0; n2 < this.m_woohooPartners.length; ++n2) {
            this.m_woohooPartners[n2] = dataInputStream.readInt();
        }
        this.m_quickLinkFlags = dataInputStream.readInt();
        for (n2 = 0; n2 < this.m_motiveLevelsF.length; ++n2) {
            this.m_motiveLevelsF[n2] = dataInputStream.readInt();
        }
        for (n2 = 0; n2 < 6; ++n2) {
            this.m_buffsActive[n2] = dataInputStream.readShort();
            this.m_buffTimers[n2] = dataInputStream.readInt();
        }
        this.applyBuffsToMood();
        n2 = this.d_numSims;
        for (n = 1; n < n2; ++n) {
            this.m_currentRelStates[n] = dataInputStream.readByte();
            this.m_currentRelStateFlags[n] = dataInputStream.readShort();
            int[] nArray = this.m_currentRelLevelsF[n];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = dataInputStream.readInt();
            }
            byte[] byArray2 = this.m_knownTraits[n];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = dataInputStream.readByte();
            }
        }
        for (n = 0; n < 100; ++n) {
            this.m_objectStateIds[n] = dataInputStream.readShort();
            this.m_objectStateValues[n] = dataInputStream.readInt();
            this.m_objectStateTimes[n] = dataInputStream.readInt();
        }
        for (n = 0; n < this.m_questSims.length; ++n) {
            this.m_questSims[n] = dataInputStream.readByte();
            this.m_questTimes[n] = dataInputStream.readInt();
        }
        this.GSEndOfGameHasBeenScreenShown = dataInputStream.readBoolean();
        for (n = 0; n < this.consumablesCounter.length; ++n) {
            for (int i = 0; i < this.consumablesCounter[n].length; ++i) {
                this.consumablesCounter[n][i] = dataInputStream.readInt();
            }
        }
        GameConstants.Minigame_numSuccessfulPracticesConsecutive = dataInputStream.readInt();
        GameConstants.Minigame_numSuccessfulPractices = dataInputStream.readInt();
        StateInGame.amountSpentOnFurniture = dataInputStream.readInt();
        StateInGame.amountSpentOnHobbyRoom = dataInputStream.readInt();
        StateInGame.numItemsSoldArt = dataInputStream.readInt();
        StateInGame.numItemsSoldFashion = dataInputStream.readInt();
        StateInGame.numItemsSoldMusic = dataInputStream.readInt();
        StateInGame.numItemsSoldSport = dataInputStream.readInt();
        this.numKissesGiven = dataInputStream.readInt();
        this.numSlapsGiven = dataInputStream.readInt();
        this.m_numTimesPromoted = dataInputStream.readInt();
        this.m_numTimesFired = dataInputStream.readInt();
        StateInGame.numMessagesRead = dataInputStream.readInt();
        StateInGame.numShowers = dataInputStream.readInt();
        StateInGame.numTimesPassedOut = dataInputStream.readInt();
    }

    public void saveRMSGameData(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        for (int i = 0; i < 10; ++i) {
            dataOutputStream.writeByte(this.d_simAttributes[0][i]);
        }
        byte[] byArray = this.d_simTraits[0];
        for (n2 = 0; n2 < 5; ++n2) {
            dataOutputStream.writeByte(byArray[n2]);
        }
        dataOutputStream.writeInt(this.m_timeTimer);
        dataOutputStream.writeInt(this.m_timeTotal);
        dataOutputStream.writeInt(this.m_money);
        dataOutputStream.writeInt(this.m_moneySpent);
        dataOutputStream.writeInt(this.m_moneySpentOnGearMaintenance);
        dataOutputStream.writeInt(this.m_moneySpentOnSnacks);
        dataOutputStream.writeInt(this.m_moneyEarned);
        dataOutputStream.writeInt(this.m_moneyEarnedOnProducibles);
        for (n2 = 0; n2 < this.m_inventory.length; ++n2) {
            dataOutputStream.writeByte(this.m_inventory[n2]);
        }
        for (n2 = 0; n2 < this.m_skillLevelsF.length; ++n2) {
            dataOutputStream.writeInt(this.m_skillLevelsF[n2]);
        }
        dataOutputStream.writeByte(this.d_simCareers[0]);
        dataOutputStream.writeByte(this.d_simCareerLevels[0]);
        dataOutputStream.writeByte(this.m_careerAcceptDay);
        dataOutputStream.writeShort(this.m_careerDaysWorked);
        dataOutputStream.writeShort(this.m_careerDaysMissed);
        for (n2 = 0; n2 < this.m_careerLevelsAttained.length; ++n2) {
            dataOutputStream.writeByte(this.m_careerLevelsAttained[n2]);
        }
        dataOutputStream.writeByte(this.m_persona);
        dataOutputStream.writeByte(this.m_dream);
        dataOutputStream.writeInt(this.m_dreamTimer);
        for (n2 = 0; n2 < this.m_promises.length; ++n2) {
            dataOutputStream.writeByte(this.m_promises[n2]);
        }
        dataOutputStream.writeInt(this.m_personaGoalsCompleted);
        dataOutputStream.writeBoolean(this.m_personaGoalsCompletedAll);
        dataOutputStream.writeBoolean(this.m_personaGoalsCompletedAllShown);
        for (n2 = 0; n2 < this.m_woohooTimes.length; ++n2) {
            dataOutputStream.writeInt(this.m_woohooTimes[n2]);
        }
        for (n2 = 0; n2 < this.m_woohooPartners.length; ++n2) {
            dataOutputStream.writeInt(this.m_woohooPartners[n2]);
        }
        dataOutputStream.writeInt(this.m_quickLinkFlags);
        for (n2 = 0; n2 < this.m_motiveLevelsF.length; ++n2) {
            dataOutputStream.writeInt(this.m_motiveLevelsF[n2]);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            dataOutputStream.writeShort(this.m_buffsActive[n2]);
            dataOutputStream.writeInt(this.m_buffTimers[n2]);
        }
        n2 = this.d_numSims;
        for (n = 1; n < n2; ++n) {
            dataOutputStream.writeByte(this.m_currentRelStates[n]);
            dataOutputStream.writeShort(this.m_currentRelStateFlags[n]);
            int[] nArray = this.m_currentRelLevelsF[n];
            for (int i = 0; i < nArray.length; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
            byte[] byArray2 = this.m_knownTraits[n];
            for (int i = 0; i < byArray2.length; ++i) {
                dataOutputStream.writeByte(byArray2[i]);
            }
        }
        for (n = 0; n < 100; ++n) {
            dataOutputStream.writeShort(this.m_objectStateIds[n]);
            dataOutputStream.writeInt(this.m_objectStateValues[n]);
            dataOutputStream.writeInt(this.m_objectStateTimes[n]);
        }
        for (n = 0; n < this.m_questSims.length; ++n) {
            dataOutputStream.writeByte(this.m_questSims[n]);
            dataOutputStream.writeInt(this.m_questTimes[n]);
        }
        dataOutputStream.writeBoolean(this.GSEndOfGameHasBeenScreenShown);
        for (n = 0; n < this.consumablesCounter.length; ++n) {
            for (int i = 0; i < this.consumablesCounter[n].length; ++i) {
                dataOutputStream.writeInt(this.consumablesCounter[n][i]);
            }
        }
        dataOutputStream.writeInt(GameConstants.Minigame_numSuccessfulPracticesConsecutive);
        dataOutputStream.writeInt(GameConstants.Minigame_numSuccessfulPractices);
        dataOutputStream.writeInt(StateInGame.amountSpentOnFurniture);
        dataOutputStream.writeInt(StateInGame.amountSpentOnHobbyRoom);
        dataOutputStream.writeInt(StateInGame.numItemsSoldArt);
        dataOutputStream.writeInt(StateInGame.numItemsSoldFashion);
        dataOutputStream.writeInt(StateInGame.numItemsSoldMusic);
        dataOutputStream.writeInt(StateInGame.numItemsSoldSport);
        dataOutputStream.writeInt(this.numKissesGiven);
        dataOutputStream.writeInt(this.numSlapsGiven);
        dataOutputStream.writeInt(this.m_numTimesPromoted);
        dataOutputStream.writeInt(this.m_numTimesFired);
        dataOutputStream.writeInt(StateInGame.numMessagesRead);
        dataOutputStream.writeInt(StateInGame.numShowers);
        dataOutputStream.writeInt(StateInGame.numTimesPassedOut);
    }
}

