/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKString;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.Camera;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.SimWorld;
import dk.progressivemedia.skeleton.state.StateInGame;

public class MapObject {
    protected static final int[] s_tempInt10 = new int[10];
    public boolean isMapObject;
    private int m_type;
    private int m_id = 0;
    private short m_typeString = 0;
    private int m_flags = 0;
    private int m_runtimeFlags = 0;
    private int m_state = 0;
    private int m_stateTime = 0;
    private int m_posXF = 0;
    private int m_posZF = 0;
    private int m_facingDir = 0;
    private byte m_footprintWidth = 0;
    private byte m_footprintHeight = 0;
    private boolean m_inView = false;
    private short m_breakCleanPoints = 0;
    private int m_breakCleanTimer = 0;
    public int m_switchToIdleTimer = -1;
    private boolean m_updateCachedStuff;
    private int m_cachedZSortOrderLeft;
    private int m_cachedZSortOrderRight;
    private int m_occupiedFlags;
    private int m_effectMoney;
    private short m_animSetId = 0;
    private AnimPlayer[] m_animPlayers = new AnimPlayer[1];
    private short m_effectAnimId;
    private int m_zSortOffsetLeft;
    private int m_zSortOffsetRight;
    private MapObjectSim m_postRenderTarget1;
    private MapObjectSim m_postRenderTarget2;

    public MapObject() {
        this.m_animPlayers[0] = new AnimPlayer();
        this.isMapObject = true;
    }

    public void init(int n, int n2, int n3, int n4, int n5) {
        this.setPos(n2, n3);
        this.setFacingDir(n4);
        this.m_type = n;
        this.m_id = n5;
        this.m_flags = Main.m_simWorld.d_objectFlags[n];
        this.m_runtimeFlags = 0;
        this.m_typeString = Main.m_simWorld.d_objectStringIds[n];
        this.m_zSortOffsetLeft = 0;
        this.m_zSortOffsetRight = 0;
        this.m_postRenderTarget1 = null;
        this.m_postRenderTarget2 = null;
        this.setRuntimeFlag(128);
        this.m_occupiedFlags = 0;
        int n6 = Main.m_simWorld.d_objectAnimIds[n];
        int n7 = Main.m_simWorld.getObjectAnimSetId(n, 0);
        if (n == 100) {
            n6 = 283;
        }
        if (n6 == 359 && n7 != 0) {
            this.setAnimSet(n7);
        } else {
            this.m_animSetId = (short)-1;
            this.setAnim(n6);
        }
        this.setEffectAnimId(-1);
        int n8 = this.getObjectValue();
        int n9 = 0;
        if (n == 7) {
            n9 = 1;
        } else if (n == 65) {
            n9 = n8 & 0xFFFFFF;
            if (n9 != 0 && (StateInGame.m_mapMode == 0 && Main.m_simWorld.m_houseId != 0 || StateInGame.m_mapMode == 1)) {
                int n10 = Main.m_simData.getGameTimeAbs();
                int n11 = this.getObjectValueTime();
                if (n11 != -1) {
                    if (n10 - n11 > 1440) {
                        n9 = 0;
                    }
                }
            }
        } else if (Main.m_simWorld.d_objectParents[n] == 15) {
            n9 = n8 & 0xFFFFFF;
        }
        this.stateTransition(n9);
        if ((n8 & 0x1000000) != 0) {
            this.breakObject();
        }
        if ((n8 & 0x2000000) != 0) {
            this.dirtyObject();
        }
        if (this.getFlag(0x6000000) && !this.getRuntimeFlag(768)) {
            this.m_breakCleanPoints = (short)(n8 & 0xFFFFFF);
            this.m_breakCleanTimer = 0;
            if (this.m_breakCleanPoints == 0) {
                this.m_breakCleanPoints = (short)Main.rand(0, 100);
            }
        }
        if (this.getParentType() == 9) {
            MapObject mapObject = StateInGame.createObject(54, this.getPosX(), this.getPosZ(), this.getFacingDir(), this.getId());
            mapObject.setZSortOffset(1);
        }
    }

    public void destroy() {
        StateInGame.removeObject(this);
        this.m_postRenderTarget1 = null;
        this.m_postRenderTarget2 = null;
    }

    public void setInView(boolean bl) {
        this.m_inView = bl;
    }

    public boolean isInView() {
        return this.m_inView;
    }

    public final int getType() {
        return this.m_type;
    }

    public final int getParentType() {
        return Main.m_simWorld.d_objectParents[this.m_type];
    }

    public final int getId() {
        return this.m_id;
    }

    public final int getTypeString() {
        if (this.getFlag(64)) {
            return this.getHouseTypeString();
        }
        return this.m_typeString;
    }

    public final int getPosX() {
        return this.m_posXF;
    }

    public final int getPosZ() {
        return this.m_posZF;
    }

    public void setPos(int n, int n2) {
        this.m_updateCachedStuff = true;
        this.m_posXF = n;
        this.m_posZF = n2;
    }

    public boolean getFlag(int n) {
        return (this.m_flags & n) != 0;
    }

    public void setFlag(int n) {
        this.m_flags |= n;
    }

    public boolean getRuntimeFlag(int n) {
        return (this.m_runtimeFlags & n) != 0;
    }

    public void setRuntimeFlag(int n, boolean bl) {
        if (bl) {
            this.setRuntimeFlag(n);
        } else {
            this.unsetRuntimeFlag(n);
        }
    }

    public void setRuntimeFlag(int n) {
        this.m_runtimeFlags |= n;
    }

    public void unsetRuntimeFlag(int n) {
        this.m_runtimeFlags &= ~n;
    }

    public void hide() {
        this.setRuntimeFlag(8192);
    }

    public void unhide() {
        this.unsetRuntimeFlag(8192);
    }

    public void reposition(int n, int n2, int n3) {
        this.applyFootprint(false);
        this.setPos(n, n2);
        this.setFacingDir(n3);
    }

    protected void updateCachedStuff() {
        if (this.m_updateCachedStuff) {
            this.m_updateCachedStuff = false;
            int n = Main.m_simWorld.coordWorldToScreenPixelsY(this.m_posXF, this.m_posZF);
            this.m_cachedZSortOrderLeft = n + this.m_zSortOffsetLeft;
            this.m_cachedZSortOrderRight = n + this.m_zSortOffsetRight;
        }
    }

    public int getTooltipStringId() {
        if (this.getFlag(16)) {
            return this.getTypeString();
        }
        return 557;
    }

    public void getHotSpot(int[] nArray) {
        int n = 0;
        int n2 = 0;
        AnimPlayer animPlayer = this.getAnimPlayer(0);
        int n3 = animPlayer.getAnimID();
        int n4 = animPlayer.getCurrAnimFrame();
        if (this.getParentType() == 15) {
            n3 = 449;
            n4 = 0;
        }
        if (n3 != -1) {
            if (AnimationManager.getAnimFrameFirePoint(nArray, n3, n4, 0)) {
                n = nArray[0];
                n2 = nArray[1];
            } else if (this.getFlag(16384)) {
                n2 = StateInGame.isMapMode() ? (n2 -= 7) : (n2 -= 38);
            }
        }
        nArray[0] = Main.m_simWorld.coordWorldToScreenX(this.getPosX(), this.getPosZ()) + (n << 16);
        nArray[1] = Main.m_simWorld.coordWorldToScreenY(this.getPosX(), this.getPosZ()) + (n2 << 16);
    }

    public void getInterestPoint(int[] nArray, int n) {
        int n2 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
        int n3 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
        int n4 = Main.m_simWorld.getObjectInterestPointX(this.getType(), n, this.getFacingDir());
        int n5 = Main.m_simWorld.getObjectInterestPointZ(this.getType(), n, this.getFacingDir());
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        nArray[0] = Main.m_simWorld.coordWorldTileToWorldCenterX(n6);
        nArray[1] = Main.m_simWorld.coordWorldTileToWorldCenterZ(n7);
    }

    public int getClosestInterestPoint(int n, int n2, boolean bl, MapObjectSim mapObjectSim) {
        int[] nArray = s_tempInt10;
        int n3 = Main.m_simWorld.getObjectInterestPointCount(this.getType());
        if (n3 > 0) {
            int n4 = -1;
            int n5 = Integer.MAX_VALUE;
            for (int i = 0; i < n3; ++i) {
                int n6;
                int n7;
                int n8;
                if (bl && !this.occupiedIsAvailable(i)) continue;
                this.getInterestPoint(nArray, i);
                int n9 = nArray[0];
                int n10 = nArray[1];
                if (!Main.m_simWorld.isWorldPointWalkable(n9, n10)) continue;
                if (bl && !this.getFlag(0x200000)) {
                    n8 = Main.m_simWorld.coordWorldToWorldTileX(n9);
                    n7 = Main.m_simWorld.coordWorldToWorldTileZ(n10);
                    n6 = 0;
                    MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
                    int n11 = mapObjectSimArray.length;
                    for (int j = 0; j < n11 && n6 == 0; ++j) {
                        MapObjectSim mapObjectSim2 = mapObjectSimArray[j];
                        if (mapObjectSim2 != null && mapObjectSim2.equals(mapObjectSim)) continue;
                        int n12 = Main.m_simWorld.coordWorldToWorldTileX(mapObjectSim2.getPosX());
                        int n13 = Main.m_simWorld.coordWorldToWorldTileZ(mapObjectSim2.getPosZ());
                        if (n12 != n8 || n13 != n7) continue;
                        n6 = 1;
                    }
                    if (n6 != 0) continue;
                }
                if ((n6 = (n8 = Math.abs(n - n9)) + (n7 = Math.abs(n2 - n10))) >= n5) continue;
                n5 = n6;
                n4 = i;
            }
            return n4;
        }
        return -1;
    }

    public boolean occupiedCapture(int n, MapObjectSim mapObjectSim) {
        if (this.getFlag(0x200000)) {
            return true;
        }
        if (this.getFlag(0x400000)) {
            if ((this.m_occupiedFlags & 1 << n) == 0) {
                this.m_occupiedFlags |= 1 << n;
                return true;
            }
        } else if (this.m_occupiedFlags == 0) {
            this.m_occupiedFlags = -1;
            return true;
        }
        return false;
    }

    public void occupiedRelease(int n) {
        this.m_occupiedFlags = this.getFlag(0x400000) ? (this.m_occupiedFlags &= ~(1 << n)) : 0;
    }

    public boolean occupiedIsEmpty() {
        if (this.getFlag(0x200000)) {
            return true;
        }
        return this.m_occupiedFlags == 0;
    }

    public boolean occupiedIsAnyAvailable() {
        if (this.occupiedIsEmpty()) {
            return true;
        }
        int n = Main.m_simWorld.getObjectInterestPointCount(this.getType());
        return this.m_occupiedFlags < (1 << n) - 1;
    }

    public boolean occupiedIsAvailable(int n) {
        return (this.m_occupiedFlags & 1 << n) == 0;
    }

    private int getObjectValue() {
        if (this.getId() == -1) {
            return 0;
        }
        if (this.getFlag(16384)) {
            return 0;
        }
        return Main.m_simData.getObjectValue(Main.m_simWorld.m_houseId, this.getId());
    }

    private int getObjectValueTime() {
        if (this.getId() == -1) {
            return -1;
        }
        return Main.m_simData.getObjectValueTime(Main.m_simWorld.m_houseId, this.getId());
    }

    private void saveObjectValue() {
        if (this.getId() == -1) {
            return;
        }
        int n = 0;
        if (this.getParentType() == 15) {
            n = this.m_state;
        } else if (this.getType() == 65) {
            n = this.m_state;
        }
        if (this.getFlag(0x2000000) && this.getRuntimeFlag(256)) {
            n |= 0x1000000;
        }
        if (this.getFlag(0x4000000) && this.getRuntimeFlag(512)) {
            n |= 0x2000000;
        }
        if (Main.m_simWorld.m_houseId == 0 && this.getFlag(0x6000000)) {
            n |= this.m_breakCleanPoints;
        }
        if (this.getRuntimeFlag(32768)) {
            n |= 0x8000000;
        }
        if (this.getRuntimeFlag(16384)) {
            n |= 0x4000000;
        }
        Main.m_simData.saveObjectValue(Main.m_simWorld.m_houseId, this.getId(), n);
    }

    public boolean isIdle() {
        if (this.getParentType() == 15) {
            return !this.isAnimating() && !this.isAnimating(1) && this.m_state != 1;
        }
        return this.m_state == 0;
    }

    public boolean isActive() {
        if (this.getParentType() == 15 && (this.isAnimating() || this.isAnimating(1))) {
            return false;
        }
        return this.m_state == 1;
    }

    protected final void stateTransition(int n) {
        int n2 = this.getParentType();
        if (n2 == 2) {
            this.basinStateTransition(n);
        } else if (n2 == 3) {
            this.bathStateTransition(n);
        } else if (n2 == 7) {
            this.coffeeMachineStateTransition(n);
        } else if (n2 == 9) {
            this.doorStateTransition(n);
        } else if (n2 == 16) {
            this.showerStateTransition(n);
        } else if (n2 == 18) {
            this.stoveStateTransition(n);
        } else if (n2 == 15) {
            this.plantStateTransition(n);
        } else if (this.getType() == 65) {
            this.trashCanStateTransition(n);
        }
        this.m_state = n;
        this.m_stateTime = 0;
        if (this.getType() == 65) {
            this.saveObjectValue();
        }
    }

    public void update(int n) {
        this.m_stateTime += n;
        if (this.getFlag(0x6000000) && !this.getRuntimeFlag(768)) {
            this.m_breakCleanTimer += n;
            if (this.m_breakCleanTimer > 4000) {
                this.m_breakCleanTimer -= 4000;
                this.addBreakCleanPoints(1);
            }
        }
        if (this.getRuntimeFlag(1)) {
            n = StateInGame.getNormalTimeStep();
        }
        int n2 = this.getType();
        int n3 = this.getParentType();
        if (n3 == 3) {
            this.bathUpdate(n);
        } else if (n3 == 15) {
            this.plantUpdate(n);
        } else {
            this.updateAnim(n);
            if (!this.isAnimating()) {
                if (n3 == 7) {
                    this.stateTransition(2);
                }
                if (this.getType() == 65 && this.m_state == 2) {
                    this.stateTransition(1);
                }
            }
        }
        if (n2 == 5) {
            if (!this.isAnimating()) {
                this.destroy();
            }
        } else if (n2 == 6 && this.m_stateTime > 1500) {
            this.destroy();
        }
    }

    public boolean isInteractivity() {
        int n = Main.INTERACTIVITIES_LIST.length;
        for (int i = 0; i < n; ++i) {
            if (this.m_type != Main.INTERACTIVITIES_LIST[i]) continue;
            return true;
        }
        return false;
    }

    protected void updateAnim(int n) {
        if (this.m_switchToIdleTimer > -1 && this.isInteractivity()) {
            this.m_switchToIdleTimer -= n;
            if (this.m_switchToIdleTimer < 0) {
                this.m_switchToIdleTimer = -1;
                this.interactEnd();
            }
        }
        if (this.getRuntimeFlag(4096)) {
            n = Camera.MathExt_Fmul(n << 16, 49152) >> 16;
        } else if (this.getRuntimeFlag(2048)) {
            n = Camera.MathExt_Fmul(n << 16, 81920) >> 16;
        }
        boolean bl = this.updateAnimPlayer(n, 0);
        if (this.updateAnimPlayer(n, 1)) {
            bl = true;
        }
        if (this.m_effectAnimId != -1 && bl) {
            this.spawnEffects();
        }
    }

    protected boolean updateAnimPlayer(int n, int n2) {
        AnimPlayer animPlayer = this.getAnimPlayer(n2);
        if (animPlayer != null) {
            return animPlayer.updateAnim(n);
        }
        return false;
    }

    protected final void spawnEffects() {
        int n;
        int[] nArray = s_tempInt10;
        AnimPlayer animPlayer = this.getAnimPlayer(0);
        AnimPlayer animPlayer2 = this.getAnimPlayer(1);
        int n2 = 1;
        AnimPlayer animPlayer3 = animPlayer;
        int n3 = 0;
        int n4 = 0;
        if (animPlayer2 != null && animPlayer2.isAnimating()) {
            animPlayer3 = animPlayer2;
            n2 = 0;
            if (animPlayer.getFirePointCurrFrame(nArray, 1)) {
                n3 = nArray[0];
                n4 = nArray[1];
            } else if (this.getRuntimeFlag(1024)) {
                n4 = -30;
            }
        }
        if ((n = animPlayer3.getNumFirePointsCurrFrame()) > n2) {
            if (this.getParentType() == 15) {
                int n5 = animPlayer3.getCurrAnimFrame();
                int n6 = this.fruitPerHarvest();
                int n7 = 2 + n6 - n5;
                this.getAnimPlayerCreate(n7).startAnim(this.m_effectAnimId, 16);
                return;
            }
            for (int i = n2; i < n; ++i) {
                int n8 = this.getPosX();
                int n9 = this.getPosZ();
                int n10 = Main.m_simWorld.coordWorldToScreenX(n8, n9);
                int n11 = Main.m_simWorld.coordWorldToScreenY(n8, n9);
                animPlayer3.getFirePointCurrFrame(nArray, i);
                n8 = Main.m_simWorld.coordScreenToWorldX(n10 += nArray[0] + n3 << 16, n11 += nArray[1] + n4 << 16);
                n9 = Main.m_simWorld.coordScreenToWorldZ(n10, n11);
                int n12 = -(nArray[1] + n4);
                if (this.getFlag(262144)) {
                    n12 += 2;
                }
                StateInGame.createEffectAnim(n8, n9, this.m_effectAnimId, n12);
            }
        }
    }

    public boolean respondToAction(int n, MapObjectSim mapObjectSim) {
        if (this.getType() == 65) {
            if (n == 153) {
                this.stateTransition(0);
            }
        } else if (this.getType() == 7) {
            if (n == 154) {
                if (this.getId() != -1) {
                    Main.m_simWorld.objectSell(this.getId());
                }
                this.destroy();
            }
        } else if (this.getParentType() == 9) {
            if (n == 155 || n == 158) {
                this.stateTransition(1);
                if (mapObjectSim.getId() == 0) {
                    if (!Main.m_simData.getSimCurRelStateFlags(0, 1)) {
                        StateInGame.advertiseEvent(23, mapObjectSim, this);
                    }
                }
            } else if (n == 156) {
                if (!StateInGame.isObjectAt(0, this.getPosX(), this.getPosZ())) {
                    this.stateTransition(0);
                }
            } else if (n == 157 && mapObjectSim.getId() == 0) {
                StateInGame.advertiseEvent(24, mapObjectSim, this);
            }
        } else if (this.getParentType() == 21) {
            if (n == 138) {
                this.unsetRuntimeFlag(16384);
                this.setRuntimeFlag(32768);
                this.saveObjectValue();
            } else if (n == 137) {
                this.setRuntimeFlag(16384);
                this.unsetRuntimeFlag(32768);
                this.saveObjectValue();
            }
        }
        return false;
    }

    public void breakObject() {
        this.setRuntimeFlag(256);
        switch (this.getParentType()) {
            case 14: 
            case 21: {
                this.turnOff();
                break;
            }
        }
        this.saveObjectValue();
        this.setSecondaryAnim(107, 20);
        StateInGame.showTutorialMessage((byte)9, 930, 931);
    }

    public void repairObject() {
        this.unsetRuntimeFlag(256);
        this.saveObjectValue();
        this.stopSecondaryAnim();
    }

    public void dirtyObject() {
        this.setRuntimeFlag(512);
        this.saveObjectValue();
        this.setSecondaryAnim(116, 20);
        StateInGame.showTutorialMessage((byte)10, 900, 901);
    }

    public void cleanObject() {
        this.unsetRuntimeFlag(512);
        this.saveObjectValue();
        this.stopSecondaryAnim();
    }

    public void addBreakCleanPoints(int n) {
        if (Main.m_simWorld.m_houseId != 0) {
            return;
        }
        if (!StateInGame.isCurtainActive() && !Event.PostEffects_isFading()) {
            this.m_breakCleanPoints = (short)(this.m_breakCleanPoints + n);
        }
        if (this.m_breakCleanPoints > 300 && (StateInGame.m_playerSim.m_simState == 0 || StateInGame.m_playerSim.m_simState == 1 || StateInGame.m_playerSim.m_simState == 3)) {
            this.m_breakCleanPoints = 0;
            if (this.getFlag(0x2000000)) {
                this.breakObject();
            } else {
                this.dirtyObject();
            }
        }
        this.saveObjectValue();
    }

    public void turnOn() {
        int n = this.getParentType();
        if (n == 14 || n == 21 || n == 17) {
            this.setAnimSetIndex(1);
        }
        if (n == 21 && !this.getRuntimeFlag(49152)) {
            this.setRuntimeFlag(32768);
        }
        this.setRuntimeFlag(64);
        this.addBreakCleanPoints(15);
    }

    public void turnOff() {
        int n = this.getParentType();
        if (n == 14 || n == 21 || n == 17) {
            this.setAnimSetIndex(0);
        }
        this.unsetRuntimeFlag(64);
        this.addBreakCleanPoints(15);
    }

    public void effectPlayAnim(int n, int n2) {
        this.unsetRuntimeFlag(128);
        this.setAnim(n);
        if (n == 110 || n == 111) {
            this.setRuntimeFlag(1);
        }
        this.setZSortOffset(n2);
    }

    public void effectShowMoney(int n) {
        this.m_effectMoney = n;
        this.setAnim(359);
        this.setZSortOffset(30);
    }

    private void renderMoneyEffect(int n, int n2) {
        int n3 = Camera.MathExt_smoothstepF(0, 1500, this.m_stateTime);
        int n4 = -40 + Camera.MathExt_Fmul(n3, -30);
        SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendMoneyToBuffer(this.m_effectMoney);
        AnimationManager.TextHandler_drawString(sDKString, 0, n, n2 + n4, 17);
    }

    public void basinStart() {
        this.stateTransition(1);
    }

    public void basinEnd() {
        this.stateTransition(0);
    }

    private void basinStateTransition(int n) {
        int n2 = 0;
        int n3 = -1;
        switch (n) {
            default: {
                n3 = -1;
                n2 = 0;
                break;
            }
            case 1: {
                n3 = 119;
                n2 = 1;
            }
        }
        this.setEffectAnimId(n3);
        this.setAnimSetIndex(n2);
    }

    public void bathToFill() {
        if (this.m_state == 0 || this.m_state == 3) {
            this.stateTransition(2);
        }
    }

    public void bathToEmpty() {
        if (this.m_state == 1 || this.m_state == 2) {
            this.stateTransition(3);
        }
    }

    public boolean bathIsFull() {
        return this.m_state == 1;
    }

    public void getBathSimPos(int[] nArray) {
        int n = Main.m_simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ());
        int n2 = Main.m_simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ());
        AnimPlayer animPlayer = this.getAnimPlayer(2);
        animPlayer.getFirePointCurrFrame(nArray, 0);
        nArray[0] = nArray[0] + n;
        nArray[1] = nArray[1] + n2;
    }

    private void bathUpdate(int n) {
        this.updateAnim(n);
        this.updateAnimPlayer(n, 2);
        if (!this.isAnimating(2)) {
            if (this.m_state == 2) {
                this.stateTransition(1);
            } else if (this.m_state == 3) {
                this.stateTransition(0);
            }
        }
    }

    private void bathStateTransition(int n) {
        int n2 = -1;
        boolean bl = true;
        switch (n) {
            default: {
                break;
            }
            case 2: {
                n2 = 141;
                bl = false;
                break;
            }
            case 1: {
                n2 = 142;
                break;
            }
            case 3: {
                n2 = 143;
                bl = false;
            }
        }
        AnimPlayer animPlayer = this.getAnimPlayerCreate(2);
        if (n2 != -1) {
            int n3 = Main.m_simWorld.getAnim(n2, this.getFacingDir());
            if (bl) {
                animPlayer.startAnim(n3, 20);
            } else {
                animPlayer.startAnim(n3, 16);
            }
        } else {
            animPlayer.setAnimating(false);
        }
    }

    public boolean chairShouldSnap() {
        int n;
        int n2 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
        return !Main.m_simWorld.isAgainstWall(n2, n = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ()), 1, 1, this.getFacingDir());
    }

    public void coffeeMachineActivate() {
        this.stateTransition(1);
    }

    public void coffeeMachineDeactivate() {
        this.stateTransition(0);
    }

    private void coffeeMachineStateTransition(int n) {
        int n2 = 0;
        boolean bl = true;
        int n3 = -1;
        if (n == 1) {
            n2 = 1;
            bl = false;
            n3 = 117;
        }
        this.m_effectAnimId = (short)n3;
        this.setRuntimeFlag(128, bl);
        this.setAnimSetIndex(n2);
    }

    public boolean coffeeMachineIsReady() {
        return this.m_state == 2;
    }

    private void doorStateTransition(int n) {
        this.m_state = n;
        int n2 = -1;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                n3 = 0;
                this.unsetRuntimeFlag(64);
                break;
            }
            case 1: {
                n2 = 1;
                n3 = -15;
                this.setRuntimeFlag(64);
                break;
            }
        }
        this.setAnimSetIndex(n2);
        this.applyFootprint(!this.getRuntimeFlag(64));
        this.setZSortOffset(n3);
    }

    public void fridgeOpen() {
        this.setAnimSetIndex(1);
    }

    public void fridgeClose() {
        this.setAnimSetIndex(0);
        this.addBreakCleanPoints(15);
    }

    private final int getHouseTypeString() {
        int n = -1;
        int n2 = -1;
        int n3 = ArrayHandler.indexOf(this.getType(), Main.m_simWorld.d_houseMacroObjects);
        int n4 = Main.m_simData.getSimCount();
        for (int i = 0; i < n4; ++i) {
            int n5 = Main.m_simData.getSimHome(i);
            if (n5 != n3) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            if (n2 != -1) continue;
            n2 = i;
        }
        if (n == -1 && n2 == -1) {
            return 605;
        }
        SDKString sDKString = n == 0 ? ArrayHandler.Rms_getSimName() : AnimationManager.TextHandler_getString(Main.m_simData.getSimName(n));
        if (n2 == -1) {
            AnimationManager.TextHandler_dynamicString(-10, 606, sDKString);
        } else {
            SDKString sDKString2 = AnimationManager.TextHandler_getString(Main.m_simData.getSimName(n2));
            AnimationManager.TextHandler_dynamicString(-10, 607, sDKString, sDKString2);
        }
        return -10;
    }

    private static final int plantForSeed(int n) {
        switch (n) {
            case 30: {
                return 42;
            }
            case 31: {
                return 45;
            }
            case 32: {
                return 43;
            }
            case 33: {
                return 46;
            }
            case 34: {
                return 44;
            }
        }
        Debug.ASSERT(false, "invalid seed type");
        return -1;
    }

    private static final int fruitAnimForPlant(int n, int n2) {
        switch (n) {
            case 42: {
                return 443;
            }
            case 45: {
                if (n2 == 0) {
                    return 447;
                }
                return 448;
            }
            case 43: {
                return 444;
            }
            case 44: {
                return 445;
            }
            case 46: {
                if (n2 == 0) {
                    return 441;
                }
                return 442;
            }
        }
        Debug.ASSERT(false, "invalid plant type");
        return -1;
    }

    private static final int fruitItemForPlant(int n) {
        switch (n) {
            case 42: {
                return 36;
            }
            case 45: {
                return 37;
            }
            case 43: {
                return 54;
            }
            case 46: {
                return 46;
            }
            case 44: {
                return 35;
            }
        }
        Debug.ASSERT(false, "invalid plant type");
        return -1;
    }

    private int fruitPerHarvest() {
        if (this.isGroundPlant()) {
            return 5;
        }
        return 8;
    }

    private boolean isGroundPlant() {
        return (Main.m_simWorld.d_objectFlags[this.getType()] & 0x10000) != 0;
    }

    public void plantSeed(int n) {
        int n2;
        GlobalConstants.PMDebug_println("plantSeed");
        this.m_type = n2 = MapObject.plantForSeed(n);
        Main.m_simWorld.objectChange(this.getId(), n2);
        this.m_typeString = Main.m_simWorld.d_objectStringIds[n2];
        this.m_state = 2;
        this.saveObjectValue();
        this.unsetRuntimeFlag(128);
        if (this.isGroundPlant()) {
            this.setAnim(450);
            this.setSecondaryAnim(446, 16);
            this.setEffectAnimId(MapObject.fruitAnimForPlant(n2, 0));
        } else {
            this.setAnim(451);
        }
        GlobalConstants.PMDebug_println("plantSeeded");
    }

    public void plantGrow() {
        GlobalConstants.PMDebug_println("plantGrow");
        boolean bl = false;
        switch (this.m_state) {
            default: {
                Debug.ASSERT(false, "invalid state for plant growth");
            }
            case 2: {
                if (this.isGroundPlant()) {
                    bl = true;
                    this.m_state = 1;
                    this.unsetRuntimeFlag(128);
                    this.setAnim(450);
                    this.setSecondaryAnim(446, 16);
                    this.setEffectAnimId(MapObject.fruitAnimForPlant(this.getType(), 1));
                    break;
                }
                this.m_state = 3;
                this.unsetRuntimeFlag(128);
                this.setAnim(452);
                break;
            }
            case 3: {
                bl = true;
                this.m_state = 1;
                this.unsetRuntimeFlag(128);
                this.setAnim(453);
                this.setSecondaryAnim(454, 16);
                this.setEffectAnimId(MapObject.fruitAnimForPlant(this.getType(), 0));
            }
        }
        this.saveObjectValue();
        GlobalConstants.PMDebug_println("plantGrowing");
    }

    private void plantClearFruit() {
        this.setSecondaryAnim(359, 16);
        for (int i = 2; i <= 9; ++i) {
            AnimPlayer animPlayer = this.getAnimPlayer(i);
            if (animPlayer == null) continue;
            animPlayer.startAnim(359, 16);
        }
    }

    private void plantCreateFruit(int n) {
        int n2 = MapObject.fruitAnimForPlant(this.getType(), n);
        int n3 = this.fruitPerHarvest();
        int n4 = 2 + n3 - 1;
        for (int i = 0; i < n3; ++i) {
            AnimPlayer animPlayer = this.getAnimPlayerCreate(n4 - i);
            animPlayer.startAnim(n2, 16);
            animPlayer.setLastFrame();
        }
    }

    public void plantHarvest() {
        GlobalConstants.PMDebug_println("plantHarvest");
        int n = MapObject.fruitItemForPlant(this.getType());
        int n2 = this.fruitPerHarvest();
        if (this.getRuntimeFlag(65536)) {
            n2 += 2;
            this.unsetRuntimeFlag(65536);
        }
        Main.m_simData.dreamCompleteEvent(44);
        int n3 = Main.m_simData.adjustInventory(n, n2);
        StateInGame.showGetItem(n, n3, 56, 360);
        if (this.isGroundPlant()) {
            this.plantUproot();
        } else {
            this.stateTransition(3);
        }
        this.plantClearFruit();
        this.saveObjectValue();
    }

    public void plantUproot() {
        this.m_type = 41;
        Main.m_simWorld.objectChange(this.getId(), 41);
        this.m_typeString = Main.m_simWorld.d_objectStringIds[41];
        this.m_state = 0;
        this.plantClearFruit();
        this.unsetRuntimeFlag(128);
        this.setAnim(449);
        this.saveObjectValue();
        GlobalConstants.PMDebug_println("plantUprooted");
    }

    private void plantStateTransition(int n) {
        this.m_state = n;
        int n2 = 0;
        switch (n) {
            default: {
                Debug.ASSERT(false, "invalid state for shower");
            }
            case 0: {
                n2 = 449;
                break;
            }
            case 2: {
                if (this.isGroundPlant()) {
                    this.plantCreateFruit(0);
                    n2 = 450;
                    AnimPlayer animPlayer = this.getAnimPlayerCreate(1);
                    animPlayer.startAnim(446, 16);
                    animPlayer.setLastFrame();
                    break;
                }
                n2 = 451;
                break;
            }
            case 3: {
                n2 = 452;
                break;
            }
            case 1: {
                this.plantCreateFruit(1);
                int n3 = 454;
                n2 = 453;
                if (this.isGroundPlant()) {
                    n3 = 446;
                    n2 = 450;
                }
                AnimPlayer animPlayer = this.getAnimPlayerCreate(1);
                animPlayer.startAnim(n3, 16);
                animPlayer.setLastFrame();
                break;
            }
        }
        this.unsetRuntimeFlag(128);
        this.setAnim(n2);
        this.getAnimPlayer(0).setLastFrame();
    }

    private void plantUpdate(int n) {
        int n2 = this.fruitPerHarvest();
        for (int i = 0; i < n2; ++i) {
            this.updateAnimPlayer(n, 2 + i);
        }
        this.updateAnim(n);
    }

    public void phonePickup() {
        this.setAnimSetIndex(1);
    }

    public void phoneHangup() {
        this.setAnimSetIndex(0);
    }

    public void interactStart() {
        this.setAnimSetIndex(1);
    }

    public void interactStart(int n) {
        this.m_switchToIdleTimer = n;
        this.setAnimSetIndex(1);
    }

    public void interactEnd() {
        if (this.m_switchToIdleTimer == -1) {
            this.setAnimSetIndex(0);
        }
    }

    public void showerStart() {
        this.stateTransition(1);
    }

    public void showerEnd() {
        this.addBreakCleanPoints(15);
        this.stateTransition(0);
    }

    private void showerStateTransition(int n) {
        this.m_state = n;
        int n2 = -1;
        int n3 = -1;
        switch (n) {
            default: {
                Debug.ASSERT(false, "invalid state for shower");
            }
            case 0: {
                n3 = -1;
                n2 = 0;
                break;
            }
            case 1: {
                n3 = 117;
                n2 = 1;
            }
        }
        this.setEffectAnimId(n3);
        this.setAnimSetIndex(n2);
    }

    public void stoveStart() {
        this.stateTransition(1);
    }

    public void stoveEnd() {
        this.stateTransition(0);
    }

    private void stoveStateTransition(int n) {
        this.m_state = n;
        int n2 = -1;
        int n3 = -1;
        switch (n) {
            default: {
                Debug.ASSERT(false, "invalid state for stove");
            }
            case 0: {
                n3 = -1;
                n2 = 0;
                break;
            }
            case 1: {
                n3 = 117;
                n2 = 1;
            }
        }
        this.setEffectAnimId(n3);
        this.setAnimSetIndex(n2);
    }

    public void trashCanKick(MapObjectSim mapObjectSim) {
        if (StateInGame.m_mapMode == 0) {
            StateInGame.advertiseEvent(21, mapObjectSim, this);
        }
        this.setFacingObject(mapObjectSim);
        this.setFacingDir((this.m_facingDir + 2) % 4);
        this.stateTransition(2);
    }

    private void trashCanStateTransition(int n) {
        Debug.ASSERT(true, "idle state for trashcan must be 0 to match default persistant value");
        boolean bl = true;
        int n2 = -1;
        switch (n) {
            default: {
                Debug.ASSERT(false, "invalid state for trashcan");
            }
            case 0: {
                this.stopSecondaryAnim();
                n2 = 0;
                break;
            }
            case 2: {
                this.setSecondaryAnim(116, 20);
                n2 = 1;
                bl = false;
                break;
            }
            case 1: {
                this.setSecondaryAnim(116, 4);
                n2 = 2;
            }
        }
        this.setRuntimeFlag(128, bl);
        this.setAnimSetIndex(n2);
    }

    public AnimPlayer getAnimPlayer(int n) {
        if (n < this.m_animPlayers.length) {
            return this.m_animPlayers[n];
        }
        return null;
    }

    protected AnimPlayer getAnimPlayerCreate(int n) {
        Object object;
        if (n >= this.m_animPlayers.length) {
            object = new AnimPlayer[n + 1];
            System.arraycopy(this.m_animPlayers, 0, object, 0, this.m_animPlayers.length);
            this.m_animPlayers = object;
        }
        if (this.m_animPlayers[n] == null) {
            this.m_animPlayers[n] = object = new AnimPlayer();
            ((AnimPlayer)object).setAnimating(false);
        }
        return this.m_animPlayers[n];
    }

    protected void setSecondaryAnim(int n, int n2) {
        AnimPlayer animPlayer = this.getAnimPlayerCreate(1);
        animPlayer.startAnim(n, n2);
    }

    protected void stopSecondaryAnim() {
        AnimPlayer animPlayer = this.getAnimPlayer(1);
        if (animPlayer != null) {
            animPlayer.setAnimating(false);
        }
    }

    public void setEffectAnimId(int n) {
        this.m_effectAnimId = (short)n;
    }

    public int getZSortOrderLeft() {
        this.updateCachedStuff();
        return this.m_cachedZSortOrderLeft;
    }

    public int getZSortOrderRight() {
        this.updateCachedStuff();
        return this.m_cachedZSortOrderRight;
    }

    public void setZSortOffset(int n) {
        this.m_zSortOffsetLeft = n;
        this.m_zSortOffsetRight = n;
        this.m_updateCachedStuff = true;
    }

    public void setPostRenderTarget(MapObjectSim mapObjectSim) {
        if (this.m_postRenderTarget1 == null) {
            this.m_postRenderTarget1 = mapObjectSim;
        } else if (this.m_postRenderTarget2 == null) {
            this.m_postRenderTarget2 = mapObjectSim;
        } else {
            Debug.ASSERT(false, "can't have three post-render targets");
        }
    }

    public void releasePostRenderTarget(MapObjectSim mapObjectSim) {
        if (this.m_postRenderTarget1 != null && this.m_postRenderTarget1.equals(mapObjectSim)) {
            this.m_postRenderTarget1 = null;
        }
        if (this.m_postRenderTarget2 != null && this.m_postRenderTarget2.equals(mapObjectSim)) {
            this.m_postRenderTarget2 = null;
        }
    }

    public void render2D() {
        AnimPlayer animPlayer;
        int n;
        int n2;
        int[] nArray = s_tempInt10;
        int n3 = Main.m_simWorld.getCameraPixelX();
        int n4 = Main.m_simWorld.getCameraPixelY() - (StateInGame.camOffsetZ >> 16);
        int n5 = n3 + Main.m_simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ());
        int n6 = n4 + Main.m_simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ());
        if (this.getType() == 6) {
            this.renderMoneyEffect(n5, n6);
            return;
        }
        AnimPlayer animPlayer2 = this.getAnimPlayer(0);
        animPlayer2.drawAnim(n5, n6);
        int n7 = this.getParentType();
        int n8 = n5;
        int n9 = n6;
        AnimPlayer animPlayer3 = this.getAnimPlayer(1);
        if (animPlayer3 != null && animPlayer3.isAnimating()) {
            if (animPlayer2.getFirePointCurrFrame(nArray, 1)) {
                n8 += nArray[0];
                n9 += nArray[1];
            } else if (animPlayer2.getFirePointCurrFrame(nArray, 0)) {
                n8 += nArray[0];
                n9 += nArray[1];
            }
            animPlayer3.drawAnim(n8, n9);
        }
        if (n7 == 15 && animPlayer3 != null && (n2 = animPlayer3.getAnimID()) != 359) {
            n = this.fruitPerHarvest();
            for (int i = n - 1; i >= 0; --i) {
                AnimPlayer animPlayer4 = this.getAnimPlayer(2 + i);
                if (animPlayer4 == null) continue;
                int n10 = n - i;
                AnimationManager.getAnimFrameFirePoint(nArray, n2, n10, 0);
                int n11 = n8 + nArray[0];
                int n12 = n9 + nArray[1];
                animPlayer4.drawAnim(n11, n12);
            }
        }
        if (n7 == 3 && (animPlayer = this.getAnimPlayer(2)).isAnimating()) {
            animPlayer.drawAnim(n5, n6);
        }
        if (this.getFlag(0x1000000)) {
            if (this.m_postRenderTarget1 != null) {
                this.m_postRenderTarget1.render2DPost();
            }
            if (this.m_postRenderTarget2 != null) {
                this.m_postRenderTarget2.render2DPost();
            }
            n2 = Main.m_simWorld.getObjectAnimSetId(this.getType(), 1);
            n = Main.m_simWorld.getAnim(n2, this.getFacingDir());
            AnimationManager.drawAnimFrame(n, 0, n5, n6);
        }
    }

    public void createBuildContextMenu(short[] sArray) {
        Main.menuClear(sArray, this.m_typeString);
        if (!this.buildInUse()) {
            if (this.buildCanRotate()) {
                Main.menuAppendItem(sArray, 98);
            }
            if (this.buildCanMove()) {
                Main.menuAppendItem(sArray, 85);
            }
            if (this.buildCanSell()) {
                Main.menuAppendItem(sArray, 100);
            }
        } else {
            Main.menuAppendItem(sArray, 63);
        }
    }

    public void applyFootprint(boolean bl) {
        int n;
        int n2;
        if (this.getFlag(262144)) {
            this.setZSortOffset(2);
            return;
        }
        if (this.getFlag(4)) {
            if (this.getType() == 9) {
                this.setZSortOffset(2);
            }
            return;
        }
        int n3 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
        int n4 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
        int n5 = Main.m_simWorld.d_objectFootprintWidths[this.getType()];
        int n6 = Main.m_simWorld.d_objectFootprintHeights[this.getType()];
        if (this.getFacingDir() == 1 || this.getFacingDir() == 3) {
            n2 = n5;
            n5 = n6;
            n6 = n2;
        }
        if (bl) {
            if (this.getParentType() == 9) {
                n2 = 255;
                n = 32;
            } else {
                n2 = 255;
                n = 128;
            }
        } else {
            n2 = ~(0x80 | 0x20);
            n = 0;
        }
        Main.m_simWorld.paintAttributes(n3 - n5 + 1, n4 - n6 + 1, n5, n6, n2, n);
        this.m_footprintWidth = (byte)n5;
        this.m_footprintHeight = (byte)n6;
        int n7 = this.m_type;
        if (this.getFlag(0x800000)) {
            this.setZSortOffset(-16);
        } else if (this.getFlag(8)) {
            this.setZSortOffset(0);
        } else if (n7 == 63) {
            this.setZSortOffset(-9);
        } else if (n7 == 52) {
            this.setZSortOffset(-10);
        } else if (n5 != 0 && n6 != 0) {
            this.m_zSortOffsetLeft = n5 * -8 + 4;
            this.m_zSortOffsetRight = n6 * -8 + 4;
        }
        this.m_updateCachedStuff = true;
    }

    public int getFacingDir() {
        return this.m_facingDir;
    }

    public void setFacingDir(int n) {
        if (this.m_facingDir != n) {
            this.m_updateCachedStuff = true;
            this.m_facingDir = n;
            if (this.m_animSetId != -1) {
                this.setAnimSet(this.m_animSetId);
            }
        }
    }

    public void setFacingDir(int n, int n2) {
        if (Math.abs(n) > Math.abs(n2)) {
            if (n < 0) {
                this.setFacingDir(2);
            } else {
                this.setFacingDir(0);
            }
        } else if (n2 < 0) {
            this.setFacingDir(3);
        } else {
            this.setFacingDir(1);
        }
    }

    public void setFacingObject(MapObject mapObject) {
        int n = Math.max(mapObject.m_footprintWidth - 1, 0);
        int n2 = Math.max(mapObject.m_footprintHeight - 1, 0);
        int n3 = n << 3 + 15;
        int n4 = n2 << 3 + 15;
        int n5 = mapObject.getPosX() - n3;
        int n6 = mapObject.getPosZ() - n4;
        this.setFacingDir(n5 - this.getPosX(), n6 - this.getPosZ());
    }

    public void setAnim(int n) {
        if (this.getRuntimeFlag(128)) {
            this.getAnimPlayer(0).startAnim(n, 20);
        } else {
            this.getAnimPlayer(0).startAnim(n, 16);
        }
    }

    public boolean isAnimating() {
        return this.m_animPlayers[0].isAnimating();
    }

    public boolean isAnimating(int n) {
        AnimPlayer animPlayer = this.getAnimPlayer(n);
        return animPlayer != null && animPlayer.isAnimating();
    }

    public void setAnimSet(int n) {
        this.m_animSetId = (short)n;
        int n2 = Main.m_simWorld.getAnim(n, this.getFacingDir());
        this.setAnim(n2);
    }

    public void setAnimSetIndex(int n) {
        this.setAnimSet(Main.m_simWorld.getObjectAnimSetId(this.getType(), n));
    }

    public boolean buildInUse() {
        int n;
        if (this.m_occupiedFlags != 0) {
            return true;
        }
        if (this.getFlag(131072)) {
            int n2;
            int n3 = this.getType();
            n = Main.m_simWorld.d_objectFootprintWidths[n3];
            int n4 = Main.m_simWorld.d_objectFootprintHeights[n3];
            if (this.getFacingDir() == 1 || this.getFacingDir() == 3) {
                n2 = n;
                n = n4;
                n4 = n2;
            }
            n2 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
            int n5 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n4; ++j) {
                    if (!Main.m_simWorld.isBenchTopObjectAt(n2 - i, n5 - j)) continue;
                    return true;
                }
            }
        }
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        for (n = 0; n < mapObjectSimArray.length; ++n) {
            if (mapObjectSimArray[n].getPostureObject() == null || !mapObjectSimArray[n].getPostureObject().equals(this)) continue;
            return true;
        }
        return false;
    }

    public boolean buildCanSell() {
        return Main.m_simWorld.d_objectSellPrices[this.m_type] > 0;
    }

    public boolean buildCanMove() {
        this.applyFootprint(false);
        int n = Main.m_simWorld.createBuildPoints(this.getType());
        StateInGame.removeBuildPoints();
        this.applyFootprint(true);
        return n >= 1;
    }

    public boolean buildCanRotate() {
        return this.getNextValidRotation() != this.getFacingDir();
    }

    private int getNextValidRotation() {
        boolean bl = this.getFlag(262144);
        if (!bl) {
            this.applyFootprint(false);
        }
        int n = this.getFacingDir();
        int n2 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
        int n3 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
        int n4 = Main.m_simWorld.getObjectValidRotations(this.getType(), n2, n3);
        Debug.ASSERT(n4 != 0, "object in invalid position");
        for (int i = 1; i <= 4; ++i) {
            int n5 = (n + i) % 4;
            int n6 = SimWorld.ROTATION_FLAGS[n5];
            if ((n4 & n6) == 0) continue;
            n = n5;
            break;
        }
        if (!bl) {
            this.applyFootprint(true);
        }
        return n;
    }

    public void buildRotate() {
        this.applyFootprint(false);
        this.reposition(this.getPosX(), this.getPosZ(), this.getNextValidRotation());
        this.applyFootprint(true);
    }

    public String toString() {
        return "";
    }
}

