/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Camera;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.state.StateInGame;

public class Cursor {
    public static MapObject m_cursorObject;
    public static int m_cursorPosX;
    public static int m_cursorPosZ;
    public static int m_cursorDestX;
    public static int m_cursorDestZ;
    public static boolean m_cursorAtDest;
    public static int m_cursorAtDestTime;
    public static AnimPlayer m_cursorAnimPlayer;
    public static int m_cursorSelectTimer;
    public static boolean hide;
    public static int cursorX;
    public static int cursorY;
    public static int m_cursorSelectFlags;
    public static boolean m_cursorSnapping;
    public static boolean m_keyLeft;
    public static boolean m_keyRight;
    public static boolean m_keyDown;
    public static boolean m_keyUp;
    public static int[] ResourceManager_m_crcTable;
    public static int MinigameArt_currentState;
    public static int MinigameArt_currentStateTime;
    public static int[] MinigameArt_solution;
    public static int[] MinigameArt_sequence;
    public static int[] MinigameArt_guess;
    public static int[] MinigameArt_guessSequence;
    public static int MinigameArt_guessSequenceIndex;
    public static int MinigameArt_guessColor;
    public static final int[] MinigameArt_TIME_PAINT;
    public static final boolean[][] MinigameArt_ALLOWED_FIELDS;
    public static final byte[] MinigameArt_NUM_SPLATS;
    public static int MinigameArt_skill;
    public static int MinigameArt_currentSplatShownTimer;
    public static int MinigameArt_numSplatsToShow;
    public static int[] MinigameArt_canvasRect;
    private static int[] MinigameArt_bgGradientColors;
    public static int[] MinigameArt_cursorPositionsX;
    public static int[] MinigameArt_cursorPositionsY;
    public static int MinigameArt_cursorPos;
    public static int MinigameArt_cursorPosPrevColorIndex;
    public static int MinigameArt_cursorPosXf;
    public static int MinigameArt_cursorPosYf;
    public static int MinigameArt_cursorPosXfPrev;
    public static int MinigameArt_cursorPosYfPrev;
    public static int MinigameArt_cursorPosXfTarget;
    public static int MinigameArt_cursorPosYfTarget;
    public static AnimPlayer MinigameArt_cursorAP;
    public static int MinigameArt_palettePosX;
    public static int MinigameArt_palettePosY;
    public static int[] MinigameArt_paletteColorPosX;
    public static int[] MinigameArt_paletteColorPosY;
    private static boolean MinigameArt_artComplete;
    public static SDKString MinigameArt_stringTop;
    public static short[] MinigameArt_stringTopWrap;
    public static int MinigameArt_stringTopPosX;
    public static int MinigameArt_stringTopPosY;
    public static SDKString MinigameArt_stringBottom;
    public static short[] MinigameArt_stringBottomWrap;
    public static int MinigameArt_stringBottomPosX;
    public static int MinigameArt_stringBottomPosY;
    public static int MinigameArt_errorShakeCounter;
    public static int MinigameArt_ERROR_SHAKE_OFFSET_MAX;
    public static int MinigameArt_errorShakeOffsetX;
    public static int MinigameArt_errorShakeOffsetY;
    public static int MinigameArt_blinkTimer;
    public static boolean MinigameArt_blinkShowString;
    public static boolean MinigameArt_addMoreTimeToBrushMovement;
    public static final short[] SimsHousesConstants_HOUSES_SYMBOL_LOOKUPS;
    public static int PMStorage_defaultId;

    public static void stopCursor() {
        m_keyLeft = false;
        m_keyRight = false;
        m_keyDown = false;
        m_keyUp = false;
    }

    public static void processKeysCursor() {
        if (hide) {
            return;
        }
        Cursor.processKeysCursorDirs();
        if (Cursor.keyAnyDir()) {
            StateInGame.clearCameraFollow();
        }
    }

    public static boolean keyAnyDir() {
        return Cursor.keyAnyLeft() || Cursor.keyAnyRight() || Cursor.keyAnyUp() || Cursor.keyAnyDown();
    }

    public static boolean keyAnyLeft() {
        return ArrayHandler.PMInput_isHeld(648);
    }

    public static boolean keyAnyRight() {
        return ArrayHandler.PMInput_isHeld(1296);
    }

    public static boolean keyAnyUp() {
        return ArrayHandler.PMInput_isHeld(416);
    }

    public static boolean keyAnyDown() {
        return ArrayHandler.PMInput_isHeld(1600);
    }

    public static void processKeysCursorDirs() {
        if (StateInGame.m_buyModeState != 10 || StateInGame.m_buyModeState == 10 && m_cursorSelectTimer <= 0) {
            m_keyLeft = Cursor.keyAnyLeft();
            m_keyRight = Cursor.keyAnyRight();
            m_keyUp = Cursor.keyAnyUp();
            m_keyDown = Cursor.keyAnyDown();
        } else {
            m_keyLeft = false;
            m_keyRight = false;
            m_keyUp = false;
            m_keyDown = false;
        }
    }

    public static void processKeysFire() {
        int n;
        int n2;
        if (hide) {
            return;
        }
        StateInGame.clearCameraFollow();
        MapObject mapObject = m_cursorObject;
        if (mapObject != null && m_cursorAtDest) {
            if (mapObject != null && mapObject.equals(StateInGame.m_playerSim)) {
                StateInGame.showQuickLinks();
            } else {
                StateInGame.showContextMenu(mapObject);
            }
        } else if (StateInGame.m_state == 5 && m_cursorAtDest && Main.m_simWorld.isWorldPointWalkable(n2 = Main.m_simWorld.coordScreenToWorldX(m_cursorPosX, m_cursorPosZ), n = Main.m_simWorld.coordScreenToWorldZ(m_cursorPosX, m_cursorPosZ))) {
            StateInGame.processSimAction(111, null, n2, n);
        }
    }

    public static void renderCursor() {
        if (hide) {
            return;
        }
        if (Event.m_eventState == 1 || StateInGame.m_buyModeState == 6) {
            return;
        }
        cursorX = m_cursorPosX;
        cursorY = m_cursorPosZ - StateInGame.camOffsetZ;
        if (StateInGame.m_quickLinksActive && m_cursorObject != null) {
            cursorX = m_cursorDestX;
            cursorY = m_cursorDestZ - StateInGame.camOffsetZ;
        }
        cursorX = (cursorX >> 16) + Main.m_simWorld.getCameraPixelX();
        cursorY = (cursorY >> 16) + Main.m_simWorld.getCameraPixelY();
        if (StateInGame.m_quickLinksActive) {
            StateInGame.renderQuickLinksMarker(cursorX, cursorY);
        } else {
            int n;
            AnimationManager.drawAnim(m_cursorAnimPlayer, cursorX, cursorY);
            if (m_cursorAtDest && m_cursorObject != null && m_cursorAtDestTime < 1000 && (n = m_cursorObject.getTooltipStringId()) != 557) {
                int n2 = AnimationManager.TextHandler_getStringWidth(n, 1);
                int n3 = AnimationManager.TextHandler_getLineHeight(1) - 2;
                int n4 = 3 + n2 + 3;
                int n5 = 2 + n3 + 2;
                int n6 = Math.max(0, cursorX + -5 - n4);
                int n7 = cursorY + -5 - n5;
                AnimationManager.setColor(48);
                ArrayOptimizer.PMGraphics_drawRect(n6, n7, n4, n5);
                AnimationManager.setColor(47);
                ArrayOptimizer.PMGraphics_fillRect(n6 + 1, n7 + 1, n4 - 1, n5 - 1);
                AnimationManager.TextHandler_drawString(n, 1, n6 + 3 + (n2 >> 1), n7 + 2, 17);
            }
        }
    }

    public static void updateCursorPosition(int n) {
        int n2;
        int n3;
        int n4;
        if (!m_cursorSnapping) {
            n4 = (m_keyRight ? 65536 : 0) + (m_keyLeft ? -65536 : 0);
            n3 = (m_keyDown ? 65536 : 0) + (m_keyUp ? -65536 : 0);
            if (n4 != 0 || n3 != 0) {
                n2 = Camera.MathExt_Fatan2(n3, n4);
                Cursor.changeCursorSnapCheck(n2, true);
            }
        }
        if (m_cursorSnapping) {
            int n5;
            if (m_cursorObject != null) {
                m_cursorObject.getHotSpot(StateInGame.m_tempInt10);
                m_cursorDestX = StateInGame.m_tempInt10[0];
                m_cursorDestZ = StateInGame.m_tempInt10[1];
            }
            if ((n4 = (StateInGame.m_quickLinksActive ? 6553 : 6553) * n) >= (n5 = Camera.MathExt_Fmag2(n3 = m_cursorDestX - m_cursorPosX >> 8, n2 = m_cursorDestZ - m_cursorPosZ >> 8)) << 8) {
                m_cursorPosX = m_cursorDestX;
                m_cursorPosZ = m_cursorDestZ;
            } else {
                n4 = Camera.MathExt_Fdiv(n4, n5);
                m_cursorPosX += Camera.MathExt_Fmul(n3, n4);
                m_cursorPosZ += Camera.MathExt_Fmul(n2, n4);
            }
            m_cursorAtDest = m_cursorPosX == m_cursorDestX && m_cursorPosZ == m_cursorDestZ;
            m_cursorSnapping = m_cursorSnapping && !m_cursorAtDest;
        } else if (m_cursorSelectTimer <= 0) {
            n4 = n * ((m_keyRight ? 8192 : 0) + (m_keyLeft ? -8192 : 0));
            n3 = n * ((m_keyDown ? 8192 : 0) + (m_keyUp ? -8192 : 0));
            m_cursorPosX += n4;
            m_cursorPosZ += n3;
            if (n4 != 0 || n3 != 0) {
                m_cursorObject = null;
                m_cursorSelectTimer = 0;
                Cursor.clipCursorPos();
                m_cursorDestX = m_cursorPosX;
                m_cursorDestZ = m_cursorPosZ;
                m_cursorAtDest = true;
                m_cursorAtDestTime = 0;
            } else if (m_cursorObject != null && m_cursorAtDest) {
                m_cursorObject.getHotSpot(StateInGame.m_tempInt10);
                m_cursorDestX = StateInGame.m_tempInt10[0];
                m_cursorDestZ = StateInGame.m_tempInt10[1];
                m_cursorPosX = StateInGame.m_tempInt10[0];
                m_cursorPosZ = StateInGame.m_tempInt10[1];
            }
        }
        m_cursorAtDestTime = m_cursorAtDest ? (m_cursorAtDestTime += n) : 0;
    }

    public static void clipCursorPos() {
        int n = (Main.m_simWorld.m_tileMap.getWidth() * Main.m_simWorld.m_tileMap.getTileSizeX() << 16) - 983040;
        int n2 = (Main.m_simWorld.m_tileMap.getHeight() * Main.m_simWorld.m_tileMap.getTileSizeY() << 16) - 983040;
        m_cursorPosX = Camera.MathExt_clip(m_cursorPosX, 983040, n);
        m_cursorPosZ = Camera.MathExt_clip(m_cursorPosZ, 983040, n2);
    }

    public static void updateCursor(int n) {
        if (StateInGame.isCurtainActive()) {
            return;
        }
        if (!StateInGame.m_pauseMenuActive) {
            Cursor.updateCursorPosition(n);
        }
        if (m_cursorObject != null && m_cursorSelectTimer > 0) {
            m_cursorSelectTimer -= n;
        }
        int n2 = m_cursorAtDest && m_cursorObject != null || StateInGame.m_contextMenuActive || StateInGame.m_state == 7 && StateInGame.m_buyModeState == 2 ? 676 : 675;
        m_cursorAnimPlayer.startAnim(n2, 4);
        m_cursorAnimPlayer.updateAnim(n);
    }

    public static void setCursorObject(MapObject mapObject) {
        m_cursorObject = mapObject;
        if (mapObject != null) {
            mapObject.getHotSpot(StateInGame.m_tempInt10);
            m_cursorDestX = StateInGame.m_tempInt10[0];
            m_cursorDestZ = StateInGame.m_tempInt10[1];
            m_cursorSnapping = true;
            m_cursorAtDestTime = 0;
        } else {
            m_cursorDestX = m_cursorPosX;
            m_cursorDestZ = m_cursorPosZ;
            m_cursorSnapping = false;
        }
    }

    public static void setCursorSelectFlags(int n) {
        m_cursorSelectFlags = n;
        if (m_cursorObject == null || !m_cursorObject.getFlag(n)) {
            Cursor.setCursorObject(null);
        }
    }

    public static MapObject cursorSnapObject(int n, boolean bl) {
        int n2 = StateInGame.m_viewportWidth << 16;
        int n3 = StateInGame.m_viewportHeight << 16;
        int n4 = bl ? 0x2D0000 : 0x190000;
        MapObject mapObject = null;
        long l = (n4 >> 8) * (n4 >> 8);
        int n5 = m_cursorPosX;
        int n6 = m_cursorPosZ;
        int n7 = Camera.MathExt_normaliseAngleRadiansF(n);
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n8 = mapObjectArray.length;
        int n9 = m_cursorSelectFlags;
        for (int i = 0; i < n8; ++i) {
            long l2;
            long l3;
            long l4;
            int n10;
            int n11;
            MapObject mapObject2 = mapObjectArray[i];
            mapObject2.getHotSpot(StateInGame.m_tempInt10);
            int n12 = StateInGame.m_tempInt10[0];
            int n13 = StateInGame.m_tempInt10[1];
            if (mapObject2 != null && mapObject2.equals(m_cursorObject) || !mapObject2.getFlag(n9)) continue;
            int n14 = Math.abs(n5 - n12);
            int n15 = Math.abs(n6 - n13);
            if (n14 > n2 || n15 > n3 || n14 == 0 && n15 == 0 || bl && (n11 = Math.abs(Camera.MathExt_normaliseAngleRadiansF(n7 - (n10 = Camera.MathExt_Fatan2(n13 - n6, n12 - n5))))) >= 51472 || (l4 = (l3 = (long)(n5 - n12 >> 8)) * l3 + (l2 = (long)(n6 - n13 >> 8)) * l2) >= l) continue;
            mapObject = mapObject2;
            l = l4;
        }
        return mapObject;
    }

    public static void changeCursorSnapCheck(int n, boolean bl) {
        MapObject mapObject = Cursor.cursorSnapObject(n, bl);
        if (mapObject != null) {
            Cursor.setCursorObject(mapObject);
            m_cursorSelectTimer = 200;
        }
    }

    public static void changeCursorDistanceCheck() {
        MapObject mapObject = null;
        int n = Integer.MAX_VALUE;
        int n2 = m_cursorPosX;
        int n3 = m_cursorPosZ;
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n4 = mapObjectArray.length;
        int n5 = m_cursorSelectFlags;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            int n8;
            MapObject mapObject2 = mapObjectArray[i];
            mapObject2.getHotSpot(StateInGame.m_tempInt10);
            int n9 = StateInGame.m_tempInt10[0];
            int n10 = StateInGame.m_tempInt10[1];
            if (mapObject2 != null && mapObject2.equals(m_cursorObject) || !mapObject2.getFlag(n5) || (n8 = Camera.MathExt_Fmag2(n7 = n2 - n9 >> 8, n6 = n3 - n10 >> 8)) >= n) continue;
            mapObject = mapObject2;
            n = n8;
        }
        if (mapObject != null) {
            Cursor.setCursorObject(mapObject);
            m_cursorSelectTimer = 200;
        }
    }

    public static void ResourceManager_init() {
        Cursor.ResourceManager_buildCRC32LUT();
    }

    public static SDKImage ResourceManager_loadImage(int n) {
        try {
            return Debug.PMImage_loadImage(Intro.ResourceConstants_RESOURCE_FILENAMES_LIST[n], "");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean ResourceManager_loadBinaryFile(int n) {
        return GameConstants.PMFile_openFile(Intro.ResourceConstants_RESOURCE_FILENAMES_LIST[n]);
    }

    public static void ResourceManager_buildCRC32LUT() {
        int[] nArray = ResourceManager_m_crcTable = new int[256];
        for (int i = 0; i <= 255; ++i) {
            int n = i;
            for (int j = 8; j > 0; --j) {
                if ((n & 1) != 0) {
                    n = n >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>>= 1;
            }
            nArray[i] = n;
        }
    }

    public static int ResourceManager_calcCRC32(byte[] byArray, int n, int n2) {
        int n3 = -1;
        int[] nArray = ResourceManager_m_crcTable;
        for (int i = n; i < n + n2; ++i) {
            int n4 = 0xFF & byArray[i] ^ n3 & 0xFF;
            n3 = n3 >>> 8 ^ nArray[n4];
        }
        return ~n3;
    }

    public static void ResourceManager_patchPalette(byte[] byArray, int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = nArray.length;
        int n4 = n2 / 3;
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] == 0xFF00FF) continue;
            int n5 = nArray[i];
            int n6 = (n5 & 0xFF0000) >> 16;
            int n7 = (n5 & 0xFF00) >> 8;
            int n8 = (n5 & 0xFF) >> 0;
            int n9 = nArray2[i];
            int n10 = (n9 & 0xFF0000) >> 16;
            int n11 = (n9 & 0xFF00) >> 8;
            int n12 = (n9 & 0xFF) >> 0;
            int n13 = n;
            for (int j = 0; j < n4; ++j) {
                int n14 = byArray[n13 + 0] & 0xFF;
                int n15 = byArray[n13 + 1] & 0xFF;
                int n16 = byArray[n13 + 2] & 0xFF;
                if (n14 == n6 && n15 == n7 && n16 == n8) {
                    byArray[n13 + 0] = (byte)(n10 & 0xFF);
                    byArray[n13 + 1] = (byte)(n11 & 0xFF);
                    byArray[n13 + 2] = (byte)(n12 & 0xFF);
                }
                n13 += 3;
            }
        }
    }

    public static SDKImage ResourceManager_loadImage(int n, int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        byte[] byArray = GameConstants.PMFile_fileToByteArray(Intro.ResourceConstants_RESOURCE_FILENAMES_LIST[n]);
        if ((0xFF & byArray[0]) != 137 || (0xFF & byArray[1]) != 80 || (0xFF & byArray[2]) != 78 || (0xFF & byArray[3]) != 71 || (0xFF & byArray[4]) != 13 || (0xFF & byArray[5]) != 10 || (0xFF & byArray[6]) != 26 || (0xFF & byArray[7]) != 10) {
            return null;
        }
        int n4 = (byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
        int n5 = (byArray[12] & 0xFF) << 24 | (byArray[13] & 0xFF) << 16 | (byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF;
        int n6 = 0;
        int n7 = 0;
        if (n4 > 0 && n5 == 1229472850) {
            n6 = byArray[24];
            n7 = byArray[25];
        }
        if (n6 != 4 && n6 != 8 || n7 != 3) {
            return null;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 8;
        int n11 = byArray.length;
        do {
            n3 = (byArray[n10 + 0] & 0xFF) << 24 | (byArray[n10 + 1] & 0xFF) << 16 | (byArray[n10 + 2] & 0xFF) << 8 | byArray[n10 + 3] & 0xFF;
            n2 = (byArray[n10 + 4] & 0xFF) << 24 | (byArray[n10 + 5] & 0xFF) << 16 | (byArray[n10 + 6] & 0xFF) << 8 | byArray[n10 + 7] & 0xFF;
            if (n2 != 1347179589) continue;
            n8 = n10;
            n9 = n3;
            break;
        } while ((n10 += 12 + n3) < n11);
        Cursor.ResourceManager_patchPalette(byArray, n8 + 8, n9, nArray, nArray2);
        if (n8 > 0) {
            n3 = Cursor.ResourceManager_calcCRC32(byArray, n8 + 4, n9 + 4);
            n2 = n8 + n9 + 8;
            byArray[n2] = (byte)((n3 & 0xFF000000) >>> 24);
            byArray[n2 + 1] = (byte)((n3 & 0xFF0000) >>> 16);
            byArray[n2 + 2] = (byte)((n3 & 0xFF00) >>> 8);
            byArray[n2 + 3] = (byte)(n3 & 0xFF);
        }
        try {
            SDKImage sDKImage = SDKUtils.createImage(byArray, 0, n11);
            byArray = null;
            if (sDKImage != null) {
                return sDKImage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        byArray = null;
        return null;
    }

    public static boolean MinigameArt_testSolution(int n) {
        int n2;
        int n3 = MinigameArt_sequence[n];
        if (n == 0) {
            return true;
        }
        if (n3 % 3 != 0 && MinigameArt_solution[n3] == MinigameArt_solution[n2 = n3 - 1]) {
            return false;
        }
        if (n3 / 3 > 0 && MinigameArt_solution[n3] == MinigameArt_solution[n2 = n3 - 3]) {
            return false;
        }
        if ((n3 + 1) % 3 != 0 && ((n2 = n3 + 1) >= MinigameArt_solution.length || MinigameArt_solution[n3] == MinigameArt_solution[n2])) {
            return false;
        }
        return n3 / 3 >= 2 || MinigameArt_solution[n3] != MinigameArt_solution[n2 = n3 + 3];
    }

    public static void MinigameArt_init() {
        int n;
        MinigameArt_bgGradientColors = new int[]{4871748, 4674370, 4542784, 4476990, 0x434E3E, 4345405, 4279356, 4147770, 4016184, 3950134, 3818550};
        MinigameArt_cursorAP = new AnimPlayer();
        MinigameArt_cursorAP.startAnim(299, 4);
        MinigameArt_skill = Main.m_simData.getSkillRank(GameConstants.Minigame_gameSkill);
        GameConstants.Minigame_gameTimer = GameConstants.Minigame_gameTimerMax = MinigameArt_TIME_PAINT[MinigameArt_skill];
        MinigameArt_guess = new int[9];
        MinigameArt_guessSequence = new int[MinigameArt_NUM_SPLATS[MinigameArt_skill]];
        MinigameArt_guessSequenceIndex = 0;
        ArrayHandler.fillArray(MinigameArt_guess, -1);
        ArrayHandler.fillArray(MinigameArt_guessSequence, -1);
        MinigameArt_solution = new int[9];
        MinigameArt_sequence = new int[MinigameArt_NUM_SPLATS[MinigameArt_skill]];
        ArrayHandler.fillArray(MinigameArt_solution, -1);
        int n2 = 0;
        do {
            int n3;
            if (!MinigameArt_ALLOWED_FIELDS[MinigameArt_skill][n3 = Debug.PMRandom_get() % 9] || MinigameArt_solution[n3] != -1) continue;
            Cursor.MinigameArt_solution[n3] = Debug.PMRandom_get() % 6;
            Cursor.MinigameArt_sequence[n2] = n3;
            if (Cursor.MinigameArt_testSolution(n2)) {
                ++n2;
                continue;
            }
            GlobalConstants.PMDebug_println("Skipping solution @ " + n2);
            Cursor.MinigameArt_solution[n3] = -1;
        } while (n2 < MinigameArt_NUM_SPLATS[MinigameArt_skill]);
        MinigameArt_canvasRect = new int[4];
        AnimationManager.getAnimFrameCollisionBox(MinigameArt_canvasRect, 301, 0, 0);
        MinigameArt_cursorPositionsX = new int[9];
        MinigameArt_cursorPositionsY = new int[9];
        for (n = 0; n < 9; ++n) {
            AnimationManager.getAnimFrameFirePoint(StateInGame.m_tempInt10, 301, 0, n);
            Cursor.MinigameArt_cursorPositionsX[n] = StateInGame.m_tempInt10[0];
            Cursor.MinigameArt_cursorPositionsY[n] = StateInGame.m_tempInt10[1];
        }
        AnimationManager.getAnimFrameFirePoint(StateInGame.m_tempInt10, 301, 0, n);
        MinigameArt_palettePosX = StateInGame.m_tempInt10[0];
        MinigameArt_palettePosY = StateInGame.m_tempInt10[1];
        AnimationManager.getAnimFrameFirePoint(StateInGame.m_tempInt10, 301, 0, ++n);
        MinigameArt_stringTopPosX = StateInGame.m_tempInt10[0];
        MinigameArt_stringTopPosY = StateInGame.m_tempInt10[1];
        AnimationManager.getAnimFrameFirePoint(StateInGame.m_tempInt10, 301, 0, ++n);
        MinigameArt_stringBottomPosX = StateInGame.m_tempInt10[0];
        MinigameArt_stringBottomPosY = StateInGame.m_tempInt10[1];
        MinigameArt_paletteColorPosX = new int[6];
        MinigameArt_paletteColorPosY = new int[6];
        for (n = 0; n < 6; ++n) {
            AnimationManager.getAnimFrameFirePoint(StateInGame.m_tempInt10, 303, 0, n);
            Cursor.MinigameArt_paletteColorPosX[n] = StateInGame.m_tempInt10[0];
            Cursor.MinigameArt_paletteColorPosY[n] = StateInGame.m_tempInt10[1];
        }
        MinigameArt_artComplete = false;
        Cursor.MinigameArt_changeState(0);
    }

    public static void MinigameArt_deinit() {
        MinigameArt_bgGradientColors = null;
        MinigameArt_stringTopWrap = null;
        MinigameArt_stringBottomWrap = null;
        MinigameArt_cursorPosPrevColorIndex = 0;
        MinigameArt_cursorAP = null;
        ArrayOptimizer.PMGraphics_setClip(0, 0, 240, 260);
    }

    public static void MinigameArt_cursorPosSetTarget() {
        MinigameArt_cursorPosXfPrev = MinigameArt_cursorPosXf;
        MinigameArt_cursorPosYfPrev = MinigameArt_cursorPosYf;
        if (MinigameArt_currentState == 2) {
            MinigameArt_cursorPosXfTarget = 120 + MinigameArt_palettePosX + MinigameArt_paletteColorPosX[MinigameArt_cursorPos] << 16;
            MinigameArt_cursorPosYfTarget = 130 + MinigameArt_palettePosY + MinigameArt_paletteColorPosY[MinigameArt_cursorPos] << 16;
        } else if (MinigameArt_currentState == 3) {
            MinigameArt_cursorPosXfTarget = 120 + MinigameArt_cursorPositionsX[MinigameArt_cursorPos] << 16;
            MinigameArt_cursorPosYfTarget = 130 + MinigameArt_cursorPositionsY[MinigameArt_cursorPos] << 16;
        }
        MinigameArt_currentStateTime = 0;
    }

    public static void MinigameArt_cursorPosUpdate() {
        int n = 0;
        int n2 = 250;
        if (MinigameArt_currentState == 3) {
            n2 = 500;
        }
        if (MinigameArt_addMoreTimeToBrushMovement) {
            n2 *= 3;
        }
        if (MinigameArt_currentStateTime <= n2) {
            n = Camera.MathExt_Fdiv(MinigameArt_currentStateTime, n2);
        } else {
            n = 65536;
            MinigameArt_addMoreTimeToBrushMovement = false;
        }
        MinigameArt_cursorPosXf = MinigameArt_cursorPosXfTarget < MinigameArt_cursorPosXfPrev ? GameConstants.Path_calc(MinigameArt_cursorPosXfTarget, MinigameArt_cursorPosXfPrev, 65536 - n, 1) : GameConstants.Path_calc(MinigameArt_cursorPosXfPrev, MinigameArt_cursorPosXfTarget, n, 1);
        MinigameArt_cursorPosYf = MinigameArt_cursorPosYfTarget < MinigameArt_cursorPosYfPrev ? GameConstants.Path_calc(MinigameArt_cursorPosYfTarget, MinigameArt_cursorPosYfPrev, 65536 - n, 1) : GameConstants.Path_calc(MinigameArt_cursorPosYfPrev, MinigameArt_cursorPosYfTarget, n, 1);
    }

    public static void MinigameArt_update(int n) {
        MinigameArt_currentStateTime += n;
        if (GameConstants.Minigame_gameTimer <= 0) {
            if (GameConstants.Minigame_endTimer == 4000) {
                GameConstants.Minigame_endTimer = 500;
            }
            if ((GameConstants.Minigame_endTimer -= n) <= 0 && !GameConstants.Minigame_done) {
                GameConstants.Minigame_done = true;
                GameConstants.Minigame_stateTransitionMiniGame(2);
                return;
            }
        }
        if (MinigameArt_currentState == 0) {
            if ((MinigameArt_currentSplatShownTimer -= n) <= 0) {
                if (MinigameArt_numSplatsToShow <= MinigameArt_NUM_SPLATS[MinigameArt_skill]) {
                    ++MinigameArt_numSplatsToShow;
                    MinigameArt_currentSplatShownTimer = 2500;
                } else {
                    Cursor.MinigameArt_changeState(1);
                }
            }
            return;
        }
        if (MinigameArt_currentState == 1) {
            GameConstants.Minigame_gameTimer -= n;
            GlobalConstants.Particle_update(n);
            if ((MinigameArt_blinkTimer -= n) <= 0) {
                MinigameArt_blinkTimer = 500;
                MinigameArt_blinkShowString = !MinigameArt_blinkShowString;
            }
            return;
        }
        if (MinigameArt_artComplete && MinigameArt_cursorAP.getAnimID() == 299) {
            if (GameConstants.Minigame_endTimer == 4000) {
                GameConstants.Minigame_endTimer = PMAudio.isEnabled ? 3000 : 500;
            }
            GameConstants.Minigame_endTimer -= n;
            GlobalConstants.Particle_update(n);
            if (!GameConstants.Minigame_done) {
                PMAudio.play(11, 1);
                GameConstants.Minigame_done = true;
                Main.setSoftKeys(1, 0);
            }
            if (GameConstants.Minigame_endTimer <= 0) {
                GameConstants.Minigame_stateTransitionMiniGame(1);
            }
        } else if (GameConstants.Minigame_gameTimer > 0) {
            Cursor.MinigameArt_cursorPosUpdate();
            if (MinigameArt_cursorAP.getAnimID() == 300) {
                MinigameArt_cursorAP.updateAnim(n);
                if (MinigameArt_cursorAP.isAnimating()) {
                    if (MinigameArt_cursorAP.getCurrAnimFrame() == 2) {
                        Cursor.MinigameArt_guessSequence[Cursor.MinigameArt_guessSequenceIndex] = MinigameArt_cursorPos;
                        Cursor.MinigameArt_guess[Cursor.MinigameArt_cursorPos] = MinigameArt_guessColor;
                    }
                } else {
                    MinigameArt_cursorAP.startAnim(299, 4);
                    if (Cursor.MinigameArt_testGuess()) {
                        ++MinigameArt_guessSequenceIndex;
                        Cursor.MinigameArt_changeState(2);
                    } else {
                        Cursor.MinigameArt_changeState(4);
                    }
                }
            } else if (MinigameArt_currentState != 4) {
                GameConstants.Minigame_gameTimer -= n;
                GlobalConstants.Particle_update(n);
            }
            if (MinigameArt_currentState == 4) {
                MinigameArt_errorShakeOffsetX = Debug.PMRandom_get() % (MinigameArt_ERROR_SHAKE_OFFSET_MAX << 1) - MinigameArt_ERROR_SHAKE_OFFSET_MAX;
                MinigameArt_errorShakeOffsetY = Debug.PMRandom_get() % (MinigameArt_ERROR_SHAKE_OFFSET_MAX << 1) - MinigameArt_ERROR_SHAKE_OFFSET_MAX;
                if ((MinigameArt_errorShakeCounter -= n) <= 0) {
                    ArrayHandler.fillArray(MinigameArt_guess, -1);
                    ArrayHandler.fillArray(MinigameArt_guessSequence, -1);
                    MinigameArt_guessSequenceIndex = 0;
                    Cursor.MinigameArt_changeState(2);
                }
            }
        }
    }

    public static void MinigameArt_render() {
        Intro.StateMenu_drawVerticalGradient(true, MinigameArt_bgGradientColors, 0, GameConstants.Minigame_top, 240, GameConstants.Minigame_height);
        int n = 120;
        int n2 = 130;
        if (MinigameArt_currentState == 4) {
            n += MinigameArt_errorShakeOffsetX;
            n2 += MinigameArt_errorShakeOffsetY;
        }
        AnimationManager.drawAnimFrame(301, 0, n, n2);
        int[] nArray = new int[]{ArrayOptimizer.PMGraphics_getClipX(), ArrayOptimizer.PMGraphics_getClipY(), ArrayOptimizer.PMGraphics_getClipWidth(), ArrayOptimizer.PMGraphics_getClipHeight()};
        ArrayOptimizer.PMGraphics_setClip(n + MinigameArt_canvasRect[0], n2 + MinigameArt_canvasRect[1], MinigameArt_canvasRect[2], MinigameArt_canvasRect[3]);
        boolean bl = false;
        boolean bl2 = false;
        switch (MinigameArt_currentState) {
            default: {
                break;
            }
            case 0: {
                bl = true;
                bl2 = true;
                int n3 = Math.min(MinigameArt_numSplatsToShow, MinigameArt_sequence.length);
                for (int i = 0; i < n3; ++i) {
                    int n4 = MinigameArt_sequence[i];
                    AnimationManager.drawAnimFrame(302, MinigameArt_solution[n4], n + MinigameArt_cursorPositionsX[n4], n2 + MinigameArt_cursorPositionsY[n4]);
                }
                ArrayOptimizer.PMGraphics_setClip(nArray[0], nArray[1], nArray[2], nArray[3]);
                break;
            }
            case 1: {
                bl = true;
                bl2 = MinigameArt_blinkShowString;
                for (int i = 0; i < MinigameArt_sequence.length; ++i) {
                    int n5 = MinigameArt_sequence[i];
                    AnimationManager.drawAnimFrame(302, MinigameArt_solution[n5], n + MinigameArt_cursorPositionsX[n5], n2 + MinigameArt_cursorPositionsY[n5]);
                }
                ArrayOptimizer.PMGraphics_setClip(nArray[0], nArray[1], nArray[2], nArray[3]);
                break;
            }
            case 2: 
            case 3: {
                bl = true;
                for (int i = 0; i < MinigameArt_guessSequence.length; ++i) {
                    if (MinigameArt_guessSequence[i] == -1) continue;
                    int n6 = MinigameArt_guessSequence[i];
                    AnimationManager.drawAnimFrame(302, MinigameArt_guess[n6], n + MinigameArt_cursorPositionsX[n6], n2 + MinigameArt_cursorPositionsY[n6]);
                }
                ArrayOptimizer.PMGraphics_setClip(nArray[0], nArray[1], nArray[2], nArray[3]);
                AnimationManager.drawAnimFrame(303, 0, n + MinigameArt_palettePosX, n2 + MinigameArt_palettePosY);
                if (MinigameArt_artComplete) break;
                if (MinigameArt_currentState == 2 && MinigameArt_cursorAP.getAnimID() == 299) {
                    MinigameArt_cursorAP.setFrame(MinigameArt_cursorPos);
                }
                MinigameArt_cursorAP.drawAnim(MinigameArt_cursorPosXf >> 16, MinigameArt_cursorPosYf >> 16);
                break;
            }
            case 4: {
                ArrayOptimizer.PMGraphics_setClip(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
        }
        Event.Ea_setSDKFont(AnimationManager.TextHandler_fonts[0]);
        if (bl) {
            Event.Ea_drawWrappedSDKString(MinigameArt_stringTop, MinigameArt_stringTopWrap, 1, MinigameArt_stringTopWrap[0], n + MinigameArt_stringTopPosX, n2 + MinigameArt_stringTopPosY, 33);
        }
        if (bl2) {
            Event.Ea_drawWrappedSDKString(MinigameArt_stringBottom, MinigameArt_stringBottomWrap, 1, MinigameArt_stringBottomWrap[0], n + MinigameArt_stringBottomPosX, n2 + MinigameArt_stringBottomPosY, 17);
        }
    }

    public static void MinigameArt_processKeys() {
        boolean bl = false;
        switch (MinigameArt_currentState) {
            default: {
                break;
            }
            case 1: {
                if (!ArrayHandler.PMInput_isPressed(1)) break;
                Cursor.MinigameArt_changeState(2);
                break;
            }
            case 2: {
                if (ArrayHandler.PMInput_isPressed(1)) {
                    Cursor.MinigameArt_changeState(3);
                    bl = true;
                    break;
                }
                if (ArrayHandler.PMInput_isPressed(32)) {
                    MinigameArt_cursorPos = Math.max(0, MinigameArt_cursorPos - 1);
                    bl = true;
                    break;
                }
                if (!ArrayHandler.PMInput_isPressed(64)) break;
                MinigameArt_cursorPos = Math.min(5, MinigameArt_cursorPos + 1);
                bl = true;
                break;
            }
            case 3: {
                if (MinigameArt_cursorAP.getAnimID() != 300) {
                    if (ArrayHandler.PMInput_isPressed(1) && Cursor.MinigameArt_currentPositionIsFree()) {
                        MinigameArt_cursorAP.startAnim(300, 0);
                    } else if (ArrayHandler.PMInput_isPressed(32)) {
                        MinigameArt_cursorPos -= 3;
                        bl = true;
                    } else if (ArrayHandler.PMInput_isPressed(64)) {
                        MinigameArt_cursorPos += 3;
                        bl = true;
                    } else if (ArrayHandler.PMInput_isPressed(8)) {
                        MinigameArt_cursorPos = MinigameArt_cursorPos % 3 == 0 ? (MinigameArt_cursorPos += 2) : --MinigameArt_cursorPos;
                        bl = true;
                    } else if (ArrayHandler.PMInput_isPressed(16)) {
                        MinigameArt_cursorPos = (MinigameArt_cursorPos + 1) % 3 == 0 ? (MinigameArt_cursorPos -= 2) : ++MinigameArt_cursorPos;
                        bl = true;
                    } else if (ArrayHandler.PMInput_isPressed(2)) {
                        Cursor.MinigameArt_changeState(2);
                        MinigameArt_addMoreTimeToBrushMovement = true;
                    }
                }
                if (MinigameArt_cursorPos >= 9) {
                    MinigameArt_cursorPos -= 9;
                    break;
                }
                if (MinigameArt_cursorPos >= 0) break;
                MinigameArt_cursorPos += 9;
            }
        }
        if (bl) {
            Cursor.MinigameArt_cursorPosSetTarget();
        }
    }

    public static void MinigameArt_changeState(int n) {
        switch (n) {
            case 0: {
                MinigameArt_currentSplatShownTimer = 1250;
                MinigameArt_numSplatsToShow = 0;
                MinigameArt_stringTop = Event.Ea_getString(1077);
                MinigameArt_stringBottom = Event.Ea_getString(1078);
                break;
            }
            case 1: {
                MinigameArt_blinkShowString = true;
                MinigameArt_blinkTimer = 500;
                MinigameArt_stringTop = Event.Ea_getString(1077);
                MinigameArt_stringBottom = Event.Ea_getString(644);
                break;
            }
            case 2: {
                MinigameArt_cursorPos = MinigameArt_cursorPosPrevColorIndex;
                MinigameArt_stringTop = Event.Ea_getString(1079);
                MinigameArt_stringBottom = null;
                break;
            }
            case 3: {
                MinigameArt_cursorPosPrevColorIndex = MinigameArt_cursorPos;
                MinigameArt_guessColor = MinigameArt_cursorPos;
                MinigameArt_cursorPos = 4;
                MinigameArt_stringTop = Event.Ea_getString(1079);
                MinigameArt_stringBottom = null;
                break;
            }
            case 4: {
                MinigameArt_errorShakeCounter = 500;
                MinigameArt_stringTop = Event.Ea_getString(1079);
                MinigameArt_stringBottom = null;
            }
        }
        Event.Ea_setSDKFont(AnimationManager.TextHandler_fonts[0]);
        MinigameArt_stringTopWrap = null;
        MinigameArt_stringBottomWrap = null;
        if (MinigameArt_stringTop != null && !MinigameArt_stringTop.equals(null)) {
            MinigameArt_stringTopWrap = Event.Ea_wrapSDKString(MinigameArt_stringTop, MinigameArt_stringTopWrap, 228, (short)124);
        }
        if (MinigameArt_stringBottom != null && !MinigameArt_stringBottom.equals(null)) {
            MinigameArt_stringBottomWrap = Event.Ea_wrapSDKString(MinigameArt_stringBottom, MinigameArt_stringBottomWrap, 228, (short)124);
        }
        MinigameArt_currentState = n;
        Cursor.MinigameArt_cursorPosSetTarget();
    }

    public static boolean MinigameArt_testGuess() {
        MinigameArt_artComplete = true;
        for (int i = 0; i < MinigameArt_guessSequence.length; ++i) {
            if (MinigameArt_guessSequence[i] == -1) {
                MinigameArt_artComplete = false;
                continue;
            }
            if (MinigameArt_guessSequence[i] == MinigameArt_sequence[i] && MinigameArt_guess[MinigameArt_guessSequence[i]] == MinigameArt_solution[MinigameArt_sequence[i]]) continue;
            MinigameArt_artComplete = false;
            return false;
        }
        return true;
    }

    public static boolean MinigameArt_currentPositionIsFree() {
        return MinigameArt_guess[MinigameArt_cursorPos] == -1;
    }

    public static void PMStorage_save(byte[] byArray, int n) {
        SDKUtils.saveRecord(n, byArray);
    }

    public static byte[] PMStorage_load(int n) {
        return SDKUtils.loadRecord(n);
    }

    static {
        hide = false;
        MinigameArt_TIME_PAINT = new int[]{45000, 45000, 40000, 35000, 35000, 30000};
        MinigameArt_ALLOWED_FIELDS = new boolean[][]{{false, false, false, true, true, true, false, false, false}, {false, false, false, true, true, true, false, false, false}, {true, true, true, true, true, true, false, false, false}, {true, true, true, true, true, true, false, false, false}, {true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true}};
        MinigameArt_NUM_SPLATS = new byte[]{2, 3, 3, 3, 4, 5};
        MinigameArt_cursorPosXf = 0xF00000;
        MinigameArt_cursorPosYf = 0x1040000;
        MinigameArt_cursorPosXfPrev = 0xF00000;
        MinigameArt_cursorPosYfPrev = 0x1040000;
        MinigameArt_cursorPosXfTarget = 0xF00000;
        MinigameArt_cursorPosYfTarget = 0x1040000;
        MinigameArt_ERROR_SHAKE_OFFSET_MAX = 5;
        SimsHousesConstants_HOUSES_SYMBOL_LOOKUPS = new short[]{100, 0, 2, 2, 3, 1, 48, 64, 61, 47, 60, 4, 65, 53, 16, 41, 56, 15, 57, 63, 50, 13, 3, 10, 12, 14, 11, 59, 52, 66, 17, 25, 21, 29, 37, 38, 39, 40, 49, 1, 2, 3, 2, 0, 0, 1, 101, 62, 58, 102, 103, 104, 105, 106, 107, 108, 109, 110};
        PMStorage_defaultId = 0;
    }
}

