/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.state;

import com.ea.sdk.SDKString;
import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Camera;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.SimData;
import java.util.Stack;

public class StateInGame {
    public static boolean firstMapEventHasBeenTriggered;
    public static boolean passedOut;
    public static int numShowers;
    public static int numTimesPassedOut;
    public static int[] m_tempInt10;
    public static int m_state;
    public static int m_stateTime;
    public static int m_afterFadeState;
    public static int m_nextScene;
    public static int m_nextSceneState;
    public static int m_initialState;
    public static byte m_mapMode;
    public static byte m_mapModePrev;
    public static int relationshipBarY;
    public static int relationshipArrowTimer;
    public static boolean m_debugHideObjects;
    public static boolean m_debugFastforward;
    public static boolean m_suppressMenus;
    public static int m_hudBottomHeight;
    public static int m_viewportX;
    public static int m_viewportY;
    public static int m_viewportWidth;
    public static int m_viewportHeight;
    public static short m_maxContextMenuItems;
    public static int m_loadingState;
    public static int m_nextSimBank;
    public static int m_loadSimId;
    public static int[] m_palSources;
    public static int[] m_palPatches;
    public static byte m_loadSimCount;
    public static byte[] m_loadedSims;
    public static boolean m_tutorialMessageActive;
    public static byte m_tutorialMessageShowing;
    public static int tutMsgStringBody;
    public static int tutMsgStringTitle;
    public static int m_normalTimeStep;
    public static boolean first;
    public static AnimPlayer m_timeAnimPlayer;
    public static AnimPlayer m_buffRisingAnimPlayer;
    public static AnimPlayer m_buffDroppingAnimPlayer;
    public static int m_displayedMoney;
    public static int m_postMessageBox;
    public static int lastMessageFun;
    public static int numMessagesRead;
    public static int m_curtainState;
    public static int m_curtainPlayerAction;
    public static int m_curtainTime;
    public static short m_tickerString1;
    public static short m_tickerString2;
    public static int m_tickerTimer;
    public static int m_tickerOffsetF;
    public static int m_tickerLengthF;
    public static short contextMenuPreviousAction;
    public static boolean contextMenuIsTainted;
    public static boolean m_keyCameraLeft;
    public static boolean m_keyCameraRight;
    public static boolean m_keyCameraDown;
    public static boolean m_keyCameraUp;
    public static int m_cameraDestX;
    public static int m_cameraDestZ;
    public static int m_cameraVelX;
    public static int m_cameraVelZ;
    public static int m_cameraLastVelX;
    public static int m_cameraLastVelZ;
    public static boolean m_cameraAtDest;
    public static MapObject m_cameraFollowTarget;
    public static boolean m_cameraFollowTargetReturn;
    public static MapObject[] m_objects;
    public static MapObjectSim[] m_objectsSims;
    public static MapObjectSim m_playerSim;
    public static Stack m_objectStack;
    public static boolean m_refreshObjects;
    public static boolean m_refreshObjectsSims;
    public static boolean m_contextMenuActive;
    public static boolean m_contextMenuOnSubMenu;
    public static short m_contextMenuBackCursor;
    public static short[] m_contextMenuItems;
    public static short[] m_contextMenuActions;
    public static short[] m_contextMenuFullActions;
    public static MapObject m_contextMenuObject;
    public static boolean m_pauseMenuActive;
    public static short[] m_pauseMenuItems;
    public static int m_pauseMenuState;
    public static boolean m_shortcutMenuActive;
    public static boolean m_shortcutByShortcutKey;
    public static short[] m_shortcutMenuItems;
    public static boolean m_quickLinksActive;
    public static short[] m_quickLinksMenu;
    public static int camOffsetZ;
    public static int m_buyModeState;
    public static int m_buyNewType;
    public static MapObject m_buyModeObject;
    public static int amountSpentOnFurniture;
    public static int m_infoScreenState;
    public static int m_infoLoadedNPC;
    public static int m_infoScreenSimSelectedIndex;
    public static int m_npcLongestStringLength;
    public static int m_skillLongestStringLength;
    public static int relationshipListItemSize;
    public static int relationshipListItemSizeHalf;
    public static int statusListItemHeight;
    public static int m_infoScreenRecipeSelected;
    public static int m_infoScreenItemSelectedIndex;
    public static int m_jobOfferCareer;
    public static int m_jobOfferLevel;
    public static int m_payIncome;
    public static boolean m_quitJobConfirmed;
    public static boolean m_showEndOfGameScreen;
    public static boolean m_showNewDream;
    public static AnimPlayer[] m_dreamAnimPlayers;
    public static int m_showGetItem;
    public static int m_showGetItemQty;
    public static int m_showGetItemTitle;
    public static int m_showGetItemMessage;
    public static int m_simAIEventTimer;
    public static int m_simInactivityTimer;
    public static int lastVisitorTime;
    public static int currentVisitorChance;
    public static int m_actionQueueSize;
    public static int[] m_actionQueueActions;
    public static MapObject[] m_actionQueueArg1s;
    public static int[] m_actionQueueArg2s;
    public static int[] m_actionQueueArg3s;
    public static int m_displayedMoodLevel;
    public static int m_timeHit;
    public static AnimPlayer m_playerGemAnimPlayer;
    public static int m_questId;
    public static int m_questSimId;
    public static int m_questState;
    public static int m_chanceCardOutcome;
    public static boolean m_showFetchQuestEnd;
    public static int numItemsSoldArt;
    public static int numItemsSoldFashion;
    public static int numItemsSoldMusic;
    public static int numItemsSoldSport;
    public static int amountSpentOnHobbyRoom;
    public static boolean showConsumablesTutorial;
    public static int m_shoppingObjectType;
    public static int m_shoppingFlagLatest;
    public static int m_shoppingTradeAmount;
    public static final int[] HOBBYROOM_ITEMS;
    public static long timeStamp;
    public static int timeInterval;
    public static boolean m_isCursorOnMove;
    public static int cursorScrollX;
    public static int cursorScrollZ;

    public static boolean isHouseMode() {
        return m_mapMode == 0;
    }

    public static boolean isMapMode() {
        return m_mapMode == 2;
    }

    public static boolean isZoomMapMode() {
        return m_mapMode == 1;
    }

    public static void updateLoading(int n) {
        Intro.LoadingScreen_update(n);
        StateInGame.updateLoadingState();
    }

    public static void updateLoadingState() {
        switch (m_loadingState) {
            default: {
                break;
            }
            case 0: {
                ++m_loadingState;
                break;
            }
            case 1: {
                Main.m_simWorld.setViewport(m_viewportX, m_viewportY, m_viewportWidth, m_viewportHeight);
                m_refreshObjects = true;
                m_refreshObjectsSims = true;
                boolean bl = true;
                if (m_mapMode == 2) {
                    StateInGame.initMacroMap();
                } else if (m_mapMode == 1) {
                    StateInGame.initZoomMap();
                    if (StateInGame.getSimObjects().length > 1) {
                        bl = false;
                    }
                } else {
                    StateInGame.initHouseMap();
                }
                if (bl) {
                    MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
                    int n = mapObjectSim.getPosX();
                    int n2 = mapObjectSim.getPosZ();
                    Cursor.m_cursorDestX = Main.m_simWorld.coordWorldToScreenX(n, n2);
                    Cursor.m_cursorDestZ = Main.m_simWorld.coordWorldToScreenY(n, n2);
                }
                Cursor.m_cursorPosX = Cursor.m_cursorDestX;
                Cursor.m_cursorPosZ = Cursor.m_cursorDestZ;
                StateInGame.clearCameraFollow();
                StateInGame.snapCameraPosition();
                ++m_loadingState;
                Main.loadImagesBegin();
                break;
            }
            case 2: {
                int n = 8;
                switch (m_mapMode) {
                    default: {
                        Debug.ASSERT(false, "invalid map mode");
                    }
                    case 2: {
                        n |= 0x20;
                        AnimationManager.loadImage(33);
                        break;
                    }
                    case 0: {
                        n |= 0x10;
                        AnimationManager.loadImage(23);
                        break;
                    }
                    case 1: {
                        if (Main.m_nextZoomMapId == 79) {
                            n |= 0x2000;
                        }
                        if (Main.m_nextZoomMapId == 80) {
                            n |= 0x4000;
                        }
                        if (Main.m_nextZoomMapId == 81) {
                            n |= 0x8000;
                        }
                        if (Main.m_nextZoomMapId == 82) {
                            n |= 0x10000;
                        }
                        if (Main.m_nextZoomMapId != 84) break;
                        n |= 0x1000;
                    }
                }
                if (!Main.loadImagesNext(n)) break;
                ++m_loadingState;
                break;
            }
            case 3: {
                if (StateInGame.isMapMode()) {
                    int[] nArray = Main.m_simWorld.getPatch(0);
                    int n = 0;
                    int[] nArray2 = Main.m_simWorld.getPatch(1);
                    AnimationManager.loadImage(34, nArray, nArray2, n);
                    AnimationManager.loadImage(31, nArray, nArray2, n);
                    nArray2 = Main.m_simWorld.getPatch(2);
                    AnimationManager.loadImage(34, nArray, nArray2, ++n);
                    AnimationManager.loadImage(31, nArray, nArray2, n);
                    nArray2 = Main.m_simWorld.getPatch(3);
                    AnimationManager.loadImage(34, nArray, nArray2, ++n);
                    AnimationManager.loadImage(31, nArray, nArray2, n);
                    nArray2 = Main.m_simWorld.getPatch(4);
                    AnimationManager.loadImage(34, nArray, nArray2, ++n);
                    AnimationManager.loadImage(31, nArray, nArray2, n);
                    StateInGame.loadPlayerSim();
                    ++m_loadingState;
                    break;
                }
                StateInGame.loadNewSimBegin();
                while (m_loadSimCount > 0) {
                    StateInGame.updateLoadSim();
                }
                ++m_loadingState;
                break;
            }
            case 4: {
                StateInGame.stateTransition(m_initialState);
                if (StateInGame.isMapMode()) {
                    StateInGame.showTutorialMessage((byte)2, 925, 926);
                    PMAudio.play(7, 1);
                } else if (StateInGame.isHouseMode()) {
                    if (Main.getNextHouseId() == 0) {
                        currentVisitorChance = 5;
                        if (lastVisitorTime == 0) {
                            lastVisitorTime = Main.m_simData.getGameTimeAbs() - 48 * 60;
                        }
                        StateInGame.showTutorialMessage((byte)0, 922, 924);
                    }
                } else if (StateInGame.isZoomMapMode()) {
                    firstMapEventHasBeenTriggered = false;
                }
                Event.PostEffects_startFadeIn();
            }
        }
    }

    public static void initSimAssets() {
        GlobalConstants.PMDebug_println("initSimAssets start");
        m_nextSimBank = 0;
        m_loadSimId = 0;
        m_loadSimCount = 0;
        if (!StateInGame.isMapMode()) {
            if (m_loadedSims == null) {
                m_loadedSims = new byte[6];
            }
            ArrayHandler.fillArray(m_loadedSims, -1);
        }
        GlobalConstants.PMDebug_println("initSimAssets end");
    }

    public static void loadNewSim(MapObjectSim mapObjectSim) {
        if (!StateInGame.isMapMode()) {
            Debug.ASSERT(m_loadSimId == -1 || m_state == 1, "trying to load too many sims mid-frame");
            if (m_loadSimId != -1 && m_state != 1) {
                return;
            }
            m_loadSimCount = (byte)(m_loadSimCount + 1);
            int n = StateInGame.nextAvailableBank();
            Debug.ASSERT(n != -1, "no banks available to load sim");
            if (n != -1) {
                StateInGame.m_loadedSims[n] = (byte)mapObjectSim.getId();
            }
        }
    }

    public static void loadNewSimBegin() {
        for (int i = 0; i < 6; ++i) {
            MapObjectSim mapObjectSim;
            int n = m_loadedSims[i];
            if (n == -1 || (mapObjectSim = StateInGame.findSim(n)).getBank() != -1) continue;
            GlobalConstants.PMDebug_println(2, "loadNewSimBegin: simId = {0}, bank = {1}", n, i);
            m_nextSimBank = i;
            m_loadSimId = n;
            Main.m_simWorld.getSimPatches(n, m_palSources, m_palPatches);
            Main.loadImagesBegin();
            return;
        }
        Debug.ASSERT(false, "shouldn't get to here");
    }

    public static int nextAvailableBank() {
        return ArrayHandler.indexOf(-1, m_loadedSims);
    }

    public static void renderLoadSim() {
    }

    public static void updateLoadSim() {
        if (m_loadSimId == -1) {
            m_loadSimCount = (byte)(m_loadSimCount - 1);
            return;
        }
        int n = m_nextSimBank;
        int n2 = m_loadSimId;
        int n3 = Main.m_simData.getSimAttribute(n2, 0) == 0 ? 256 : 128;
        Event.PMSystem_forceGC();
        if (Main.loadImagesNext(n3, m_palSources, m_palPatches, n)) {
            int n4 = StateInGame.getSimHairImage(n2);
            AnimationManager.loadImage(n4, m_palSources, m_palPatches, n);
            MapObjectSim mapObjectSim = StateInGame.findSim(n2);
            mapObjectSim.setBank(n);
            m_loadSimId = -1;
            m_nextSimBank = n + 1;
            m_loadSimCount = (byte)(m_loadSimCount - 1);
            if (n2 == 0) {
                StateInGame.loadPlayerSim();
            }
            GlobalConstants.PMDebug_println("finished loading sim");
            if (m_loadSimCount > 0) {
                GlobalConstants.PMDebug_println("loading next sim");
                StateInGame.loadNewSimBegin();
            }
        }
    }

    public static void loadPlayerSim() {
        Main.m_simWorld.getSimPatches(0, m_palSources, m_palPatches);
        if (Main.m_simData.getSimAttribute(0, 0) == 0) {
            AnimationManager.loadImage(60, m_palSources, m_palPatches, 0);
        } else {
            AnimationManager.loadImage(52, m_palSources, m_palPatches, 0);
        }
    }

    public static int getSimHairImage(int n) {
        int n2 = Main.m_simData.getSimAttribute(n, 2);
        if (Main.m_simData.getSimAttribute(n, 0) == 0) {
            return n2 == 0 ? 62 : (n2 == 1 ? 63 : (n2 == 2 ? 64 : 65));
        }
        return n2 == 0 ? 54 : (n2 == 1 ? 55 : (n2 == 2 ? 56 : 57));
    }

    public static void init(int n) {
        Event.PMSystem_forceGC();
        GlobalConstants.PMDebug_println("StateInGame.init()");
        GameConstants.Minigame_init();
        Main.m_simData.newScene();
        if (Debug.UserInterface_m_arrowLeftAnimPlayer == null) {
            Debug.UserInterface_m_arrowLeftAnimPlayer = new AnimPlayer();
            Debug.UserInterface_m_arrowRightAnimPlayer = new AnimPlayer();
        }
        m_state = 0;
        m_stateTime = 0;
        m_afterFadeState = 0;
        m_nextScene = -1;
        m_nextSceneState = -1;
        m_suppressMenus = false;
        m_hudBottomHeight = AnimationManager.getAnimFrameHeight(699, 0) + AnimationManager.getAnimFrameHeight(700, 0);
        relationshipListItemSize = AnimationManager.getAnimFrameHeight(735, 1) + 6;
        relationshipListItemSizeHalf = relationshipListItemSize >> 1;
        m_viewportX = 0;
        m_viewportY = 0;
        m_viewportWidth = 240 - m_viewportX;
        m_viewportHeight = 245 - m_viewportY - m_hudBottomHeight;
        m_maxContextMenuItems = (short)(m_viewportHeight / 26);
        StateInGame.initSimAssets();
        m_tutorialMessageActive = false;
        m_normalTimeStep = 0;
        m_displayedMoney = Main.m_simData.getMoney();
        m_postMessageBox = 0;
        m_curtainState = 0;
        m_tickerString1 = (short)-1;
        m_tickerString2 = (short)-1;
        Cursor.m_cursorObject = null;
        Cursor.m_cursorSelectFlags = 0;
        Cursor.m_cursorSnapping = false;
        Cursor.hide = false;
        Cursor.m_keyLeft = false;
        Cursor.m_keyRight = false;
        Cursor.m_keyDown = false;
        Cursor.m_keyUp = false;
        m_cameraDestX = 0;
        m_cameraDestZ = 0;
        m_cameraVelX = 0;
        m_cameraVelZ = 0;
        m_cameraLastVelX = 0;
        m_cameraLastVelZ = 0;
        m_cameraAtDest = false;
        m_cameraFollowTarget = null;
        m_cameraFollowTargetReturn = false;
        m_objects = null;
        m_objectsSims = null;
        m_playerSim = null;
        if (m_objectStack == null) {
            m_objectStack = new Stack();
        }
        m_objectStack.removeAllElements();
        m_refreshObjects = true;
        m_refreshObjectsSims = true;
        m_contextMenuActive = false;
        m_contextMenuOnSubMenu = false;
        m_contextMenuBackCursor = 0;
        if (m_contextMenuItems == null) {
            m_contextMenuItems = new short[55];
            m_contextMenuActions = new short[55];
            m_contextMenuFullActions = new short[55];
        }
        m_contextMenuObject = null;
        m_pauseMenuActive = false;
        if (m_pauseMenuItems == null) {
            short[] sArray = new short[15];
            Main.menuClear(sArray, 624, 17);
            Main.menuAppendItem(sArray, 778);
            Main.menuAppendItem(sArray, 621);
            Main.menuAppendItem(sArray, 361);
            Main.menuAppendItem(sArray, 781);
            Main.menuAppendItem(sArray, 785);
            Main.menuAppendItem(sArray, 783);
            Main.menuAppendItem(sArray, 759);
            m_pauseMenuItems = sArray;
        }
        m_pauseMenuState = 0;
        m_shortcutMenuActive = false;
        m_shortcutByShortcutKey = false;
        if (m_shortcutMenuItems == null) {
            m_shortcutMenuItems = new short[20];
        }
        m_quickLinksActive = false;
        if (m_quickLinksMenu == null) {
            m_quickLinksMenu = new short[25];
        }
        m_buyModeState = 0;
        m_buyModeObject = null;
        m_infoScreenState = -1;
        m_infoLoadedNPC = 0;
        m_infoScreenSimSelectedIndex = 0;
        m_npcLongestStringLength = 0;
        m_skillLongestStringLength = 0;
        m_infoScreenRecipeSelected = 0;
        m_infoScreenItemSelectedIndex = 0;
        m_jobOfferCareer = 0;
        m_jobOfferLevel = 0;
        m_payIncome = 0;
        m_quitJobConfirmed = false;
        m_showEndOfGameScreen = false;
        if (GlobalConstants.PMStateManager_lastState == 1) {
            m_showNewDream = false;
        }
        m_showGetItem = -1;
        m_showGetItemQty = 0;
        m_showGetItemTitle = 0;
        m_showGetItemMessage = 0;
        m_simAIEventTimer = 0;
        m_simInactivityTimer = 0;
        StateInGame.initActionQueue();
        m_displayedMoodLevel = Main.m_simData.getMoodLevel();
        m_showFetchQuestEnd = false;
        Event.m_eventState = 0;
        Event.m_preEventCursorObject = null;
        if (m_timeAnimPlayer == null) {
            m_timeAnimPlayer = new AnimPlayer();
            m_buffRisingAnimPlayer = new AnimPlayer();
            m_buffDroppingAnimPlayer = new AnimPlayer();
            Cursor.m_cursorAnimPlayer = new AnimPlayer();
            m_dreamAnimPlayers = new AnimPlayer[4];
            int n2 = 0;
            while (true) {
                if (n2 >= 4) break;
                StateInGame.m_dreamAnimPlayers[n2] = new AnimPlayer();
                ++n2;
            }
            m_playerGemAnimPlayer = new AnimPlayer();
        }
        m_timeAnimPlayer.startAnim(749, 20);
        m_buffRisingAnimPlayer.startAnim(717, 20);
        m_buffDroppingAnimPlayer.startAnim(716, 20);
        Cursor.m_cursorAnimPlayer.startAnim(676, 20);
        m_playerGemAnimPlayer.startAnim(694, 20);
        Debug.UserInterface_initUI();
        Event.PMSystem_gc();
        if (GlobalConstants.PMStateManager_lastState == 1) {
            Main.setNextZoomMapId(-1);
        }
        if (n == 99) {
            m_mapModePrev = m_mapMode;
            m_mapMode = 1;
        } else if (n == 98) {
            m_mapModePrev = m_mapMode;
            m_mapMode = (byte)2;
            n = 5;
        } else if (n == 100) {
            m_mapModePrev = m_mapMode;
            m_mapMode = 1;
            n = 5;
        } else if (n == -1 || n == 96) {
            m_mapModePrev = m_mapMode;
            m_mapMode = 0;
            n = 5;
        }
        m_initialState = n;
        StateInGame.stateTransition(1);
        GlobalConstants.PMDebug_println("StateInGame.started!");
    }

    public static void deinit() {
        GlobalConstants.PMDebug_println("StateInGame.deinit()");
        if (GlobalConstants.PMStateManager_nextState == 3) {
            return;
        }
        m_pauseMenuItems = null;
        if (m_mapMode == 0 || m_mapMode == 2 || m_mapMode == 1) {
            // empty if block
        }
        Main.m_simWorld.unload();
        int n = 129528;
        if (GlobalConstants.PMStateManager_nextState == 0) {
            n &= 0xFFFFFFF7;
        }
        if (GlobalConstants.PMStateManager_nextState != 0) {
            AnimationManager.unloadImage(33, -1);
        }
        if (GlobalConstants.PMStateManager_nextState != 0) {
            AnimationManager.unloadImage(23, -1);
        }
        if (GlobalConstants.PMStateManager_nextState != 0) {
            AnimationManager.unloadImage(60, -1);
            AnimationManager.unloadImage(52, -1);
        }
        Main.unloadAllImages(n, -1);
    }

    public static void render() {
        switch (m_state) {
            default: {
                break;
            }
            case 1: {
                Intro.LoadingScreen_draw();
                break;
            }
            case 5: {
                StateInGame.renderMain();
                StateInGame.renderSoftkeyBar();
                break;
            }
            case 6: {
                StateInGame.renderLoadSim();
                break;
            }
            case 7: {
                StateInGame.renderBuildMode();
                break;
            }
            case 8: {
                StateInGame.renderInfoScreen();
                break;
            }
            case 3: 
            case 9: {
                StateInGame.renderMain();
                if (!m_pauseMenuActive) {
                    Event.PostEffects_renderBackgroundDim();
                    Debug.UserInterface_drawGenericMessageBox();
                }
                StateInGame.renderSoftkeyBar();
                break;
            }
            case 10: {
                StateInGame.renderJobOffer();
                break;
            }
            case 11: {
                StateInGame.renderPay();
                break;
            }
            case 12: {
                StateInGame.renderRaiseFailure();
                break;
            }
            case 13: {
                StateInGame.renderQuitJob();
                break;
            }
            case 14: {
                StateInGame.renderNewDream();
                break;
            }
            case 15: {
                StateInGame.renderShowGetItem();
                break;
            }
            case 16: {
                GameConstants.Minigame_renderMiniGame();
                break;
            }
            case 17: {
                Intro.StateMenu_page = 9;
                StateInGame.renderShopping();
                StateInGame.renderSoftkeyBar();
                break;
            }
            case 18: {
                StateInGame.renderQuest();
                break;
            }
            case 19: {
                Event.renderEvent();
            }
        }
        Event.PostEffects_renderFade(-1);
        Debug.renderDebug();
        Debug.renderPerf();
    }

    public static void renderSoftkeyBar() {
        Main.renderSoftkeyBar();
        AnimationManager.drawAnimFrame(715, 0, 120, 260);
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 715, 0, 0);
        int n = 120 + m_tempInt10[0];
        int n2 = 260 + m_tempInt10[1];
        SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendMoneyToBuffer(m_displayedMoney);
        AnimationManager.TextHandler_drawString(sDKString, 2, n, n2, 24);
    }

    public static void renderMain() {
        Main.m_simWorld.renderWorld();
        if (!m_quickLinksActive) {
            StateInGame.renderHUDTop();
        }
        if (StateInGame.isCurtainActive()) {
            StateInGame.renderCurtain();
        }
        if (m_pauseMenuActive) {
            Cursor.renderCursor();
            StateInGame.renderContextRelationships();
            StateInGame.renderHUDBottom();
            StateInGame.renderHUDMoodSim();
            StateInGame.renderPauseMenu();
        } else if (!m_suppressMenus && m_contextMenuActive) {
            StateInGame.renderContextRelationships();
            StateInGame.renderHUDBottom();
            StateInGame.renderHUDMoodSim();
            StateInGame.renderContextMenu();
        } else if (m_tutorialMessageActive) {
            StateInGame.renderContextRelationships();
            StateInGame.renderHUDBottom();
            StateInGame.renderHUDMoodSim();
            Event.PostEffects_renderBackgroundDim();
            if (!m_pauseMenuActive) {
                Debug.UserInterface_prepareTextScreen(tutMsgStringBody, tutMsgStringTitle, false);
            }
            Debug.UserInterface_drawTextScreen();
        } else {
            if (m_state != 16) {
                Cursor.renderCursor();
            }
            StateInGame.renderContextRelationships();
            StateInGame.renderHUDBottom();
            StateInGame.renderHUDMoodSim();
            if (!m_suppressMenus && m_shortcutMenuActive) {
                StateInGame.renderShortcutMenu();
            }
        }
        if (Debug.DISABLE_EVENTS) {
            AnimationManager.TextHandler_drawRawString(new SDKString("no events"), 0, m_viewportX + 2, 2, 20);
        }
    }

    public static void processKeys() {
        if (m_state == 1 || StateInGame.isCurtainActive() && !m_pauseMenuActive && m_state != 9 && m_state != 14 && m_state != 19) {
            return;
        }
        if (!Event.PostEffects_m_fading && m_afterFadeState != 0) {
            StateInGame.stateTransition(m_afterFadeState);
            m_afterFadeState = 0;
            return;
        }
        if (Event.PostEffects_isFading()) {
            return;
        }
        if (m_pauseMenuActive) {
            StateInGame.processKeysPauseMenu();
        } else if (!m_suppressMenus && m_contextMenuActive) {
            StateInGame.processKeysContextMenu();
        } else if (!m_suppressMenus && m_shortcutMenuActive) {
            StateInGame.processKeysShortcutMenu();
        } else if (m_tutorialMessageActive) {
            StateInGame.processKeysTutorialMessage();
        } else if (m_quickLinksActive) {
            StateInGame.processKeysQuickLinks();
        } else {
            switch (m_state) {
                default: {
                    break;
                }
                case 3: {
                    StateInGame.processKeysSavePrompt();
                    break;
                }
                case 5: {
                    StateInGame.processKeysMain();
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    StateInGame.processKeysBuildMode();
                    break;
                }
                case 8: {
                    StateInGame.processKeysInfoScreen();
                    break;
                }
                case 9: {
                    StateInGame.processKeysMessageBox();
                    break;
                }
                case 10: {
                    StateInGame.processKeysJobOffer();
                    break;
                }
                case 11: {
                    StateInGame.processKeysPay();
                    break;
                }
                case 12: {
                    StateInGame.processKeysRaiseFailure();
                    break;
                }
                case 13: {
                    StateInGame.processKeysQuitJob();
                    break;
                }
                case 14: {
                    StateInGame.processKeysNewDream();
                    break;
                }
                case 15: {
                    StateInGame.processKeysShowGetItem();
                    break;
                }
                case 16: {
                    GameConstants.Minigame_processKeysMiniGame();
                    break;
                }
                case 17: {
                    StateInGame.processKeysShopping();
                    break;
                }
                case 18: {
                    StateInGame.processKeysQuest();
                    break;
                }
                case 19: {
                    Event.processKeysEvent();
                }
            }
        }
    }

    public static void processKeysSavePrompt() {
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            ArrayHandler.Rms_saveRMSAppSettings();
            ArrayHandler.Rms_saveRMSGameData();
            StateInGame.fadeStateTransition(2);
        } else if (Main.softPressNeg()) {
            StateInGame.fadeStateTransition(2);
        }
    }

    public static void processKeysMain() {
        if (Main.softPressNeg()) {
            StateInGame.showPauseMenu();
            return;
        }
        if (Main.softPressPos()) {
            StateInGame.showShortcutMenu();
            return;
        }
        Cursor.processKeysCursor();
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            Cursor.processKeysFire();
        }
    }

    public static void updateStep(int n) {
        relationshipArrowTimer += n;
        if (!Debug.UserInterface_resetTextScrollTimer) {
            Debug.UserInterface_textOffsetTimer += n;
        } else {
            Debug.UserInterface_resetTextScrollTimer = false;
        }
        m_stateTime += n;
        if (m_state == 1) {
            StateInGame.updateLoading(n);
            return;
        }
        StateInGame.updateHUD(n);
        AnimationManager.TextHandler_updateScrollers(n);
        switch (m_state) {
            case 5: {
                StateInGame.updateMain(n);
                break;
            }
            case 6: {
                StateInGame.updateLoadSim();
                if (m_loadSimCount != 0) break;
                StateInGame.stateTransition(5);
                break;
            }
            case 7: {
                StateInGame.updateBuildMode(n);
                break;
            }
            case 8: {
                StateInGame.updateInfoScreen(n);
                break;
            }
            case 16: {
                GameConstants.Minigame_updateMiniGame(n);
                break;
            }
            case 19: {
                Event.updateEvent(n);
                break;
            }
            case 18: {
                break;
            }
            case 17: {
                Debug.UserInterface_m_storeHeaderAnimPlayer.updateAnim(n);
                break;
            }
        }
    }

    public static void stateTransition(int n) {
        int n2 = m_state;
        m_state = n;
        m_stateTime = 0;
        m_suppressMenus = true;
        AnimationManager.TextHandler_resetScrollers();
        Cursor.stopCursor();
        switch (n) {
            default: {
                break;
            }
            case 1: {
                m_loadingState = 0;
                m_contextMenuActive = false;
                m_pauseMenuActive = false;
                break;
            }
            case 2: {
                Intro.LoadingScreen_init();
                GlobalConstants.PMStateManager_set(3, 1);
                break;
            }
            case 3: {
                StateInGame.hideMenus();
                Debug.UserInterface_prepareGenericMessageBox(780, 787);
                break;
            }
            case 4: {
                ArrayHandler.Rms_saveRMSGameData();
                GlobalConstants.PMStateManager_set(-1, 0);
                break;
            }
            case 5: {
                Cursor.setCursorSelectFlags(1);
                m_suppressMenus = false;
                break;
            }
            case 6: {
                StateInGame.loadNewSimBegin();
                Debug.UserInterface_prepareGenericMessageBox(423, 852);
                break;
            }
            case 7: {
                m_suppressMenus = false;
                break;
            }
            case 11: {
                m_payIncome = Main.m_simData.careerDayWorked();
                Debug.UserInterface_prepareGenericMessageBox(351, 625);
                break;
            }
            case 15: {
                Debug.UserInterface_prepareGenericMessageBox(m_showGetItemMessage, m_showGetItemTitle);
                break;
            }
            case 8: {
                Debug.UserInterface_wrapStrings = true;
                Debug.UserInterface_resetTextScrollTimer = true;
                Debug.UserInterface_textOffsetTimer = 0;
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: {
                break;
            }
            case 18: {
                break;
            }
            case 17: {
                if (Debug.UserInterface_m_storeHeaderAnimPlayer == null) {
                    Debug.UserInterface_m_storeHeaderAnimPlayer = new AnimPlayer();
                }
                Debug.UserInterface_m_storeHeaderAnimPlayer.startAnim(746, 4);
            }
        }
        StateInGame.setupSoftkeys();
    }

    public static void fadeStateTransition(int n) {
        m_afterFadeState = n;
        if (!Event.PostEffects_isFadingOut()) {
            Event.PostEffects_startFadeOut();
        }
        Cursor.stopCursor();
    }

    public static void changeSceneWithSavePrompt(int n, int n2) {
        if (ArrayHandler.Rms_getSavePromptsEnabled()) {
            m_nextScene = n;
            m_nextSceneState = n2;
            StateInGame.stateTransition(3);
        } else {
            StateInGame.changeSceneWithFade(n, n2);
        }
    }

    public static void changeSceneWithFade(int n, int n2) {
        m_nextScene = n;
        m_nextSceneState = n2;
        StateInGame.fadeStateTransition(2);
    }

    public static void changeScene(int n, int n2) {
        m_nextScene = n;
        m_nextSceneState = n2;
        StateInGame.stateTransition(2);
    }

    public static void setupSoftkeys() {
        int n = 0;
        int n2 = 0;
        if (m_pauseMenuActive) {
            if (m_pauseMenuState == 1 || m_pauseMenuState == 2 || m_pauseMenuState == 3 || m_pauseMenuState == 4) {
                n2 = 512;
                n = 256;
            } else {
                n2 = 4;
                n = 16;
            }
        } else if (!m_suppressMenus && m_contextMenuActive) {
            n2 = 4;
            n = m_state == 7 && Cursor.m_cursorObject.buildInUse() ? 0 : 16;
        } else if (!m_suppressMenus && m_shortcutMenuActive) {
            n2 = 4;
            n = 16;
        } else if (m_tutorialMessageActive) {
            if (m_tutorialMessageShowing == 0) {
                n = 256;
                n2 = 512;
            } else {
                n = 8;
            }
        } else if (m_quickLinksActive) {
            n2 = 4;
            n = 16;
        } else {
            block0 : switch (m_state) {
                default: {
                    break;
                }
                case 3: {
                    n2 = 512;
                    n = 256;
                    break;
                }
                case 5: {
                    if (m_curtainState != 0) break;
                    n2 = 1;
                    n = 1024;
                    break;
                }
                case 7: {
                    switch (m_buyModeState) {
                        default: {
                            break block0;
                        }
                        case 1: {
                            n2 = 4;
                            n = 16;
                            break block0;
                        }
                        case 2: {
                            n2 = 4;
                            n = 16;
                            break block0;
                        }
                        case 3: 
                        case 7: 
                        case 8: {
                            n = 8;
                            break block0;
                        }
                        case 4: 
                        case 10: {
                            n2 = 4;
                            n = 2048;
                            break block0;
                        }
                        case 5: 
                        case 9: {
                            n2 = 512;
                            n = 256;
                            break block0;
                        }
                        case 11: 
                        case 12: {
                            n = 8;
                            break block0;
                        }
                        case 6: 
                    }
                    break;
                }
                case 8: {
                    switch (m_infoScreenState) {
                        default: {
                            break block0;
                        }
                        case 0: {
                            n2 = 4;
                            n = Main.m_simData.getRelationshipNthCount() > 0 ? 16 : 0;
                            break block0;
                        }
                        case 3: {
                            if (Main.m_simData.getDream() != -1 && Main.m_simData.isDreamToPromisePossible()) {
                                n = 8;
                            }
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 9: 
                        case 10: {
                            n2 = 4;
                            break block0;
                        }
                        case 6: 
                    }
                    n = 0;
                    n2 = 4;
                    int n3 = StateInGame.getInfoItem();
                    if (n3 == -1 || (Main.m_simWorld.d_itemFlags[n3] & 0x400) == 0) break;
                    n = 16;
                    break;
                }
                case 9: {
                    n2 = 0;
                    n = 8;
                    break;
                }
                case 10: {
                    if (m_jobOfferCareer != -1) {
                        n2 = 512;
                        n = 256;
                        break;
                    }
                    n = 8;
                    break;
                }
                case 11: {
                    n = 8;
                    break;
                }
                case 12: {
                    n = 8;
                    break;
                }
                case 13: {
                    if (m_quitJobConfirmed) {
                        n = 8;
                        break;
                    }
                    n2 = 512;
                    n = 256;
                    break;
                }
                case 14: {
                    n2 = 128;
                    n = 8;
                    break;
                }
                case 15: {
                    n = 8;
                    break;
                }
                case 16: {
                    n2 = 1;
                    if (GameConstants.Minigame_done) break;
                    n = 64;
                    break;
                }
                case 17: {
                    n2 = 4;
                    if (m_shoppingTradeAmount > 0) {
                        n = 4096;
                        break;
                    }
                    if (m_shoppingTradeAmount >= 0) break;
                    n = 8192;
                    break;
                }
                case 18: {
                    switch (m_questState) {
                        default: {
                            break block0;
                        }
                        case 0: {
                            n2 = 512;
                            n = 256;
                            break block0;
                        }
                        case 1: {
                            n = 8;
                            break block0;
                        }
                        case 2: 
                        case 3: 
                    }
                    n = 8;
                    break;
                }
                case 19: {
                    switch (Event.m_eventState) {
                        case 2: {
                            n = 8;
                            break block0;
                        }
                    }
                }
            }
        }
        Main.setSoftKeys(n2, n);
    }

    public static void hideMenus() {
        if (m_contextMenuActive) {
            StateInGame.hideContextMenu();
        }
        if (m_shortcutMenuActive) {
            StateInGame.hideShortcutMenu();
        }
        if (m_quickLinksActive) {
            StateInGame.hideQuickLinks();
        }
    }

    public static void kickPlayer(int n, int n2) {
        StateInGame.showMessageBox(n, n2, 1);
    }

    public static void killPlayer(int n) {
        AnimationManager.TextHandler_dynamicString(-11, n, ArrayHandler.Rms_getSimName());
        if (m_quickLinksActive) {
            StateInGame.hideQuickLinks();
        }
        Event.triggerEvent(0, -11, -1, -11, -1);
    }

    public static void passOut() {
        m_playerSim.beginSimAction(6, null);
        StateInGame.startCurtainIn();
        ++numTimesPassedOut;
    }

    public static void goHome() {
        Main.setNextHouseId(0);
        StateInGame.changeSceneWithSavePrompt(0, -1);
    }

    public static void gotoWork() {
        StateInGame.hideMenus();
        Main.m_simData.removeActiveBuff(3);
        StateInGame.changeSceneWithSavePrompt(0, 99);
    }

    public static void gotoMap() {
        StateInGame.changeSceneWithSavePrompt(0, 98);
    }

    public static void gotoMapForObject(MapObject mapObject) {
        int n = mapObject.getType();
        if (n == 1) {
            Main.setupEncounter((MapObjectSim)mapObject);
            Main.setNextZoomMapId(84);
            StateInGame.changeSceneWithSavePrompt(0, 100);
        } else if (n == 111) {
            Main.setupEncounter(null);
            Main.setNextZoomMapId(79);
            StateInGame.changeSceneWithSavePrompt(0, 100);
        } else if (n == 113) {
            Main.setupEncounter(null);
            Main.setNextZoomMapId(80);
            StateInGame.changeSceneWithSavePrompt(0, 100);
        } else if (n == 112) {
            Main.setupEncounter(null);
            Main.setNextZoomMapId(81);
            StateInGame.changeSceneWithSavePrompt(0, 100);
        } else if (n == 114) {
            Main.setupEncounter(null);
            Main.setNextZoomMapId(82);
            StateInGame.changeSceneWithSavePrompt(0, 100);
        } else {
            Main.setNextHouseId(ArrayHandler.indexOf(n, Main.m_simWorld.d_houseMacroObjects));
            StateInGame.changeSceneWithSavePrompt(0, -1);
        }
    }

    public static void showTutorialMessage(byte by, int n, int n2) {
        m_tutorialMessageShowing = by;
        if (m_state == 19 || m_state == 9) {
            return;
        }
        if (ArrayHandler.Rms_getRMSHasSeenTutorial(by)) {
            return;
        }
        ArrayHandler.Rms_setRMSHasSeenTutorial(by);
        if (!ArrayHandler.Rms_getTutorialsEnabled()) {
            return;
        }
        StateInGame.hideMenus();
        tutMsgStringBody = n2;
        tutMsgStringTitle = n;
        Debug.UserInterface_prepareTextScreen(tutMsgStringBody, tutMsgStringTitle, true);
        m_tutorialMessageActive = true;
        StateInGame.setupSoftkeys();
    }

    public static void processKeysTutorialMessage() {
        Debug.UserInterface_processKeysTextScreen();
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            StateInGame.hideTutorialMessage();
            if (m_tutorialMessageShowing == 0) {
                StateInGame.showTutorialMessage((byte)1, 922, 923);
            }
            if (m_state != 5 && m_state != 16) {
                StateInGame.stateTransition(5);
            }
        } else if (Main.softPressNeg()) {
            StateInGame.hideTutorialMessage();
        }
    }

    public static void hideTutorialMessage() {
        m_tutorialMessageActive = false;
        StateInGame.setupSoftkeys();
    }

    public static int getNormalTimeStep() {
        return m_normalTimeStep;
    }

    public static boolean gamePaused() {
        return m_pauseMenuActive || m_shortcutMenuActive || m_tutorialMessageActive || m_state != 5;
    }

    public static void updateMain(int n) {
        if (StateInGame.gamePaused()) {
            return;
        }
        if (m_loadSimCount > 0) {
            StateInGame.stateTransition(6);
            return;
        }
        if (StateInGame.isCurtainActive()) {
            StateInGame.updateCurtain(n);
        }
        if (!m_tutorialMessageActive && !Main.m_simData.isDelayed() && StateInGame.checkTriggers()) {
            return;
        }
        StateInGame.updateTicker(n);
        m_normalTimeStep = n;
        int n2 = Main.m_simData.getFastforward() ? n << 2 : n;
        StateInGame.updateObjects(n2);
        Cursor.updateCursor(n);
        StateInGame.updateCamera(n);
        Debug.UserInterface_updateLeftRightArrows(n);
        if (!StateInGame.isCurtainActive() && !Event.PostEffects_isFading()) {
            StateInGame.updateSimData(n);
            if (m_mapMode == 2) {
                StateInGame.updateEventsMapMode(n);
            } else if (m_mapMode == 0) {
                StateInGame.updateEventsHouse(n);
            } else {
                StateInGame.updateEventsZoomMode(n);
            }
            if (GameConstants.Minigame_goalCompletedPracticed) {
                if (GameConstants.Minigame_goalCompletedType == 0) {
                    Main.m_simData.dreamCompleteEvent(8);
                    if (GameConstants.Minigame_goalCompletedWon) {
                        Main.m_simData.dreamCompleteEvent(24);
                    }
                }
                if (GameConstants.Minigame_goalCompletedType == 2) {
                    Main.m_simData.dreamCompleteEvent(7);
                    if (GameConstants.Minigame_goalCompletedWon) {
                        Main.m_simData.dreamCompleteEvent(29);
                    }
                }
                if (GameConstants.Minigame_goalCompletedType == 1) {
                    Main.m_simData.dreamCompleteEvent(32);
                    if (GameConstants.Minigame_goalCompletedWon) {
                        Main.m_simData.dreamCompleteEvent(40);
                    }
                }
                if (GameConstants.Minigame_goalCompletedType == 3) {
                    Main.m_simData.dreamCompleteEvent(45);
                    if (GameConstants.Minigame_goalCompletedWon) {
                        Main.m_simData.dreamCompleteEvent(52);
                    }
                }
                GameConstants.Minigame_goalCompletedPracticed = false;
                GameConstants.Minigame_goalCompletedType = (byte)-1;
                GameConstants.Minigame_goalCompletedWon = false;
            }
            StateInGame.updateSimAction();
            if (first) {
                first = false;
            }
        }
    }

    public static boolean checkTriggers() {
        if (m_showFetchQuestEnd) {
            m_showFetchQuestEnd = false;
            StateInGame.stateTransition(18);
            StateInGame.stateTransitionQuest(3);
            return true;
        }
        if (m_showGetItem != -1) {
            StateInGame.stateTransition(15);
            return true;
        }
        if (Main.m_simData.showPersonaComplete()) {
            Main.m_simData.m_personaGoalsCompletedAllShown = true;
            Event.triggerEvent(7, -1, -1, Main.m_simData.d_personaDescStrings[Main.m_simData.m_persona], 642);
            return true;
        }
        if (m_showEndOfGameScreen) {
            m_showEndOfGameScreen = false;
            Main.m_simData.GSEndOfGameHasBeenScreenShown = true;
            ArrayHandler.Rms_saveRMSGameData();
            StateInGame.showMessageBox(501, 250, 5);
            return true;
        }
        if (m_showNewDream) {
            m_showNewDream = false;
            if (Main.m_simData.getDream() != -1) {
                StateInGame.showNewDreamMessage();
                return true;
            }
        }
        return false;
    }

    public static void updateHUD(int n) {
        m_timeAnimPlayer.updateAnim(n);
        int n2 = Main.m_simData.getMoney();
        m_displayedMoney = Debug.UserInterface_interpolateValue(m_displayedMoney, n2, n, 9);
        if (!StateInGame.gamePaused()) {
            m_buffDroppingAnimPlayer.updateAnim(n);
            m_buffRisingAnimPlayer.updateAnim(n);
            m_playerGemAnimPlayer.updateAnim(n);
        }
        if (m_state == 5 && !m_shortcutMenuActive && !m_pauseMenuActive) {
            for (int i = 0; i < m_dreamAnimPlayers.length; ++i) {
                int n3 = Main.m_simData.getPromise(i);
                AnimPlayer animPlayer = m_dreamAnimPlayers[i];
                animPlayer.updateAnim(n);
                if (animPlayer.isAnimating() || animPlayer.getAnimID() != 702 && n3 == -1) continue;
                animPlayer.startAnim(701, 20);
            }
        }
    }

    public static void renderHUDTop() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = m_viewportX + m_viewportWidth;
        int n11 = m_viewportY;
        if (m_state == 7) {
            n9 = AnimationManager.getAnimFrameWidth(708, 0);
            n8 = AnimationManager.getAnimFrameHeight(708, 0);
            n7 = 240 - (n9 + 9);
            n6 = n8 + 3 - 1;
            Debug.UserInterface_drawDropDownTitle(3, n7, n6, 793);
        } else {
            n5 = AnimationManager.getAnimFrameWidth(7, 0);
            n9 = AnimationManager.getAnimFrameWidth(8, 0);
            n4 = m_viewportX + 5 + (n9 >> 1);
            n3 = n11 + 3 + (n9 >> 1);
            n2 = n4;
            n = m_actionQueueSize;
            int[] nArray = m_actionQueueActions;
            MapObject[] mapObjectArray = m_actionQueueArg1s;
            for (int i = 0; i < n; ++i) {
                int n12 = nArray[i];
                MapObject mapObject = mapObjectArray[i];
                int n13 = 8;
                int n14 = n9;
                if (i == 0) {
                    n13 = 7;
                    n14 = n5;
                }
                int n15 = 359;
                if (n12 == 111) {
                    n15 = 5;
                } else if (mapObject != null) {
                    n15 = mapObject.getFlag(16384) && !StateInGame.isMapMode() ? 10 : Main.m_simWorld.d_objectActionIcons[mapObject.getType()];
                }
                AnimationManager.drawAnimFrame(n13, 0, n2, n3);
                AnimationManager.drawAnimFrame(n15, 0, n2, n3);
                n2 += n14 + 2;
            }
        }
        n5 = Main.m_simData.getGameTime();
        SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendTimeToBuffer24Hour(n5);
        AnimationManager.drawAnimFrame(708, 0, n10, n11);
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 708, 0, 0);
        n8 = n10 + m_tempInt10[0];
        n7 = n11 + m_tempInt10[1];
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 708, 0, 1);
        n6 = n10 + m_tempInt10[0];
        n4 = n11 + m_tempInt10[1];
        AnimationManager.TextHandler_drawString(sDKString, 2, n8 + 1, n7 + 1, 24);
        n3 = SimData.DAY_STRINGS[Main.m_simData.getGameDay()];
        AnimationManager.TextHandler_drawString(n3, 2, n6 + 1, n4 + 1, 20);
        if (StateInGame.gamePaused()) {
            n2 = 2;
            n = 750;
        } else if (Main.m_simData.getFastforward()) {
            n2 = 4;
            n = 748;
        } else {
            n2 = 3;
            n = 749;
        }
        m_timeAnimPlayer.startAnim(n, 4);
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 708, 0, n2);
        AnimationManager.drawAnim(m_timeAnimPlayer, n10 + m_tempInt10[0], n11 + m_tempInt10[1]);
    }

    public static void renderHUDBottom() {
        short s;
        int n;
        int n2;
        if (m_quickLinksActive) {
            StateInGame.renderQuickLinks();
        }
        if (m_state != 16 && m_state != 7 && StateInGame.getSimContext() == -1 && !m_quickLinksActive) {
            StateInGame.renderBuffs();
        }
        AnimationManager.drawAnimFrame(700, 0, 120, 245);
        if (m_tickerString1 != -1) {
            StateInGame.renderTicker();
        }
        AnimationManager.getAnimFrameCollisionBox(m_tempInt10, 700, 0, 0);
        int n3 = 120 + m_tempInt10[0] - 50;
        int n4 = 245 + m_tempInt10[1];
        int n5 = 0;
        while (true) {
            if (n5 >= 4) break;
            n2 = n3 + n5 * (AnimationManager.getAnimFrameWidth(701, 0) + 3);
            AnimPlayer animPlayer = m_dreamAnimPlayers[n5];
            if (animPlayer.isAnimating()) {
                AnimationManager.drawAnim(animPlayer, n2, n4);
            }
            ++n5;
        }
        AnimationManager.getAnimFrameCollisionBox(m_tempInt10, 700, 0, 1);
        n5 = Main.m_simData.getMotiveCount();
        n2 = AnimationManager.getAnimFrameWidth(Main.m_simData.getMotiveLowAnim(0), 0);
        int n6 = 120 + m_tempInt10[0] - (n2 >> 1) - 50;
        int n7 = 245 + m_tempInt10[1] + (m_tempInt10[3] >> 1);
        int n8 = m_tempInt10[2];
        int n9 = n6 + n8;
        for (n = 0; n < n5 && n9 > n6; ++n) {
            if (Main.m_simData.getMotiveLevel(n) >= 0x230000) continue;
            s = Main.m_simData.getMotiveLowAnim(n);
            AnimationManager.drawAnimFrame(s, 0, n9, n7);
            n9 -= n2;
        }
        for (n = 0; n < n5 && n9 > n6; ++n) {
            if (Main.m_simData.getMotiveLevel(n) <= 0x410000) continue;
            s = Main.m_simData.getMotiveHighAnim(n);
            AnimationManager.drawAnimFrame(s, 0, n9, n7);
            n9 -= n2;
        }
    }

    public static void renderHUDMoodSim() {
        AnimationManager.drawAnimFrame(699, 0, 120, 245);
        boolean bl = m_displayedMoodLevel < 0;
        int n = Math.abs(m_displayedMoodLevel >> 16);
        int n2 = 0x640000 >> 16;
        int n3 = AnimationManager.getAnimFrameWidth(697, 0);
        int n4 = n3 * n / n2;
        int n5 = 120 + (bl ? -n4 : 0);
        int n6 = ArrayOptimizer.PMGraphics_getClipX();
        int n7 = ArrayOptimizer.PMGraphics_getClipY();
        int n8 = ArrayOptimizer.PMGraphics_getClipWidth();
        int n9 = ArrayOptimizer.PMGraphics_getClipHeight();
        ArrayOptimizer.PMGraphics_setClip(n5, n7, n4, n9);
        int n10 = bl ? 698 : 697;
        AnimationManager.drawAnimFrame(n10, 0, 120, 245);
        ArrayOptimizer.PMGraphics_setClip(n6, n7, n8, n9);
        Debug.UserInterface_drawHUDSim(120, 245, false);
    }

    public static void showMessageBoxFun() {
        int[] nArray;
        if (m_mapMode != 1) {
            return;
        }
        int n = -1;
        if (Main.getNextZoomMapId() == 79) {
            nArray = new int[]{424, 425, 426, 427, 428, 429, 430, 431};
            while ((n = nArray[Main.rand(0, nArray.length - 1)]) == lastMessageFun) {
            }
            nArray = null;
        }
        if (Main.getNextZoomMapId() == 80) {
            nArray = new int[]{432, 433, 434, 435, 436, 437, 438, 439};
            while ((n = nArray[Main.rand(0, nArray.length - 1)]) == lastMessageFun) {
            }
            nArray = null;
        }
        if (Main.getNextZoomMapId() == 81) {
            nArray = new int[]{440, 441, 442, 443, 444, 445, 446, 447};
            while ((n = nArray[Main.rand(0, nArray.length - 1)]) == lastMessageFun) {
            }
            nArray = null;
        }
        if (Main.getNextZoomMapId() == 82) {
            nArray = new int[]{448, 449, 450, 451, 452, 453, 454, 455};
            while ((n = nArray[Main.rand(0, nArray.length - 1)]) == lastMessageFun) {
            }
            nArray = null;
        }
        if (n != -1) {
            StateInGame.showMessageBox(n, 984);
            ++numMessagesRead;
            lastMessageFun = n;
        }
    }

    public static void showMessageBox(int n, int n2) {
        StateInGame.showMessageBox(n, n2, 0);
    }

    public static void showMessageBox(int n, int n2, int n3) {
        Debug.UserInterface_m_uiTextBoxTopLine = 0;
        StateInGame.hideQuickLinks();
        m_postMessageBox = n3;
        Debug.UserInterface_prepareGenericMessageBox(n, n2);
        StateInGame.stateTransition(9);
    }

    public static void processKeysMessageBox() {
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos() || ArrayHandler.PMInput_isPressed(4)) {
            switch (m_postMessageBox) {
                default: {
                    break;
                }
                case 0: {
                    StateInGame.stateTransition(5);
                    break;
                }
                case 8: {
                    StateInGame.stateTransition(7);
                    StateInGame.stateTransitionBuildMode(2);
                    break;
                }
                case 1: {
                    StateInGame.gotoMap();
                    break;
                }
                case 2: {
                    if (StateInGame.getPlayerSim().getSimAction() == 183) {
                        StateInGame.getPlayerSim().interrupt();
                    }
                    StateInGame.stateTransition(5);
                    break;
                }
                case 3: {
                    Event.triggerEvent(5, -1, -1, 946, -1);
                    break;
                }
                case 5: {
                    Event.triggerEvent(8, -1, -1, -1, -1);
                    break;
                }
                case 4: {
                    Event.triggerEvent(6, -1, -1, 495, -1);
                    break;
                }
                case 6: {
                    StateInGame.showTutorialMessage((byte)30, 1030, 1029);
                    if (m_tutorialMessageActive) break;
                    StateInGame.stateTransition(5);
                    break;
                }
                case 7: {
                    StateInGame.showTutorialMessage((byte)29, 1028, 1027);
                    if (m_tutorialMessageActive) break;
                    StateInGame.stateTransition(5);
                }
            }
        }
    }

    public static boolean isCurtainActive() {
        return m_curtainState != 0;
    }

    public static void startCurtainIn() {
        StateInGame.hideMenus();
        m_curtainPlayerAction = m_playerSim.getSimAction();
        StateInGame.stateTransitionCurtain(1);
    }

    public static void startCurtainOut() {
        StateInGame.hideMenus();
        StateInGame.stateTransitionCurtain(2);
    }

    public static void stateTransitionCurtain(int n) {
        ArrayOptimizer.Touch_clear();
        m_curtainState = n;
        switch (n) {
            default: {
                break;
            }
            case 0: {
                m_curtainTime = 0;
                break;
            }
            case 1: {
                Main.m_simData.delayAlerts();
                m_curtainTime = 0;
                break;
            }
            case 2: {
                m_curtainTime = 1000;
                break;
            }
            case 3: {
                m_curtainTime = 1000;
            }
        }
        StateInGame.setupSoftkeys();
    }

    public static void updateCurtain(int n) {
        if (!m_cameraAtDest) {
            return;
        }
        switch (m_curtainState) {
            default: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                Main.m_simData.delayAlerts();
                if (m_curtainTime == 1000) {
                    StateInGame.stateTransitionCurtain(2);
                    StateInGame.doCurtainInUpdate();
                    break;
                }
                m_curtainTime = Math.min(m_curtainTime + n, 1000);
                if (!ArrayHandler.PMInput_isPressed(4)) break;
                m_curtainTime = 1000;
                break;
            }
            case 2: {
                Main.m_simData.delayAlerts();
                if ((m_curtainTime += n) < 1500) break;
                StateInGame.stateTransitionCurtain(3);
                break;
            }
            case 3: {
                Main.m_simData.delayAlerts();
                if (m_curtainTime == 0) {
                    StateInGame.stateTransitionCurtain(0);
                    StateInGame.doCurtainOutUpdate();
                    break;
                }
                m_curtainTime = Math.max(m_curtainTime - n, 0);
                if (!ArrayHandler.PMInput_isPressed(4)) break;
                m_curtainTime = 0;
            }
        }
    }

    public static void doCurtainInUpdate() {
        switch (m_curtainPlayerAction) {
            default: {
                break;
            }
            case 183: {
                Main.m_simData.removeActiveBuff(3);
                Main.m_simData.updateSkipWorking();
                StateInGame.cancelWorkMessages();
                m_playerSim.endSimPhase();
                break;
            }
            case 128: {
                Main.m_simData.updateSkipSleeping(StateInGame.getPlayerSim().getFeedbackTime() - 15);
                break;
            }
            case 6: {
                boolean bl = false;
                boolean bl2 = false;
                if (StateInGame.isHouseMode()) {
                    if (Main.m_simWorld.m_houseId == 0) {
                        bl = true;
                    } else {
                        Main.setNextHouseId(0);
                        GlobalConstants.PMStateManager_set(0, 96);
                    }
                } else if (StateInGame.isZoomMapMode() && Main.m_nextZoomMapId != 84) {
                    bl = true;
                    bl2 = true;
                } else {
                    passedOut = true;
                    Main.setNextHouseId(0);
                    GlobalConstants.PMStateManager_set(0, 96);
                }
                if (!bl) break;
                StateInGame.putSimInBed(m_playerSim);
                m_timeHit = 120;
                Main.m_simData.delayAlerts();
                MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
                for (int i = 0; i < mapObjectSimArray.length; ++i) {
                    MapObjectSim mapObjectSim = mapObjectSimArray[i];
                    if (mapObjectSim != null && mapObjectSim.equals(m_playerSim)) continue;
                    if (!bl2 && Main.m_simData.getSimHome(mapObjectSim.getId()) != 0) {
                        mapObjectSim.destroy();
                        continue;
                    }
                    mapObjectSim.beginSimAction(0, null);
                }
            }
        }
    }

    public static void doCurtainOutUpdate() {
        switch (m_curtainPlayerAction) {
            case 183: {
                StateInGame.finishWork();
                break;
            }
            default: {
                Main.m_simData.delayAlerts();
            }
        }
    }

    public static void renderCurtain() {
        if (!m_cameraAtDest) {
            return;
        }
        int n = Math.min(m_curtainTime, 1000);
        int n2 = (n * m_viewportHeight / 1000 >> 1) + 1;
        ArrayOptimizer.PMGraphics_setColor(0);
        ArrayOptimizer.PMGraphics_fillRect(m_viewportX, m_viewportY, m_viewportWidth, n2);
        ArrayOptimizer.PMGraphics_fillRect(m_viewportX, m_viewportY + m_viewportHeight - n2, m_viewportWidth, n2);
    }

    public static void showTickerMessage(int n, int n2) {
        m_tickerString1 = (short)n;
        m_tickerString2 = (short)n2;
        m_tickerTimer = 0;
        m_tickerOffsetF = 0;
        m_tickerLengthF = (AnimationManager.TextHandler_getStringWidth(n, 0) << 16) + 327680;
        if (n2 != -1) {
            m_tickerLengthF += 5 + AnimationManager.TextHandler_getStringWidth(n2, 0) << 16;
        }
    }

    public static void cancelTickerMessage(int n) {
        if (m_tickerString1 == n) {
            m_tickerString1 = (short)-1;
        }
    }

    public static boolean isShowingTickerMessage() {
        return m_tickerString1 != -1;
    }

    public static void updateTicker(int n) {
        if (m_tickerString1 != -1 && (m_tickerTimer += n) > 2000) {
            if (m_tickerOffsetF > m_tickerLengthF) {
                m_tickerString1 = (short)-1;
                m_tickerString2 = (short)-1;
                if (m_contextMenuActive && m_contextMenuItems[3] != 0) {
                    int n2 = 5 + m_contextMenuItems[2];
                    contextMenuPreviousAction = m_contextMenuItems[n2];
                    contextMenuIsTainted = true;
                    MapObject mapObject = m_contextMenuObject;
                    StateInGame.hideContextMenu();
                    StateInGame.showContextMenu(mapObject);
                    mapObject = null;
                }
            } else {
                m_tickerOffsetF += n * 3276;
            }
        }
    }

    public static void renderTicker() {
        int n = AnimationManager.getAnimFrameHeight(747, 0);
        int n2 = 245 - m_hudBottomHeight - n;
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 747, 0, 0);
        int n3 = 0 + m_tempInt10[0] + 5;
        int n4 = n2 + m_tempInt10[1];
        AnimationManager.drawAnimFrame(747, 0, 0, n2);
        if (m_tickerTimer < 1000 && (m_tickerTimer & 0x1FF) > 255) {
            return;
        }
        int n5 = n3 - (m_tickerOffsetF >> 16);
        AnimationManager.TextHandler_drawString(m_tickerString1, 0, n5, n4, 20);
        if (m_tickerString2 != -1) {
            int n6 = AnimationManager.TextHandler_getStringWidth(m_tickerString1, 0);
            int n7 = n5 + n6 + 5;
            AnimationManager.TextHandler_drawString(m_tickerString2, 0, n7, n4, 20);
        }
    }

    public static void calcCameraDest() {
        int n;
        int n2 = Cursor.m_cursorDestX;
        int n3 = Cursor.m_cursorDestZ;
        if (m_cameraFollowTarget != null) {
            m_cameraFollowTarget.getHotSpot(m_tempInt10);
            n2 = m_tempInt10[0];
            n3 = m_tempInt10[1];
        } else if (m_contextMenuActive || Main.m_simData.getLastNPC() != -1) {
            MapObject mapObject = m_contextMenuObject;
            if (mapObject == null && Cursor.m_cursorObject != null && Cursor.m_cursorObject.getFlag(16384) && ((MapObjectSim)Cursor.m_cursorObject).getId() == Main.m_simData.getLastNPC()) {
                mapObject = Cursor.m_cursorObject;
            }
            if (mapObject != null) {
                n = m_viewportWidth << 14;
                n2 = mapObject.getFlag(16384) ? (n2 -= n) : (n2 += n);
            }
        }
        int n4 = Main.m_simWorld.m_viewportWidth;
        n = n4 >> 1;
        int n5 = Main.m_simWorld.m_viewportHeight;
        int n6 = n5 >> 1;
        int n7 = n << 16;
        int n8 = Main.m_simWorld.m_tileMap.getWidth() * Main.m_simWorld.m_tileMap.getTileSizeX() - n - 1 << 16;
        int n9 = n6 << 16;
        int n10 = Main.m_simWorld.m_tileMap.getHeight() * Main.m_simWorld.m_tileMap.getTileSizeY() - n6 - 1 << 16;
        n2 = Camera.MathExt_clip(n2, n7, n8);
        n3 = Camera.MathExt_clip(n3, n9, n10);
        m_cameraDestX = n2;
        m_cameraDestZ = n3;
    }

    public static void setCameraFollow(MapObject mapObject) {
        if (!m_contextMenuActive && !m_quickLinksActive) {
            m_cameraFollowTarget = mapObject;
            Cursor.m_cursorObject = null;
            if (mapObject == null) {
                m_cameraFollowTargetReturn = true;
            }
        }
    }

    public static void clearCameraFollow() {
        m_cameraFollowTarget = null;
        m_cameraFollowTargetReturn = false;
    }

    public static MapObject getCameraFollow() {
        return m_cameraFollowTarget;
    }

    public static void updateCamera(int n) {
        boolean bl;
        boolean bl2;
        int n2 = Main.m_simWorld.m_cameraPosX;
        int n3 = Main.m_simWorld.m_cameraPosZ;
        if (m_isCursorOnMove) {
            if (cursorScrollX == 0 && cursorScrollZ == 0) {
                return;
            }
            int n4 = n2 + cursorScrollX;
            int n5 = n3 + cursorScrollZ;
            int n6 = Main.m_simWorld.m_viewportWidth;
            int n7 = n6 >> 1;
            int n8 = Main.m_simWorld.m_viewportHeight;
            int n9 = n8 >> 1;
            int n10 = n7 << 16;
            int n11 = Main.m_simWorld.m_tileMap.getWidth() * Main.m_simWorld.m_tileMap.getTileSizeX() - n7 - 1 << 16;
            int n12 = n9 << 16;
            int n13 = Main.m_simWorld.m_tileMap.getHeight() * Main.m_simWorld.m_tileMap.getTileSizeY() - n9 - 1 << 16;
            n4 = Camera.MathExt_clip(n4, n10, n11);
            n5 = Camera.MathExt_clip(n5, n12, n13);
            Main.m_simWorld.m_cameraPosX = n4;
            Main.m_simWorld.m_cameraPosZ = n5;
            Cursor.m_cursorPosX += n4 - n2;
            Cursor.m_cursorPosZ += n5 - n3;
            return;
        }
        if (Debug.CAMERA_MODE) {
            StateInGame.updateCameraControl(n);
            return;
        }
        int n14 = 17301;
        int n15 = 1441;
        int n16 = 49;
        if (m_quickLinksActive) {
            n14 = Camera.MathExt_Fmul(n14, 196608);
            n16 = Camera.MathExt_Fmul(n16, 196608);
        }
        StateInGame.calcCameraDest();
        int n17 = Camera.MathExt_sign(m_cameraDestX - n2);
        int n18 = Camera.MathExt_sign(m_cameraDestZ - n3);
        if (n17 > 0 && m_cameraLastVelX > 0) {
            m_cameraVelX += n16 * n;
        } else if (n17 > 0 && m_cameraLastVelX <= 0) {
            m_cameraVelX = n15;
        } else if (n17 < 0 && m_cameraLastVelX < 0) {
            m_cameraVelX -= n16 * n;
        } else if (n17 < 0 && m_cameraLastVelX >= 0) {
            m_cameraVelX = -n15;
        } else if (n17 == 0 && m_cameraLastVelX > 0) {
            m_cameraVelX = -n15;
        } else if (n17 == 0 && m_cameraLastVelX < 0) {
            m_cameraVelX = n15;
        }
        if (m_cameraVelX < -n14) {
            m_cameraVelX = -n14;
        }
        if (m_cameraVelX > n14) {
            m_cameraVelX = n14;
        }
        if (n18 > 0 && m_cameraLastVelZ > 0) {
            m_cameraVelZ += n16 * n;
        } else if (n18 > 0 && m_cameraLastVelZ <= 0) {
            m_cameraVelZ = n15;
        } else if (n18 < 0 && m_cameraLastVelZ < 0) {
            m_cameraVelZ -= n16 * n;
        } else if (n18 < 0 && m_cameraLastVelZ >= 0) {
            m_cameraVelZ = -n15;
        } else if (n18 == 0 && m_cameraLastVelZ > 0) {
            m_cameraVelZ = -n15;
        } else if (n18 == 0 && m_cameraLastVelZ < 0) {
            m_cameraVelZ = n15;
        }
        if (m_cameraVelZ < -n14) {
            m_cameraVelZ = -n14;
        }
        if (m_cameraVelZ > n14) {
            m_cameraVelZ = n14;
        }
        int n19 = n2 + m_cameraVelX * n;
        int n20 = n3 + m_cameraVelZ * n;
        if (m_cameraVelX > 0 && n19 > m_cameraDestX || m_cameraVelX < 0 && n19 < m_cameraDestX) {
            bl2 = true;
            n19 = m_cameraDestX;
        } else {
            boolean bl3 = bl2 = n19 == m_cameraDestX;
        }
        if (m_cameraVelZ > 0 && n20 > m_cameraDestZ || m_cameraVelZ < 0 && n20 < m_cameraDestZ) {
            bl = true;
            n20 = m_cameraDestZ;
        } else {
            bl = n20 == m_cameraDestZ;
        }
        m_cameraLastVelX = m_cameraVelX;
        m_cameraLastVelZ = m_cameraVelZ;
        Main.m_simWorld.m_cameraPosX = n19;
        Main.m_simWorld.m_cameraPosZ = n20;
        boolean bl4 = m_cameraAtDest = bl2 && bl;
        if (m_cameraFollowTarget != null || m_cameraFollowTargetReturn) {
            Cursor.m_cursorPosX += n19 - n2;
            Cursor.m_cursorPosZ += n20 - n3;
        }
    }

    public static void snapCameraPosition() {
        StateInGame.calcCameraDest();
        Main.m_simWorld.m_cameraPosX = m_cameraDestX;
        Main.m_simWorld.m_cameraPosZ = m_cameraDestZ;
        m_cameraAtDest = true;
    }

    public static void snapCameraAndCursor(MapObject mapObject) {
        Cursor.setCursorObject(mapObject);
        Cursor.m_cursorPosX = Cursor.m_cursorDestX;
        Cursor.m_cursorPosZ = Cursor.m_cursorDestZ;
        StateInGame.snapCameraPosition();
    }

    public static void updateCameraControl(int n) {
        int n2 = n * ((m_keyCameraRight ? 6553 : 0) + (m_keyCameraLeft ? -6553 : 0));
        int n3 = n * ((m_keyCameraDown ? 6553 : 0) + (m_keyCameraUp ? -6553 : 0));
        Main.m_simWorld.m_cameraPosX += n2;
        Main.m_simWorld.m_cameraPosZ += n3;
    }

    public static void initHouseMap() {
        Main.m_simWorld.prepareWorldHouse(Main.getNextHouseId());
        if (m_initialState == 96 || passedOut) {
            passedOut = false;
            m_initialState = 5;
            StateInGame.putSimInBed(m_playerSim);
            m_timeHit = 120;
            Main.m_simData.delayAlerts();
            StateInGame.startCurtainOut();
        }
    }

    public static void initMacroMap() {
        Main.setNextZoomMapId(-1);
        Main.m_simWorld.prepareWorldMacromap();
        m_playerSim.setFlag(1);
    }

    public static void initZoomMap() {
        boolean bl = false;
        if (m_initialState == 99) {
            Main.m_simData.setLastNPC(-1);
            Main.m_encounterNPCId = -1;
            StateInGame.hideMenus();
            Cursor.hide = true;
            m_initialState = 5;
            bl = true;
            switch (Main.m_simData.d_simCareers[0]) {
                case 0: {
                    Main.m_nextZoomMapId = 79;
                    break;
                }
                case 2: {
                    Main.m_nextZoomMapId = 80;
                    break;
                }
                case 1: {
                    Main.m_nextZoomMapId = 81;
                    break;
                }
                case 3: {
                    Main.m_nextZoomMapId = 82;
                    break;
                }
            }
        }
        Main.m_simWorld.prepareWorldZoomMap(Main.getNextZoomMapId(), bl);
    }

    public static MapObject[] getObjects() {
        if (m_refreshObjects) {
            m_refreshObjects = false;
            if (m_objects == null || m_objects.length != m_objectStack.size()) {
                m_objects = null;
                m_objects = new MapObject[m_objectStack.size()];
            }
            m_objectStack.copyInto(m_objects);
        }
        return m_objects;
    }

    public static MapObjectSim[] getSimObjects() {
        if (m_refreshObjectsSims) {
            m_refreshObjectsSims = false;
            MapObject[] mapObjectArray = StateInGame.getObjects();
            int n = 0;
            for (int i = 0; i < mapObjectArray.length; ++i) {
                if (!mapObjectArray[i].getFlag(16384)) continue;
                ++n;
            }
            MapObjectSim[] mapObjectSimArray = m_objectsSims;
            if (mapObjectSimArray == null || mapObjectSimArray.length != n) {
                m_objectsSims = null;
                mapObjectSimArray = null;
                m_objectsSims = mapObjectSimArray = new MapObjectSim[n];
            }
            int n2 = 0;
            for (int i = 0; i < mapObjectArray.length; ++i) {
                if (!mapObjectArray[i].getFlag(16384)) continue;
                mapObjectSimArray[n2] = (MapObjectSim)mapObjectArray[i];
                ++n2;
            }
        }
        return m_objectsSims;
    }

    public static MapObjectSim getPlayerSim() {
        return m_playerSim;
    }

    public static MapObject findRandomObjectByType(int n) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n2 = Main.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n3 = (n2 + i) % mapObjectArray.length;
            MapObject mapObject = mapObjectArray[n3];
            if (mapObject.getType() != n) continue;
            return mapObject;
        }
        return null;
    }

    public static MapObject findObjectByParentTypeNearest(int n, int n2, int n3) {
        MapObject mapObject = null;
        int n4 = -1;
        MapObject[] mapObjectArray = StateInGame.getObjects();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n5;
            MapObject mapObject2 = mapObjectArray[i];
            if (mapObject2.getParentType() != n || (n5 = Math.abs(n2 - mapObject2.getPosX()) + Math.abs(n3 - mapObject2.getPosZ())) >= n4 && mapObject != null) continue;
            n4 = n5;
            mapObject = mapObject2;
        }
        return mapObject;
    }

    public static boolean isObjectAt(int n, int n2, int n3) {
        int n4 = Main.m_simWorld.coordWorldToWorldTileX(n2);
        int n5 = Main.m_simWorld.coordWorldToWorldTileX(n3);
        MapObject[] mapObjectArray = StateInGame.getObjects();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[i];
            if (mapObject.getParentType() != n) continue;
            int n6 = Main.m_simWorld.coordWorldToWorldTileX(mapObject.getPosX());
            int n7 = Main.m_simWorld.coordWorldToWorldTileZ(mapObject.getPosZ());
            if (n6 != n4 || n7 != n5) continue;
            return true;
        }
        return false;
    }

    public static MapObject findRandomObjectByParentType(int n) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n2 = Main.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n3 = (n2 + i) % mapObjectArray.length;
            MapObject mapObject = mapObjectArray[n3];
            if (mapObject.getParentType() != n) continue;
            return mapObject;
        }
        return null;
    }

    public static MapObject findRandomNeedObject(int n, boolean bl) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n2 = Main.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n3 = (n2 + i) % mapObjectArray.length;
            MapObject mapObject = mapObjectArray[n3];
            int n4 = mapObject.getType();
            boolean bl2 = false;
            if ((Main.m_simWorld.d_objectNeeds[n4] & n) == 0 || mapObject.getRuntimeFlag(768)) continue;
            bl2 = mapObject.occupiedIsAnyAvailable();
            if (bl) {
                bl2 = mapObject.occupiedIsEmpty();
            }
            if (!bl2) continue;
            return mapObject;
        }
        return null;
    }

    public static MapObjectSim findSim(int n) {
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        int n2 = mapObjectSimArray.length;
        for (int i = 0; i < n2; ++i) {
            MapObjectSim mapObjectSim = mapObjectSimArray[i];
            if (mapObjectSim.getId() != n) continue;
            return mapObjectSim;
        }
        return null;
    }

    public static MapObject createObject(int n, int n2, int n3, int n4, int n5) {
        int n6 = Main.m_simWorld.d_objectFlags[n];
        if (StateInGame.isZoomMapMode() && (n == 2 || n == 3)) {
            n6 |= 0x2000;
        }
        MapObject mapObject = null;
        if ((n6 & 0x4000) != 0) {
            mapObject = new MapObjectSim();
            if (n == 0) {
                m_playerSim = mapObject;
            }
        } else if ((n6 & 0x2000) != 0) {
            mapObject = new MapObject();
        }
        if (mapObject != null) {
            mapObject.init(n, n2, n3, n4, n5);
            StateInGame.addObject(mapObject);
            if (mapObject.getFlag(16384)) {
                StateInGame.loadNewSim((MapObjectSim)mapObject);
            }
            if (mapObject.getParentType() == 11) {
                mapObject.setZSortOffset(-3);
            }
        }
        return mapObject;
    }

    public static MapObject createObjectOnObjectInterestPoint(int n, MapObject mapObject, int n2) {
        int n3 = 0;
        do {
            mapObject.getInterestPoint(m_tempInt10, n3);
            ++n3;
        } while (!Main.m_simWorld.isWorldPointWalkable(m_tempInt10[0], m_tempInt10[1]));
        return StateInGame.createObject(n, m_tempInt10[0], m_tempInt10[1], 0, n2);
    }

    public static MapObject createObjectOnWorldTile(int n, int n2, int n3, int n4, int n5) {
        int n6 = Main.m_simWorld.coordWorldTileToWorldCenterX(n2);
        int n7 = Main.m_simWorld.coordWorldTileToWorldCenterZ(n3);
        return StateInGame.createObject(n, n6, n7, n4, n5);
    }

    public static void createEffectAnim(int n, int n2, int n3, int n4) {
        MapObject mapObject = StateInGame.createObject(5, n, n2, 3, -1);
        if (mapObject != null) {
            mapObject.effectPlayAnim(n3, n4);
        }
    }

    public static void createEffectMoney(int n, int n2, int n3) {
        MapObject mapObject = StateInGame.createObject(6, n, n2, 3, -1);
        if (mapObject != null) {
            mapObject.effectShowMoney(n3);
        }
    }

    public static void addObject(MapObject mapObject) {
        mapObject.applyFootprint(true);
        m_objectStack.addElement(mapObject);
        m_refreshObjects = true;
        if (mapObject.getFlag(16384)) {
            m_refreshObjectsSims = true;
        }
    }

    public static void removeObject(MapObject mapObject) {
        if (Cursor.m_cursorObject != null && Cursor.m_cursorObject.equals(mapObject)) {
            Cursor.setCursorObject(null);
        }
        if (m_contextMenuActive && m_contextMenuObject != null && m_contextMenuObject.equals(mapObject)) {
            StateInGame.hideContextMenu();
        }
        int n = -1;
        if (mapObject.getFlag(16384)) {
            n = mapObject.getId();
        }
        mapObject.applyFootprint(false);
        m_objectStack.removeElement(mapObject);
        m_refreshObjects = true;
        if (n != -1) {
            m_refreshObjectsSims = true;
            int n2 = ArrayHandler.indexOf(n, m_loadedSims);
            if (n2 != -1) {
                int n3 = Main.m_simData.getSimAttribute(n, 0) == 0 ? 256 : 128;
                Main.unloadAllImages(n3 |= 0x800, n2);
                StateInGame.m_loadedSims[n2] = -1;
                GlobalConstants.PMDebug_println(2, "Unloaded sim with id = {0}, bank = {1}", n, n2);
            }
        }
    }

    public static void updateObjects(int n) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        if (mapObjectArray != null) {
            for (int i = 0; i < mapObjectArray.length; ++i) {
                MapObject mapObject = mapObjectArray[i];
                mapObject.update(n);
            }
        }
    }

    public static void updateObjectTypes(int n, int n2) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        if (mapObjectArray != null) {
            for (int i = 0; i < mapObjectArray.length; ++i) {
                MapObject mapObject = mapObjectArray[i];
                if (mapObject.getType() != n2) continue;
                mapObject.update(n);
            }
        }
    }

    public static void removeBuildPoints() {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[i];
            if (!mapObject.getFlag(4)) continue;
            mapObject.destroy();
        }
    }

    public static MapObject getContextMenuObject() {
        return m_contextMenuObject;
    }

    public static void showContextMenu(MapObject mapObject) {
        if (m_shortcutMenuActive) {
            StateInGame.hideShortcutMenu();
        }
        Cursor.stopCursor();
        short[] sArray = m_contextMenuItems;
        short[] sArray2 = m_contextMenuActions;
        Main.m_simData.setLastNPC(-1);
        m_contextMenuActive = true;
        m_contextMenuOnSubMenu = false;
        m_contextMenuBackCursor = (short)-1;
        m_contextMenuObject = mapObject;
        if (m_state == 7) {
            mapObject.createBuildContextMenu(sArray);
            sArray[4] = m_maxContextMenuItems;
            Main.menuCopy(sArray2, sArray);
        } else {
            int n = ArrayHandler.indexOf(m_contextMenuObject, m_actionQueueArg1s);
            int n2 = n > -1 ? m_actionQueueActions[n] : -1;
            if (n != -1 && n2 != 2) {
                int n3 = m_contextMenuObject.getFlag(16384) ? Main.m_simData.getSimName(m_contextMenuObject.getId()) : m_contextMenuObject.getTypeString();
                Main.menuClear(sArray, n3);
                Main.menuClear(sArray2, n3);
                Main.menuAppendItem(sArray, 794);
                Main.menuAppendItem(sArray2, -3);
            } else {
                Main.m_simData.createContextMenu(m_contextMenuObject, sArray, sArray2);
            }
            Main.menuCopy(m_contextMenuFullActions, sArray2);
            if (sArray[0] > m_maxContextMenuItems) {
                Main.m_simData.compactContextMenu(sArray, sArray2, m_contextMenuFullActions);
            }
            sArray[4] = m_maxContextMenuItems;
        }
        StateInGame.setupSoftkeys();
    }

    public static void hideContextMenu() {
        AnimationManager.TextHandler_resetScrollers();
        m_contextMenuActive = false;
        m_contextMenuOnSubMenu = false;
        m_contextMenuBackCursor = (short)-1;
        m_contextMenuObject = null;
        StateInGame.setupSoftkeys();
        Cursor.setCursorObject(Cursor.m_cursorObject);
    }

    public static void renderContextMenu() {
        boolean bl = m_contextMenuObject != null && m_contextMenuObject.getFlag(16384);
        int n = bl ? 2 : 4;
        Debug.UserInterface_drawGenericMenu(m_contextMenuItems, n);
    }

    public static int getSimContext() {
        if (!m_suppressMenus && m_contextMenuActive) {
            if (m_contextMenuObject != null && m_contextMenuObject.getFlag(16384)) {
                return ((MapObjectSim)m_contextMenuObject).getId();
            }
        } else if (Main.m_simData.isLastNPCStillRelevant()) {
            return Main.m_simData.getLastNPC();
        }
        return -1;
    }

    public static void renderContextRelationships() {
        boolean bl;
        int n = StateInGame.getSimContext();
        boolean bl2 = bl = !m_contextMenuActive || m_suppressMenus;
        if (!m_suppressMenus && m_contextMenuActive) {
            if (m_contextMenuObject != null && m_contextMenuObject.getFlag(16384)) {
                n = ((MapObjectSim)m_contextMenuObject).getId();
            }
        } else if (Main.m_simData.isLastNPCStillRelevant()) {
            bl = true;
            n = Main.m_simData.getLastNPC();
        }
        if (n != -1) {
            int n2;
            Main.m_simData.getRelationshipLevels(n, m_tempInt10);
            int n3 = (m_tempInt10[0] != -1 ? 1 : 0) + (m_tempInt10[2] != -1 ? 1 : 0);
            int n4 = m_viewportX + 3;
            int n5 = AnimationManager.getAnimFrameHeight(747, 0);
            int n6 = 245 - m_hudBottomHeight;
            int n7 = n6 - 18 * (n3 + 1);
            if (m_tickerString1 != -1) {
                n7 -= n5;
            }
            int n8 = n7;
            relationshipBarY = n7;
            int n9 = Main.m_simData.getRelState(n);
            StateInGame.drawRelBar(15, n4, n8, 120, n9, 65536, true);
            n8 += 18;
            for (n2 = 0; n2 < 4 && (n9 = m_tempInt10[n2]) != -1; n2 += 2) {
                int n10 = m_tempInt10[n2 + 1];
                StateInGame.drawRelBar(15 + (n2 + 1), n4, n8, 120, n9, n10, false);
                n8 += 18;
            }
            if (bl) {
                n2 = -1;
                MapObjectSim mapObjectSim = StateInGame.getPlayerSim().getSimActionArg1Sim();
                if (mapObjectSim != null && mapObjectSim.getId() == n) {
                    n2 = Main.m_simData.d_actionStringIds[StateInGame.getPlayerSim().getSimAction()];
                }
                if (n2 == 557) {
                    n2 = -1;
                }
                int n11 = n7 - 14 - 4 - (n2 != -1 ? 12 : 0);
                int n12 = n11 + 7;
                AnimationManager.setColor(47);
                ArrayOptimizer.PMGraphics_fillRect(n4, n11, 120, 14);
                AnimationManager.setColor(48);
                ArrayOptimizer.PMGraphics_drawRect(n4, n11, 120, 14);
                AnimationManager.TextHandler_drawString(Main.m_simData.getSimName(n), 0, n4 + 60, n12, 3);
                if (n2 != -1) {
                    int n13 = n11 + 14;
                    AnimationManager.setColor(47);
                    ArrayOptimizer.PMGraphics_fillRect(n4, n13, 120, 12);
                    AnimationManager.setColor(48);
                    ArrayOptimizer.PMGraphics_drawRect(n4, n13, 120, 12);
                    AnimationManager.TextHandler_renderScroller(9, n2, 1, n4 + 2, n13 + 2, 116, 17);
                }
            }
        }
    }

    public static void processKeysContextMenu() {
        if (Main.softPressNeg()) {
            StateInGame.resetPlayerInactivity();
            if (m_contextMenuOnSubMenu) {
                Main.m_simData.compactContextMenu(m_contextMenuItems, m_contextMenuActions, m_contextMenuFullActions);
                StateInGame.m_contextMenuItems[4] = m_maxContextMenuItems;
                m_contextMenuOnSubMenu = false;
                StateInGame.m_contextMenuItems[2] = m_contextMenuBackCursor;
                Main.menuVisible(m_contextMenuItems);
            } else {
                StateInGame.hideContextMenu();
            }
        } else if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            int n = 5 + m_contextMenuItems[2];
            if (m_state == 7) {
                StateInGame.processBasicAction(m_contextMenuItems[n]);
            } else {
                short s = m_contextMenuActions[n];
                if (s == -4) {
                    StateInGame.hideContextMenu();
                } else if (s == -3) {
                    StateInGame.processCancelAction(m_contextMenuObject);
                    StateInGame.hideContextMenu();
                } else if (s == -2) {
                    m_contextMenuBackCursor = m_contextMenuItems[2];
                    m_contextMenuOnSubMenu = true;
                    short s2 = m_contextMenuItems[n];
                    Main.m_simData.filterContextMenu(m_contextMenuItems, m_contextMenuActions, m_contextMenuFullActions, s2);
                    StateInGame.m_contextMenuItems[4] = m_maxContextMenuItems;
                } else if (s == 144 || s == 143) {
                    StateInGame.processCallAction();
                } else if (s == 119) {
                    StateInGame.processPlantAction();
                } else if (s == 133) {
                    StateInGame.processCookAction();
                } else {
                    StateInGame.hideMenus();
                    StateInGame.processSimAction(s, Cursor.m_cursorObject, 0, 0);
                }
            }
        } else {
            Main.menuCursorUpDown(m_contextMenuItems);
        }
    }

    public static void stateTransitionPauseMenu(int n) {
        m_pauseMenuState = n;
        switch (n) {
            default: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                Debug.UserInterface_prepareGenericMessageBox(760, 759);
                break;
            }
            case 2: {
                Debug.UserInterface_prepareGenericMessageBox(782, 787);
                break;
            }
            case 3: {
                Debug.UserInterface_prepareGenericMessageBox(786, 787);
                break;
            }
            case 4: {
                Debug.UserInterface_prepareGenericMessageBox(784, 787);
            }
            case 5: 
        }
        StateInGame.setupSoftkeys();
    }

    public static void showPauseMenu() {
        if (m_contextMenuActive) {
            StateInGame.hideContextMenu();
        }
        if (m_shortcutMenuActive) {
            StateInGame.hideShortcutMenu();
        }
        Cursor.stopCursor();
        PMAudio.stopAll();
        m_pauseMenuActive = true;
        m_pauseMenuState = 0;
        StateInGame.m_pauseMenuItems[2] = 0;
        StateInGame.setupSoftkeys();
    }

    public static void hidePauseMenu() {
        m_pauseMenuActive = false;
        StateInGame.setupSoftkeys();
    }

    public static void processKeysPauseMenu() {
        if (Intro.StateMenu_m_sharedMenuState != -1) {
            Intro.StateMenu_processKeysSharedMenu();
            return;
        }
        switch (m_pauseMenuState) {
            case 0: {
                if (Main.softPressNeg()) {
                    StateInGame.hidePauseMenu();
                    break;
                }
                if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
                    int n = 5 + m_pauseMenuItems[2];
                    StateInGame.processBasicAction(m_pauseMenuItems[n]);
                    break;
                }
                Main.menuCursorUpDown(m_pauseMenuItems);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
                    if (m_pauseMenuState != 1) {
                        ArrayHandler.Rms_saveRMSAppSettings();
                        ArrayHandler.Rms_saveRMSGameData();
                    }
                    if (m_pauseMenuState != 2) {
                        StateInGame.changeSceneWithFade(1, -1);
                        break;
                    }
                    StateInGame.hidePauseMenu();
                    break;
                }
                if (!Main.softPressNeg()) break;
                StateInGame.stateTransitionPauseMenu(0);
                break;
            }
            case 4: {
                if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
                    ArrayHandler.Rms_saveRMSAppSettings();
                    ArrayHandler.Rms_saveRMSGameData();
                    StateInGame.fadeStateTransition(4);
                    break;
                }
                if (!Main.softPressNeg()) break;
                StateInGame.stateTransitionPauseMenu(0);
                break;
            }
            case 5: {
                break;
            }
            default: {
                Debug.ASSERT(false, "invalid state");
            }
        }
    }

    public static void renderPauseMenu() {
        Event.PostEffects_renderBackgroundDim();
        int n = m_pauseMenuState;
        if (Intro.StateMenu_m_sharedMenuState != -1) {
            Intro.StateMenu_renderSharedMenu();
        } else if (n == 0) {
            Debug.UserInterface_drawGenericMenu(m_pauseMenuItems, 1);
        } else if (n == 2 || n == 3 || n == 1 || n == 4) {
            Debug.UserInterface_drawGenericMessageBox();
        }
    }

    public static void showShortcutMenu() {
        m_shortcutByShortcutKey = false;
        if (m_contextMenuActive) {
            StateInGame.hideContextMenu();
        }
        Cursor.stopCursor();
        short[] sArray = m_shortcutMenuItems;
        m_shortcutMenuActive = true;
        Main.menuClear(sArray, 457, 17);
        if (m_actionQueueSize > 0 && StateInGame.getPlayerSim().lastInteractivityObject == null) {
            Main.menuAppendItem(sArray, 794);
        }
        if (Main.m_simData.isTimeForWork(null, 0)) {
            Main.menuAppendItem(sArray, 52);
        }
        if (StateInGame.isZoomMapMode()) {
            Main.menuAppendItem(sArray, 51);
        }
        if (StateInGame.isHouseMode()) {
            Main.menuAppendItem(sArray, 51);
            if (Main.m_simWorld.m_houseId == 0) {
                Main.menuAppendItem(sArray, 793);
            }
        }
        if (StateInGame.isMapMode()) {
            Main.menuAppendItem(sArray, 49);
            Main.menuAppendItem(sArray, 801);
        }
        Main.menuAppendItem(sArray, 802);
        Main.menuAppendItem(sArray, 795);
        Main.menuAppendItem(sArray, 803);
        Main.menuAppendItem(sArray, 797);
        Main.menuAppendItem(sArray, 804);
        Main.menuAppendItem(sArray, 800);
        Main.menuAppendItem(sArray, 799);
        StateInGame.setupSoftkeys();
    }

    public static void hideShortcutMenu() {
        m_shortcutMenuActive = false;
        StateInGame.setupSoftkeys();
    }

    public static void processKeysShortcutMenu() {
        if (Main.softPressNeg()) {
            StateInGame.hideShortcutMenu();
        } else if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            int n = m_shortcutMenuItems[2] + 5;
            StateInGame.processBasicAction(m_shortcutMenuItems[n]);
        } else {
            Main.menuCursorUpDown(m_shortcutMenuItems);
        }
    }

    public static void renderShortcutMenu() {
        Event.PostEffects_renderBackgroundDim();
        Debug.UserInterface_drawGenericMenu(m_shortcutMenuItems, 1);
    }

    public static void showQuickLinks() {
        StateInGame.clearCameraFollow();
        m_quickLinksActive = true;
        short[] sArray = m_quickLinksMenu;
        Main.menuClear(sArray, 557);
        int n = Main.m_simWorld.d_objectStringIds.length;
        for (int i = 0; i < n; ++i) {
            if (!Main.m_simData.isQuickLinkVisited(i)) continue;
            Main.menuAppendItem(sArray, i);
        }
        StateInGame.quickLinksSelect(m_quickLinksMenu[2]);
        StateInGame.setupSoftkeys();
    }

    public static void hideQuickLinks() {
        m_quickLinksActive = false;
        camOffsetZ = 0;
        StateInGame.setupSoftkeys();
    }

    public static void processKeysQuickLinks() {
        if (Main.softPressNeg()) {
            StateInGame.hideQuickLinks();
        } else if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            StateInGame.hideQuickLinks();
            Cursor.processKeysFire();
        } else if (Main.menuCursorLeftRight(m_quickLinksMenu)) {
            StateInGame.quickLinksSelect(m_quickLinksMenu[2]);
        }
        if (ArrayHandler.PMInput_isPressed(8)) {
            Debug.UserInterface_triggerLeftArrow();
        } else if (ArrayHandler.PMInput_isPressed(16)) {
            Debug.UserInterface_triggerRightArrow();
        }
    }

    public static void quickLinksSelect(int n) {
        short s = m_quickLinksMenu[5 + n];
        MapObject mapObject = StateInGame.findRandomObjectByType(s);
        Cursor.setCursorObject(mapObject);
    }

    public static void renderQuickLinks() {
        int n = AnimationManager.getAnimFrameHeight(669, 0);
        int n2 = AnimationManager.getAnimFrameHeight(692, 0);
        int n3 = m_viewportX + (m_viewportWidth >> 1);
        int n4 = m_viewportY + (n2 >> 1);
        int n5 = m_viewportY + m_viewportHeight - (n2 >> 1);
        Debug.UserInterface_drawAnimBox(m_viewportX, m_viewportY, m_viewportWidth, m_viewportHeight, 692, -1);
        AnimationManager.TextHandler_drawString(801, 0, n3, n4, 3);
        int n6 = m_quickLinksMenu[2] + 5;
        short s = m_quickLinksMenu[n6];
        MapObject mapObject = StateInGame.findRandomObjectByType(s);
        int n7 = mapObject.getTooltipStringId();
        SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendIntToBuffer(m_quickLinksMenu[2] + 1);
        AnimationManager.TextHandler_appendStringIdToBuffer(558);
        AnimationManager.TextHandler_appendStringIdToBuffer(n7);
        AnimationManager.TextHandler_drawString(sDKString, 1, n3, n5, 3);
        int n8 = n5 - (n >> 1);
        Debug.UserInterface_m_arrowLeftAnimPlayer.drawAnim(3, n8);
        Debug.UserInterface_m_arrowRightAnimPlayer.drawAnim(237, n8);
    }

    public static void renderQuickLinksMarker(int n, int n2) {
        AnimationManager.drawAnimFrame(733, 0, n, n2);
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 733, 0, 0);
        SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendIntToBuffer(m_quickLinksMenu[2] + 1);
        AnimationManager.TextHandler_drawString(sDKString, 0, n + m_tempInt10[0], n2 + m_tempInt10[1], 33);
    }

    public static void stateTransitionBuildMode(int n) {
        int n2 = 0;
        switch (n) {
            default: {
                break;
            }
            case 0: {
                StateInGame.stateTransition(5);
                break;
            }
            case 1: {
                Cursor.setCursorSelectFlags(2);
                break;
            }
            case 2: {
                if (m_buyModeState == 7 || m_buyModeState == 8 || m_buyModeState == 3 || m_buyModeState == 4 || m_buyModeState == 6 || m_buyModeState == 11 || m_buyModeState == 12) break;
                StateInGame.initListFurniture();
                break;
            }
            case 12: {
                Debug.UserInterface_prepareGenericMessageBox(504, 505);
                break;
            }
            case 11: {
                Debug.UserInterface_prepareGenericMessageBox(503, 505);
                break;
            }
            case 3: {
                Debug.UserInterface_prepareGenericMessageBox(509, 530);
                break;
            }
            case 4: {
                if (m_buyModeState == 5) break;
                Cursor.setCursorSelectFlags(4);
                Cursor.changeCursorDistanceCheck();
                break;
            }
            case 5: {
                n2 = Main.m_simWorld.d_objectStringIds[m_buyNewType];
                Debug.UserInterface_prepareGenericMessageBox(499, n2);
                break;
            }
            case 6: {
                m_stateTime = 0;
                break;
            }
            case 7: {
                n2 = Main.m_simWorld.d_objectStringIds[m_buyNewType];
                Debug.UserInterface_prepareGenericMessageBox(498, n2);
                break;
            }
            case 8: {
                n2 = Main.m_simWorld.d_objectStringIds[m_buyNewType];
                Debug.UserInterface_prepareGenericMessageBox(500, n2);
                break;
            }
            case 9: {
                n2 = Cursor.m_cursorObject.getTypeString();
                Debug.UserInterface_prepareGenericMessageBox(515, n2);
                break;
            }
            case 10: {
                m_buyNewType = Cursor.m_cursorObject.getType();
                m_buyModeObject = Cursor.m_cursorObject;
                m_buyModeObject.applyFootprint(false);
                m_buyModeObject.hide();
                Main.m_simWorld.createBuildPoints(m_buyNewType);
                Cursor.setCursorSelectFlags(4);
                Cursor.changeCursorDistanceCheck();
            }
        }
        m_buyModeState = n;
        StateInGame.setupSoftkeys();
    }

    public static void processKeysBuildMode() {
        switch (m_buyModeState) {
            default: {
                break;
            }
            case 1: {
                StateInGame.processKeysBuildModeEdit();
                break;
            }
            case 2: {
                StateInGame.processKeysBuildModeSelect();
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                if (!ArrayHandler.PMInput_isPressed(1) && !Main.softPressPos() && !Main.softPressNeg()) break;
                StateInGame.stateTransitionBuildMode(2);
                break;
            }
            case 4: 
            case 10: {
                StateInGame.processKeysBuildModePlace();
                break;
            }
            case 5: {
                StateInGame.processKeysBuildModeBuyConfirm();
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                StateInGame.processKeysBuildModeSellConfirm();
            }
        }
    }

    public static void updateBuildMode(int n) {
        switch (m_buyModeState) {
            default: {
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: {
                StateInGame.updateTicker(n);
                Cursor.updateCursor(n);
                StateInGame.updateCamera(n);
                StateInGame.updateObjectTypes(n, 6);
                if (m_buyModeState != 6 || m_stateTime <= 1500) break;
                StateInGame.stateTransitionBuildMode(2);
                break;
            }
            case 2: {
                Cursor.updateCursor(n);
            }
        }
    }

    public static void renderBuildMode() {
        switch (m_buyModeState) {
            default: {
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: {
                StateInGame.renderMain();
                break;
            }
            case 2: {
                StateInGame.renderBuyModeSelect();
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                StateInGame.renderBuyModeSelect();
                Event.PostEffects_renderBackgroundDim();
                Debug.UserInterface_drawGenericMessageBox();
                break;
            }
            case 5: 
            case 9: {
                short s;
                int n;
                short s2;
                if (m_buyModeState == 5) {
                    s2 = Main.m_simWorld.d_objectStringIds[m_buyNewType];
                    n = 159;
                    s = Main.m_simWorld.d_objectBuyPrices[m_buyNewType];
                } else {
                    s2 = Main.m_simWorld.d_objectStringIds[Cursor.m_cursorObject.getType()];
                    n = 792;
                    s = Main.m_simWorld.d_objectSellPrices[Cursor.m_cursorObject.getType()];
                }
                Debug.UserInterface_setUIPlaceholderString(1, s2);
                Debug.UserInterface_setUIPlaceholderString(2, n);
                SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
                AnimationManager.TextHandler_appendMoneyToBuffer(s);
                AnimationManager.TextHandler_dynamicString(-9, sDKString);
                Debug.UserInterface_setUIPlaceholderString(3, -9);
                StateInGame.renderMain();
                Event.PostEffects_renderBackgroundDim();
                Debug.UserInterface_drawUIFullScreen(22);
                StateInGame.renderSoftkeyBar();
            }
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void processKeysBuildModeEdit() {
        if (Main.softPressNeg()) {
            StateInGame.stateTransition(5);
        }
        Cursor.processKeysCursor();
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            Cursor.processKeysFire();
        }
    }

    public static void processKeysBuildModeSelect() {
        if (Main.softPressNeg()) {
            StateInGame.stateTransition(5);
            return;
        }
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            int n;
            int n2 = Debug.UserInterface_getListCursor();
            m_buyNewType = n = Main.m_simWorld.getFurnitureNthItem(n2);
            if (!Main.m_simWorld.isFurnitureAvailable(n)) {
                StateInGame.stateTransitionBuildMode(8);
            } else {
                short s = Main.m_simWorld.d_objectBuyPrices[m_buyNewType];
                if (Main.m_simData.getMoney() >= s) {
                    if (StateInGame.isHouseMode()) {
                        if (ArrayHandler.indexOf(-1, Main.m_simWorld.m_playerHouseObjectTypes) == -1) {
                            StateInGame.showMessageBox(1081, 793, 8);
                            return;
                        }
                        int n3 = Main.m_simWorld.createBuildPoints(m_buyNewType);
                        if (n3 > 0) {
                            StateInGame.stateTransitionBuildMode(4);
                        } else {
                            StateInGame.stateTransitionBuildMode(3);
                        }
                    } else if (Main.m_simData.placeNewFurnitureOnLawn(m_buyNewType)) {
                        StateInGame.stateTransitionBuildMode(11);
                        Main.m_simData.adjustMoney(-s, -1);
                        StateInGame.registerFurniturePurchase(s);
                    } else {
                        StateInGame.stateTransitionBuildMode(12);
                    }
                } else {
                    StateInGame.stateTransitionBuildMode(7);
                }
            }
        }
        Debug.UserInterface_processKeysList();
    }

    public static void renderBuyModeSelect() {
        int n = Main.m_simWorld.getFurnitureNthItem(Debug.UserInterface_getListCursor());
        if (!Main.m_simWorld.isFurnitureAvailable(n)) {
            Debug.UserInterface_setUIPlaceholderString(1, 521);
        } else {
            SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
            AnimationManager.TextHandler_appendMoneyToBuffer(Main.m_simWorld.d_objectBuyPrices[n]);
            AnimationManager.TextHandler_dynamicString(-9, sDKString);
            Debug.UserInterface_setUIPlaceholderString(1, -9);
        }
        Debug.UserInterface_drawUIFullScreen(26);
        StateInGame.renderSoftkeyBar();
    }

    public static void drawUIFurniturePreview(boolean bl, int[] nArray) {
        int n = nArray[2];
        int n2 = n * 3 / 5;
        if (!bl) {
            int n3 = nArray[0] + n - n2;
            int n4 = nArray[1];
            int n5 = nArray[3];
            Debug.UserInterface_drawDescBox(n3, n4, n2, n5);
            int n6 = Main.m_simWorld.getFurnitureNthItem(Debug.UserInterface_getListCursor());
            int n7 = Main.m_simWorld.d_objectAnimIds[n6];
            int n8 = Main.m_simWorld.getObjectAnimSetId(n6, 0);
            if (n7 == 359 && n8 != 0 && (n7 = Main.m_simWorld.getAnim(n8, 1)) == 359) {
                n7 = Main.m_simWorld.getAnim(n8, 2);
            }
            Debug.ASSERT(n7 != 359, "where's the anim for this furniture?");
            int n9 = AnimationManager.getAnimFrameX(n7, 0);
            int n10 = AnimationManager.getAnimFrameY(n7, 0);
            int n11 = AnimationManager.getAnimFrameWidth(n7, 0);
            int n12 = AnimationManager.getAnimFrameHeight(n7, 0);
            int n13 = n3 + (n2 >> 1) - n9 - (n11 >> 1);
            int n14 = n4 + (n5 >> 1) - n10 - (n12 >> 1);
            AnimationManager.drawAnimFrame(n7, 0, n13, n14);
        }
        nArray[2] = n - n2 - 3;
    }

    public static void initListFurniture() {
        Debug.UserInterface_initList(Main.m_simWorld.getFurnitureNthCount(), 16, 0);
    }

    public static void drawListFurniture(int n, int n2, int n3, int n4) {
        int n5 = n + 3;
        int n6 = n2;
        int n7 = Debug.UserInterface_getListCursor();
        int n8 = 0;
        for (int i = Debug.UserInterface_getListOffset(); n6 < n2 + n4 && i < Debug.UserInterface_getListNum(); ++i) {
            ArrayOptimizer.Touch_addTouchData(12 + n8, n, n6, n3, 16);
            ++n8;
            int n9 = Main.m_simWorld.getFurnitureNthItem(i);
            short s = Main.m_simWorld.d_objectStringIds[n9];
            int n10 = 1;
            if (i == n7) {
                Debug.UserInterface_drawListSelect(n, n6, n3, 16, n2 + n4, 53, i);
                n10 = 0;
            }
            AnimationManager.TextHandler_drawString(s, n10, n5, n6 + 8, 6);
            Debug.UserInterface_drawListDivider(n, n6 += 16, n3);
        }
    }

    public static void processKeysBuildModePlace() {
        Cursor.processKeysCursor();
        MapObject mapObject = m_buyModeObject;
        if (Main.softPressNeg()) {
            StateInGame.removeBuildPoints();
            if (m_buyModeState == 10) {
                StateInGame.removeBuildPoints();
                mapObject.applyFootprint(true);
                mapObject.unhide();
                m_buyModeObject = null;
                StateInGame.stateTransitionBuildMode(1);
            } else {
                StateInGame.stateTransitionBuildMode(2);
            }
        } else if ((ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) && Cursor.m_cursorObject != null) {
            if (m_buyModeState == 10) {
                MapObject mapObject2 = Cursor.m_cursorObject;
                if (mapObject2 != null) {
                    mapObject.unhide();
                    mapObject.reposition(mapObject2.getPosX(), mapObject2.getPosZ(), mapObject2.getFacingDir());
                    mapObject.applyFootprint(true);
                    Main.m_simWorld.objectChange(mapObject.getId(), mapObject2.getPosX(), mapObject2.getPosZ(), mapObject2.getFacingDir());
                    Cursor.setCursorObject(mapObject);
                    m_buyModeObject = null;
                    StateInGame.removeBuildPoints();
                    StateInGame.stateTransitionBuildMode(1);
                }
            } else {
                StateInGame.stateTransitionBuildMode(5);
            }
        }
    }

    public static void registerFurniturePurchase(int n) {
        Main.m_simData.dreamCompleteEvent(43);
        if ((amountSpentOnFurniture += n) >= 5000) {
            Main.m_simData.dreamCompleteEvent(54);
        }
    }

    public static void processKeysBuildModeBuyConfirm() {
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            MapObject mapObject = Cursor.m_cursorObject;
            if (mapObject != null) {
                int n = Main.m_simWorld.objectBuy(m_buyNewType, mapObject.getPosX(), mapObject.getPosZ(), mapObject.getFacingDir());
                short s = Main.m_simWorld.d_objectBuyPrices[m_buyNewType];
                StateInGame.createEffectMoney(mapObject.getPosX(), mapObject.getPosZ(), s);
                Main.m_simData.adjustMoney(-s, -1);
                StateInGame.removeBuildPoints();
                MapObject mapObject2 = StateInGame.createObject(m_buyNewType, mapObject.getPosX(), mapObject.getPosZ(), mapObject.getFacingDir(), n);
                Cursor.setCursorObject(mapObject2);
                StateInGame.registerFurniturePurchase(s);
                StateInGame.stateTransitionBuildMode(6);
            }
        } else if (Main.softPressNeg()) {
            StateInGame.stateTransitionBuildMode(4);
        }
    }

    public static void processKeysBuildModeSellConfirm() {
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            MapObject mapObject = Cursor.m_cursorObject;
            Debug.ASSERT(mapObject != null, "Can't sell null object");
            int n = mapObject.getType();
            Cursor.m_cursorObject.getHotSpot(m_tempInt10);
            Main.m_simWorld.objectSell(Cursor.m_cursorObject.getId());
            StateInGame.processCancelAction(Cursor.m_cursorObject);
            Cursor.m_cursorObject.destroy();
            Cursor.setCursorObject(null);
            Cursor.m_cursorSnapping = true;
            Cursor.m_cursorDestX = m_tempInt10[0];
            Cursor.m_cursorDestZ = m_tempInt10[1];
            short s = Main.m_simWorld.d_objectSellPrices[n];
            Main.m_simData.adjustMoney(s, -1);
            StateInGame.stateTransitionBuildMode(1);
        } else if (Main.softPressNeg()) {
            StateInGame.stateTransitionBuildMode(1);
        }
    }

    public static void stateTransitionInfoScreen(int n) {
        switch (n) {
            case 0: {
                if (m_infoScreenState != 9) {
                    m_infoScreenSimSelectedIndex = 0;
                }
                StateInGame.initListRelationships();
                break;
            }
            case 9: {
                m_infoScreenSimSelectedIndex = Debug.UserInterface_getListCursor();
                StateInGame.reloadInfoScreenSim();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int n2 = StateInGame.processInfoScreenStateDreams();
                AnimationManager.TextHandler_wrapString(n2, 1, Debug.UserInterface_m_uiInfoBoxWrapWidth);
                StateInGame.initListDreams();
                break;
            }
            case 4: {
                StateInGame.initListStatus();
                break;
            }
            case 5: {
                StateInGame.initListPersonaGoals();
                break;
            }
            case 6: {
                StateInGame.initListInventory();
                break;
            }
            case 10: {
                StateInGame.initListRecipe();
                break;
            }
            case 7: {
                StateInGame.stateTransition(5);
                break;
            }
            case 8: {
                StateInGame.stateTransition(5);
                StateInGame.processInfoScreenStateBack();
                break;
            }
        }
        m_infoScreenState = n;
        StateInGame.setupSoftkeys();
    }

    private static int processInfoScreenStateDreams() {
        if (Main.m_simData.getDream() == -1) {
            return 325;
        }
        if (!Main.m_simData.isDreamToPromisePossible()) {
            return 326;
        }
        return 324;
    }

    private static void processInfoScreenStateBack() {
        if (!m_shortcutByShortcutKey) {
            StateInGame.showShortcutMenu();
            int n = StateInGame.getInfoScreenBackKeyDestination();
            if (n != -1) {
                Main.menuSelectById(m_shortcutMenuItems, n);
            }
        }
    }

    private static int getInfoScreenBackKeyDestination() {
        int n;
        switch (m_infoScreenState) {
            default: {
                n = -1;
                break;
            }
            case 0: {
                n = 802;
                break;
            }
            case 1: {
                n = 795;
                break;
            }
            case 2: {
                n = 803;
                break;
            }
            case 3: {
                n = 797;
                break;
            }
            case 4: {
                n = 804;
                break;
            }
            case 5: {
                n = 800;
                break;
            }
            case 6: {
                n = 799;
            }
        }
        return n;
    }

    public static void reloadInfoScreenSim() {
        int n = StateInGame.getInfoSim();
        if (n != m_infoLoadedNPC) {
            m_infoLoadedNPC = n;
            AnimationManager.unloadImage(60, 1);
            AnimationManager.unloadImage(52, 1);
            Main.m_simWorld.getSimPatches(n, m_palSources, m_palPatches);
            if (Main.m_simData.getSimAttribute(n, 0) == 0) {
                AnimationManager.loadImage(60, m_palSources, m_palPatches, 1);
            } else {
                AnimationManager.loadImage(52, m_palSources, m_palPatches, 1);
            }
        }
    }

    public static void processKeysInfoScreen() {
        if (m_infoScreenState == 9) {
            if (Main.softPressNeg()) {
                StateInGame.stateTransitionInfoScreen(0);
                return;
            }
            int n = Main.m_simData.getRelationshipNthCount();
            if (ArrayHandler.PMInput_isPressed(8)) {
                m_infoScreenSimSelectedIndex = (m_infoScreenSimSelectedIndex + n - 1) % n;
                Debug.UserInterface_triggerLeftArrow();
                StateInGame.reloadInfoScreenSim();
            } else if (ArrayHandler.PMInput_isPressed(16)) {
                m_infoScreenSimSelectedIndex = (m_infoScreenSimSelectedIndex + 1) % n;
                Debug.UserInterface_triggerRightArrow();
                StateInGame.reloadInfoScreenSim();
            }
        } else if (m_infoScreenState == 10) {
            if (Main.softPressNeg()) {
                AnimationManager.TextHandler_resetScrollers();
                StateInGame.stateTransitionInfoScreen(6);
                return;
            }
            Debug.UserInterface_processKeysList();
        } else {
            if (Main.softPressNeg()) {
                StateInGame.stateTransitionInfoScreen(8);
                return;
            }
            switch (m_infoScreenState) {
                default: {
                    break;
                }
                case 0: {
                    Debug.UserInterface_processKeysList();
                    if (Debug.UserInterface_getListNum() <= 0 || !ArrayHandler.PMInput_isPressed(1) && !Main.softPressPos()) break;
                    relationshipArrowTimer = 0;
                    StateInGame.stateTransitionInfoScreen(9);
                    return;
                }
                case 3: {
                    Debug.UserInterface_processKeysList();
                    if (Main.m_simData.getDream() == -1 || !Main.m_simData.isDreamToPromisePossible() || !ArrayHandler.PMInput_isPressed(1) && !Main.softPressPos(8)) break;
                    Main.m_simData.dreamToPromise();
                    AnimationManager.TextHandler_wrapString(327, 1, Debug.UserInterface_m_uiInfoBoxWrapWidth);
                    Main.setSoftKeys(4, 0);
                    break;
                }
                case 4: 
                case 5: {
                    Debug.UserInterface_processKeysList();
                    break;
                }
                case 6: {
                    int n;
                    if (Debug.UserInterface_processKeysList()) {
                        StateInGame.setupSoftkeys();
                    }
                    if ((n = StateInGame.getInfoItem()) == -1 || (Main.m_simWorld.d_itemFlags[n] & 0x400) == 0 || !ArrayHandler.PMInput_isPressed(1) && !Main.softPressPos()) break;
                    StateInGame.stateTransitionInfoScreen(10);
                }
            }
            if (ArrayHandler.PMInput_isPressed(8)) {
                if (--m_infoScreenState < 0) {
                    m_infoScreenState = 6;
                }
                Debug.UserInterface_wrapStrings = true;
                Debug.UserInterface_resetTextScrollTimer = true;
                Debug.UserInterface_textOffsetTimer = 0;
                StateInGame.stateTransitionInfoScreen(m_infoScreenState);
                Debug.UserInterface_triggerLeftArrow();
            } else if (ArrayHandler.PMInput_isPressed(16)) {
                if (++m_infoScreenState > 6) {
                    m_infoScreenState = 0;
                }
                Debug.UserInterface_wrapStrings = true;
                Debug.UserInterface_resetTextScrollTimer = true;
                Debug.UserInterface_textOffsetTimer = 0;
                StateInGame.stateTransitionInfoScreen(m_infoScreenState);
                Debug.UserInterface_triggerRightArrow();
            } else if (ArrayHandler.PMInput_isPressed(32)) {
                Debug.UserInterface_wrapStrings = true;
                Debug.UserInterface_resetTextScrollTimer = true;
                Debug.UserInterface_textOffsetTimer = 0;
            } else if (ArrayHandler.PMInput_isPressed(64)) {
                Debug.UserInterface_wrapStrings = true;
                Debug.UserInterface_resetTextScrollTimer = true;
                Debug.UserInterface_textOffsetTimer = 0;
            }
        }
    }

    public static void updateInfoScreen(int n) {
        Debug.UserInterface_updateLeftRightArrows(n);
    }

    public static void renderInfoScreen() {
        switch (m_infoScreenState) {
            default: {
                break;
            }
            case 0: {
                Intro.StateMenu_page = 4;
                Debug.UserInterface_drawUIFullScreen(14);
                break;
            }
            case 1: {
                Intro.StateMenu_page = 13;
                StateInGame.renderInfoScreenCareer(false);
                break;
            }
            case 2: {
                Intro.StateMenu_page = 8;
                AnimationManager.setColor(48);
                ArrayOptimizer.PMGraphics_fillRect(0, 0, 240, 260);
                Debug.UserInterface_drawUIFullScreen(19);
                break;
            }
            case 3: {
                Intro.StateMenu_page = 7;
                Debug.UserInterface_drawUIFullScreen(11);
                break;
            }
            case 4: {
                Intro.StateMenu_page = 6;
                StateInGame.renderInfoScreenStatus();
                break;
            }
            case 5: {
                Intro.StateMenu_page = 10;
                StateInGame.renderInfoScreenPersona();
                break;
            }
            case 6: {
                Intro.StateMenu_page = 5;
                Debug.UserInterface_drawUIFullScreen(12);
                break;
            }
            case 9: {
                Intro.StateMenu_page = 11;
                StateInGame.renderInfoScreenNPCRelationship();
                break;
            }
            case 10: {
                Intro.StateMenu_page = 12;
                StateInGame.renderInfoScreenRecipe();
            }
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void initListRelationships() {
        Debug.UserInterface_initList(Main.m_simData.getRelationshipNthCount(), relationshipListItemSize, m_infoScreenSimSelectedIndex);
    }

    public static void drawListRelationships(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (Debug.UserInterface_getListNum() == 0) {
            int n10 = n + (n3 >> 1);
            int n11 = n2 + 3;
            AnimationManager.TextHandler_drawString(631, 1, n10, n11, 17);
            return;
        }
        if (m_npcLongestStringLength == 0) {
            n9 = 0;
            n8 = Main.m_simData.getSimCount();
            for (n7 = 1; n7 < n8; ++n7) {
                n6 = Main.m_simData.getSimName(n7);
                n5 = AnimationManager.TextHandler_getStringWidth(n6, 1);
                if (n5 <= n9) continue;
                n9 = n5;
            }
            m_npcLongestStringLength = n9;
        }
        n9 = n3 - m_npcLongestStringLength - 9;
        n8 = n + n3 - n9 - 3;
        n7 = n + 3;
        n6 = n2;
        int n12 = Debug.UserInterface_getListCursor();
        int n13 = 0;
        for (n5 = Debug.UserInterface_getListOffset(); n6 < n2 + n4 && n5 < Debug.UserInterface_getListNum(); ++n5) {
            int n14 = Main.m_simData.getRelationshipNthItem(n5);
            int n15 = Main.m_simData.getSimName(n14);
            if (n5 == n12) {
                Debug.UserInterface_drawListSelect(n, n6, n3, relationshipListItemSize, n2 + n4, 53, n5);
            }
            AnimationManager.TextHandler_drawString(n15, 1, n7, n6 + relationshipListItemSizeHalf, 6);
            int n16 = Main.m_simData.getRelState(n14);
            int n17 = 65536;
            StateInGame.drawRelBar(1 + n13, n8, n6 + 3, n9, n16, n17, true);
            ++n13;
            Debug.UserInterface_drawListDivider(n, n6 += relationshipListItemSize, n3);
        }
    }

    public static void renderInfoScreenCareer(boolean bl) {
        int n;
        int n2 = -1;
        int n3 = 0;
        if (bl) {
            n = 8;
            n2 = m_jobOfferCareer;
            n3 = m_jobOfferLevel;
        } else {
            n2 = Main.m_simData.getSimCareer(0);
            if (n2 == -1) {
                n = 5;
            } else {
                n = 6;
                n3 = Main.m_simData.getSimCareerLevel(0);
            }
        }
        int n4 = 795;
        if (n2 == -1) {
            if (bl) {
                n4 = 532;
            }
        } else {
            int n5;
            if (bl) {
                n4 = n2 == Main.m_simData.getSimCareer(0) ? 646 : 418;
            }
            Debug.UserInterface_setUIPlaceholderString(1, n4);
            Debug.UserInterface_setUIPlaceholderString(2, Main.m_simData.getCareerDescString(n2));
            Debug.UserInterface_setUIPlaceholderString(3, Main.m_simData.getCareerLevelDescString(n2, n3));
            int n6 = Main.m_simData.getCareerLevelIncome(n2, n3);
            SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
            AnimationManager.TextHandler_appendMoneyToBuffer(n6);
            AnimationManager.TextHandler_dynamicString(-9, sDKString);
            Debug.UserInterface_setUIPlaceholderString(4, -9);
            int n7 = Main.m_simData.getCareerRabbitHole(n2);
            Debug.UserInterface_setUIPlaceholderString(5, Main.m_simWorld.d_objectStringIds[n7]);
            int n8 = Main.m_simData.getCareerBoss(n2);
            Debug.UserInterface_setUIPlaceholderString(6, Main.m_simData.getSimName(n8));
            int n9 = Main.m_simData.getCareerLevelFlags(n2, n3);
            sDKString = AnimationManager.TextHandler_clearStringBuffer();
            SDKString sDKString2 = AnimationManager.TextHandler_getString(345);
            int n10 = 0;
            int n11 = SimData.DAY_FLAGS.length;
            for (n5 = 0; n5 < n11; ++n5) {
                if ((n9 & SimData.DAY_FLAGS[n5]) == 0) continue;
                if (n10 > 0) {
                    AnimationManager.TextHandler_appendSDKStringToBuffer(sDKString2);
                }
                AnimationManager.TextHandler_appendStringIdToBuffer(SimData.DAY_STRINGS[n5]);
                ++n10;
            }
            AnimationManager.TextHandler_dynamicString(-8, sDKString);
            Debug.UserInterface_setUIPlaceholderString(7, -8);
            sDKString = AnimationManager.TextHandler_clearStringBuffer();
            n5 = Main.m_simData.getCareerLevelHoursStart(n2, n3);
            AnimationManager.TextHandler_appendTimeToBuffer24Hour(n5);
            AnimationManager.TextHandler_appendStringIdToBuffer(854);
            n11 = Main.m_simData.getCareerLevelHoursEnd(n2, n3);
            AnimationManager.TextHandler_appendTimeToBuffer24Hour(n11);
            AnimationManager.TextHandler_dynamicString(-7, sDKString);
            Debug.UserInterface_setUIPlaceholderString(8, -7);
            if (!bl) {
                sDKString = AnimationManager.TextHandler_clearStringBuffer();
                int n12 = 0;
                int n13 = 3;
                int n14 = 9;
                Debug.UserInterface_setUIPlaceholderString(9, 631);
                Debug.UserInterface_setUIPlaceholderString(10, 557);
                Debug.UserInterface_setUIPlaceholderString(11, 557);
                int n15 = SimData.PERK_FLAGS.length;
                for (int i = 0; i < n15 && n12 < n13; ++i) {
                    if ((n9 & SimData.PERK_FLAGS[i]) == 0) continue;
                    Debug.UserInterface_setUIPlaceholderString(n14, SimData.PERK_STRINGS[i]);
                    ++n14;
                    ++n12;
                }
            }
        }
        Debug.UserInterface_setUIPlaceholderString(1, n4);
        Debug.UserInterface_drawUIFullScreen(n);
    }

    public static int drawUISkill(boolean bl, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = Main.m_simData.getSkillCount();
        if (m_skillLongestStringLength == 0) {
            n9 = 0;
            for (n8 = 0; n8 < n10; ++n8) {
                n7 = Main.m_simData.getSkillDesc(n8);
                n6 = AnimationManager.TextHandler_getStringWidth(n7, 1);
                if (n6 <= n9) continue;
                n9 = n6;
            }
            m_skillLongestStringLength = n9;
        }
        if (!bl) {
            n9 = Main.m_simData.getSkillDesc(n5);
            n8 = Main.m_simData.getSkillLevel(n5);
            n7 = Main.m_simData.getSkillLevelDesc(n5);
            n6 = n3 - m_skillLongestStringLength - 3;
            int n11 = n + m_skillLongestStringLength + 3;
            int n12 = 2;
            int n13 = 2 * Debug.UserInterface_m_uiTextHeight - 3;
            if (n10 < 4) {
                if (Intro.StateMenu_pageItemVertSpacing == 0) {
                    Intro.StateMenu_pageItemVertSpacing = (Intro.StateMenu_availableVerticalPageSpace - 2 * n13 - 2 * (n12 + 3)) / (n10 + 1);
                    Intro.StateMenu_firstPageElementY = Intro.StateMenu_lastPageElementY + Intro.StateMenu_pageItemVertSpacing;
                }
                if (Intro.StateMenu_page == 8) {
                    n2 = Intro.StateMenu_lastPageElementY <= Intro.StateMenu_firstPageElementY ? (Intro.StateMenu_lastPageElementY = Intro.StateMenu_firstPageElementY) : Intro.StateMenu_lastPageElementY;
                }
            }
            AnimationManager.TextHandler_drawString(n9, 1, n, n2, 20);
            StateInGame.drawSkillBar(n11, n2, n6, n8);
            AnimationManager.TextHandler_drawString(n7, 1, n + 6, (n2 += Debug.UserInterface_m_uiTextHeight) + 1, 20);
            Intro.StateMenu_lastPageElementY += n13 + Intro.StateMenu_pageItemVertSpacing;
        }
        return Debug.UserInterface_m_uiTextHeight * 2;
    }

    public static void drawSkillBar(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - 0 >> 10;
        int n7 = 327680 - 0 >> 10;
        int n8 = n3 - 2;
        int n9 = n8 * n6 / n7;
        int n10 = AnimationManager.getAnimFrameHeight(737, 0);
        int n11 = n + 1;
        int n12 = n2 + 1;
        int n13 = n10 + 2;
        AnimationManager.setColor(48);
        ArrayOptimizer.PMGraphics_drawRect(n, n2, n3 - 1, n13 - 1);
        int n14 = ArrayOptimizer.PMGraphics_getClipX();
        int n15 = ArrayOptimizer.PMGraphics_getClipY();
        int n16 = ArrayOptimizer.PMGraphics_getClipWidth();
        int n17 = ArrayOptimizer.PMGraphics_getClipHeight();
        ArrayOptimizer.PMGraphics_setClip(n11, n15, n8, n17);
        AnimationManager.drawAnimFrame(737, 0, n11, n12);
        ArrayOptimizer.PMGraphics_setClip(n14, n15, n16, n17);
        AnimationManager.setColor(48);
        int n18 = 1;
        while (true) {
            if (n18 >= 5) break;
            n5 = n + n3 * n18 / 5;
            ArrayOptimizer.PMGraphics_fillRect(n5, n12, 1, n10);
            ++n18;
        }
        ArrayOptimizer.PMGraphics_setClip(n11, n15, n9, n17);
        AnimationManager.drawAnimFrame(738, 0, n11, n12);
        AnimationManager.setColor(47);
        n18 = 1;
        while (true) {
            if (n18 >= 5) break;
            n5 = n + n3 * n18 / 5;
            ArrayOptimizer.PMGraphics_fillRect(n5, n12, 1, n10);
            ++n18;
        }
        ArrayOptimizer.PMGraphics_setClip(n14, n15, n16, n17);
    }

    public static void initListDreams() {
        Debug.UserInterface_initList(4, Debug.UserInterface_m_goalListItemSize, -1);
    }

    public static int drawUICurrentDream(boolean bl, int n, int n2, int n3, int n4) {
        if (!bl) {
            int n5 = n + 10;
            int n6 = AnimationManager.getAnimFrameHeight(674, 0);
            int n7 = Debug.UserInterface_m_goalListItemSize - n6 >> 1;
            int n8 = n3 - 30;
            int n9 = n + n3 - n8;
            int n10 = Debug.UserInterface_m_goalListItemSize >> 1;
            int n11 = Main.m_simData.getDream();
            int n12 = Main.m_simData.getDreamDescString(n11);
            int n13 = 701;
            if (n11 == -1) {
                n13 = 359;
            }
            AnimationManager.TextHandler_drawWrappedStringChunk(19, n12, 1, n8, n9, n2 + n10, 6);
            AnimationManager.drawAnimFrame(n13, 0, n5, n2 + n7);
        }
        return Debug.UserInterface_m_goalListItemSize + 3;
    }

    public static void renderInfoScreenStatus() {
        Debug.UserInterface_setUIPlaceholderString(1, Main.m_simData.m_moodDesc);
        int n = Main.m_simData.getTotalDays();
        SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendIntToBuffer(n);
        AnimationManager.TextHandler_dynamicString(-9, sDKString);
        Debug.UserInterface_setUIPlaceholderString(2, -9);
        sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendMoneyToBuffer(Main.m_simData.m_moneySpent);
        AnimationManager.TextHandler_dynamicString(-8, sDKString);
        Debug.UserInterface_setUIPlaceholderString(3, -8);
        Debug.UserInterface_drawUIFullScreen(10);
    }

    public static void initListStatus() {
        statusListItemHeight = AnimationManager.TextHandler_getLineHeight(1) + 6;
        Debug.UserInterface_initList(Main.m_simData.getMotiveCount(), statusListItemHeight, -1);
    }

    public static void drawListStatus(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = statusListItemHeight;
        int n8 = Main.m_simData.getMotiveCount();
        int n9 = 0;
        for (n6 = 0; n6 < n8; ++n6) {
            n5 = AnimationManager.TextHandler_getStringWidth(Main.m_simData.getMotiveDescString(n6), 1);
            if (n5 <= n9) continue;
            n9 = n5;
        }
        n6 = n + 3;
        n5 = n3 - n9 - 9;
        int n10 = n6 + n9 + 3;
        int n11 = AnimationManager.getAnimFrameHeight(744, 0) >> 1;
        int n12 = n7 >> 1;
        int n13 = n2;
        for (int i = Debug.UserInterface_getListOffset(); n13 < n2 + n4 && i < Debug.UserInterface_getListNum(); ++i) {
            short s = Main.m_simData.getMotiveDescString(i);
            AnimationManager.TextHandler_drawString(s, 1, n6, n13 + n12, 6);
            int n14 = Main.m_simData.getMotiveLevel(i);
            StateInGame.drawStatusBar(n10, n13 + n12 - n11, n5, n14);
            Debug.UserInterface_drawListDivider(n, n13 += n7, n3);
        }
    }

    public static void initListPersonaGoals() {
        Debug.UserInterface_initList(Main.m_simData.getPersonaNthGoalCount(), Debug.UserInterface_m_goalListItemSize, -1);
    }

    public static void renderInfoScreenPersona() {
        SDKString sDKString = ArrayHandler.Rms_getSimName();
        AnimationManager.TextHandler_dynamicString(-9, sDKString);
        Debug.UserInterface_setUIPlaceholderString(1, -9);
        Debug.UserInterface_setUIPlaceholderString(2, Main.m_simData.d_personaDescStrings[Main.m_simData.m_persona]);
        Debug.UserInterface_drawUIFullScreen(18);
    }

    public static void initListInventory() {
        int n = 0;
        if (m_infoScreenState == 10) {
            n = m_infoScreenItemSelectedIndex;
        }
        Debug.UserInterface_initList(Main.m_simData.getInventoryNthCount(), 18, n);
    }

    public static void initListRecipe() {
        m_infoScreenItemSelectedIndex = Debug.UserInterface_getListCursor();
        m_infoScreenRecipeSelected = ArrayHandler.indexOf(StateInGame.getInfoItem(), Main.m_simWorld.d_recipeItems);
        Debug.UserInterface_initList(Main.m_simWorld.d_recipeIngredients[m_infoScreenRecipeSelected].length, 18, -1);
    }

    public static int getInfoItem() {
        return Main.m_simData.getInventoryNthItem(Debug.UserInterface_getListCursor());
    }

    public static void drawListInventory(int n, int n2, int n3, int n4, int n5) {
        int n6 = n + 3 + 8;
        int n7 = n + 3 + 16 + 3;
        int n8 = n7 + 3;
        int n9 = n + n3 - 3;
        int n10 = n9 - 35;
        int n11 = n2;
        int n12 = Debug.UserInterface_getListOffset();
        int n13 = Debug.UserInterface_getListCursor();
        int n14 = 0;
        while (n11 < n2 + n4 && n12 < Debug.UserInterface_getListNum()) {
            int n15;
            int n16;
            int n17;
            int n18 = n5 == 5 ? Main.m_simData.getInventoryNthItem(n12) : (n5 == 9 ? Main.m_simWorld.getItemNthItem(m_shoppingObjectType, n12) : Main.m_simWorld.d_recipeIngredients[m_infoScreenRecipeSelected][n12]);
            short s = Main.m_simWorld.d_itemDescStringIds[n18];
            short s2 = Main.m_simWorld.d_itemIcons[n18];
            if (n12 == n13) {
                Debug.UserInterface_drawListSelect(n, n11, n3, 18, n2 + n4, 53, n12);
            }
            AnimationManager.drawAnimFrame(s2, 0, n6, n11 + 9);
            int n19 = 240 - n8 - (240 - n10) - 2;
            if (n12 == n13 || n5 == 6) {
                AnimationManager.TextHandler_renderScroller(n14, s, 1, n8, n11 + 9, n19, 6);
            } else {
                n17 = ArrayOptimizer.PMGraphics_getClipX();
                int n20 = ArrayOptimizer.PMGraphics_getClipY();
                n16 = ArrayOptimizer.PMGraphics_getClipWidth();
                n15 = ArrayOptimizer.PMGraphics_getClipHeight();
                ArrayOptimizer.PMGraphics_setClip(n8, n2, n19, n4);
                AnimationManager.TextHandler_drawString(s, 1, n8, n11 + 9, 6);
                ArrayOptimizer.PMGraphics_setClip(n17, n20, n16, n15);
            }
            n17 = Main.m_simData.getInventoryCount(n18);
            if (n17 > 0 || n5 == 6) {
                SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
                AnimationManager.TextHandler_appendIntToBuffer(n17);
                AnimationManager.TextHandler_appendStringIdToBuffer(345);
                if (n5 == 6) {
                    AnimationManager.TextHandler_appendIntToBuffer(1);
                } else {
                    AnimationManager.TextHandler_appendIntToBuffer(Main.m_simWorld.d_itemMaxInventory[n18]);
                }
                n16 = n9 - n10 + 3;
                n15 = n10 + (n16 >> 1);
                AnimationManager.TextHandler_drawString(sDKString, 1, n15, n11 + 9, 3);
            }
            ++n12;
            ++n14;
            Debug.UserInterface_drawListDivider(n, n11 += 18, n3);
        }
        AnimationManager.setColor(46);
        ArrayOptimizer.PMGraphics_fillRect(n7, n2, 1, n4);
        ArrayOptimizer.PMGraphics_fillRect(n10, n2, 1, n4);
        AnimationManager.TextHandler_updateScrollers(25);
    }

    public static void renderInfoScreenRecipe() {
        AnimationManager.setColor(48);
        ArrayOptimizer.PMGraphics_fillRect(0, 0, 240, 260);
        int n = Debug.UserInterface_drawDropDownTitle(4, 232, 799);
        byte by = Main.m_simWorld.d_recipeItems[m_infoScreenRecipeSelected];
        short s = Main.m_simWorld.d_itemDescStringIds[by];
        Debug.UserInterface_setUIPlaceholderString(1, s);
        Debug.UserInterface_drawUIFullScreen(13, n);
    }

    public static int getInfoSim() {
        return Main.m_simData.getRelationshipNthItem(m_infoScreenSimSelectedIndex);
    }

    public static void renderInfoScreenNPCRelationship() {
        int n = StateInGame.getInfoSim();
        AnimationManager.setColor(48);
        ArrayOptimizer.PMGraphics_fillRect(0, 0, 240, 260);
        int n2 = Debug.UserInterface_drawDropDownTitle(4, 232, 802);
        Debug.UserInterface_setUIPlaceholderString(1, Main.m_simData.getSimName(n));
        int n3 = Main.m_simData.getSimPartner(n);
        if (n3 == -1) {
            Debug.UserInterface_setUIPlaceholderString(2, 557);
            Debug.UserInterface_setUIPlaceholderString(3, 557);
        } else {
            Debug.UserInterface_setUIPlaceholderString(2, 622);
            Debug.UserInterface_setUIPlaceholderString(3, Main.m_simData.getSimName(n3));
        }
        if (Main.m_simData.m_currentRelStates[n] == 12) {
            Debug.UserInterface_setUIPlaceholderString(2, 622);
            Debug.UserInterface_setUIPlaceholderString(3, -1987);
        }
        if (n3 >= 0 && n3 < Main.m_simData.m_currentRelStates.length && Main.m_simData.m_currentRelStates[n3] == 12) {
            Debug.UserInterface_setUIPlaceholderString(2, 557);
            Debug.UserInterface_setUIPlaceholderString(3, 557);
        }
        int n4 = Main.m_simData.getSimCareer(n);
        int n5 = Main.m_simData.getCareerDescString(n4);
        Debug.UserInterface_setUIPlaceholderString(4, n5);
        int n6 = Intro.StateMenu_lastPageElementY;
        int n7 = Intro.StateMenu_lastPageElementH;
        Debug.UserInterface_drawUIFullScreen(15, n2);
        Debug.UserInterface_drawDropDownTitle(4, 232, 802);
        Intro.StateMenu_lastPageElementY = n6;
        Intro.StateMenu_lastPageElementH = n7;
    }

    public static int drawUIRelationship(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = AnimationManager.getAnimFrameHeight(734, 0);
        int n6 = AnimationManager.TextHandler_getLineHeight(1);
        if (!bl) {
            int n7 = StateInGame.getInfoSim();
            int n8 = n2;
            int n9 = Main.m_simData.getRelState(n7);
            StateInGame.drawRelBar(0, n, n8 += 2, n3, n9, 65536, true);
            n8 += n5;
            Main.m_simData.getRelationshipLevels(n7, m_tempInt10);
            for (int i = 0; i < 4 && (n9 = m_tempInt10[i]) != -1; i += 2) {
                int n10 = m_tempInt10[i + 1];
                StateInGame.drawRelBar(1 + i, n, n8 += 2, n3, n9, n10, false);
                n8 += n5;
            }
            Intro.StateMenu_lastPageElementH = 0;
        }
        return n5 * 3 + 4;
    }

    public static void drawUINPCPortrait(int n, int n2, int n3, int n4) {
        int n5 = StateInGame.getInfoSim();
        int n6 = n + n3 - 20;
        int n7 = n2 + n4 - 1;
        Debug.UserInterface_drawHUDSim(n6, n7, n5, true, 1, false);
    }

    public static void drawUIPlayerPortrait(int n, int n2, int n3, int n4) {
        int n5 = n + n3 - 20;
        int n6 = n2 + n4 - 1;
        Debug.UserInterface_drawHUDSim(n5, n6, 0, true, 0, false);
    }

    public static void drawAnimBar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = ArrayOptimizer.PMGraphics_getClipX();
        int n10 = ArrayOptimizer.PMGraphics_getClipY();
        int n11 = ArrayOptimizer.PMGraphics_getClipWidth();
        int n12 = ArrayOptimizer.PMGraphics_getClipHeight();
        int n13 = Camera.MathExt_Fmul(n3, n4);
        int n14 = AnimationManager.getAnimFrameWidth(n5, n8);
        int n15 = AnimationManager.getAnimFrameWidth(n6, n8);
        int n16 = Math.min(n3 - n15 - n14, n13 - n14);
        ArrayOptimizer.PMGraphics_setClip(n, n10, n13, n12);
        AnimationManager.drawAnimFrame(n5, n8, n, n2);
        AnimationManager.drawAnimFrame(n6, n8, n + n3 - n15, n2);
        ArrayOptimizer.PMGraphics_setClip(n + n14, n10, n16, n12);
        AnimationManager.drawAnimFrame(n7, n8, n + n14, n2);
        ArrayOptimizer.PMGraphics_setClip(n9, n10, n11, n12);
    }

    public static void drawStatusBar(int n, int n2, int n3, int n4) {
        StateInGame.drawAnimBar(n, n2, n3, 65536, 744, 745, 743, 0);
        int n5 = n4 < 0x230000 ? 2 : 1;
        n4 = Camera.MathExt_Fdiv(n4, 0x640000);
        StateInGame.drawAnimBar(n, n2, n3, n4, 744, 745, 743, n5);
    }

    public static void drawRelBar(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = Main.m_simData.getRelStateFlags(n5);
        int n8 = (n7 & 2) != 0 ? 1 : ((n7 & 1) != 0 ? 3 : 2);
        int n9 = bl ? n8 : 0;
        StateInGame.drawAnimBar(n2, n3, ++n4, 65536, 735, 736, 734, n9);
        if (!bl) {
            StateInGame.drawAnimBar(n2, n3, n4, n6, 735, 736, 734, n8 + 3);
        }
        int n10 = bl ? 0 : 1;
        int n11 = n3 + 8;
        AnimationManager.TextHandler_renderScroller(n, Main.m_simData.getRelStateDescString(n5), n10, n2 + 2, n11, n4 - 4, 3);
    }

    public static void showJobOffer(int n, int n2) {
        StateInGame.hideQuickLinks();
        m_jobOfferCareer = n;
        m_jobOfferLevel = n2;
        if (n == -1) {
            Debug.UserInterface_prepareGenericMessageBox(533, 532);
        } else {
            if (!Main.m_simData.careerRequirementsMet(n, n2)) {
                StateInGame.showJobRaiseFail(n, n2);
                return;
            }
            int n3 = Main.m_simData.getSimCareer(0);
            int n4 = n3 == -1 ? 9 : (n3 == n ? 11 : 10);
            AnimationManager.TextHandler_wrapString(n4, 1, Debug.UserInterface_m_uiMessageBoxWrapWidth);
        }
        StateInGame.stateTransition(10);
    }

    public static void processKeysJobOffer() {
        if (m_jobOfferCareer == -1) {
            if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos() || Main.softPressNeg()) {
                StateInGame.stateTransition(5);
            }
        } else if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            Main.m_simData.careerAcceptJob(m_jobOfferCareer, m_jobOfferLevel);
            if (m_jobOfferLevel > 0) {
                Main.m_simData.dreamCompleteEvent(18);
                ++Main.m_simData.m_numTimesPromoted;
                if (m_jobOfferLevel == Main.m_simData.getCareerLevelCount(m_jobOfferCareer) - 1) {
                    if (Main.m_simData.m_persona == 0 && m_jobOfferCareer == 0) {
                        Main.m_simData.dreamCompleteEvent(19);
                    }
                    if (Main.m_simData.m_persona == 1 && m_jobOfferCareer == 1) {
                        Main.m_simData.dreamCompleteEvent(25);
                    }
                    if (Main.m_simData.m_persona == 2 && m_jobOfferCareer == 2) {
                        Main.m_simData.dreamCompleteEvent(36);
                    }
                    if (Main.m_simData.m_persona == 3 && m_jobOfferCareer == 3) {
                        Main.m_simData.dreamCompleteEvent(48);
                    }
                }
            }
        } else if (Main.softPressNeg()) {
            StateInGame.stateTransition(5);
        }
    }

    public static void renderJobOffer() {
        int n = m_jobOfferCareer;
        if (n != -1) {
            StateInGame.renderInfoScreenCareer(true);
        } else {
            StateInGame.renderMain();
            if (!m_pauseMenuActive) {
                Event.PostEffects_renderBackgroundDim();
                Debug.UserInterface_drawGenericMessageBox();
            }
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void finishWork() {
        if (Cursor.hide) {
            Cursor.hide = false;
        }
        if (Main.randPercent() < 1 && Main.m_simData.m_careerDaysWorked >= 2) {
            int n = Main.m_simData.getCareerDeathString();
            StateInGame.killPlayer(n);
        } else {
            StateInGame.stateTransition(11);
        }
    }

    public static void processKeysPay() {
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos() || Main.softPressNeg()) {
            if (Main.randPercent() < 15) {
                int n = Main.m_simData.getChanceCardForWork();
                StateInGame.triggerChanceCard(n);
            } else {
                Main.m_simData.chooseProducible();
            }
        }
    }

    public static void renderPay() {
        Debug.UserInterface_setUIPlaceholderString(1, 625);
        Debug.UserInterface_setUIPlaceholderString(2, 364);
        SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendMoneyToBuffer(m_payIncome);
        AnimationManager.TextHandler_dynamicString(-9, sDKString);
        Debug.UserInterface_setUIPlaceholderString(3, -9);
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            Event.PostEffects_renderBackgroundDim();
            Debug.UserInterface_drawUIFullScreen(22);
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void showJobRaiseFail(int n, int n2) {
        m_jobOfferCareer = n;
        m_jobOfferLevel = n2;
        int n3 = Main.m_simData.getCareerFailString(n, n2);
        AnimationManager.TextHandler_wrapString(n3, 1, Debug.UserInterface_m_uiMessageBoxWrapWidth);
        StateInGame.stateTransition(12);
    }

    public static void renderRaiseFailure() {
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            Event.PostEffects_renderBackgroundDim();
            int n = m_jobOfferCareer;
            int n2 = m_jobOfferLevel;
            byte[] byArray = Main.m_simData.getCareerLevelRequirements(n, n2);
            byte by = byArray[0];
            byte by2 = byArray[1];
            byte by3 = byArray[2];
            byte by4 = byArray[3];
            byte by5 = byArray[4];
            byte by6 = byArray[5];
            int n3 = Main.m_simData.getSimName(Main.m_simData.getCareerBoss(n));
            Debug.UserInterface_setUIPlaceholderString(0, n3);
            Debug.UserInterface_setUIPlaceholderString(1, n3);
            int n4 = 1;
            if (by != -1) {
                n4 = 22;
                Debug.UserInterface_setUIPlaceholderString(2, Main.m_simData.getRequirementName(by, n));
                SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
                AnimationManager.TextHandler_appendIntToBuffer(Main.m_simData.getRequirementValue(by, n));
                AnimationManager.TextHandler_appendStringIdToBuffer(345);
                AnimationManager.TextHandler_appendIntToBuffer(by2);
                AnimationManager.TextHandler_dynamicString(-9, sDKString);
                Debug.UserInterface_setUIPlaceholderString(3, -9);
                if (by3 != -1) {
                    n4 = 23;
                    Debug.UserInterface_setUIPlaceholderString(4, Main.m_simData.getRequirementName(by3, n));
                    sDKString = AnimationManager.TextHandler_clearStringBuffer();
                    AnimationManager.TextHandler_appendIntToBuffer(Main.m_simData.getRequirementValue(by3, n));
                    AnimationManager.TextHandler_appendStringIdToBuffer(345);
                    AnimationManager.TextHandler_appendIntToBuffer(by4);
                    AnimationManager.TextHandler_dynamicString(-8, sDKString);
                    Debug.UserInterface_setUIPlaceholderString(5, -8);
                    if (by5 != -1) {
                        n4 = 24;
                        Debug.UserInterface_setUIPlaceholderString(6, Main.m_simData.getRequirementName(by5, n));
                        sDKString = AnimationManager.TextHandler_clearStringBuffer();
                        AnimationManager.TextHandler_appendIntToBuffer(Main.m_simData.getRequirementValue(by5, n));
                        AnimationManager.TextHandler_appendStringIdToBuffer(345);
                        AnimationManager.TextHandler_appendIntToBuffer(by6);
                        AnimationManager.TextHandler_dynamicString(-7, sDKString);
                        Debug.UserInterface_setUIPlaceholderString(7, -7);
                    }
                }
            }
            Debug.UserInterface_drawUIFullScreen(n4);
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void processKeysRaiseFailure() {
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos() || ArrayHandler.PMInput_isPressed(4)) {
            StateInGame.stateTransition(5);
        }
    }

    public static void showQuitJob() {
        m_quitJobConfirmed = false;
        int n = Main.m_simData.getCareerLevelDescString(Main.m_simData.getSimCareer(0), Main.m_simData.getSimCareerLevel(0));
        Debug.UserInterface_prepareGenericMessageBox(757, n);
        StateInGame.stateTransition(13);
    }

    public static void processKeysQuitJob() {
        if (Main.softPressNeg() || m_quitJobConfirmed && Main.softPressPos() || m_quitJobConfirmed && ArrayHandler.PMInput_isPressed(1)) {
            StateInGame.stateTransition(5);
        } else if (Main.softPressPos() || ArrayHandler.PMInput_isPressed(1)) {
            int n = Main.m_simData.getCareerBoss(Main.m_simData.getSimCareer(0));
            Main.m_simData.careerAcceptJob(-1, 0);
            m_quitJobConfirmed = true;
            StateInGame.setupSoftkeys();
            Main.m_simData.applyCommodity(n, 2, 120, false);
            Main.m_simData.adjustRelLevels(n, -2, 0);
            MapObjectSim mapObjectSim = StateInGame.findSim(n);
            if (mapObjectSim != null) {
                mapObjectSim.simFeedback(10, 2450, 680, true, false);
            }
            Debug.UserInterface_prepareGenericMessageBox(758, 92);
        }
    }

    public static void renderQuitJob() {
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            Event.PostEffects_renderBackgroundDim();
            Debug.UserInterface_drawGenericMessageBox();
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void showNewDream() {
        m_showNewDream = true;
    }

    public static void showExpiredDream(int n) {
        StateInGame.showTickerMessage(619, Main.m_simData.getDreamDescString(n));
    }

    public static void showNewDreamMessage() {
        StateInGame.hideQuickLinks();
        Camera.PMVibrate_vibrate(240);
        int n = 324;
        if (!Main.m_simData.isDreamToPromisePossible()) {
            n = 326;
        }
        AnimationManager.TextHandler_wrapString(n, 1, Debug.UserInterface_m_uiInfoBoxWrapWidth);
        StateInGame.stateTransition(14);
    }

    public static void renderNewDream() {
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            Event.PostEffects_renderBackgroundDim();
            Debug.UserInterface_drawUIFullScreen(27);
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void processKeysNewDream() {
        if (Main.softPressNeg()) {
            StateInGame.stateTransition(5);
            AnimationManager.TextHandler_resetScrollers();
        } else if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            if (Main.m_simData.isDreamToPromisePossible()) {
                Main.m_simData.dreamToPromise();
            }
            StateInGame.stateTransition(5);
            AnimationManager.TextHandler_resetScrollers();
        }
    }

    public static void showNewPromise(int n) {
        m_dreamAnimPlayers[n].startAnim(702, 16);
    }

    public static void showGoalCompleted(int n, int n2) {
        StateInGame.showTickerMessage(347, Main.m_simData.getDreamDescString(n));
        StateInGame.getPlayerSim().queueSimAction(9, null, 0, 0);
        if (n2 != -1) {
            m_dreamAnimPlayers[n2].startAnim(703, 16);
        }
    }

    public static void showDoorKnock(int n) {
        StateInGame.showTickerMessage(Main.m_simData.getSimName(n), 420);
    }

    public static void showGetItem(int n, int n2, int n3, int n4) {
        m_showGetItem = n;
        m_showGetItemQty = n2;
        m_showGetItemTitle = n3;
        if (Main.m_simData.getInventoryCount(n) == Main.m_simWorld.d_itemMaxInventory[n]) {
            n4 = 371;
        }
        m_showGetItemMessage = n4;
    }

    public static void renderShowGetItem() {
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            Event.PostEffects_renderBackgroundDim();
            Debug.UserInterface_drawUIFullScreen(28);
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void processKeysShowGetItem() {
        if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
            m_showGetItem = -1;
            StateInGame.stateTransition(5);
        }
    }

    public static int drawUIGetItem(boolean bl, int n, int n2, int n3, int n4) {
        if (!bl) {
            int n5 = m_showGetItem;
            int n6 = n + 3 + 8;
            int n7 = n2 + 9;
            int n8 = n + 3 + 16 + 3;
            int n9 = n8 + 3;
            int n10 = n2 + 9;
            int n11 = n + n3 - 3;
            short s = Main.m_simWorld.d_itemIcons[n5];
            AnimationManager.drawAnimFrame(s, 0, n6, n7);
            SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
            if (m_showGetItemQty != 1) {
                AnimationManager.TextHandler_appendIntToBuffer(m_showGetItemQty);
                AnimationManager.TextHandler_appendStringIdToBuffer(944);
            }
            AnimationManager.TextHandler_appendStringIdToBuffer(Main.m_simWorld.d_itemDescStringIds[n5]);
            AnimationManager.TextHandler_drawString(sDKString, 1, n9, n10, 6);
            sDKString = AnimationManager.TextHandler_clearStringBuffer();
            AnimationManager.TextHandler_appendIntToBuffer(Main.m_simData.getInventoryCount(n5));
            AnimationManager.TextHandler_appendStringIdToBuffer(345);
            AnimationManager.TextHandler_appendIntToBuffer(Main.m_simWorld.d_itemMaxInventory[n5]);
            AnimationManager.TextHandler_drawString(sDKString, 1, n11, n10, 10);
        }
        return 18;
    }

    public static boolean isPlayerInactive() {
        return m_simInactivityTimer > 20000;
    }

    public static void resetPlayerInactivity() {
        m_simInactivityTimer = 0;
        StateInGame.getPlayerSim().clearNeedFlags();
    }

    public static void updateEventsHouse(int n) {
        if (Debug.DISABLE_EVENTS) {
            return;
        }
        m_simAIEventTimer += n;
        int n2 = Main.m_simWorld.m_houseId;
        int n3 = 3000;
        if (Main.m_simData.getFastforward()) {
            n3 >>= 1;
        }
        if (m_simAIEventTimer > n3) {
            int n4;
            int n5;
            m_simAIEventTimer = 0;
            if (Main.m_simWorld.potentialVisitor != -1) {
                if ((Main.m_simData.getGameTimeAbs() - lastVisitorTime) / 60 > 48 && Main.m_simData.isTimeInRange(Main.m_simData.getGameTime(), 360, 1260)) {
                    if (StateInGame.nextAvailableBank() != -1) {
                        MapObjectSim mapObjectSim = StateInGame.findSim(Main.m_simWorld.potentialVisitor);
                        if (mapObjectSim != null) {
                            Main.m_simWorld.potentialVisitor = Main.m_simData.determinePotentialVisitor();
                            return;
                        }
                        n5 = Main.randPercent();
                        if (n5 < currentVisitorChance) {
                            mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, StateInGame.findRandomObjectByType(4), Main.m_simWorld.potentialVisitor);
                            mapObjectSim.setNeedFlag(32);
                            Main.m_simWorld.potentialVisitor = -1;
                        } else {
                            currentVisitorChance = Main.m_simData.isItAWorkDayToday() ? (currentVisitorChance += 2) : (currentVisitorChance += 10);
                        }
                    } else {
                        Main.m_simWorld.potentialVisitor = -1;
                    }
                }
            }
            int n6 = Main.m_simData.getSimCount();
            for (n5 = 1; n5 < n6; ++n5) {
                n4 = Main.m_simData.getTimeFlags(n5);
                MapObjectSim mapObjectSim = StateInGame.findSim(n5);
                if (mapObjectSim != null) {
                    if ((n4 & (1 | 2 | 4)) != 0) {
                        mapObjectSim.setNeedFlag(1);
                    }
                    if ((n4 & 0x10) == 0) continue;
                    if (n2 == Main.m_simData.getSimHome(n5)) {
                        mapObjectSim.setNeedFlag(4);
                        continue;
                    }
                    GlobalConstants.PMDebug_println("adding leave (for sleep) flag");
                    mapObjectSim.setNeedFlag(256);
                    continue;
                }
                if ((n4 & 8) == 0 || n2 != Main.m_simData.getSimHome(n5) || StateInGame.nextAvailableBank() == -1) continue;
                MapObject mapObject = StateInGame.findRandomObjectByType(4);
                if (mapObject == null) {
                    mapObject = StateInGame.findRandomObjectByType(3);
                }
                if (mapObject == null) {
                    mapObject = StateInGame.findRandomObjectByParentType(8);
                }
                mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject, n5);
            }
            MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
            int n7 = mapObjectSimArray.length;
            for (n4 = 1; n4 < n7; ++n4) {
                if (!mapObjectSimArray[n4].isIdle() || !mapObjectSimArray[n4].occupiedIsEmpty()) continue;
                int n8 = (Main.randPercent() < 50 ? 2 : 0) | (Main.randPercent() < 25 ? 8 : 0) | (Main.randPercent() < 50 ? 64 : 0) | (Main.randPercent() < 25 ? 16 : 0) | (Main.randPercent() < 60 ? 32 : 0) | (Main.randPercent() < 40 ? 128 : 0) | (Main.randPercent() < 15 ? 4 : 0);
                if (n2 != Main.m_simData.getSimHome(mapObjectSimArray[n4].getId())) {
                    n8 &= 0xFFFFFFFB;
                }
                mapObjectSimArray[n4].setNeedFlag(n8);
            }
        }
        MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
        if (ArrayHandler.Rms_getAutonomityEnabled()) {
            if (StateInGame.isPlayerInactive()) {
                if (mapObjectSim.isIdle()) {
                    int n9 = Main.m_simData.getPlayerNeedFlags();
                    if (Main.m_simWorld.m_houseId != 0) {
                        if (!Main.m_simData.getSimCurRelStateFlags(0, 1)) {
                            n9 |= 0x20;
                        }
                    }
                    mapObjectSim.setNeedFlag(n9);
                }
            } else {
                m_simInactivityTimer += n;
            }
        } else {
            mapObjectSim.clearNeedFlags();
        }
    }

    public static void updateEventsZoomMode(int n) {
        MapObjectSim[] mapObjectSimArray;
        if (Debug.DISABLE_EVENTS) {
            return;
        }
        m_simAIEventTimer += n;
        int n2 = 5000;
        if (Main.m_simData.getFastforward()) {
            n2 >>= 1;
        }
        if (!firstMapEventHasBeenTriggered && m_simAIEventTimer > n2 >> 2) {
            firstMapEventHasBeenTriggered = true;
            if (Main.getNextZoomMapId() == 79) {
                StateInGame.showTutorialMessage((byte)17, 904, 905);
                PMAudio.play(3, 1);
            }
            if (Main.getNextZoomMapId() == 81) {
                StateInGame.showTutorialMessage((byte)19, 906, 907);
                PMAudio.play(5, 1);
            }
            if (Main.getNextZoomMapId() == 80) {
                StateInGame.showTutorialMessage((byte)18, 908, 909);
                PMAudio.play(4, 1);
            }
            if (Main.getNextZoomMapId() == 82) {
                StateInGame.showTutorialMessage((byte)20, 910, 911);
                PMAudio.play(6, 1);
            }
            if (showConsumablesTutorial) {
                showConsumablesTutorial = false;
                StateInGame.showTutorialMessage((byte)30, 1030, 1029);
            }
        }
        if (m_simAIEventTimer > n2) {
            m_simAIEventTimer = 0;
            if (Main.getNextZoomMapId() == 79) {
                Main.m_simData.dreamCompleteEvent(0);
            }
            if (Main.getNextZoomMapId() == 81) {
                Main.m_simData.dreamCompleteEvent(1);
            }
            if (Main.getNextZoomMapId() == 80) {
                Main.m_simData.dreamCompleteEvent(30);
            }
            if (Main.getNextZoomMapId() == 82) {
                Main.m_simData.dreamCompleteEvent(41);
            }
            GlobalConstants.PMDebug_println("zoom map event");
            mapObjectSimArray = StateInGame.getSimObjects();
            int n3 = 50;
            if (Main.getNextZoomMapId() == 84 && mapObjectSimArray.length <= 2) {
                boolean bl = false;
                int n4 = Main.m_simData.getSimCount();
                int n5 = 4;
                for (int i = 0; i < n5; ++i) {
                    MapObject mapObject;
                    int n6 = Main.rand(1, n4 - 1);
                    if (Main.m_simData.getSimHome(n6) == -1) continue;
                    MapObjectSim mapObjectSim = StateInGame.findSim(n6);
                    int n7 = Main.m_simData.getTimeFlags(n6);
                    if (mapObjectSim != null) {
                        if ((n7 & (1 | 2 | 4)) != 0) {
                            mapObjectSim.setNeedFlag(1);
                        }
                        if ((n7 & 0x10) == 0) continue;
                        GlobalConstants.PMDebug_println("adding leave (for sleep) flag");
                        mapObjectSim.setNeedFlag(256);
                        continue;
                    }
                    if ((n7 & 8) == 0) continue;
                    if ((n7 & 0x10) != 0 || StateInGame.nextAvailableBank() == -1 || bl) continue;
                    bl = true;
                    if (Main.randPercent() >= n3 || (mapObject = StateInGame.findRandomObjectByType(3)) == null) continue;
                    mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject, n6);
                    mapObjectSim.setNeedFlag(32);
                }
            } else {
                int n8;
                for (n8 = 1; n8 < Main.m_simData.getSimCount() && StateInGame.nextAvailableBank() != -1; ++n8) {
                    int n9 = Main.rand(1, Main.m_simData.getSimCount() - 1);
                    if (StateInGame.findSim(n9) != null) continue;
                    MapObject mapObject = StateInGame.findRandomMapDestination();
                    MapObjectSim mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject, n9);
                    if (mapObject == null || mapObjectSim == null) continue;
                    mapObject = StateInGame.findRandomMapDestination();
                    if (mapObject.getClosestInterestPoint(mapObjectSim.getPosX(), mapObjectSim.getPosZ(), true, null) == -1) break;
                    mapObjectSim.beginSimAction(111, mapObject);
                    break;
                }
                mapObjectSimArray = StateInGame.getSimObjects();
                for (n8 = 1; n8 < mapObjectSimArray.length; ++n8) {
                    MapObject mapObject;
                    if (mapObjectSimArray[n8] == null || !mapObjectSimArray[n8].isIdle()) continue;
                    if (Main.randPercent() < 10) {
                        mapObjectSimArray[n8].setNeedFlag(32);
                        continue;
                    }
                    if (Main.randPercent() >= 60 || (mapObject = StateInGame.findRandomMapDestination()) == null || mapObject.getClosestInterestPoint(mapObjectSimArray[n8].getPosX(), mapObjectSimArray[n8].getPosZ(), true, null) == -1) continue;
                    mapObjectSimArray[n8].beginSimAction(111, mapObject);
                }
            }
        }
        mapObjectSimArray = StateInGame.getPlayerSim();
        if (ArrayHandler.Rms_getAutonomityEnabled()) {
            if (StateInGame.isPlayerInactive()) {
                if (mapObjectSimArray.isIdle()) {
                    int n10 = Main.m_simData.getPlayerNeedFlags();
                    mapObjectSimArray.setNeedFlag(n10);
                }
            } else {
                m_simInactivityTimer += n;
            }
        } else {
            mapObjectSimArray.clearNeedFlags();
        }
    }

    public static void updateEventsMapMode(int n) {
        if (Debug.DISABLE_EVENTS) {
            return;
        }
        if ((m_simAIEventTimer += n) > 5000) {
            MapObject mapObject;
            int n2;
            m_simAIEventTimer = 0;
            int n3 = Main.rand(1, Main.m_simData.getSimCount() - 1);
            MapObjectSim mapObjectSim = StateInGame.findSim(n3);
            if (mapObjectSim == null && (n2 = Main.m_simData.getSimHome(n3)) != -1) {
                MapObject mapObject2 = StateInGame.findRandomObjectByType(Main.m_simWorld.d_houseMacroObjects[n2]);
                mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject2, n3);
            }
            if (mapObjectSim != null && mapObjectSim.isIdle() && (mapObject = StateInGame.findRandomMapDestination()).getClosestInterestPoint(mapObjectSim.getPosX(), mapObjectSim.getPosZ(), true, null) != -1) {
                mapObjectSim.beginSimAction(111, mapObject);
            }
        }
    }

    public static MapObject findRandomMapDestination() {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n = mapObjectArray.length;
        Debug.ASSERT(n <= 257, "LGC isn't big enough for destination list");
        int n2 = Main.rand(0, n - 1);
        for (int i = 0; i < n; ++i) {
            MapObject mapObject = mapObjectArray[n2];
            if (mapObject.getFlag(4096)) {
                return mapObject;
            }
            while ((n2 = (1543 * n2 + 3571) % 257) >= n) {
            }
        }
        return null;
    }

    public static void putSimInBed(MapObjectSim mapObjectSim) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        MapObject mapObject = null;
        MapObject mapObject2 = null;
        int n = mapObjectArray.length;
        for (int i = 0; i < n; ++i) {
            MapObject mapObject3 = mapObjectArray[i];
            if (mapObject3.getParentType() == 4) {
                if (!mapObjectSim.setOccupied(mapObject3)) continue;
                mapObject = mapObject3;
                break;
            }
            if (mapObject3.getParentType() != 8 || !mapObject3.occupiedIsEmpty()) continue;
            mapObject2 = mapObject3;
        }
        if (mapObject == null) {
            mapObject = mapObject2;
        }
        if (mapObject != null) {
            mapObjectSim.gotoSleep(mapObject);
        } else if (mapObjectSim.getId() == 0) {
            mapObjectSim.beginSimAction(6, null);
        }
    }

    public static void advertiseEvent(int n, MapObjectSim mapObjectSim, MapObject mapObject) {
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        int n2 = Main.m_simData.d_actionFlags[n];
        if (n == 23) {
            Main.m_simData.setSimCurRelStateFlags(0, 1);
        }
        int n3 = mapObjectSimArray.length;
        for (int i = 0; i < n3; ++i) {
            boolean bl;
            MapObjectSim mapObjectSim2 = mapObjectSimArray[i];
            int n4 = mapObjectSim2.getId();
            if (n4 == 0 || mapObjectSim2 != null && (mapObjectSim2.equals(mapObject) || mapObjectSim2.equals(mapObjectSim)) || (n2 & 0x20000) != 0 && Main.m_simData.getSimHome(n4) != Main.m_simWorld.m_houseId || !(bl = mapObjectSim2.respondToEvent(n, mapObjectSim, mapObject)) || (n2 & 0x400000) == 0) continue;
            GlobalConstants.PMDebug_println("sim responded");
            return;
        }
    }

    public static void processBasicAction(int n) {
        switch (n) {
            case 778: {
                StateInGame.hidePauseMenu();
                break;
            }
            case 781: {
                StateInGame.stateTransitionPauseMenu(2);
                break;
            }
            case 785: {
                StateInGame.stateTransitionPauseMenu(3);
                break;
            }
            case 783: {
                StateInGame.stateTransitionPauseMenu(4);
                break;
            }
            case 759: {
                StateInGame.stateTransitionPauseMenu(1);
                break;
            }
            case 621: {
                Intro.StateMenu_stateTransitionSharedMenu(1);
                break;
            }
            case 361: {
                Intro.StateMenu_stateTransitionSharedMenu(3);
                break;
            }
            case 794: {
                StateInGame.hideMenus();
                StateInGame.cancelSimAction();
                break;
            }
            case 793: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(7);
                StateInGame.stateTransitionBuildMode(1);
                break;
            }
            case 51: {
                Main.m_simData.delayAlerts();
                m_timeHit = 25;
                Cursor.hide = false;
                StateInGame.gotoMap();
                break;
            }
            case 801: {
                StateInGame.hideMenus();
                StateInGame.showQuickLinks();
                break;
            }
            case 52: {
                StateInGame.gotoWork();
                break;
            }
            case 49: {
                Main.m_simData.delayAlerts();
                m_timeHit = 25;
                StateInGame.goHome();
                break;
            }
            case 802: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(0);
                break;
            }
            case 795: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(1);
                break;
            }
            case 803: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(2);
                break;
            }
            case 797: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(3);
                break;
            }
            case 804: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(4);
                break;
            }
            case 800: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(5);
                break;
            }
            case 799: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(6);
                break;
            }
            case 796: {
                break;
            }
            case 100: {
                StateInGame.hideMenus();
                StateInGame.stateTransitionBuildMode(9);
                break;
            }
            case 98: {
                StateInGame.hideMenus();
                Cursor.m_cursorObject.buildRotate();
                Main.m_simWorld.objectRotate(Cursor.m_cursorObject.getId(), Cursor.m_cursorObject.getFacingDir());
                break;
            }
            case 85: {
                StateInGame.hideMenus();
                StateInGame.stateTransitionBuildMode(10);
                break;
            }
            case 43: 
            case 63: {
                StateInGame.hideMenus();
                break;
            }
            default: {
                Debug.ASSERT(false, "action not implemented");
            }
        }
    }

    public static void initActionQueue() {
        m_actionQueueSize = 0;
        if (m_actionQueueActions == null) {
            m_actionQueueActions = new int[3];
            m_actionQueueArg1s = new MapObject[3];
            m_actionQueueArg2s = new int[3];
            m_actionQueueArg3s = new int[3];
        }
        ArrayHandler.fillArray(m_actionQueueActions, -1);
        ArrayHandler.fillArray(m_actionQueueArg1s, null);
    }

    public static void updateSimAction() {
        MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
        int[] nArray = m_actionQueueActions;
        MapObject[] mapObjectArray = m_actionQueueArg1s;
        if (m_actionQueueSize > 0) {
            int n;
            if (mapObjectSim.isIdle()) {
                int n2;
                --m_actionQueueSize;
                for (n2 = 0; n2 < 2; ++n2) {
                    nArray[n2] = nArray[n2 + 1];
                    mapObjectArray[n2] = mapObjectArray[n2 + 1];
                    StateInGame.m_actionQueueArg2s[n2] = m_actionQueueArg2s[n2 + 1];
                    StateInGame.m_actionQueueArg3s[n2] = m_actionQueueArg3s[n2 + 1];
                }
                mapObjectArray[StateInGame.m_actionQueueSize] = null;
                if (m_actionQueueSize > 0) {
                    n2 = nArray[0];
                    MapObject mapObject = mapObjectArray[0];
                    int n3 = m_actionQueueArg2s[0];
                    int n4 = m_actionQueueArg3s[0];
                    StateInGame.startPlayerAction(n2, mapObject, n3, n4);
                }
            } else if (nArray[0] != mapObjectSim.getSimAction() && (Main.m_simData.d_actionFlags[n = mapObjectSim.getSimAction()] & 0x40000) == 0) {
                nArray[0] = n;
                mapObjectArray[0] = mapObjectSim.getSimActionArg1();
            }
        } else {
            int n = mapObjectSim.getSimAction();
            if ((Main.m_simData.d_actionFlags[n] & 0x40000) == 0) {
                nArray[0] = mapObjectSim.getSimAction();
                mapObjectArray[0] = mapObjectSim.getSimActionArg1();
                m_actionQueueSize = 1;
            }
        }
    }

    public static void processSimAction(int n, MapObject mapObject, int n2, int n3) {
        StateInGame.resetPlayerInactivity();
        if (StateInGame.getPlayerSim().isIdle()) {
            StateInGame.startPlayerAction(n, mapObject, n2, n3);
        } else {
            int n4 = m_actionQueueSize == 3 ? 2 : m_actionQueueSize++;
            StateInGame.m_actionQueueActions[n4] = n;
            StateInGame.m_actionQueueArg1s[n4] = mapObject;
            StateInGame.m_actionQueueArg2s[n4] = n2;
            StateInGame.m_actionQueueArg3s[n4] = n3;
        }
    }

    public static void startPlayerAction(int n, MapObject mapObject, int n2, int n3) {
        MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
        mapObjectSim.beginSimAction(n, mapObject, n2, n3);
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        int n4 = mapObjectSimArray.length;
        for (int i = 0; i < n4; ++i) {
            MapObjectSim mapObjectSim2 = mapObjectSimArray[i];
            if (mapObjectSim2 != null && mapObjectSim2.equals(mapObjectSim)) continue;
            mapObjectSim2.playerAction(mapObject);
        }
    }

    public static void cancelSimAction() {
        StateInGame.resetPlayerInactivity();
        m_playerSim.setOccupied(null);
        if (m_actionQueueSize > 0) {
            StateInGame.m_actionQueueActions[--StateInGame.m_actionQueueSize] = -1;
            StateInGame.m_actionQueueArg1s[StateInGame.m_actionQueueSize] = null;
            if (m_actionQueueSize == 0) {
                m_playerSim.interrupt();
            }
        }
    }

    public static void processCancelAction(MapObject mapObject) {
        StateInGame.resetPlayerInactivity();
        if (mapObject != null) {
            m_playerSim.setOccupied(null);
        }
        if (mapObject != null && m_actionQueueSize > 0) {
            int n = ArrayHandler.indexOf(mapObject, m_actionQueueArg1s);
            if (n == 0) {
                StateInGame.getPlayerSim().interrupt();
            } else if (n > 0) {
                --m_actionQueueSize;
                for (int i = n; i < m_actionQueueSize; ++i) {
                    StateInGame.m_actionQueueActions[i] = m_actionQueueActions[i + 1];
                    StateInGame.m_actionQueueArg1s[i] = m_actionQueueArg1s[i + 1];
                    StateInGame.m_actionQueueArg2s[i] = m_actionQueueArg2s[i + 1];
                    StateInGame.m_actionQueueArg3s[i] = m_actionQueueArg3s[i + 1];
                }
                StateInGame.m_actionQueueArg1s[StateInGame.m_actionQueueSize] = null;
            }
        }
    }

    public static void processCallAction() {
        int n = m_contextMenuItems[2] + 5;
        short s = m_contextMenuActions[n];
        short s2 = m_contextMenuItems[n];
        if (s2 == 30 || s2 == 29) {
            m_contextMenuBackCursor = m_contextMenuItems[2];
            m_contextMenuOnSubMenu = true;
            Main.m_simData.createCallContextMenu(m_contextMenuItems, m_contextMenuActions, s);
            StateInGame.m_contextMenuItems[4] = m_maxContextMenuItems;
            if (m_contextMenuItems[0] == 0) {
                StateInGame.hideMenus();
                StateInGame.showMessageBox(510, 531);
            }
        } else {
            StateInGame.hideMenus();
            int n2 = Main.m_simData.getSimByName(s2);
            StateInGame.processSimAction(s, Cursor.m_cursorObject, n2, 0);
        }
    }

    public static void finishCallAction(int n, int n2) {
        if (n == 144) {
            if (StateInGame.findSim(n2) != null) {
                StateInGame.showMessageBox(497, 30);
            } else if (StateInGame.nextAvailableBank() != -1 && Main.m_simData.acceptInvitation(n2)) {
                MapObject mapObject = StateInGame.findRandomObjectByType(4);
                Debug.ASSERT(mapObject != null, "no town object!");
                MapObjectSim mapObjectSim = (MapObjectSim)StateInGame.createObject(1, mapObject.getPosX(), mapObject.getPosZ(), mapObject.getFacingDir(), n2);
                mapObjectSim.setNeedFlag(32);
                StateInGame.showMessageBox(496, 30);
                Main.m_simData.dreamCompleteEvent(17);
            } else {
                StateInGame.showMessageBox(514, 30);
            }
        } else if (n == 143) {
            if (StateInGame.findSim(n2) != null) {
                StateInGame.showMessageBox(497, 29);
            } else {
                int n3 = Main.m_simData.getRelState(n2);
                if ((Main.m_simData.getRelStateFlags(n3) & 0x10) != 0) {
                    Main.m_simData.adjustMotiveLevel(4, 0x140000);
                }
            }
        }
    }

    public static void processPlantAction() {
        int n = m_contextMenuItems[2] + 5;
        short s = m_contextMenuActions[n];
        short s2 = m_contextMenuItems[n];
        if (s2 == 89) {
            m_contextMenuBackCursor = m_contextMenuItems[2];
            m_contextMenuOnSubMenu = true;
            Main.m_simData.createPlantContextMenu(m_contextMenuItems, m_contextMenuActions, s);
            StateInGame.m_contextMenuItems[4] = m_maxContextMenuItems;
            if (m_contextMenuItems[0] == 0) {
                StateInGame.hideMenus();
                StateInGame.showMessageBox(513, 535);
            }
        } else {
            StateInGame.hideMenus();
            int n2 = ArrayHandler.indexOf((int)s2, Main.m_simWorld.d_itemDescStringIds);
            StateInGame.processSimAction(s, Cursor.m_cursorObject, n2, 0);
        }
    }

    public static void processCookAction() {
        int n = m_contextMenuItems[2] + 5;
        short s = m_contextMenuActions[n];
        short s2 = m_contextMenuItems[n];
        if (s2 == 70) {
            m_contextMenuBackCursor = m_contextMenuItems[2];
            m_contextMenuOnSubMenu = true;
            Main.m_simData.createCookContextMenu(m_contextMenuItems, m_contextMenuActions, s);
            StateInGame.m_contextMenuItems[4] = m_maxContextMenuItems;
            if (m_contextMenuItems[0] == 0) {
                StateInGame.hideMenus();
                StateInGame.showMessageBox(512, 534);
            }
        } else {
            StateInGame.hideMenus();
            int n2 = Main.m_simWorld.getRecipeByName(s2);
            StateInGame.processSimAction(s, Cursor.m_cursorObject, n2, 0);
        }
    }

    public static void buyFurniture() {
        StateInGame.hideMenus();
        StateInGame.stateTransition(7);
        StateInGame.stateTransitionBuildMode(2);
    }

    public static void updateSimData(int n) {
        block7: {
            block5: {
                block8: {
                    int n2;
                    block6: {
                        int n3;
                        if (m_timeHit != 0) {
                            Main.m_simData.update(m_timeHit * 1000, false);
                            m_timeHit = 0;
                        } else {
                            n3 = n;
                            if (Main.m_simData.getFastforward()) {
                                n3 <<= 4;
                            }
                            Main.m_simData.update(n3, true);
                        }
                        n3 = Main.m_simData.getMoodLevel();
                        m_displayedMoodLevel = Debug.UserInterface_interpolateValue(m_displayedMoodLevel, n3, n, 8);
                        if (StateInGame.getPlayerSim().isWorking()) break block5;
                        n2 = Main.m_simData.getTimeFlags(0);
                        if ((n2 & 1) == 0 || StateInGame.isShowingTickerMessage()) break block6;
                        StateInGame.showTickerMessage(329, -1);
                        break block7;
                    }
                    if (StateInGame.isShowingTickerMessage()) break block7;
                    if ((n2 & 2) != 0) break block8;
                    if (m_timeHit == 0) break block7;
                    if ((n2 & 4) == 0) break block7;
                }
                StateInGame.showTickerMessage(421, -1);
                break block7;
            }
            StateInGame.cancelWorkMessages();
        }
    }

    public static void cancelWorkMessages() {
        StateInGame.cancelTickerMessage(421);
        StateInGame.cancelTickerMessage(329);
    }

    public static void checkGameTimeTriggers(int n, int n2) {
        if (!StateInGame.getPlayerSim().isWorking() && Main.m_simData.getSimCareer(0) != -1) {
            for (int i = n; i < n2; ++i) {
                int n3 = Main.m_simData.getTimeFlags(0, i);
                int n4 = Main.m_simData.getTimeFlags(0, i + 1);
                if ((n3 & 2) == 0) continue;
                if ((n4 & 4) == 0) continue;
                Main.m_simData.careerDayMissed();
                StateInGame.cancelWorkMessages();
                MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
                int n5 = mapObjectSim.m_simActionPrev;
                if (Main.m_simData.getSimCareer(0) == -1) {
                    StateInGame.showMessageBox(344, 343, 2);
                    break;
                }
                StateInGame.showMessageBox(472, 471, 2);
                break;
            }
        }
    }

    public static void renderPlayerGem(int n, int n2) {
        if (m_state != 19) {
            m_playerGemAnimPlayer.drawAnim(n, n2);
        }
    }

    public static void renderBuffs() {
        int n = 245 - m_hudBottomHeight;
        if (m_tickerString1 != -1) {
            n -= AnimationManager.getAnimFrameHeight(747, 0);
        }
        int n2 = 0;
        while (true) {
            if (n2 >= 6) break;
            short s = Main.m_simData.m_buffsActive[n2];
            if (s != -1) {
                short s2 = Main.m_simData.d_buffDescStringIds[s];
                int n3 = AnimationManager.TextHandler_getLineHeight(1);
                int n4 = AnimationManager.TextHandler_getStringWidth(s2, 1);
                int n5 = 6 + AnimationManager.getAnimFrameWidth(m_buffDroppingAnimPlayer.getAnimID(), m_buffDroppingAnimPlayer.getCurrAnimFrame());
                int n6 = n4 + n5 + 3;
                AnimationManager.setColor(47);
                ArrayOptimizer.PMGraphics_fillRect(0, n - n3, n6, n3);
                if ((Main.m_simData.d_buffFlags[s] & 1) == 0) {
                    m_buffDroppingAnimPlayer.drawAnim(3, n);
                } else {
                    m_buffRisingAnimPlayer.drawAnim(3, n);
                }
                AnimationManager.TextHandler_drawString(s2, 1, n5, n, 36);
                n -= n3;
            }
            ++n2;
        }
    }

    public static void triggerChanceCard(int n) {
        m_questId = n;
        m_questSimId = -1;
        m_chanceCardOutcome = -1;
        StateInGame.stateTransition(18);
        StateInGame.stateTransitionQuest(0);
    }

    public static void triggerFetchQuest(int n, int n2) {
        m_questId = n;
        m_questSimId = n2;
        StateInGame.stateTransition(18);
        StateInGame.stateTransitionQuest(2);
    }

    public static void triggerFetchQuestEnd(int n, int n2) {
        m_showFetchQuestEnd = true;
        m_questId = n;
        m_questSimId = n2;
    }

    public static void stateTransitionQuest(int n) {
        m_questState = n;
        int n2 = m_questId;
        int n3 = -1;
        switch (n) {
            default: {
                break;
            }
            case 0: {
                n3 = Main.m_simData.getChanceCardPromptString(n2);
                break;
            }
            case 1: {
                n3 = Main.m_simData.getChanceCardOutcomeString(n2, m_chanceCardOutcome);
                break;
            }
            case 2: {
                n3 = Main.m_simData.getQuestPromptString(n2);
                break;
            }
            case 3: {
                n3 = Main.m_simData.getQuestMessageString(n2);
                break;
            }
            case 4: {
                StateInGame.stateTransition(5);
            }
        }
        if (n3 != -1) {
            int n4 = -1;
            n4 = m_questSimId != -1 ? Main.m_simData.getSimName(m_questSimId) : 225;
            Debug.UserInterface_prepareGenericMessageBox(n3, n4);
        }
        StateInGame.setupSoftkeys();
    }

    public static void renderQuest() {
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            Event.PostEffects_renderBackgroundDim();
            Debug.UserInterface_drawGenericMessageBox();
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void processKeysQuest() {
        switch (m_questState) {
            default: {
                break;
            }
            case 1: {
                if (!ArrayHandler.PMInput_isPressed(1) && !Main.softPressPos() && !Main.softPressNeg()) break;
                StateInGame.stateTransitionQuest(4);
                Main.m_simData.performChanceCardOutcome(m_questId, m_chanceCardOutcome);
                break;
            }
            case 0: {
                if (ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) {
                    m_chanceCardOutcome = Main.m_simData.getChanceCardOutcome(m_questId, true);
                    StateInGame.stateTransitionQuest(1);
                    break;
                }
                if (!Main.softPressNeg()) break;
                m_chanceCardOutcome = Main.m_simData.getChanceCardOutcome(m_questId, false);
                StateInGame.stateTransitionQuest(1);
                break;
            }
            case 2: {
                if (!ArrayHandler.PMInput_isPressed(1) && !Main.softPressPos()) break;
                StateInGame.stateTransitionQuest(4);
                break;
            }
            case 3: {
                if (!ArrayHandler.PMInput_isPressed(1) && !Main.softPressPos()) break;
                Main.m_simData.questCompleted(m_questId);
                StateInGame.stateTransitionQuest(4);
            }
        }
    }

    public static void openShop(MapObject mapObject) {
        m_shoppingObjectType = mapObject.getType();
        m_shoppingFlagLatest = Main.m_simWorld.getShopFlags(m_shoppingObjectType);
        m_shoppingTradeAmount = 0;
        StateInGame.stateTransition(17);
        StateInGame.stateTransitionShopping();
    }

    public static void stateTransitionShopping() {
        StateInGame.initListShopping();
        StateInGame.setupSoftkeys();
    }

    public static void renderShopping() {
        int n = Main.m_simWorld.getItemNthItem(m_shoppingObjectType, Debug.UserInterface_getListCursor());
        Debug.UserInterface_setUIPlaceholderString(1, Main.m_simWorld.d_objectStringIds[m_shoppingObjectType]);
        int n2 = Main.m_simWorld.getItemBuyPrice(n);
        if (n2 > 0) {
            SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
            AnimationManager.TextHandler_appendMoneyToBuffer(n2);
            AnimationManager.TextHandler_dynamicString(-9, sDKString);
            Debug.UserInterface_setUIPlaceholderString(2, -9);
        } else {
            Debug.UserInterface_setUIPlaceholderString(2, 521);
        }
        short s = Main.m_simWorld.d_itemSellPrices[n];
        if (s > 0) {
            SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
            AnimationManager.TextHandler_appendMoneyToBuffer(s);
            AnimationManager.TextHandler_dynamicString(-8, sDKString);
            Debug.UserInterface_setUIPlaceholderString(3, -8);
        } else {
            Debug.UserInterface_setUIPlaceholderString(3, 521);
        }
        int n3 = m_shoppingTradeAmount >= 0 ? m_shoppingTradeAmount * n2 : -m_shoppingTradeAmount * s;
        SDKString sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendIntToBuffer(Main.m_simData.getInventoryCount(n));
        AnimationManager.TextHandler_appendStringIdToBuffer(345);
        AnimationManager.TextHandler_appendIntToBuffer(Main.m_simWorld.d_itemMaxInventory[n]);
        AnimationManager.TextHandler_dynamicString(-7, sDKString);
        Debug.UserInterface_setUIPlaceholderString(4, -7);
        sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendIntToBuffer(m_shoppingTradeAmount);
        AnimationManager.TextHandler_dynamicString(-6, sDKString);
        Debug.UserInterface_setUIPlaceholderString(5, -6);
        sDKString = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendMoneyToBuffer(n3);
        AnimationManager.TextHandler_dynamicString(-5, sDKString);
        Debug.UserInterface_setUIPlaceholderString(6, -5);
        Debug.UserInterface_drawUIFullScreen(25);
    }

    public static void initListShopping() {
        Debug.UserInterface_initList(Main.m_simWorld.getItemNthCount(m_shoppingObjectType), 18, 0);
    }

    public static void processKeysShopping() {
        if (Main.softPressNeg()) {
            StateInGame.stateTransition(5);
            return;
        }
        if (Debug.UserInterface_processKeysList()) {
            int n;
            StateInGame.setShoppingTradeAmount(0);
            if (!showConsumablesTutorial && (Main.m_simWorld.d_itemFlags[n = Main.m_simWorld.getItemNthItem(m_shoppingObjectType, Debug.UserInterface_getListCursor())] & 0x800) != 0) {
                showConsumablesTutorial = true;
            }
        } else if ((ArrayHandler.PMInput_isPressed(1) || Main.softPressPos()) && m_shoppingTradeAmount != 0) {
            int n = -1;
            int n2 = Main.m_simWorld.getItemNthItem(m_shoppingObjectType, Debug.UserInterface_getListCursor());
            int n3 = m_shoppingTradeAmount * (m_shoppingTradeAmount > 0 ? Main.m_simWorld.getItemBuyPrice(n2) : Main.m_simWorld.d_itemSellPrices[n2]);
            Main.m_simData.adjustInventory(n2, m_shoppingTradeAmount);
            if (m_shoppingTradeAmount > 0) {
                if ((Main.m_simWorld.d_itemFlags[n2] & 0x20) != 0) {
                    Main.m_simData.dreamCompleteEvent(42);
                }
                if ((Main.m_simWorld.d_itemFlags[n2] & 0x400) != 0) {
                    Main.m_simData.dreamCompleteEvent(3);
                }
                if ((Main.m_simWorld.d_itemFlags[n2] & 0x1000) != 0) {
                    if ((amountSpentOnHobbyRoom += Math.abs(n3)) >= 2000) {
                        Main.m_simData.dreamCompleteEvent(53);
                    }
                    boolean bl = true;
                    for (int i = 0; i < HOBBYROOM_ITEMS.length; ++i) {
                        if (Main.m_simData.getInventoryCount(HOBBYROOM_ITEMS[i]) != 0) continue;
                        bl = false;
                    }
                    if (bl) {
                        Main.m_simData.dreamCompleteEvent(55);
                    }
                }
            } else if (m_shoppingTradeAmount < 0 && (Main.m_simWorld.d_itemFlags[n2] & 0x800) != 0) {
                n = 3;
                if ((Main.m_simWorld.d_itemFlags[n2] & 0x4000) != 0) {
                    if ((numItemsSoldArt += -m_shoppingTradeAmount) >= 10) {
                        Main.m_simData.dreamCompleteEvent(21);
                    }
                    if (n2 == 5) {
                        Main.m_simData.dreamCompleteEvent(13);
                    }
                }
                if ((Main.m_simWorld.d_itemFlags[n2] & 0x8000) != 0) {
                    if ((numItemsSoldFashion += -m_shoppingTradeAmount) >= 10) {
                        Main.m_simData.dreamCompleteEvent(38);
                    }
                    if (n2 == 12) {
                        Main.m_simData.dreamCompleteEvent(35);
                    }
                }
                if ((Main.m_simWorld.d_itemFlags[n2] & 0x10000) != 0) {
                    if ((numItemsSoldMusic += -m_shoppingTradeAmount) >= 10) {
                        Main.m_simData.dreamCompleteEvent(27);
                    }
                    if (n2 == 19) {
                        Main.m_simData.dreamCompleteEvent(12);
                    }
                }
                if ((Main.m_simWorld.d_itemFlags[n2] & 0x20000) != 0) {
                    if ((numItemsSoldSport += -m_shoppingTradeAmount) >= 10) {
                        Main.m_simData.dreamCompleteEvent(50);
                    }
                    if (n2 == 26) {
                        Main.m_simData.dreamCompleteEvent(47);
                    }
                }
            }
            Main.m_simData.adjustMoney(-n3, n);
            StateInGame.setShoppingTradeAmount(0);
        } else {
            if (ArrayHandler.PMInput_isPressed(8)) {
                StateInGame.setShoppingTradeAmount(m_shoppingTradeAmount - 1);
            }
            if (ArrayHandler.PMInput_isPressed(16)) {
                StateInGame.setShoppingTradeAmount(m_shoppingTradeAmount + 1);
            }
        }
    }

    public static void setShoppingTradeAmount(int n) {
        int n2 = Main.m_simWorld.getItemNthItem(m_shoppingObjectType, Debug.UserInterface_getListCursor());
        int n3 = Main.m_simData.getMoney();
        int n4 = Main.m_simWorld.getItemBuyPrice(n2);
        short s = Main.m_simWorld.d_itemSellPrices[n2];
        int n5 = n4 <= 0 ? 0 : Math.min(Math.min(Main.m_simWorld.d_itemMaxInventory[n2] - Main.m_simData.getInventoryCount(n2), n3 / n4), Main.m_simWorld.d_itemMaxInventory[n2]);
        int n6 = s <= 0 ? 0 : -Main.m_simData.getInventoryCount(n2);
        m_shoppingTradeAmount = Camera.MathExt_clip(n, n6, n5);
        StateInGame.setupSoftkeys();
    }

    public static void update() {
        Intro.StateMenu_page = -1;
        Intro.StateMenu_firstPageElementY = 0;
        Intro.StateMenu_pageItemVertSpacing = 0;
        Intro.StateMenu_lastPageElementY = 0;
        Intro.StateMenu_lastPageElementH = 0;
        Intro.StateMenu_availableVerticalPageSpace = 0;
        Intro.StateMenu_skillsPageDrawn = false;
        relationshipBarY = 0;
        Intro.StateMenu_enableTextAdjustments = false;
        ArrayOptimizer.Touch_clear();
        long l = Intro.PMTimer_tick();
        timeInterval = (int)(l - timeStamp);
        timeStamp = l;
        if (Debug.m_debugSlowMo) {
            timeInterval = Math.max(1, timeInterval >> 2);
        }
        if (timeInterval > 150) {
            timeInterval = 150;
        }
        Event.PostEffects_update(timeInterval);
        StateInGame.processKeys();
        Main.updateSoftKeys(timeInterval);
        StateInGame.updateStep(timeInterval);
        StateInGame.render();
        Event.PMSystem_nextFrame();
    }

    static {
        m_tempInt10 = new int[10];
        m_mapMode = 0;
        m_mapModePrev = 0;
        m_debugHideObjects = false;
        m_debugFastforward = false;
        m_palSources = new int[32];
        m_palPatches = new int[32];
        first = true;
        lastMessageFun = -1;
        m_showEndOfGameScreen = false;
        lastVisitorTime = 0;
        currentVisitorChance = 0;
        HOBBYROOM_ITEMS = new int[]{2, 9, 16, 23};
        m_isCursorOnMove = false;
    }
}

