/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKString;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Camera;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.TileMap;
import dk.progressivemedia.skeleton.state.StateInGame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SimWorld {
    public int m_cameraPosX;
    public int m_cameraPosZ;
    public byte[] d_objectParents;
    public short[] d_objectStringIds;
    public short[] d_objectActionIcons;
    public int[] d_objectFlags;
    public short[] d_objectNeeds;
    public short[] d_objectBuyPrices;
    public short[] d_objectSellPrices;
    public byte[] d_objectFootprintWidths;
    public byte[] d_objectFootprintHeights;
    public short[] d_objectAnimIds;
    public short[][] d_objectAnimSetIds;
    public byte[] d_objectInterestPointXs;
    public byte[] d_objectInterestPointYs;
    public short[] d_objectActions;
    public short[] d_objectActionOffsets;
    public short[] d_animSetIndexes;
    public short[][] d_appearances;
    public byte[][] d_tileArrays;
    public short[] d_itemDescStringIds;
    public short[] d_itemIcons;
    public int[] d_itemFlags;
    public short[] d_itemBuyPrices;
    public short[] d_itemSellPrices;
    public byte[] d_itemMaxInventory;
    public byte[] d_recipeItems;
    public byte[] d_recipeReplenishes;
    public short[][] d_recipeIngredients;
    public short[] d_houseMacroObjects;
    private byte[][] d_houseRoomXs;
    private byte[][] d_houseRoomYs;
    private byte[][] d_houseRoomWidths;
    private byte[][] d_houseRoomHeights;
    private byte[][] d_houseRoomFloors;
    private byte[][] d_houseRoomWalls;
    private byte[][] d_houseDoorXs;
    private byte[][] d_houseDoorYs;
    private byte[][] d_houseDoorWidths;
    private byte[][] d_houseObjectXs;
    private byte[][] d_houseObjectZs;
    private short[][] d_houseObjectTypes;
    private byte[][] d_houseObjectFacingDirs;
    public int m_houseId;
    public byte[] m_playerHouseObjectXs;
    public byte[] m_playerHouseObjectZs;
    public short[] m_playerHouseObjectTypes;
    public byte[] m_playerHouseObjectFacingDirs;
    public int m_viewportX;
    public int m_viewportY;
    public int m_viewportWidth;
    public int m_viewportHeight;
    public int potentialVisitor = -1;
    public static final int[] ROTATION_FLAGS = new int[]{256, 512, 1024, 2048};
    private byte[] m_attributesLayer;
    public TileMap m_tileMap;
    public TileMap m_tileMapWalls;
    public short[] d_objectBuyPricesLocation;
    public int[][] d_patches;
    public byte[][] d_pals;
    private int m_pathStartX;
    private int m_pathStartY;
    private int m_pathDestX;
    private int m_pathDestY;
    private int[] m_pathAvoidTiles;
    private int m_pathNumAvoidTiles;
    private int m_pathOffsetX;
    private int m_pathOffsetY;
    private short[] m_pathOpenList;
    private int m_pathOpenCount;
    private long[] m_pathClosedLookup;
    private short[][] m_pathParentArray;
    private int[][] m_pathFCost;
    private int[][] m_pathGCost;
    private int[][] m_pathHCost;
    private short[] m_pathList;
    private int m_pathFlags;

    public SimWorld() {
        this.initWorld();
        this.initHouses();
        this.initColors();
        this.pathInit();
    }

    private void initWorld() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Cursor.ResourceManager_loadBinaryFile(89);
        int n10 = GameConstants.PMFile_readShort();
        this.d_objectParents = new byte[n10];
        this.d_objectStringIds = new short[n10];
        this.d_objectActionIcons = new short[n10];
        this.d_objectFlags = new int[n10];
        this.d_objectNeeds = new short[n10];
        this.d_objectBuyPrices = new short[n10];
        this.d_objectSellPrices = new short[n10];
        this.d_objectFootprintWidths = new byte[n10];
        this.d_objectFootprintHeights = new byte[n10];
        this.d_objectAnimIds = new short[n10];
        this.d_objectAnimSetIds = new short[n10][];
        this.d_objectActions = new short[n10 * 5];
        this.d_objectActionOffsets = new short[n10 + 1];
        this.d_objectInterestPointXs = new byte[n10 * 5];
        this.d_objectInterestPointYs = new byte[n10 * 5];
        for (n9 = 0; n9 < n10; ++n9) {
            this.d_objectParents[n9] = GameConstants.PMFile_readByte();
            this.d_objectStringIds[n9] = AnimationManager.SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_objectActionIcons[n9] = AnimationManager.SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_objectFlags[n9] = GameConstants.PMFile_readInt();
            this.d_objectNeeds[n9] = AnimationManager.SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            if (this.d_objectNeeds[n9] == -1) {
                this.d_objectNeeds[n9] = 0;
            }
            this.d_objectBuyPrices[n9] = GameConstants.PMFile_readShort();
            this.d_objectSellPrices[n9] = GameConstants.PMFile_readShort();
            this.d_objectFootprintWidths[n9] = GameConstants.PMFile_readByte();
            this.d_objectFootprintHeights[n9] = GameConstants.PMFile_readByte();
            this.d_objectAnimIds[n9] = AnimationManager.SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            n8 = GameConstants.PMFile_readByte();
            this.d_objectAnimSetIds[n9] = new short[n8];
            for (n7 = 0; n7 < n8; ++n7) {
                this.d_objectAnimSetIds[n9][n7] = GameConstants.PMFile_readShort();
            }
            n7 = GameConstants.PMFile_readByte();
            n6 = n9 * 5;
            this.d_objectInterestPointXs[n6] = (byte)n7;
            this.d_objectInterestPointYs[n6] = (byte)n7;
            for (n5 = 1; n5 <= n7; ++n5) {
                this.d_objectInterestPointXs[n6 + n5] = GameConstants.PMFile_readByte();
                this.d_objectInterestPointYs[n6 + n5] = GameConstants.PMFile_readByte();
            }
            n5 = GameConstants.PMFile_readByte();
            n4 = this.d_objectActionOffsets[n9];
            this.d_objectActionOffsets[n9 + 1] = (short)(n4 + n5);
            for (n3 = 0; n3 < n5; ++n3) {
                this.d_objectActions[n4 + n3] = AnimationManager.SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            }
        }
        this.d_objectAnimSetIds = ArrayOptimizer.Optimize(this.d_objectAnimSetIds);
        n9 = GameConstants.PMFile_readShort();
        n8 = n9 << 2;
        this.d_animSetIndexes = new short[n8];
        for (n7 = 0; n7 < n8; ++n7) {
            this.d_animSetIndexes[n7] = AnimationManager.SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
        }
        n7 = GameConstants.PMFile_readByte();
        this.d_appearances = new short[n7][];
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = GameConstants.PMFile_readByte();
            n4 = n5 << 1;
            this.d_appearances[n6] = new short[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.d_appearances[n6][n3] = GameConstants.PMFile_readShort();
            }
        }
        this.d_appearances = ArrayOptimizer.Optimize(this.d_appearances);
        n6 = GameConstants.PMFile_readByte();
        n5 = GameConstants.PMFile_readByte();
        n4 = GameConstants.PMFile_readByte();
        this.d_tileArrays = new byte[n4][];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = GameConstants.PMFile_readByte();
            this.d_tileArrays[n3] = new byte[n2];
            for (n = 0; n < n2; ++n) {
                this.d_tileArrays[n3][n] = GameConstants.PMFile_readByte();
            }
        }
        this.d_tileArrays = ArrayOptimizer.Optimize(this.d_tileArrays);
        n3 = GameConstants.PMFile_readByte();
        this.d_itemDescStringIds = new short[n3];
        this.d_itemIcons = new short[n3];
        this.d_itemFlags = new int[n3];
        this.d_itemBuyPrices = new short[n3];
        this.d_itemSellPrices = new short[n3];
        this.d_itemMaxInventory = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.d_itemDescStringIds[n2] = AnimationManager.SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_itemIcons[n2] = AnimationManager.SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            this.d_itemFlags[n2] = GameConstants.PMFile_readInt();
            this.d_itemBuyPrices[n2] = GameConstants.PMFile_readShort();
            this.d_itemSellPrices[n2] = GameConstants.PMFile_readShort();
            this.d_itemMaxInventory[n2] = GameConstants.PMFile_readByte();
        }
        n2 = GameConstants.PMFile_readByte();
        this.d_recipeItems = new byte[n2];
        this.d_recipeReplenishes = new byte[n2];
        this.d_recipeIngredients = new short[n2][];
        for (n = 0; n < n2; ++n) {
            this.d_recipeItems[n] = GameConstants.PMFile_readByte();
            this.d_recipeReplenishes[n] = GameConstants.PMFile_readByte();
            int n11 = GameConstants.PMFile_readByte();
            this.d_recipeIngredients[n] = new short[n11];
            for (int i = 0; i < n11; ++i) {
                this.d_recipeIngredients[n][i] = GameConstants.PMFile_readByte();
            }
        }
        this.d_recipeIngredients = ArrayOptimizer.Optimize(this.d_recipeIngredients);
        GameConstants.PMFile_closeFile();
    }

    private void initHouses() {
        Cursor.ResourceManager_loadBinaryFile(87);
        int n = GameConstants.PMFile_readByte();
        this.d_houseMacroObjects = new short[n];
        this.d_houseRoomXs = new byte[n][];
        this.d_houseRoomYs = new byte[n][];
        this.d_houseRoomWidths = new byte[n][];
        this.d_houseRoomHeights = new byte[n][];
        this.d_houseRoomFloors = new byte[n][];
        this.d_houseRoomWalls = new byte[n][];
        this.d_houseDoorXs = new byte[n][];
        this.d_houseDoorYs = new byte[n][];
        this.d_houseDoorWidths = new byte[n][];
        this.d_houseObjectXs = new byte[n][];
        this.d_houseObjectZs = new byte[n][];
        this.d_houseObjectTypes = new short[n][];
        this.d_houseObjectFacingDirs = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            this.d_houseMacroObjects[i] = Cursor.SimsHousesConstants_HOUSES_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            int n4 = GameConstants.PMFile_readByte();
            this.d_houseRoomXs[i] = new byte[n4];
            this.d_houseRoomYs[i] = new byte[n4];
            this.d_houseRoomWidths[i] = new byte[n4];
            this.d_houseRoomHeights[i] = new byte[n4];
            this.d_houseRoomFloors[i] = new byte[n4];
            this.d_houseRoomWalls[i] = new byte[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.d_houseRoomXs[i][n3] = GameConstants.PMFile_readByte();
                this.d_houseRoomYs[i][n3] = GameConstants.PMFile_readByte();
                this.d_houseRoomWidths[i][n3] = GameConstants.PMFile_readByte();
                this.d_houseRoomHeights[i][n3] = GameConstants.PMFile_readByte();
                this.d_houseRoomFloors[i][n3] = (byte)Cursor.SimsHousesConstants_HOUSES_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
                this.d_houseRoomWalls[i][n3] = (byte)Cursor.SimsHousesConstants_HOUSES_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            }
            n3 = GameConstants.PMFile_readByte();
            this.d_houseDoorXs[i] = new byte[n3];
            this.d_houseDoorYs[i] = new byte[n3];
            this.d_houseDoorWidths[i] = new byte[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.d_houseDoorXs[i][n2] = GameConstants.PMFile_readByte();
                this.d_houseDoorYs[i][n2] = GameConstants.PMFile_readByte();
                this.d_houseDoorWidths[i][n2] = GameConstants.PMFile_readByte();
            }
            n2 = GameConstants.PMFile_readShort();
            this.d_houseObjectXs[i] = new byte[n2];
            this.d_houseObjectZs[i] = new byte[n2];
            this.d_houseObjectTypes[i] = new short[n2];
            this.d_houseObjectFacingDirs[i] = new byte[n2];
            for (int j = 0; j < n2; ++j) {
                this.d_houseObjectXs[i][j] = GameConstants.PMFile_readByte();
                this.d_houseObjectZs[i][j] = GameConstants.PMFile_readByte();
                this.d_houseObjectTypes[i][j] = Cursor.SimsHousesConstants_HOUSES_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
                this.d_houseObjectFacingDirs[i][j] = (byte)Cursor.SimsHousesConstants_HOUSES_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
            }
        }
        GameConstants.PMFile_closeFile();
        this.d_houseRoomXs = ArrayOptimizer.Optimize(this.d_houseRoomXs);
        this.d_houseRoomYs = ArrayOptimizer.Optimize(this.d_houseRoomYs);
        this.d_houseRoomWidths = ArrayOptimizer.Optimize(this.d_houseRoomWidths);
        this.d_houseRoomHeights = ArrayOptimizer.Optimize(this.d_houseRoomHeights);
        this.d_houseRoomFloors = ArrayOptimizer.Optimize(this.d_houseRoomFloors);
        this.d_houseRoomWalls = ArrayOptimizer.Optimize(this.d_houseRoomWalls);
        this.d_houseDoorXs = ArrayOptimizer.Optimize(this.d_houseDoorXs);
        this.d_houseDoorYs = ArrayOptimizer.Optimize(this.d_houseDoorYs);
        this.d_houseDoorWidths = ArrayOptimizer.Optimize(this.d_houseDoorWidths);
        this.d_houseObjectXs = ArrayOptimizer.Optimize(this.d_houseObjectXs);
        this.d_houseObjectZs = ArrayOptimizer.Optimize(this.d_houseObjectZs);
        this.d_houseObjectTypes = ArrayOptimizer.Optimize(this.d_houseObjectTypes);
        this.d_houseObjectFacingDirs = ArrayOptimizer.Optimize(this.d_houseObjectFacingDirs);
    }

    public void initPlayerHouse() {
        if (this.m_playerHouseObjectXs == null) {
            this.m_playerHouseObjectXs = new byte[200];
            this.m_playerHouseObjectZs = new byte[200];
            this.m_playerHouseObjectTypes = new short[200];
            this.m_playerHouseObjectFacingDirs = new byte[200];
        }
        ArrayHandler.fillArray(this.m_playerHouseObjectTypes, -1);
        byte[] byArray = this.d_houseObjectXs[0];
        byte[] byArray2 = this.d_houseObjectZs[0];
        short[] sArray = this.d_houseObjectTypes[0];
        byte[] byArray3 = this.d_houseObjectFacingDirs[0];
        System.arraycopy(byArray, 0, this.m_playerHouseObjectXs, 0, byArray.length);
        System.arraycopy(byArray2, 0, this.m_playerHouseObjectZs, 0, byArray2.length);
        System.arraycopy(sArray, 0, this.m_playerHouseObjectTypes, 0, sArray.length);
        System.arraycopy(byArray3, 0, this.m_playerHouseObjectFacingDirs, 0, byArray3.length);
    }

    public int objectBuy(int n, int n2, int n3, int n4) {
        int n5 = ArrayHandler.indexOf(-1, this.m_playerHouseObjectTypes);
        if (n5 != -1) {
            this.m_playerHouseObjectTypes[n5] = (short)n;
            this.m_playerHouseObjectXs[n5] = (byte)this.coordWorldToWorldTileX(n2);
            this.m_playerHouseObjectZs[n5] = (byte)this.coordWorldToWorldTileZ(n3);
            this.m_playerHouseObjectFacingDirs[n5] = (byte)n4;
        }
        return n5;
    }

    public int objectBuyNoRecalc(int n, byte by, byte by2, int n2) {
        int n3 = ArrayHandler.indexOf(-1, this.m_playerHouseObjectTypes);
        this.m_playerHouseObjectTypes[n3] = (short)n;
        this.m_playerHouseObjectXs[n3] = by;
        this.m_playerHouseObjectZs[n3] = by2;
        this.m_playerHouseObjectFacingDirs[n3] = (byte)n2;
        return n3;
    }

    public void objectSell(int n) {
        this.m_playerHouseObjectTypes[n] = -1;
        this.m_playerHouseObjectXs[n] = 0;
        this.m_playerHouseObjectZs[n] = 0;
        this.m_playerHouseObjectFacingDirs[n] = -1;
        Main.m_simData.removeObjectValue(0, n);
    }

    public void objectRotate(int n, int n2) {
        this.m_playerHouseObjectFacingDirs[n] = (byte)n2;
    }

    public void objectChange(int n, int n2) {
        this.m_playerHouseObjectTypes[n] = (short)n2;
    }

    public void objectChange(int n, int n2, int n3, int n4) {
        this.m_playerHouseObjectXs[n] = (byte)this.coordWorldToWorldTileX(n2);
        this.m_playerHouseObjectZs[n] = (byte)this.coordWorldToWorldTileZ(n3);
        this.m_playerHouseObjectFacingDirs[n] = (byte)n4;
    }

    public void resetRMSGameData() {
        this.initPlayerHouse();
    }

    public void loadRMSGameData(DataInputStream dataInputStream) throws IOException {
        for (int i = 0; i < this.m_playerHouseObjectTypes.length; ++i) {
            this.m_playerHouseObjectTypes[i] = dataInputStream.readShort();
            this.m_playerHouseObjectXs[i] = dataInputStream.readByte();
            this.m_playerHouseObjectZs[i] = dataInputStream.readByte();
            this.m_playerHouseObjectFacingDirs[i] = dataInputStream.readByte();
        }
    }

    public void saveRMSGameData(DataOutputStream dataOutputStream) throws IOException {
        for (int i = 0; i < this.m_playerHouseObjectTypes.length; ++i) {
            dataOutputStream.writeShort(this.m_playerHouseObjectTypes[i]);
            dataOutputStream.writeByte(this.m_playerHouseObjectXs[i]);
            dataOutputStream.writeByte(this.m_playerHouseObjectZs[i]);
            dataOutputStream.writeByte(this.m_playerHouseObjectFacingDirs[i]);
        }
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.m_viewportX = n;
        this.m_viewportY = n2;
        this.m_viewportWidth = n3;
        this.m_viewportHeight = n4;
    }

    private void clearAttribLayer() {
        if (this.m_attributesLayer == null) {
            this.m_attributesLayer = new byte[4096];
        }
        ArrayHandler.fillArray(this.m_attributesLayer, 0);
    }

    public void prepareWorldHouse(int n) {
        this.m_houseId = n;
        this.clearAttribLayer();
        this.prepareHouseTileMap(n);
        this.createObjectsHouse(n);
        this.potentialVisitor = n == 0 ? Main.m_simData.determinePotentialVisitor() : -1;
    }

    public void createObjectsHouse(int n) {
        int n2;
        int n3;
        byte[] byArray = this.d_houseObjectXs[n];
        byte[] byArray2 = this.d_houseObjectZs[n];
        short[] sArray = this.d_houseObjectTypes[n];
        byte[] byArray3 = this.d_houseObjectFacingDirs[n];
        if (this.m_houseId == 0) {
            byArray = this.m_playerHouseObjectXs;
            byArray2 = this.m_playerHouseObjectZs;
            sArray = this.m_playerHouseObjectTypes;
            byArray3 = this.m_playerHouseObjectFacingDirs;
        }
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < sArray.length; ++n3) {
            if (sArray[n3] == -1) continue;
            n2 = sArray[n3];
            if (sArray[n3] == 17) {
                n2 = Main.m_simData.getInventoryCount(2) > 0 ? 20 : (Main.m_simData.getInventoryCount(1) > 0 ? 19 : (Main.m_simData.getInventoryCount(0) > 0 ? 18 : -1));
            } else if (sArray[n3] == 25) {
                n2 = Main.m_simData.getInventoryCount(9) > 0 ? 28 : (Main.m_simData.getInventoryCount(8) > 0 ? 27 : (Main.m_simData.getInventoryCount(7) > 0 ? 26 : -1));
            } else if (sArray[n3] == 21) {
                n2 = Main.m_simData.getInventoryCount(16) > 0 ? 24 : (Main.m_simData.getInventoryCount(15) > 0 ? 23 : (Main.m_simData.getInventoryCount(14) > 0 ? 22 : -1));
            } else if (sArray[n3] == 29) {
                n2 = Main.m_simData.getInventoryCount(23) > 0 ? 32 : (Main.m_simData.getInventoryCount(22) > 0 ? 31 : (Main.m_simData.getInventoryCount(21) > 0 ? 30 : -1));
            }
            if (n2 != -1) {
                StateInGame.createObjectOnWorldTile(n2, byArray[n3], byArray2[n3], byArray3[n3], n3);
            }
            if (bl || this.d_objectParents[sArray[n3]] != 15) continue;
            bl = true;
            n4 = byArray[n3];
            n5 = byArray2[n3];
        }
        if (bl) {
            this.drawGarden(n4 + 32, n5, 3, 3);
        }
        this.drawRoad();
        n3 = this.m_houseId == 0 || StateInGame.m_mapModePrev == 0 ? 2 : 3;
        n2 = -1;
        n2 = ArrayHandler.indexOf(n3, sArray);
        byte by = byArray[n2];
        int n6 = byArray2[n2];
        int n7 = 0;
        byte by2 = byArray3[n2];
        StateInGame.createObjectOnWorldTile(n7, by, n6, by2, 0);
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        for (n6 = 0; n6 < mapObjectSimArray.length; ++n6) {
            if (mapObjectSimArray[n6].getType() == 0) continue;
            mapObjectSimArray[n6].destroy();
        }
        n6 = n3 == 2 ? n2 : -1;
        int n8 = Main.m_simData.getSimCount();
        for (int i = 1; i < n8; ++i) {
            if (Main.m_simData.getSimHome(i) != n) continue;
            int n9 = Main.m_simData.getTimeFlags(i);
            if ((n9 & 8) == 0) continue;
            if (StateInGame.nextAvailableBank() == -1) break;
            n6 = n3 == 2 ? ArrayHandler.indexOf(3, sArray, 0) : ArrayHandler.indexOf(2, sArray, n6 + 1);
            if (n6 < 0) continue;
            n7 = byArray[n6];
            by2 = byArray2[n6];
            int n10 = 1;
            byte by3 = byArray3[n6];
            MapObjectSim mapObjectSim = (MapObjectSim)StateInGame.createObjectOnWorldTile(n10, n7, by2, by3, i);
            if ((n9 & 0x10) == 0 || Main.randPercent() >= 30) continue;
            StateInGame.putSimInBed(mapObjectSim);
        }
    }

    public boolean isBenchTopObjectAt(int n, int n2) {
        byte[] byArray = this.m_playerHouseObjectXs;
        byte[] byArray2 = this.m_playerHouseObjectZs;
        short[] sArray = this.m_playerHouseObjectTypes;
        for (int i = 0; i < sArray.length; ++i) {
            int n3;
            short s = sArray[i];
            if (s == -1 || ((n3 = this.d_objectFlags[s]) & 0x40000) == 0 || n != byArray[i] || n2 != byArray2[i]) continue;
            return true;
        }
        return false;
    }

    public int getFirstFacing(int n) {
        for (int i = 0; i < 4; ++i) {
            if ((n & ROTATION_FLAGS[i]) == 0) continue;
            return i;
        }
        return -1;
    }

    public boolean isAgainstWall(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        block5: {
            block4: {
                bl = true;
                if (n5 != 0 && n5 != 2) break block4;
                int n6 = 1;
                if (n5 == 2) {
                    n6 = -1;
                }
                int n7 = n - n3 * n6;
                int n8 = n2;
                for (int i = 0; i < n4 && bl; ++i) {
                    bl = (this.getAttribute(n7, n8 - i * n6) & 0x40) != 0;
                }
                break block5;
            }
            if (n5 != 1 && n5 != 3) break block5;
            int n9 = 1;
            if (n5 == 3) {
                n9 = -1;
            }
            int n10 = n;
            int n11 = n2 - n3 * n9;
            for (int i = 0; i < n4 && bl; ++i) {
                bl = (this.getAttribute(n10 - i * n9, n11) & 0x40) != 0;
            }
        }
        return bl;
    }

    public int getObjectValidRotations(int n, int n2, int n3) {
        int n4 = this.d_objectFlags[n];
        byte by = this.d_objectFootprintWidths[n];
        byte by2 = this.d_objectFootprintHeights[n];
        int n5 = this.getObjectInterestPointCount(n);
        int n6 = 0;
        for (int i = 0; i < ROTATION_FLAGS.length; ++i) {
            int n7 = ROTATION_FLAGS[i];
            if ((n4 & n7) == 0) {
                GlobalConstants.PMDebug_println("skip rot");
                continue;
            }
            byte by3 = by;
            byte by4 = by2;
            if (i == 1 || i == 3) {
                by3 = by2;
                by4 = by;
            }
            if ((n4 & 0x40000) == 0 && !this.checkFootprintOK(n2, n3, by3, by4)) {
                GlobalConstants.PMDebug_println("skip footprint");
                continue;
            }
            if (n5 > 0) {
                int n8 = 0;
                for (int j = 0; j < n5; ++j) {
                    int n9;
                    int n10 = this.getObjectInterestPointX(n, j, i);
                    if (!this.isWorldTileWalkable(n2 + n10, n3 + (n9 = this.getObjectInterestPointZ(n, j, i)))) continue;
                    ++n8;
                }
                if (n8 < 1) {
                    GlobalConstants.PMDebug_println("skip interest");
                    continue;
                }
            }
            if ((n4 & 0x80000) != 0 && !this.isAgainstWall(n2, n3, by, by2, i)) {
                GlobalConstants.PMDebug_println("skip !againstWall");
                continue;
            }
            if ((n4 & 0x100000) != 0 && this.isAgainstWall(n2, n3, by, by2, i)) {
                GlobalConstants.PMDebug_println("skip againstWall");
                continue;
            }
            n6 |= n7;
        }
        return n6;
    }

    public int createBuildPoints(int n) {
        byte[] byArray = this.m_playerHouseObjectXs;
        byte[] byArray2 = this.m_playerHouseObjectZs;
        short[] sArray = this.m_playerHouseObjectTypes;
        byte[] byArray3 = this.m_playerHouseObjectFacingDirs;
        int n2 = this.d_objectFlags[n];
        byte by = this.d_objectFootprintWidths[n];
        byte by2 = this.d_objectFootprintHeights[n];
        byte by3 = this.d_objectParents[n];
        int n3 = 0;
        int n4 = sArray.length;
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            int n7;
            short s = sArray[i];
            if (s == -1) continue;
            byte by4 = byArray[i];
            byte by5 = byArray2[i];
            byte by6 = byArray3[i];
            int n8 = this.d_objectFlags[s];
            int n9 = this.d_objectFootprintWidths[s];
            int n10 = this.d_objectFootprintHeights[s];
            if ((n2 & 0x40000) != 0) {
                if ((n8 & 0x20000) == 0) continue;
                if (by6 == 1 || by6 == 3) {
                    n7 = n9;
                    n9 = n10;
                    n10 = n7;
                }
                for (n7 = 0; n7 < n9; ++n7) {
                    for (n6 = 0; n6 < n10; ++n6) {
                        int n11;
                        int n12;
                        n5 = by4 - n7;
                        int n13 = by5 - n6;
                        if (this.isBenchTopObjectAt(n5, n13) || (n12 = this.getFirstFacing(n11 = this.getObjectValidRotations(n, n5, n13))) == -1) continue;
                        StateInGame.createObjectOnWorldTile(9, n5, n13, n12, -1);
                        ++n3;
                    }
                }
                continue;
            }
            if ((n8 & 4) == 0 || n9 != by || n10 != by2 || (by3 != 13 && by3 != 12 && by3 != 18 ? s == 15 : s != 15) || (n6 = this.getFirstFacing(n7 = this.getObjectValidRotations(n, by4, by5))) == -1) continue;
            n5 = 0;
            for (int j = 0; j < Main.m_simData.getSimCount(); ++j) {
                MapObjectSim mapObjectSim = StateInGame.findSim(j);
                if (mapObjectSim == null || by4 != Main.m_simWorld.coordWorldToWorldTileX(mapObjectSim.getPosX()) || by5 != Main.m_simWorld.coordWorldToWorldTileZ(mapObjectSim.getPosZ())) continue;
                n5 = 1;
                break;
            }
            if (n5 != 0) continue;
            MapObject mapObject = StateInGame.createObjectOnWorldTile(8, by4, by5, n6, -1);
            if (mapObject != null) {
                mapObject.setZSortOffset(-18);
            }
            ++n3;
        }
        return n3;
    }

    public void prepareWorldZoomMap(int n, boolean bl) {
        int n2;
        this.clearAttribLayer();
        TileMap tileMap = new TileMap(n, Cursor.ResourceManager_loadImage(70));
        tileMap.setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
        tileMap.setUseOffscreenBuffer(true);
        this.m_tileMap = tileMap;
        this.initAttributesZoomMap(n);
        this.createObjectsFromTilemap(true);
        MapObject mapObject = StateInGame.findRandomObjectByType(3);
        int n3 = this.coordWorldToWorldTileX(mapObject.getPosX());
        int n4 = this.coordWorldToWorldTileZ(mapObject.getPosZ());
        if (bl) {
            int n5 = Main.m_simData.getCareerRabbitHole(Main.m_simData.getSimCareer(0));
            MapObject mapObject2 = StateInGame.findRandomObjectByType(n5);
            StateInGame.createObjectOnObjectInterestPoint(0, mapObject2, 0);
            StateInGame.startPlayerAction(183, mapObject2, 0, 0);
            StateInGame.snapCameraAndCursor(mapObject2);
        } else {
            StateInGame.createObjectOnWorldTile(0, n3, n4, 3, 0);
        }
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        for (n2 = 0; n2 < mapObjectSimArray.length; ++n2) {
            if (mapObjectSimArray[n2].getType() == 0) continue;
            mapObjectSimArray[n2].destroy();
        }
        n2 = Main.getEncounterNPCId();
        if (n2 != -1) {
            MapObject mapObject3 = StateInGame.createObjectOnWorldTile(1, n3, n4 - 1, 1, n2);
            Cursor.setCursorObject(mapObject3);
            StateInGame.showContextMenu(mapObject3);
        } else {
            this.spawnSimsZoomMap();
            Cursor.setCursorObject(StateInGame.getPlayerSim());
        }
    }

    public void spawnSimsZoomMap() {
        int n;
        int n2 = -1;
        if (Main.m_nextZoomMapId == 79) {
            n2 = 8;
        }
        if (Main.m_nextZoomMapId == 80) {
            n2 = 16;
        }
        if (Main.m_nextZoomMapId == 81) {
            n2 = 32;
        }
        if (Main.m_nextZoomMapId == 82) {
            n2 = 64;
        }
        if (n2 == -1) {
            return;
        }
        int n3 = Main.m_simData.getSimCount();
        int n4 = 0;
        int n5 = 3;
        int[] nArray = new int[n5];
        MapObject mapObject = null;
        MapObjectSim mapObjectSim = null;
        int n6 = -1;
        for (n = 1; n < n3 && StateInGame.nextAvailableBank() != -1 && n4 < n5; ++n) {
            if (ArrayHandler.indexOf(n, nArray) != -1) continue;
            mapObject = null;
            mapObjectSim = null;
            if (!Main.m_simData.hasSimGotFlag(n, n2)) continue;
            mapObject = StateInGame.findRandomMapDestination();
            mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject, n);
            if (mapObject == null || mapObjectSim == null) continue;
            nArray[n4] = n;
            ++n4;
            mapObject = StateInGame.findRandomMapDestination();
            if (mapObject.getClosestInterestPoint(mapObjectSim.getPosX(), mapObjectSim.getPosZ(), true, null) == -1) continue;
            mapObjectSim.beginSimAction(111, mapObject);
        }
        for (n = 1; n < n3 && StateInGame.nextAvailableBank() != -1 && n4 < n5; ++n) {
            n6 = Main.rand(1, n3 - 1);
            mapObject = null;
            mapObjectSim = null;
            if (ArrayHandler.indexOf(n6, nArray) != -1) continue;
            mapObject = StateInGame.findRandomMapDestination();
            mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject, n6);
            if (mapObject == null || mapObjectSim == null) continue;
            nArray[n4] = n6;
            ++n4;
            mapObject = StateInGame.findRandomMapDestination();
            if (mapObject.getClosestInterestPoint(mapObjectSim.getPosX(), mapObjectSim.getPosZ(), true, null) == -1) continue;
            mapObjectSim.beginSimAction(111, mapObject);
        }
    }

    public void prepareWorldMacromap() {
        MapObject mapObject;
        this.clearAttribLayer();
        int n = 69;
        SDKImage sDKImage = Cursor.ResourceManager_loadImage(n);
        int n2 = 83;
        TileMap tileMap = new TileMap(n2, sDKImage);
        tileMap.setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
        tileMap.setUseOffscreenBuffer(true);
        this.m_tileMap = tileMap;
        this.initAttributesMacromap();
        this.createObjectsFromTilemap(false);
        int n3 = Main.getNextHouseId();
        if (StateInGame.m_mapModePrev == 1) {
            if (Main.m_nextZoomMapIdPREV == 84) {
                StateInGame.createObject(0, Main.getEncounterPlayerX(), Main.getEncounterPlayerZ(), 0, 0);
                int n4 = Main.getEncounterNPCId();
                if (n4 != -1) {
                    StateInGame.createObject(1, Main.getEncounterNPCX(), Main.getEncounterNPCZ(), 0, n4);
                }
                Main.setupEncounter(null);
            } else if (Main.m_nextZoomMapIdPREV == 79) {
                mapObject = StateInGame.findRandomObjectByType(111);
                StateInGame.createObjectOnObjectInterestPoint(0, mapObject, 0);
            } else if (Main.m_nextZoomMapIdPREV == 80) {
                mapObject = StateInGame.findRandomObjectByType(113);
                StateInGame.createObjectOnObjectInterestPoint(0, mapObject, 0);
            } else if (Main.m_nextZoomMapIdPREV == 81) {
                mapObject = StateInGame.findRandomObjectByType(112);
                StateInGame.createObjectOnObjectInterestPoint(0, mapObject, 0);
            } else if (Main.m_nextZoomMapIdPREV == 82) {
                mapObject = StateInGame.findRandomObjectByType(114);
                StateInGame.createObjectOnObjectInterestPoint(0, mapObject, 0);
            }
        } else if (n3 != -1) {
            mapObject = StateInGame.findRandomObjectByType(this.d_houseMacroObjects[n3]);
            StateInGame.createObjectOnObjectInterestPoint(0, mapObject, 0);
        }
        mapObject = null;
    }

    private void createObjectsFromTilemap(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.m_tileMap.getObjectCount();
        short[] sArray = this.m_tileMap.getObjectData();
        for (n6 = 0; n6 < n7; ++n6) {
            int n8 = n6 * 3;
            n5 = sArray[n8 + 0];
            n4 = sArray[n8 + 1] << 16;
            n3 = sArray[n8 + 2] << 16;
            n2 = this.coordScreenToWorldX(n4, n3);
            n = this.coordScreenToWorldZ(n4, n3);
            if (bl) {
                n2 = this.coordWorldTileToWorldCenterX(this.coordWorldToWorldTileX(n2));
                n = this.coordWorldTileToWorldCenterZ(this.coordWorldToWorldTileZ(n));
            }
            if (n5 == 65) {
                StateInGame.createObject(n5, n2, n, 0, n6);
                continue;
            }
            StateInGame.createObject(n5, n2, n, 0, -1);
        }
        n6 = this.m_tileMap.getAnimCount();
        short[] sArray2 = this.m_tileMap.getAnimData();
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = n5 * 3;
            n3 = sArray2[n4 + 0];
            n2 = sArray2[n4 + 1] << 16;
            n = sArray2[n4 + 2] << 16;
            int n9 = this.coordScreenToWorldX(n2, n);
            int n10 = this.coordScreenToWorldZ(n2, n);
            if (bl) {
                n9 = this.coordWorldTileToWorldCenterX(this.coordWorldToWorldTileX(n9));
                n10 = this.coordWorldTileToWorldCenterZ(this.coordWorldToWorldTileZ(n10));
            }
            MapObject mapObject = StateInGame.createObject(99, n9, n10, 0, -1);
            mapObject.setAnim(n3);
            if (n3 == 244 || n3 == 245 || n3 == 242 || n3 == 243) {
                mapObject.setZSortOffset(-18);
            }
            if (n3 != 249 && n3 != 250 && n3 != 251 && n3 != 252 && n3 != 253) continue;
            mapObject.setZSortOffset(-25);
        }
    }

    public void unload() {
        this.m_tileMap = null;
        this.m_tileMapWalls = null;
        Event.PMSystem_forceGC();
    }

    public void renderWorld() {
        TileMap tileMap = this.m_tileMap;
        int n = ArrayOptimizer.PMGraphics_getClipX();
        int n2 = ArrayOptimizer.PMGraphics_getClipY();
        int n3 = ArrayOptimizer.PMGraphics_getClipWidth();
        int n4 = ArrayOptimizer.PMGraphics_getClipHeight();
        ArrayOptimizer.PMGraphics_setClip(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
        tileMap.setCameraX(this.m_cameraPosX - (this.m_viewportWidth >> 1 << 16));
        tileMap.setCameraY(this.m_cameraPosZ - (this.m_viewportHeight >> 1 << 16) + StateInGame.camOffsetZ);
        tileMap.render();
        if (!StateInGame.m_debugHideObjects) {
            this.renderObjects2D();
        }
        ArrayOptimizer.PMGraphics_setClip(n, n2, n3, n4);
    }

    public int getCameraPixelX() {
        return this.m_viewportX + (this.m_viewportWidth >> 1) - (this.m_cameraPosX >> 16);
    }

    public int getCameraPixelY() {
        return this.m_viewportY + (this.m_viewportHeight >> 1) - (this.m_cameraPosZ >> 16);
    }

    public int coordWorldToScreenX(int n, int n2) {
        return (n - n2 << 1) + 0x2000000;
    }

    public int coordWorldToScreenY(int n, int n2) {
        return n + n2 + 0x1080000;
    }

    public int coordWorldToScreenPixelsX(int n, int n2) {
        return (n - n2 >> 15) + 512;
    }

    public int coordWorldToScreenPixelsY(int n, int n2) {
        return (n + n2 >> 16) + 264;
    }

    public int coordScreenToWorldX(int n, int n2) {
        return (n - 0x2000000 >> 1) + (n2 - 0x1080000) >> 1;
    }

    public int coordScreenToWorldZ(int n, int n2) {
        return (-(n - 0x2000000) >> 1) + (n2 - 0x1080000) >> 1;
    }

    public int coordWorldTileToScreenTileX(int n, int n2) {
        return n - n2;
    }

    public int coordWorldTileToScreenTileY(int n, int n2) {
        return n + n2;
    }

    public int coordWorldTileToWorldCenterX(int n) {
        return (n << 19) + 262144;
    }

    public int coordWorldTileToWorldCenterZ(int n) {
        return (n << 19) + 262144;
    }

    public int coordWorldToWorldTileX(int n) {
        return n >> 19;
    }

    public int coordWorldToWorldTileZ(int n) {
        return n >> 19;
    }

    public boolean isWorldPointWalkable(int n, int n2) {
        return this.isWorldTileWalkable(this.coordWorldToWorldTileX(n), this.coordWorldToWorldTileZ(n2));
    }

    public boolean isWorldTileWalkable(int n, int n2) {
        int n3 = this.getAttribute(n, n2);
        return (n3 & 0x80) == 0;
    }

    public int getAttribute(int n, int n2) {
        if ((n += 32) >= 0 && n < 64 && (n2 += 32) >= 0 && n2 < 64) {
            int n3 = n + n2 * 64;
            return this.m_attributesLayer[n3];
        }
        return 128;
    }

    private void setAttribute(int n, int n2, int n3, int n4) {
        if ((n += 32) >= 0 && n < 64 && (n2 += 32) >= 0 && n2 < 64) {
            byte[] byArray = this.m_attributesLayer;
            int n5 = n + n2 * 64;
            int n6 = byArray[n5] & n3;
            byArray[n5] = (byte)(n6 | n4);
        }
    }

    public void paintAttributes(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 32 + n; i < 32 + n + n3; ++i) {
            for (int j = 32 + n2; j < 32 + n2 + n4; ++j) {
                int n7 = i + j * 64;
                int n8 = this.m_attributesLayer[n7] & n5;
                this.m_attributesLayer[n7] = (byte)(n8 | n6);
            }
        }
    }

    public boolean checkFootprintOK(int n, int n2, int n3, int n4) {
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (this.isWorldTileWalkable(n - i, n2 - j)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void prepareHouseTileMap(int n) {
        void var15_20;
        int n2;
        int n3;
        int n4;
        byte by;
        void var15_18;
        Object object;
        int n5;
        Object object2;
        int n6;
        Object object3;
        Object object4;
        if (this.m_tileMap == null) {
            object4 = Cursor.ResourceManager_loadImage(70);
            object3 = new TileMap(64, 64, (SDKImage)object4);
            ((TileMap)object3).setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
            ((TileMap)object3).setUseOffscreenBuffer(true);
            this.m_tileMap = object3;
        }
        if (this.m_tileMapWalls == null) {
            object4 = Cursor.ResourceManager_loadImage(71);
            this.m_tileMapWalls = object3 = new TileMap(64, 64, (SDKImage)object4);
            ((TileMap)object3).setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
            this.m_tileMap.setLinkedTileMap((TileMap)object3);
        }
        object4 = this.d_houseRoomXs[n];
        object3 = this.d_houseRoomYs[n];
        byte[] byArray = this.d_houseRoomWidths[n];
        byte[] byArray2 = this.d_houseRoomHeights[n];
        byte[] byArray3 = this.d_houseRoomFloors[n];
        byte[] byArray4 = this.d_houseRoomWalls[n];
        byte[] byArray5 = this.d_houseDoorXs[n];
        byte[] byArray6 = this.d_houseDoorYs[n];
        byte[] byArray7 = this.d_houseDoorWidths[n];
        int n7 = ((Object)object4).length;
        int n8 = byArray5.length;
        for (n6 = 0; n6 < n7; ++n6) {
            object2 = object4[n6];
            Object object5 = object3[n6];
            n5 = byArray[n6];
            object = byArray2[n6];
            this.paintAttributes((int)object2, (int)object5, n5, (int)object, 255, n6 + 1 | 0x10);
            this.paintAttributes((int)(object2 - true), (int)(object5 - true), n5 + 2, 1, 255, 128);
            this.paintAttributes((int)(object2 - true), (int)(object5 + object), n5 + 2, 1, 255, 128);
            this.paintAttributes((int)(object2 - true), (int)object5, 1, (int)object, 255, 128);
            this.paintAttributes((int)(object2 + n5), (int)object5, 1, (int)object, 255, 128);
        }
        for (n6 = 0; n6 < n8; ++n6) {
            object2 = byArray5[n6];
            byte by2 = byArray6[n6];
            n5 = Math.abs(byArray7[n6]);
            if ((this.getAttribute((int)(object2 - true), by2) & 0x80) != 0) {
                this.paintAttributes((int)object2, by2, n5, 1, -129, 0);
                continue;
            }
            this.paintAttributes((int)object2, by2, 1, n5, -129, 0);
            byArray7[n6] = (byte)(-n5);
        }
        ArrayHandler.fillArray(this.m_tileMap.getTileMapData(), 16);
        ArrayHandler.fillArray(this.m_tileMapWalls.getTileMapData(), -1);
        n6 = 32;
        object2 = false;
        boolean bl = false;
        while (var15_18 < n7) {
            n5 = n6 + object4[var15_18];
            object = object2 + object3[var15_18];
            by = byArray[var15_18];
            n4 = byArray2[var15_18];
            n3 = byArray3[var15_18];
            n2 = byArray4[var15_18];
            this.drawRoom(n5, (int)object, by, n4, n3, n2);
            ++var15_18;
        }
        boolean bl2 = false;
        while (var15_20 < n8) {
            n5 = byArray5[var15_20];
            object = byArray6[var15_20];
            by = byArray7[var15_20];
            if (by > 0) {
                n4 = this.getAttribute(n5, object - 1);
                n3 = this.getAttribute(n5, object + 1);
            } else {
                n4 = this.getAttribute(n5 - 1, (int)object);
                n3 = this.getAttribute(n5 + 1, (int)object);
            }
            n2 = (n4 & 0xF) - 1;
            int n9 = (n3 & 0xF) - 1;
            int n10 = n2 == -1 ? 3 : byArray3[n2];
            int n11 = n9 == -1 ? 3 : byArray3[n9];
            byte by3 = n9 == -1 ? (byte)0 : byArray4[n9];
            this.drawDoor(n6 + n5, (int)(object2 + object), Math.abs(by), n10, n11, by3, by < 0 ? 2 : 1);
            ++var15_20;
        }
        this.tilemapFixupHouse();
        this.initAttributesHouse();
        this.m_tileMap.refreshOffscreenBuffer();
    }

    private void drawRoom(int n, int n2, int n3, int n4, int n5, int n6) {
        TileMap tileMap = this.m_tileMap;
        byte[] byArray = tileMap.getTileMapData();
        byte[] byArray2 = this.m_tileMapWalls.getTileMapData();
        int n7 = tileMap.getWidth();
        int n8 = this.coordWorldTileToScreenTileX(n, n2);
        int n9 = this.coordWorldTileToScreenTileY(n, n2);
        int n10 = n3 + n4;
        byte by = this.d_tileArrays[4][n5];
        byte by2 = this.d_tileArrays[11][n6];
        byte by3 = this.d_tileArrays[17][n6];
        byte by4 = this.d_tileArrays[7][n6];
        byte by5 = this.d_tileArrays[13][n6];
        int n11 = n8 - n4;
        int n12 = n9 + n4;
        int n13 = n12 + 1;
        for (int i = 0; i < n10; ++i) {
            int n14;
            byte by6;
            byte by7;
            boolean bl = i < n4;
            boolean bl2 = i < n3;
            byArray2[n11 + (n12 - 0) * n7] = by7 = bl ? by2 : by3;
            byArray2[n11 + (n12 - 1) * n7] = by6 = bl ? by4 : by5;
            byArray2[n11 + (n13 + 0) * n7] = n14 = bl2 ? 56 : 48;
            int n15 = n13 - n12 + 2;
            for (int j = 0; j < n15; ++j) {
                byArray[n11 + (n12 + j) * n7] = by;
            }
            if (i == 0) {
                byArray2[n11 - 1 + (n12 + 0) * n7] = this.d_tileArrays[19][n6];
            } else if (i == n10 - 1) {
                byArray2[n11 + 1 + (n12 + 0) * n7] = this.d_tileArrays[20][n6];
            }
            ++n11;
            if (i != n3 - 1) {
                n13 += bl2 ? 1 : -1;
            }
            if (i == n4 - 1) continue;
            n12 += bl ? -1 : 1;
        }
    }

    private void drawDoor(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl;
        TileMap tileMap = this.m_tileMap;
        int n8 = tileMap.getWidth();
        byte[] byArray = this.m_tileMapWalls.getTileMapData();
        int n9 = this.coordWorldTileToScreenTileX(n, n2);
        int n10 = this.coordWorldTileToScreenTileY(n, n2);
        boolean bl2 = bl = (n7 & 1) != 0;
        if (bl) {
            byte by = this.d_tileArrays[23][n6];
            byte by2 = this.d_tileArrays[24][n6];
            byte by3 = this.d_tileArrays[6][n4];
            int n11 = --n9 + n10 * n8;
            byArray[n11] = by;
            byArray[n11 += n8] = by2;
            byArray[n11 += n8] = by3;
            for (int i = 0; i < n3; ++i) {
                n11 = ++n9 + ++n10 * n8;
                byArray[n11] = -1;
                byArray[n11 += n8] = -1;
                byArray[n11 += n8] = by3;
            }
            n11 = ++n9 + ++n10 * n8;
            byArray[n11] = 52;
            if (byArray[n11 += n8] == -1) {
                byArray[n11] = this.d_tileArrays[13][n6];
                byArray[n11 += n8] = this.d_tileArrays[17][n6];
            }
        } else {
            byte by = this.d_tileArrays[21][n6];
            byte by4 = this.d_tileArrays[22][n6];
            byte by5 = this.d_tileArrays[5][n4];
            int n12 = (n9 -= 2) + ((n10 += 2) + 0) * n8;
            byArray[n12] = 52;
            if (byArray[n12 += n8] == -1) {
                byArray[n12] = this.d_tileArrays[7][n6];
                byArray[n12 += n8] = this.d_tileArrays[11][n6];
            }
            for (int i = 0; i < n3; ++i) {
                n12 = ++n9 + (--n10 + 0) * n8;
                byArray[n12] = -1;
                byArray[n12 += n8] = -1;
                byArray[n12 += n8] = by5;
            }
            n12 = ++n9 + (--n10 + 0) * n8;
            byArray[n12] = by;
            byArray[n12 += n8] = by4;
            byArray[n12 += n8] = by5;
        }
    }

    private void drawGarden(int n, int n2, int n3, int n4) {
        int n5;
        byte[] byArray = this.m_tileMap.getTileMapData();
        int n6 = this.m_tileMap.getWidth();
        int n7 = this.coordWorldTileToScreenTileX(n, n2);
        int n8 = this.coordWorldTileToScreenTileY(n, n2);
        int n9 = n3 + n4 + 2;
        int n10 = n7 - n4 - 1;
        int n11 = n5 = n8 + n4 + 1;
        byArray[n10 - 1 + (n5 - 2) * n6] = 4;
        byArray[n10 - 1 + (n5 - 1) * n6] = 12;
        byArray[n10 - 1 + n5 * n6] = 13;
        byArray[n10 - 1 + (n5 + 1) * n6] = 21;
        byArray[n10 - 2 + (n5 - 1) * n6] = 4;
        byArray[n10 - 2 + n5 * n6] = 21;
        for (int i = 0; i < n9; ++i) {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            boolean bl = i < n4 + 1;
            boolean bl2 = i < n3 + 1;
            int n17 = n11 - n5;
            for (n16 = 0; n16 < n17; ++n16) {
                byArray[n10 + (n5 + n16) * n6] = n15 = Main.randPercent() < 50 ? 6 : 7;
            }
            byArray[n10 + (n5 - 1) * n6] = n16 = bl ? 22 : 23;
            byArray[n10 + (n5 - 3) * n6] = n15 = bl ? 4 : 5;
            byArray[n10 + n11 * n6] = n14 = bl2 ? 15 : 14;
            byArray[n10 + (n11 + 2) * n6] = n13 = bl2 ? 21 : 20;
            byArray[n10 + (n5 - 2) * n6] = n12 = Main.randPercent() < 50 ? 12 : 13;
            byArray[n10 + (n11 + 1) * n6] = n12;
            if (i != n3) {
                n11 += bl2 ? 1 : -1;
            }
            if (i != n4) {
                n5 += bl ? -1 : 1;
            }
            ++n10;
        }
        byArray[n10 + (n5 - 3) * n6] = 5;
        byArray[n10 + (n5 - 2) * n6] = 12;
        byArray[n10 + (n5 - 1) * n6] = 13;
        byArray[n10 + n5 * n6] = 20;
        byArray[n10 + 1 + (n5 - 2) * n6] = 5;
        byArray[n10 + 1 + (n5 - 1) * n6] = 20;
    }

    private void drawRoad() {
        MapObject mapObject = StateInGame.findRandomObjectByParentType(9);
        int n = this.coordWorldToWorldTileX(mapObject.getPosX()) + 2 + 32;
        int n2 = this.coordWorldToWorldTileZ(mapObject.getPosZ()) + 2;
        int n3 = this.coordWorldTileToScreenTileX(n, n2);
        this.m_tileMap.getTileMapData()[n3 - 1 + (i - 1) * this.m_tileMap.getWidth()] = 11;
        this.m_tileMap.getTileMapData()[n3 - 1 + i * this.m_tileMap.getWidth()] = 19;
        for (int i = this.coordWorldTileToScreenTileY(n, n2); n3 < this.m_tileMap.getWidth() && i < this.m_tileMap.getHeight() - 1; ++n3, ++i) {
            this.m_tileMap.getTileMapData()[n3 + i * this.m_tileMap.getWidth()] = 11;
            this.m_tileMap.getTileMapData()[n3 + (i - 1) * this.m_tileMap.getWidth()] = 11;
            this.m_tileMap.getTileMapData()[n3 + (i - 2) * this.m_tileMap.getWidth()] = 3;
            this.m_tileMap.getTileMapData()[n3 + (i + 1) * this.m_tileMap.getWidth()] = 19;
        }
        this.drawCorner(0, this.d_tileArrays[0]);
        int n4 = 21;
        int n5 = this.coordWorldToWorldTileZ(mapObject.getPosZ());
        this.setAttribute(n4, n5, 255, 128);
        int n6 = n5 + 2;
        while (n6 < 15) {
            this.setAttribute(n4, n6++, 255, 128);
            this.setAttribute(n4, n6++, 255, 128);
            StateInGame.createObjectOnWorldTile(55, n4, n6++, 0, -1);
            this.setAttribute(n4 - 1, n6, 255, 128);
            this.setAttribute(n4, n6++, 255, 128);
        }
        n6 = n5 - 1;
        while (n6 > -14) {
            this.setAttribute(n4 - 1, n6, 255, 128);
            this.setAttribute(n4, n6--, 255, 128);
            StateInGame.createObjectOnWorldTile(55, n4, n6--, 0, -1);
            this.setAttribute(n4, n6--, 255, 128);
            this.setAttribute(n4, n6--, 255, 128);
        }
    }

    private void drawCorner(int n, byte[] byArray) {
        byte[] byArray2 = this.m_tileMap.getTileMapData();
        int n2 = this.m_tileMap.getWidth();
        int n3 = this.m_tileMap.getHeight();
        int n4 = byArray.length - 1;
        int n5 = n2 - n4;
        int n6 = n3 - 1;
        int n7 = 1;
        int n8 = -1;
        if (n == 1) {
            n5 = n4 - 1;
            n7 = -1;
        }
        byte[] byArray3 = this.d_tileArrays[1];
        byte[] byArray4 = this.d_tileArrays[2];
        while (n5 >= 0 && n5 < n2) {
            for (int i = 0; n6 + i < n3 && i < byArray.length; ++i) {
                int n9;
                byte by = byArray[i];
                if ((n5 & 1) == 0 && (n9 = ArrayHandler.indexOf((int)by, byArray3)) != -1) {
                    by = byArray4[n9];
                }
                n9 = n6 + i;
                byArray2[n5 + n9 * n2] = by;
            }
            n5 += n7;
            n6 += n8;
        }
    }

    private void tilemapFixupHouse() {
        byte[] byArray = this.m_tileMapWalls.getTileMapData();
        byte[] byArray2 = this.m_tileMap.getTileMapData();
        int n = this.m_tileMap.getWidth();
        int n2 = this.m_tileMap.getHeight();
        byte[] byArray3 = this.d_tileArrays[3];
        byte[] byArray4 = this.d_tileArrays[4];
        byte[] byArray5 = this.d_tileArrays[25];
        byte[] byArray6 = this.d_tileArrays[7];
        byte[] byArray7 = this.d_tileArrays[13];
        byte[] byArray8 = this.d_tileArrays[19];
        byte[] byArray9 = this.d_tileArrays[20];
        for (int i = 1; i < n - 1; ++i) {
            boolean bl = false;
            for (int j = 0; j < n2 - 1; ++j) {
                int n3;
                int n4;
                int n5 = i + (j + 0) * n;
                int n6 = n5 + n;
                byte by = byArray2[n5];
                byte by2 = byArray2[n6];
                int n7 = byArray[n5];
                byte by3 = byArray[n6];
                if (n7 == 56 && by3 == -1) {
                    by3 = byArray7[0];
                }
                if (n7 == 48 && by3 == -1) {
                    by3 = byArray6[0];
                }
                if (by3 == -1 && (ArrayHandler.indexOf(n7, this.d_tileArrays[26]) != -1 || ArrayHandler.indexOf(n7, byArray8) != -1)) {
                    by3 = byArray7[0];
                    n4 = n5 + n;
                    if (byArray[n4] == -1) {
                        byArray[n4] = this.d_tileArrays[17][0];
                    }
                }
                if ((ArrayHandler.indexOf(n7, byArray5) != -1 || ArrayHandler.indexOf(n7, byArray9) != -1) && by3 == -1) {
                    by3 = byArray6[0];
                    n4 = n5 + n;
                    if (byArray[n4] == -1) {
                        byArray[n4] = this.d_tileArrays[11][0];
                    }
                }
                n4 = -1;
                n4 = ArrayHandler.indexOf(n7, byArray7);
                if (n4 != -1) {
                    if (ArrayHandler.indexOf((int)by3, byArray6) != -1 || ArrayHandler.indexOf((int)by3, byArray8) != -1) {
                        n7 = byArray9[n4];
                    } else {
                        n3 = ArrayHandler.indexOf((int)by2, byArray4);
                        if (n3 != -1 && by3 == -1) {
                            by3 = this.d_tileArrays[17][n4];
                        }
                    }
                }
                if ((n4 = ArrayHandler.indexOf(n7, byArray6)) != -1) {
                    if (ArrayHandler.indexOf((int)by3, byArray7) != -1 || ArrayHandler.indexOf((int)by3, byArray9) != -1) {
                        n7 = byArray8[n4];
                    } else {
                        n3 = ArrayHandler.indexOf((int)by2, byArray4);
                        if (n3 != -1 && by3 == -1) {
                            by3 = this.d_tileArrays[11][n4];
                        }
                    }
                }
                if ((n3 = ArrayHandler.indexOf((int)by, byArray4)) != -1) {
                    int n8;
                    int n9;
                    int n10;
                    int n11 = -1;
                    n11 = ArrayHandler.indexOf((int)by3, byArray6);
                    if (n11 != -1 || (n11 = ArrayHandler.indexOf((int)by3, byArray8)) != -1) {
                        if (!bl) {
                            int n12 = this.d_tileArrays[9][n11];
                            n10 = this.d_tileArrays[10][n11];
                            for (n9 = 0; n9 < 5; ++n9) {
                                byArray[i + (j - n9) * n] = n8 = n9 == 4 ? n12 : n10;
                            }
                            n7 = n10;
                            byArray[i + (j - 5 - 1) * n] = 52;
                            n9 = i + (j - 5 - 0) * n;
                            byArray[n9] = this.d_tileArrays[8][n11];
                            if (byArray[--n9] == 52) {
                                byArray[n9] = 48;
                            }
                            if ((n11 = ArrayHandler.indexOf((int)by3, byArray6)) != -1) {
                                by3 = this.d_tileArrays[12][n11];
                            } else {
                                n11 = ArrayHandler.indexOf((int)by3, byArray8);
                                if (n11 != -1) {
                                    by3 = this.d_tileArrays[26][n11];
                                }
                            }
                            bl = true;
                        } else if (n7 == -1) {
                            n7 = 48;
                        }
                    } else {
                        n11 = ArrayHandler.indexOf((int)by3, byArray7);
                        if (n11 != -1 || (n11 = ArrayHandler.indexOf((int)by3, byArray9)) != -1) {
                            if (!bl) {
                                int n13 = this.d_tileArrays[15][n11];
                                n10 = this.d_tileArrays[16][n11];
                                for (n9 = 0; n9 < 5; ++n9) {
                                    byArray[i + (j - n9 - 1) * n] = n8 = n9 == 3 ? n13 : n10;
                                }
                                n7 = n10;
                                n9 = i + (j - 5 - 1) * n;
                                n8 = byArray[n9 - 1];
                                byArray[n9] = n8 == 52 || ArrayHandler.indexOf(n8, this.d_tileArrays[14]) != -1 ? 56 : 52;
                                byArray[i + (j - 5 - 0) * n] = this.d_tileArrays[14][n11];
                                if (byArray[--n9] == 52) {
                                    byArray[n9] = 48;
                                }
                                if ((n11 = ArrayHandler.indexOf((int)by3, byArray7)) != -1) {
                                    by3 = this.d_tileArrays[18][n11];
                                } else {
                                    n11 = ArrayHandler.indexOf((int)by3, byArray9);
                                    if (n11 != -1) {
                                        by3 = byArray5[n11];
                                    }
                                }
                                bl = true;
                            } else if (n7 == -1) {
                                n7 = 56;
                            }
                        } else {
                            int n14;
                            int n15;
                            int n16;
                            byte[] byArray10 = this.d_tileArrays[23];
                            if (n3 == 3 || n3 == 4) {
                                n10 = Main.rand(0, byArray3.length - 1);
                                by = byArray3[n10];
                            }
                            n10 = -1;
                            n9 = byArray[i + 1 + j * n];
                            n10 = ArrayHandler.indexOf(n9, byArray8);
                            if (n10 != -1) {
                                if (!bl) {
                                    n10 = 0;
                                    n8 = this.d_tileArrays[29][n10];
                                    n16 = this.d_tileArrays[28][n10];
                                    for (n15 = 0; n15 < 5; ++n15) {
                                        byArray[i + (j - n15 - 1) * n] = n14 = n15 == 4 ? n8 : n16;
                                    }
                                    n7 = this.d_tileArrays[27][n10];
                                    n15 = i + (j - 1 - 5) * n;
                                    byArray[n15] = this.d_tileArrays[21][n10];
                                    bl = true;
                                } else if (n7 == -1) {
                                    n7 = this.d_tileArrays[21][0];
                                }
                                if (by3 == -1) {
                                    by3 = this.d_tileArrays[22][0];
                                }
                            }
                            n8 = -1;
                            n16 = byArray[i - 1 + j * n];
                            if (ArrayHandler.indexOf(n16, byArray9) != -1) {
                                if (n7 == -1) {
                                    n15 = byArray[i - 1 + (j + 1) * n];
                                    n14 = ArrayHandler.indexOf(n15, byArray6);
                                    n7 = byArray10[n14];
                                    by3 = this.d_tileArrays[24][n14];
                                }
                            } else {
                                n8 = ArrayHandler.indexOf(n16, byArray5);
                                if (n8 != -1) {
                                    if (!bl) {
                                        int n17;
                                        n8 = 0;
                                        n15 = this.d_tileArrays[32][n8];
                                        n14 = this.d_tileArrays[31][n8];
                                        for (n17 = 0; n17 < 5; ++n17) {
                                            int n18;
                                            byArray[i + (j - n17 - 1) * n] = n18 = n17 == 4 ? n15 : n14;
                                        }
                                        n7 = this.d_tileArrays[30][n8];
                                        n17 = i + (j - 1 - 5) * n;
                                        byArray[n17] = byArray10[n8];
                                        bl = true;
                                        if (byArray[n17 -= n + 1] == 52) {
                                            byArray[n17] = 56;
                                        }
                                    } else if (n7 == -1) {
                                        n7 = byArray10[n8];
                                    }
                                    if (by3 == -1) {
                                        by3 = this.d_tileArrays[24][n8];
                                    }
                                }
                            }
                        }
                    }
                }
                byArray2[n5] = by;
                byArray2[n6] = by2;
                byArray[n5] = n7;
                byArray[n6] = by3;
            }
        }
    }

    private void initAttributesHouse() {
        int n;
        TileMap tileMap = this.m_tileMapWalls;
        byte[] byArray = tileMap.getTileMapData();
        int n2 = tileMap.getWidth();
        int n3 = tileMap.getHeight();
        byte[] byArray2 = this.m_attributesLayer;
        for (n = 0; n < this.m_attributesLayer.length; ++n) {
            if ((byArray2[n] & 0x80) == 0) continue;
            int n4 = n;
            byArray2[n4] = (byte)(byArray2[n4] | 0x40);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                byte by = byArray[n + i * n2];
                if (n != 0 && n != n2 - 1 && i != 0 && i != n3 - 1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[10]) == -1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[16]) == -1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[30]) == -1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[31]) == -1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[32]) == -1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[7]) == -1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[9]) == -1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[8]) == -1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[13]) == -1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[15]) == -1 && ArrayHandler.indexOf((int)by, this.d_tileArrays[14]) == -1) continue;
                int n5 = tileMap.coordTileToWorldX(n);
                int n6 = tileMap.coordTileToWorldY(i);
                int n7 = this.coordScreenToWorldX(n5, n6);
                int n8 = this.coordScreenToWorldZ(n5, n6);
                int n9 = this.coordWorldToWorldTileX(n7);
                int n10 = this.coordWorldToWorldTileZ(n8);
                this.setAttribute(n9, n10, 255, 128);
            }
        }
    }

    private void initAttributesMacromap() {
        int n;
        byte by;
        int n2;
        TileMap tileMap = this.m_tileMap;
        byte[] byArray = tileMap.getTileMapData();
        int n3 = tileMap.getWidth();
        int n4 = tileMap.getHeight();
        byte[] byArray2 = this.d_tileArrays[33];
        ArrayHandler.fillArray(this.m_attributesLayer, 128);
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                by = byArray[i + n2 * n3];
                if (ArrayHandler.indexOf((int)by, byArray2) == -1) continue;
                n = tileMap.coordTileToWorldX(i);
                int n5 = tileMap.coordTileToWorldY(n2);
                int n6 = this.coordScreenToWorldX(n, n5);
                int n7 = this.coordScreenToWorldZ(n, n5);
                int n8 = this.coordWorldToWorldTileX(n6);
                int n9 = this.coordWorldToWorldTileZ(n7);
                this.setAttribute(n8, n9, -129, 32);
                this.setAttribute(n8 + 1, n9, 255, 16);
                this.setAttribute(n8 - 1, n9, 255, 16);
                this.setAttribute(n8, n9 + 1, 255, 16);
                this.setAttribute(n8, n9 - 1, 255, 16);
            }
        }
        byte[] byArray3 = this.m_attributesLayer;
        for (n2 = 0; n2 < byArray3.length; ++n2) {
            by = byArray3[n2];
            n = 255;
            if ((by & 0x20) != 0) {
                n &= 0xFFFFFFEF;
            }
            if ((by & 0x10) != 0) {
                n &= 0xFFFFFF7F;
            }
            byArray3[n2] = (byte)(by & n);
        }
    }

    private void initAttributesZoomMap(int n) {
        TileMap tileMap = this.m_tileMap;
        byte[] byArray = tileMap.getTileMapData();
        int n2 = tileMap.getWidth();
        int n3 = tileMap.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                boolean bl;
                byte by = byArray[i + j * n2];
                boolean bl2 = bl = ArrayHandler.indexOf((int)by, this.d_tileArrays[34]) != -1;
                if (i != 0 && i != n2 - 1 && j != 0 && j != n3 - 1 && !bl) continue;
                int n4 = i;
                if (!bl && n4 == n2 - 1) {
                    ++n4;
                }
                int n5 = tileMap.coordTileToWorldX(n4);
                int n6 = tileMap.coordTileToWorldY(j);
                int n7 = this.coordScreenToWorldX(n5, n6);
                int n8 = this.coordScreenToWorldZ(n5, n6);
                int n9 = this.coordWorldToWorldTileX(n7);
                int n10 = this.coordWorldToWorldTileZ(n8);
                this.setAttribute(n9, n10, 255, 128);
            }
        }
    }

    private void objectsZSort() {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        boolean bl = false;
        for (int i = 0; i < mapObjectArray.length; ++i) {
            for (int j = 1; j < mapObjectArray.length; ++j) {
                int n;
                MapObject mapObject = mapObjectArray[j];
                MapObject mapObject2 = mapObjectArray[j - 1];
                int n2 = this.coordWorldToScreenPixelsX(mapObject.getPosX(), mapObject.getPosZ());
                if (n2 < (n = this.coordWorldToScreenPixelsX(mapObject2.getPosX(), mapObject2.getPosZ()))) {
                    if (mapObject.getZSortOrderRight() >= mapObject2.getZSortOrderLeft()) continue;
                    mapObjectArray[j - 1] = mapObject;
                    mapObjectArray[j] = mapObject2;
                    bl = true;
                    continue;
                }
                if (mapObject.getZSortOrderLeft() >= mapObject2.getZSortOrderRight()) continue;
                mapObjectArray[j - 1] = mapObject;
                mapObjectArray[j] = mapObject2;
                bl = true;
            }
            if (!bl) break;
            bl = false;
        }
    }

    private void objectsCheckInView2D() {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n = this.m_viewportX - 50;
        int n2 = this.m_viewportY - 20;
        int n3 = this.m_viewportX + this.m_viewportWidth + 50;
        int n4 = this.m_viewportY + this.m_viewportHeight + 60;
        int n5 = this.getCameraPixelX();
        int n6 = this.getCameraPixelY();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[i];
            int n7 = n5 + this.coordWorldToScreenPixelsX(mapObject.getPosX(), mapObject.getPosZ());
            int n8 = n6 + this.coordWorldToScreenPixelsY(mapObject.getPosX(), mapObject.getPosZ());
            if ((this.d_objectFlags[mapObjectArray[i].getType()] & 0x80) > 0) {
                mapObject.setInView(true);
                continue;
            }
            mapObject.setInView(n7 >= n && n7 <= n3 && n8 >= n2 && n8 <= n4);
        }
    }

    private void renderObjects2D() {
        this.objectsZSort();
        this.objectsCheckInView2D();
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n = mapObjectArray.length;
        for (int i = 0; i < n; ++i) {
            MapObject mapObject = mapObjectArray[i];
            if (mapObject == null) {
                return;
            }
            if (mapObject.isInView() && !mapObject.getRuntimeFlag(8192)) {
                mapObject.render2D();
            }
            if (!Debug.RENDER_OBJECT_INFO) continue;
            int n2 = this.getCameraPixelX() + this.coordWorldToScreenPixelsX(mapObject.getPosX(), mapObject.getPosZ());
            int n3 = this.getCameraPixelY() + this.coordWorldToScreenPixelsY(mapObject.getPosX(), mapObject.getPosZ());
            AnimationManager.TextHandler_drawRawString(Event.Ea_intToSdkstring(i), 0, n2, n3, 33);
            int n4 = mapObject.getType() == 0 ? 0xFF0000 : (mapObject.getType() == 1 ? 0xFFFF00 : 65280);
            ArrayOptimizer.PMGraphics_setColor(0);
            ArrayOptimizer.PMGraphics_fillRect(n2 - 2 + 1, n3 - 2 + 1, 5, 5);
            ArrayOptimizer.PMGraphics_setColor(n4);
            ArrayOptimizer.PMGraphics_fillRect(n2 - 2, n3 - 2, 5, 5);
            AnimationManager.TextHandler_drawString(mapObject.getTypeString(), 0, n2, n3 + 3, 17);
            SDKString sDKString = mapObject.occupiedIsEmpty() ? new SDKString(" ") : (mapObject.occupiedIsAnyAvailable() ? new SDKString("A") : new SDKString("O"));
            AnimationManager.TextHandler_drawRawString(sDKString, 0, n2, n3 + 13, 17);
        }
    }

    public int getObjectAnimSetId(int n, int n2) {
        if (n2 < this.d_objectAnimSetIds[n].length) {
            return this.d_objectAnimSetIds[n][n2];
        }
        return 0;
    }

    public int getObjectInterestPointCount(int n) {
        return this.d_objectInterestPointXs[n * 5];
    }

    public int getObjectInterestPointX(int n, int n2, int n3) {
        int n4 = this.d_objectInterestPointXs[n * 5 + n2 + 1];
        int n5 = this.d_objectInterestPointYs[n * 5 + n2 + 1];
        switch (n3) {
            default: {
                break;
            }
            case 1: {
                n4 = n5;
                break;
            }
            case 2: {
                n4 = 1 - n4 - Math.max(this.d_objectFootprintHeights[n], 1);
                break;
            }
            case 3: {
                n4 = 1 - Math.max(this.d_objectFootprintWidths[n], 1) - n5;
            }
        }
        return n4;
    }

    public int getObjectInterestPointZ(int n, int n2, int n3) {
        int n4 = this.d_objectInterestPointXs[n * 5 + n2 + 1];
        int n5 = this.d_objectInterestPointYs[n * 5 + n2 + 1];
        switch (n3) {
            default: {
                break;
            }
            case 1: {
                n5 = n4;
                break;
            }
            case 2: {
                n5 = 1 - n5 - Math.max(this.d_objectFootprintWidths[n], 1);
                break;
            }
            case 3: {
                n5 = 1 - Math.max(this.d_objectFootprintHeights[n], 1) - n4;
            }
        }
        return n5;
    }

    public int getObjectFirstAction(int n) {
        return this.d_objectActions[this.d_objectActionOffsets[n]];
    }

    public int getObjectActions(int n, short[] sArray) {
        short s = this.d_objectActionOffsets[n];
        int n2 = this.d_objectActionOffsets[n + 1] - s;
        for (int i = 0; i < n2; ++i) {
            sArray[i] = this.d_objectActions[s + i];
        }
        return n2;
    }

    public int getObjectQuickLinkIndex(int n) {
        int[] nArray = this.d_objectFlags;
        if ((nArray[n] & 0x20) == 0) {
            return -1;
        }
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & 0x20) == 0) continue;
            if (i == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getAnim(int n, int n2) {
        int n3 = (n << 2) + n2;
        return this.d_animSetIndexes[n3];
    }

    public int mapSubAppearance(int n, boolean bl) {
        if (n < 0) {
            int n2 = Main.randPercent();
            if (n == -2) {
                if (!bl) {
                    n2 = n2 * 75 / 100;
                }
                n = n2 < 25 ? 6 : (n2 < 50 ? 7 : (n2 < 75 ? 8 : 9));
            } else if (n == -3) {
                n = n2 < 50 ? 10 : 11;
            } else if (n == -4) {
                n = n2 < 50 ? 13 : 14;
            }
        }
        return n;
    }

    public int getSubAppearanceAnimSet(int n, int n2, boolean bl) {
        short[] sArray = this.d_appearances[n];
        n2 <<= 1;
        if (bl) {
            ++n2;
        }
        if (n2 < sArray.length) {
            return sArray[n2];
        }
        return bl ? 0 : sArray[0];
    }

    public boolean isFurnitureAvailable(int n) {
        if (StateInGame.isHouseMode()) {
            int n2 = 0x78000000;
            return (this.d_objectFlags[n] & n2) == 0;
        }
        if (StateInGame.isZoomMapMode()) {
            switch (Main.getNextZoomMapId()) {
                case 79: {
                    return (this.d_objectFlags[n] & 0x8000000) != 0;
                }
                case 80: {
                    return (this.d_objectFlags[n] & 0x10000000) != 0;
                }
                case 81: {
                    return (this.d_objectFlags[n] & 0x20000000) != 0;
                }
                case 82: {
                    return (this.d_objectFlags[n] & 0x40000000) != 0;
                }
            }
            return false;
        }
        return false;
    }

    public int getFurnitureNthCount() {
        this.d_objectBuyPricesLocation = new short[this.d_objectBuyPrices.length];
        System.arraycopy(this.d_objectBuyPrices, 0, this.d_objectBuyPricesLocation, 0, this.d_objectBuyPrices.length);
        if (StateInGame.isHouseMode()) {
            int n = 0x78000000;
            for (int i = 0; i < this.d_objectBuyPrices.length; ++i) {
                if (this.d_objectBuyPrices[i] == -1 || (this.d_objectFlags[i] & n) == 0) continue;
                this.d_objectBuyPricesLocation[i] = -1;
            }
        } else {
            int n;
            switch (Main.getNextZoomMapId()) {
                case 79: {
                    n = 0x8000000;
                    break;
                }
                case 80: {
                    n = 0x10000000;
                    break;
                }
                case 81: {
                    n = 0x20000000;
                    break;
                }
                case 82: {
                    n = 0x40000000;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            for (int i = 0; i < this.d_objectBuyPrices.length; ++i) {
                if (this.d_objectBuyPrices[i] == -1 || (this.d_objectFlags[i] & n) != 0) continue;
                this.d_objectBuyPricesLocation[i] = -1;
            }
        }
        return this.d_objectBuyPricesLocation.length - ArrayHandler.countOf(-1, this.d_objectBuyPricesLocation);
    }

    public int getFurnitureNthItem(int n) {
        return ArrayHandler.indexOfNthElement(n, this.d_objectBuyPricesLocation, -1);
    }

    public int getItemBuyPrice(int n) {
        int n2 = Main.m_simData.getCareerLevelFlagsPlayer();
        int n3 = 0;
        if ((n2 & 1) > 0) {
            n3 = 16384;
        }
        if ((n2 & 2) > 0) {
            n3 = 32768;
        }
        if ((n2 & 4) > 0) {
            n3 = 65536;
        }
        if ((n2 & 8) > 0) {
            n3 = 131072;
        }
        if ((StateInGame.m_shoppingFlagLatest & n3) > 0) {
            return this.d_itemBuyPrices[n] * 80 / 100;
        }
        return this.d_itemBuyPrices[n];
    }

    public int getShopFlags(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 115: {
                return 8192;
            }
            case 131: {
                return 65536;
            }
            case 123: {
                return 16384;
            }
            case 145: {
                return 32768;
            }
            case 158: 
        }
        return 131072;
    }

    public int getItemNthCount(int n) {
        return ArrayHandler.countOfFlags(this.getShopFlags(n), this.d_itemFlags);
    }

    public int getItemNthItem(int n, int n2) {
        return ArrayHandler.indexOfNthElementFlags(n2, this.d_itemFlags, this.getShopFlags(n));
    }

    public int getRecipeReplenishes(int n) {
        return Camera.MathExt_Fmul(this.d_recipeReplenishes[n] << 16, 65536);
    }

    public int getRecipeByName(int n) {
        for (int i = 0; i < this.d_recipeItems.length; ++i) {
            if (this.d_itemDescStringIds[this.d_recipeItems[i]] != n) continue;
            return i;
        }
        return -1;
    }

    public boolean areThereAnyRecipesLeftToBuy() {
        for (int i = 0; i < this.d_itemFlags.length; ++i) {
            if ((this.d_itemFlags[i] & 0x400) <= 0 || Main.m_simData.getInventoryCount(i) != 0) continue;
            return true;
        }
        return false;
    }

    private void initColors() {
        int n;
        int n2;
        int n3;
        Cursor.ResourceManager_loadBinaryFile(85);
        int n4 = GameConstants.PMFile_readByte();
        this.d_patches = new int[n4][];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = GameConstants.PMFile_readByte();
            this.d_patches[n3] = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.d_patches[n3][n] = GameConstants.PMFile_readInt();
            }
        }
        n3 = GameConstants.PMFile_readByte();
        this.d_pals = new byte[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            n = GameConstants.PMFile_readByte();
            this.d_pals[n2] = new byte[n];
            for (int i = 0; i < n; ++i) {
                this.d_pals[n2][i] = GameConstants.PMFile_readByte();
            }
        }
        GameConstants.PMFile_closeFile();
    }

    public void patchAdd(int[] nArray, int[] nArray2, int n, int n2) {
        if (n < 0 || n2 < 0) {
            return;
        }
        int[] nArray3 = this.d_patches[n];
        int[] nArray4 = this.d_patches[n2];
        int n3 = -1;
        int n4 = nArray.length;
        for (int i = 0; i < n4; ++i) {
            if (nArray[i] != 0xFF00FF) continue;
            n3 = i;
            break;
        }
        System.arraycopy(nArray3, 0, nArray, n3, nArray3.length);
        System.arraycopy(nArray4, 0, nArray2, n3, nArray4.length);
    }

    public int[] getPatch(int n) {
        return this.d_patches[n];
    }

    public byte[] getPal(int n) {
        return this.d_pals[n];
    }

    public void getSimPatches(int n, int[] nArray, int[] nArray2) {
        byte[] byArray = Main.m_simData.d_simAttributes[n >= 0 ? n : 0];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray2[n2] = 0xFF00FF;
            nArray[n2] = 0xFF00FF;
        }
        this.patchAdd(nArray, nArray2, 16, this.d_pals[1][byArray[3]]);
        this.patchAdd(nArray, nArray2, 39, this.d_pals[2][byArray[4]]);
        this.patchAdd(nArray, nArray2, 25, this.d_pals[3][byArray[5]]);
        this.patchAdd(nArray, nArray2, 35, this.d_pals[4][byArray[6]]);
        this.patchAdd(nArray, nArray2, 36, this.d_pals[5][byArray[7]]);
        this.patchAdd(nArray, nArray2, 37, this.d_pals[6][byArray[8]]);
        this.patchAdd(nArray, nArray2, 38, this.d_pals[7][byArray[9]]);
        this.patchAdd(nArray, nArray2, 5, this.d_pals[0][byArray[1]]);
    }

    public void pathClearAvoidTiles() {
        this.m_pathNumAvoidTiles = 0;
    }

    public void pathAddAvoidTile(int n, int n2) {
        if (this.m_pathNumAvoidTiles < 10) {
            int n3 = this.m_pathNumAvoidTiles << 1;
            this.m_pathAvoidTiles[n3] = n;
            this.m_pathAvoidTiles[n3 + 1] = n2;
            ++this.m_pathNumAvoidTiles;
        }
    }

    public int pathFind(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        this.pathReset();
        this.m_pathFlags = n5;
        this.m_pathStartX = this.coordWorldToWorldTileX(n);
        this.m_pathStartY = this.coordWorldToWorldTileZ(n2);
        this.m_pathDestX = this.coordWorldToWorldTileX(n3);
        this.m_pathDestY = this.coordWorldToWorldTileZ(n4);
        if (!this.isWorldTileWalkable(this.m_pathDestX, this.m_pathDestY)) {
            return 0;
        }
        this.m_pathOffsetX = this.m_pathStartX + this.m_pathDestX - 46 >> 1;
        this.m_pathOffsetY = this.m_pathStartY + this.m_pathDestY - 46 >> 1;
        int n12 = this.m_pathStartX - this.m_pathOffsetX;
        int n13 = this.m_pathStartY - this.m_pathOffsetY;
        if (n12 < 0 || n13 < 0 || n12 >= 46 || n13 >= 46) {
            return 0;
        }
        n12 = this.m_pathDestX - this.m_pathOffsetX;
        n13 = this.m_pathDestY - this.m_pathOffsetY;
        if (n12 < 0 || n13 < 0 || n12 >= 46 || n13 >= 46) {
            return 0;
        }
        this.pathAddToOpenList(this.m_pathStartX - this.m_pathOffsetX, this.m_pathStartY - this.m_pathOffsetY);
        n12 = 0;
        while (n12 == 0) {
            n13 = this.pathFindLowestF();
            if (n13 == -1) {
                return 0;
            }
            n11 = this.m_pathOpenList[n13] & 0xFF;
            n10 = (this.m_pathOpenList[n13] & 0xFF00) >> 8;
            for (n9 = 0; n9 < 4; ++n9) {
                n8 = n11 + (n9 == 0 ? -1 : (n9 == 1 ? 1 : 0));
                if (this.pathIsClosed(n8, n7 = n10 + (n9 == 2 ? -1 : (n9 == 3 ? 1 : 0)))) continue;
                if (this.pathAddToOpenList(n8, n7)) {
                    this.pathSetParent(n8, n7, n11, n10);
                    this.pathCalculateGCost(n8, n7);
                    this.pathCalculateHCost(n8, n7);
                    this.pathCalculateFCost(n8, n7);
                    continue;
                }
                if (!this.pathBetterGCost(n8, n7, n11, n10)) continue;
                this.pathSetParent(n8, n7, n11, n10);
                this.pathCalculateGCost(n8, n7);
                this.pathCalculateFCost(n8, n7);
            }
            this.pathSwitchToClosedList(n13);
            if (n11 != this.m_pathDestX - this.m_pathOffsetX || n10 != this.m_pathDestY - this.m_pathOffsetY) continue;
            n12 = 1;
        }
        n13 = Integer.MAX_VALUE;
        n11 = Integer.MAX_VALUE;
        n10 = this.m_pathDestX - this.m_pathOffsetX;
        n9 = this.m_pathDestY - this.m_pathOffsetY;
        n8 = this.m_pathStartX - this.m_pathOffsetX;
        n7 = this.m_pathStartY - this.m_pathOffsetY;
        int n14 = 0;
        while (!(n10 < 0 || n9 < 0 || n10 >= 46 || n9 >= 46 || n10 == n8 && n9 == n7 || n13 == n10 && n11 == n9 || (n6 = this.m_pathParentArray[n10][n9]) == -1)) {
            this.m_pathList[n14] = (short)(n10 | n9 << 8);
            ++n14;
            n13 = n10;
            n11 = n9;
            n10 = n6 & 0xFF;
            n9 = (n6 & 0xFF00) >> 8;
        }
        for (n6 = 0; n6 < n14; ++n6) {
            int n15 = n14 - n6 - 1;
            int n16 = (this.m_pathList[n15] & 0xFF) + this.m_pathOffsetX;
            int n17 = ((this.m_pathList[n15] & 0xFF00) >> 8) + this.m_pathOffsetY;
            nArray[(n6 << 1) + 0] = this.coordWorldTileToWorldCenterX(n16);
            nArray[(n6 << 1) + 1] = this.coordWorldTileToWorldCenterZ(n17);
        }
        return n14 * 2;
    }

    private void pathInit() {
        this.m_pathOpenList = new short[2116];
        this.m_pathOpenCount = 0;
        this.m_pathClosedLookup = new long[46];
        this.m_pathParentArray = new short[46][46];
        this.m_pathGCost = new int[46][46];
        this.m_pathFCost = new int[46][46];
        this.m_pathHCost = new int[46][46];
        this.m_pathList = new short[529];
        this.m_pathNumAvoidTiles = 0;
        this.m_pathAvoidTiles = new int[20];
    }

    private boolean pathAddToOpenList(int n, int n2) {
        short s = (short)(n | n2 << 8);
        for (int i = 0; i < this.m_pathOpenCount; ++i) {
            if (this.m_pathOpenList[i] != s) continue;
            return false;
        }
        this.m_pathOpenList[this.m_pathOpenCount] = s;
        ++this.m_pathOpenCount;
        return true;
    }

    private void pathSwitchToClosedList(int n) {
        int n2 = this.m_pathOpenList[n] & 0xFF;
        int n3 = (this.m_pathOpenList[n] & 0xFF00) >> 8;
        int n4 = n2;
        this.m_pathClosedLookup[n4] = this.m_pathClosedLookup[n4] | 1L << n3;
        this.m_pathOpenList[n] = this.m_pathOpenList[this.m_pathOpenCount - 1];
        --this.m_pathOpenCount;
    }

    private void pathSetParent(int n, int n2, int n3, int n4) {
        this.m_pathParentArray[n][n2] = (short)(n3 | n4 << 8);
    }

    private int pathTileGCost(int n, int n2) {
        if ((this.m_pathFlags & 6) != 0) {
            int n3 = n + this.m_pathOffsetX;
            int n4 = n2 + this.m_pathOffsetY;
            int n5 = this.getAttribute(n3, n4);
            if ((n5 & 0x20) != 0) {
                return (this.m_pathFlags & 2) != 0 ? 5 : 50;
            }
            if ((n5 & 0x10) != 0) {
                return 10;
            }
            return 15;
        }
        return 15;
    }

    private void pathCalculateGCost(int n, int n2) {
        int n3 = this.m_pathParentArray[n][n2] & 0xFF;
        int n4 = (this.m_pathParentArray[n][n2] & 0xFF00) >> 8;
        int n5 = this.m_pathGCost[n3][n4];
        int n6 = 0;
        if ((this.m_pathFlags & 8) != 0) {
            int n7 = this.m_pathParentArray[n3][n4] & 0xFF;
            int n8 = (this.m_pathParentArray[n3][n4] & 0xFF00) >> 8;
            if (!(n7 == n3 && n3 == n || n8 == n4 && n4 == n2)) {
                n6 = 20;
            }
        }
        this.m_pathGCost[n][n2] = n5 + this.pathTileGCost(n, n2) + n6;
    }

    private boolean pathBetterGCost(int n, int n2, int n3, int n4) {
        int n5 = this.m_pathGCost[n][n2];
        int n6 = this.m_pathGCost[n3][n4];
        return (n6 += this.pathTileGCost(n, n2)) < n5;
    }

    private void pathCalculateHCost(int n, int n2) {
        int n3 = this.m_pathDestX - this.m_pathOffsetX - n;
        int n4 = this.m_pathDestY - this.m_pathOffsetY - n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n4 < 0) {
            n4 = -n4;
        }
        int n5 = 0;
        if ((this.m_pathFlags & 1) != 0) {
            for (int i = 0; i < this.m_pathNumAvoidTiles; ++i) {
                int n6 = i << 1;
                if (n + this.m_pathOffsetX != this.m_pathAvoidTiles[n6] || n2 + this.m_pathOffsetY != this.m_pathAvoidTiles[n6 + 1]) continue;
                n5 = 250;
                break;
            }
        }
        this.m_pathHCost[n][n2] = n3 * 24 + n4 * 24 + n5;
    }

    private void pathCalculateFCost(int n, int n2) {
        this.m_pathFCost[n][n2] = this.m_pathHCost[n][n2] + this.m_pathGCost[n][n2];
    }

    private int pathFindLowestF() {
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.m_pathOpenCount; ++i) {
            int n3 = this.m_pathOpenList[i] & 0xFF;
            int n4 = (this.m_pathOpenList[i] & 0xFF00) >> 8;
            if (n2 <= this.m_pathFCost[n3][n4]) continue;
            n2 = this.m_pathFCost[n3][n4];
            n = i;
        }
        return n;
    }

    private boolean pathIsWalkable(int n, int n2) {
        int n3 = n + this.m_pathOffsetX;
        int n4 = n2 + this.m_pathOffsetY;
        return this.isWorldTileWalkable(n3, n4);
    }

    private boolean pathIsClosed(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= 46 || n2 >= 46) {
            return true;
        }
        if (!this.pathIsWalkable(n, n2)) {
            return true;
        }
        return (this.m_pathClosedLookup[n] & 1L << n2) > 0L;
    }

    public void pathReset() {
        this.m_pathOpenCount = 0;
        for (int i = 0; i < 46; ++i) {
            for (int j = 0; j < 46; ++j) {
                this.m_pathParentArray[i][j] = 0;
                this.m_pathGCost[i][j] = 0;
                this.m_pathFCost[i][j] = 0;
                this.m_pathHCost[i][j] = 0;
            }
            this.m_pathClosedLookup[i] = 0L;
        }
    }
}

