/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Camera;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.SimData;
import dk.progressivemedia.skeleton.SimWorld;
import dk.progressivemedia.skeleton.state.StateInGame;

public class Main {
    public static boolean isInitDone = false;
    public static final int[] INTERACTIVITIES_LIST = new int[]{120, 127, 151, 149, 136, 134, 142, 164, 163};
    public static int m_musicID = -1;
    public static int s_debugMemoryCount = 0;
    public static int initCounter = 0;
    public static boolean externalDrawing;
    public static long timeLastDrawnExternal;
    public static int m_rightCommandID;
    public static int m_leftCommandID;
    public static long m_leftSoftkeyTime;
    public static long m_rightSoftkeyTime;
    public static int[] d_images;
    public static int m_loadImageIndex;
    public static SimData m_simData;
    public static SimWorld m_simWorld;
    public static int m_nextHouseId;
    public static int m_nextZoomMapId;
    public static int m_nextZoomMapIdPREV;
    public static short[][] d_uiPanels;
    public static int m_encounterPlayerXF;
    public static int m_encounterPlayerZF;
    public static int m_encounterNPCXF;
    public static int m_encounterNPCZF;
    public static int m_encounterNPCId;
    public static final short[] RESPONSE_ANIMS;

    public static void startMusic(int n) {
        GlobalConstants.PMDebug_println(2, "Main.startMusic( {0} );", n);
        if (!PMAudio.isEnabled) {
            return;
        }
        if (n == -1) {
            PMAudio.stopAll();
            PMAudio.update();
        }
        if (m_musicID != n && n != -1) {
            if (m_musicID != -1) {
                PMAudio.stop(m_musicID);
            }
            PMAudio.play(n, -1);
        }
        m_musicID = n;
    }

    public static void loadSounds() {
        PMAudio.initAudio(16);
        PMAudio.loadRegOnly(2, "menu", 1, 10864);
        PMAudio.loadRegOnly(8, "male_0", 6, 19449);
        PMAudio.loadRegOnly(9, "female_0", 6, 12325);
        PMAudio.loadRegOnly(0, "ui_toggle", 1, 525);
        PMAudio.loadRegOnly(3, "district_art", 1, 4015);
        PMAudio.loadRegOnly(4, "district_fashion", 1, 4817);
        PMAudio.loadRegOnly(5, "district_festival", 1, 5120);
        PMAudio.loadRegOnly(6, "district_sports", 1, 6606);
        PMAudio.loadRegOnly(7, "townmap", 1, 1323);
        PMAudio.loadRegOnly(13, "awesome", 1, 1422);
        PMAudio.loadRegOnly(14, "career", 1, 1367);
        PMAudio.loadRegOnly(15, "romantic", 1, 1000);
        PMAudio.loadRegOnly(1, "goalcomplete", 1, 873);
        PMAudio.loadRegOnly(10, "skillpoint", 1, 935);
        PMAudio.loadRegOnly(11, "minigame_win", 1, 522);
        PMAudio.loadRegOnly(12, "minigame_lose", 1, 506);
    }

    public static void init() {
        switch (initCounter) {
            default: {
                GlobalConstants.PMDebug_println(0, "ERROR IN Main.init()");
                break;
            }
            case 0: {
                GlobalConstants.PMStateManager_set(3, 0);
                Intro.LoadingScreen_drawBasicBackground();
                Intro.LoadingScreen_initProgressBar(13);
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 1: {
                Main.preMenuInit();
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 2: {
                Event.PostEffects_init();
                ArrayOptimizer.Touch_init();
                Cursor.ResourceManager_init();
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 3: {
                Main.loadSounds();
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 4: {
                if (AnimationManager.loadSubimageFile()) {
                    ++initCounter;
                    Intro.LoadingScreen_currentSubStep = 0;
                } else {
                    --Intro.LoadingScreen_currentStep;
                    ++Intro.LoadingScreen_currentSubStep;
                }
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                break;
            }
            case 5: {
                if (AnimationManager.loadAnimFile()) {
                    ++initCounter;
                } else {
                    --Intro.LoadingScreen_currentStep;
                    ++Intro.LoadingScreen_currentSubStep;
                }
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                break;
            }
            case 6: {
                AnimationManager.loadColorsFile();
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 7: {
                Main.loadGameData(0);
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 8: {
                Main.loadGameData(1);
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 9: {
                Main.loadGameData(2);
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 10: {
                for (int i = 0; i < 3; ++i) {
                    ArrayHandler.Rms_simNameStrings[i] = new SDKString(8, 0);
                    ArrayHandler.Rms_clearSimName(i);
                }
                Intro.StateMenu_casNameString = new SDKString(8, 0);
                Intro.StateMenu_casNameString.setLength(1);
                Intro.StateMenu_casNameString.setCharAt(0, Intro.StateMenu_SELECT_LETTERS[0]);
                ArrayHandler.Rms_loadRMSAppSettings();
                AnimationManager.TextHandler_initWraps();
                AnimationManager.TextHandler_loadTextSDKStrings();
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 11: {
                int n;
                if (AnimationManager.TextHandler_m_sdkStringInstances == null) {
                    AnimationManager.TextHandler_m_sdkStringInstances = new SDKString[10];
                    for (n = 0; n < 10; ++n) {
                        AnimationManager.TextHandler_m_sdkStringInstances[n] = new SDKString();
                    }
                }
                AnimationManager.TextHandler_m_tempStringBuffers = new SDKString[25];
                for (n = 0; n < 25; ++n) {
                    AnimationManager.TextHandler_m_tempStringBuffers[n] = new SDKString(100, 0);
                }
                Main.loadAllImages(1);
                GlobalConstants.PMDebug_println("loaded AppEngine images");
                ArrayHandler.Rms_resetRMSGameData();
                ArrayHandler.Rms_loadRMSGameData();
                GlobalConstants.PMDebug_println("loaded RMS");
                Intro.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 12: {
                Intro.StateMenu_initSharedMenus();
                isInitDone = true;
                int n = 5;
                if (ArrayHandler.Rms_GSLangIndex == -1) {
                    n = 4;
                }
                Intro.LoadingScreen_init();
                GlobalConstants.PMStateManager_set(1, n);
                break;
            }
        }
    }

    public static void preFlush() {
    }

    public static void preMenuInit() {
        Debug.PMRandom_init(0);
        GameConstants.PMFile_initBFC();
        SDKUtils.setGraphics(ArrayOptimizer.PMGraphics_g);
    }

    public static void externalEvent() {
        if (!isInitDone) {
            Event.PMSystem_externalPause = false;
        }
        AnimationManager.TextHandler_resetScrollers();
        externalDrawing = false;
        Main.startMusic(-1);
        timeLastDrawnExternal = Intro.PMTimer_tick();
    }

    public static void drawExternal() {
        if (!externalDrawing) {
            Main.setVarsOnExternal();
        }
        externalDrawing = true;
        AnimationManager.TextHandler_updateScrollers((int)(Intro.PMTimer_tick() - timeLastDrawnExternal));
        AnimationManager.setColor(48);
        ArrayOptimizer.PMGraphics_fillRect(0, 0, 240, 260);
        int n = AnimationManager.getAnimFrameWidth(753, 0);
        for (int i = 0; i < 240; i += n) {
            AnimationManager.drawAnimFrame(753, 0, i, 260);
        }
        short[] sArray = new short[6];
        Main.menuClear(sArray, 624);
        Main.menuAppendItem(sArray, 644);
        Debug.UserInterface_drawGenericMenu(sArray, 1);
        int n2 = m_leftCommandID;
        int n3 = m_rightCommandID;
        Main.setSoftKeys(0, 8);
        m_rightSoftkeyTime = 400L;
        m_leftSoftkeyTime = 400L;
        Main.renderSoftkeyButtons(0);
        Main.setSoftKeys(n3, n2);
        timeLastDrawnExternal = Intro.PMTimer_tick();
    }

    public static void drawExternalLoading() {
        AnimationManager.TextHandler_updateScrollers((int)(Intro.PMTimer_tick() - timeLastDrawnExternal));
        AnimationManager.setColor(48);
        ArrayOptimizer.PMGraphics_fillRect(0, 0, 240, 260);
        int n = AnimationManager.getAnimFrameWidth(753, 0);
        for (int i = 0; i < 240; i += n) {
            AnimationManager.drawAnimFrame(753, 0, i, 260);
        }
        short[] sArray = new short[6];
        Main.menuClear(sArray, 624);
        Main.menuAppendItem(sArray, 852);
        Debug.UserInterface_drawGenericMenu(sArray, 1);
        timeLastDrawnExternal = Intro.PMTimer_tick();
    }

    public static boolean softPressPos() {
        return ArrayHandler.PMInput_isPressed(2048) && m_leftCommandID != 0;
    }

    public static boolean softPressPos(int n) {
        return ArrayHandler.PMInput_isPressed(2048) && m_leftCommandID == n;
    }

    public static boolean softPressNeg() {
        return ArrayHandler.PMInput_isPressed(4096) && m_rightCommandID != 0 || ArrayHandler.PMInput_isPressed(4);
    }

    public static boolean softPressNeg(int n) {
        return ArrayHandler.PMInput_isPressed(4096) && m_rightCommandID == n;
    }

    public static void setSoftKeys(int n, int n2) {
        GlobalConstants.PMDebug_println(2, "Main.setSoftKeys( {0}, {1} );", n, n2);
        int n3 = n;
        n = n2;
        n2 = n3;
        if (n2 != m_rightCommandID) {
            m_rightCommandID = n2;
            m_rightSoftkeyTime = 0L;
        }
        if (n != m_leftCommandID) {
            m_leftCommandID = n;
            m_leftSoftkeyTime = 0L;
        }
    }

    public static final int getCommandString(int n) {
        if (n == 0) {
            return -1;
        }
        if (n == 1) {
            return 623;
        }
        if (n == 2) {
            return 528;
        }
        if (n == 4) {
            return 143;
        }
        if (n == 8) {
            return 618;
        }
        if (n == 16) {
            return 788;
        }
        if (n == 32) {
            return 261;
        }
        if (n == 64) {
            return 160;
        }
        if (n == 128) {
            return 363;
        }
        if (n == 256) {
            return 945;
        }
        if (n == 512) {
            return 529;
        }
        if (n == 1024) {
            return 457;
        }
        if (n == 2048) {
            return 643;
        }
        if (n == 4096) {
            return 158;
        }
        if (n == 8192) {
            return 791;
        }
        if (n == 16384) {
            return 1;
        }
        if (n == 32768) {
            return 2;
        }
        return -1;
    }

    public static int rand(int n, int n2) {
        int n3 = n2 - n + 1;
        return n + Debug.PMRandom_get() % n3;
    }

    public static int randPercent() {
        return Main.rand(0, 99);
    }

    public static int popupSize(int n, int n2, int n3, long l, long l2) {
        if (l >= l2) {
            return n3;
        }
        if (l < 0L) {
            return n2;
        }
        int n4 = 0;
        switch (n) {
            default: {
                return (int)((long)n2 + l * (long)(n3 - n2) / l2);
            }
            case 2: {
                n4 = Camera.MathExt_smoothstepF(0, (int)l2, (int)l);
                break;
            }
            case 1: {
                int n5 = (int)(l2 >> 1);
                if (l < (long)n5) {
                    int n6 = Camera.MathExt_Fdiv(Camera.MathExt_Fmul((int)l, 102944), n5);
                    n4 = Camera.MathExt_Fmul(Camera.MathExt_Fsin(n6), 72089);
                    break;
                }
                int n7 = Camera.MathExt_Fdiv((int)l - n5, (int)l2 - n5);
                int n8 = Camera.MathExt_Fmul(n7, 617662);
                int n9 = 6554 - Camera.MathExt_Fmul(6554, n7);
                n4 = Camera.MathExt_Fmul(Camera.MathExt_Fcos(n8), n9) + 65536;
                break;
            }
        }
        return n2 + (n4 * (n3 - n2) >> 16);
    }

    public static void updateSoftKeys(int n) {
        if (Event.PostEffects_isFading()) {
            m_leftSoftkeyTime = 0L;
            m_rightSoftkeyTime = 0L;
        } else {
            if (m_leftSoftkeyTime < 400L) {
                m_leftSoftkeyTime += (long)n;
            }
            if (m_rightSoftkeyTime < 400L) {
                m_rightSoftkeyTime += (long)n;
            }
        }
    }

    public static void renderSoftkeyBar() {
        Main.renderSoftkeyBar(0);
    }

    public static void renderSoftkeyBar(int n) {
        int n2 = AnimationManager.getAnimFrameWidth(753, 0);
        for (int i = 0; i < 240; i += n2) {
            AnimationManager.drawAnimFrame(753, 0, i, 260 + n);
        }
        if (!Event.PostEffects_isFading()) {
            Main.renderSoftkeyButtons(n);
        }
    }

    public static void renderSoftkeyButtons(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        SDKString sDKString;
        SDKString sDKString2;
        int n8 = Main.getCommandString(m_leftCommandID);
        int n9 = Main.getCommandString(m_rightCommandID);
        if (n8 >= 0) {
            sDKString2 = AnimationManager.TextHandler_getString(n8);
            sDKString = AnimationManager.TextHandler_clearStringBuffer();
            AnimationManager.TextHandler_appendStringIdToBuffer(1082);
            AnimationManager.TextHandler_appendSDKStringToBuffer(sDKString2);
            sDKString2 = sDKString;
            n7 = Main.popupSize(1, 15, 0, m_leftSoftkeyTime, 400L);
            n6 = Math.max(25, AnimationManager.TextHandler_getStringWidth(sDKString2, 0));
            n5 = 260 + n7 + n;
            n4 = n5 - 7;
            n3 = 11 + n6 - 4 - 0;
            n2 = 11 + n3 >> 1;
            ArrayOptimizer.Touch_lskWidth = n6 + 19;
            AnimationManager.drawAnimFrame(756, 0, n3, n5);
            AnimationManager.drawAnimFrame(754, 0, 11, n5);
            Main.renderSoftKeyJoin(13, n5, n3 - 11 - 4);
            AnimationManager.TextHandler_drawString(sDKString2, 0, n2, n4, 3);
        }
        if (n9 >= 0) {
            sDKString2 = AnimationManager.TextHandler_getString(n9);
            sDKString = AnimationManager.TextHandler_clearStringBuffer();
            AnimationManager.TextHandler_appendStringIdToBuffer(1083);
            AnimationManager.TextHandler_appendSDKStringToBuffer(sDKString2);
            sDKString2 = sDKString;
            n7 = Main.popupSize(1, 15, 0, m_rightSoftkeyTime, 400L);
            n6 = Math.max(25, AnimationManager.TextHandler_getStringWidth(sDKString2, 0));
            n5 = 260 + n7 + n;
            n4 = n5 - 7;
            n3 = 229 - n6 + 4 + 0;
            n2 = n3 + 229 >> 1;
            ArrayOptimizer.Touch_rskWidth = n6 + 19;
            AnimationManager.drawAnimFrame(756, 0, 229, n5);
            AnimationManager.drawAnimFrame(754, 0, n3, n5);
            Main.renderSoftKeyJoin(n3 + 2, n5, 229 - n3 - 4);
            AnimationManager.TextHandler_drawString(sDKString2, 0, n2, n4, 3);
        }
    }

    public static void renderSoftKeyJoin(int n, int n2, int n3) {
        int n4 = ArrayOptimizer.PMGraphics_getClipX();
        int n5 = ArrayOptimizer.PMGraphics_getClipY();
        int n6 = ArrayOptimizer.PMGraphics_getClipWidth();
        int n7 = ArrayOptimizer.PMGraphics_getClipHeight();
        ArrayOptimizer.PMGraphics_setClip(n, n5, n3, n7);
        AnimationManager.drawAnimFrame(755, 0, n, n2);
        ArrayOptimizer.PMGraphics_setClip(n4, n5, n6, n7);
    }

    public static void loadImagesBegin() {
        m_loadImageIndex = 0;
    }

    public static boolean loadImagesNext(int n) {
        return Main.loadImagesNext(n, null, null, 0);
    }

    public static boolean loadImagesNext(int n, int[] nArray, int[] nArray2, int n2) {
        int n3 = d_images.length;
        int n4 = 0;
        int n5 = m_loadImageIndex;
        while (n5 << 1 < n3 && n4 < 3) {
            if ((d_images[(n5 << 1) + 1] & n) != 0) {
                int n6;
                for (n6 = 1; !AnimationManager.loadImage(d_images[n5 << 1], nArray, nArray2, n2) && n6 < 2; ++n6) {
                    Event.PMSystem_forceGC();
                }
                if (n6 >= 2) {
                    GlobalConstants.PMDebug_println(2, "OOM: failed to load image({0})", d_images[n5 << 1]);
                    return true;
                }
                ++n4;
            }
            ++n5;
        }
        m_loadImageIndex = n5;
        return n5 << 1 == n3;
    }

    public static void loadAllImages(int n) {
        Main.loadAllImages(n, null, null, 0);
    }

    public static void loadAllImages(int n, int[] nArray, int[] nArray2, int n2) {
        Main.loadImagesBegin();
        while (!Main.loadImagesNext(n, nArray, nArray2, n2)) {
        }
    }

    public static void unloadAllImages(int n, int n2) {
        int[] nArray = d_images;
        int n3 = 0;
        int n4 = nArray.length;
        while (n3 << 1 < n4) {
            if ((nArray[(n3 << 1) + 1] & n) != 0) {
                int n5 = nArray[n3 << 1];
                if (n2 == -1) {
                    int n6 = 6;
                    while (--n6 >= 0) {
                        AnimationManager.unloadImage(n5, n6);
                    }
                } else {
                    AnimationManager.unloadImage(n5, n2);
                }
            }
            ++n3;
        }
        Event.PMSystem_forceGC();
    }

    public static void menuClear(short[] sArray, int n) {
        Main.menuClear(sArray, n, -1);
    }

    public static void menuClear(short[] sArray, int n, int n2) {
        sArray[1] = (short)n;
        sArray[2] = 0;
        sArray[3] = 0;
        sArray[4] = (short)n2;
        sArray[0] = 0;
    }

    public static void menuAppendItem(short[] sArray, int n) {
        short s = sArray[0];
        sArray[5 + s] = (short)n;
        sArray[0] = (short)(s + 1);
    }

    public static boolean menuContains(short[] sArray, int n) {
        int n2 = sArray[0] + 5;
        for (int i = 5; i < n2; ++i) {
            if (n != sArray[i]) continue;
            return true;
        }
        return false;
    }

    public static void menuCopy(short[] sArray, short[] sArray2) {
        System.arraycopy(sArray2, 0, sArray, 0, 5 + sArray2[0]);
    }

    public static void menuVisible(short[] sArray) {
        short s = sArray[4];
        if (s <= 0) {
            return;
        }
        int n = sArray[2];
        int n2 = sArray[3];
        if (n < n2) {
            n2 = n;
        } else if (n >= n2 + s) {
            n2 = Math.max(0, n - s + 1);
        }
        sArray[3] = (short)n2;
    }

    public static boolean menuCursorUpDown(short[] sArray) {
        short s = sArray[0];
        short s2 = sArray[2];
        if (ArrayHandler.PMInput_isPressed(32)) {
            sArray[2] = (short)((s2 + s - 1) % s);
        }
        if (ArrayHandler.PMInput_isPressed(64)) {
            sArray[2] = (short)((s2 + 1) % s);
        }
        if (sArray[2] != s2) {
            AnimationManager.TextHandler_resetScrollerTimers(1, s);
            Main.menuVisible(sArray);
            return true;
        }
        return false;
    }

    public static boolean menuCursorLeftRight(short[] sArray) {
        short s = sArray[0];
        short s2 = sArray[2];
        if (ArrayHandler.PMInput_isPressed(8) && s > 0) {
            sArray[2] = (short)((s2 + s - 1) % s);
        }
        if (ArrayHandler.PMInput_isPressed(16) && s > 0) {
            sArray[2] = (short)((s2 + 1) % s);
        }
        if (sArray[2] != s2) {
            Main.menuVisible(sArray);
            AnimationManager.TextHandler_resetScrollers();
            return true;
        }
        return false;
    }

    public static void menuSelectById(short[] sArray, int n) {
        for (int i = 5; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            sArray[2] = (short)(i - 5);
            return;
        }
    }

    public static void drawLoading() {
        Intro.LoadingScreen_draw();
    }

    public static void loadGameData(int n) {
        if (n == 0) {
            Main.loadUIPanels();
        } else if (n == 1) {
            m_simWorld = new SimWorld();
        } else if (n == 2) {
            m_simData = new SimData();
            m_nextHouseId = 0;
            Main.setNextZoomMapId(-1);
            m_encounterNPCId = -1;
        }
    }

    public static void setNextHouseId(int n) {
        m_nextHouseId = n;
    }

    public static int getNextHouseId() {
        return m_nextHouseId;
    }

    public static void setNextZoomMapId(int n) {
        if (m_nextZoomMapId != -1) {
            m_nextZoomMapIdPREV = m_nextZoomMapId;
        } else if (m_nextZoomMapId == -1 && n != -1) {
            m_nextZoomMapIdPREV = n;
        }
        m_nextZoomMapId = n;
    }

    public static int getNextZoomMapId() {
        return m_nextZoomMapId;
    }

    public static void setupEncounter(MapObjectSim mapObjectSim) {
        MapObjectSim mapObjectSim2 = StateInGame.getPlayerSim();
        m_encounterPlayerXF = mapObjectSim2.getPosX();
        m_encounterPlayerZF = mapObjectSim2.getPosZ();
        if (mapObjectSim != null) {
            m_encounterNPCXF = mapObjectSim.getPosX();
            m_encounterNPCZF = mapObjectSim.getPosZ();
            m_encounterNPCId = mapObjectSim.getId();
        } else {
            m_encounterNPCId = -1;
        }
        m_nextHouseId = -1;
    }

    public static int getEncounterPlayerX() {
        return m_encounterPlayerXF;
    }

    public static int getEncounterPlayerZ() {
        return m_encounterPlayerZF;
    }

    public static int getEncounterNPCX() {
        return m_encounterNPCXF;
    }

    public static int getEncounterNPCZ() {
        return m_encounterNPCZF;
    }

    public static int getEncounterNPCId() {
        return m_encounterNPCId;
    }

    public static final short lookupSimsUI() {
        return ArrayHandler.SimsUIConstants_SIMSUI_SYMBOL_LOOKUPS[GameConstants.PMFile_readShort()];
    }

    public static void loadUIPanels() {
        int n;
        int n2;
        Cursor.ResourceManager_loadBinaryFile(88);
        int n3 = GameConstants.PMFile_readByte();
        short[][] sArrayArray = new short[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = GameConstants.PMFile_readByte();
            short[] sArray = new short[n4 << 1];
            n = 0;
            for (int i = 0; i < n4; ++i) {
                sArray[n] = GameConstants.PMFile_readByte();
                sArray[n + 1] = Main.lookupSimsUI();
                n += 2;
            }
            sArrayArray[n2] = sArray;
        }
        n2 = GameConstants.PMFile_readByte();
        int[] nArray = new int[n2 << 1];
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            nArray[n5] = Main.lookupSimsUI();
            nArray[n5 + 1] = GameConstants.PMFile_readInt();
            n5 += 2;
        }
        d_images = nArray;
        GameConstants.PMFile_closeFile();
        d_uiPanels = sArrayArray;
        d_uiPanels = ArrayOptimizer.Optimize(d_uiPanels);
    }

    public static short[] getUIPanel(int n) {
        return d_uiPanels[n];
    }

    public static int responseToFeedbackAnim(int n) {
        return RESPONSE_ANIMS[n & 0xF];
    }

    public static void setVarsOnExternal() {
        Debug.UserInterface_newScrollTimePressed = -1;
        GameConstants.Minigame_externalEvent();
    }

    public static void BB_MenuPressed() {
        Intro.StateMenu_BB_MenuRequestedSet(true);
    }

    static {
        RESPONSE_ANIMS = new short[]{681, 680, 679, 359, 682, 683, 684};
    }
}

