/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.mobilepostproduction.ResourceBlock;
import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Camera;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.state.StateInGame;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;

public class GameConstants {
    public static boolean Minigame_goalCompletedPracticed;
    public static byte Minigame_goalCompletedType;
    public static boolean Minigame_goalCompletedWon;
    public static MapObject Minigame_targetObject;
    public static boolean Minigame_inspired;
    public static int Minigame_gameSkill;
    public static int Minigame_npcID;
    public static int Minigame_numSuccessfulPracticesConsecutive;
    public static int Minigame_numSuccessfulPractices;
    public static int Minigame_gametype;
    public static final int[] Minigame_MOTIVE_ADJUST_WIN;
    public static final int[] Minigame_MOTIVE_ADJUST_LOSE;
    public static int Minigame_gameState;
    public static int Minigame_top;
    public static int Minigame_bottom;
    public static int Minigame_width;
    public static int Minigame_height;
    public static int Minigame_clockX;
    public static int Minigame_clockY;
    public static int Minigame_clockW;
    public static int Minigame_timerX;
    public static int Minigame_timerY;
    public static int Minigame_timerW;
    public static int Minigame_timerH;
    public static int Minigame_gameTimer;
    public static int Minigame_gameTimerMax;
    public static int Minigame_endTimer;
    public static boolean Minigame_done;
    public static boolean Minigame_clearBg;
    public static int Minigame_runningUpdates;
    public static int Minigame_key;
    public static boolean Minigame_interruptedByExternalEvent;
    public static int Minigame_practiceTimeOpen;
    public static int Minigame_practiceTimeClose;
    public static final int[] Minigame_COMMODITIES_POS;
    public static final int[] Minigame_COMMODITIES_NEG;
    public static final short[] SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS;
    public static Canvas PMFile_canvas;
    public static DataInputStream PMFile_dis;
    public static int PMFile_fileLen;
    public static boolean PMFile_loadScreen;
    public static int PMFile_currentOffset;
    public static int PMFile_currentBin;
    public static int PMFile_currentFile;
    public static boolean PMFile_cachedFile;
    public static byte[][] PMFile_fileByteCaching;
    public static int PMFile_readingFromArrayPos;
    public static short[] PMFile_filesCRC;
    public static byte[] PMFile_filesCache;
    public static int[] PMFile_filesOffset;
    public static byte[] PMFile_filesBin;
    public static int[] PMFile_filesLen;
    public static int PMFile_fileCount;
    private static int PMFile_poly;
    private static int[] PMFile_crcTable;

    public static int Path_calc(int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        switch (n4) {
            default: {
                Debug.ASSERT(false, "invalid path type");
            }
            case 0: {
                return n + Camera.MathExt_clip(Camera.MathExt_Fmul(n3, n5), 0, n5);
            }
            case 1: {
                n3 = Camera.MathExt_smoothstepF(0, 65536, n3);
                return n + Camera.MathExt_clip(Camera.MathExt_Fmul(n3, n5), 0, n5);
            }
            case 2: {
                n3 = Camera.MathExt_smoothstepF(0, 65536, 32768 + (n3 >> 1));
                return n + Camera.MathExt_clip(Camera.MathExt_Fmul(n3, n5), 0, n5);
            }
            case 3: {
                if (n3 < 58982) {
                    n3 = Camera.MathExt_Fmul(Camera.MathExt_smoothstepF(0, 58982, n3), 68812);
                } else {
                    int n6 = 65536 - Camera.MathExt_Fdiv(n3 - 58982, 6554);
                    n3 = 65536 + Camera.MathExt_Fmul(3276, n6);
                }
                return n + Camera.MathExt_Fmul(n3, n5);
            }
            case 4: {
                if (n3 < 55705) {
                    n3 = Camera.MathExt_Fmul(Camera.MathExt_smoothstepF(0, 55705, n3), 68812);
                } else {
                    int n7 = 65536 - Camera.MathExt_Fdiv(n3 - 55705, 9831);
                    n3 = 65536 + Camera.MathExt_Fmul(3276, n7);
                }
                return n + Camera.MathExt_Fmul(n3, n5);
            }
            case 5: {
                if (n3 < 49152) {
                    n3 = Camera.MathExt_Fmul(Camera.MathExt_smoothstepF(0, 49152, n3), 98304);
                } else {
                    int n8 = 65536 - Camera.MathExt_Fdiv(n3 - 49152, 16384);
                    n3 = 65536 + Camera.MathExt_Fmul(32768, n8);
                }
                return n + Camera.MathExt_Fmul(n3, n5);
            }
            case 6: 
        }
        if (n3 < 32768) {
            int n9 = Camera.MathExt_Fdiv(Camera.MathExt_Fmul(n3, 102944), 32768);
            n3 = Camera.MathExt_Fmul(Camera.MathExt_Fsin(n9), 72089);
        } else {
            int n10 = Camera.MathExt_Fdiv(n3 - 32768, 32768);
            int n11 = Camera.MathExt_Fmul(n10, 617662);
            int n12 = 6554 - Camera.MathExt_Fmul(6554, n10);
            n3 = Camera.MathExt_Fmul(Camera.MathExt_Fcos(n11), n12) + 65536;
        }
        return n + Camera.MathExt_Fmul(n3, n5);
    }

    public static void Minigame_init() {
        Minigame_top = AnimationManager.getAnimFrameHeight(677, 0);
        Minigame_bottom = 245;
        Minigame_width = 240;
        Minigame_height = Minigame_bottom - Minigame_top;
        Minigame_clockX = Minigame_clockW = AnimationManager.getAnimFrameWidth(296, 0);
        Minigame_timerH = AnimationManager.getAnimFrameHeight(298, 0);
        Minigame_timerY = (Minigame_top >> 1) - Minigame_timerH;
        Minigame_clockY = Minigame_top - Minigame_timerH >> 1;
        Minigame_timerW = 240 - Minigame_clockW * 4;
        Minigame_timerX = Minigame_clockW * 2;
    }

    public static void Minigame_load(int n) {
        Minigame_key = -1;
        Minigame_runningUpdates = 0;
        switch (n) {
            case 0: {
                AnimationManager.loadImage(35);
                break;
            }
            case 1: {
                AnimationManager.loadImage(36);
                AnimationManager.loadImage(74);
                break;
            }
            case 2: {
                AnimationManager.loadImage(37);
                break;
            }
            case 3: {
                AnimationManager.loadImage(38);
                break;
            }
        }
    }

    public static void Minigame_deinit(boolean bl, boolean bl2) {
        switch (Minigame_gametype) {
            case 0: {
                Cursor.MinigameArt_deinit();
                AnimationManager.unloadImage(35, 0);
                break;
            }
            case 1: {
                ArrayHandler.MinigameFashion_deinit();
                AnimationManager.unloadImage(36, 0);
                AnimationManager.unloadImage(74, 0);
                break;
            }
            case 2: {
                AnimationManager.MinigameMusic_deinit();
                AnimationManager.unloadImage(37, 0);
                break;
            }
            case 3: {
                ArrayOptimizer.MinigameSport_deinit();
                AnimationManager.unloadImage(38, 0);
            }
        }
        if (!bl2) {
            Minigame_goalCompletedPracticed = true;
            if (Minigame_gametype == 0) {
                Minigame_goalCompletedType = 0;
                if (bl) {
                    Minigame_goalCompletedWon = true;
                }
            }
            if (Minigame_gametype == 2) {
                Minigame_goalCompletedType = (byte)2;
                if (bl) {
                    Minigame_goalCompletedWon = true;
                }
            }
            if (Minigame_gametype == 1) {
                Minigame_goalCompletedType = 1;
                if (bl) {
                    Minigame_goalCompletedWon = true;
                }
            }
            if (Minigame_gametype == 3) {
                Minigame_goalCompletedType = (byte)3;
                if (bl) {
                    Minigame_goalCompletedWon = true;
                }
            }
        }
        if (Minigame_npcID == -1) {
            if (bl && !bl2) {
                ++Minigame_numSuccessfulPractices;
                if (++Minigame_numSuccessfulPracticesConsecutive == 10) {
                    Minigame_numSuccessfulPracticesConsecutive = 0;
                    Main.m_simData.dreamCompleteEvent(22);
                }
            } else {
                Minigame_numSuccessfulPracticesConsecutive = 0;
            }
        }
        if (Minigame_npcID != -1 && !bl2) {
            int n = -1;
            int n2 = 1;
            int n3 = Main.rand(30, 70);
            int n4 = -1;
            int n5 = Minigame_COMMODITIES_POS[Main.rand(0, Minigame_COMMODITIES_POS.length - 1)];
            if (Minigame_gametype == 0) {
                n4 = 17;
            }
            if (Minigame_gametype == 2) {
                n4 = 18;
            }
            if (Minigame_gametype == 1) {
                n4 = 19;
            }
            if (Minigame_gametype == 3) {
                n4 = 20;
            }
            MapObjectSim mapObjectSim = StateInGame.findSim(Minigame_npcID);
            if (bl) {
                n = Main.responseToFeedbackAnim(4);
                if (n4 != -1 && Main.m_simData.hasSimGotTrait(Minigame_npcID, n4) != -1) {
                    n = Main.responseToFeedbackAnim(6);
                    n2 *= 2;
                    n3 *= 2;
                }
                mapObjectSim.simFeedback(12, 5000, n, true, false);
                Main.m_simData.adjustRelLevels(Minigame_npcID, n2, 0);
                Main.m_simData.applyCommodity(Minigame_npcID, n5, n3, false);
                StateInGame.showMessageBox(979, 978);
            } else {
                n = Main.responseToFeedbackAnim(2);
                if (n4 != -1 && Main.m_simData.hasSimGotTrait(Minigame_npcID, n4) != -1) {
                    n = Main.responseToFeedbackAnim(0);
                    n2 *= 2;
                    n3 *= 2;
                }
                mapObjectSim.simFeedback(28, 5000, n, true, false);
                Main.m_simData.adjustRelLevels(Minigame_npcID, -n2, 0);
                n5 = Minigame_COMMODITIES_NEG[Main.rand(0, Minigame_COMMODITIES_NEG.length - 1)];
                Main.m_simData.applyCommodity(Minigame_npcID, n5, n3, false);
                StateInGame.showMessageBox(976, 977);
            }
            Minigame_npcID = -1;
        }
        Main.m_simData.m_timeoutDelay = 0;
        StateInGame.m_timeHit = 60;
        Main.m_simData.removeActiveBuff(3);
        Main.m_simData.setMotiveAdjust(1, -1638400);
        if (StateInGame.m_mapMode == 1) {
            if (Main.getNextZoomMapId() == 79) {
                Main.m_simData.dreamCompleteEvent(0);
            }
            if (Main.getNextZoomMapId() == 81) {
                Main.m_simData.dreamCompleteEvent(1);
            }
            if (Main.getNextZoomMapId() == 80) {
                Main.m_simData.dreamCompleteEvent(30);
            }
            if (Main.getNextZoomMapId() == 82) {
                Main.m_simData.dreamCompleteEvent(41);
            }
        }
    }

    public static void Minigame_beginMiniGame(int n, MapObject mapObject) {
        Main.m_simData.delayAlerts();
        Minigame_targetObject = mapObject;
        Minigame_gametype = n;
        StateInGame.hideMenus();
        Minigame_endTimer = 4000;
        Minigame_done = false;
        Minigame_clearBg = true;
        GameConstants.Minigame_load(n);
        boolean bl = false;
        Minigame_gameTimer = 0;
        switch (n) {
            default: {
                break;
            }
            case 0: {
                Minigame_gameSkill = 0;
                Cursor.MinigameArt_init();
                break;
            }
            case 1: {
                Minigame_gameSkill = 2;
                ArrayHandler.MinigameFashion_init();
                break;
            }
            case 2: {
                Minigame_gameSkill = 1;
                AnimationManager.MinigameMusic_init();
                break;
            }
            case 3: {
                Minigame_gameSkill = 3;
                ArrayOptimizer.MinigameSport_init();
            }
        }
        Minigame_interruptedByExternalEvent = false;
        StateInGame.stateTransition(16);
        if (bl) {
            GameConstants.Minigame_stateTransitionMiniGame(1);
        } else {
            GameConstants.Minigame_stateTransitionMiniGame(0);
        }
    }

    public static void Minigame_stateTransitionMiniGame(int n) {
        Minigame_gameState = n;
        block0 : switch (n) {
            default: {
                break;
            }
            case 0: {
                switch (Minigame_gametype) {
                    case 0: {
                        StateInGame.showTutorialMessage((byte)3, 897, 898);
                        break block0;
                    }
                    case 1: {
                        StateInGame.showTutorialMessage((byte)4, 913, 914);
                        break block0;
                    }
                    case 2: {
                        StateInGame.showTutorialMessage((byte)5, 927, 928);
                        break block0;
                    }
                    case 3: {
                        StateInGame.showTutorialMessage((byte)6, 934, 935);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                GameConstants.Minigame_adjustMotives(true);
                Main.m_simData.consumeTools(Minigame_gameSkill);
                GameConstants.Minigame_win();
                break;
            }
            case 2: {
                PMAudio.play(12, 1);
                GameConstants.Minigame_adjustMotives(false);
                Main.m_simData.consumeTools(Minigame_gameSkill);
                Cursor.setCursorObject(Minigame_targetObject);
                StateInGame.m_playerSim.endSimPhase();
                if (Minigame_npcID != -1) {
                    StateInGame.showMessageBox(976, 977);
                } else {
                    StateInGame.showMessageBox(517, 458);
                }
                GameConstants.Minigame_deinit(false, false);
                break;
            }
            case 3: {
                StateInGame.m_timeHit = 0;
                Main.m_simData.consumeTools(Minigame_gameSkill);
                Cursor.setCursorObject(Minigame_targetObject);
                StateInGame.m_playerSim.endSimPhase();
                StateInGame.m_playerSim.interrupt();
                StateInGame.showMessageBox(516, 458);
                GameConstants.Minigame_deinit(false, true);
            }
        }
    }

    public static void Minigame_win() {
        if (Minigame_targetObject != null) {
            Cursor.setCursorObject(Minigame_targetObject);
        }
        StateInGame.stateTransition(5);
        GameConstants.Minigame_increaseSkill(Minigame_gameSkill);
        StateInGame.m_playerSim.endSimPhase();
        GameConstants.Minigame_deinit(true, false);
    }

    public static void Minigame_increaseSkill(int n) {
        if (Minigame_npcID != -1) {
            return;
        }
        int n2 = Main.m_simData.getSkillRank(n);
        Main.m_simData.increaseSkill(n);
        int n3 = Main.m_simData.getSkillRank(n);
        int n4 = 518;
        if (n2 != n3) {
            n4 = n3 == 5 ? 520 : 519;
            if (n3 == 5) {
                if (n == 0) {
                    Main.m_simData.dreamCompleteEvent(20);
                }
                if (n == 1) {
                    Main.m_simData.dreamCompleteEvent(26);
                }
                if (n == 2) {
                    Main.m_simData.dreamCompleteEvent(37);
                }
                if (n == 3) {
                    Main.m_simData.dreamCompleteEvent(49);
                }
                AnimationManager.TextHandler_dynamicString(-11, 855, Main.m_simData.getSkillDesc(n));
                Event.triggerEvent(4, -11, n, 856, -11);
            } else if (n3 == 2) {
                PMAudio.play(10, 1);
                StateInGame.showMessageBox(n4, Main.m_simData.getSkillDesc(n), 6);
            } else if (n2 != 5) {
                PMAudio.play(10, 1);
                int n5 = Main.m_simData.getSkillDesc(n);
                StateInGame.showMessageBox(n4, n5);
            }
        } else if (n2 != 5) {
            PMAudio.play(10, 1);
            int n6 = Main.m_simData.getSkillDesc(n);
            StateInGame.showMessageBox(n4, n6);
        } else if (n2 == 5) {
            if (n3 == 5) {
                StateInGame.showMessageBox(520, Main.m_simData.getSkillDesc(n));
            }
        }
    }

    public static void Minigame_renderMiniGame() {
        ArrayOptimizer.Touch_clear();
        GameConstants.Minigame_renderMiniGameBGTimer();
        switch (Minigame_gametype) {
            case 0: {
                Cursor.MinigameArt_render();
                break;
            }
            case 1: {
                ArrayHandler.MinigameFashion_render();
                break;
            }
            case 2: {
                AnimationManager.MinigameMusic_render();
                break;
            }
            case 3: {
                ArrayOptimizer.MinigameSport_render();
                break;
            }
        }
        if (StateInGame.m_tutorialMessageActive) {
            Debug.UserInterface_drawTextScreen();
        }
        if (StateInGame.m_pauseMenuActive) {
            StateInGame.renderPauseMenu();
            Minigame_clearBg = true;
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void Minigame_renderMiniGameBGTimer() {
        AnimationManager.drawAnimFrame(677, 0, 0, Minigame_top);
        AnimationManager.drawAnimFrame(678, 0, 0, Minigame_bottom);
        int n = ArrayOptimizer.PMGraphics_getClipX();
        int n2 = ArrayOptimizer.PMGraphics_getClipY();
        int n3 = ArrayOptimizer.PMGraphics_getClipWidth();
        int n4 = ArrayOptimizer.PMGraphics_getClipHeight();
        ArrayOptimizer.PMGraphics_setClip(Minigame_timerX, n2, Minigame_timerW, n4);
        AnimationManager.drawAnimFrame(297, 0, Minigame_timerX, Minigame_timerY);
        int n5 = Minigame_timerW * Minigame_gameTimer / Minigame_gameTimerMax;
        ArrayOptimizer.PMGraphics_setClip(Minigame_timerX, n2, n5, n4);
        AnimationManager.drawAnimFrame(298, 0, Minigame_timerX, Minigame_timerY);
        ArrayOptimizer.PMGraphics_setClip(n, n2, n3, n4);
        AnimationManager.drawAnimFrame(296, 0, Minigame_clockX, Minigame_clockY);
    }

    public static void Minigame_processKeysMiniGame() {
        if (Main.softPressNeg(1) || ArrayHandler.PMInput_isPressed(4) || Minigame_interruptedByExternalEvent) {
            Minigame_interruptedByExternalEvent = false;
            StateInGame.showPauseMenu();
            return;
        }
        if (Main.softPressPos(64)) {
            GameConstants.Minigame_stateTransitionMiniGame(3);
            return;
        }
        switch (Minigame_gametype) {
            default: {
                break;
            }
            case 0: {
                Cursor.MinigameArt_processKeys();
                break;
            }
            case 1: {
                ArrayHandler.MinigameFashion_processKeys();
                break;
            }
            case 2: {
                AnimationManager.MinigameMusic_processKeys();
                break;
            }
            case 3: {
                ArrayOptimizer.MinigameSport_processKeys();
            }
        }
    }

    public static void Minigame_updateMiniGame(int n) {
        if (StateInGame.m_pauseMenuActive || StateInGame.m_tutorialMessageActive) {
            return;
        }
        StateInGame.m_playerSim.update(n);
        if (Minigame_targetObject != null) {
            Minigame_targetObject.update(n);
        }
        StateInGame.updateObjectTypes(n, 5);
        switch (Minigame_gametype) {
            case 0: {
                Cursor.MinigameArt_update(n);
                break;
            }
            case 1: {
                ArrayHandler.MinigameFashion_update(n);
                break;
            }
            case 2: {
                AnimationManager.MinigameMusic_update(n);
                break;
            }
            case 3: {
                ArrayOptimizer.MinigameSport_update(n);
                break;
            }
        }
    }

    public static void Minigame_externalEvent() {
        if (!StateInGame.m_pauseMenuActive) {
            Minigame_interruptedByExternalEvent = true;
        }
    }

    public static boolean Minigame_isMinigameAvailable(int n) {
        int n2;
        int n3 = 0;
        if (n == Main.m_simData.getSimCareer(0)) {
            n3 = Main.m_simData.getSimCareerLevel(0);
        }
        return Main.m_simData.isTimeInRange(n2 = Main.m_simData.getGameTime(), Minigame_practiceTimeOpen = Main.m_simData.getCareerLevelHoursEnd(n, n3), Minigame_practiceTimeClose = Main.m_simData.getCareerLevelHoursStart(n, n3));
    }

    public static boolean Minigame_areNecessaryToolsAvailable(int n) {
        block4: {
            block3: {
                int n2 = Main.m_simData.getSkillRank(n);
                if (n2 <= 1) break block3;
                if (n2 != 5) break block4;
            }
            return true;
        }
        int[] nArray = Main.m_simData.getSkillConsumables(n);
        for (int i = 0; i < nArray.length; ++i) {
            if (Main.m_simData.getInventoryCount(nArray[i]) != 0) continue;
            return false;
        }
        return true;
    }

    public static void Minigame_adjustMotives(boolean bl) {
        if (bl) {
            int n = Main.rand(0, Minigame_MOTIVE_ADJUST_WIN.length - 1);
            Main.m_simData.adjustMotiveLevel(Minigame_MOTIVE_ADJUST_WIN[n], Main.rand(20, 40));
        } else {
            int n = Main.rand(0, Minigame_MOTIVE_ADJUST_LOSE.length - 1);
            Main.m_simData.adjustMotiveLevel(Minigame_MOTIVE_ADJUST_LOSE[n], -Main.rand(20, 40));
        }
    }

    public static int PMFile_fileNumber(short s) {
        for (int i = 0; i < PMFile_fileCount; ++i) {
            if (PMFile_filesCRC[i] != s) continue;
            return i;
        }
        GlobalConstants.PMDebug_println("GameConstants.PMFile_fileNumber(): WARNING! Unable to find file in the bfc. Check /res/bfc.log to make sure the file is in the build.");
        return -1;
    }

    public static void PMFile_initFileCache(int n) {
        PMFile_fileByteCaching = new byte[n][];
        PMFile_cachedFile = false;
    }

    public static void PMFile_cacheFile(int n) {
        try {
            PMFile_currentFile = n;
            PMFile_cachedFile = true;
            PMFile_readingFromArrayPos = 0;
            GameConstants.PMFile_fileByteCaching[n] = new byte[PMFile_fileLen];
            int n2 = 0;
            int n3 = 0;
            int n4 = PMFile_fileLen;
            while (n4 > 0) {
                n2 = PMFile_dis.read(PMFile_fileByteCaching[n], n3, n4);
                n4 -= n2;
                n3 += n2;
            }
            for (int i = 0; i < PMFile_fileCount; ++i) {
                if (i == n || PMFile_filesOffset[i] != PMFile_filesOffset[n] || PMFile_filesBin[i] != PMFile_filesBin[n]) continue;
                GameConstants.PMFile_fileByteCaching[i] = PMFile_fileByteCaching[n];
            }
            PMFile_currentOffset += PMFile_fileLen;
        }
        catch (Exception exception) {
            GlobalConstants.PMDebug_println("GameConstants.PMFile_cacheFile(): Exception!");
        }
    }

    public static void PMFile_initBFC() {
        PMFile_currentBin = -1;
        PMFile_currentOffset = 0;
        GameConstants.PMFile_initCRC();
        try {
            int n;
            String string = "/head.bfc";
            PMFile_dis = new DataInputStream(ResourceBlock.getResourceAsStream(string));
            PMFile_fileCount = n = PMFile_dis.readUnsignedShort();
            PMFile_filesCRC = new short[n];
            PMFile_filesCache = new byte[n];
            PMFile_filesOffset = new int[n];
            PMFile_filesBin = new byte[n];
            PMFile_filesLen = new int[n];
            for (int i = 0; i < n; ++i) {
                GameConstants.PMFile_filesCRC[i] = (short)PMFile_dis.readUnsignedShort();
                GameConstants.PMFile_filesCache[i] = PMFile_dis.readByte();
                GameConstants.PMFile_filesOffset[i] = PMFile_dis.readUnsignedByte() << 16 | PMFile_dis.readUnsignedByte() << 8 | PMFile_dis.readUnsignedByte();
                GameConstants.PMFile_filesBin[i] = (byte)PMFile_dis.readUnsignedByte();
                GameConstants.PMFile_filesLen[i] = PMFile_fileLen = PMFile_dis.readUnsignedByte() << 16 | PMFile_dis.readUnsignedByte() << 8 | PMFile_dis.readUnsignedByte();
            }
        }
        catch (Exception exception) {
            GlobalConstants.PMDebug_println("GameConstants.PMFile_cacheFile(): Exception!");
        }
        GameConstants.PMFile_initFileCache(PMFile_fileCount);
    }

    public static void PMFile_initCRC() {
        for (int i = 0; i < 256; ++i) {
            int n = 0;
            int n2 = i << 8;
            for (int j = 0; j < 8; ++j) {
                n = ((n ^ n2) & 0x8000) != 0 ? n << 1 ^ PMFile_poly : (n <<= 1);
                n2 <<= 1;
                n &= 0xFFFF;
            }
            GameConstants.PMFile_crcTable[i] = n;
        }
    }

    public static short PMFile_calcCRC(String string) {
        int n = 65535;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            byte by = (byte)(c >> 8);
            n = (PMFile_crcTable[(by ^ n >> 8) & 0xFF] ^ n << 8) & 0xFFFF;
            by = (byte)(c & 0xFF);
            n = (PMFile_crcTable[(by ^ n >> 8) & 0xFF] ^ n << 8) & 0xFFFF;
        }
        return (short)(n & 0xFFFF);
    }

    public static byte[] PMFile_fileToByteArrayNoBFC(String string) {
        byte[] byArray;
        if (!GameConstants.PMFile_openFile(string)) {
            return null;
        }
        int n = 2048;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        try {
            for (n2 = 0; n2 < n; ++n2) {
                byArray2[n2] = PMFile_dis.readByte();
            }
            byArray = byArray2;
        }
        catch (Exception exception) {
            byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = byArray2[i];
            }
        }
        return byArray;
    }

    public static byte[] PMFile_fileToByteArray(String string) {
        byte[] byArray = GameConstants.PMFile_fileToByteArray(GameConstants.PMFile_calcCRC(string));
        if (byArray == null) {
            return GameConstants.PMFile_fileToByteArrayNoBFC(string);
        }
        return byArray;
    }

    public static byte[] PMFile_fileToByteArray(short s) {
        if (!GameConstants.PMFile_openFile(s)) {
            GlobalConstants.PMDebug_println("GameConstants.PMFile_fileToByteArray(): WARNING! Unable to find file in the bfc. Check /res/bfc.log to make sure the file is in the build.");
            return null;
        }
        byte[] byArray = new byte[PMFile_fileLen];
        GameConstants.PMFile_read(byArray, 0, PMFile_fileLen);
        return byArray;
    }

    public static byte[] PMFile_fileToConstByteArray(String string) {
        return GameConstants.PMFile_fileToConstByteArray(GameConstants.PMFile_calcCRC(string));
    }

    public static byte[] PMFile_fileToConstByteArray(short s) {
        int n = GameConstants.PMFile_fileNumber(s);
        if (n < 0) {
            return null;
        }
        if (PMFile_fileByteCaching[n] != null) {
            return PMFile_fileByteCaching[n];
        }
        return GameConstants.PMFile_fileToByteArray(s);
    }

    public static boolean PMFile_openFile(String string) {
        short s = GameConstants.PMFile_calcCRC(string);
        boolean bl = GameConstants.PMFile_openFile(s);
        if (bl) {
            return true;
        }
        try {
            GlobalConstants.PMDebug_println("GameConstants.PMFile_openFile(): WARNING! Failed to open file from the bfc. Trying to open it in the jar file.");
            InputStream inputStream = null;
            inputStream = ResourceBlock.getResourceAsStream("/" + string);
            if (inputStream == null) {
                return false;
            }
            PMFile_dis = new DataInputStream(inputStream);
        }
        catch (Exception exception) {
            GlobalConstants.PMDebug_println("GameConstants.PMFile_openFile(): ERROR! File not found in jar.");
            return false;
        }
        return true;
    }

    public static boolean PMFile_openFile(short s) {
        int n;
        if (PMFile_loadScreen) {
            Main.drawLoading();
        }
        PMFile_currentFile = n = GameConstants.PMFile_fileNumber(s);
        PMFile_readingFromArrayPos = 0;
        PMFile_cachedFile = false;
        if (n >= 0 && PMFile_fileByteCaching[n] != null) {
            PMFile_fileLen = PMFile_filesLen[n];
            PMFile_cachedFile = true;
            return true;
        }
        if (n != -1) {
            PMFile_fileLen = PMFile_filesLen[n];
            if (PMFile_currentBin == PMFile_filesBin[n] && PMFile_currentOffset <= PMFile_filesOffset[n]) {
                GameConstants.PMFile_skip(PMFile_filesOffset[n] - PMFile_currentOffset);
                if (PMFile_filesCache[n] >= 0 && PMFile_fileByteCaching[n] == null) {
                    GameConstants.PMFile_cacheFile(n);
                }
                return true;
            }
            try {
                if (PMFile_dis != null) {
                    GameConstants.PMFile_forceClose();
                }
                PMFile_dis = new DataInputStream(ResourceBlock.getResourceAsStream("/" + PMFile_filesBin[n] + ".bfc"));
                PMFile_dis.skip(PMFile_filesOffset[n]);
                PMFile_currentBin = PMFile_filesBin[n];
                PMFile_currentOffset = PMFile_filesOffset[n];
                if (PMFile_filesCache[n] >= 0 && PMFile_fileByteCaching[n] == null) {
                    GameConstants.PMFile_cacheFile(n);
                }
                return true;
            }
            catch (Exception exception) {
                GlobalConstants.PMDebug_println("GameConstants.PMFile_openFile(): ERROR! Exception caught.");
            }
        }
        return false;
    }

    public static void PMFile_skip(int n) {
        if (PMFile_cachedFile) {
            PMFile_readingFromArrayPos += n;
        } else {
            PMFile_currentOffset += n;
            try {
                while (n > 0) {
                    n = (int)((long)n - PMFile_dis.skip(n));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static byte[] PMFile_read(byte[] byArray, int n, int n2) {
        if (PMFile_cachedFile) {
            System.arraycopy(PMFile_fileByteCaching[PMFile_currentFile], PMFile_readingFromArrayPos, byArray, n, n2);
            PMFile_readingFromArrayPos += n2;
            return byArray;
        }
        PMFile_currentOffset += n2;
        try {
            int n3 = 0;
            while (n2 > 0) {
                n3 = PMFile_dis.read(byArray, n, n2);
                n2 -= n3;
                n += n3;
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static short PMFile_readShort() {
        if (PMFile_cachedFile) {
            short s = (short)(PMFile_fileByteCaching[PMFile_currentFile][PMFile_readingFromArrayPos] << 8 | PMFile_fileByteCaching[PMFile_currentFile][PMFile_readingFromArrayPos + 1] & 0xFF);
            PMFile_readingFromArrayPos += 2;
            return s;
        }
        PMFile_currentOffset += 2;
        try {
            return PMFile_dis.readShort();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int PMFile_readUnsignedByte() {
        if (PMFile_cachedFile) {
            int n = PMFile_fileByteCaching[PMFile_currentFile][PMFile_readingFromArrayPos] & 0xFF;
            ++PMFile_readingFromArrayPos;
            return n;
        }
        ++PMFile_currentOffset;
        try {
            return PMFile_dis.readUnsignedByte();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static byte PMFile_readByte() {
        if (PMFile_cachedFile) {
            byte by = PMFile_fileByteCaching[PMFile_currentFile][PMFile_readingFromArrayPos];
            ++PMFile_readingFromArrayPos;
            return by;
        }
        ++PMFile_currentOffset;
        try {
            return PMFile_dis.readByte();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int PMFile_readInt() {
        if (PMFile_cachedFile) {
            int n = (PMFile_fileByteCaching[PMFile_currentFile][PMFile_readingFromArrayPos] & 0xFF) << 24 | (PMFile_fileByteCaching[PMFile_currentFile][PMFile_readingFromArrayPos + 1] & 0xFF) << 16 | (PMFile_fileByteCaching[PMFile_currentFile][PMFile_readingFromArrayPos + 2] & 0xFF) << 8 | PMFile_fileByteCaching[PMFile_currentFile][PMFile_readingFromArrayPos + 3] & 0xFF;
            PMFile_readingFromArrayPos += 4;
            return n;
        }
        PMFile_currentOffset += 4;
        try {
            return PMFile_dis.readInt();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static void PMFile_forceClose() {
        try {
            PMFile_dis.close();
            PMFile_currentFile = -1;
            PMFile_currentBin = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        PMFile_dis = null;
    }

    public static void PMFile_closeFile() {
    }

    static {
        Minigame_npcID = -1;
        Minigame_MOTIVE_ADJUST_WIN = new int[]{5, 1};
        Minigame_MOTIVE_ADJUST_LOSE = new int[]{5, 1};
        Minigame_COMMODITIES_POS = new int[]{4, 5, 6};
        Minigame_COMMODITIES_NEG = new int[]{0, 8, 1, 7};
        SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS = new short[]{635, 634, 161, 639, 638, 163, 637, 636, 162, 641, 640, 164, 241, 242, 246, 247, 243, 244, 245, 240, 249, 248, 121, 6, 0, -1, 173, 4, 7, 174, 5, 175, 176, 177, 171, 808, 809, 170, 157, 132, 2, 190, 191, 192, 193, 194, 189, 810, 811, 188, 187, 158, 144, 1, 165, 166, 167, 168, 169, 164, 806, 807, 163, 162, 155, 157, 3, 198, 199, 200, 201, 202, 197, 812, 813, 196, 195, 159, 893, 877, 883, 892, 880, 879, 895, 889, 888, 881, 878, 876, 894, 890, 882, 875, 891, 884, 886, 885, 887, 492, 721, 728, 490, 723, 730, 489, 718, 725, 493, 722, 729, 494, 724, 731, 491, 720, 727, 236, 238, 235, 237, 232, 234, 231, 233, 230, 229, 226, 228, 227, 35, 686, 687, 45, 692, 693, 44, 695, 696, 698, 699, 746, 747, 668, 669, 39, 665, 666, 653, 654, 656, 657, 43, 743, 744, 710, 711, 713, 714, 49, 731, 732, 48, 650, 651, 36, 737, 738, 674, 675, 671, 672, 56, 728, 729, 683, 684, 54, 659, 660, 704, 705, 57, 680, 681, 58, 677, 678, 55, 689, 690, 707, 708, 716, 717, 722, 723, 701, 702, 719, 720, 725, 726, 740, 741, 662, 663, 734, 735, 749, 750, 752, 753, 755, 756, 871, 775, 359, 761, 857, 764, 114, 860, 765, 861, 771, 867, 769, 112, 865, 770, 866, 762, 858, 773, 113, 869, 763, 859, 868, 772, 864, 768, 870, 774, 767, 863, 766, 862, 150, 121, 122, 3, 4, 818, 821, 822, 819, 820, 823, 824, 152, 126, 127, 17, 18, 832, 835, 836, 833, 834, 837, 838, 151, 123, 124, 10, 11, 825, 828, 829, 826, 827, 830, 831, 153, 130, 131, 24, 25, 839, 842, 843, 840, 841, 844, 845, 267, 268, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 319, 294, 295, 296, 298, 320, 269, 299, 300, 301, 302, 303, 304, 305, 306, 308, 321, 270, 271, 309, 310, 311, 312, 313, 316, 317, 318, 315, 322, 297, 307, 314, 557, 0, 68, -2, 40, 41, 2, 3, 51, 52, -3, 12, -4, 28, 46, 47, 54, 53, 358, 5, 55, 54, 6, 685, 691, 694, 697, 745, 667, 664, 730, 709, 649, 712, 736, 688, 706, 679, 715, 748, 733, 652, 655, 721, 739, 724, 727, 673, 718, 742, 670, 682, 661, 676, 703, 700, 658, 751, 754, 36, 37, 14, 13, 32, 359, 97, 96, 108, 111, 24, 109, 22, 110, 23, 112, 25, 115, 353, 114, 71, 50, 46, 355, 88, 42, 66, 127, 91, 48, 39, 354, 38, 44, 60, 356, 15, 11, 59, 103, 26, 31, 352, 26, 41, 18, 19, 16, 92, 99, 357, 40, 17, 122, 125, 123, 1046, 1047, 1050, 94, 51, 33, 45, 89, 38, 116, 44, 56, 119, 57, 58, 124, 120, 104, 86, 95, 105, 70, 69, 4, 126, 32, 107, 106, 118, 117, 29, 31, 30, 27, 47, 102, 93, 65, 21, 34, 42, 87, 35, 67, 43, 20, 74, 77, 80, 83, 75, 78, 81, 84, 73, 76, 79, 82, 72, 121, 101, 28, 62, 61, 964, 974, 1059, 1063, 1065, 1069, 52, 49, 0, 550, 1, 541, 554, 2, 547, 538, 3, 543, 4, 552, 5, 540, 546, 6, 537, 539, 7, 551, 8, 555, 553, 548, 536, 542, 556, 9, 549, 10, 545, 544, 156, 0, 149, 155, 157, 1, 2, 3, 152, 148, 146, 147, 154, 153, 151, 145, 150};
        PMFile_dis = null;
        PMFile_loadScreen = false;
        PMFile_currentOffset = -1;
        PMFile_currentBin = -1;
        PMFile_currentFile = -1;
        PMFile_readingFromArrayPos = 0;
        PMFile_poly = 4129;
        PMFile_crcTable = new int[256];
    }
}

