/*
 * Decompiled with CFR 0.152.
 */
package com.mobilepostproduction;

import com.mobilepostproduction.FileData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;

public class ResourceBlock {
    private static ResourceBlock m_Instance;
    private Hashtable m_FileCache = new Hashtable();
    private int m_nBlockSize;
    private int m_nCatalogueLength;

    public static InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        if (null == m_Instance) {
            m_Instance = new ResourceBlock();
            m_Instance.loadCatalogue();
        }
        if (null != (inputStream = m_Instance.getClass().getResourceAsStream(string))) {
            return inputStream;
        }
        return m_Instance.get(string);
    }

    public void loadCatalogue() {
        try {
            DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/r.0"));
            this.m_nBlockSize = dataInputStream.readInt();
            this.m_nCatalogueLength = dataInputStream.readInt();
            int n = dataInputStream.readInt();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.m_nCatalogueLength);
            byte[] byArray = new byte[this.m_nBlockSize];
            int n2 = 0;
            int n3 = 0;
            int n4 = this.m_nBlockSize - 12;
            do {
                int n5;
                if (n2 + n4 > this.m_nCatalogueLength) {
                    n4 = 0 == n3 ? this.m_nCatalogueLength : this.m_nCatalogueLength - n2;
                }
                if (-1 == (n5 = dataInputStream.read(byArray, 0, n4))) {
                    return;
                }
                n2 += n5;
                byteArrayOutputStream.write(byArray, 0, n5);
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n4 = this.m_nBlockSize;
                dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/r." + ++n3));
            } while (n2 < this.m_nCatalogueLength);
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            for (int i = 0; i < n; ++i) {
                String string = "/" + dataInputStream2.readUTF();
                int n6 = dataInputStream2.readInt();
                int n7 = dataInputStream2.readInt();
                this.m_FileCache.put(string, new FileData(n6, n7 + this.m_nCatalogueLength + 12));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public InputStream get(String string) {
        FileData fileData = (FileData)ResourceBlock.m_Instance.m_FileCache.get(string);
        if (null != fileData) {
            if (null == fileData.m_Data) {
                fileData.m_Data = new byte[fileData.m_nLength];
                byte[] byArray = new byte[this.m_nBlockSize];
                int n = fileData.m_nOffset / this.m_nBlockSize;
                int n2 = fileData.m_nOffset - this.m_nBlockSize * n;
                int n3 = this.m_nBlockSize;
                int n4 = 0;
                int n5 = 0;
                do {
                    InputStream inputStream = this.getClass().getResourceAsStream("/r." + n);
                    ++n;
                    try {
                        n5 = inputStream.read(byArray, 0, this.m_nBlockSize);
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        fileData.m_Data = null;
                        break;
                    }
                    if (-1 == n5) {
                        fileData.m_Data = null;
                        break;
                    }
                    if (n4 + n3 > fileData.m_nLength) {
                        n3 = fileData.m_nLength - n4;
                    }
                    if (n2 + n3 > this.m_nBlockSize) {
                        n3 = this.m_nBlockSize - n2;
                    }
                    System.arraycopy(byArray, n2, fileData.m_Data, n4, n3);
                    n2 = 0;
                } while ((n4 += (n3 = this.m_nBlockSize)) < fileData.m_nLength);
            }
            if (null != fileData.m_Data) {
                return new ByteArrayInputStream(fileData.m_Data);
            }
        }
        return null;
    }
}

