/*
 * Decompiled with CFR 0.152.
 */
class Quat {
    public TheGame m_g;
    public int[] val = new int[4];

    public Quat() {
        this.val[1] = 0;
        this.val[2] = 0;
        this.val[0] = 0;
        this.val[3] = 256;
    }

    public Quat(TheGame pGlobal) {
        this.m_g = pGlobal;
        this.val[1] = 0;
        this.val[2] = 0;
        this.val[0] = 0;
        this.val[3] = 256;
    }

    public Quat(TheGame pGlobal, Vec3 v, int theta) {
        this.m_g = pGlobal;
        int sinTheta = this.m_g.fm_Sin(theta >>= 1) >> 6;
        v.normalise();
        this.val[3] = this.m_g.fm_Cos(theta) >> 6;
        this.val[0] = v.val[0] * sinTheta >> 8;
        this.val[1] = v.val[1] * sinTheta >> 8;
        this.val[2] = v.val[2] * sinTheta >> 8;
        this.normalise();
    }

    public void set(Quat q) {
        this.val[0] = q.val[0];
        this.val[1] = q.val[1];
        this.val[2] = q.val[2];
        this.val[3] = q.val[3];
        this.m_g = q.m_g;
    }

    public int mag() {
        int num = this.val[0] * this.val[0] + this.val[1] * this.val[1] + this.val[2] * this.val[2] + this.val[3] * this.val[3];
        num = this.m_g.fm_Sqrt(num >> 0);
        return num >> 8;
    }

    public void normalise() {
        int m = this.mag();
        if (m == 0) {
            this.val[0] = 0;
            this.val[1] = 0;
            this.val[2] = 0;
            this.val[3] = 256;
        } else {
            this.val[0] = (this.val[0] << 8) / m;
            this.val[1] = (this.val[1] << 8) / m;
            this.val[2] = (this.val[2] << 8) / m;
            this.val[3] = (this.val[3] << 8) / m;
        }
    }

    public void inverse() {
        this.val[0] = -this.val[0];
        this.val[1] = -this.val[1];
        this.val[2] = -this.val[2];
    }

    public void rotate(Quat rhs) {
        Quat tmp = new Quat(this.m_g);
        tmp.val[0] = this.val[3] * rhs.val[0] + this.val[0] * rhs.val[3] + this.val[1] * rhs.val[2] - this.val[2] * rhs.val[1];
        tmp.val[1] = this.val[3] * rhs.val[1] - this.val[0] * rhs.val[2] + this.val[1] * rhs.val[3] + this.val[2] * rhs.val[0];
        tmp.val[2] = this.val[3] * rhs.val[2] + this.val[0] * rhs.val[1] - this.val[1] * rhs.val[0] + this.val[2] * rhs.val[3];
        tmp.val[3] = this.val[3] * rhs.val[3] - this.val[0] * rhs.val[0] - this.val[1] * rhs.val[1] - this.val[2] * rhs.val[2];
        this.val[0] = tmp.val[0] >> 8;
        this.val[1] = tmp.val[1] >> 8;
        this.val[2] = tmp.val[2] >> 8;
        this.val[3] = tmp.val[3] >> 8;
        this.normalise();
    }

    public void getMatrix(int[] matrix) {
        for (int i = 0; i < 16; ++i) {
            matrix[i] = 0;
        }
        matrix[15] = 1;
        int x2 = this.val[0] * this.val[0] >> 8;
        int y2 = this.val[1] * this.val[1] >> 8;
        int z2 = this.val[2] * this.val[2] >> 8;
        int w2 = this.val[3] * this.val[3] >> 8;
        int xy = this.val[0] * this.val[1] >> 8;
        int xz = this.val[0] * this.val[2] >> 8;
        int yz = this.val[1] * this.val[2] >> 8;
        int wx = this.val[3] * this.val[0] >> 8;
        int wy = this.val[3] * this.val[1] >> 8;
        int wz = this.val[3] * this.val[2] >> 8;
        matrix[0] = 256 - 2 * (y2 + z2);
        matrix[1] = 2 * (xy + wz);
        matrix[2] = 2 * (xz - wy);
        matrix[4] = 2 * (xy - wz);
        matrix[5] = 256 - 2 * (x2 + z2);
        matrix[6] = 2 * (yz + wx);
        matrix[8] = 2 * (xz + wy);
        matrix[9] = 2 * (yz - wx);
        matrix[10] = 256 - 2 * (x2 + y2);
    }
}

