/*
 * Decompiled with CFR 0.152.
 */
class Vec3 {
    public TheGame m_g;
    public int[] val = new int[3];

    public Vec3() {
    }

    public Vec3(TheGame g, int x, int y, int z) {
        this.val[0] = x;
        this.val[1] = y;
        this.val[2] = z;
        this.m_g = g;
    }

    public Vec3(TheGame pGlobal) {
        this.m_g = pGlobal;
    }

    public void set(Vec3 v) {
        this.val[0] = v.val[0];
        this.val[1] = v.val[1];
        this.val[2] = v.val[2];
        this.m_g = v.m_g;
    }

    public int mag() {
        int num = this.val[0] * this.val[0] + this.val[1] * this.val[1] + this.val[2] * this.val[2];
        num = this.m_g.fm_Sqrt(num >> 0);
        return num >> 8;
    }

    public int normalise() {
        int m = this.mag();
        if (m == 0) {
            this.val[0] = 256;
            this.val[1] = 0;
            this.val[2] = 0;
        } else {
            this.val[0] = (this.val[0] << 8) / m;
            this.val[1] = (this.val[1] << 8) / m;
            this.val[2] = (this.val[2] << 8) / m;
        }
        return m;
    }

    public void rotateZ(int r) {
        int cosr = this.m_g.fm_Cos(r) >> 6;
        int sinr = this.m_g.fm_Sin(r) >> 6;
        int tmpx = cosr * this.val[0] + this.val[1] * -sinr >> 8;
        int tmpy = sinr * this.val[0] + this.val[1] * cosr >> 8;
        this.val[0] = tmpx;
        this.val[1] = tmpy;
    }

    public void transform3(int[] matrix) {
        int tmpx = this.val[0] * matrix[0] + this.val[1] * matrix[4] + this.val[2] * matrix[8] >> 8;
        int tmpy = this.val[0] * matrix[1] + this.val[1] * matrix[5] + this.val[2] * matrix[9] >> 8;
        int tmpz = this.val[0] * matrix[2] + this.val[1] * matrix[6] + this.val[2] * matrix[10] >> 8;
        this.val[0] = tmpx;
        this.val[1] = tmpy;
        this.val[2] = tmpz;
    }

    public int dot(Vec3 v) {
        return this.val[0] * v.val[0] + this.val[1] * v.val[1] + this.val[2] * v.val[2];
    }
}

