/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import javax.microedition.lcdui.Font;

class CFont {
    TheGame m_tg;
    TheGame m_g;
    Font m_SystemFont;
    int m_pCustomFont;
    int m_pCustomFontColour;
    int m_nCustomChars;
    int m_propDataSize;
    char[] m_propDataArray;
    Hashtable charTable;
    int m_red;
    int m_green;
    int m_blue;
    int m_nMaxWidth;

    public CFont(TheGame tg) {
        this.m_tg = tg;
        this.m_g = tg;
    }

    void Construct() {
        this.m_SystemFont = null;
        this.m_pCustomFont = -1;
        this.m_pCustomFontColour = -1;
        this.m_red = 0;
        this.m_green = 0;
        this.m_blue = 0;
        this.m_nMaxWidth = 0;
    }

    void SetSystem(Font font) {
        if (this.m_pCustomFont >= 0) {
            this.m_g.asset_FreeFixedFont(this.m_pCustomFont);
        }
        this.m_pCustomFont = -1;
        this.m_SystemFont = font;
    }

    void SetCustom(int pFixedFont) throws Exception {
        if (this.m_pCustomFont >= 0) {
            this.m_g.asset_FreeFixedFont(this.m_pCustomFont);
        }
        this.m_SystemFont = null;
        this.m_pCustomFont = pFixedFont;
        this.m_g.asset_LoadFixedFont(this.m_pCustomFont);
        this.FindBestColourMatch();
        int fileID = 892;
        int nID = this.m_g.scene_binLoad(fileID);
        int nStart = (this.m_g.asset_DataArray[fileID + 0] & 0xFFFFFFFF) >> 0;
        int nSize = (this.m_g.asset_DataArray[fileID + 1] & 0xFFFF0000) >> 16;
        this.m_propDataArray = new char[nSize];
        for (int i = 0; i < nSize; ++i) {
            this.m_propDataArray[i] = this.m_g.scene_binGetByte(nID);
        }
        int h = (this.m_propDataArray[1] & 0xFF) << 8 | this.m_propDataArray[0] & 0xFF;
        if (h != 117) {
            // empty if block
        }
        this.m_nCustomChars = (this.m_propDataArray[3] & 0xFF) << 8 | this.m_propDataArray[2] & 0xFF;
        this.m_propDataSize = nSize;
        this.BinArrayToHashTable();
        this.m_g.scene_binFree(fileID);
    }

    void BinArrayToHashTable() {
        int recOffset = 6;
        this.charTable = new Hashtable();
        for (recOffset = 6; recOffset < this.m_propDataArray.length; recOffset += 10) {
            int charCode = (this.m_propDataArray[recOffset + 0 + 1] & 0xFF) << 8 | this.m_propDataArray[recOffset + 0 + 0] & 0xFF;
            int charPosX = (this.m_propDataArray[recOffset + 2 + 1] & 0xFF) << 8 | this.m_propDataArray[recOffset + 2 + 0] & 0xFF;
            int charPosY = (this.m_propDataArray[recOffset + 4 + 1] & 0xFF) << 8 | this.m_propDataArray[recOffset + 4 + 0] & 0xFF;
            int charWidth = this.m_propDataArray[recOffset + 6];
            int charHeight = this.m_propDataArray[recOffset + 7];
            int charOffsetY = ((this.m_propDataArray[recOffset + 8 + 1] & 0xFF) << 8 | this.m_propDataArray[recOffset + 8 + 0] & 0xFF) - 3;
            this.charTable.put(new Character((char)charCode), new int[]{charPosX, charPosY, charWidth, charHeight, charOffsetY});
        }
    }

    void Free() {
        if (this.m_propDataArray != null) {
            this.m_propDataArray = null;
        }
        if (this.m_pCustomFont >= 0) {
            this.m_g.asset_FreeFixedFont(this.m_pCustomFont);
        }
        this.m_pCustomFont = -1;
        this.m_SystemFont = null;
    }

    void SetColour(int r, int g, int b) {
        this.m_red = r;
        this.m_green = g;
        this.m_blue = b;
        if (this.m_pCustomFont >= 0) {
            this.FindBestColourMatch();
        }
    }

    void SetColour(int systemRGB) {
        this.m_red = systemRGB >> 16 & 0xFF;
        this.m_green = systemRGB >> 8 & 0xFF;
        this.m_blue = systemRGB & 0xFF;
        if (this.m_pCustomFont >= 0) {
            this.FindBestColourMatch();
        }
    }

    void FindBestColourMatch() {
        int pBestFixedFontColour = -1;
        int nBestDistance = Integer.MAX_VALUE;
        short pFixedFontColourArray = (short)((this.m_g.asset_DataArray[this.m_pCustomFont + 1] & 0xFFFF) >> 0);
        int nFixedFontColours = (this.m_g.asset_DataArray[pFixedFontColourArray + 0] & 0xFFFF0000) >> 16;
        for (int i = 0; i < nFixedFontColours; ++i) {
            int pFixedFontColour = this.m_g.asset_GetArrayElement(pFixedFontColourArray, i);
            short nRed = (short)((this.m_g.asset_DataArray[pFixedFontColour + 0] & 0xFFFF0000) >> 16);
            short nGreen = (short)((this.m_g.asset_DataArray[pFixedFontColour + 0] & 0xFFFF) >> 0);
            short nBlue = (short)((this.m_g.asset_DataArray[pFixedFontColour + 1] & 0xFFFF0000) >> 16);
            if (nRed > 255) {
                if (pBestFixedFontColour != -1) continue;
                pBestFixedFontColour = pFixedFontColour;
                continue;
            }
            int nDistance = (nRed - this.m_red) * (nRed - this.m_red) + (nGreen - this.m_green) * (nGreen - this.m_green) + (nBlue - this.m_blue) * (nBlue - this.m_blue);
            if (nDistance >= nBestDistance) continue;
            nBestDistance = nDistance;
            pBestFixedFontColour = pFixedFontColour;
        }
        this.m_pCustomFontColour = pBestFixedFontColour;
    }

    int GetHeight() {
        if (this.m_SystemFont != null) {
            return this.m_SystemFont.getHeight();
        }
        return (short)((this.m_g.asset_DataArray[this.m_pCustomFont + 0] & 0xFFFF) >> 0);
    }

    int GetSubstringWrappedHeight(String str, int nFirstChar, int nChars, int nWidth, int ySpacing) {
        int nStartOfLine = nFirstChar;
        int nLength = nFirstChar + nChars;
        int nHeight = 0;
        this.m_nMaxWidth = 0;
        while (true) {
            int nEndOfNextWord;
            int nLineWidth;
            if (nStartOfLine < nLength && str.charAt(nStartOfLine) == ' ') {
                ++nStartOfLine;
                continue;
            }
            if (nStartOfLine >= nLength) break;
            int nEndOfLine = this.m_g.system_FindFirst(str, nStartOfLine, nLength, ' ');
            while (nEndOfLine < nLength - 1 && (nLineWidth = this.GetSubstringWidth(str, nStartOfLine, (nEndOfNextWord = this.m_g.system_FindFirst(str, nEndOfLine + 1, nLength, ' ')) - nStartOfLine)) <= nWidth) {
                nEndOfLine = nEndOfNextWord;
            }
            while ((nLineWidth = this.GetSubstringWidth(str, nStartOfLine, nEndOfLine - nStartOfLine)) > nWidth) {
                --nEndOfLine;
            }
            if (this.m_nMaxWidth < nLineWidth) {
                this.m_nMaxWidth = nLineWidth;
            }
            nStartOfLine = nEndOfLine;
            nHeight += this.GetHeight() + ySpacing;
        }
        return nHeight;
    }

    int GetSubstringWrappedNumLines(String str, int nFirstChar, int nChars, int nWidth, int x, int y, int nAnchor, int ySpacing) {
        int nStartOfLine = nFirstChar;
        int nLength = nFirstChar + nChars;
        int nCurrentLine = 0;
        if ((nAnchor & 0xC) != 0) {
            int nHeight = this.GetSubstringWrappedHeight(str, nFirstChar, nChars, nWidth, ySpacing);
            if ((nAnchor & 4) != 0) {
                y -= nHeight >> 1;
            } else if ((nAnchor & 8) != 0) {
                y -= nHeight;
            }
            nAnchor = nAnchor & 3 | 0;
        }
        while (true) {
            int n;
            if (nStartOfLine < nLength && (str.charAt(nStartOfLine) == '\u0001' || str.charAt(nStartOfLine) == '\n')) {
                ++nStartOfLine;
            }
            while (nStartOfLine < nLength && str.charAt(nStartOfLine) == ' ') {
                ++nStartOfLine;
            }
            if (nStartOfLine >= nLength) break;
            int nEndOfLine = this.FindBreak(str, nStartOfLine, nLength);
            if (nEndOfLine + 1 < nLength && (str.charAt(n = nEndOfLine + 1) == '!' || str.charAt(n) == '.' || str.charAt(n) == '?')) {
                nEndOfLine = this.FindBreak(str, n, nLength);
            }
            while (nEndOfLine < nLength - 1 && str.charAt(nEndOfLine) != '\u0001' && str.charAt(nEndOfLine) != '\n') {
                int nLineWidth;
                int n2;
                int nEndOfNextWord = this.FindBreak(str, nEndOfLine + 1, nLength);
                if (nEndOfNextWord + 1 < nLength && (str.charAt(n2 = nEndOfNextWord + 1) == '!' || str.charAt(n2) == '.' || str.charAt(n2) == '?')) {
                    nEndOfNextWord = this.FindBreak(str, n2, nLength);
                }
                if ((nLineWidth = this.GetSubstringWidth(str, nStartOfLine, nEndOfNextWord - nStartOfLine)) > nWidth) break;
                nEndOfLine = nEndOfNextWord;
            }
            while (this.GetSubstringWidth(str, nStartOfLine, nEndOfLine - nStartOfLine) > nWidth) {
                --nEndOfLine;
            }
            for (int nLast = nEndOfLine; nLast >= nStartOfLine && str.charAt(nLast - 1) == ' '; --nLast) {
            }
            y += this.GetHeight() + ySpacing;
            ++nCurrentLine;
            nStartOfLine = nEndOfLine;
        }
        return nCurrentLine;
    }

    int GetSubstringWrappedWidth(String str, int nFirstChar, int nChars, int nWidth, int x, int y, int nAnchor, int ySpacing) {
        int nStartOfLine = nFirstChar;
        int nLength = nFirstChar + nChars;
        int nNumberOfLines = 0;
        int nMinWidth = 0;
        if ((nAnchor & 0xC) != 0) {
            int nHeight = this.GetSubstringWrappedHeight(str, nFirstChar, nChars, nWidth, ySpacing);
            if ((nAnchor & 4) != 0) {
                y -= nHeight >> 1;
            } else if ((nAnchor & 8) != 0) {
                y -= nHeight;
            }
            nAnchor = nAnchor & 3 | 0;
        }
        while (true) {
            int nLast;
            if (nStartOfLine < nLength && (str.charAt(nStartOfLine) == ' ' || str.charAt(nStartOfLine) == '}' || str.charAt(nStartOfLine) == '\u00a2')) {
                ++nStartOfLine;
                continue;
            }
            if (nStartOfLine >= nLength) break;
            int nEndOfLine = this.FindBreak(str, nStartOfLine, nLength);
            while (nEndOfLine < nLength - 1) {
                int nEndOfNextWord = this.m_g.system_FindFirst(str, nEndOfLine + 1, nLength, ' ');
                int nLineWidth = this.GetSubstringWidth(str, nStartOfLine, nEndOfNextWord - nStartOfLine);
                if (nMinWidth < nLineWidth) {
                    nMinWidth = nLineWidth;
                }
                if (nLineWidth > nWidth) break;
                nEndOfLine = nEndOfNextWord;
            }
            while (this.GetSubstringWidth(str, nStartOfLine, nEndOfLine - nStartOfLine) > nWidth) {
                --nEndOfLine;
                nMinWidth = nWidth;
            }
            for (nLast = nEndOfLine; nLast >= nStartOfLine && str.charAt(nLast - 1) == ' '; --nLast) {
            }
            if (nStartOfLine >= nLast) break;
            ++nNumberOfLines;
            nStartOfLine = nEndOfLine;
            y += this.GetHeight() + ySpacing;
        }
        if (nMinWidth == 0) {
            nMinWidth = this.GetSubstringWidth(str, nFirstChar, nChars);
        }
        return nMinWidth;
    }

    int FindBreak(String str, int startIdx, int length) {
        int t4;
        int t3;
        int t2;
        int t1 = this.m_g.system_FindFirst(str, startIdx, length, ' ');
        return t1 < ((t2 = this.m_g.system_FindFirst(str, startIdx, length, '\u0001')) < ((t3 = this.m_g.system_FindFirst(str, startIdx, length, '\n')) < (t4 = this.m_g.system_FindFirst(str, startIdx, length, '}')) ? t3 : t4) ? t2 : (t3 < t4 ? t3 : t4)) ? t1 : (t2 < (t3 < t4 ? t3 : t4) ? t2 : (t3 < t4 ? t3 : t4));
    }

    void DrawSubstringWrapped(String str, int nFirstChar, int nChars, int nWidth, int x, int y, int nAnchor, int ySpacing, int startLine, int endLine) {
        int nStartOfLine = nFirstChar;
        int nLength = nFirstChar + nChars;
        int nCurrentLine = 0;
        if ((nAnchor & 0xC) != 0) {
            int nHeight = this.GetSubstringWrappedHeight(str, nFirstChar, nChars, nWidth, ySpacing);
            if ((nAnchor & 4) != 0) {
                y -= nHeight >> 1;
            } else if ((nAnchor & 8) != 0) {
                y -= nHeight;
            }
            nAnchor = nAnchor & 3 | 0;
        }
        while (true) {
            int nLast;
            int n;
            if (nStartOfLine < nLength && (str.charAt(nStartOfLine) == '\u0001' || str.charAt(nStartOfLine) == '\n')) {
                ++nStartOfLine;
            }
            while (nStartOfLine < nLength && str.charAt(nStartOfLine) == ' ') {
                ++nStartOfLine;
            }
            if (nStartOfLine >= nLength) break;
            int nEndOfLine = this.FindBreak(str, nStartOfLine, nLength);
            if (nEndOfLine + 1 < nLength && (str.charAt(n = nEndOfLine + 1) == '!' || str.charAt(n) == '.' || str.charAt(n) == '?')) {
                nEndOfLine = this.FindBreak(str, n, nLength);
            }
            while (nEndOfLine < nLength - 1 && str.charAt(nEndOfLine) != '\u0001' && str.charAt(nEndOfLine) != '\n') {
                int nLineWidth;
                int n2;
                int nEndOfNextWord = this.FindBreak(str, nEndOfLine + 1, nLength);
                if (nEndOfNextWord + 1 < nLength && (str.charAt(n2 = nEndOfNextWord + 1) == '!' || str.charAt(n2) == '.' || str.charAt(n2) == '?')) {
                    nEndOfNextWord = this.FindBreak(str, n2, nLength);
                }
                if ((nLineWidth = this.GetSubstringWidth(str, nStartOfLine, nEndOfNextWord - nStartOfLine)) > nWidth) break;
                nEndOfLine = nEndOfNextWord;
            }
            while (this.GetSubstringWidth(str, nStartOfLine, nEndOfLine - nStartOfLine) > nWidth) {
                --nEndOfLine;
            }
            for (nLast = nEndOfLine; nLast >= nStartOfLine && str.charAt(nLast - 1) == ' '; --nLast) {
            }
            if (y + this.GetHeight() < 0) {
                y += this.GetHeight() + ySpacing;
            } else if (startLine == -1 || endLine == -1) {
                this.DrawSubstring(str, nStartOfLine, nLast - nStartOfLine, x, y, nAnchor);
                y += this.GetHeight() + ySpacing;
            } else if (nCurrentLine >= startLine && nCurrentLine <= endLine) {
                this.DrawSubstring(str, nStartOfLine, nLast - nStartOfLine, x, y, nAnchor);
                y += this.GetHeight() + ySpacing;
            }
            if (++nCurrentLine > endLine && endLine != -1 || y > this.m_g.system_nCanvasHeight) break;
            nStartOfLine = nEndOfLine;
        }
    }

    void DrawSubstringCustom(int pFixedFont, int pFixedFontColour, String str, int nFirstChar, int nChars, int x, int y) {
        short nFontHeight = (short)((this.m_g.asset_DataArray[pFixedFont + 0] & 0xFFFF) >> 0);
        short pImage = (short)((this.m_g.asset_DataArray[pFixedFontColour + 1] & 0xFFFF) >> 0);
        short xOffset = (short)((this.m_g.asset_DataArray[pImage + 0] & 0xFFFF0000) >> 16);
        int yOffset = (short)((this.m_g.asset_DataArray[pImage + 0] & 0xFFFF) >> 0) - (short)((this.m_g.asset_DataArray[pImage + 3] & 0xFFFF0000) >> 16);
        short pCombined = (short)((this.m_g.asset_DataArray[pImage + 2] & 0xFFFF0000) >> 16);
        short nID = (short)((this.m_g.asset_DataArray[pCombined + 0] & 0xFFFF0000) >> 16);
        int nEnd = nFirstChar + nChars;
        for (int i = nFirstChar; i < nEnd; ++i) {
            char c = str.charAt(i);
            if (c == ' ') {
                x += 3;
                continue;
            }
            Character cObj = new Character(c);
            if (this.charTable.containsKey(cObj)) {
                int[] coord = (int[])this.charTable.get(cObj);
                this.m_g.asset_DrawClipped(nID, x - coord[0], y - coord[1] + coord[4], x, y + coord[4], coord[2], coord[3], true, false);
                x += coord[2];
                continue;
            }
            TheGame.m_CurrentGraphics.setColor(0xFF0000);
            TheGame.m_CurrentGraphics.fillRect(x, y, 10, 10);
            x += 10;
        }
    }

    int GetSubstringWidth(String str, int nFirstChar, int nChars) {
        if (this.m_SystemFont != null) {
            return this.m_SystemFont.substringWidth(str, nFirstChar, nChars);
        }
        int w = 0;
        int start = nFirstChar;
        int end = nFirstChar + nChars;
        for (int i = start; i < end; ++i) {
            char c = str.charAt(i);
            if (c == ' ') {
                w += 3;
                continue;
            }
            Character cObj = new Character(c);
            if (!this.charTable.containsKey(cObj)) continue;
            int[] coord = (int[])this.charTable.get(cObj);
            w += coord[2];
        }
        return w;
    }

    void DrawSubstring(String str, int nFirstChar, int nChars, int x, int y, int nAnchor) {
        int nWidth = this.GetSubstringWidth(str, nFirstChar, nChars);
        int nHeight = this.GetHeight();
        if ((nAnchor & 1) != 0) {
            x -= nWidth >> 1;
        } else if ((nAnchor & 2) != 0) {
            x -= nWidth;
        }
        if ((nAnchor & 4) != 0) {
            y -= nHeight >> 1;
        } else if ((nAnchor & 8) != 0) {
            y -= nHeight;
        }
        if (this.m_SystemFont != null) {
            TheGame.m_CurrentGraphics.setFont(this.m_SystemFont);
            TheGame.m_CurrentGraphics.setClip(this.m_g.system_xClip, this.m_g.system_yClip, this.m_g.system_nClipWidth, this.m_g.system_nClipHeight);
            TheGame.m_CurrentGraphics.setColor(this.m_red, this.m_green, this.m_blue);
            TheGame.m_CurrentGraphics.drawSubstring(str, nFirstChar, nChars, x, y, 20);
        } else {
            this.DrawSubstringCustom(this.m_pCustomFont, this.m_pCustomFontColour, str, nFirstChar, nChars, x, y);
        }
    }
}

