/*
 * Decompiled with CFR 0.152.
 */
class GameObject {
    TheGame m_g;
    final Variables variables = new Variables();
    byte m_type;
    byte m_id;
    boolean m_active;
    int m_x;
    int m_y;
    int m_sortY;
    int m_dx;
    int m_dy;
    int m_size;
    int m_animFrame;
    short m_cxBoundingBox;
    short m_cyBoundingBox;
    short m_spawnpt;
    int m_pathStartIndex;
    int m_pathCurrentIndex;
    int m_pathEndIndex;
    boolean m_pathLoopToStart;
    boolean m_pathLoopingForward;
    int m_wobbleTimer;
    int m_lastWobble;
    boolean m_bAnimating;

    public void SetGlobal(TheGame pGlobal) {
        this.m_g = pGlobal;
    }

    void SetBoundingBox(int cx, int cy) {
        this.m_cxBoundingBox = (short)cx;
        this.m_cyBoundingBox = (short)cy;
    }

    void Construct() {
        this.m_type = 0;
        this.m_active = false;
        this.m_wobbleTimer = 0;
    }

    void Init(int objType, int id, int damage, int xx, int yy) {
        this.m_type = (byte)objType;
        this.m_id = (byte)id;
        this.m_x = xx << 8;
        this.m_y = yy << 8;
        this.m_active = true;
        this.m_pathEndIndex = -1;
        this.m_pathCurrentIndex = -1;
        this.m_pathStartIndex = -1;
        short imgID = this.m_g.game_pPickupTypes[this.m_type - 1][1];
        short width = this.m_g.game_pPickupImageSize[imgID][0];
        short height = this.m_g.game_pPickupImageSize[imgID][1];
        this.m_size = height + width << 8 >> 2;
        this.m_y -= height << 8 >> 1;
        this.m_sortY = this.m_y;
        if ((this.m_g.game_pPickupTypes[this.m_type - 1][0] & 0x80) != 0) {
            this.m_sortY = -this.m_sortY;
        }
        this.m_spawnpt = (short)-1;
        this.m_animFrame = 0;
        this.SetBoundingBox(width, height);
        this.m_g.game_bResortObjs = true;
        this.m_bAnimating = true;
    }

    void Draw() {
        int x = (this.m_x >> 8) - (this.m_g.scroller_xMap >> 8);
        int y = (this.m_y >> 8) - (this.m_g.scroller_yMap >> 8);
        if (this.m_wobbleTimer > 0 && this.m_wobbleTimer < this.m_lastWobble - 200) {
            int wobbleAmount = this.m_lastWobble / 500;
            x = this.m_wobbleTimer % 2 == 0 ? (x -= wobbleAmount) : (x += wobbleAmount);
            this.m_lastWobble = this.m_wobbleTimer;
        }
        short imgID = this.m_g.game_pPickupTypes[this.m_type - 1][1 + this.m_animFrame];
        if (this.m_dx < 0) {
            boolean bDraw = false;
            int i = 0;
            while (true) {
                if (i >= Variables.flippedLen * 2) break;
                if (this.m_g.currMapID == Variables.movingObjects[i]) {
                    if (this.m_type == Variables.movingObjects[i + 1]) {
                        bDraw = true;
                        this.m_g.game_drawPickupImgRotated(imgID, x, y, 2);
                        break;
                    }
                }
                i += 2;
            }
            if (!bDraw) {
                this.m_g.game_drawPickupImgCentered(imgID, x, y);
            }
        } else {
            this.m_g.game_drawPickupImgCentered(imgID, x, y);
        }
    }

    void Update(int nDT) throws Exception {
        short flags;
        short img = this.m_g.game_pPickupTypes[this.m_type - 1][1];
        if (!this.m_g.game_CheckOnScreen(img, this.m_x, this.m_y)) {
            short entityTag = TheGame.game_map_entities[this.m_spawnpt][2];
            this.m_g.game_DespawnEntity(this, entityTag != 0);
            return;
        }
        if (this.m_bAnimating) {
            ++this.m_animFrame;
            if (this.m_animFrame >= 4 || this.m_g.game_pPickupTypes[this.m_type - 1][1 + this.m_animFrame] < 0) {
                this.m_animFrame = 0;
            }
        }
        if (((flags = this.m_g.game_pPickupTypes[this.m_type - 1][0]) & 1) != 0) {
            this.chase_Update(nDT);
        } else {
            this.pickup_Update(nDT);
        }
    }

    void chase_Update(int nDT) throws Exception {
        this.m_bAnimating = false;
        int home_x = TheGame.game_map_vertices[TheGame.game_map_entities[this.m_spawnpt][0]][0] << 8;
        int home_y = TheGame.game_map_vertices[TheGame.game_map_entities[this.m_spawnpt][0]][1] << 8;
        Vec3 diff = new Vec3(this.m_g);
        diff.val[0] = home_x;
        diff.val[1] = home_y;
        diff.val[2] = -256;
        diff.val[0] = diff.val[0] - this.m_g.game_worldPos.val[0];
        diff.val[1] = diff.val[1] - this.m_g.game_worldPos.val[1];
        diff.val[2] = diff.val[2] - this.m_g.game_worldPos.val[2];
        int r = 24576;
        if (Math.abs(diff.val[0]) < r && Math.abs(diff.val[1]) < r && Math.abs(diff.val[2]) < r) {
            diff.val[0] = this.m_x;
            diff.val[1] = this.m_y;
            diff.val[2] = -256;
            diff.val[0] = diff.val[0] - this.m_g.game_worldPos.val[0];
            diff.val[1] = diff.val[1] - this.m_g.game_worldPos.val[1];
            diff.val[2] = diff.val[2] - this.m_g.game_worldPos.val[2];
            int mag = diff.mag();
            if (mag < this.m_g.game_kataScreenSize + (this.m_size >> 1)) {
                if (this.m_size < this.m_g.game_kataScreenSize >> 1) {
                    int img = this.m_type - 1;
                    this.m_g.game_AddObj(diff, img, this.m_size, 0);
                    this.m_g.game_lastPickupTime = this.m_g.game_Time;
                    this.m_g.game_lastPickupImg = img;
                    this.m_active = false;
                } else {
                    diff.normalise();
                    this.m_g.game_worldImpulse.val[0] = this.m_g.game_worldImpulse.val[0] - (diff.val[0] * (this.m_g.game_kataScreenSize >> 8) >> 1);
                    this.m_g.game_worldImpulse.val[1] = this.m_g.game_worldImpulse.val[1] - (diff.val[1] * (this.m_g.game_kataScreenSize >> 8) >> 1);
                }
            } else if (this.m_size > this.m_g.game_kataScreenSize >> 1) {
                diff.normalise();
                this.m_x -= 5 * (nDT * (diff.val[0] >> 2)) >> 5;
                this.m_y -= 5 * (nDT * (diff.val[1] >> 2)) >> 5;
                this.m_bAnimating = true;
            }
        } else {
            Vec3 vecHome = new Vec3(this.m_g);
            vecHome.val[0] = home_x - this.m_x;
            vecHome.val[1] = home_y - this.m_y;
            if (Math.abs(vecHome.val[0]) > 256 && Math.abs(vecHome.val[1]) > 256) {
                int length = Math.abs(home_x) > Math.abs(home_y) ? home_x + (home_y >> 1) : home_y + (home_x >> 1);
                length = Math.abs(length >> 8);
                this.m_x += vecHome.val[0] * nDT / length;
                this.m_y += vecHome.val[1] * nDT / length;
                this.m_bAnimating = true;
            }
        }
    }

    void pickup_Update(int nDT) throws Exception {
        short entityTag;
        int mag;
        this.m_wobbleTimer -= nDT;
        Vec3 diff = new Vec3(this.m_g);
        diff.val[0] = this.m_x;
        diff.val[1] = this.m_y;
        diff.val[2] = -256;
        diff.val[0] = diff.val[0] - this.m_g.game_worldPos.val[0];
        diff.val[1] = diff.val[1] - this.m_g.game_worldPos.val[1];
        diff.val[2] = diff.val[2] - this.m_g.game_worldPos.val[2];
        int r = this.m_g.game_kataScreenSize + (this.m_size >> 1);
        if (Math.abs(diff.val[0]) < r && Math.abs(diff.val[1]) < r && Math.abs(diff.val[2]) < r && (mag = diff.mag()) < r) {
            boolean pickup = true;
            short f = this.m_g.game_pPickupTypes[this.m_type - 1][0];
            if (this.m_g.game_mode == 4 && (f & 0x40) != 0) {
                this.m_g.game_score = -1;
            }
            int kataSize = this.m_g.game_kataScreenSize >> 1;
            if (this.m_g.game_currentLevel == 30) {
                kataSize *= 2;
            }
            if (this.m_size < kataSize) {
                if (this.m_g.game_mode == 1) {
                    int goalObj = 8;
                    int goalObj2 = this.variables.game_levelData[this.m_g.game_currentLevel][6];
                    int goalFlag = goalObj | goalObj2;
                    if (this.m_g.game_currentLevel == 15) {
                        if ((f & goalFlag) == (goalFlag & 0xFFFFFDFF)) {
                            ++this.m_g.game_score;
                        }
                    } else if ((goalFlag & 0x200) != 0) {
                        if ((f & 0x200) != 0) {
                            int objSize = f >> 10;
                            int lastObjSize = this.m_g.game_score >> 10;
                            if (Math.abs(f >> 10) > Math.abs(this.m_g.game_score >> 10)) {
                                this.m_g.game_biggestCowBearId = this.m_type - 1;
                            }
                            this.m_g.game_score |= f;
                        }
                    } else if ((f & goalFlag) == goalFlag) {
                        ++this.m_g.game_score;
                    }
                } else if (this.m_g.game_mode == 3) {
                    if ((f & 4) != 0) {
                        int checkpointID = f >> 10;
                        if (this.m_g.game_score == checkpointID) {
                            this.m_g.game_score <<= 1;
                        } else {
                            diff.normalise();
                            this.m_g.game_worldImpulse.val[0] = this.m_g.game_worldImpulse.val[0] - diff.val[0] * (this.m_g.game_kataScreenSize >> 8 >> 2);
                            this.m_g.game_worldImpulse.val[1] = this.m_g.game_worldImpulse.val[1] - diff.val[1] * (this.m_g.game_kataScreenSize >> 8 >> 2);
                            pickup = false;
                        }
                    }
                } else if (this.m_g.game_mode == 2) {
                    short tag = TheGame.game_map_entities[this.m_spawnpt][2];
                    if (tag > 0) {
                        short s = tag;
                        this.m_g.game_pairs[s] = (char)(this.m_g.game_pairs[s] + '\u0001');
                        if (this.m_g.game_pairs[tag] > '\u0001') {
                            ++this.m_g.game_score;
                        }
                    }
                }
                if (pickup) {
                    int img = this.m_type - 1;
                    this.m_g.game_AddObj(diff, img, this.m_size, f);
                    if ((f & 0x10) != 0) {
                        int text;
                        int cousin = this.variables.game_levelData[this.m_g.game_currentLevel][7];
                        this.m_g.game_rewards |= cousin;
                        this.m_g.reward_order = cousin;
                        switch (cousin) {
                            case 4: {
                                text = 202;
                                break;
                            }
                            case 1: {
                                text = 201;
                                break;
                            }
                            default: {
                                text = 203;
                            }
                        }
                        this.m_g.TriggerKingSpeech(this.m_g.m_gameText.m_Text[text], 5, this.m_g.system_nCanvasHeight >> 1, this.m_g.system_nCanvasWidth - 10);
                        this.m_g.game_timedPause = 1000;
                    } else if ((f & 0x20) != 0) {
                        if ((f & 0x200) != 0) {
                            this.m_g.game_unlockedCutscenes |= 0xF0000000;
                            this.m_g.TriggerKingSpeech(this.m_g.m_gameText.m_Text[204], 5, this.m_g.system_nCanvasHeight >> 1, this.m_g.system_nCanvasWidth - 10);
                        } else {
                            this.m_g.game_rewards |= this.variables.game_levelData[this.m_g.game_currentLevel][7];
                            this.m_g.TriggerKingSpeech(this.m_g.m_gameText.m_Text[200], 5, this.m_g.system_nCanvasHeight >> 1, this.m_g.system_nCanvasWidth - 10);
                        }
                        this.m_g.game_timedPause = 1000;
                    }
                    this.m_g.game_lastPickupTime = this.m_g.game_Time;
                    this.m_g.game_lastPickupImg = img;
                    this.m_active = false;
                }
            } else {
                if ((f & 0x100) == 0) {
                    diff.normalise();
                    if (TheGame.game_map_entities[this.m_spawnpt][2] == 0) {
                        this.m_g.game_worldImpulse.val[0] = this.m_g.game_worldImpulse.val[0] - diff.val[0] * (this.m_g.game_kataScreenSize >> 8 >> 2);
                        this.m_g.game_worldImpulse.val[1] = this.m_g.game_worldImpulse.val[1] - diff.val[1] * (this.m_g.game_kataScreenSize >> 8 >> 2);
                    } else {
                        this.m_g.game_worldImpulse.val[0] = this.m_g.game_worldImpulse.val[0] - diff.val[0] * (this.m_g.game_kataScreenSize >> 8 >> 2);
                        this.m_g.game_worldImpulse.val[1] = this.m_g.game_worldImpulse.val[1] - diff.val[1] * (this.m_g.game_kataScreenSize >> 8 >> 2);
                    }
                    this.m_g.system_StartVibrate(50);
                }
                if (this.m_size < 3 * (this.m_g.game_kataScreenSize >> 2)) {
                    this.m_wobbleTimer = 1500;
                    this.m_lastWobble = this.m_wobbleTimer + 200;
                }
            }
        }
        if ((entityTag = TheGame.game_map_entities[this.m_spawnpt][2]) != 0 && this.m_g.game_mode != 2) {
            if (this.m_pathCurrentIndex > this.m_pathEndIndex) {
                if (this.m_pathLoopToStart) {
                    this.m_pathCurrentIndex = this.m_pathStartIndex;
                } else {
                    this.m_pathLoopingForward = false;
                    this.m_pathCurrentIndex = this.m_pathEndIndex;
                }
            }
            if (this.m_pathCurrentIndex < this.m_pathStartIndex) {
                this.m_pathLoopingForward = true;
                this.m_pathCurrentIndex = this.m_pathStartIndex;
            }
            int p1x = this.m_x >> 8;
            int p1y = this.m_y >> 8;
            short nextVert = this.m_pathLoopingForward ? TheGame.game_map_lines[this.m_pathCurrentIndex][1] : TheGame.game_map_lines[this.m_pathCurrentIndex][0];
            short p2x = TheGame.game_map_vertices[nextVert][0];
            short p2y = TheGame.game_map_vertices[nextVert][1];
            int pathx = p2x - p1x;
            int pathy = p2y - p1y;
            int length = Math.abs(pathx) > Math.abs(pathy) ? pathx + (pathy >> 1) : pathy + (pathx >> 1);
            length = Math.abs(length);
            if (length <= 1) {
                this.m_x = p2x << 8;
                this.m_y = p2y << 8;
                this.m_pathCurrentIndex = this.m_pathLoopingForward ? ++this.m_pathCurrentIndex : --this.m_pathCurrentIndex;
                return;
            }
            int speedShift = 5;
            if (this.m_g.game_resized) {
                speedShift += 2;
            }
            short f = this.m_g.game_pPickupTypes[this.m_type - 1][0];
            if (this.m_g.game_mode == 4 && (f & 0x40) != 0) {
                ++speedShift;
            }
            if (speedShift < 1) {
                speedShift = 1;
            }
            int dx = (pathx << 8) / length * nDT;
            int dy = (pathy << 8) / length * nDT;
            this.m_dx = dx;
            this.m_dy = dy;
            this.m_x += dx >> speedShift;
            this.m_y += dy >> speedShift;
        }
    }

    public GameObject(TheGame pGlobal) {
        this.m_g = pGlobal;
    }
}

