/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CSprite
extends CControl {
    short imgIndex = (short)-1;
    byte flip;
    byte transitionProgress = 0;
    byte transitionType = 0;
    short spriteIndex;
    Image img;
    int[] rgbData;
    byte opacity;
    static final int NO_SPRITE = -1;

    public CSprite() {
        super(new CRect(0, 0, 0, 0));
        this.imgIndex = (short)-1;
        this.spriteIndex = (short)-1;
        this.zDepth = 0;
        this.type = (byte)3;
    }

    public CSprite(short left, short top, int img, byte z) {
        super(new CRect(left, top, left + CResManager.images[CResManager.getSpriteImageId(img)].getWidth(), top + CResManager.images[CResManager.getSpriteImageId(img)].getHeight()));
        try {
            this.zDepth = z;
            this.imgIndex = (short)CResManager.getSpriteImageId(img);
            this.spriteIndex = (short)CResManager.getSpriteId(img);
            if (this.spriteIndex == 0) {
                this.spriteIndex = (short)-1;
            } else {
                this.spriteIndex = (short)(this.spriteIndex - 1);
                this.bounds.resize(CResManager.getSpriteWidth(this.imgIndex, this.spriteIndex), CResManager.getSpriteHeight(this.imgIndex, this.spriteIndex));
            }
            this.opacity = (byte)-1;
            this.type = (byte)3;
        }
        catch (Exception e) {
            CDebug.show("iar lipseste ceva " + this.imgIndex);
        }
    }

    public CSprite(short left, short right, short top, int img, byte z) {
        super(new CRect(left, top, left + CResManager.images[CResManager.getSpriteImageId(img)].getWidth(), top + CResManager.images[CResManager.getSpriteImageId(img)].getHeight()));
        this.zDepth = z;
        this.imgIndex = (short)CResManager.getSpriteImageId(img);
        this.spriteIndex = (short)CResManager.getSpriteId(img);
        if (this.spriteIndex == 0) {
            this.spriteIndex = (short)-1;
        } else {
            this.spriteIndex = (short)(this.spriteIndex - 1);
            this.bounds.resize(CResManager.getSpriteWidth(this.imgIndex, this.spriteIndex), CResManager.getSpriteHeight(this.imgIndex, this.spriteIndex));
            this.bounds.moveTo(right - this.bounds.getWidth(), this.bounds.top);
        }
        this.opacity = (byte)-1;
        this.type = (byte)3;
    }

    public CSprite(short left, short top, int img, byte opacity, byte z) {
        super(new CRect(left, top, left + CResManager.images[CResManager.getSpriteImageId(img)].getWidth(), top + CResManager.images[CResManager.getSpriteImageId(img)].getHeight()));
        this.zDepth = z;
        this.imgIndex = (short)CResManager.getSpriteImageId(img);
        this.spriteIndex = (short)CResManager.getSpriteId(img);
        if (this.spriteIndex == 0) {
            this.spriteIndex = (short)-1;
        } else {
            this.spriteIndex = (short)(this.spriteIndex - 1);
            this.bounds.resize(CResManager.getSpriteWidth(this.imgIndex, this.spriteIndex), CResManager.getSpriteHeight(this.imgIndex, this.spriteIndex));
        }
        this.getRgbData();
        this.changeOpacity(opacity);
        this.type = (byte)3;
    }

    public CSprite(short left, short top, Image img, byte opacity, byte z) {
        super(new CRect(left, top, left + img.getWidth(), top + img.getHeight()));
        this.zDepth = z;
        this.imgIndex = (short)-1;
        this.spriteIndex = (short)-1;
        this.img = img;
        this.getRgbData();
        this.changeOpacity(opacity);
        this.type = (byte)3;
    }

    public final void changeProps(short left, short top, int img, byte z) {
        this.bounds = new CRect(left, top, left + CResManager.images[CResManager.getSpriteImageId(img)].getWidth(), top + CResManager.images[CResManager.getSpriteImageId(img)].getHeight());
        this.zDepth = z;
        this.imgIndex = (short)CResManager.getSpriteImageId(img);
        this.spriteIndex = (short)CResManager.getSpriteId(img);
        if (this.spriteIndex == 0) {
            this.spriteIndex = (short)-1;
        } else {
            this.spriteIndex = (short)(this.spriteIndex - 1);
            this.bounds.resize(CResManager.getSpriteWidth(this.imgIndex, this.spriteIndex), CResManager.getSpriteHeight(this.imgIndex, this.spriteIndex));
        }
        this.opacity = (byte)-1;
        this.type = (byte)3;
    }

    public final void changeProps(short left, short top, int img, byte opacity, byte z) {
        this.bounds = new CRect(left, top, left + CResManager.images[CResManager.getSpriteImageId(img)].getWidth(), top + CResManager.images[CResManager.getSpriteImageId(img)].getHeight());
        this.zDepth = z;
        this.imgIndex = (short)CResManager.getSpriteImageId(img);
        this.spriteIndex = (short)CResManager.getSpriteId(img);
        if (this.spriteIndex == 0) {
            this.spriteIndex = (short)-1;
        } else {
            this.spriteIndex = (short)(this.spriteIndex - 1);
            this.bounds.resize(CResManager.getSpriteWidth(this.imgIndex, this.spriteIndex), CResManager.getSpriteHeight(this.imgIndex, this.spriteIndex));
        }
        this.getRgbData();
        this.changeOpacity(opacity);
        this.type = (byte)3;
    }

    public final void changeOpacity(byte opacity) {
        if (this.opacity == opacity) {
            return;
        }
        if (this.rgbData == null && opacity != -1) {
            this.getRgbData();
        }
        this.opacity = opacity;
        if (opacity == -1 && this.rgbData != null) {
            this.rgbData = null;
            this.needsRepaint = true;
            this.notifyParent((byte)30);
            return;
        }
        for (int i = 0; i < this.rgbData.length; ++i) {
            if (this.rgbData[i] == 0xFF00FF) continue;
            this.rgbData[i] = this.rgbData[i] & 0xFFFFFF | (opacity & 0xFF) << 24;
        }
        this.needsRepaint = true;
        this.notifyParent((byte)30);
    }

    private final void getRgbData() {
        if (this.imgIndex > -1) {
            this.rgbData = new int[CResManager.rgbData[this.imgIndex].length];
            System.arraycopy(CResManager.rgbData[this.imgIndex], 0, this.rgbData, 0, this.rgbData.length);
        } else {
            this.rgbData = new int[this.img.getWidth() * this.img.getHeight()];
            this.img.getRGB(this.rgbData, 0, this.img.getWidth(), 0, 0, this.img.getWidth(), this.img.getHeight());
        }
        this.opacity = (byte)-1;
    }

    public final void processEvent(byte event) {
        this.needsRepaint = true;
    }

    public final void updateBounds() {
        CRect old = new CRect(this.bounds);
        this.bounds.resize(CResManager.images[this.imgIndex].getWidth(), CResManager.images[this.imgIndex].getHeight());
        this.bounds.center(old, false);
    }

    public final void changeSprite(short img, short spriteIn) {
        if (this.imgIndex == img && this.spriteIndex == spriteIn) {
            return;
        }
        CRect r = new CRect(this.bounds);
        this.imgIndex = img;
        this.spriteIndex = spriteIn;
        this.opacity = (byte)-1;
        this.rgbData = null;
        this.needsRepaint = true;
        this.notifyParent((byte)30);
        if (this.spriteIndex != -1) {
            this.bounds.resize(CResManager.getSpriteWidth(this.imgIndex, this.spriteIndex), CResManager.getSpriteHeight(this.imgIndex, this.spriteIndex));
        } else {
            this.bounds.resize(CResManager.images[this.imgIndex].getWidth(), CResManager.images[this.imgIndex].getHeight());
        }
        this.bounds.center(r, false);
    }

    public void changeSprite(int image) {
        short imgIndex = (short)CResManager.getSpriteImageId(image);
        short spriteIndex = (short)CResManager.getSpriteId(image);
        spriteIndex = spriteIndex == 0 ? (short)-1 : (short)((short)(spriteIndex - 1));
        this.changeSprite(imgIndex, spriteIndex);
    }

    public final void paint(Graphics g, CRect forcedClip) {
        if (!this.isVisible) {
            return;
        }
        if (forcedClip == null) {
            g.setClip(this.bounds.left, this.bounds.top, this.bounds.getWidth(), this.bounds.getHeight());
        } else {
            g.setClip(this.bounds.left, this.bounds.top, this.bounds.getWidth(), this.bounds.getHeight());
            g.clipRect(forcedClip.left, forcedClip.top, forcedClip.getWidth(), forcedClip.getHeight());
        }
        if (this.transitionType != 0 && this.transitionProgress < 100) {
            switch (this.transitionType) {
                case 1: {
                    int sw = CResManager.images[this.imgIndex].getWidth() / 8;
                    int sh = CResManager.images[this.imgIndex].getHeight() / 4;
                    int aw = (sw >> 1) * (100 - this.transitionProgress) / 100;
                    int ah = (sh >> 1) * (100 - this.transitionProgress) / 100;
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            g.drawRegion(CResManager.images[this.imgIndex], i * sw + aw, j * sh + ah, sw - (aw << 1), sh - (ah << 1), 0, this.bounds.left + i * sw + aw, this.bounds.top + j * sh + ah, 20);
                        }
                    }
                    break;
                }
            }
            return;
        }
        if (this.spriteIndex == -1) {
            this.drawImage(g, this.bounds.left, this.bounds.top, 0);
        } else {
            byte[] spriteData = CResManager.spriteData[this.imgIndex][this.spriteIndex];
            int tileNr = spriteData[0];
            int offset = 32;
            CRect oldClip = new CRect(g);
            block11: for (int t = 0; t < tileNr; ++t) {
                int sLeft = Bitwise.read(10, spriteData, offset);
                int sTop = Bitwise.read(10, spriteData, offset += 10);
                int sRight = Bitwise.read(10, spriteData, offset += 10);
                int sBottom = Bitwise.read(10, spriteData, offset += 10);
                int sRelLeft = Bitwise.read(10, spriteData, offset += 10);
                int sRelTop = Bitwise.read(10, spriteData, offset += 10);
                int sTrans = Bitwise.read(4, spriteData, offset += 10);
                offset += 4;
                oldClip.setClipRect(g);
                g.clipRect(this.bounds.left + sRelLeft, this.bounds.top + sRelTop, sRight - sLeft + 1, sBottom - sTop + 1);
                switch (CResManager.getSpriteTrans(sTrans)) {
                    case 0: {
                        this.drawImage(g, this.bounds.left + sRelLeft - sLeft, this.bounds.top + sRelTop - sTop, sTrans);
                        continue block11;
                    }
                    case 2: {
                        int left = this.bounds.left + sRelLeft - (CResManager.images[this.imgIndex].getWidth() - sLeft - (sRight - sLeft + 1));
                        this.drawImage(g, left, this.bounds.top + sRelTop - sTop, sTrans);
                        continue block11;
                    }
                    case 1: {
                        int top = this.bounds.top + sRelTop - (CResManager.images[this.imgIndex].getHeight() - sTop - (sBottom - sTop + 1));
                        this.drawImage(g, this.bounds.left + sRelLeft - sLeft, top, sTrans);
                        continue block11;
                    }
                    case 3: {
                        int top = this.bounds.top + sRelTop - (CResManager.images[this.imgIndex].getHeight() - sTop - (sBottom - sTop + 1));
                        int left = this.bounds.left + sRelLeft - (CResManager.images[this.imgIndex].getWidth() - sLeft - (sRight - sLeft + 1));
                        this.drawImage(g, left, top, sTrans);
                        continue block11;
                    }
                    default: {
                        this.drawImage(g, this.bounds.left + sRelLeft - sLeft, this.bounds.top + sRelTop - sTop, sTrans);
                    }
                }
            }
        }
    }

    private void drawImage(Graphics g, int left, int top, int trans) {
        if (g.getClipWidth() == 0 || g.getClipHeight() == 0) {
            return;
        }
        if (CResManager.images[this.imgIndex] == null) {
            CResManager.loadImage(this.imgIndex, false, null);
        }
        if (this.rgbData == null) {
            g.drawRegion(CResManager.images[this.imgIndex], 0, 0, CResManager.images[this.imgIndex].getWidth(), CResManager.images[this.imgIndex].getHeight(), CResManager.getSpriteTrans(trans), left, top, 20);
        } else if (this.imgIndex > -1) {
            g.drawRGB(this.rgbData, 0, CResManager.images[this.imgIndex].getWidth(), left, top, CResManager.images[this.imgIndex].getWidth(), CResManager.images[this.imgIndex].getHeight(), true);
        } else {
            g.drawRGB(this.rgbData, 0, this.img.getWidth(), left, top, this.img.getWidth(), this.img.getHeight(), true);
        }
    }

    public final String toString() {
        return "adr: " + this.hashCode() + "; type: " + this.getClass() + "; img: " + this.imgIndex + "; sprite: " + this.spriteIndex + "; opacity: " + this.opacity + "; rgbData: " + this.rgbData + "; bounds: " + this.bounds;
    }
}

