/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class CSoundManager
implements PlayerListener {
    static Player player = null;
    static int currentSound = -1;
    static int currentLoop = 0;
    static int lastPlayedSound = -1;
    public static CMIDIvol[] mids = new CMIDIvol[13];
    public static int[] volVal;
    static byte volIndex;
    static int lastVolIndex;
    static CSoundManager _this;

    public CSoundManager() {
        _this = this;
    }

    public static void initVolumeValues() {
        int[] vals = new int[]{0, 20, 45, 65};
        volVal = vals;
    }

    public static void changeVolumes(int vol) {
        for (int i = 0; i < 13; ++i) {
            if (mids[i] == null) continue;
            mids[i].writeMidWithVolume(vol);
        }
    }

    public static void changeVolume(int snd, int vol) {
        if (mids[snd] != null) {
            CDebug.show("VOLUME for snd " + snd + " changed to " + vol);
            mids[snd].writeMidWithVolume(vol);
        }
    }

    public static void initPlayers() {
        for (int i = 0; i < 13; ++i) {
            CSoundManager.mids[i] = new CMIDIvol(CResManager.getData((byte)1, i));
            CMIDIvol cfr_ignored_0 = mids[i];
            CSoundManager.mids[i].volMAX = 127;
            CMIDIvol cfr_ignored_1 = mids[i];
            CSoundManager.mids[i].volMIN = 127;
        }
    }

    public static void playDummyTone() {
        try {
            Manager.playTone((int)50, (int)50, (int)20);
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized void playSound(int s, int loopCount) {
        if (CFlags.isInTransition) {
            CFlags.soundAfterTransition = s;
            currentSound = s;
            currentLoop = loopCount;
            return;
        }
        if (volIndex == 0 || s < 0 || s == lastPlayedSound && player != null && player.getState() == 400) {
            currentSound = s;
            currentLoop = loopCount;
            return;
        }
        try {
            CSoundManager.stopSound();
            currentSound = s;
            currentLoop = loopCount;
            player = Manager.createPlayer((InputStream)mids[s].prepareMidOutputForPlayer(), (String)"audio/midi");
            player.realize();
            player.prefetch();
            player.addPlayerListener((PlayerListener)_this);
            VolumeControl vc = (VolumeControl)player.getControl("VolumeControl");
            vc.setLevel(volVal[volIndex]);
            if (!CFlags.isNokiaN70) {
                player.setLoopCount(loopCount);
            }
            player.start();
            if (CFlags.isNokiaN70) {
                Thread.sleep(50L);
            } else if (CFlags.isNokiaN91) {
                for (int count = 500; count > 0 && player.getState() != 400; --count) {
                    player.start();
                }
            }
            lastPlayedSound = s;
        }
        catch (Exception e) {
            CDebug.setDebug("playSound . " + e.toString());
            e.printStackTrace();
        }
    }

    public static synchronized void stopSound() {
        block6: {
            currentLoop = 0;
            currentSound = -1;
            if (volIndex == 0) {
                return;
            }
            try {
                if (player == null) break block6;
                if (player.getState() == 400) {
                    player.stop();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                player.deallocate();
                player.close();
                player = null;
                currentLoop = 0;
                currentSound = -1;
            }
            catch (Exception e) {
                CDebug.setDebug("stopSound . " + e.toString());
                e.printStackTrace();
            }
        }
    }

    public void playerUpdate(Player p, String s, Object o) {
        if (s == "endOfMedia" && CFlags.isNokiaN70 && currentLoop == -1) {
            CSoundManager.playSound(currentSound, currentLoop);
        }
    }

    static {
        volIndex = (byte)2;
    }
}

