/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CMIDIvol {
    public static final int MIDI_MAX_VOL = 127;
    public static final int MIDI_MIN_VOL = 0;
    public static final int MIDI_CONTROLLER_ID = 176;
    public static final byte MIDI_VOLUME_CONTROLLER = 7;
    public static final int MAX_NO_TRACKS = 20;
    public int volMAX = 0;
    public int volMIN = 127;
    byte[] out;
    byte[] in;
    int inPos;
    int[] trackVolumes;

    public CMIDIvol(byte[] res) {
        this.in = res;
    }

    public static int b2i(int b) {
        if (b < 0) {
            b += 256;
        }
        return b;
    }

    public static int[] getVolumeValues(int min, int max, int scale) {
        int[] val = new int[scale];
        int mm = max - min;
        int k = 127 - mm;
        int m = k / (scale - (mm > 0 ? 2 : 1));
        val[0] = 0;
        for (int t = 0; t <= scale - 3; ++t) {
            val[t + 1] = mm > 0 ? mm + t * m : (t + 1) * m;
        }
        val[scale - 1] = 127;
        if (scale >= 4) {
            val[1] = 2 * val[1] / 3;
            val[2] = val[2] / 3;
        }
        return val;
    }

    public boolean writeMidWithVolume(int volume) {
        this.inPos = 0;
        int length = this.in.length - 1;
        if (this.in == null) {
            CDebug.show("ERROR: the MIDI file cannot be found or is invalid");
            return false;
        }
        try {
            this.out = new byte[this.in.length];
        }
        catch (Exception e) {
            this.out = null;
            return false;
        }
        try {
            while (this.inPos < length) {
                int b = this.in[this.inPos];
                this.out[this.inPos++] = b;
                int i = b < 0 ? b + 256 : b;
                if (i - 176 >= 16 || i - 176 < 0) continue;
                b = this.in[this.inPos];
                this.out[this.inPos++] = b;
                if (this.inPos >= length || b != 7) continue;
                b = this.in[this.inPos];
                this.out[this.inPos++] = (byte)this.computeVolumeValue(b, volume);
            }
        }
        catch (Exception e) {
            CDebug.show("ERROR write");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private int computeVolumeValue(int crVal, int volume) {
        int t = volume;
        return t >= 0 ? t : 0;
    }

    public byte[] getData() {
        return this.in;
    }

    public InputStream prepareMidOutputForPlayer() {
        ByteArrayInputStream inp = new ByteArrayInputStream(this.out);
        return inp;
    }
}

