/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public final class CFontManager {
    static final byte FONT_MENU = 0;
    static final byte CHUNK_FONT_MENU = 0;
    static final byte FONT_TEXT = 1;
    static final byte FONT_TEXT_WHITE = 4;
    static final byte FONT_TEXT_MARON = 6;
    static final byte CHUNK_FONT_TEXT = 1;
    static final byte FONT_QUEST = 2;
    static final byte CHUNK_FONT_QUEST = 2;
    static final byte FONT_NONE = 3;
    static final byte CHUNK_FONT_NONE = 3;
    static final byte FONT_BUTTONS_BAR = 5;
    static final byte CHUNK_FONT_BUTTONS_BAR = 4;
    static final byte FONTS_CHUNKS_COUNT = 5;
    static final int[] FONT_IMAGES = new int[]{0, 1, 2, -1, 125, 3, 126};
    static final byte[] FONT_CHUNK_ID = new byte[]{0, 1, 2, 3, 1, 4, 1};
    static final byte[] SPACE_WIDTH = new byte[]{5, 5, 5, 5, 5, 5, 5};
    static final byte LEFT_ALIGNMENT = 0;
    static final byte CENTER_ALIGNMENT = 1;
    static final byte RIGHT_ALIGNMENT = 2;
    static final byte JUSTIFY = 3;
    public static final char PARAGRAPH_MARKER = '\n';
    static final int[] FONT_HEIGHT = new int[5];
    static final Hashtable[] HASH_TABLES = new Hashtable[5];
    private static byte[][][] chars = new byte[5][][];

    static boolean loadFontChunk(byte[] buf, int fontID, int startPos) {
        if (HASH_TABLES[FONT_CHUNK_ID[fontID]] != null) {
            return true;
        }
        int index = startPos;
        int nch = buf[index];
        CFontManager.HASH_TABLES[CFontManager.FONT_CHUNK_ID[fontID]] = new Hashtable(nch);
        CFontManager.chars[CFontManager.FONT_CHUNK_ID[fontID]] = new byte[nch][];
        CFontManager.FONT_HEIGHT[CFontManager.FONT_CHUNK_ID[fontID]] = buf[++index];
        ++index;
        CDebug.show("font: " + fontID + " height: " + FONT_HEIGHT[FONT_CHUNK_ID[fontID]]);
        int symbol = 0;
        for (int chidx = 0; chidx < nch; ++chidx) {
            int tileCount;
            int width;
            int spaceBefore = 0;
            int spaceAfter = 0;
            int hasSpace = CFontManager.readBits(1, buf, index * 8);
            if (hasSpace > 0) {
                width = CFontManager.readBits(7, buf, index * 8 + 1);
                spaceBefore = CFontManager.readBits(5, buf, index * 8 + 8);
                spaceAfter = CFontManager.readBits(5, buf, index * 8 + 13);
                tileCount = CFontManager.readBits(6, buf, index * 8 + 18);
                index += 3;
            } else {
                width = CFontManager.readBits(9, buf, index * 8 + 1);
                tileCount = CFontManager.readBits(6, buf, index * 8 + 10);
                index += 2;
            }
            symbol = buf[index] > 0 ? buf[index] << 8 : buf[index] + 256 << 8;
            int n = buf[index + 1] > 0 ? buf[index + 1] : buf[index + 1] + 256;
            index += 2;
            HASH_TABLES[FONT_CHUNK_ID[fontID]].put(new Character((char)(symbol += n)), new Integer(chidx));
            int len = tileCount * 5;
            CFontManager.chars[CFontManager.FONT_CHUNK_ID[fontID]][chidx] = new byte[len + 4];
            CFontManager.chars[CFontManager.FONT_CHUNK_ID[fontID]][chidx][0] = (byte)tileCount;
            CFontManager.chars[CFontManager.FONT_CHUNK_ID[fontID]][chidx][1] = (byte)width;
            CFontManager.chars[CFontManager.FONT_CHUNK_ID[fontID]][chidx][2] = (byte)spaceBefore;
            CFontManager.chars[CFontManager.FONT_CHUNK_ID[fontID]][chidx][3] = (byte)spaceAfter;
            System.arraycopy(buf, index, chars[FONT_CHUNK_ID[fontID]][chidx], 4, len);
            index += tileCount * 5;
        }
        return true;
    }

    public static int getCharIndex(char c, int fontID) {
        if (fontID == 0 || fontID == 2) {
            c = Character.toLowerCase(c);
        }
        try {
            Integer i = (Integer)HASH_TABLES[FONT_CHUNK_ID[fontID]].get(new Character(c));
            if (i == null) {
                return -1;
            }
            return i;
        }
        catch (Exception e) {
            e.printStackTrace();
            CDebug.show("getCharIndex exception!");
            return -1;
        }
    }

    static int getCharWidth(char c, int fontID) {
        if (c == ' ') {
            return SPACE_WIDTH[fontID];
        }
        int q = CFontManager.getCharIndex(c, fontID);
        if (q == -1) {
            return 5;
        }
        return chars[FONT_CHUNK_ID[fontID]][q][1];
    }

    static int getStringLength(byte[] s, int fontID) {
        return CFontManager.getStringLength(s, 0, s.length, fontID);
    }

    static int getStringLength(byte[] s, int begID, int endID, int fontID) {
        int xPos = 0;
        for (int i = begID; i < endID; ++i) {
            char c = CFontManager.getCharAt(s, i);
            if (c == ' ') {
                xPos += SPACE_WIDTH[fontID];
                continue;
            }
            int q = CFontManager.getCharIndex(c, fontID);
            if (q == -1) {
                if (c == '\n') continue;
                xPos += 5;
                CDebug.show("!!! Char not found: " + c + " !!!");
                continue;
            }
            xPos += chars[FONT_CHUNK_ID[fontID]][q][1];
        }
        return xPos;
    }

    static int getFontHeight(int fontID) {
        return FONT_HEIGHT[FONT_CHUNK_ID[fontID]];
    }

    public static int[] wrapText(byte[] s, int width, int fontID) {
        int[] breaks = s.length < 2 ? new int[2] : new int[s.length];
        int iBreak = 0;
        breaks[iBreak++] = 0;
        int lineLength = 0;
        int iLastSpaceIndex = 0;
        for (int iChar = 0; iChar < s.length; ++iChar) {
            char c = CFontManager.getCharAt(s, iChar);
            if (c == '\n') {
                lineLength = CFontManager.getStringLength(s, breaks[iBreak - 1], iChar, fontID);
                if (lineLength <= width) {
                    breaks[iBreak++] = iChar;
                } else if (iLastSpaceIndex <= breaks[iBreak - 1]) {
                    iChar = breaks[iBreak - 1] + 1;
                    while (CFontManager.getStringLength(s, breaks[iBreak - 1], iChar, fontID) < width) {
                        ++iChar;
                    }
                    breaks[iBreak++] = --iChar;
                    --iChar;
                } else {
                    breaks[iBreak++] = iLastSpaceIndex;
                    iChar = iLastSpaceIndex - 1;
                }
            } else if (c == ' ') {
                lineLength = CFontManager.getStringLength(s, breaks[iBreak - 1], iChar, fontID);
                if (lineLength > width) {
                    if (iLastSpaceIndex <= breaks[iBreak - 1]) {
                        iChar = breaks[iBreak - 1] + 1;
                        while (CFontManager.getStringLength(s, breaks[iBreak - 1], iChar, fontID) < width) {
                            ++iChar;
                        }
                        breaks[iBreak++] = --iChar;
                    } else {
                        breaks[iBreak++] = iLastSpaceIndex;
                        iChar = iLastSpaceIndex - 1;
                    }
                }
                iLastSpaceIndex = --iChar;
            }
            if (iChar != s.length - 1) continue;
            lineLength = CFontManager.getStringLength(s, breaks[iBreak - 1], s.length, fontID);
            if (lineLength > width) {
                if (iLastSpaceIndex <= breaks[iBreak - 1]) {
                    iChar = breaks[iBreak - 1] + 1;
                    while (CFontManager.getStringLength(s, breaks[iBreak - 1], iChar, fontID) < width) {
                        ++iChar;
                    }
                    breaks[iBreak++] = --iChar;
                    --iChar;
                    continue;
                }
                breaks[iBreak++] = iLastSpaceIndex;
                iChar = iLastSpaceIndex - 1;
                continue;
            }
            breaks[iBreak++] = s.length;
        }
        int[] indexes = new int[iBreak];
        System.arraycopy(breaks, 0, indexes, 0, iBreak);
        return indexes;
    }

    public static char getCharAt(byte[] string, int location) {
        if (string[location] < 0) {
            return (char)(string[location] + 256);
        }
        return (char)string[location];
    }

    public static void setCharAt(byte[] string, char c, int location) {
        string[location] = (byte)c;
    }

    public static void printChar(int index, int x, int y, Graphics g, int fontID) {
        if (index < 0) {
            g.setColor(0xFF0000);
            g.fillRect(x, y, 4, CFontManager.getFontHeight(fontID));
            return;
        }
        for (int i = 0; i < chars[FONT_CHUNK_ID[fontID]][index][0]; ++i) {
            g.drawRegion(CResManager.images[FONT_IMAGES[fontID]], CFontManager.readBits(10, chars[FONT_CHUNK_ID[fontID]][index], 32 + i * 40), CFontManager.readBits(10, chars[FONT_CHUNK_ID[fontID]][index], 42 + i * 40), CFontManager.readBits(5, chars[FONT_CHUNK_ID[fontID]][index], 52 + i * 40) + 1, CFontManager.readBits(5, chars[FONT_CHUNK_ID[fontID]][index], 57 + i * 40) + 1, 0, x + CFontManager.readBits(5, chars[FONT_CHUNK_ID[fontID]][index], 62 + i * 40), y + CFontManager.readBits(5, chars[FONT_CHUNK_ID[fontID]][index], 67 + i * 40), 20);
        }
    }

    static void printString(byte[] s, int x, int y, Graphics g, int fontID) {
        CFontManager.printString(s, 0, s.length, x, y, g, fontID);
    }

    static void printString(byte[] s, int beg, int end, int x, int y, Graphics g, int fontID) {
        if (CResManager.images[FONT_IMAGES[fontID]] == null) {
            g.drawString("null", x, y, 20);
            return;
        }
        int xPos = 0;
        for (int i = beg; i < end; ++i) {
            char c = CFontManager.getCharAt(s, i);
            if (c == '\n') continue;
            if (c == ' ') {
                xPos += SPACE_WIDTH[fontID];
                continue;
            }
            int q = CFontManager.getCharIndex(c, fontID);
            if (q == -1) {
                CFontManager.printChar(q, x + xPos, y, g, fontID);
                xPos += 5;
                continue;
            }
            CFontManager.printChar(q, x + xPos, y, g, fontID);
            xPos += chars[FONT_CHUNK_ID[fontID]][q][1];
        }
    }

    public static int readBits(int bits, byte[] v, int offset) {
        int rez = 0;
        for (int i = offset; i < offset + bits; ++i) {
            if ((v[i >> 3] & 1 << (7 - i & 7)) == 0) continue;
            rez |= 1 << bits - 1 - (i - offset);
        }
        return rez;
    }

    private static int b2i(int b) {
        if (b < 0) {
            b += 256;
        }
        return b;
    }

    private static char bb2c(int b1, int b2) {
        if (b1 < 0) {
            b1 += 256;
        }
        if (b2 < 0) {
            b2 += 256;
        }
        return (char)(b1 + (b2 << 8));
    }
}

