/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CSoftKeyBar
extends CControl {
    public int softLeft;
    public int softRight;
    public int softMiddleImage;
    public byte softLeftEvent;
    public byte softRightEvent;
    public byte softMiddleEvent;
    public byte font;
    private int[][] softKeyBackup;
    private int saveIndex;
    boolean showKeys = true;

    public CSoftKeyBar(short left, short top, short width, short height, byte font) {
        super(new CRect(left, top, left + width, top + height));
        this.font = font;
        this.type = 0;
    }

    public void setSoftKeys(int softLeft, byte softLeftEvent, int softMiddleImage, byte softMiddleEvent, int softRight, byte softRightEvent) {
        this.softLeft = softLeft;
        this.softLeftEvent = softLeftEvent;
        this.softMiddleImage = softMiddleImage;
        this.softMiddleEvent = softMiddleEvent;
        this.softRight = softRight;
        this.softRightEvent = softRightEvent;
        this.notifyParent((byte)30);
    }

    public void saveSoftKeys() {
        if (this.softKeyBackup == null) {
            this.softKeyBackup = new int[2][];
            this.saveIndex = 0;
        }
        if (this.saveIndex >= 2) {
            return;
        }
        this.softKeyBackup[this.saveIndex] = new int[6];
        this.softKeyBackup[this.saveIndex][0] = this.softLeft;
        this.softKeyBackup[this.saveIndex][1] = this.softLeftEvent;
        this.softKeyBackup[this.saveIndex][2] = this.softMiddleImage;
        this.softKeyBackup[this.saveIndex][3] = this.softMiddleEvent;
        this.softKeyBackup[this.saveIndex][4] = this.softRight;
        this.softKeyBackup[this.saveIndex][5] = this.softRightEvent;
        ++this.saveIndex;
    }

    public void loadSoftKeys() {
        if (this.softKeyBackup == null || this.saveIndex - 1 < 0) {
            return;
        }
        --this.saveIndex;
        this.softLeft = this.softKeyBackup[this.saveIndex][0];
        this.softLeftEvent = (byte)this.softKeyBackup[this.saveIndex][1];
        this.softMiddleImage = this.softKeyBackup[this.saveIndex][2];
        this.softMiddleEvent = (byte)this.softKeyBackup[this.saveIndex][3];
        this.softRight = this.softKeyBackup[this.saveIndex][4];
        this.softRightEvent = (byte)this.softKeyBackup[this.saveIndex][5];
        this.softKeyBackup[this.saveIndex] = null;
        this.notifyParent((byte)30);
    }

    public void processEvent(byte event) {
        this.notifyParent((byte)30);
    }

    public void paint(Graphics g, CRect forcedClip) {
        if (forcedClip == null) {
            g.setClip(this.bounds.left, this.bounds.top, this.bounds.getWidth(), this.bounds.getHeight());
        } else {
            g.setClip(this.bounds.left, this.bounds.top, this.bounds.getWidth(), this.bounds.getHeight());
            g.clipRect(forcedClip.left, forcedClip.top, forcedClip.getWidth(), forcedClip.getHeight());
        }
        g.drawImage(CResManager.images[10], this.bounds.left, this.bounds.bottom, 0x20 | 4);
        if (!this.showKeys) {
            return;
        }
        if (this.softLeft >= 0) {
            CFontManager.printString(CResManager.getTextBytes(this.softLeft), this.bounds.left + 4, this.bounds.top + 2, g, this.font);
            g.drawImage(CResManager.images[9], (this.bounds.getWidth() - CResManager.images[9].getWidth()) / 2, this.bounds.bottom, 4 | 0x20);
        }
        if (this.softRight >= 0) {
            byte[] command = CResManager.getTextBytes(this.softRight);
            CFontManager.printString(command, this.bounds.right - 4 - CFontManager.getStringLength(command, this.font), this.bounds.top + 2, g, this.font);
        }
    }

    public void setVisibleKeys(boolean visible) {
        this.showKeys = visible;
        this.notifyParent((byte)30);
    }

    public String toString() {
        return "adr: " + this.hashCode() + "; type: " + this.getClass() + "; bounds: " + this.bounds;
    }
}

