/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class CPNG {
    private static final int CHUNK_IHDR_INT = 1229472850;
    private static final int CHUNK_FONT_INT = 1716473428;
    private static final int CHUNK_AMAF_INT = 1632452934;
    private static final int CHUNK_AMAS_INT = 1632452947;
    private static final int CHUNK_PLTE_INT = 1347179589;
    private static final int CHUNK_TRNS_INT = 1951551059;
    private static final int CHUNK_IDAT_INT = 1229209940;
    private static final int CHUNK_IEND_INT = 1229278788;
    private static final int CHUNK_IEND_CRC = -1371381630;
    private static final int FONT_BIT = 0;
    private static final int AMAS_BIT = 1;
    private static final int PLTE_BIT = 2;
    private static final int MYPLTE_BIT = 3;
    private static final int TRNS_BIT = 4;
    private static final int IDAT_BIT = 5;
    private static final int AMAF_BIT = 6;
    private static final int CHUNK_IHDR_SIZE = 13;
    private static final byte[] PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int SIZE_SWITCH_MASK = 4;
    private static final int PNG_CHOPPED_SIZE = 61;
    private static final int PNG_EXTRA_SIZE = 45;
    private static final int PALETTE_CHUNK_CHOPPED_SIZE = 8;
    private static final int TRNS_CHUNK_SIZE = 13;
    private static final int IDAT_HEADER_LENGTH = 7;
    private static final int IDAT_ADLER_LENGTH = 4;
    private static final int IDAT_EXTRA_DATA = 11;
    private static final int EXTRA_DATA_SIZE = 5;
    public static final int TRANSPARENCY_COLOUR = 0xFF00FF;
    private static byte[] pNGByteArray;
    private static byte[] fontChunk;
    private static byte[] spriteChunk;
    private static int trnsIndex;
    private static final int[] CRC_TABLE;
    static int inlen;
    static int incnt;
    static int bitbuf;
    static int bitcnt;
    static int outlen;
    static int outcnt;
    private static final int MAXBITS = 15;
    private static final int MAXLCODES = 286;
    private static final int MAXDCODES = 30;
    private static final int MAXCODES = 316;
    private static final int FIXLCODES = 288;
    static boolean virgin;

    public static void initVariables() {
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int k = 0; k < 8; k = (int)((byte)(k + 1))) {
                boolean leftBit = (c & 1) == 1;
                c = c >> 1 & Integer.MAX_VALUE;
                if (!leftBit) continue;
                c ^= 0xEDB88320;
            }
            CPNG.CRC_TABLE[i] = c;
        }
    }

    public static Image loadImage(byte[] data, int palette, int transform, boolean cacheData, byte[] fontPalette) {
        boolean isPacked = false;
        for (int i = 0; i < PNG_HEADER.length; ++i) {
            if (data[i] == PNG_HEADER[i]) continue;
            isPacked = true;
            break;
        }
        if (!isPacked) {
            try {
                CPNG.getPNG24SpriteChunk(data);
                return Image.createImage((byte[])data, (int)0, (int)data.length);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        Image finalImage = null;
        byte[] imageBuffer = CPNG.buildPNGArray(data, palette, transform, cacheData);
        try {
            if (fontPalette != null) {
                System.arraycopy(fontPalette, 0, imageBuffer, 41, fontPalette.length);
                byte[] crc = CPNG.intToBytes(CPNG.updateCrc(imageBuffer, fontPalette.length + 4, 37));
                System.arraycopy(crc, 0, imageBuffer, 41 + fontPalette.length, 4);
            }
            finalImage = Image.createImage((byte[])imageBuffer, (int)0, (int)imageBuffer.length);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            CDebug.show("CPNG: Error loading image");
        }
        return finalImage;
    }

    public static byte[] buildPNGArray(byte[] data, int palette, int transform, boolean cacheData) {
        byte[] imageBuffer = null;
        fontChunk = null;
        spriteChunk = null;
        int pData = 0;
        int pImage = 0;
        int chunkType = 0;
        int chunkCnt = 0;
        int chunkPlteCnt = 0;
        int length = 0;
        int paletteNr = 0;
        int chunkInfo = 0;
        int nextChunkType = -1;
        int extraDataSize = 5;
        int oldWidth = 0;
        int oldHeight = 0;
        int newWidth = 0;
        int newHeight = 0;
        trnsIndex = -1;
        while (pData < data.length) {
            boolean skipCopy = false;
            if (chunkCnt == 0) {
                if (((chunkInfo = data[pData++] & 0xFF) & 8) != 0) {
                    paletteNr = data[pData++] & 0xFF;
                    ++extraDataSize;
                } else {
                    paletteNr = 1;
                }
                oldWidth = (data[pData++] & 0xFF) << 8 | data[pData++] & 0xFF;
                oldHeight = (data[pData++] & 0xFF) << 8 | data[pData++] & 0xFF;
                if ((transform & 4) != 0) {
                    newWidth = oldHeight;
                    newHeight = oldWidth;
                } else {
                    newWidth = oldWidth;
                    newHeight = oldHeight;
                }
                int imageBufferLength = data.length - extraDataSize + 45;
                int parseOffset = extraDataSize;
                chunkCnt = 0;
                int currentPalette = 0;
                while (parseOffset < data.length) {
                    if ((chunkInfo & 1 << chunkCnt) != 0) {
                        length = (data[parseOffset] & 0xFF) << 24 | (data[parseOffset + 1] & 0xFF) << 16 | (data[parseOffset + 2] & 0xFF) << 8 | data[parseOffset + 3] & 0xFF;
                        imageBufferLength = chunkCnt == 4 || chunkCnt == 5 || (chunkCnt == 2 || chunkCnt == 3) && currentPalette == palette ? (imageBufferLength += 8) : (imageBufferLength -= length + 4);
                        parseOffset += length + 4;
                        if (chunkCnt == 2 || chunkCnt == 3) {
                            ++currentPalette;
                        }
                    }
                    if (chunkCnt == 3 && currentPalette != paletteNr) continue;
                    ++chunkCnt;
                }
                if (transform != 0) {
                    imageBufferLength -= length;
                    imageBufferLength += 11 + (newWidth + 1) * newHeight;
                }
                chunkCnt = 1;
                imageBuffer = new byte[imageBufferLength];
                length = 13;
                System.arraycopy(PNG_HEADER, 0, imageBuffer, 0, PNG_HEADER.length);
                System.arraycopy(CPNG.intToBytes(13), 0, imageBuffer, pImage += PNG_HEADER.length, 4);
                System.arraycopy(CPNG.intToBytes(1229472850), 0, imageBuffer, pImage + 4, 4);
                System.arraycopy(CPNG.intToBytes(newWidth), 0, imageBuffer, pImage + 8, 4);
                System.arraycopy(CPNG.intToBytes(newHeight), 0, imageBuffer, pImage + 12, 4);
                imageBuffer[pImage += 16] = 8;
                imageBuffer[pImage + 1] = 3;
                imageBuffer[pImage + 2] = 0;
                imageBuffer[pImage + 3] = 0;
                imageBuffer[pImage + 4] = 0;
                pImage += 5;
            } else {
                if (nextChunkType != 3 || chunkPlteCnt == paletteNr) {
                    ++nextChunkType;
                    while ((chunkInfo & 1 << nextChunkType) == 0) {
                        ++nextChunkType;
                    }
                }
                length = CPNG.bytesToInt(data, pData, true);
                if (nextChunkType == 0) {
                    chunkType = 1716473428;
                    skipCopy = true;
                } else if (nextChunkType == 6) {
                    chunkType = 1632452934;
                    skipCopy = true;
                } else if (nextChunkType == 1) {
                    chunkType = 1632452947;
                    skipCopy = true;
                } else if (nextChunkType == 2 || nextChunkType == 3) {
                    chunkType = 1347179589;
                    if (palette != chunkPlteCnt) {
                        skipCopy = true;
                    }
                    ++chunkPlteCnt;
                } else if (nextChunkType == 4) {
                    chunkType = 1951551059;
                    trnsIndex = data[pData + 4] & 0xFF;
                } else if (nextChunkType == 5) {
                    chunkType = 1229209940;
                }
                if (!skipCopy) {
                    System.arraycopy(data, pData, imageBuffer, pImage, 4);
                    pData += 4;
                    System.arraycopy(CPNG.intToBytes(chunkType), 0, imageBuffer, pImage + 4, 4);
                    pImage += 8;
                    if (chunkType != 1229209940 || transform == 0) {
                        System.arraycopy(data, pData, imageBuffer, pImage, length);
                        pImage += length;
                        pData += length;
                    } else {
                        int i;
                        int pChunk;
                        byte[] chunkData;
                        if (length < (oldWidth + 1) * oldHeight + 11) {
                            chunkData = new byte[(oldWidth + 1) * oldHeight];
                            pChunk = 0;
                            CPNG.uncompress(data, pData, length, chunkData, pChunk, chunkData.length);
                            pData += length;
                        } else {
                            chunkData = data;
                            pChunk = pData + 7;
                            pData += length;
                        }
                        int compsize = (newWidth + 1) * newHeight;
                        length = compsize + 11;
                        int pSize = pImage - 8;
                        imageBuffer[pImage++] = 120;
                        imageBuffer[pImage++] = -38;
                        imageBuffer[pImage++] = 1;
                        imageBuffer[pImage++] = (byte)(compsize & 0xFF);
                        imageBuffer[pImage++] = (byte)(compsize >>> 8 & 0xFF);
                        imageBuffer[pImage] = ~imageBuffer[pImage - 2];
                        imageBuffer[++pImage] = ~imageBuffer[pImage - 2];
                        int adlerstart = ++pImage;
                        switch (transform) {
                            case 0: 
                            case 8: {
                                int x;
                                int y;
                                i = pChunk;
                                for (y = 0; y < oldHeight; ++y) {
                                    imageBuffer[pImage++] = 0;
                                    ++i;
                                    for (x = 0; x < oldWidth; ++x) {
                                        imageBuffer[pImage++] = chunkData[i++];
                                    }
                                }
                                break;
                            }
                            case 2: {
                                int x;
                                int y;
                                for (y = 0; y < oldHeight; ++y) {
                                    i = (y + 1) * oldWidth + y + pChunk;
                                    imageBuffer[pImage++] = 0;
                                    for (x = 0; x < oldWidth; ++x) {
                                        imageBuffer[pImage++] = chunkData[i--];
                                    }
                                }
                                break;
                            }
                            case 1: {
                                int x;
                                int y;
                                for (y = 0; y < oldHeight; ++y) {
                                    i = (oldHeight - y - 1) * (oldWidth + 1) + pChunk;
                                    imageBuffer[pImage++] = 0;
                                    ++i;
                                    for (x = 0; x < oldWidth; ++x) {
                                        imageBuffer[pImage++] = chunkData[i++];
                                    }
                                }
                                break;
                            }
                            case 3: {
                                int x;
                                int y;
                                for (y = 0; y < oldHeight; ++y) {
                                    i = (oldHeight - y) * (oldWidth + 1) - 1 + pChunk;
                                    imageBuffer[pImage++] = 0;
                                    for (x = 0; x < oldWidth; ++x) {
                                        imageBuffer[pImage++] = chunkData[i--];
                                    }
                                }
                                break;
                            }
                            case 5: {
                                int x;
                                int y;
                                int j = (oldWidth + 1) * (oldHeight - 1) + 1 + pChunk;
                                for (y = 0; y < newHeight; ++y) {
                                    i = j + y;
                                    imageBuffer[pImage++] = 0;
                                    for (x = 0; x < newWidth; ++x) {
                                        imageBuffer[pImage++] = chunkData[i];
                                        i -= oldWidth + 1;
                                    }
                                }
                                break;
                            }
                            case 6: {
                                int x;
                                int y;
                                int j = oldWidth + pChunk;
                                for (y = 0; y < newHeight; ++y) {
                                    i = j - y;
                                    imageBuffer[pImage++] = 0;
                                    for (x = 0; x < newWidth; ++x) {
                                        imageBuffer[pImage++] = chunkData[i];
                                        i += oldWidth + 1;
                                    }
                                }
                                break;
                            }
                            case 7: {
                                int x;
                                int y;
                                int j = (oldWidth + 1) * oldHeight - 1 + pChunk;
                                for (y = 0; y < newHeight; ++y) {
                                    i = j - y;
                                    imageBuffer[pImage++] = 0;
                                    for (x = 0; x < newWidth; ++x) {
                                        imageBuffer[pImage++] = chunkData[i];
                                        i -= oldWidth + 1;
                                    }
                                }
                                break;
                            }
                            case 4: {
                                int x;
                                int y;
                                int j = 1 + pChunk;
                                for (y = 0; y < newHeight; ++y) {
                                    i = j + y;
                                    imageBuffer[pImage++] = 0;
                                    for (x = 0; x < newWidth; ++x) {
                                        imageBuffer[pImage++] = chunkData[i];
                                        i += oldWidth + 1;
                                    }
                                }
                                break;
                            }
                        }
                        int adler1 = 1;
                        int adler2 = 0;
                        for (i = 0; i < compsize; ++i) {
                            adler2 = (adler1 += imageBuffer[adlerstart + i] & 0xFF) + adler2;
                            adler1 %= 65521;
                            adler2 %= 65521;
                        }
                        int crc = adler2 << 16 | adler1;
                        imageBuffer[pImage++] = (byte)(crc >>> 24 & 0xFF);
                        imageBuffer[pImage++] = (byte)(crc >>> 16 & 0xFF);
                        imageBuffer[pImage++] = (byte)(crc >>> 8 & 0xFF);
                        imageBuffer[pImage++] = (byte)(crc & 0xFF);
                        System.arraycopy(CPNG.intToBytes(length), 0, imageBuffer, pSize, 4);
                    }
                } else if (chunkType == 1716473428) {
                    fontChunk = new byte[length];
                    System.arraycopy(data, pData + 4, fontChunk, 0, length);
                    pData += 4 + length;
                } else if (chunkType == 1632452934) {
                    fontChunk = new byte[length];
                    System.arraycopy(data, pData + 4, fontChunk, 0, length);
                    pData += 4 + length;
                } else if (chunkType == 1632452947) {
                    spriteChunk = new byte[length];
                    System.arraycopy(data, pData + 4, spriteChunk, 0, length);
                    pData += 4 + length;
                } else {
                    pData += 4 + length;
                }
            }
            if (!skipCopy) {
                System.arraycopy(CPNG.intToBytes(CPNG.updateCrc(imageBuffer, length + 4, pImage - length - 4)), 0, imageBuffer, pImage, 4);
                pImage += 4;
            }
            ++chunkCnt;
        }
        System.arraycopy(CPNG.intToBytes(0), 0, imageBuffer, pImage, 4);
        System.arraycopy(CPNG.intToBytes(1229278788), 0, imageBuffer, pImage + 4, 4);
        System.arraycopy(CPNG.intToBytes(-1371381630), 0, imageBuffer, pImage + 8, 4);
        pImage += 12;
        pNGByteArray = (byte[])(cacheData ? imageBuffer : null);
        return imageBuffer;
    }

    public static int[] getRGBArray() {
        int palStart = PNG_HEADER.length + 13 + 12;
        int palBytes = (pNGByteArray[palStart] & 0xFF) << 24;
        palBytes |= (pNGByteArray[palStart + 1] & 0xFF) << 16;
        palBytes |= (pNGByteArray[palStart + 2] & 0xFF) << 8;
        palBytes |= pNGByteArray[palStart + 3] & 0xFF;
        palStart += 8;
        int[] palette = new int[palBytes / 3];
        for (int k = 0; k < palette.length; ++k) {
            if (trnsIndex == k) {
                palette[k] = 0xFF00FF;
                continue;
            }
            palette[k] = -16777216;
            int n = k;
            palette[n] = palette[n] | (pNGByteArray[palStart + 3 * k] & 0xFF) << 16;
            int n2 = k;
            palette[n2] = palette[n2] | (pNGByteArray[palStart + 3 * k + 1] & 0xFF) << 8;
            int n3 = k;
            palette[n3] = palette[n3] | pNGByteArray[palStart + 3 * k + 2] & 0xFF;
        }
        int width = (pNGByteArray[PNG_HEADER.length + 8] & 0xFF) << 24 | (pNGByteArray[PNG_HEADER.length + 9] & 0xFF) << 16 | (pNGByteArray[PNG_HEADER.length + 10] & 0xFF) << 8 | pNGByteArray[PNG_HEADER.length + 11] & 0xFF;
        int height = (pNGByteArray[PNG_HEADER.length + 12] & 0xFF) << 24 | (pNGByteArray[PNG_HEADER.length + 13] & 0xFF) << 16 | (pNGByteArray[PNG_HEADER.length + 14] & 0xFF) << 8 | pNGByteArray[PNG_HEADER.length + 15] & 0xFF;
        int start = pNGByteArray.length - (width + 1) * height - 4 - 16;
        ++start;
        int[] rgbData = new int[width * height];
        for (int k = 0; k < rgbData.length; ++k) {
            rgbData[k] = palette[pNGByteArray[start + k + k / width]];
        }
        return rgbData;
    }

    public static int getWidth() {
        return (pNGByteArray[PNG_HEADER.length + 8] & 0xFF) << 24 | (pNGByteArray[PNG_HEADER.length + 9] & 0xFF) << 16 | (pNGByteArray[PNG_HEADER.length + 10] & 0xFF) << 8 | pNGByteArray[PNG_HEADER.length + 11] & 0xFF;
    }

    public static int getHeight() {
        return (pNGByteArray[PNG_HEADER.length + 12] & 0xFF) << 24 | (pNGByteArray[PNG_HEADER.length + 13] & 0xFF) << 16 | (pNGByteArray[PNG_HEADER.length + 14] & 0xFF) << 8 | pNGByteArray[PNG_HEADER.length + 15] & 0xFF;
    }

    public static byte[] getFontChunk() {
        return fontChunk;
    }

    public static byte[] getSpriteChunk() {
        return spriteChunk;
    }

    public static void deallocate() {
        fontChunk = null;
        pNGByteArray = null;
    }

    private static int uncompress(byte[] source, int pSource, int oldLength, byte[] out, int pOut, int newLength) {
        int err;
        outlen = newLength;
        outcnt = pOut;
        incnt = pSource;
        inlen = oldLength + incnt;
        bitbuf = 0;
        bitcnt = 0;
        int last = CPNG.bits(source, 16);
        do {
            last = CPNG.bits(source, 1);
            int type = CPNG.bits(source, 2);
            int n = type == 0 ? CPNG.stored(source, out) : (type == 1 ? CPNG.fixed(source, out) : (err = type == 2 ? CPNG.dynamic(source, out) : -1));
        } while (err == 0 && last != 1);
        return err;
    }

    private static int stored(byte[] source, byte[] out) {
        bitbuf = 0;
        bitcnt = 0;
        if (incnt + 4 > inlen) {
            return -1;
        }
        int len = source[incnt++];
        int n = incnt++;
        if (source[incnt++] != (~(len |= source[n] << 8) & 0xFF) || source[incnt++] != (~len >> 8 & 0xFF)) {
            return -1;
        }
        if (incnt + len > inlen) {
            return -1;
        }
        if (out != null) {
            if (outcnt + len > outlen) {
                return -1;
            }
            while (len-- != 0) {
                out[CPNG.outcnt++] = source[incnt++];
            }
        } else {
            outcnt += len;
            incnt += len;
        }
        return 0;
    }

    private static int fixed(byte[] source, byte[] out) {
        short[] lencnt = new short[16];
        short[] lensym = new short[288];
        short[] distcnt = new short[16];
        short[] distsym = new short[30];
        if (virgin) {
            int symbol;
            short[] lengths = new short[288];
            for (symbol = 0; symbol < 144; ++symbol) {
                lengths[symbol] = 8;
            }
            while (symbol < 256) {
                lengths[symbol] = 9;
                ++symbol;
            }
            while (symbol < 280) {
                lengths[symbol] = 7;
                ++symbol;
            }
            while (symbol < 288) {
                lengths[symbol] = 8;
                ++symbol;
            }
            CPNG.construct(lencnt, lensym, lengths, 0, 288);
            for (symbol = 0; symbol < 30; ++symbol) {
                lengths[symbol] = 5;
            }
            CPNG.construct(distcnt, distsym, lengths, 0, 30);
            virgin = false;
        }
        return CPNG.codes(source, out, lencnt, lensym, distcnt, distsym);
    }

    private static int dynamic(byte[] source, byte[] out) {
        int index;
        short[] lengths = new short[316];
        short[] lencnt = new short[16];
        short[] lensym = new short[286];
        short[] distcnt = new short[16];
        short[] distsym = new short[30];
        short[] order = new short[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
        int nlen = CPNG.bits(source, 5) + 257;
        int ndist = CPNG.bits(source, 5) + 1;
        int ncode = CPNG.bits(source, 4) + 4;
        if (nlen > 286 || ndist > 30) {
            return -3;
        }
        for (index = 0; index < ncode; ++index) {
            lengths[order[index]] = (short)CPNG.bits(source, 3);
        }
        while (index < 19) {
            lengths[order[index]] = 0;
            ++index;
        }
        int err = CPNG.construct(lencnt, lensym, lengths, 0, 19);
        if (err != 0) {
            return -4;
        }
        index = 0;
        while (index < nlen + ndist) {
            int symbol = CPNG.decode(source, lencnt, lensym);
            if (symbol < 16) {
                lengths[index++] = (short)symbol;
                continue;
            }
            short len = 0;
            if (symbol == 16) {
                if (index == 0) {
                    return -5;
                }
                len = lengths[index - 1];
                symbol = 3 + CPNG.bits(source, 2);
            } else {
                symbol = symbol == 17 ? 3 + CPNG.bits(source, 3) : 11 + CPNG.bits(source, 7);
            }
            if (index + symbol > nlen + ndist) {
                return -6;
            }
            while (symbol-- != 0) {
                lengths[index++] = len;
            }
        }
        err = CPNG.construct(lencnt, lensym, lengths, 0, nlen);
        if (err < 0 || err > 0 && nlen - lencnt[0] != 1) {
            return -7;
        }
        err = CPNG.construct(distcnt, distsym, lengths, nlen, ndist);
        if (err < 0 || err > 0 && ndist - distcnt[0] != 1) {
            return -8;
        }
        return CPNG.codes(source, out, lencnt, lensym, distcnt, distsym);
    }

    private static int construct(short[] count, short[] symbols, short[] length, int lengthOffset, int n) {
        int symbol;
        int len;
        short[] offs = new short[16];
        for (len = 0; len <= 15; ++len) {
            count[len] = 0;
        }
        for (symbol = 0; symbol < n; ++symbol) {
            short s = length[symbol + lengthOffset];
            count[s] = (short)(count[s] + 1);
        }
        if (count[0] == n) {
            return 0;
        }
        int left = 1;
        for (len = 1; len <= 15; ++len) {
            left <<= 1;
            if ((left -= count[len]) >= 0) continue;
            return left;
        }
        offs[1] = 0;
        for (len = 1; len < 15; ++len) {
            offs[len + 1] = (short)(offs[len] + count[len]);
        }
        for (symbol = 0; symbol < n; ++symbol) {
            if (length[symbol + lengthOffset] == 0) continue;
            short s = length[symbol + lengthOffset];
            short s2 = offs[s];
            offs[s] = (short)(s2 + 1);
            symbols[s2] = (short)symbol;
        }
        return left;
    }

    private static int decode(byte[] source, short[] counts, short[] symbols) {
        int tempbitbuf = bitbuf;
        int left = bitcnt;
        int code = 0;
        int first = 0;
        int index = 0;
        int len = 1;
        int next = 1;
        while (true) {
            if (left-- != 0) {
                short count;
                if ((code |= (tempbitbuf >>= 1) & 1) < first + (count = counts[next++])) {
                    bitbuf = tempbitbuf;
                    bitcnt = bitcnt - len & 7;
                    return symbols[index + (code - first)];
                }
                index += count;
                first += count;
                first <<= 1;
                code <<= 1;
                ++len;
                continue;
            }
            left = 16 - len;
            if (left == 0) break;
            if (incnt == inlen) {
                return -1;
            }
            tempbitbuf = source[incnt++] & 0xFF;
            if (left <= 8) continue;
            left = 8;
        }
        return -1;
    }

    private static int codes(byte[] source, byte[] out, short[] lcount, short[] lsymbol, short[] dcount, short[] dsymbol) {
        int symbol;
        short[] lens = new short[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258};
        short[] lext = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0};
        short[] dists = new short[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
        short[] dext = new short[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
        do {
            if ((symbol = CPNG.decode(source, lcount, lsymbol)) < 0) {
                return symbol;
            }
            if (symbol < 256) {
                if (out != null) {
                    if (outcnt == outlen) {
                        return 1;
                    }
                    out[CPNG.outcnt] = (byte)symbol;
                }
                ++outcnt;
                continue;
            }
            if (symbol <= 256) continue;
            if ((symbol -= 257) >= 29) {
                return -9;
            }
            int len = lens[symbol] + CPNG.bits(source, lext[symbol]);
            symbol = CPNG.decode(source, dcount, dsymbol);
            if (symbol < 0) {
                return symbol;
            }
            int dist = dists[symbol] + CPNG.bits(source, dext[symbol]);
            if (dist > outcnt) {
                return -10;
            }
            if (out != null) {
                if (outcnt + len > outlen) {
                    return 1;
                }
                while (len-- != 0) {
                    out[CPNG.outcnt] = out[outcnt - dist];
                    ++outcnt;
                }
            } else {
                outcnt += len;
            }
        } while (symbol != 256);
        return 0;
    }

    private static int bits(byte[] source, int need) {
        long val = bitbuf;
        while (bitcnt < need) {
            val |= (long)(source[incnt++] << bitcnt & (1 << bitcnt + 8) - 1);
            bitcnt += 8;
        }
        bitbuf = (int)(val >> need);
        bitcnt -= need;
        return (int)(val & (1L << need) - 1L);
    }

    public static int updateCrc(byte[] buf, int len, int startIdx) {
        int c = -1;
        len += startIdx;
        for (int i = startIdx; i < len; ++i) {
            c = CRC_TABLE[(c ^ buf[i]) & 0xFF] ^ c >> 8 & 0xFFFFFF;
        }
        return ~c;
    }

    public static int bytesToInt(byte[] readInt, int startIdx, boolean nbo) {
        int rez = 0;
        int offset = nbo ? 3 : 0;
        int semn = nbo ? -1 : 1;
        for (int i = startIdx; i < startIdx + 4; ++i) {
            rez |= (readInt[i] & 0xFF) << (offset + semn * (i - startIdx)) * 8;
        }
        return rez;
    }

    public static byte[] intToBytes(int readInt) {
        byte[] rez = new byte[4];
        for (int i = 3; i >= 0; --i) {
            rez[i] = (byte)(0xFF & readInt);
            readInt >>= 8;
        }
        return rez;
    }

    public static void getPNG24SpriteChunk(byte[] data) {
        int offset = -1;
        int length = 0;
        byte[] chunkType = new byte[4];
        spriteChunk = null;
        for (int i = 0; i < data.length; ++i) {
            ++offset;
            if (data[i] != 97 || i + 3 >= data.length) continue;
            System.arraycopy(data, offset, chunkType, 0, 4);
            if (CPNG.bytesToInt(chunkType, 0, true) != 1632452947) continue;
            length = (data[offset -= 4] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
            spriteChunk = new byte[length];
            System.arraycopy(data, offset += 8, spriteChunk, 0, length);
            return;
        }
    }

    static {
        CRC_TABLE = new int[256];
        CPNG.initVariables();
        inlen = 0;
        incnt = 0;
        bitbuf = 0;
        bitcnt = 0;
        outlen = 0;
        outcnt = 0;
        virgin = true;
    }
}

