/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CEditBox
extends CControl {
    public static final int EDIT_FLAG_LETTER = 1;
    public static final int EDIT_FLAG_NUMBER = 2;
    public static final int EDIT_FLAG_SPACE = 4;
    public static final int EDIT_FLAG_DOT = 8;
    public static final int EDIT_FLAG_CAP_LETTER = 16;
    public static final int EDIT_FLAG_ALL = 31;
    public static final int EDIT_FLAG_DEFAULT_VALUE = 64;
    private static final int CARRET_RETYPE_TIME = 1000;
    private static final int CARRET_BLINK_TIME = 512;
    private static final String[] KBSTR = new String[]{"", "abc", "def", "ghi", "jkl", "mno", "pqrs", "tuv", "wxyz", "", " ", "#"};
    private String lowerCase = "1abc2\u00e2\u00e1\u00e4\u00e7def3\u00e9\u00eaghi4\u00eejkl5mno6\u00f4\u00f3\u00f6pqrs7tuv8\u00fa\u00fcwxyz9*.0 #";
    private String upperCase = "1ABC2\u00c2\u00c1\u00c4\u00c7DEF3\u00c9\u00caGHI4\u00ceJKL5MNO6\u00d4\u00d3\u00d6PQRS7TUV8\u00da\u00dcWXYZ9*.0 #";
    protected int carretBlinkTimer = -1;
    protected int editNewKeyTimer = -1;
    private byte[] textStr;
    public byte font;
    public byte alignment;
    public boolean isFocused = false;
    public boolean visibleCarret = true;
    public int entryLength;
    private int editFlags = 1;
    private int lastKey = -1;
    private int cKey = -1;
    private String lastKeyFilter = "";
    private boolean carretOn = true;
    public int carretPosition = 0;
    private int carretPushes = 0;
    private boolean newKey = true;
    private boolean capsOn = false;

    public CEditBox(CRect ctrlRect, byte editFont, int maxLength, int flags, boolean carretShown, byte align) {
        super(ctrlRect);
        this.editFlags = flags;
        this.visibleCarret = carretShown;
        this.entryLength = 0;
        this.font = editFont;
        this.textStr = new byte[maxLength];
        this.alignment = align;
        this.type = (byte)6;
    }

    public CEditBox(CRect ctrlRect, byte editFont, int maxLength, byte[] text, int flags, boolean carretShown, byte align) {
        super(ctrlRect);
        this.editFlags = flags;
        this.visibleCarret = carretShown;
        this.entryLength = 0;
        this.alignment = align;
        this.font = editFont;
        this.textStr = new byte[maxLength];
        this.type = (byte)6;
        if (text != null && text.length <= maxLength) {
            for (int i = 0; i < text.length; ++i) {
                CFontManager.setCharAt(this.textStr, (char)text[i], i);
            }
            this.entryLength = text.length;
            this.carretPosition += this.entryLength;
        }
    }

    private void register() {
        for (int i = 0; i <= 11; ++i) {
            CEvents.setControlOnEvent(this, (byte)i);
        }
        CEvents.setControlOnEvent(this, (byte)19);
        CEvents.setControlOnEvent(this, (byte)14);
        CEvents.setControlOnEvent(this, (byte)15);
        CEvents.setControlOnEvent(this, (byte)49);
        CEvents.setControlOnEvent(this, (byte)79);
        CEvents.setControlOnEvent(this, (byte)48);
    }

    private void unRegister() {
        for (int i = 0; i <= 11; ++i) {
            CEvents.removeControlFromEvent(this, (byte)i);
        }
        CEvents.removeControlFromEvent(this, (byte)19);
        CEvents.removeControlFromEvent(this, (byte)14);
        CEvents.removeControlFromEvent(this, (byte)15);
        CEvents.removeControlFromEvent(this, (byte)49);
        CEvents.removeControlFromEvent(this, (byte)79);
        CEvents.removeControlFromEvent(this, (byte)48);
    }

    public void setFlag(int newFlag) {
        this.editFlags |= newFlag;
    }

    public void removeFlag(int flag) {
        this.editFlags &= ~flag;
    }

    public byte[] getText() {
        byte[] string = new byte[this.entryLength];
        if (this.entryLength > 0) {
            System.arraycopy(this.textStr, 0, string, 0, this.entryLength);
        }
        return string;
    }

    public int getInteger() {
        int nr = 0;
        for (int i = 0; i < this.entryLength; ++i) {
            int d = this.textStr[this.entryLength - i - 1] - 48;
            for (int j = 0; j < i; ++j) {
                d *= 10;
            }
            nr += d;
        }
        return nr;
    }

    public void paint(Graphics g, CRect forcedClip) {
        if (!this.isVisible) {
            return;
        }
        if (forcedClip == null) {
            g.setClip(this.bounds.left, this.bounds.top, this.bounds.getWidth(), this.bounds.getHeight());
        } else {
            g.setClip(this.bounds.left, this.bounds.top, this.bounds.getWidth(), this.bounds.getHeight());
            g.clipRect(forcedClip.left, forcedClip.top, forcedClip.getWidth(), forcedClip.getHeight());
        }
        int x = this.bounds.left + (this.alignment == 1 ? this.bounds.getWidth() - CFontManager.getStringLength(this.textStr, 0, this.entryLength, this.font) >> 1 : 0);
        int carretOffset = x + CFontManager.getStringLength(this.textStr, 0, this.carretPosition, this.font);
        int yOffset = this.bounds.getHeight() - CFontManager.getFontHeight(this.font) >> 1;
        CFontManager.printString(this.textStr, 0, this.entryLength, x, this.bounds.top + yOffset, g, this.font);
        if (this.carretOn && this.visibleCarret) {
            g.setColor(0xFFFFFF);
            g.fillRect(carretOffset, this.bounds.top, 2, CFontManager.getFontHeight(this.font));
        }
        this.needsRepaint = false;
    }

    private int getKeyIndexByEvent() {
        this.cKey = -1;
        if (CEvents.getEvent(1)) {
            this.cKey = 0;
        } else if (CEvents.getEvent(2)) {
            this.cKey = 1;
        } else if (CEvents.getEvent(3)) {
            this.cKey = 2;
        } else if (CEvents.getEvent(4)) {
            this.cKey = 3;
        } else if (CEvents.getEvent(5)) {
            this.cKey = 4;
        } else if (CEvents.getEvent(6)) {
            this.cKey = 5;
        } else if (CEvents.getEvent(7)) {
            this.cKey = 6;
        } else if (CEvents.getEvent(8)) {
            this.cKey = 7;
        } else if (CEvents.getEvent(9)) {
            this.cKey = 8;
        } else if (CEvents.getEvent(10)) {
            this.cKey = -1;
            this.capsOn = false;
        } else if (CEvents.getEvent(0)) {
            this.cKey = 10;
        } else if (CEvents.getEvent(11)) {
            this.cKey = 11;
            boolean bl = this.capsOn = !this.capsOn;
        }
        if (this.cKey >= KBSTR.length) {
            this.cKey = -1;
        }
        return this.cKey;
    }

    private String filterKey(int key) {
        String s = "";
        if (key == -1) {
            return "";
        }
        int n = KBSTR[key].length();
        if (n == 0) {
            return "";
        }
        for (int i = 0; i < n; ++i) {
            char c = KBSTR[key].charAt(i);
            if ((this.editFlags & 1) != 0 && c != '*' && c != '#') {
                s = s + c;
            }
            if (c == ' ' && (this.editFlags & 4) != 0) {
                s = s + c;
            }
            if ((this.editFlags & 2) != 0 && c >= '0' && c <= '9') {
                s = s + c;
            }
            if ((this.editFlags & 8) != 0 && c == '.') {
                s = s + c;
            }
            if ((this.editFlags & 0x10) == 0 || c == '*' || c == '#') continue;
            s = s + this.upperCase.charAt(this.lowerCase.indexOf(c));
        }
        return s;
    }

    public void killTimers() {
        if (this.editNewKeyTimer >= 0) {
            CTimers.killTimer(this.editNewKeyTimer);
            this.editNewKeyTimer = -1;
        }
        if (this.carretBlinkTimer >= 0) {
            CTimers.killTimer(this.carretBlinkTimer);
            this.carretBlinkTimer = -1;
        }
    }

    private void resetNewKey() {
        this.newKey = true;
        this.lastKey = -1;
        this.cKey = -1;
        this.carretOn = true;
        CTimers.resetTimer(this.carretBlinkTimer, true);
        CTimers.resetTimer(this.editNewKeyTimer);
        this.notifyParent((byte)30);
    }

    public void processEvent(byte action) {
        if (!this.isFocused) {
            this.carretOn = false;
            this.needsRepaint = false;
            return;
        }
        if (action == 79 && (this.editFlags & 0x10) == 0) {
            boolean bl = this.capsOn = !this.capsOn;
        }
        if (action == 48) {
            this.carretOn = !this.carretOn;
            this.notifyParent((byte)30);
        } else if (action == 49) {
            this.resetNewKey();
        } else {
            if (action == 19 || action == 14) {
                this.needsRepaint = true;
                if (this.carretPosition > 0) {
                    int pos = this.carretPosition;
                    while (pos != this.entryLength) {
                        this.textStr[pos - 1] = this.textStr[pos++];
                    }
                    --this.carretPosition;
                    --this.entryLength;
                    this.resetNewKey();
                    return;
                }
                this.resetNewKey();
                return;
            }
            if (action == 15) {
                if (this.carretPosition == this.entryLength) {
                    return;
                }
                ++this.carretPosition;
                this.resetNewKey();
                return;
            }
            this.cKey = this.getKeyIndexByEvent();
            if (this.cKey != -1) {
                if (this.cKey == this.lastKey) {
                    if (this.lastKeyFilter.length() > 1) {
                        if (!this.newKey) {
                            if (this.carretPosition > 0) {
                                this.carretPushes = (this.carretPushes + 1) % this.lastKeyFilter.length();
                                char c = this.lastKeyFilter.charAt(this.carretPushes);
                                if (this.capsOn && (this.editFlags & 0x10) == 0) {
                                    c = this.upperCase.charAt(this.lowerCase.indexOf(c));
                                }
                                CFontManager.setCharAt(this.textStr, c, this.carretPosition - 1);
                                this.carretOn = false;
                                CTimers.resetTimer(this.editNewKeyTimer);
                                this.notifyParent((byte)30);
                                return;
                            }
                        } else {
                            this.carretPushes = 0;
                        }
                    }
                } else {
                    if (this.entryLength == this.textStr.length) {
                        if (this.textStr.length == 1) {
                            this.needsRepaint = true;
                            int pos = this.carretPosition;
                            while (pos != this.entryLength) {
                                this.textStr[pos - 1] = this.textStr[pos++];
                            }
                            --this.carretPosition;
                            --this.entryLength;
                        } else {
                            return;
                        }
                    }
                    this.lastKeyFilter = this.filterKey(this.cKey);
                    this.lastKey = this.cKey;
                    this.carretPushes = 0;
                }
                if (this.entryLength < this.textStr.length && this.lastKeyFilter.length() > 0) {
                    byte[] string = new byte[this.textStr.length];
                    System.arraycopy(this.textStr, 0, string, 0, this.carretPosition);
                    char c = this.lastKeyFilter.charAt(0);
                    if (this.capsOn && (this.editFlags & 0x10) == 0) {
                        c = this.upperCase.charAt(this.lowerCase.indexOf(c));
                    }
                    if (c == ' ' && this.carretPosition == 0) {
                        return;
                    }
                    CFontManager.setCharAt(string, c, this.carretPosition);
                    System.arraycopy(this.textStr, this.carretPosition, string, this.carretPosition + 1, this.textStr.length - (this.carretPosition + 1));
                    ++this.entryLength;
                    this.textStr = string;
                    string = null;
                    CTimers.resetTimer(this.editNewKeyTimer, true);
                    this.newKey = false;
                    CTimers.resetTimer(this.carretBlinkTimer, true);
                    this.carretOn = false;
                    ++this.carretPosition;
                    this.notifyParent((byte)30);
                }
            }
        }
    }

    public void setFocus(boolean focus) {
        this.isFocused = focus;
        if (focus) {
            this.register();
            this.carretOn = true;
            if (this.carretBlinkTimer < 0) {
                this.carretBlinkTimer = CTimers.newTimer(512, 48, true);
            }
            if (this.editNewKeyTimer < 0) {
                this.editNewKeyTimer = CTimers.newTimer(1000, 49, false);
            }
            CTimers.startTimer(this.carretBlinkTimer);
            CTimers.startTimer(this.editNewKeyTimer);
        } else {
            this.carretOn = false;
            this.unRegister();
            this.killTimers();
        }
        this.notifyParent((byte)30);
    }

    public void resetText() {
        this.entryLength = 0;
    }
}

