/*
 * Decompiled with CFR 0.152.
 */
public final class CTimers {
    public static final int MAX_TIMERS = 15;
    private static final int CURRENT_VALUE = 0;
    private static final int TRIGGER_VALUE = 1;
    private static final int EVENT_GENERATED = 2;
    private static final int INIT_VALUE = 3;
    private static final int PERIOD = 4;
    private static final int TIMERS_TABLE_COLUMNS = 5;
    public static long timeOut = -1L;
    private static int[][] timersTable = new int[15][5];
    private static boolean[] timersTableAux = new boolean[15];
    public static final int ALL = -1000;
    private static int maxAllocatedTimer;
    private static long lastUpdateTime;
    private static long updateTime;
    private static int dt;
    private static int dt2;

    public static void runTimers() {
        lastUpdateTime = updateTime;
        updateTime = System.currentTimeMillis();
        if (timeOut != -1L) {
            lastUpdateTime += timeOut;
            timeOut = -1L;
        }
        dt = (int)(updateTime - lastUpdateTime < 0L ? lastUpdateTime - updateTime : updateTime - lastUpdateTime);
        for (int i = 0; i < maxAllocatedTimer; ++i) {
            dt2 = timersTable[i][4] != 0 && dt > timersTable[i][4] ? timersTable[i][4] : dt;
            if (timersTable[i][0] < 0 || timersTableAux[i]) continue;
            int[] nArray = timersTable[i];
            nArray[0] = nArray[0] + dt2;
            if (nArray[0] < timersTable[i][1]) continue;
            if (0 != timersTable[i][4]) {
                int[] nArray2 = timersTable[i];
                nArray2[1] = nArray2[1] + timersTable[i][4];
            } else {
                CTimers.timersTable[i][0] = -1;
            }
            CEvents.setEvent((byte)timersTable[i][2]);
        }
    }

    public static void initTimers() {
        for (int i = 0; i < 15; ++i) {
            CTimers.timersTable[i][0] = -1;
        }
    }

    public static int newTimer(int delay, int event, int period) {
        int i;
        int timer = 0;
        for (i = 0; i < maxAllocatedTimer; ++i) {
            if (timersTable[i][0] >= 0) continue;
            timer = i;
            break;
        }
        if (i == maxAllocatedTimer) {
            timer = maxAllocatedTimer++;
        }
        CTimers.setTimer(timer, delay, event, period);
        return timer;
    }

    public static int newTimer(int value, int event, boolean retrigger) {
        int i;
        int timer = 0;
        for (i = 0; i < maxAllocatedTimer; ++i) {
            if (timersTable[i][0] >= 0) continue;
            timer = i;
            break;
        }
        if (i == maxAllocatedTimer) {
            timer = maxAllocatedTimer++;
        }
        if (retrigger) {
            CTimers.setTimer(timer, value, event, value);
        } else {
            CTimers.setTimer(timer, value, event, 0);
        }
        return timer;
    }

    public static int getEventOnTimer(int timer) {
        return timersTable[timer][2];
    }

    public static void setTimer(int timer, int value, int event, int period) {
        CTimers.timersTable[timer][0] = 0;
        CTimers.timersTable[timer][1] = value;
        CTimers.timersTable[timer][2] = event;
        CTimers.timersTable[timer][3] = value;
        CTimers.timersTable[timer][4] = period;
        CTimers.timersTableAux[timer] = true;
    }

    public static void resetTimer(int timer) {
        CTimers.timersTable[timer][1] = timersTable[timer][3];
        CTimers.timersTable[timer][0] = 0;
    }

    public static void resetTimer(int timer, boolean retrig) {
        if (retrig) {
            CTimers.timersTable[timer][1] = timersTable[timer][3];
            CTimers.timersTable[timer][0] = 0;
            CTimers.timersTableAux[timer] = false;
        }
    }

    public static void killTimer(int timer) {
        CTimers.timersTable[timer][0] = -1;
    }

    public static void killAllTimers() {
        for (int i = 0; i < 15; ++i) {
            CTimers.timersTable[i][0] = -1;
        }
    }

    public static void startTimer(int timer) {
        if (timer == -1000) {
            for (int i = 0; i < 15; ++i) {
                CTimers.timersTableAux[i] = false;
            }
        } else {
            CTimers.timersTableAux[timer] = false;
        }
    }

    public static void pauseTimer(int timer) {
        if (timer == -1000) {
            for (int i = 0; i < 15; ++i) {
                CTimers.timersTableAux[i] = true;
            }
        } else {
            CTimers.timersTableAux[timer] = true;
        }
    }

    public static void resumeTimer(int timer) {
        if (timer == -1000) {
            for (int i = 0; i < 15; ++i) {
                CTimers.timersTableAux[i] = false;
            }
        } else {
            CTimers.timersTableAux[timer] = false;
        }
    }

    public static int getPausedTimers() {
        int timers = 0;
        for (int i = 0; i < 15; ++i) {
            if (!timersTableAux[i]) continue;
            timers |= 1 << i;
        }
        return timers;
    }

    public static boolean isActive(int timer) {
        return !timersTableAux[timer] && timersTable[timer][0] != -1;
    }

    public static int getTimerByEvent(byte event) {
        for (int i = 0; i < 15; ++i) {
            if (timersTable[i][2] != event || !CTimers.isActive(i)) continue;
            return i;
        }
        return -1;
    }
}

