/*
 * Decompiled with CFR 0.152.
 */
public final class CEvents {
    private static int[] events = new int[3];
    private static int[] eventsToBeProcessed = new int[10];
    private static int processedEventsCount = 0;
    private static int processedEvent = 0;
    public static CControl[][] controlsAttached = new CControl[81][];
    public static int[] controlTops = new int[81];
    private static int[][] eventsToBeProcessedSaved;
    private static int[] processedEventsCountSaved;
    private static CControl[][][] controlsAttachedSaved;
    static int saveIndex;
    public static final int ALL_EVENTS = -1000;
    public static final int EXCEPT_QUICK_MENU = -1001;

    public static void setEvent(int eventFlag) {
        if (eventFlag == -1) {
            return;
        }
        int n = eventFlag >> 5;
        events[n] = events[n] | 1 << (eventFlag & 0x1F);
        if (processedEventsCount < 10) {
            for (int i = 0; i < processedEventsCount; ++i) {
                if (eventsToBeProcessed[i] != eventFlag) continue;
                return;
            }
            CEvents.eventsToBeProcessed[CEvents.processedEventsCount++] = eventFlag;
        }
    }

    public static void clrEvent(int eventFlag) {
        int n = eventFlag >> 5;
        events[n] = events[n] & ~(1 << (eventFlag & 0x1F));
    }

    public static boolean getEvent() {
        for (int i = 0; i < events.length; ++i) {
            if (events[i] == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean getEvent(int eventFlag) {
        return (events[eventFlag >> 5] & 1 << (eventFlag & 0x1F)) != 0;
    }

    public static void clearProcessedEvents() {
        processedEventsCount = 0;
        processedEvent = 0;
    }

    public static boolean hasEventsForProcessing() {
        return processedEventsCount > 0;
    }

    public static void clearAttachedControls() {
        for (int i = 0; i < controlsAttached.length; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < controlTops[i]; ++j) {
                CEvents.controlsAttached[i][j] = null;
            }
            CEvents.controlTops[i] = 0;
        }
    }

    public static void setControlOnEvent(CControl ctrl, byte event) {
        if (controlTops[event] == 20) {
            CDebug.show("MAX_CONTROLS_ATTACHED limit reached !!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        if (controlsAttached[event] == null) {
            CEvents.controlsAttached[event] = new CControl[20];
            CEvents.controlTops[event] = 0;
        }
        for (int i = 0; i < controlTops[event]; ++i) {
            if (controlsAttached[event][i] != ctrl) continue;
            return;
        }
        CEvents.controlsAttached[event][CEvents.controlTops[event]] = ctrl;
        byte by = event;
        controlTops[by] = controlTops[by] + 1;
    }

    public static void removeControlFromEvent(CControl ctrl, byte event) {
        if (event == -1) {
            return;
        }
        int location = -1;
        for (int i = 0; i < controlTops[event]; ++i) {
            if (location == -1) {
                if (controlsAttached[event][i] != ctrl) continue;
                location = i;
                if (i < controlsAttached[event].length - 1) {
                    CEvents.controlsAttached[event][i] = controlsAttached[event][i + 1];
                    continue;
                }
                CEvents.controlsAttached[event][i] = null;
                continue;
            }
            CEvents.controlsAttached[event][i] = i < controlsAttached[event].length - 1 ? controlsAttached[event][i + 1] : null;
        }
        if (location != -1) {
            byte by = event;
            controlTops[by] = controlTops[by] - 1;
        }
    }

    public static CControl getControlOnEvent(byte event, int location) {
        return controlsAttached[event][location];
    }

    public static int processNextEvent() {
        if (processedEvent == processedEventsCount) {
            return -1;
        }
        return eventsToBeProcessed[processedEvent++];
    }

    public static boolean translateEvent(int src, int dest) {
        if (CEvents.getEvent(src)) {
            CEvents.clrEvent(src);
            CEvents.setEvent(dest);
            return true;
        }
        return false;
    }

    public static void clearEvents() {
        for (int i = 0; i < 3; ++i) {
            CEvents.events[i] = 0;
        }
    }

    public static void saveEvents() {
        if (eventsToBeProcessedSaved == null) {
            eventsToBeProcessedSaved = new int[2][];
            controlsAttachedSaved = new CControl[2][][];
            processedEventsCountSaved = new int[2];
            saveIndex = 0;
        }
        if (saveIndex >= 2) {
            return;
        }
        CEvents.eventsToBeProcessedSaved[CEvents.saveIndex] = new int[eventsToBeProcessed.length];
        System.arraycopy(eventsToBeProcessed, 0, eventsToBeProcessedSaved[saveIndex], 0, eventsToBeProcessed.length);
        CEvents.processedEventsCountSaved[CEvents.saveIndex] = processedEventsCount;
        CEvents.controlsAttachedSaved[CEvents.saveIndex] = new CControl[controlsAttached.length][];
        for (int i = 0; i < controlsAttached.length; ++i) {
            if (controlsAttached[i] == null) continue;
            CEvents.controlsAttachedSaved[CEvents.saveIndex][i] = new CControl[controlTops[i]];
            System.arraycopy(controlsAttached[i], 0, controlsAttachedSaved[saveIndex][i], 0, controlsAttachedSaved[saveIndex][i].length);
        }
        ++saveIndex;
    }

    public static void loadSavedEvents() {
        if (saveIndex - 1 < 0) {
            return;
        }
        System.arraycopy(eventsToBeProcessedSaved[--saveIndex], 0, eventsToBeProcessed, 0, eventsToBeProcessed.length);
        CEvents.eventsToBeProcessedSaved[CEvents.saveIndex] = null;
        processedEventsCount = processedEventsCountSaved[saveIndex];
        for (int i = 0; i < controlsAttachedSaved[saveIndex].length; ++i) {
            if (controlsAttachedSaved[saveIndex][i] == null) continue;
            CEvents.controlTops[i] = controlsAttachedSaved[saveIndex][i].length;
            System.arraycopy(controlsAttachedSaved[saveIndex][i], 0, controlsAttached[i], 0, controlsAttachedSaved[saveIndex][i].length);
        }
        CEvents.controlsAttachedSaved[CEvents.saveIndex] = null;
    }
}

