/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class CResManager {
    static final String MIDI_FORMAT = "audio/midi";
    private static final String[] RES_FILE_NAMES = new String[]{"ani", "snd", "gfx", "txt", "fsm"};
    public static final byte ANI_LIB = 0;
    public static final byte SND_LIB = 1;
    public static final byte GFX_LIB = 2;
    public static final byte TXT_LIB = 3;
    public static final byte FSM_LIB = 4;
    public static final int RES_FILES_NO = 5;
    public static final int ALL_AT_ONCE = -1;
    private static int[] currentOffset = new int[5];
    private static byte[][][] data = new byte[5][][];
    private static int[][] header = new int[5][];
    static InputStream[] streams = new InputStream[5];
    static int[] indexes = new int[5];
    static int[] elementCount = new int[]{68, 1, 125, 936, 1};
    public static int[] elementIncrement = new int[]{68, 2, 5, 10, 1};
    static boolean[] neededImages = new boolean[125];
    static short imgPointer;
    static short imgCount;
    static short imgNumber;
    public static Image[] images;
    public static int[][] rgbData;
    public static byte[][][] spriteData;
    public static short[][][] hardcode;
    public static short[] library;
    public static short[] byteCounts;
    public static final int IMG_NEEDS_RGB_VECTOR_LENGTH = 4;
    public static int[] imgNeedsRGB;
    private static int openLib;
    public static final char PARAGRAPH_MARKER = '|';
    private static byte[] cachedFSM;
    public static byte[][] stateDescriptors;
    private static final byte HAS_ANIMATIONS = 1;
    private static final byte HAS_GRAPHICS = 2;
    public static final byte KEEP_WINDOW = 4;
    public static final byte KEEP_TIMERS = 8;
    public static final byte HAS_ENTRY = 16;
    public static final byte HAS_DO = 32;
    public static final byte HAS_EXIT = 64;
    public static final byte HAS_PARENT = -128;
    public static final short TYPE_ANIMATIONS = 0;
    public static final short TYPE_GRAPHICS = 1;
    public static final short TYPE_FLAGS = 2;
    public static final short TYPE_PARENT = 3;

    public static void openStreams() {
        try {
            for (int i = 0; i < 5; ++i) {
                CResManager.streams[i] = "".getClass().getResourceAsStream(RES_FILE_NAMES[i]);
                CResManager.currentOffset[i] = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CDebug.show("openStreams exception!");
        }
    }

    public static void openStream(int lib) {
        try {
            CResManager.streams[lib] = "".getClass().getResourceAsStream("/" + RES_FILE_NAMES[lib] + ".res");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (streams[lib] == null) {
            CDebug.show("Eroare la deschiderea streamului!");
        }
        CResManager.currentOffset[lib] = 0;
    }

    public static void closeStream(int lib) {
        try {
            if (streams[lib] != null) {
                streams[lib].close();
                CResManager.streams[lib] = null;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            CDebug.show("closeStream exception!");
        }
    }

    public static void closeStreams() {
        try {
            for (int i = 0; i < 5; ++i) {
                if (streams[i] == null) continue;
                streams[i].close();
                CResManager.streams[i] = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CDebug.show("closeStreams() exception!");
        }
    }

    public static byte[] getData(byte lib, int id) {
        if (data[lib] != null && data[lib][id] != null) {
            return data[lib][id];
        }
        boolean closeStream = false;
        if (streams[lib] == null) {
            CResManager.openStream(lib);
            closeStream = true;
        }
        if (header[lib] == null) {
            CResManager.cacheHeader(lib);
        }
        CResManager.cacheData(lib, -1);
        if (closeStream) {
            CResManager.closeStream(lib);
        }
        return data[lib][id];
    }

    public static int loadNext(byte lib) {
        switch (lib) {
            case 2: {
                if (header[2] == null) {
                    CResManager.cacheHeader(2);
                }
                for (int i = 0; i < elementIncrement[2] && CResManager.hasMoreElements(2); ++i) {
                    CResManager.cacheData((byte)2, indexes[2]);
                    if (CResManager.imageNeedsRGB(indexes[2])) {
                        CResManager.loadImage(indexes[2], true, null);
                    } else {
                        CResManager.loadImage(indexes[2], false, null);
                    }
                    CResManager.data[2][CResManager.indexes[2]] = null;
                    indexes[2] = indexes[2] + 1;
                }
                indexes[2] = indexes[2] - 1;
                break;
            }
            case 3: {
                if (header[3] == null) {
                    CResManager.cacheHeader(3);
                }
                for (int i = 0; i < elementIncrement[3] && CResManager.hasMoreElements(3); ++i) {
                    CResManager.cacheData((byte)3, indexes[3]);
                    indexes[3] = indexes[3] + 1;
                }
                indexes[3] = indexes[3] - 1;
                break;
            }
            case 1: {
                if (header[1] == null) {
                    CResManager.cacheHeader(1);
                }
                for (int i = 0; i < 13; ++i) {
                    CResManager.cacheData((byte)1, i);
                }
                new CSoundManager();
                CSoundManager.initVolumeValues();
                CSoundManager.initPlayers();
                CResManager.data[1] = null;
                CResManager.header[1] = null;
                break;
            }
            case 0: {
                try {
                    int type;
                    int length;
                    int bit;
                    int b = streams[0].read();
                    CDebug.show("No ctrl types: " + b);
                    int noCtrlTypes = b;
                    byteCounts = new short[noCtrlTypes];
                    for (int i = 0; i < noCtrlTypes; ++i) {
                        if ((i & 1) == 0) {
                            b = streams[0].read();
                        }
                        CResManager.byteCounts[i] = (short)(b >> ((i & 1) == 0 ? 4 : 0) & 0xF);
                    }
                    short[] buf = new short[6000];
                    int libCnt = streams[0].read() & 0xFF;
                    if ((libCnt |= (streams[0].read() & 0xFF) << 8) > 0) {
                        int ctrl = 0;
                        bit = 0;
                        length = 0;
                        short[][] controls = new short[libCnt][];
                        block19: for (ctrl = 0; ctrl < libCnt; ++ctrl) {
                            short byteRead = (short)streams[0].read();
                            type = byteRead >> 4 & 0xF;
                            controls[ctrl] = new short[byteCounts[type]];
                            length += controls[ctrl].length;
                            controls[ctrl][0] = byteRead;
                            for (int k = 1; k < controls[ctrl].length; ++k) {
                                controls[ctrl][k] = (short)streams[0].read();
                            }
                            switch (type) {
                                case 1: {
                                    short imageID = (short)Bitwise.read(10, controls[ctrl], 24);
                                    CResManager.markImageNeedsRGBArray(imageID);
                                    continue block19;
                                }
                            }
                        }
                        library = new short[length];
                        for (ctrl = 0; ctrl < libCnt; ++ctrl) {
                            System.arraycopy(controls[ctrl], 0, library, bit, controls[ctrl].length);
                            bit += controls[ctrl].length;
                        }
                    }
                    int noAni = streams[0].read();
                    hardcode = new short[noAni][][];
                    for (int i = 0; i < noAni; ++i) {
                        int nk = b = streams[0].read();
                        CResManager.hardcode[i] = new short[nk][];
                        CResManager.hardcode[i][0] = library;
                        for (int j = 0; j < nk; ++j) {
                            short[] descr = new short[3];
                            for (bit = 0; bit < descr.length; ++bit) {
                                descr[bit] = (short)streams[0].read();
                            }
                            int nc = descr[descr.length - 1];
                            int crt = 0;
                            block25: for (int k = 0; k < nc; ++k) {
                                buf[crt++] = (short)streams[0].read();
                                if ((buf[crt - 1] & 0x80) != 0) {
                                    buf[crt++] = (short)streams[0].read();
                                    buf[crt++] = (short)streams[0].read();
                                    continue;
                                }
                                type = buf[crt - 1] >> 4 & 0xF;
                                int pointer = crt - 1;
                                length = byteCounts[type] - 1;
                                for (bit = 0; bit < length; ++bit) {
                                    buf[crt++] = (short)streams[0].read();
                                }
                                switch (type) {
                                    case 1: {
                                        short imageID = (short)Bitwise.read(10, buf, pointer * 8 + 24);
                                        CResManager.markImageNeedsRGBArray(imageID);
                                        continue block25;
                                    }
                                }
                            }
                            CResManager.hardcode[i][j] = new short[crt + descr.length];
                            System.arraycopy(descr, 0, hardcode[i][j], 0, descr.length);
                            System.arraycopy(buf, 0, hardcode[i][j], descr.length, crt);
                        }
                    }
                    CResManager.indexes[0] = elementCount[0];
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                    CDebug.show("loadNext exception! lib: " + lib + " index: " + indexes[lib]);
                }
                break;
            }
            case 4: {
                if (cachedFSM != null) break;
                CResManager.cacheFSM();
                break;
            }
        }
        byte by = lib;
        int n = indexes[by] + 1;
        indexes[by] = n;
        return n;
    }

    public static boolean hasMoreElements(int library) {
        return indexes[library] < elementCount[library];
    }

    public static int getLibCount(int library) {
        return elementCount[library];
    }

    public static void loadImage(int image, boolean saveRGBArray, byte[] newPalette) {
        System.out.println("l img " + image);
        try {
            byte[] fontChunk = null;
            if (saveRGBArray) {
                CResManager.images[image] = CPNG.loadImage(CResManager.getData((byte)2, image), 0, 8, true, null);
                CResManager.rgbData[image] = CPNG.getRGBArray();
            } else {
                CResManager.images[image] = CPNG.loadImage(CResManager.getData((byte)2, image), 0, 0, false, newPalette);
                fontChunk = CPNG.getFontChunk();
                if (image == 1) {
                    CResManager.images[125] = CPNG.loadImage(CResManager.getData((byte)2, image), 1, 0, false, null);
                    CResManager.images[126] = CPNG.loadImage(CResManager.getData((byte)2, image), 2, 0, false, null);
                }
            }
            byte[] spriteChunk = CPNG.getSpriteChunk();
            if (spriteChunk != null) {
                CResManager.spriteData[image] = CResManager.loadSpriteChunk(spriteChunk);
            }
            if (fontChunk != null) {
                int currentFont;
                for (currentFont = 0; currentFont < 5 && image != CFontManager.FONT_IMAGES[currentFont]; ++currentFont) {
                }
                CFontManager.loadFontChunk(fontChunk, currentFont, 0);
            }
            CPNG.deallocate();
        }
        catch (Throwable t) {
            CDebug.setDebug("img " + image + " " + t);
        }
    }

    public static byte[][] loadSpriteChunk(byte[] data) {
        int startIndex = 0;
        int spriteNumber = data[startIndex++];
        byte[][] spriteBytes = new byte[spriteNumber][];
        for (int i = 0; i < spriteNumber; ++i) {
            byte tileCount = data[startIndex];
            int spriteLen = 4 + 8 * tileCount;
            spriteBytes[i] = new byte[spriteLen];
            for (int j = startIndex; j < startIndex + spriteLen; ++j) {
                spriteBytes[i][j - startIndex] = data[j];
            }
            startIndex += spriteLen;
        }
        return spriteBytes;
    }

    public static int getSpriteWidth(int imageIdx, int spriteIdx) {
        return (spriteData[imageIdx][spriteIdx][1] & 0xFF) << 4 | (spriteData[imageIdx][spriteIdx][2] & 0xF0) >> 4;
    }

    public static int getSpriteHeight(int imageIdx, int spriteIdx) {
        return (spriteData[imageIdx][spriteIdx][2] & 0xF) << 8 | spriteData[imageIdx][spriteIdx][3] & 0xFF;
    }

    public static int getSpriteImageId(int interfaceID) {
        return interfaceID & 0xFFFF;
    }

    public static int getSpriteId(int interfaceID) {
        return interfaceID >> 16 & 0xFFFF;
    }

    public static int getSpriteTrans(int trans) {
        switch (trans) {
            case 3: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 4: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 11: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 14: {
                return 5;
            }
        }
        return 0;
    }

    public static void markImageNeedsRGBArray(int imageId) {
        int n = imageId >> 5;
        imgNeedsRGB[n] = imgNeedsRGB[n] | 1 << (imageId & 0x1F);
    }

    public static boolean imageNeedsRGB(int imageId) {
        return (imgNeedsRGB[imageId >> 5] & 1 << (imageId & 0x1F)) != 0;
    }

    public static String getString(int stringID) {
        String str = new String(CResManager.getData((byte)3, stringID));
        return str;
    }

    public static byte[] getTextBytes(int id) {
        return CResManager.getData((byte)3, id);
    }

    public static byte getByte(int offset) {
        return CResManager.getData((byte)3, offset)[0];
    }

    public static int getFrameCount(int animation) {
        return hardcode[animation].length;
    }

    public static int getControlNumber(int animation, int frame) {
        if (hardcode[animation][frame] == null) {
            return 0;
        }
        return hardcode[animation][frame][2];
    }

    public static CControl getControl(int[] date) {
        int type = date[0];
        int left = date[1];
        int top = date[2];
        int z = date[date.length - 1];
        CControl c = null;
        switch (type) {
            case 0: {
                int image = date[3];
                byte spriteIndex = (byte)date[4];
                if (images[image] == null) {
                    CResManager.loadImage(image, false, null);
                    System.out.println("extraloading " + image);
                }
                if (spriteIndex >= 0) {
                    image |= spriteIndex + 1 << 16;
                }
                c = new CSprite((short)left, (short)top, image, (byte)z);
                break;
            }
            case 1: {
                int image = date[3];
                byte spriteIndex = (byte)date[4];
                if (spriteIndex >= 0) {
                    image |= spriteIndex + 1 << 16;
                }
                byte opacity = (byte)date[5];
                c = new CSprite((short)left, (short)top, image, opacity, (byte)z);
                break;
            }
            case 3: {
                int width = date[3];
                int height = date[4];
                byte font = (byte)date[5];
                byte alignment = (byte)date[6];
                c = new CLabel((short)left, (short)top, (short)width, (short)height, -1, font, alignment, (byte)z);
                break;
            }
            case 2: {
                int width = date[3];
                int height = date[4];
                c = new CColorRect((short)left, (short)top, (short)width, (short)height, 0xFF00FF);
                c.zDepth = (byte)z;
                break;
            }
        }
        return c;
    }

    public static void changeControlProps(CControl c, int[] date) {
        int type = date[0];
        int left = date[1];
        int top = date[2];
        int z = date[date.length - 1];
        switch (type) {
            case 0: {
                int image = date[3];
                byte spriteIndex = (byte)date[4];
                if (spriteIndex >= 0) {
                    image |= spriteIndex + 1 << 16;
                }
                ((CSprite)c).changeProps((short)left, (short)top, image, (byte)z);
                break;
            }
            case 1: {
                int image = date[3];
                byte spriteIndex = (byte)date[4];
                if (spriteIndex >= 0) {
                    image |= spriteIndex + 1 << 16;
                }
                byte opacity = (byte)date[5];
                ((CSprite)c).changeProps((short)left, (short)top, image, opacity, (byte)z);
                break;
            }
            case 3: {
                int width = date[3];
                int height = date[4];
                byte font = (byte)date[5];
                byte alignment = (byte)date[6];
                ((CLabel)c).changeProps((short)left, (short)top, (short)width, (short)height, -1, font, alignment, (byte)z);
                break;
            }
            case 2: {
                int width = date[3];
                int height = date[4];
                ((CColorRect)c).changeProps((short)left, (short)top, (short)width, (short)height, 0xFF00FF);
                c.zDepth = (byte)z;
                break;
            }
        }
    }

    public static int convertType(int t) {
        switch (t) {
            case 0: 
            case 1: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 4: 
            case 5: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        return -1;
    }

    public static int[] getControlDate(int animation, int frame, int index) {
        short[] info;
        int type;
        int newZ = -1;
        int realAni = animation;
        int offset = 3;
        for (int ctrl = 0; ctrl < index; ++ctrl) {
            if ((hardcode[realAni][frame][offset] & 0x80) != 0) {
                offset += 3;
                continue;
            }
            type = hardcode[realAni][frame][offset] >> 4;
            offset += byteCounts[type];
        }
        if ((hardcode[realAni][frame][offset] & 0x80) != 0) {
            int indLib = hardcode[realAni][frame][offset++] & 0xFFFFFF7F;
            indLib = indLib << 8 | hardcode[realAni][frame][offset] & 0xFF;
            int libOffset = 0;
            for (int i = 0; i < indLib; ++i) {
                type = library[libOffset] >> 4;
                libOffset += byteCounts[type];
            }
            type = library[libOffset] >> 4;
            info = new short[byteCounts[type]];
            System.arraycopy(library, libOffset, info, 0, info.length);
            newZ = hardcode[realAni][frame][offset + 1];
        } else {
            type = hardcode[realAni][frame][offset] >> 4;
            info = new short[byteCounts[type]];
            System.arraycopy(hardcode[realAni][frame], offset, info, 0, info.length);
        }
        int[] date = CResManager.unpack(info, type);
        if (newZ != -1) {
            date[date.length - 1] = newZ;
        }
        return date;
    }

    public static int[] getSpriteProps(int[] date) {
        int type = date[0];
        int left = date[1];
        int top = date[2];
        switch (type) {
            case 0: {
                int image = date[3];
                byte spriteIndex = (byte)date[4];
                if (spriteIndex >= 0) {
                    image |= spriteIndex + 1 << 16;
                }
                return new int[]{image, left, top};
            }
        }
        return null;
    }

    public static void isRead(InputStream is, byte[] buf) {
        try {
            for (int bytesRead = 0; bytesRead < buf.length; bytesRead += is.read(buf, bytesRead, buf.length - bytesRead)) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CDebug.show("isRead exception!");
        }
    }

    public static void cacheHeader(int lib) {
        try {
            CResManager.openStream(lib);
            int nItems = streams[lib].read() & 0xFF;
            CResManager.header[lib] = new int[nItems += (streams[lib].read() & 0xFF) << 8];
            byte[] buffer = new byte[4 * nItems];
            CResManager.isRead(streams[lib], buffer);
            int startOffset = 2 + 4 * nItems;
            for (int i = 0; i < nItems; ++i) {
                CResManager.header[lib][i] = startOffset + Bitwise.bytesToInt(buffer, i * 4, false);
            }
            CResManager.currentOffset[lib] = startOffset;
        }
        catch (Exception e) {
            CDebug.show("ERROR: cache header");
        }
    }

    public static void cacheData(byte lib, int index) {
        if (data[lib] == null) {
            CResManager.data[lib] = new byte[header[lib].length - 1][];
        }
        boolean allAtOnce = false;
        if (index == -1) {
            allAtOnce = true;
            index = 0;
        }
        do {
            CResManager.data[lib][index] = new byte[header[lib][index + 1] - header[lib][index]];
            if (currentOffset[lib] > header[lib][index]) {
                CResManager.closeStream(lib);
                CResManager.openStream(lib);
            }
            try {
                streams[lib].skip(header[lib][index] - currentOffset[lib]);
                CResManager.isRead(streams[lib], data[lib][index]);
            }
            catch (IOException ex) {
                CDebug.show("cacheData exception!");
            }
            CResManager.currentOffset[lib] = header[lib][index + 1];
        } while (++index < data[lib].length && allAtOnce);
        if (allAtOnce) {
            CResManager.header[lib] = null;
        }
    }

    public static int[] unpack(short[] bits, int type) {
        int[] rez = null;
        int offset = 0;
        switch (type) {
            case 0: {
                rez = new int[]{Bitwise.read(4, bits, offset), Bitwise.read(10, bits, offset += 4), Bitwise.read(10, bits, offset += 10), Bitwise.read(10, bits, offset += 10), Bitwise.read(8, bits, offset += 10), Bitwise.read(6, bits, offset += 8)};
                break;
            }
            case 1: {
                rez = new int[]{Bitwise.read(4, bits, offset), Bitwise.read(10, bits, offset += 4), Bitwise.read(10, bits, offset += 10), Bitwise.read(10, bits, offset += 10), Bitwise.read(8, bits, offset += 10), Bitwise.read(8, bits, offset += 8), Bitwise.read(6, bits, offset += 8)};
                break;
            }
            case 3: {
                rez = new int[]{Bitwise.read(4, bits, offset), Bitwise.read(10, bits, offset += 4), Bitwise.read(10, bits, offset += 10), Bitwise.read(9, bits, offset += 10), Bitwise.read(9, bits, offset += 9), Bitwise.read(5, bits, offset += 9), Bitwise.read(3, bits, offset += 5), Bitwise.read(6, bits, offset += 3)};
                break;
            }
            case 4: {
                rez = new int[]{Bitwise.read(4, bits, offset), Bitwise.read(10, bits, offset += 4), Bitwise.read(10, bits, offset += 10), Bitwise.read(10, bits, offset += 10), Bitwise.read(8, bits, offset += 10), Bitwise.read(6, bits, offset += 8)};
                break;
            }
            case 2: {
                rez = new int[]{Bitwise.read(4, bits, offset), Bitwise.read(10, bits, offset += 4), Bitwise.read(10, bits, offset += 10), Bitwise.read(9, bits, offset += 10), Bitwise.read(9, bits, offset += 9), Bitwise.read(6, bits, offset += 9)};
                break;
            }
            case 5: {
                rez = new int[]{Bitwise.read(4, bits, offset), Bitwise.read(10, bits, offset += 4), Bitwise.read(10, bits, offset += 10), Bitwise.read(9, bits, offset += 10), Bitwise.read(9, bits, offset += 9), Bitwise.read(4, bits, offset += 9), Bitwise.read(4, bits, offset += 4), Bitwise.read(8, bits, offset += 4), Bitwise.read(6, bits, offset += 8)};
                break;
            }
        }
        return rez;
    }

    public void precacheImages() {
        CResManager.cacheHeader(2);
        CResManager.cacheData((byte)2, -1);
        CResManager.closeStream(2);
        System.gc();
    }

    public static void cacheFSM() {
        CResManager.openStream(4);
        try {
            short len = (short)streams[4].read();
            len = (short)(len | (short)(streams[4].read() << 8));
            cachedFSM = new byte[len];
            CResManager.isRead(streams[4], cachedFSM);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        CResManager.closeStream(4);
    }

    public static void getStateDescriptors() {
        int offset = 0;
        int nrState = Bitwise.readShort(cachedFSM, offset);
        offset += 2;
        stateDescriptors = new byte[nrState][];
        for (int i = 0; i < nrState; ++i) {
            byte flags;
            int startOffset = offset;
            int nrbytes = 0;
            if (((flags = cachedFSM[offset++]) & 0xFFFFFF80) != 0) {
                offset += 2;
            }
            if ((flags & 1) != 0) {
                byte nrAnimations = cachedFSM[offset++];
                offset += nrAnimations;
            }
            if ((flags & 2) != 0) {
                short nrGfx = Bitwise.readShort(cachedFSM, offset);
                offset += 2;
                offset += nrGfx * 2;
            }
            nrbytes = offset - startOffset;
            CResManager.stateDescriptors[i] = new byte[nrbytes];
            System.arraycopy(cachedFSM, startOffset, stateDescriptors[i], 0, nrbytes);
        }
        cachedFSM = null;
        System.gc();
    }

    public static short[] getFSMResource(int state, int type) {
        short flags = stateDescriptors[state][0];
        if (type == 2) {
            return new short[]{flags};
        }
        int offset = 1;
        if ((flags & 0xFFFFFF80) != 0) {
            if (type == 3) {
                short[] rez = new short[]{Bitwise.readShort(stateDescriptors[state], offset)};
                return rez;
            }
            offset += 2;
        }
        if ((flags & 1) != 0) {
            int nrAnis = stateDescriptors[state][offset++];
            if (type == 0) {
                short[] rez = new short[nrAnis];
                for (int i = 0; i < nrAnis; ++i) {
                    rez[i] = stateDescriptors[state][i + offset];
                }
                return rez;
            }
            offset += nrAnis;
        }
        if ((flags & 2) != 0) {
            int nrGfx = Bitwise.readShort(stateDescriptors[state], offset);
            offset += 2;
            if (type == 1) {
                short[] rez = new short[nrGfx];
                for (int i = 0; i < nrGfx; ++i) {
                    rez[i] = Bitwise.readShort(stateDescriptors[state], 2 * i + offset);
                }
                return rez;
            }
            offset += 2 * nrGfx;
        }
        return new short[0];
    }

    public static boolean manageResources(short nextState) {
        int i;
        boolean ret = false;
        boolean keepImg = false;
        short[] data = CResManager.getFSMResource(nextState, 2);
        if ((data[0] & 4) != 0) {
            keepImg = true;
        }
        for (i = 0; i < neededImages.length; ++i) {
            CResManager.neededImages[i] = false;
        }
        short[] needed = CResManager.getFSMResource(0, 1);
        for (i = 0; i < needed.length; ++i) {
            CResManager.neededImages[needed[i]] = true;
        }
        needed = CResManager.getFSMResource(nextState, 1);
        for (i = 0; i < needed.length; ++i) {
            CResManager.neededImages[needed[i]] = true;
        }
        short[] parImg = CResManager.getFSMResource(nextState, 3);
        while (parImg.length > 0) {
            needed = CResManager.getFSMResource(parImg[0], 1);
            for (i = 0; i < needed.length; ++i) {
                CResManager.neededImages[needed[i]] = true;
            }
            parImg = CResManager.getFSMResource(parImg[0], 3);
        }
        for (i = 0; i < neededImages.length; ++i) {
            if (!keepImg && images[i] != null && !neededImages[i]) {
                CResManager.images[i] = null;
                continue;
            }
            if (ret || !neededImages[i] || images[i] != null) continue;
            ret = true;
        }
        return ret;
    }

    public static void initiateLoading() {
        imgPointer = 0;
        imgCount = 0;
        imgNumber = 0;
        for (int i = 0; i < neededImages.length; ++i) {
            if (!neededImages[i]) continue;
            if (images[i] == null) {
                imgNumber = (short)(imgNumber + 1);
                continue;
            }
            CResManager.neededImages[i] = false;
        }
    }

    public static boolean loadNextImage() {
        if (imgCount == imgNumber) {
            return false;
        }
        while (!neededImages[imgPointer]) {
            imgPointer = (short)(imgPointer + 1);
        }
        if (images[imgPointer] == null) {
            try {
                CResManager.loadImage(imgPointer, CResManager.imageNeedsRGB(imgPointer), null);
            }
            catch (Throwable e) {
                CWindowManager.debug = CWindowManager.debug + imgPointer;
            }
        }
        imgPointer = (short)(imgPointer + 1);
        imgCount = (short)(imgCount + 1);
        return true;
    }

    static {
        images = new Image[128];
        rgbData = new int[125][];
        spriteData = new byte[125][][];
        imgNeedsRGB = new int[4];
        openLib = -1;
    }
}

