/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CRect {
    int top;
    int left;
    int bottom;
    int right;

    public CRect(int left, int top, int right, int bottom) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public CRect(CRect rect) {
        this.top = rect.top;
        this.left = rect.left;
        this.bottom = rect.bottom;
        this.right = rect.right;
    }

    public CRect(Graphics g) {
        this.left = g.getClipX();
        this.right = this.left + g.getClipWidth();
        this.top = g.getClipY();
        this.bottom = this.top + g.getClipHeight();
    }

    public CRect(int imageIndex) {
        this.left = 0;
        this.top = 0;
        this.right = CResManager.images[imageIndex].getWidth();
        this.bottom = CResManager.images[imageIndex].getHeight();
    }

    public CRect(byte[] text, int fontID) {
        this.left = 0;
        this.top = 0;
        this.right = CFontManager.getStringLength(text, fontID);
        this.bottom = CFontManager.getFontHeight(fontID);
    }

    public CRect clone() {
        return new CRect(this);
    }

    public void move(int xOffset, int yOffset) {
        if (xOffset != 0) {
            this.left += xOffset;
            this.right += xOffset;
        }
        if (yOffset != 0) {
            this.bottom += yOffset;
            this.top += yOffset;
        }
    }

    public void moveTo(int x, int y) {
        this.right += x - this.left;
        this.bottom += y - this.top;
        this.left = x;
        this.top = y;
    }

    public void inflate(int dxSize, int dySize) {
        this.bottom += dySize;
        this.right += dxSize;
    }

    public void resize(int width, int height) {
        if (width >= 0) {
            this.right = this.left + width;
        }
        if (height >= 0) {
            this.bottom = this.top + height;
        }
    }

    public void resize(CRect newBounds) {
        this.left = newBounds.left;
        this.right = newBounds.right;
        this.top = newBounds.top;
        this.bottom = newBounds.bottom;
    }

    public void reset(Graphics g) {
        this.left = g.getClipX();
        this.right = this.left + g.getClipWidth();
        this.top = g.getClipY();
        this.bottom = this.top + g.getClipHeight();
    }

    public CRect zoom(int xOffset, int yOffset) {
        this.left -= xOffset;
        this.right += xOffset;
        this.top -= yOffset;
        this.bottom += yOffset;
        return this;
    }

    public int getWidth() {
        return this.right - this.left;
    }

    public int getHeight() {
        return this.bottom - this.top;
    }

    public boolean combine(CRect rect) {
        if (rect == null) {
            return false;
        }
        if (this.top < rect.top) {
            this.top = rect.top;
        }
        if (this.left < rect.left) {
            this.left = rect.left;
        }
        if (this.bottom > rect.bottom) {
            this.bottom = rect.bottom;
        }
        if (this.right > rect.right) {
            this.right = rect.right;
        }
        if (this.top > this.bottom) {
            this.bottom = this.top;
        }
        if (this.left > this.right) {
            this.right = this.left;
        }
        return this.getHeight() * this.getWidth() != 0;
    }

    public void copy(CRect r) {
        this.left = r.left;
        this.top = r.top;
        this.right = r.right;
        this.bottom = r.bottom;
    }

    public boolean intersect(CRect rect) {
        if (this.bottom <= rect.top) {
            return false;
        }
        if (this.top >= rect.bottom) {
            return false;
        }
        if (this.right <= rect.left) {
            return false;
        }
        return this.left < rect.right;
    }

    public boolean intersect(int left, int top, int right, int bottom) {
        if (this.bottom <= top) {
            return false;
        }
        if (this.top >= bottom) {
            return false;
        }
        if (this.right <= left) {
            return false;
        }
        return this.left < right;
    }

    public void expand(CRect rect) {
        if (this.top > rect.top) {
            this.top = rect.top;
        }
        if (this.left > rect.left) {
            this.left = rect.left;
        }
        if (this.bottom < rect.bottom) {
            this.bottom = rect.bottom;
        }
        if (this.right < rect.right) {
            this.right = rect.right;
        }
    }

    public void getClipRect(Graphics g) {
        this.left = g.getClipX();
        this.right = this.left + g.getClipWidth();
        this.top = g.getClipY();
        this.bottom = this.top + g.getClipHeight();
    }

    public void setClipRect(Graphics g) {
        g.setClip(0, 0, 240, 298);
        g.clipRect(this.left, this.top, this.getWidth(), this.getHeight());
    }

    public boolean combineClipRect(Graphics g) {
        g.clipRect(this.left, this.top, this.getWidth(), this.getHeight());
        return g.getClipWidth() * g.getClipHeight() != 0;
    }

    public void centerHorizontally(CRect rect, boolean relative) {
        int width1 = rect.right - rect.left;
        int width2 = this.right - this.left;
        this.left = (relative ? 0 : rect.left) + (width1 - width2) / 2;
        this.right = this.left + width2;
    }

    public void centerVertically(CRect rect, boolean relative) {
        int height1 = rect.bottom - rect.top;
        int height2 = this.bottom - this.top;
        this.top = (relative ? 0 : rect.top) + (height1 - height2) / 2;
        this.bottom = this.top + height2;
    }

    public void center(CRect rect, boolean relative) {
        this.centerHorizontally(rect, relative);
        this.centerVertically(rect, relative);
    }

    public void center(CRect rect) {
        this.centerHorizontally(rect, false);
        this.centerVertically(rect, false);
    }

    public final void alignLeft(CRect rect) {
        int width = this.right - this.left;
        this.left = rect.left;
        this.right = this.left + width;
    }

    public void alignRight(CRect rect) {
        int width = this.right - this.left;
        this.right = rect.right;
        this.left = this.right - width;
    }

    public void alignTop(CRect rect) {
        int height = this.bottom - this.top;
        this.top = rect.top;
        this.bottom = this.top + height;
    }

    public void alignBottom(CRect rect) {
        int height = this.bottom - this.top;
        this.bottom = rect.bottom;
        this.top = this.bottom - height;
    }

    public boolean isEqual(CRect rect) {
        return this.left == rect.left && this.top == rect.top && this.right == rect.right && this.bottom == rect.bottom;
    }

    public static boolean includes(short l1, short t1, short r1, short b1, short l2, short t2, short r2, short b2) {
        return l1 <= l2 && t1 <= t2 && r1 >= r2 && b1 >= b2;
    }

    public boolean includes(CRect r) {
        return this.left <= r.left && this.top <= r.top && this.right >= r.right && this.bottom >= r.bottom;
    }

    public boolean includes(int l, int t, int r, int b) {
        return this.left <= l && this.top <= t && this.right >= r && this.bottom >= b;
    }
}

