/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;

public final class CRMSManager {
    static final int RECORD_STORE_NUM = 1;
    static final int RECORD_UNIQUE_ID = 1;
    static final String RECORD_STORE_NAME = "AMAHON";
    static RecordStore recordStore;
    static final byte NO_SAVED_DATA = -1;
    static final int RECORD_NUM_OF_BYTES = 511;
    static byte rmsSoundsLevel;
    static byte rmsGeneralSettings;
    static byte[] rmsQuest;
    static byte[][] rmsPictures;
    static byte[][] rmsFamous;
    static byte[] rmsSniper1Scores;
    static byte[] rmsSniper2Scores;

    static void init() {
        try {
            recordStore = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            if (recordStore.getNumRecords() < 1) {
                byte[] recordTable = new byte[511];
                CRMSManager.reset();
                CRMSManager.store2RecordTable(recordTable);
                int n = recordStore.addRecord(recordTable, 0, 511);
            } else {
                CRMSManager.loadRecords();
            }
        }
        catch (Exception e) {
            CDebug.show("EXCEPTION : CRMSManager.init() : " + e.toString());
        }
    }

    static void reset() {
        int i;
        for (i = 0; i < rmsPictures.length; ++i) {
            CRMSManager.rmsPictures[i] = new byte[39];
            CRMSManager.rmsPictures[i][0] = -1;
        }
        rmsSoundsLevel = (byte)2;
        CSoundManager.volIndex = (byte)2;
        CSoundManager.changeVolumes(CSoundManager.volVal[CSoundManager.volIndex]);
        rmsGeneralSettings = 0;
        CFlags.isMinigameUnLocked = false;
        CRMSManager.resetQuest();
        for (i = 0; i < rmsFamous.length; ++i) {
            CRMSManager.rmsFamous[i] = new byte[10];
            CRMSManager.rmsFamous[i][0] = -1;
        }
        rmsSniper1Scores = new byte[6];
        for (i = 0; i < 6; ++i) {
            CRMSManager.rmsSniper1Scores[i] = 0;
        }
        rmsSniper2Scores = new byte[6];
        for (i = 0; i < 6; ++i) {
            CRMSManager.rmsSniper2Scores[i] = 0;
        }
    }

    static void resetQuest() {
        rmsQuest = new byte[57];
        CRMSManager.rmsQuest[0] = -1;
    }

    static byte[] getFamousName(int id) {
        byte[] name = new byte[8];
        System.arraycopy(rmsFamous[id], 0, name, 0, name.length);
        return name;
    }

    static int getFamousScore(int id) {
        byte[] score = new byte[2];
        System.arraycopy(rmsFamous[id], 8, score, 0, score.length);
        return (score[0] & 0xFF) + ((score[1] & 0xFF) << 8);
    }

    public static long bytesToLong(byte[] readInt, int startIdx) {
        long rez = 0L;
        for (int i = startIdx; i < startIdx + 8; ++i) {
            rez += (long)((readInt[i] & 0xFF) << (i - startIdx) * 8);
        }
        return rez;
    }

    static void loadRecords() {
        try {
            int j;
            int i;
            byte[] recordTable = recordStore.getRecord(1);
            int t = 0;
            rmsSoundsLevel = recordTable[t++];
            rmsGeneralSettings = recordTable[t++];
            rmsQuest = new byte[57];
            for (i = 0; i < rmsQuest.length; ++i) {
                CRMSManager.rmsQuest[i] = recordTable[t++];
            }
            for (i = 0; i < 10; ++i) {
                CRMSManager.rmsPictures[i] = new byte[39];
                for (j = 0; j < 39; ++j) {
                    CRMSManager.rmsPictures[i][j] = recordTable[t++];
                }
            }
            for (i = 0; i < 5; ++i) {
                CRMSManager.rmsFamous[i] = new byte[10];
                for (j = 0; j < 10; ++j) {
                    CRMSManager.rmsFamous[i][j] = recordTable[t++];
                }
            }
            rmsSniper1Scores = new byte[6];
            for (i = 0; i < rmsSniper1Scores.length; ++i) {
                CRMSManager.rmsSniper1Scores[i] = recordTable[t++];
            }
            rmsSniper2Scores = new byte[6];
            for (i = 0; i < rmsSniper2Scores.length; ++i) {
                CRMSManager.rmsSniper2Scores[i] = recordTable[t++];
            }
        }
        catch (Exception e) {
            CDebug.show("loadRecords : " + e.toString());
        }
    }

    static void saveRecords() {
        try {
            byte[] recordTable = new byte[511];
            CRMSManager.store2RecordTable(recordTable);
            recordStore.setRecord(1, recordTable, 0, 511);
        }
        catch (Exception e) {
            CDebug.show("saveRecords : " + e.toString());
        }
    }

    private static void store2RecordTable(byte[] recordTable) {
        int j;
        int i;
        int t = 0;
        recordTable[t++] = rmsSoundsLevel;
        recordTable[t++] = rmsGeneralSettings;
        for (i = 0; i < 57; ++i) {
            recordTable[t++] = rmsQuest[i];
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 39; ++j) {
                recordTable[t++] = rmsPictures[i][j];
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 10; ++j) {
                recordTable[t++] = rmsFamous[i][j];
            }
        }
        for (i = 0; i < 6; ++i) {
            recordTable[t++] = rmsSniper1Scores[i];
        }
        for (i = 0; i < 6; ++i) {
            recordTable[t++] = rmsSniper2Scores[i];
        }
    }

    private static int byte2int(int b, int p) {
        return (b & 0xFF) << p;
    }

    static {
        rmsPictures = new byte[10][];
        rmsFamous = new byte[5][];
    }
}

