/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public final class CPuzzle
extends CControl {
    private int SIZE;
    private static final int NO_SELECTION = -1;
    public static final byte STATE_DONE = 0;
    public static final byte STATE_SELECT_FIRST = 1;
    public static final byte STATE_SELECT_SECOND = 2;
    public static final byte STATE_INIT = 3;
    private static final int SELECTION_IMAGE = 118;
    private int[][] currentPuzzleArray;
    private int imgIndex;
    private byte puzzleState;
    private int currentSelection = -1;
    private int firstSelection = -1;
    private CSprite[] selectionGraphics;
    private int selectionTimer = -1;
    private int selectionState = 0;

    public CPuzzle(int imgIndex, int size) {
        super(null);
        int i;
        CRect bnd;
        this.SIZE = size;
        this.imgIndex = imgIndex;
        this.bounds = bnd = new CRect(0, 0, CResManager.images[imgIndex].getWidth(), CResManager.images[imgIndex].getHeight());
        this.puzzleState = (byte)3;
        this.currentPuzzleArray = new int[this.SIZE][this.SIZE];
        for (i = 0; i < this.SIZE * this.SIZE; ++i) {
            this.currentPuzzleArray[i / this.SIZE][i % this.SIZE] = i;
        }
        this.selectionGraphics = new CSprite[CResManager.spriteData[118].length];
        for (i = 0; i < this.selectionGraphics.length; ++i) {
            this.selectionGraphics[i] = new CSprite(0, 0, 118, 0);
            this.selectionGraphics[i].changeSprite((short)118, (short)i);
        }
    }

    public void paint(Graphics g, CRect forcedClip) {
        if (!this.isVisible) {
            return;
        }
        if (forcedClip == null) {
            g.setClip(this.bounds.left, this.bounds.top, this.bounds.getWidth(), this.bounds.getHeight());
        } else {
            g.setClip(this.bounds.left, this.bounds.top, this.bounds.getWidth(), this.bounds.getHeight());
            g.clipRect(forcedClip.left, forcedClip.top, forcedClip.getWidth(), forcedClip.getHeight());
        }
        g.setStrokeStyle(0);
        g.setColor(65280);
        for (int j = 0; j < this.SIZE; ++j) {
            for (int i = 0; i < this.SIZE; ++i) {
                g.drawRegion(CResManager.images[this.imgIndex], this.currentPuzzleArray[j][i] % this.SIZE * this.bounds.getWidth() / this.SIZE, this.currentPuzzleArray[j][i] / this.SIZE * this.bounds.getHeight() / this.SIZE, this.bounds.getWidth() / this.SIZE, this.bounds.getHeight() / this.SIZE, 0, this.bounds.left + i * this.bounds.getWidth() / this.SIZE, this.bounds.top + j * this.bounds.getHeight() / this.SIZE, 20);
                g.drawRect(i * this.bounds.getWidth() / this.SIZE, j * this.bounds.getHeight() / this.SIZE, this.bounds.getWidth() / this.SIZE, this.bounds.getHeight() / this.SIZE);
            }
        }
        if (this.firstSelection != -1) {
            int x = this.firstSelection % this.SIZE;
            int y = this.firstSelection / this.SIZE;
            g.setColor(0xFFFFFF);
            g.setStrokeStyle(1);
            int offset = this.selectionState % 6;
            g.drawLine(x * this.bounds.getWidth() / this.SIZE + 1 + offset, y * this.bounds.getHeight() / this.SIZE + 1, (x + 1) * this.bounds.getWidth() / this.SIZE - 1, y * this.bounds.getHeight() / this.SIZE + 1);
            g.drawLine((x + 1) * this.bounds.getWidth() / this.SIZE - 1, y * this.bounds.getHeight() / this.SIZE + 1 + offset, (x + 1) * this.bounds.getWidth() / this.SIZE - 1, (y + 1) * this.bounds.getHeight() / this.SIZE - 1);
            g.drawLine((x + 1) * this.bounds.getWidth() / this.SIZE - 1 - offset, (y + 1) * this.bounds.getHeight() / this.SIZE - 1, x * this.bounds.getWidth() / this.SIZE + 1, (y + 1) * this.bounds.getHeight() / this.SIZE - 1);
            g.drawLine(x * this.bounds.getWidth() / this.SIZE + 1, (y + 1) * this.bounds.getHeight() / this.SIZE - 1 - offset, x * this.bounds.getWidth() / this.SIZE + 1, y * this.bounds.getHeight() / this.SIZE + 1);
        }
        if (this.currentSelection != -1 && this.puzzleState != 0) {
            int start = this.selectionState % 4 < 2 ? 0 : 4;
            CRect oldClip = new CRect(g);
            for (int i = start; i < start + 4; ++i) {
                this.selectionGraphics[i].paint(g, oldClip);
            }
        }
    }

    public void switchPieces(int piece1, int piece2) {
        int temp = this.currentPuzzleArray[piece1 / this.SIZE][piece1 % this.SIZE];
        this.currentPuzzleArray[piece1 / this.SIZE][piece1 % this.SIZE] = this.currentPuzzleArray[piece2 / this.SIZE][piece2 % this.SIZE];
        this.currentPuzzleArray[piece2 / this.SIZE][piece2 % this.SIZE] = temp;
        this.notifyParent((byte)30);
    }

    public void scramblePuzzle() {
        for (int i = 0; i < this.SIZE * this.SIZE; ++i) {
            this.switchPieces((CAMARandom.getNextInt() & 0xFF) % (this.SIZE * this.SIZE), (CAMARandom.getNextInt() & 0xFF) % (this.SIZE * this.SIZE));
        }
    }

    public void processEvent(byte event) {
        if (event == 64) {
            ++this.selectionState;
            this.notifyParent((byte)30);
            return;
        }
        switch (this.puzzleState) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                int top = this.currentSelection / this.SIZE;
                int left = this.currentSelection % this.SIZE;
                switch (event) {
                    case 14: {
                        if (--left >= 0) break;
                        left = this.SIZE - 1;
                        break;
                    }
                    case 15: {
                        if (++left < this.SIZE) break;
                        left = 0;
                        break;
                    }
                    case 12: {
                        if (--top >= 0) break;
                        top = this.SIZE - 1;
                        break;
                    }
                    case 13: {
                        if (++top < this.SIZE) break;
                        top = 0;
                        break;
                    }
                    case 66: {
                        if (this.puzzleState == 1) {
                            this.firstSelection = this.currentSelection;
                            this.puzzleState = (byte)2;
                            break;
                        }
                        this.puzzleState = 1;
                        this.switchPieces(this.currentSelection, this.firstSelection);
                        this.firstSelection = -1;
                    }
                }
                this.currentSelection = top * this.SIZE + left;
                this.updateSelection();
                if (!this.isSolved()) break;
                this.stop();
                this.puzzleState = 0;
                break;
            }
        }
        this.notifyParent((byte)30);
    }

    private void updateSelection() {
        int left = this.currentSelection % this.SIZE;
        int top = this.currentSelection / this.SIZE;
        block6: for (int i = 0; i < this.selectionGraphics.length; ++i) {
            switch (i % 4) {
                case 0: {
                    this.selectionGraphics[i].bounds.moveTo(this.bounds.left + left * this.bounds.getWidth() / this.SIZE + (this.bounds.getWidth() / this.SIZE - this.selectionGraphics[i].bounds.getWidth()) / 2, this.bounds.top + (top + 1) * this.bounds.getHeight() / this.SIZE - this.selectionGraphics[i].bounds.getHeight());
                    continue block6;
                }
                case 1: {
                    this.selectionGraphics[i].bounds.moveTo(this.bounds.left + left * this.bounds.getWidth() / this.SIZE + 1, this.bounds.top + top * this.bounds.getHeight() / this.SIZE + (this.bounds.getHeight() / this.SIZE - this.selectionGraphics[i].bounds.getHeight()) / 2);
                    continue block6;
                }
                case 2: {
                    this.selectionGraphics[i].bounds.moveTo(this.bounds.left + left * this.bounds.getWidth() / this.SIZE + (this.bounds.getWidth() / this.SIZE - this.selectionGraphics[i].bounds.getWidth()) / 2, this.bounds.top + top * this.bounds.getHeight() / this.SIZE + 1);
                    continue block6;
                }
                case 3: {
                    this.selectionGraphics[i].bounds.moveTo(this.bounds.left + (left + 1) * this.bounds.getWidth() / this.SIZE - this.selectionGraphics[i].bounds.getWidth(), this.bounds.top + top * this.bounds.getHeight() / this.SIZE + (this.bounds.getHeight() / this.SIZE - this.selectionGraphics[i].bounds.getHeight()) / 2);
                    continue block6;
                }
            }
        }
    }

    public void registerEvents() {
        CEvents.setControlOnEvent(this, (byte)14);
        CEvents.setControlOnEvent(this, (byte)15);
        CEvents.setControlOnEvent(this, (byte)12);
        CEvents.setControlOnEvent(this, (byte)13);
        CEvents.setControlOnEvent(this, (byte)66);
        CEvents.setControlOnEvent(this, (byte)64);
    }

    public void unregisterEvents() {
        CEvents.removeControlFromEvent(this, (byte)14);
        CEvents.removeControlFromEvent(this, (byte)15);
        CEvents.removeControlFromEvent(this, (byte)12);
        CEvents.removeControlFromEvent(this, (byte)13);
        CEvents.removeControlFromEvent(this, (byte)66);
        CEvents.removeControlFromEvent(this, (byte)64);
    }

    public boolean isSolved() {
        for (int i = 0; i < this.SIZE * this.SIZE; ++i) {
            if (this.currentPuzzleArray[i / this.SIZE][i % this.SIZE] == i) continue;
            return false;
        }
        this.puzzleState = 0;
        return true;
    }

    public void start() {
        this.scramblePuzzle();
        if (this.selectionTimer != -1) {
            CTimers.killTimer(this.selectionTimer);
        }
        this.selectionTimer = CTimers.newTimer(150, 64, true);
        CTimers.startTimer(this.selectionTimer);
        this.selectionState = 0;
        this.registerEvents();
        this.puzzleState = 1;
        this.currentSelection = 0;
        this.updateSelection();
    }

    public void stop() {
        if (this.selectionTimer != -1) {
            CTimers.killTimer(this.selectionTimer);
            this.selectionTimer = -1;
        }
        this.unregisterEvents();
        this.currentSelection = -1;
        this.firstSelection = -1;
    }

    public byte getState() {
        return this.puzzleState;
    }
}

