/*
 * Decompiled with CFR 0.152.
 */
public class CAnimation {
    public static CController parent;
    static short[] currentFrames;
    static short[] maxFrames;
    static byte[] aniTimers;
    static short[] aniLoopFrames;
    static byte[] aniIndexes;
    static short[] aniLeft;
    static short[] aniTop;
    static byte[] frameIncrease;
    static short aniDirections;
    static short aniPause;
    static short aniFinished;
    static short aniStarted;
    static short aniDynamic;
    static short aniBlockPaint;
    static short aniBlockKeys;
    static short savedAniPause;
    private static byte[] vLabel;
    private static byte[] vSprite;
    private static byte[] vColorRect;
    private static byte[] vButton;
    static int aniNumber;
    static final int NA = -10;
    static int aniBlock;

    public static void initAnimationEngine(CController prt) {
        parent = prt;
        currentFrames = new short[10];
        maxFrames = new short[10];
        aniTimers = new byte[10];
        aniLoopFrames = new short[10];
        aniIndexes = new byte[10];
        aniLeft = new short[10];
        aniTop = new short[10];
        frameIncrease = new byte[10];
        vLabel = new byte[71];
        vSprite = new byte[71];
        vColorRect = new byte[71];
        vButton = new byte[71];
        CAnimation.vLabel[0] = 0;
        CAnimation.vSprite[0] = 0;
        CAnimation.vColorRect[0] = 0;
        CAnimation.vButton[0] = 0;
        aniDirections = 0;
        aniPause = 0;
        aniBlockPaint = 0;
        aniBlockKeys = 0;
        aniFinished = 0;
        aniStarted = 0;
        aniDynamic = 0;
        for (int i = 0; i < 10; ++i) {
            CAnimation.aniIndexes[i] = -10;
            CAnimation.aniTimers[i] = -10;
        }
        aniNumber = 0;
    }

    public static int startAnimation(byte anim, boolean reversed, boolean blockKeys) {
        return CAnimation.startAnimation(anim, 0, reversed, blockKeys);
    }

    public static int startAnimation(byte anim, int frame) {
        return CAnimation.startAnimation(anim, frame, false, true);
    }

    public static int startAnimation(byte anim) {
        return CAnimation.startAnimation(anim, 0, false, true);
    }

    public static int startAnimation(byte anim, int frame, int loopframe, boolean blockKeys) {
        int poz = CAnimation.startAnimation(anim, frame, false, blockKeys);
        CAnimation.aniLoopFrames[poz] = (short)loopframe;
        return poz;
    }

    public static int startAnimation(byte anim, int frame, boolean blockKeys) {
        int poz = CAnimation.startAnimation(anim, frame, false, blockKeys);
        return poz;
    }

    public static int startAnimation(byte ani, int frame, boolean reversed, boolean blockKeys) {
        int poz;
        System.out.println("starting ani " + ani);
        for (poz = 0; poz < 10 && aniIndexes[poz] != -10; ++poz) {
        }
        if (poz >= 10) {
            return -1;
        }
        CAnimation.frameIncrease[poz] = 1;
        CAnimation.aniIndexes[poz] = ani;
        CAnimation.maxFrames[poz] = (short)CResManager.getFrameCount(ani);
        CAnimation.currentFrames[poz] = (short)frame;
        CAnimation.aniLoopFrames[poz] = -10;
        aniDirections = !reversed ? (short)(aniDirections & ~(1 << poz)) : (short)(aniDirections | 1 << poz);
        aniPause = (short)(aniPause & ~(1 << poz));
        aniFinished = (short)(aniFinished & ~(1 << poz));
        aniStarted = (short)(aniStarted | 1 << poz);
        if (maxFrames[poz] > 1) {
            if (blockKeys) {
                aniBlockKeys = (short)(aniBlockKeys | 1 << poz);
                CWindowManager.setBlockKeys(true);
            } else {
                aniBlockKeys = (short)(aniBlockKeys & ~(1 << poz));
            }
            short time = CAnimation.getFrameTime(poz, 0);
            if (time > 0) {
                CAnimation.aniTimers[poz] = (byte)CTimers.newTimer((int)time, 50 + poz, false);
                CTimers.startTimer(aniTimers[poz]);
                aniDynamic = (short)(aniDynamic | 1 << poz);
            } else {
                CAnimation.aniTimers[poz] = -10;
            }
        } else {
            CAnimation.aniTimers[poz] = -10;
        }
        ++aniNumber;
        CAnimation.addAnimationControls(poz, currentFrames[poz]);
        return poz;
    }

    public static void setBlockPaintAnimation(int poz, boolean block) {
        if (poz == -10) {
            return;
        }
        if (block == ((aniBlockPaint & 1 << poz) != 0)) {
            return;
        }
        aniBlockPaint = block ? (short)(aniBlockPaint | 1 << poz) : (short)(aniBlockPaint & ~(1 << poz));
        CAnimation.refresh(poz);
    }

    public static boolean willBePainted(int poz) {
        return (aniBlockPaint & 1 << poz) == 0;
    }

    public static void pauseAnimation(int poz, boolean pause) {
        if (poz < 0) {
            return;
        }
        if (pause) {
            short time;
            aniPause = (short)(aniPause | 1 << poz);
            if (maxFrames[poz] > 1 && (time = CAnimation.getFrameTime(poz, 0)) > 0 && aniTimers[poz] >= 0) {
                CTimers.pauseTimer(aniTimers[poz]);
                aniDynamic = (short)(aniDynamic & ~(1 << poz));
            }
            short aniPausedBlock = aniBlockKeys;
            aniPausedBlock = (short)(aniPausedBlock & ~(1 << poz));
            for (int i = 0; i < aniNumber; ++i) {
                if (i == poz || (aniPause & 1 << i) == 0) continue;
                aniPausedBlock = (short)(aniPausedBlock & ~(1 << i));
            }
            if (aniPausedBlock == 0) {
                CWindowManager.setBlockKeys(false);
            }
        } else {
            CAnimation.onAniResume(aniIndexes[poz]);
            aniPause = (short)(aniPause & ~(1 << poz));
            if (maxFrames[poz] > 1) {
                short time = CAnimation.getFrameTime(poz, 0);
                if (time > 0 && aniTimers[poz] >= 0) {
                    CTimers.resumeTimer(aniTimers[poz]);
                    CTimers.resetTimer(aniTimers[poz]);
                    aniDynamic = (short)(aniDynamic | 1 << poz);
                }
                if ((aniBlockKeys & 1 << poz) != 0) {
                    CWindowManager.setBlockKeys(true);
                }
            }
        }
    }

    public static void reverseAnimation(int poz, boolean rev) {
        if (poz < 0) {
            return;
        }
        aniDirections = !rev ? (short)(aniDirections & ~(1 << poz)) : (short)(aniDirections | 1 << poz);
    }

    private static boolean getDirection(int poz) {
        return (aniDirections & 1 << poz) == 0;
    }

    private static CLabel getLabel(int poz, int index) {
        return (CLabel)CWindowManager.aniList[poz][vLabel[index + 1]];
    }

    private static CColorRect getColorRect(int poz, int index) {
        return (CColorRect)CWindowManager.aniList[poz][vColorRect[index + 1]];
    }

    private static CSprite getSprite(int poz, int index) {
        return (CSprite)CWindowManager.aniList[poz][vSprite[index + 1]];
    }

    public static void addAnimationControls(int poz, int frame) {
        int i;
        CAnimation.vLabel[0] = 0;
        CAnimation.vSprite[0] = 0;
        CAnimation.vColorRect[0] = 0;
        CAnimation.vButton[0] = 0;
        for (i = 0; i < aniNumber; ++i) {
            CAnimation.lock(i);
        }
        int n = CResManager.getControlNumber(aniIndexes[poz], frame);
        block7: for (i = 0; i < n; ++i) {
            CControl newControl;
            int[] date = CResManager.getControlDate(aniIndexes[poz], frame, i);
            if (i < CWindowManager.tops[poz]) {
                CControl oldControl = CWindowManager.aniList[poz][i];
                if (oldControl.type == CResManager.convertType(date[0])) {
                    oldControl.notifyParent((byte)70);
                    CResManager.changeControlProps(oldControl, date);
                    newControl = oldControl;
                    if (CAnimation.getLeft(poz) != 0 || CAnimation.getTop(poz) != 0) {
                        newControl.move(CAnimation.getLeft(poz), CAnimation.getTop(poz));
                    }
                    newControl.isVisible = true;
                    newControl.notifyParent((byte)30);
                } else {
                    newControl = CResManager.getControl(date);
                    CWindowManager.replaceInAni(oldControl, newControl, false);
                }
            } else {
                newControl = CResManager.getControl(date);
                CWindowManager.addTo(poz, newControl);
            }
            switch (newControl.type) {
                case 5: {
                    vLabel[0] = (byte)(vLabel[0] + 1);
                    CAnimation.vLabel[vLabel[0]] = newControl.indexInWindow;
                    continue block7;
                }
                case 3: {
                    vSprite[0] = (byte)(vSprite[0] + 1);
                    CAnimation.vSprite[vSprite[0]] = newControl.indexInWindow;
                    continue block7;
                }
                case 4: {
                    vColorRect[0] = (byte)(vColorRect[0] + 1);
                    CAnimation.vColorRect[vColorRect[0]] = newControl.indexInWindow;
                    continue block7;
                }
                case 2: {
                    vButton[0] = (byte)(vButton[0] + 1);
                    CAnimation.vButton[vButton[0]] = newControl.indexInWindow;
                    continue block7;
                }
            }
        }
        CWindowManager.removeFrom(i, poz);
        CWindowManager.removeLastStars(poz, CWindowManager.starTop[poz]);
        CAnimation.extraModifications(poz, frame);
        for (i = 0; i < aniNumber; ++i) {
            CAnimation.unLock(i);
        }
    }

    static int getPoz(int ani) {
        for (int poz = 0; poz < 10; ++poz) {
            if (aniIndexes[poz] != ani) continue;
            return poz;
        }
        return -10;
    }

    static int getLeft(int aniPoz) {
        if (aniPoz < 0) {
            return 0;
        }
        return aniLeft[aniPoz];
    }

    static int getTop(int aniPoz) {
        if (aniPoz < 0) {
            return 0;
        }
        return aniTop[aniPoz];
    }

    static short getFrameTime(int poz, int frame) {
        byte animID = aniIndexes[poz];
        short time = (short)((CResManager.hardcode[animID][frame][1] & 0xFF) << 8);
        time = (short)(time | (short)(CResManager.hardcode[animID][frame][0] & 0xFF));
        return time;
    }

    public static void continueAnimations() {
        for (int i = 0; i < aniNumber; ++i) {
            short time;
            int poz = i;
            if (poz < 0 || (aniPause & 1 << poz) != 0 || aniTimers[poz] == -10 || !CEvents.getEvent(CTimers.getEventOnTimer(aniTimers[poz]))) continue;
            CAnimation.aniTimers[poz] = -10;
            if (CAnimation.frameControl(poz) == -10) continue;
            if ((aniBlockKeys & 1 << poz) != 0) {
                CWindowManager.setBlockKeys(true);
            }
            if ((time = CAnimation.getFrameTime(poz, currentFrames[poz])) > 0) {
                CAnimation.aniTimers[poz] = (byte)CTimers.newTimer((int)time, 50 + poz, false);
                CTimers.startTimer(aniTimers[poz]);
                aniDynamic = (short)(aniDynamic | 1 << poz);
            } else {
                CAnimation.aniTimers[poz] = -10;
                aniDynamic = (short)(aniDynamic & ~(1 << poz));
            }
            CAnimation.addAnimationControls(poz, currentFrames[poz]);
        }
    }

    public static int frameControl(int poz) {
        CAnimation.currentFrames[poz] = (aniDirections & 1 << poz) == 0 ? (short)(currentFrames[poz] + frameIncrease[poz]) : (short)(currentFrames[poz] - frameIncrease[poz]);
        if (currentFrames[poz] >= maxFrames[poz] || currentFrames[poz] < 0) {
            if (aniLoopFrames[poz] != -10) {
                CAnimation.currentFrames[poz] = aniLoopFrames[poz];
            } else {
                CAnimation.onAniEnd(aniIndexes[poz], currentFrames[poz]);
                return -10;
            }
        }
        return 0;
    }

    public static void removeAllAnimations() {
        int i;
        if (aniNumber <= 0) {
            return;
        }
        for (i = 0; i < aniNumber; ++i) {
            for (int j = 0; j < CWindowManager.tops[i]; ++j) {
                CWindowManager.aniList[i][j] = null;
            }
            CWindowManager.tops[i] = 0;
        }
        for (i = 0; i < aniNumber; ++i) {
            CWindowManager.removeLastStars(i, CWindowManager.starTop[i]);
        }
        for (i = 0; i < 10; ++i) {
            CAnimation.aniIndexes[i] = -10;
        }
        for (i = 0; i < aniNumber; ++i) {
            if (aniTimers[i] < 0) continue;
            CTimers.killTimer(aniTimers[i]);
            CAnimation.aniTimers[i] = -10;
        }
        aniNumber = 0;
        aniBlockPaint = 0;
        aniBlockKeys = 0;
        aniPause = 0;
        aniFinished = 0;
        aniStarted = 0;
        aniDynamic = 0;
        CWindowManager.softKeyBar.setVisibleKeys(true);
        for (i = 0; i < aniLeft.length; ++i) {
            CAnimation.aniLeft[i] = 0;
            CAnimation.aniTop[i] = 0;
        }
    }

    public static void removeLastAnimations(int n) {
        if (n == 0) {
            return;
        }
        if (n >= aniNumber) {
            CAnimation.removeAllAnimations();
            return;
        }
        for (int i = aniNumber - n; i < aniNumber; ++i) {
            CAnimation.aniIndexes[i] = -10;
            if (aniTimers[i] >= 0) {
                CTimers.killTimer(aniTimers[i]);
            }
            aniStarted = (short)(aniStarted & ~(1 << i));
            aniFinished = (short)(aniFinished & ~(1 << i));
            aniPause = (short)(aniPause & ~(1 << i));
            aniBlockPaint = (short)(aniBlockPaint & ~(1 << i));
            aniBlockKeys = (short)(aniBlockKeys & ~(1 << i));
            aniDynamic = (short)(aniDynamic & ~(1 << i));
            CWindowManager.removeLastStars(i, CWindowManager.starTop[i]);
            CWindowManager.removeFrom(0, i);
        }
        aniNumber -= n;
        if (CWindowManager.blockKeys) {
            boolean isBlocked = false;
            for (int i = 0; i < aniNumber; ++i) {
                if ((aniBlockKeys & 1 << i) == 0 || (aniPause & 1 << i) != 0) continue;
                isBlocked = true;
                break;
            }
            if (!isBlocked) {
                CWindowManager.setBlockKeys(false);
            }
        }
    }

    public static void removeAnimation(int ani) {
        int poz = CAnimation.getPoz(ani);
        if (poz == 10 || poz == -10) {
            return;
        }
        if (aniTimers[poz] >= 0) {
            CTimers.killTimer(aniTimers[poz]);
            CAnimation.aniTimers[poz] = -10;
            aniDynamic = (short)(aniDynamic & ~(1 << poz));
        }
        CWindowManager.removeLastStars(poz, CWindowManager.starTop[poz]);
        CWindowManager.removeFrom(0, poz);
        for (int i = poz; i < aniNumber - 1; ++i) {
            CAnimation.aniIndexes[i] = aniIndexes[i + 1];
            CAnimation.aniTimers[i] = aniTimers[i + 1];
            CWindowManager.aniList[i] = CWindowManager.aniList[i + 1];
            CWindowManager.tops[i] = CWindowManager.tops[i + 1];
            CAnimation.frameIncrease[i] = frameIncrease[i + 1];
            CAnimation.maxFrames[i] = maxFrames[i + 1];
            CAnimation.currentFrames[i] = currentFrames[i + 1];
            CAnimation.aniLoopFrames[i] = aniLoopFrames[i + 1];
            CAnimation.aniLeft[i] = aniLeft[i + 1];
            CAnimation.aniTop[i] = aniTop[i + 1];
        }
        aniStarted = (short)((aniStarted & ~((1 << poz + 1) - 1)) >> 1 | aniStarted & (1 << poz) - 1);
        aniDynamic = (short)((aniDynamic & ~((1 << poz + 1) - 1)) >> 1 | aniDynamic & (1 << poz) - 1);
        aniFinished = (short)((aniFinished & ~((1 << poz + 1) - 1)) >> 1 | aniFinished & (1 << poz) - 1);
        aniDirections = (short)((aniDirections & ~((1 << poz + 1) - 1)) >> 1 | aniDirections & (1 << poz) - 1);
        aniPause = (short)((aniPause & ~((1 << poz + 1) - 1)) >> 1 | aniPause & (1 << poz) - 1);
        savedAniPause = (short)((savedAniPause & ~((1 << poz + 1) - 1)) >> 1 | savedAniPause & (1 << poz) - 1);
        aniBlock = (short)((aniBlock & ~((1 << poz + 1) - 1)) >> 1 | aniBlock & (1 << poz) - 1);
        aniBlockKeys = (short)((aniBlockKeys & ~((1 << poz + 1) - 1)) >> 1 | aniBlockKeys & (1 << poz) - 1);
        aniBlockPaint = (short)((aniBlockPaint & ~((1 << poz + 1) - 1)) >> 1 | aniBlockPaint & (1 << poz) - 1);
        CAnimation.aniIndexes[--CAnimation.aniNumber] = -10;
        CAnimation.aniTimers[CAnimation.aniNumber] = -10;
        CWindowManager.tops[CAnimation.aniNumber] = 0;
        CWindowManager.aniList[CAnimation.aniNumber] = null;
        CWindowManager.aniList[CAnimation.aniNumber] = new CControl[70];
        if (CWindowManager.blockKeys) {
            boolean isBlocked = false;
            for (int i = 0; i < aniNumber; ++i) {
                if ((aniBlockKeys & 1 << i) == 0 || (aniPause & 1 << i) != 0) continue;
                isBlocked = true;
                break;
            }
            if (!isBlocked) {
                CWindowManager.setBlockKeys(false);
            }
        }
    }

    public static void setXY(int aniPoz, short x, short y) {
        if (CAnimation.isLocked(aniPoz)) {
            return;
        }
        if (aniPoz < 0) {
            aniPoz = aniNumber;
        } else {
            for (int i = 0; i < CWindowManager.aniList[aniPoz].length; ++i) {
                if (CWindowManager.aniList[aniPoz][i] == null) continue;
                CWindowManager.aniList[aniPoz][i].move(x - aniLeft[aniPoz], y - aniTop[aniPoz]);
            }
            CAnimation.refresh(aniPoz);
        }
        CAnimation.aniLeft[aniPoz] = x;
        CAnimation.aniTop[aniPoz] = y;
    }

    private static void onAniResume(int ani) {
        int poz = CAnimation.getPoz(ani);
        switch (ani) {
            default: 
        }
    }

    private static void onAniEnd(int ani, int frame) {
        int poz = CAnimation.getPoz(ani);
        switch (ani) {
            case 1: {
                CAnimation.endSplash(poz, frame);
                break;
            }
            case 6: {
                CAnimation.endQuizScore(poz, frame);
                break;
            }
            case 8: {
                CAnimation.endQuestMapBullets(poz, frame);
                break;
            }
            case 9: {
                CAnimation.endFashion(poz, frame);
                break;
            }
            case 45: {
                CAnimation.endShopBuy(poz, frame);
                break;
            }
            case 55: {
                CAnimation.endEndScreen(poz, frame);
                break;
            }
            default: {
                CAnimation.currentFrames[poz] = 0;
                CAnimation.pauseAnimation(poz, true);
            }
        }
        aniFinished = (short)(aniFinished | 1 << poz);
        short aniPausedBlock = aniBlockKeys = (short)(aniBlockKeys & ~(1 << poz));
        for (int i = 0; i < aniNumber; ++i) {
            if ((aniPause & 1 << i) == 0) continue;
            aniPausedBlock = (short)(aniPausedBlock & ~(1 << i));
        }
        if (aniPausedBlock == 0) {
            CWindowManager.setBlockKeys(false);
        }
    }

    private static void extraModifications(int poz, int frame) {
        byte ani = aniIndexes[poz];
        switch (ani) {
            case 0: {
                CAnimation.emMenu(poz, frame);
                break;
            }
            case 1: {
                CAnimation.emSplash(poz, frame);
                break;
            }
            case 2: {
                CAnimation.emPopup(poz, frame);
                break;
            }
            case 3: {
                CAnimation.emTextscreen(poz, frame);
                break;
            }
            case 4: {
                CAnimation.emQuiz(poz, frame);
                break;
            }
            case 5: {
                CAnimation.emQuizSelect(poz, frame);
                break;
            }
            case 7: {
                CAnimation.emQuestMap(poz, frame);
                break;
            }
            case 8: {
                CAnimation.emQuestMapBullets(poz, frame);
                break;
            }
            case 9: {
                CAnimation.emFashion(poz, frame);
                break;
            }
            case 18: {
                CAnimation.emAmaLoading(poz, frame);
                break;
            }
            case 19: {
                CAnimation.emFashionSelect(poz, frame);
                break;
            }
            case 20: {
                CAnimation.emBeauty(poz, frame);
                break;
            }
            case 27: {
                CAnimation.emBeautySelect(poz, frame);
                break;
            }
            case 29: {
                CAnimation.emSchool(poz, frame);
                break;
            }
            case 30: {
                CAnimation.emMall(poz, frame);
                break;
            }
            case 31: {
                CAnimation.emParty(poz, frame);
                break;
            }
            case 32: {
                CAnimation.emDinner(poz, frame);
                break;
            }
            case 33: {
                CAnimation.emPopupGuy(poz, frame);
                break;
            }
            case 34: {
                CAnimation.emQuickMenu(poz, frame);
                break;
            }
            case 35: {
                CAnimation.emJuryMall(poz, frame);
                break;
            }
            case 36: {
                CAnimation.emJurySchool(poz, frame);
                break;
            }
            case 37: {
                CAnimation.emJuryDinner(poz, frame);
                break;
            }
            case 38: {
                CAnimation.emJuryParty(poz, frame);
                break;
            }
            case 39: {
                CAnimation.emStatus(poz, frame);
                break;
            }
            case 40: {
                CAnimation.emStatusBubles(poz, frame);
                break;
            }
            case 41: {
                CAnimation.emStatusStars(poz, frame);
                break;
            }
            case 42: {
                CAnimation.emPopupSmallLeft(poz, frame);
                break;
            }
            case 43: {
                CAnimation.emPopupSmallRight(poz, frame);
                break;
            }
            case 44: {
                CAnimation.emShop(poz, frame);
                break;
            }
            case 46: {
                CAnimation.emShopSelect(poz, frame);
                break;
            }
            case 47: {
                CAnimation.emNoLoading(poz, frame);
                break;
            }
            case 49: {
                CAnimation.emAdviserSelect(poz, frame);
                break;
            }
            case 50: {
                CAnimation.emAdviserSave(poz, frame);
                break;
            }
            case 51: {
                CAnimation.emSoundsQuickMenu(poz, frame);
                break;
            }
            case 52: {
                CAnimation.emCategory(poz, frame);
                break;
            }
            case 53: {
                CAnimation.emQuestName(poz, frame);
                break;
            }
            case 54: {
                CAnimation.emHallOfFame(poz, frame);
                break;
            }
            case 55: {
                CAnimation.emEndScreen(poz, frame);
                break;
            }
            case 57: {
                CAnimation.emMiniPopup(poz, frame);
                break;
            }
            case 58: {
                CAnimation.emSniperBkg(poz, frame);
                break;
            }
            case 59: {
                CAnimation.emSniperBand(poz, frame);
                break;
            }
            case 60: {
                CAnimation.emSniperShot(poz, frame);
                break;
            }
            case 63: {
                CAnimation.emPuzzleTimer(poz, frame);
                break;
            }
            case 64: {
                CAnimation.emMenuTooltip(poz, frame);
                break;
            }
            case 65: {
                CAnimation.emMinigameSelect(poz, frame);
                break;
            }
            case 66: {
                CAnimation.emIga(poz, frame);
                break;
            }
            case 67: {
                CAnimation.emGetMore(poz, frame);
                break;
            }
        }
    }

    static boolean areEqual(CControl c1, CControl c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.getClass() == c2.getClass();
    }

    static boolean lookAlike(CControl c1, CControl c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.getClass() != c2.getClass()) {
            return false;
        }
        return c1.type == 3 && ((CSprite)c1).imgIndex == ((CSprite)c2).imgIndex;
    }

    static boolean isPaused(byte ani) {
        int poz = CAnimation.getPoz(ani);
        if (poz < 0) {
            return false;
        }
        return (aniPause & 1 << poz) != 0;
    }

    static boolean isFinished(byte ani) {
        int poz = CAnimation.getPoz(ani);
        if (poz < 0) {
            return true;
        }
        return (aniFinished & 1 << poz) != 0;
    }

    static boolean isStarted(byte ani) {
        int poz = CAnimation.getPoz(ani);
        if (poz < 0) {
            return false;
        }
        return (aniStarted & 1 << poz) != 0;
    }

    public static void refresh(int poz) {
        for (int i = 0; i < CWindowManager.tops[poz]; ++i) {
            CWindowManager.aniList[poz][i].notifyParent((byte)30);
        }
    }

    public static void jumpTo(int poz, int frame) {
        CAnimation.currentFrames[poz] = (short)frame;
    }

    public static void instantJumpTo(int ani, int frame) {
        int poz = CAnimation.getPoz(ani);
        if (poz < 0) {
            return;
        }
        CAnimation.currentFrames[poz] = (short)frame;
        CAnimation.addAnimationControls(poz, frame);
    }

    public static boolean isLocked(int poz) {
        return (aniBlock & 1 << poz) != 0;
    }

    public static void lock(int poz) {
        aniBlock |= 1 << poz;
    }

    public static void unLock(int poz) {
        aniBlock &= ~(1 << poz);
    }

    public static boolean exists(int aniIndex) {
        for (int i = 0; i < aniNumber; ++i) {
            if (aniIndexes[i] != aniIndex) continue;
            return true;
        }
        return false;
    }

    public static CSprite findSpriteinAni(int poz, int image) {
        for (int i = 0; i < CWindowManager.tops[poz]; ++i) {
            CControl cs = CWindowManager.aniList[poz][i];
            if (cs.type != 3 || ((CSprite)cs).imgIndex != CResManager.getSpriteImageId(image) || ((CSprite)cs).spriteIndex != CResManager.getSpriteId(image) - 1) continue;
            return (CSprite)cs;
        }
        return null;
    }

    private static void emSplash(int poz, int frame) {
        CWindowManager.blockKeys = false;
    }

    private static void emMenu(int poz, int frame) {
        CSprite s1 = CAnimation.getSprite(poz, 3);
        CSprite s2 = CAnimation.getSprite(poz, 4);
        CSprite s3 = CAnimation.getSprite(poz, 5);
        if (frame <= 3) {
            if (CAnimation.getDirection(poz)) {
                if (frame < 3) {
                    s1.changeSprite(IConstants.MENU[CFlags.menu][CFlags.menuIDX][1]);
                    s2.changeSprite(IConstants.MENU[CFlags.menu][CFlags.menuIDX - 1 < 0 ? CFlags.menuIDX - 1 + IConstants.MENU[CFlags.menu].length : CFlags.menuIDX - 1][1]);
                    s3.changeSprite(IConstants.MENU[CFlags.menu][CFlags.menuIDX - 2 < 0 ? CFlags.menuIDX - 2 + IConstants.MENU[CFlags.menu].length : CFlags.menuIDX - 2][1]);
                } else {
                    s1.changeSprite(IConstants.MENU[CFlags.menu][(CFlags.menuIDX + 1) % IConstants.MENU[CFlags.menu].length][1]);
                    s2.changeSprite(IConstants.MENU[CFlags.menu][CFlags.menuIDX][1]);
                    s3.changeSprite(IConstants.MENU[CFlags.menu][CFlags.menuIDX - 1 < 0 ? CFlags.menuIDX - 1 + IConstants.MENU[CFlags.menu].length : CFlags.menuIDX - 1][1]);
                }
            } else if (frame < 3) {
                s1.changeSprite(IConstants.MENU[CFlags.menu][(CFlags.menuIDX + 1) % IConstants.MENU[CFlags.menu].length][1]);
                s2.changeSprite(IConstants.MENU[CFlags.menu][CFlags.menuIDX][1]);
                s3.changeSprite(IConstants.MENU[CFlags.menu][CFlags.menuIDX - 1 < 0 ? CFlags.menuIDX - 1 + IConstants.MENU[CFlags.menu].length : CFlags.menuIDX - 1][1]);
            } else {
                s1.changeSprite(IConstants.MENU[CFlags.menu][(CFlags.menuIDX + 2) % IConstants.MENU[CFlags.menu].length][1]);
                s2.changeSprite(IConstants.MENU[CFlags.menu][(CFlags.menuIDX + 1) % IConstants.MENU[CFlags.menu].length][1]);
                s3.changeSprite(IConstants.MENU[CFlags.menu][CFlags.menuIDX][1]);
            }
        } else {
            s1.changeSprite(IConstants.MENU[CFlags.menu][(CFlags.menuIDX + 1) % IConstants.MENU[CFlags.menu].length][1]);
            s2.changeSprite(IConstants.MENU[CFlags.menu][CFlags.menuIDX][1]);
            s3.changeSprite(IConstants.MENU[CFlags.menu][CFlags.menuIDX - 1 < 0 ? CFlags.menuIDX - 1 + IConstants.MENU[CFlags.menu].length : CFlags.menuIDX - 1][1]);
        }
        if (frame == maxFrames[poz] - 1) {
            CAnimation.pauseAnimation(poz, true);
            CLabel text = CAnimation.getLabel(poz, 0);
            text.changeText(IConstants.MENU[CFlags.menu][CFlags.menuIDX][0]);
            if (CAnimation.getPoz(64) != -10) {
                int timer = CTimers.getTimerByEvent((byte)60);
                if (timer != -1) {
                    CTimers.resetTimer(timer);
                    CTimers.startTimer(timer);
                } else {
                    CTimers.startTimer(CTimers.newTimer(2000, 60, false));
                }
            }
        }
        if (frame == 0 && !CAnimation.getDirection(poz)) {
            CAnimation.currentFrames[poz] = 3;
            CAnimation.reverseAnimation(poz, false);
        }
    }

    private static void endSplash(int poz, int frame) {
        parent.transitTo((short)4, (short)31);
    }

    private static void emPopup(int poz, int frame) {
        if (frame == maxFrames[poz] - 1) {
            if (CFlags.popupText == 74 || CFlags.popupText == 75) {
                int sc = CFlags.isInFirstSniper ? CGame.sniperPoints : CGame.sniperTime;
                byte[] text = CLabel.replaceString(CResManager.getTextBytes(CFlags.popupText), "%".getBytes(), (sc + "").getBytes());
                sc = CFlags.isInFirstSniper ? CGame.getLevelScore(CGame.sniper1Level, true) : CGame.getLevelScore(CGame.sniper2Level, false);
                text = CLabel.replaceString(text, "#".getBytes(), (sc + "").getBytes());
                CAnimation.getLabel(poz, 0).changeText(text);
            } else if (CFlags.popupText == 151) {
                byte[] text = CResManager.getTextBytes(CFlags.popupText);
                text = CLabel.replaceString(text, "#".getBytes(), CAnimation.parent.IGA_LINKS[CFlags.igaCurrentItem].getBytes());
                CAnimation.getLabel(poz, 0).changeText(text);
            } else {
                CAnimation.getLabel(poz, 0).changeText(CFlags.popupText);
            }
            CAnimation.getLabel(poz, 0).centerVertically();
            CWindowManager.makeStar(CAnimation.getLabel(poz, 0));
            CAnimation.pauseAnimation(poz, true);
            for (int i = 0; i < CWindowManager.tops[poz]; ++i) {
                if (CWindowManager.aniList[poz][i].type != 3 || ((CSprite)CWindowManager.aniList[poz][i]).imgIndex != 23) continue;
                CWindowManager.makeStar(CWindowManager.aniList[poz][i]);
            }
            byte ani = aniIndexes[poz];
            CWindowManager.getStar(ani, 1).setVisible(((CLabel)CWindowManager.getStar((int)ani, (int)0)).upArrow);
            CWindowManager.getStar(ani, 2).setVisible(((CLabel)CWindowManager.getStar((int)ani, (int)0)).downArrow);
            CAnimation.getSprite((int)poz, (int)0).transitionType = 0;
        } else {
            for (int i = 0; i < CWindowManager.tops[poz]; ++i) {
                if (CWindowManager.aniList[poz][i].type != 3) continue;
                ((CSprite)CWindowManager.aniList[poz][i]).transitionType = 1;
                ((CSprite)CWindowManager.aniList[poz][i]).transitionProgress = (byte)(frame * 100 / (maxFrames[poz] - 1));
            }
        }
        if (frame == 0 && !CAnimation.getDirection(poz)) {
            parent.quickTransitTo(CFlags.popupReturnState);
        }
    }

    private static void emMiniPopup(int poz, int frame) {
        if (frame == maxFrames[poz] - 1) {
            CAnimation.getLabel(poz, 0).changeText(CFlags.popupText);
            CAnimation.getLabel(poz, 0).centerVertically();
        }
    }

    private static void emTextscreen(int poz, int frame) {
        CLabel text = CAnimation.getLabel(poz, 0);
        text.changeText(CFlags.textScreenTextId);
        CWindowManager.makeStar(text);
        CSprite ar = CAnimation.getSprite(poz, 2);
        ar.setVisible(text.upArrow);
        CWindowManager.makeStar(ar);
        ar = CAnimation.getSprite(poz, 3);
        ar.setVisible(text.downArrow);
        CWindowManager.makeStar(ar);
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0xA30000;
    }

    private static void emQuiz(int poz, int frame) {
        CLabel atext;
        String s;
        CLabel qtext;
        if (frame == 5) {
            CGame.quizSavedAnswer = (byte)-1;
            CAnimation.pauseAnimation(CAnimation.getPoz(4), true);
            qtext = CAnimation.getLabel(poz, 0);
            qtext.font = 1;
            CLabel.textFind = "%/%".getBytes();
            s = CGame.quizCrtQuestionId + 1 + "/" + (CAnimation.parent.currentState == 7 ? 15 : 7);
            CLabel.textReplace = s.getBytes();
            qtext.changeText(CGame.quizQuestions[CGame.quizCrtQuestionId]);
            CWindowManager.makeStar(qtext);
            atext = CAnimation.getLabel(poz, 1);
            atext.font = (byte)4;
            atext.changeText(CGame.quizQuestions[CGame.quizCrtQuestionId] + 1 + CGame.quizCrtAnswer * 2);
            CWindowManager.makeStar(atext);
            CEvents.removeControlFromEvent(atext, (byte)12);
            CEvents.removeControlFromEvent(atext, (byte)13);
            CWindowManager.makeStar(CAnimation.findSpriteinAni(poz, 262173));
            CWindowManager.blockKeys = false;
            CAnimation.removeAnimation(5);
        }
        if (frame == 6) {
            CAnimation.pauseAnimation(CAnimation.getPoz(4), true);
            qtext = CAnimation.getLabel(poz, 1);
            qtext.font = (byte)4;
            CLabel.textFind = "%/%".getBytes();
            s = CGame.quizCrtQuestionId + 1 + "/" + (CAnimation.parent.currentState == 7 ? 15 : 7);
            CLabel.textReplace = s.getBytes();
            qtext.changeText(CGame.quizQuestions[CGame.quizCrtQuestionId]);
            CWindowManager.makeStar(qtext);
            CEvents.removeControlFromEvent(qtext, (byte)12);
            CEvents.removeControlFromEvent(qtext, (byte)13);
            atext = CAnimation.getLabel(poz, 0);
            atext.font = 1;
            atext.changeText(CGame.quizQuestions[CGame.quizCrtQuestionId] + 1 + CGame.quizCrtAnswer * 2);
            CWindowManager.makeStar(atext);
            CWindowManager.makeStar(CAnimation.findSpriteinAni(poz, 196637));
            CWindowManager.makeStar(CAnimation.findSpriteinAni(poz, 196633));
            int frm = CAnimation.parent.currentState == 7 ? CGame.quizCrtAnswer : 4;
            CAnimation.startAnimation((byte)5, frm);
        }
        if (frame > 6) {
            CLabel text = CAnimation.getLabel(poz, 0);
            text.changeText(CGame.quizQuestions[CGame.quizCrtQuestionId] + 1 + CGame.quizCrtAnswer * 2);
            text.font = (byte)((frame - 6) % 2 == 0 ? 1 : 4);
        }
        if (frame == maxFrames[poz] - 1) {
            if (CAnimation.parent.currentState == 17) {
                qtext = CAnimation.getLabel(poz, 1);
                qtext.font = (byte)4;
                CLabel.textFind = "%/%".getBytes();
                s = CGame.quizCrtQuestionId + 1 + "/" + (CAnimation.parent.currentState == 7 ? 15 : 7);
                CLabel.textReplace = s.getBytes();
                qtext.changeText(CGame.quizQuestions[CGame.quizCrtQuestionId]);
                CEvents.removeControlFromEvent(qtext, (byte)12);
                CEvents.removeControlFromEvent(qtext, (byte)13);
                CAnimation.removeAnimation(5);
                CAnimation.pauseAnimation(CAnimation.getPoz(4), true);
                int feedback = (CGame.quizQuestions[CGame.quizCrtQuestionId] - 436) / (2 * CGame.answersNb + 1) * CGame.answersNb + CGame.quizCrtAnswer + 786;
                CLabel text = CAnimation.getLabel(poz, 0);
                CWindowManager.makeStar(text);
                text.changeText(feedback);
                text.font = 1;
                CGame.quizCrtAnswer = 0;
                if (!CFlags.isComingFromLoad) {
                    CTimers.startTimer(CTimers.newTimer(500, 43, false));
                }
                CGame.quizSavedAnswer = (byte)CGame.quizCrtAnswer;
                CWindowManager.makeStar(CAnimation.findSpriteinAni(poz, 196633));
                CLabel label = (CLabel)CWindowManager.getStar(4, 0);
                ((CSprite)CWindowManager.getStar(4, 1)).setVisible(label.downArrow);
            }
            if (CAnimation.parent.currentState == 7) {
                CAnimation.findSpriteinAni(poz, 196633).setVisible(CAnimation.getLabel((int)poz, (int)0).downArrow);
                CGame.quizCrtAnswer = 0;
                if (++CGame.quizCrtQuestionId == CGame.questionsNb) {
                    int text = CGame.quizPoints < 11 ? 435 : (CGame.quizPoints < 21 ? 434 : 433);
                    parent.transitTxt(text, -1, (short)-1, 33, (short)6, (short)31);
                } else {
                    CAnimation.instantJumpTo(4, 5);
                }
            }
        }
    }

    private static void endQuizScore(int poz, int frame) {
        CEvents.setEvent(59);
    }

    private static void emQuizSelect(int poz, int frame) {
        CAnimation.pauseAnimation(poz, true);
    }

    private static void emQuestMap(int poz, int frame) {
        switch (frame) {
            case 0: 
            case 7: 
            case 14: 
            case 21: 
            case 28: {
                if (CAnimation.getDirection(poz)) break;
                CAnimation.reverseAnimation(poz, false);
                CFlags.questItemFlashLoops = (byte)(CFlags.questItemFlashLoops + 1);
                if (CFlags.questItemFlashLoops < 3 + (CFlags.questDestination == 0 ? 1 : 0)) break;
                CAnimation.pauseAnimation(poz, true);
                CTimers.startTimer(CTimers.newTimer(4000, 59, false));
                break;
            }
            case 1: 
            case 8: 
            case 15: 
            case 22: 
            case 29: {
                CAnimation.reverseAnimation(poz, true);
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 23: {
                CAnimation.pauseAnimation(poz, true);
                CAnimation.startAnimation((byte)8);
                break;
            }
            default: {
                CAnimation.removeAnimation(8);
            }
        }
        switch (frame) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                CAnimation.getLabel(poz, 0).changeText(16);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                CAnimation.getLabel(poz, 0).changeText(17);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                CAnimation.getLabel(poz, 0).changeText(18);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                CAnimation.getLabel(poz, 0).changeText(19);
                break;
            }
            case 28: 
            case 29: {
                CAnimation.getLabel(poz, 0).changeText(20);
                break;
            }
        }
    }

    private static void emQuestMapBullets(int poz, int frame) {
    }

    private static void endQuestMapBullets(int poz, int frame) {
        CAnimation.pauseAnimation(CAnimation.getPoz(7), false);
    }

    private static void emFashion(int poz, int frame) {
        CSprite cs;
        if ((CAnimation.parent.currentState == 10 || CAnimation.parent.currentState == 21) && (cs = CAnimation.findSpriteinAni(poz, 39)) != null) {
            cs.setVisible(false);
        }
        if (frame == maxFrames[poz] - 1 && (cs = CAnimation.findSpriteinAni(poz, 43)) != null) {
            CGirl.theGirl.setCloseViewMode(false);
            if (CAnimation.parent.currentState == 10) {
                CGirl.theGirl.setAvailableItems(IGirl.AVAILABLE_CHOOSE_AVATAR);
                CGirl.theGirl.setZDepth(IGirl.Z_CHOOSE_AVATAR);
                CGirl.theGirl.registerEvents((byte)66, (byte)68);
                if (CFlags.isComingBackInQuest) {
                    CGirl.theGirl.currentItem = CGirl.theGirl.availableItemTypes.length - 1;
                    CFlags.isComingBackInQuest = false;
                    CGirl.theGirl.updateSimpleArrows();
                }
            } else if (CAnimation.parent.currentState == 21) {
                CGirl.theGirl.setAvailableItems(IGirl.AVAILABLE_ADVISOR_CHOOSE_AVATAR);
                CGirl.theGirl.setZDepth(IGirl.Z_CHOOSE_AVATAR);
                CGirl.theGirl.registerEvents((byte)66, (byte)68);
            }
            switch (CAnimation.parent.currentState) {
                case 39: 
                case 43: {
                    CGirl.theGirl.setAvailableItems(new byte[]{3});
                    CGirl.theGirl.setZDepth(IGirl.Z_FASHION);
                    CGirl.theGirl.registerEvents((byte)13, (byte)12);
                    CAnimation.instantJumpTo(19, 8);
                    break;
                }
                case 40: 
                case 44: {
                    CGirl.theGirl.setAvailableItems(new byte[]{4});
                    CGirl.theGirl.setZDepth(IGirl.Z_FASHION);
                    CGirl.theGirl.registerEvents((byte)13, (byte)12);
                    CAnimation.instantJumpTo(19, 2);
                    break;
                }
                case 42: 
                case 46: {
                    CGirl.theGirl.setAvailableItems(new byte[]{5});
                    CGirl.theGirl.setZDepth(IGirl.Z_FASHION);
                    CGirl.theGirl.registerEvents((byte)13, (byte)12);
                    CAnimation.instantJumpTo(19, 4);
                    break;
                }
                case 41: 
                case 45: {
                    CGirl.theGirl.setAvailableItems(new byte[]{6});
                    CGirl.theGirl.setZDepth(IGirl.Z_FASHION);
                    CGirl.theGirl.registerEvents((byte)13, (byte)12);
                    CAnimation.instantJumpTo(19, 6);
                    break;
                }
            }
            CGirl.theGirl.handleZExceptions();
            CGirl.theGirl.moveTo(cs.bounds.left, cs.bounds.top);
            CWindowManager.replaceInAni(cs, CGirl.theGirl, true);
        }
    }

    private static void endFashion(int poz, int frame) {
        CEvents.setEvent(59);
    }

    private static void emAmaLoading(int poz, int frame) {
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0xFFFFFF;
        CAnimation.pauseAnimation(poz, true);
    }

    private static void emFashionSelect(int poz, int frame) {
        CAnimation.pauseAnimation(poz, true);
        if (frame == 9 || frame == 3 || frame == 5 || frame == 7) {
            CAnimation.getSprite(poz, 4).setVisible(CGirl.theGirl.wasPreviousItemPressed);
            CAnimation.getSprite(poz, 3).setVisible(!CGirl.theGirl.wasPreviousItemPressed);
        }
    }

    private static void emBeauty(int poz, int frame) {
        CSprite cs = CAnimation.findSpriteinAni(poz, 79);
        if (CGirl.theGirl != null && cs != null) {
            CGirl.theGirl.setCloseViewMode(true);
            CGirl.theGirl.registerEvents((byte)13, (byte)12);
            if (CAnimation.parent.currentState == 11) {
                CAnimation.startAnimation((byte)27);
                CGirl.theGirl.setAvailableItems(IGirl.AVAILABLE_CUSTOM_AVATAR);
                CGirl.theGirl.setZDepth(IGirl.Z_CUSTOM_AVATAR);
            } else if (CAnimation.parent.currentState == 13 || CAnimation.parent.currentState == 22) {
                CAnimation.startAnimation((byte)27);
                if (CFlags.isSecondScreen) {
                    CGirl.theGirl.setAvailableItems(IGirl.AVAILABLE_BEAUTY_2);
                } else {
                    CGirl.theGirl.setAvailableItems(IGirl.AVAILABLE_BEAUTY_1);
                }
                CGirl.theGirl.setZDepth(IGirl.Z_BEAUTY);
            }
            for (int i = 2; i < 7; ++i) {
                CGirl.theGirl.putItem(i, CGirl.theGirl.getItemID(i));
            }
            CGirl.theGirl.moveTo(cs.bounds.left, cs.bounds.top);
            CWindowManager.replaceInAni(cs, CGirl.theGirl, true);
        }
    }

    private static void emBeautySelect(int poz, int frame) {
        CAnimation.pauseAnimation(poz, true);
    }

    private static void replaceTheGirl(int poz) {
        CSprite cs = CAnimation.findSpriteinAni(poz, 43);
        if (CGirl.theGirl != null && cs != null) {
            CGirl.theGirl.setCloseViewMode(false);
            CGirl.theGirl.moveTo(cs.bounds.left, cs.bounds.top);
            CGirl.theGirl.setZDepth(IGirl.Z_FASHION);
            CGirl.theGirl.handleZExceptions();
            CGirl.theGirl.setAvailableItems(null);
            CGirl.theGirl.unregisterEvents();
            CWindowManager.replaceInAni(cs, CGirl.theGirl, true);
        }
    }

    private static void emSchool(int poz, int frame) {
        if (frame == maxFrames[poz] - 1) {
            CAnimation.replaceTheGirl(poz);
        }
    }

    private static void emMall(int poz, int frame) {
        if (frame == maxFrames[poz] - 1) {
            CAnimation.replaceTheGirl(poz);
        }
    }

    private static void emParty(int poz, int frame) {
        if (frame == maxFrames[poz] - 1) {
            CAnimation.replaceTheGirl(poz);
        }
    }

    private static void emDinner(int poz, int frame) {
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0xA30000;
        if (frame == maxFrames[poz] - 1) {
            CAnimation.replaceTheGirl(poz);
        }
    }

    private static void emPopupGuy(int poz, int frame) {
        CAnimation.emPopup(poz, frame);
    }

    private static void emQuickMenu(int poz, int frame) {
        CAnimation.pauseAnimation(poz, true);
        for (int i = 0; i < IConstants.MENU[3].length; ++i) {
            CAnimation.getLabel(poz, i).changeText(IConstants.MENU[3][i][0]);
            CWindowManager.makeStar(CAnimation.getLabel(poz, i));
        }
        CAnimation.getLabel((int)poz, (int)0).font = (byte)6;
    }

    private static void emJuryMall(int poz, int frame) {
        CAnimation.getLabel(poz, 0).changeText(("" + CGame.juryScore1).getBytes());
        CAnimation.getLabel(poz, 1).changeText(("" + CGame.juryScore2).getBytes());
    }

    private static void emJurySchool(int poz, int frame) {
        CAnimation.emJuryMall(poz, frame);
    }

    private static void emJuryDinner(int poz, int frame) {
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0xA30000;
        CAnimation.emJuryMall(poz, frame);
    }

    private static void emJuryParty(int poz, int frame) {
        CAnimation.emJuryMall(poz, frame);
    }

    private static void emStatus(int poz, int frame) {
        for (int i = 0; i < 5; ++i) {
            CLabel cl = CAnimation.getLabel(poz, i);
            CEvents.removeControlFromEvent(cl, (byte)12);
            CEvents.removeControlFromEvent(cl, (byte)13);
            cl.font = (byte)4;
        }
        CAnimation.getLabel(poz, 0).changeText(28);
        CLabel ctr = CAnimation.getLabel(poz, 1);
        CWindowManager.makeStar(ctr);
        ctr.changeText(("" + CGame.totalScore).getBytes());
        CAnimation.getLabel(poz, 2).changeText(123 + CGame.getStatus());
        CAnimation.getLabel(poz, 3).changeText(27);
        ctr = CAnimation.getLabel(poz, 4);
        CWindowManager.makeStar(ctr);
        ctr.changeText(("" + CGame.spendingPoints).getBytes());
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0xFFFFFF;
        CColorRect cr = CAnimation.getColorRect(poz, 1);
        cr.color1 = 0xFF0000;
        cr.notifyParent((byte)30);
        int scor = CAnimation.parent.currentState == 19 ? CGame.totalScore + (!CFlags.isScoreFinished ? CGame.destinationsScore[CFlags.questDestination - 1] : (short)0) : CGame.totalScore;
        int dy = scor == 0 ? 0 : (cr.bounds.bottom - cr.bounds.top) * 1000 / (113000 / scor);
        cr.bounds.top = cr.bounds.bottom - dy;
        cr.notifyParent((byte)30);
    }

    private static void emStatusBubles(int poz, int frame) {
        int i;
        if (CAnimation.parent.currentState == 19) {
            CFlags.pointsLevel = 0;
            for (i = 0; i < 6; ++i) {
                CWindowManager.makeStar(CAnimation.getSprite(poz, (CFlags.questDestination - 1) * 6 + i));
            }
        }
        block1: for (i = 0; i <= (CFlags.isScoreFinished && CAnimation.parent.currentState == 19 ? CFlags.questDestination - 1 : CFlags.questDestination - 1); ++i) {
            for (int j = 0; j < IGame.DEST_SCORE_LEVELS.length; ++j) {
                if (CGame.destinationsScore[i] < IGame.DEST_SCORE_LEVELS[IGame.DEST_SCORE_LEVELS.length - 1 - j]) continue;
                if (i < (CFlags.isScoreFinished ? CFlags.questDestination : CFlags.questDestination - 1)) {
                    int starpoz = i * 6;
                    for (int k = 0; k < 6 - j; ++k) {
                        int replaceStar = k % 2 == 0 ? 196622 : 393230;
                        CAnimation.getSprite(poz, k + starpoz).changeSprite(replaceStar);
                    }
                    continue block1;
                }
                CFlags.pointsLevel = 6 - j;
                continue block1;
            }
        }
    }

    private static void emStatusStars(int poz, int frame) {
        int status = CGame.getStatus();
        for (int i = 4; i >= status; --i) {
            CAnimation.getSprite(poz, i).setVisible(false);
        }
    }

    private static void emPopupSmallLeft(int poz, int frame) {
        if (frame == maxFrames[poz] - 1) {
            CLabel textControl = CAnimation.getLabel(poz, 0);
            byte[] text = null;
            text = CGame.hasPerfectOutfit ? CResManager.getTextBytes(CAMARandom.getNextInt() % 2 == 0 ? 91 : 92) : (CGame.bufferScore >= 14 ? CResManager.getTextBytes(93 + (CAMARandom.getNextInt() & 0xFF) % 5) : (CGame.bufferScore >= 7 ? CResManager.getTextBytes(98 + (CAMARandom.getNextInt() & 0xFF) % ((CFlags.questDestination == 4 ? 103 : 102) - 98 + 1)) : CResManager.getTextBytes(104 + (CAMARandom.getNextInt() & 0xFF) % 7)));
            text = CLabel.replaceString(text, "%".getBytes(), CResManager.getTextBytes(IConstants.GIRLS_NAMES[CGirl.theGirl.getItemID(0)]));
            text = CLabel.replaceString(text, "#".getBytes(), CResManager.getTextBytes(111 + CFlags.questDestination - 1));
            textControl.changeText(text);
            textControl.centerVertically();
            CWindowManager.makeStar(textControl);
            for (int i = 0; i < CWindowManager.tops[poz]; ++i) {
                if (CWindowManager.aniList[poz][i].type != 3 || ((CSprite)CWindowManager.aniList[poz][i]).imgIndex != 23) continue;
                CWindowManager.makeStar(CWindowManager.aniList[poz][i]);
            }
            byte ani = aniIndexes[poz];
            CWindowManager.getStar(ani, 1).setVisible(((CLabel)CWindowManager.getStar((int)ani, (int)0)).upArrow);
            CWindowManager.getStar(ani, 2).setVisible(((CLabel)CWindowManager.getStar((int)ani, (int)0)).downArrow);
            CAnimation.pauseAnimation(poz, true);
            CAnimation.reverseAnimation(poz, true);
        }
    }

    private static void emPopupSmallRight(int poz, int frame) {
        if (frame == maxFrames[poz] - 1) {
            CLabel textControl = CAnimation.getLabel(poz, 0);
            byte[] text = null;
            text = CGame.hairType == 0 ? CResManager.getTextBytes(121) : (CGame.hairType == 1 ? CResManager.getTextBytes(115 + (CAMARandom.getNextInt() & 0xFF) % 5) : (CFlags.questDestination == 4 ? CResManager.getTextBytes(120) : CResManager.getTextBytes(122)));
            text = CLabel.replaceString(text, "%".getBytes(), CResManager.getTextBytes(IConstants.GIRLS_NAMES[CGirl.theGirl.getItemID(0)]));
            text = CLabel.replaceString(text, "#".getBytes(), CResManager.getTextBytes(111 + CFlags.questDestination - 1));
            textControl.changeText(text);
            textControl.centerVertically();
            CWindowManager.makeStar(textControl);
            for (int i = 0; i < CWindowManager.tops[poz]; ++i) {
                if (CWindowManager.aniList[poz][i].type != 3 || ((CSprite)CWindowManager.aniList[poz][i]).imgIndex != 23) continue;
                CWindowManager.makeStar(CWindowManager.aniList[poz][i]);
            }
            byte ani = aniIndexes[poz];
            CWindowManager.getStar(ani, 1).setVisible(((CLabel)CWindowManager.getStar((int)ani, (int)0)).upArrow);
            CWindowManager.getStar(ani, 2).setVisible(((CLabel)CWindowManager.getStar((int)ani, (int)0)).downArrow);
            CAnimation.pauseAnimation(poz, true);
            CAnimation.reverseAnimation(poz, true);
        }
    }

    private static void emShop(int poz, int frame) {
        CSprite cs = null;
        if (frame >= 8) {
            CLabel price = CAnimation.getLabel(poz, 0);
            cs = CAnimation.findSpriteinAni(poz, 65588);
            CGame.crtShopItem = -1;
            CWindowManager.replaceInAni(cs, CGame.getShopNextItem(true), true);
            price.changeText(("" + CGame.getShopItemPrice()).getBytes());
        }
        if (frame == 9) {
            CAnimation.pauseAnimation(poz, true);
            CAnimation.getLabel(poz, 1).changeText(("Punkte: " + CGame.spendingPoints).getBytes());
            CWindowManager.makeStar(cs);
            CWindowManager.makeStar(CAnimation.getLabel(poz, 0));
            CWindowManager.makeStar(CAnimation.getLabel(poz, 1));
        }
    }

    private static void endShopBuy(int poz, int frame) {
        CAnimation.removeLastAnimations(1);
        CSprite cs = (CSprite)CWindowManager.getStar(44, 0);
        CLabel price = (CLabel)CWindowManager.getStar(44, 1);
        CLabel points = (CLabel)CWindowManager.getStar(44, 2);
        CGame.spendingPoints = (short)(CGame.spendingPoints - CGame.getShopItemPrice());
        CGame.setItemAvailable();
        CWindowManager.replaceInAni(cs, CGame.getShopNextItem(true), true);
        price.changeText(("" + CGame.getShopItemPrice()).getBytes());
        points.changeText(("Punkte: " + CGame.spendingPoints).getBytes());
        CWindowManager.setBlockKeys(false);
    }

    private static void emShopSelect(int poz, int frame) {
        if (frame == 2 || frame == 4 || frame == 7) {
            CAnimation.pauseAnimation(poz, true);
        }
        if (frame == 1 || frame == 3 || frame == 5) {
            CAnimation.pauseAnimation(poz, false);
        }
        if (frame == 7) {
            CAnimation.startAnimation((byte)45);
        }
    }

    private static void emNoLoading(int poz, int frame) {
        CLabel text = CAnimation.getLabel(poz, 0);
        text.bounds = new CRect(0, 0, CFontManager.getStringLength(CResManager.getTextBytes(55), text.font), CFontManager.getFontHeight(text.font));
        text.changeText(55);
        text.center();
        CColorRect rect = CAnimation.getColorRect(poz, 0);
        rect.color1 = -2130736965;
        rect.bounds.copy(text.bounds);
        rect.bounds.zoom(5, 5);
    }

    private static void emAdviserSelect(int poz, int frame) {
        if (frame == 0) {
            CAnimation.pauseAnimation(poz, true);
        }
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0;
        CAnimation.getLabel(poz, 0).changeText(16 + CFlags.adviserDestination);
        CSprite s = CAnimation.findSpriteinAni(poz, 65571);
        switch (CFlags.adviserDestination) {
            case 1: {
                s.changeSprite(frame == 0 ? 65571 : 131107);
                break;
            }
            case 2: {
                s.changeSprite(frame == 0 ? 327715 : 393251);
                break;
            }
            case 3: {
                s.changeSprite(frame == 0 ? 196643 : 262179);
                break;
            }
            case 4: {
                s.changeSprite(frame == 0 ? 589859 : 655395);
                break;
            }
        }
    }

    private static void emAdviserSave(int poz, int frame) {
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0;
        int labelsNumber = 0;
        for (int i = 0; i < CWindowManager.tops[poz]; ++i) {
            if (CWindowManager.aniList[poz][i].type != 5) continue;
            CWindowManager.makeStar(CWindowManager.aniList[poz][i]);
            CEvents.removeControlFromEvent(CWindowManager.aniList[poz][i], (byte)12);
            CEvents.removeControlFromEvent(CWindowManager.aniList[poz][i], (byte)13);
            ++labelsNumber;
        }
        if (labelsNumber >= 10) {
            CAnimation.findSpriteinAni(poz, 131097).setVisible(false);
            CAnimation.findSpriteinAni(poz, 196633).setVisible(false);
        }
    }

    private static void emSoundsQuickMenu(int poz, int frame) {
        CSprite back = CAnimation.findSpriteinAni(CAnimation.getPoz(34), 13);
        CAnimation.getSprite(poz, 0).centerHorizontally(back.bounds, false);
        CAnimation.getSprite(poz, 0).centerVertically(back.bounds, false);
    }

    private static void emQuestName(int poz, int frame) {
        CLabel cl = CAnimation.getLabel(poz, 0);
        cl.changeText(21 + CFlags.questDestination);
        CEvents.removeControlFromEvent(cl, (byte)12);
        CEvents.removeControlFromEvent(cl, (byte)13);
    }

    private static void emHallOfFame(int poz, int frame) {
        int namesNb;
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0;
        CFlags.newFamousPos = CFlags.isInQuest ? CGame.insertNewFamous(CGame.totalScore) : -1;
        for (namesNb = 0; namesNb < 5 && CRMSManager.rmsFamous[namesNb][0] != -1; ++namesNb) {
        }
        for (int i = 0; i < 5; ++i) {
            CLabel cl = CAnimation.getLabel(poz, i);
            CEvents.removeControlFromEvent(cl, (byte)12);
            CEvents.removeControlFromEvent(cl, (byte)13);
            byte[] name = i < namesNb ? CRMSManager.getFamousName(i) : CResManager.getTextBytes(48);
            cl.changeText(CGame.fillStringWithChar(name, cl.font, cl.bounds.getWidth(), '.'));
            cl = CAnimation.getLabel(poz, i + 5);
            CEvents.removeControlFromEvent(cl, (byte)12);
            CEvents.removeControlFromEvent(cl, (byte)13);
            cl.changeText((CRMSManager.getFamousScore(i) + "").getBytes());
            cl = CAnimation.getLabel(poz, i + 10);
            CEvents.removeControlFromEvent(cl, (byte)12);
            CEvents.removeControlFromEvent(cl, (byte)13);
            cl.changeText((i + 1 + ".").getBytes());
        }
        if (CFlags.newFamousPos != -1) {
            CLabel label = CAnimation.getLabel(poz, CFlags.newFamousPos);
            CWindowManager.makeStar(label);
            label.setVisible(false);
            CEditBox edit = new CEditBox(label.bounds, 4, 8, 5, true, 0);
            CEvents.removeControlFromEvent(edit, (byte)12);
            CEvents.removeControlFromEvent(edit, (byte)13);
            edit.setFocus(true);
            CWindowManager.addExtraControl(edit);
            CFlags.isInEditMode = true;
            CWindowManager.navigate = false;
            CAnimation.getLabel(poz, CFlags.newFamousPos + 5).changeText((CRMSManager.getFamousScore(CFlags.newFamousPos) + "").getBytes());
        }
    }

    private static void emSniperBkg(int poz, int frame) {
        CWindowManager.makeStar(CAnimation.getLabel(poz, 0));
        if (CFlags.isInFirstSniper) {
            CAnimation.getLabel(poz, 0).changeText((CGame.sniperPoints + "").getBytes());
        } else {
            CAnimation.getLabel(poz, 0).changeText((CGame.unhitTargets + "").getBytes());
        }
        CWindowManager.makeStar(CAnimation.getLabel(poz, 1));
        CAnimation.getLabel(poz, 1).changeText((CGame.sniperTime + "").getBytes());
    }

    private static void emSniperBand(int poz, int frame) {
        if (frame == 0) {
            if (CFlags.isInFirstSniper) {
                CGame.sniper1AddTgsGradually(CGame.sniperTargetsUp, false);
                CGame.sniper1AddTgsGradually(CGame.sniperTargetsDown, true);
                CGame.sniperAddBonus();
            } else if (CFlags.sniperFrameCount < 7) {
                CGame.sniper2AddTgsGradually(CGame.sniper2TargetsUp, false);
                CGame.sniper2AddTgsGradually(CGame.sniper2TargetsDown, true);
                CGame.sniper2ShiftTargets(CGame.sniper2InitialTargetsUp, false);
                CGame.sniper2ShiftTargets(CGame.sniper2InitialTargetsDown, true);
                ++CFlags.sniperFrameCount;
            } else if (CFlags.sniperFrameCount == 7) {
                CGame.sniper2TargetsUp = CGame.sniper2InitialTargetsUp;
                CGame.sniper2TargetsDown = CGame.sniper2InitialTargetsDown;
                CGame.sniper2ShiftTargets(CGame.sniper2TargetsUp, false);
                CGame.sniper2ShiftTargets(CGame.sniper2TargetsDown, true);
            } else {
                CGame.sniper2ShiftTargets(CGame.sniper2TargetsUp, false);
                CGame.sniper2ShiftTargets(CGame.sniper2TargetsDown, true);
            }
        }
        CAnimation.sniperChangeSprites(poz, CFlags.isInFirstSniper ? CGame.sniperTargetsUp : CGame.sniper2TargetsUp, CFlags.isInFirstSniper ? CGame.sniperTargetsDown : CGame.sniper2TargetsDown);
    }

    private static void emSniperShot(int poz, int frame) {
        switch (frame) {
            case 0: {
                int r = CAMARandom.getNextInt() % 2;
                CGame.sniperBullet = r == 0 ? 196715 : 131179;
                break;
            }
            case 1: {
                if (!CFlags.isInFirstSniper && CGame.unhitTargets == 0 && CFlags.sniperFrameCount != 0) {
                    int highScore = CGame.getLevelScore(CGame.sniper2Level, false);
                    if (CGame.sniperTime <= highScore || highScore == 0) {
                        if (CGame.sniper2Level == 2) {
                            parent.transitPopup((byte)28);
                        } else {
                            parent.transitPopup((byte)27);
                        }
                        CGame.setLevelScore(CGame.sniper2Level, false, CGame.sniperTime);
                        CRMSManager.saveRecords();
                    } else {
                        parent.transitPopup((byte)34);
                    }
                }
                CAnimation.pauseAnimation(poz, true);
                CGame.changeItems(CFlags.isInFirstSniper ? CGame.sniperTargetsDown : CGame.sniper2TargetsDown);
                CGame.changeItems(CFlags.isInFirstSniper ? CGame.sniperTargetsUp : CGame.sniper2TargetsUp);
                break;
            }
            case 3: {
                CAnimation.extModSniper(CFlags.isInFirstSniper ? CGame.sniperTargetsDown : CGame.sniper2TargetsDown, poz, true);
                break;
            }
            case 4: {
                boolean jumpOver;
                boolean bl = jumpOver = CFlags.isInFirstSniper ? CAnimation.extModSniper(CGame.sniperTargetsUp, poz, false) : CAnimation.extModSniper(CGame.sniper2TargetsUp, poz, false);
                if (!jumpOver) break;
                CAnimation.instantJumpTo(60, 5);
                break;
            }
        }
        if (CGame.sniperBullet == 131179) {
            CAnimation.getSprite(poz, 1).changeSprite(262251);
        }
    }

    private static void endEndScreen(int poz, int frame) {
        CAnimation.startAnimation((byte)56);
    }

    public static boolean extModSniper(int[] band, int poz, boolean down) {
        int bandPoz = CAnimation.getPoz(59);
        for (int i = 0; i < 7; ++i) {
            if (band[i] == -1 || band[i] == 65644 || band[i] == 262251 || band[i] != CGame.sniperBullet && (band[i] == 196715 || band[i] == 131179)) continue;
            int indexInBand = down ? 15 - i : i + 2;
            int x1 = CAnimation.getSprite((int)poz, (int)1).bounds.left;
            int x2 = CAnimation.getSprite((int)bandPoz, (int)indexInBand).bounds.left;
            if (CAMARandom.abs(x1 - x2) > 15L) continue;
            if (CFlags.isInFirstSniper) {
                int p = band[i] == 196715 || band[i] == 131179 ? 1 : 3;
                ((CLabel)CWindowManager.getStar(58, 0)).changeText(((CGame.sniperPoints += p) + "").getBytes());
            } else {
                ((CLabel)CWindowManager.getStar(58, 0)).changeText((--CGame.unhitTargets + "").getBytes());
            }
            if (CFlags.isInFirstSniper && CGame.sniperTime != 0 || !CFlags.isInFirstSniper && CGame.unhitTargets != 0) {
                band[i] = band[i] == 196715 ? 196714 : (band[i] == 131179 ? 65642 : 131178);
            } else if (band[i] == 196715) {
                band[i] = 65644;
            } else if (band[i] == 131179) {
                band[i] = 262251;
            }
            CAnimation.getSprite(bandPoz, indexInBand).changeSprite(band[i]);
            CAnimation.instantJumpTo(60, 0);
            return false;
        }
        return true;
    }

    public static void sniperChangeSprites(int poz, int[] tgUp, int[] tgDown) {
        for (int i = 0; i < 7; ++i) {
            if (tgUp[i] == -1) {
                CAnimation.getSprite(poz, i + 2).setVisible(false);
            } else {
                CAnimation.getSprite(poz, i + 2).changeSprite(tgUp[i]);
            }
            if (tgDown[i] == -1) {
                CAnimation.getSprite(poz, 15 - i).setVisible(false);
                continue;
            }
            CAnimation.getSprite(poz, 15 - i).changeSprite(tgDown[i]);
        }
    }

    private static void emEndScreen(int poz, int frame) {
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0xA30000;
        int t = 0;
        for (int i = 0; i < CWindowManager.tops[poz]; ++i) {
            if (CWindowManager.aniList[poz][i].type != 3 || ((CSprite)CWindowManager.aniList[poz][i]).imgIndex != 43) continue;
            CAnimation.parent.endScreenGirls[t].moveTo(CWindowManager.aniList[poz][i].bounds.left, CWindowManager.aniList[poz][i].bounds.top);
            CWindowManager.replaceInAni(CWindowManager.aniList[poz][i], CAnimation.parent.endScreenGirls[t++], true);
        }
    }

    private static void emPuzzleTimer(int poz, int frame) {
        if (frame == maxFrames[poz] - 1) {
            CWindowManager.makeStar(CAnimation.getLabel(poz, 0));
            CAnimation.getLabel(poz, 0).changeText(CGame.timeToString(CGame.puzzleTime));
            if (CGame.puzzleTime > 10) {
                CTimers.startTimer(CTimers.newTimer(4000, 65, false));
            }
        }
        if (frame == 0 || frame == maxFrames[poz] - 1) {
            CAnimation.pauseAnimation(poz, true);
        }
    }

    public static void updateMinigameSelect(int frame) {
        block0 : switch (frame) {
            case 0: {
                CWindowManager.getStar(65, 0).setVisible(CFlags.isInFirstSniper);
                CWindowManager.getStar(65, 1).setVisible(!CFlags.isInFirstSniper);
                break;
            }
            case 1: 
            case 2: {
                byte level = 0;
                level = CFlags.isPuzzleSelected ? CGame.puzzleLevel : (CFlags.isInFirstSniper ? CGame.sniper1Level : CGame.sniper2Level);
                switch (level) {
                    case 0: {
                        ((CColorRect)CWindowManager.getStar(65, 0)).setColor(0xCACACA);
                        ((CColorRect)CWindowManager.getStar(65, 1)).setColor(0xCACACA);
                        ((CLabel)CWindowManager.getStar(65, 2)).changeText(50);
                        break block0;
                    }
                    case 1: {
                        ((CColorRect)CWindowManager.getStar(65, 0)).setColor(0xFF0000);
                        ((CColorRect)CWindowManager.getStar(65, 1)).setColor(0xCACACA);
                        ((CLabel)CWindowManager.getStar(65, 2)).changeText(51);
                        break block0;
                    }
                    case 2: {
                        ((CColorRect)CWindowManager.getStar(65, 0)).setColor(0xFF0000);
                        ((CColorRect)CWindowManager.getStar(65, 1)).setColor(0xFF0000);
                        ((CLabel)CWindowManager.getStar(65, 2)).changeText(52);
                    }
                }
            }
        }
    }

    private static void emMinigameSelect(int poz, int frame) {
        CLabel cl;
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0;
        CAnimation.pauseAnimation(poz, true);
        if (frame == 0) {
            cl = CAnimation.getLabel(poz, 0);
            cl.changeText(46);
            CEvents.removeControlFromEvent(cl, (byte)12);
            CEvents.removeControlFromEvent(cl, (byte)13);
            cl = CAnimation.getLabel(poz, 1);
            cl.changeText(47);
            CEvents.removeControlFromEvent(cl, (byte)12);
            CEvents.removeControlFromEvent(cl, (byte)13);
            CWindowManager.makeStar(CAnimation.getSprite(poz, 1));
            CWindowManager.makeStar(CAnimation.getSprite(poz, 2));
            CAnimation.updateMinigameSelect(frame);
        }
        if (frame == 1) {
            cl = CAnimation.getLabel(poz, 0);
            cl.changeText(CFlags.isPuzzleSelected ? 15 : 46);
            CEvents.removeControlFromEvent(cl, (byte)12);
            CEvents.removeControlFromEvent(cl, (byte)13);
            int txte = CFlags.isPuzzleSelected ? 80 : 135;
            cl = CAnimation.getLabel(poz, 1);
            cl.changeText(txte);
            CAnimation.getColorRect((int)poz, (int)1).color1 = 0xFF0000;
            CAnimation.getColorRect((int)poz, (int)2).color1 = 0xCACACA;
            CAnimation.getColorRect((int)poz, (int)3).color1 = 0xCACACA;
            CWindowManager.makeStar(CAnimation.getColorRect(poz, 2));
            CWindowManager.makeStar(CAnimation.getColorRect(poz, 3));
            cl = CAnimation.getLabel(poz, 2);
            CWindowManager.makeStar(cl);
            CEvents.removeControlFromEvent(cl, (byte)12);
            CEvents.removeControlFromEvent(cl, (byte)13);
            CAnimation.updateMinigameSelect(frame);
            CWindowManager.makeStar(CAnimation.getLabel(poz, 1));
            CWindowManager.makeStar(CAnimation.getSprite(poz, 1));
            CWindowManager.makeStar(CAnimation.getSprite(poz, 2));
            CWindowManager.makeStar(CAnimation.getSprite(poz, 3));
            CWindowManager.makeStar(CAnimation.getSprite(poz, 4));
            parent.updateMinigameArrows();
        }
        if (frame == 2) {
            cl = CAnimation.getLabel(poz, 0);
            cl.changeText(47);
            CEvents.removeControlFromEvent(cl, (byte)12);
            CEvents.removeControlFromEvent(cl, (byte)13);
            cl = CAnimation.getLabel(poz, 1);
            cl.changeText(136);
            CAnimation.getColorRect((int)poz, (int)1).color1 = 0xFF0000;
            CAnimation.getColorRect((int)poz, (int)2).color1 = 0xCACACA;
            CAnimation.getColorRect((int)poz, (int)3).color1 = 0xCACACA;
            CWindowManager.makeStar(CAnimation.getColorRect(poz, 2));
            CWindowManager.makeStar(CAnimation.getColorRect(poz, 3));
            cl = CAnimation.getLabel(poz, 2);
            CWindowManager.makeStar(cl);
            CEvents.removeControlFromEvent(cl, (byte)12);
            CEvents.removeControlFromEvent(cl, (byte)13);
            CWindowManager.makeStar(CAnimation.getLabel(poz, 1));
            CWindowManager.makeStar(CAnimation.getSprite(poz, 1));
            CWindowManager.makeStar(CAnimation.getSprite(poz, 2));
            CWindowManager.makeStar(CAnimation.getSprite(poz, 3));
            CWindowManager.makeStar(CAnimation.getSprite(poz, 4));
            parent.updateMinigameArrows();
            CAnimation.updateMinigameSelect(frame);
        }
    }

    private static void emDifficulty(int poz, int frame) {
        CAnimation.pauseAnimation(poz, true);
    }

    private static void emMenuTooltip(int poz, int frame) {
        if (frame == 3 && CAnimation.isPaused((byte)CAnimation.getPoz(0))) {
            CAnimation.pauseAnimation(poz, true);
            CLabel text = CAnimation.getLabel(poz, 0);
            text.changeText(IConstants.MENU[CFlags.menu][CFlags.menuIDX][2]);
            text.centerVertically();
            CEvents.removeControlFromEvent(text, (byte)12);
            CEvents.removeControlFromEvent(text, (byte)13);
        } else if (frame == maxFrames[poz] - 1) {
            CAnimation.pauseAnimation(poz, true);
            CAnimation.currentFrames[poz] = 0;
        } else if (frame == 0) {
            CAnimation.pauseAnimation(poz, true);
        }
    }

    private static void emCategory(int poz, int frame) {
        CAnimation.getColorRect((int)poz, (int)0).color1 = 8127548;
    }

    private static void emIga(int poz, int frame) {
        CLabel text = CAnimation.getLabel(poz, 0);
        int[] nArray = CAnimation.parent.IGA_ITEMS[CFlags.igaCurrentItem];
        parent.getClass();
        text.changeText(nArray[1]);
        CWindowManager.makeStar(text);
        CSprite cSprite = CAnimation.findSpriteinAni(poz, 121);
        int[] nArray2 = CAnimation.parent.IGA_ITEMS[CFlags.igaCurrentItem];
        parent.getClass();
        cSprite.changeSprite(nArray2[0]);
        if (CAnimation.parent.IGA_ITEMS.length == 1) {
            CAnimation.findSpriteinAni(poz, 65578).setVisible(false);
            CAnimation.findSpriteinAni(poz, 131114).setVisible(false);
        }
        CSprite ar = CAnimation.findSpriteinAni(poz, 131097);
        ar.setVisible(text.upArrow);
        CWindowManager.makeStar(ar);
        ar = CAnimation.findSpriteinAni(poz, 196633);
        ar.setVisible(text.downArrow);
        CWindowManager.makeStar(ar);
        CAnimation.getColorRect((int)poz, (int)0).color1 = 0xA30000;
    }

    private static void emGetMore(int poz, int frame) {
    }

    static {
        aniBlock = 0;
    }
}

