/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class Entity {
    public static int touchMe = 1;
    public static final int ENTITY_FLAG_GIBBED = 65536;
    public static final int ENTITY_FLAG_TAKEDAMAGE = 131072;
    public static final int ENTITY_FLAG_ACTIVE = 262144;
    public static final int ENTITY_FLAG_GHOST = 524288;
    public static final int ENTITY_FLAG_LINKED = 0x100000;
    public static final int ENTITY_FLAG_HASFOUGHT = 0x200000;
    public static final int ENTITY_FLAG_DROPPED = 0x200000;
    public static final int ENTITY_FLAG_DIRTY = 0x400000;
    public static final int ENTITY_FLAG_CORPSE = 0x1000000;
    public static final int ENTITY_FLAG_DEATHFUNC = 0x2000000;
    public static final int ENTITY_FLAG_HURT = 0x4000000;
    public static final int ENTITY_FLAG_RAISETARGET = 0x8000000;
    public static final int ENTITY_FLAG_NOSNAP = 0x10000000;
    EntityDef def;
    EntityMonster monster;
    Entity nextOnTile;
    Entity prevOnTile;
    short linkIndex;
    short name;
    int info;
    int param;
    public static int HARBINGER_BLOOD_POOLX = 0;
    public static int HARBINGER_BLOOD_POOLY = 0;
    private static final int HARBINGER_HEAL_TURNS = 7;
    static final int DIR_BITS = 2;
    static final int NUM_DIRS = 4;
    static final int DIR_MASK = 3;
    static final int DIR_TABLE_SHIFT = 2;
    static final int PATH_BITS = 64;
    private static final int MAX_PATH_DEPTH = 8;
    private static final int MAX_DIST = 999999999;
    private static long curPath = 0L;
    private static int pathDepth = 0;
    private static int pathSearchDepth = 8;
    private static long closestPath = 0L;
    private static int closestPathDepth = 0;
    private static int closestPathDist = 999999999;
    private static final int LINE_OF_SIGHT_YES = 0;
    private static final int LINE_OF_SIGHT_NO = 1;
    private static final int LINE_OF_SIGHT_BOTH = 2;
    private static byte[] visitOrder = new byte[8];
    private static int[] visitDist = new int[8];
    private static int[] visitedTiles = new int[32];
    public static int[] baseVisitedTiles = new int[32];
    private static int lineOfSight = 2;
    private static int lineOfSightWeight = 0;
    private static Entity findEnt;
    private static Entity skipEnt;
    private static int interactClipMask;
    private static final int[] knockbackDelta;
    private static final int[] pos;
    private static int[] tempSaveBuf;

    Entity() {
    }

    public boolean hasHead() {
        return this.def.eType != 2 || this.def.eSubType != 4 || (this.monster.flags & 1) == 0;
    }

    public void reset() {
        this.def = null;
        this.prevOnTile = null;
        this.nextOnTile = null;
        this.linkIndex = 0;
        this.info = 0;
        this.param = 0;
        this.monster = null;
        this.name = (short)-1;
    }

    public void initspawn() {
        byte by = this.def.eType;
        byte by2 = this.def.eSubType;
        this.name = (short)(this.def.name | 0x800);
        int n = this.getSprite();
        int n2 = Render.mapSpriteInfo[n] & 0xFF;
        if (by == 2) {
            this.monster.ce = Combat.monsters[by2 * 3 + this.def.parm].clone();
            if (Game.difficulty == 4 || Game.difficulty == 2 && this.def.eSubType < 11) {
                int n3 = this.monster.ce.getStat(1);
                n3 += n3 >> 2;
                this.monster.ce.setStat(1, n3);
                this.monster.ce.setStat(0, n3);
            }
            short s = 0;
            int n4 = 64;
            Render.mapSprites[Render.S_Z + n] = (short)(32 + Render.getHeight(Render.mapSprites[Render.S_X + n], Render.mapSprites[Render.S_Y + n]));
            Render.relinkSprite(n);
            if (by2 == 8) {
                if (this.def.parm == 0) {
                    n4 = 50;
                } else if (this.def.parm == 1) {
                    n4 = 58;
                } else if (this.def.parm == 2) {
                    n4 = 66;
                }
            } else if (by2 == 10) {
                n4 = 88;
            }
            Render.mapSprites[Render.S_SCALEFACTOR + n] = n4;
            Render.mapSprites[Render.S_RENDERMODE + n] = s;
            this.info |= 0x20000;
        } else if (by == 7 && by2 != 3) {
            int n5 = n;
            Render.mapSpriteInfo[n5] = Render.mapSpriteInfo[n5] & 0xFFFEFFFF;
            if (n2 == 173) {
                Render.mapSprites[Render.S_SCALEFACTOR + n] = 32;
            }
        } else if (by == 6 && by2 == 2 && this.def.parm == 7) {
            Render.mapSprites[Render.S_SCALEFACTOR + n] = 32;
        } else if (by == 10) {
            this.info |= 0x20000;
        } else if (this.def.eType == 9 && this.def.eSubType == 15) {
            this.info |= 0x420000;
        } else if (by == 3) {
            this.param = 1;
        }
    }

    public int getSprite() {
        return (this.info & 0xFFFF) - 1;
    }

    public boolean touched() {
        byte by = this.def.eType;
        if (by == 11 || by == 6) {
            if (this.touchedItem()) {
                Game.scriptStateVars[11] = this.def.tileIndex;
                Game.executeStaticFunc(11);
                if (this.isDroppedEntity()) {
                    Render.mapSprites[Render.S_ENT + this.getSprite()] = -1;
                    this.def = null;
                }
                return true;
            }
        } else if (by == 8) {
            if (this.def.eSubType == 1 && Player.buffs[9] == 0) {
                Player.painEvent(null, false);
                Player.pain(20, this, true);
                Player.addStatusEffect(13, 5, 3);
                Player.translateStatusEffects();
            } else if (this.def.eSubType == 0) {
                Player.painEvent(null, false);
                Player.pain(20, this, true);
            }
            return true;
        }
        return false;
    }

    boolean touchedItem() {
        if (this.def.eSubType == 0 || this.def.eSubType == 6) {
            int n = 1;
            if (this.isDroppedEntity()) {
                n = this.param;
            }
            if (!Player.give(this.def.eSubType, this.def.parm, n, false)) {
                Text text = Hud.getMessageBuffer(2);
                Text.resetTextArgs();
                Text.addTextArg((short)2, this.def.name);
                Text.composeText((short)1, (short)85, text);
                Hud.finishMessageBuffer();
                return false;
            }
            Text.resetTextArgs();
            if (this.def.eSubType == 0 && (this.def.parm == 19 || this.def.parm == 20)) {
                Text text = Hud.getMessageBuffer(3);
                Text.composeText((short)1, (short)86, text);
                Hud.repaintFlags |= 4;
            } else {
                Text text = Hud.getMessageBuffer(1);
                Text.addTextArg((short)2, this.def.longName);
                Text.composeText((short)1, (short)87, text);
            }
            Hud.finishMessageBuffer();
            if (!this.isDroppedEntity() && this.def.parm != 18) {
                Game.foundLoot(this.getSprite(), 1);
            }
        } else if (this.def.eSubType == 4) {
            int n = this.def.parm == 0 || this.def.parm == 2 ? 40 : 20;
            if (!Player.addHealth(n)) {
                Hud.addMessage((short)45, 2);
                return false;
            }
        } else if (this.def.eSubType == 2) {
            int n = this.isDroppedEntity() ? this.param : 2 + App.nextInt() % 4;
            if (!Player.give(2, this.def.parm, n, false)) {
                Hud.addMessage((short)89);
            } else {
                Text text = Hud.getMessageBuffer(1);
                Text.resetTextArgs();
                Text.addTextArg(n);
                Text text2 = Text.getSmallBuffer();
                Text.composeTextField(this.name, text2);
                Text.addTextArg(text2);
                Text.composeText((short)1, (short)88, text);
                Hud.finishMessageBuffer();
                text2.dispose();
                if (!this.isDroppedEntity()) {
                    Game.foundLoot(this.getSprite(), 1);
                }
            }
        } else if (this.def.eSubType == 1) {
            Player.give(1, this.def.parm, 1, false);
            int n = this.def.parm * 9;
            if (Combat.weapons[n + 5] != 0) {
                if ((1L << this.def.parm & 0x600L) != 0L) {
                    Player.give(2, Combat.weapons[n + 4], 8, true);
                } else if (this.def.parm == 14) {
                    Player.give(2, Combat.weapons[n + 4], 100, true);
                } else {
                    Player.give(2, Combat.weapons[n + 4], 10, true);
                }
            }
            Text text = Hud.getMessageBuffer(1);
            Text.resetTextArgs();
            Text.addTextArg((short)2, this.def.longName);
            Text.composeText((short)1, (short)87, text);
            Hud.finishMessageBuffer();
            Player.showWeaponHelp(this.def.parm, false);
            if (!this.isDroppedEntity()) {
                Game.foundLoot(this.getSprite(), 1);
            }
        }
        Game.remove(this);
        Sound.playSound(8);
        return true;
    }

    public boolean pain(int n, Entity entity) {
        boolean bl = false;
        int n2 = this.getSprite();
        if ((this.info & 0x20000) == 0) {
            return bl;
        }
        if (this.def.eType == 2) {
            int n3 = this.monster.ce.getStat(0);
            int n4 = this.monster.ce.getStat(1);
            if ((this.monster.flags & 4) != 0 && (n3 -= n) <= 0) {
                n3 = 1;
            }
            if (this.def.eSubType >= 11 && this.def.eSubType <= 14) {
                int n5 = n4 >> 1;
                int n6 = n5 >> 1;
                int n7 = n4 - n6;
                if (n3 <= n7 && n3 + n > n7) {
                    boolean bl2 = bl = Game.executeStaticFunc(2) != 0;
                    if (n3 < n5) {
                        n3 = n5 + 1;
                    }
                } else if (n3 <= n5 && n3 + n > n5) {
                    boolean bl3 = bl = Game.executeStaticFunc(3) != 0;
                    if (n3 < n6) {
                        n3 = n6 + 1;
                    }
                } else if (n3 <= n6 && n3 + n > n6) {
                    boolean bl4 = bl = Game.executeStaticFunc(4) != 0;
                }
                if (bl && (this.monster.flags & 0x20) != 0) {
                    Combat.animLoopCount = 1;
                }
            }
            this.monster.ce.setStat(0, n3);
            if (n3 > 0) {
                if ((Combat.punchingMonster == 0 || Combat.curTarget.def.eSubType == 10) && 0 == (this.monster.monsterEffects & 2)) {
                    Render.mapSpriteInfo[n2] = Render.mapSpriteInfo[n2] & 0xFFFF00FF | 0x6000;
                    this.monster.frameTime = App.time + 250;
                }
                if (this.def.eSubType == 14 && this.monster.goalType == 6) {
                    this.monster.frameTime = Integer.MAX_VALUE;
                } else {
                    this.monster.resetGoal();
                }
                if (n3 < n4 >> 1 && this.def.eSubType == 2 && 0 == (this.monster.monsterEffects & 2) && (App.nextInt() & 3) == 0) {
                    Text.resetTextArgs();
                    Text text = Text.getSmallBuffer();
                    Text.composeTextField(this.name, text);
                    Text.addTextArg(text);
                    Hud.addMessage((short)90);
                    text.dispose();
                    this.monster.resetGoal();
                    this.monster.goalType = (byte)4;
                    this.monster.goalParam = (short)(2 + (App.nextInt() & 0xFF) % 3);
                }
            } else if (0 == (this.monster.monsterEffects & 2)) {
                Render.mapSpriteInfo[n2] = Render.mapSpriteInfo[n2] & 0xFFFF00FF | 0x6000;
                if (Combat.animLoopCount > 0) {
                    this.monster.frameTime = App.time + 250;
                }
                this.monster.frameTime = Combat.punchingMonster != 0 ? Combat.animEndTime + 200 : App.time + 250 + 200;
                Render.chatZoom = false;
            }
        } else if (this.isExplodableEntity()) {
            short s = Render.mapSprites[Render.S_X + n2];
            short s2 = Render.mapSprites[Render.S_Y + n2];
            short s3 = Render.mapSprites[Render.S_Z + n2];
            if (!Game.isUnderWater()) {
                Game.gsprite_allocAnim(234, s, s2, s3);
            }
            GameSprite gameSprite = Game.gsprite_allocAnim(242, s, s2, s3);
            gameSprite.flags |= 0x800;
            gameSprite.data = this;
            Game.unlinkEntity(this);
            ++Game.animatingEffects;
        } else if (this.def.eType == 10) {
            byte by = this.def.eSubType;
            if (by == 3) {
                Render.mapSpriteInfo[n2] = Render.mapSpriteInfo[n2] & 0xFFFF00FF | 0x100;
                this.param = App.getUpTimeMs() + 200;
            } else if (by == 1) {
                ParticleSystem.spawnParticles(2, -8826361, n2);
                Game.remove(this);
            } else if (by == 8) {
                ParticleSystem.spawnParticles(1, -1, n2);
                this.died(false, entity);
            } else if (by == 7) {
                boolean bl5 = true;
                if (Combat.curTarget == this && (1L << Player.ce.weapon & 0x7F0L) != 0L) {
                    ++this.param;
                    boolean bl6 = bl5 = this.param > 2;
                }
                if (bl5) {
                    ParticleSystem.spawnParticles(2, -8826361, n2);
                    Game.remove(this);
                    this.info |= 0x400000;
                    int n8 = n2;
                    Render.mapSpriteInfo[n8] = Render.mapSpriteInfo[n8] | 0x10000;
                }
            } else {
                if (by == 5 || by == 0) {
                    ParticleSystem.spawnParticles(2, -8826361, n2);
                } else {
                    if (by == 10 || by == 11) {
                        ParticleSystem.spawnParticles(1, -1, n2);
                        Game.unlinkEntity(this);
                        Render.mapSpriteInfo[n2] = Render.mapSpriteInfo[n2] & 0xFFFF00FF | 0x200;
                        this.info |= 0x400000;
                        return bl;
                    }
                    if (by == 9) {
                        ParticleSystem.spawnParticles(1, -7267291, n2);
                    }
                }
                Game.remove(this);
                this.info |= 0x400000;
                int n9 = n2;
                Render.mapSpriteInfo[n9] = Render.mapSpriteInfo[n9] | 0x10000;
            }
        }
        return bl;
    }

    public void checkMonsterDeath(boolean bl) {
        if (this.monster != null && (this.monster.flags & 0x80) == 0) {
            int n;
            Player.fillMonsterStats();
            int[] nArray = Player.monsterStats;
            if (bl) {
                n = this.monster.ce.calcXP();
                if (this.def.eSubType >= 11) {
                    n += 130;
                }
                Player.addXP(n);
            }
            if (nArray[0] == nArray[1] && (Player.killedMonstersLevels & 1 << Canvas.loadMapID - 1) == 0) {
                Player.giveStandardMedal(Canvas.loadMapID, 2);
                n = Player.calcLevelXP(Player.level) - Player.calcLevelXP(Player.level - 1) >> 4;
                Player.addXP(n);
                Player.killedMonstersLevels |= 1 << Canvas.loadMapID - 1;
            }
        }
    }

    public void died(boolean bl, Entity entity) {
        int n = this.getSprite();
        short s = Render.mapSprites[Render.S_X + n];
        short s2 = Render.mapSprites[Render.S_Y + n];
        int n2 = Render.mapSpriteInfo[n];
        if ((this.info & 0x20000) == 0 || this.monster != null && (this.monster.flags & 4) != 0) {
            return;
        }
        this.info &= 0xFFFDFFFF;
        byte by = this.def.eType;
        byte by2 = this.def.eSubType;
        if (this.isExplodableEntity()) {
            if (Canvas.state == 1) {
                Canvas.setState(3);
            }
            int n3 = 40;
            if (by == 14 && by2 == 6) {
                byte by3 = Combat.weapons[99];
                byte by4 = Combat.weapons[100];
                n3 = by3 + ((by4 - by3) * App.nextByte() >> 8);
            }
            --Game.animatingEffects;
            Sound.playSound(10);
            if (!Game.isCameraActive()) {
                Combat.hurtEntityAt(s >> 6, s2 >> 6, s >> 6, s2 >> 6, 0, n3, this, true);
                Combat.radiusHurtEntities(s >> 6, s2 >> 6, 1, n3 / 2, this);
            }
            Game.executeTile(s >> 6, s2 >> 6, 20468, true);
            n2 |= 0x10000;
            Game.remove(this);
            this.info = this.isDroppedEntity() ? (this.info &= 0xFFBFFFFF) : (this.info |= 0x400000);
            if (by == 10) {
                Game.destroyedObject(n);
            }
            Canvas.startShake(500, 4, 500);
        } else if (by == 10) {
            Text.resetTextArgs();
            Text text = Text.getSmallBuffer();
            Text.composeTextField(this.name, text);
            Text.addTextArg(text);
            Hud.addMessage((short)91);
            text.dispose();
            Player.addXP(5);
            if (by2 == 3) {
                this.info |= 0x400000;
                Game.unlinkEntity(this);
            } else if (by2 == 8) {
                this.dropChickenPlate(entity);
                Game.remove(this);
                this.info |= 0x400000;
                n2 |= 0x10000;
            }
            if (this.def.eSubType != 8 && this.def.eSubType != 10) {
                Game.destroyedObject(n);
            }
        } else if (by == 9) {
            n2 |= 0x10000;
            this.info |= 0x410000;
            this.info &= 0xFFF7FFFF;
            if (null != this.monster) {
                this.monster.monsterEffects = 0;
            }
            Player.counters[4] = Player.counters[4] + 1;
            Game.unlinkEntity(this);
        } else if (by == 2) {
            int n4;
            int n5;
            this.info |= 0x400000;
            this.monster.resetGoal();
            Game.snapLerpSprites(this.getSprite());
            n2 = n2 & 0xFFFF00FF | 0x7000;
            this.monster.frameTime = App.time;
            if ((this.info & 0x10000) != 0) {
                n2 |= 0x10000;
            } else {
                this.info |= 0x1020000;
                this.trimCorpsePile(s, s2);
            }
            if (0 != (this.monster.monsterEffects & 2) || 0 != (this.monster.monsterEffects & 1)) {
                this.monster.clearEffects();
            } else {
                this.monster.monsterEffects = (short)(this.monster.monsterEffects & 0xFFFF801F);
                this.monster.monsterEffects = (short)(this.monster.monsterEffects | 0x28A0);
            }
            if (Game.difficulty == 4 && (this.monster.flags & 0x40) == 0) {
                n5 = 2 + App.nextInt() % 3;
                this.monster.monsterEffects = (short)(this.monster.monsterEffects & 0xFFFFF9FB);
                this.monster.monsterEffects = (short)(this.monster.monsterEffects | n5 << 9);
                this.monster.monsterEffects = (short)(this.monster.monsterEffects | 4);
            }
            Game.deactivate(this);
            this.undoAttack();
            if (by2 >= 11 && by2 <= 14) {
                Player.inCombat = false;
                Game.executeStaticFunc(5);
            } else if (by2 == 9) {
                Game.gsprite_allocAnim(192, s, s2, Render.mapSprites[Render.S_Z + n]);
                n2 |= 0x10000;
            } else if (by2 == 10) {
                n2 |= 0x10000;
            }
            this.checkMonsterDeath(bl);
            if ((this.info & 0x10000) != 0 || by2 == 9 || by2 == 10) {
                this.info = this.info & 0xFEFDFFFF | 0x10000;
                Game.unlinkEntity(this);
            }
            this.def = EntityDef.find(9, by2, this.def.parm);
            this.name = (short)(this.def.name | 0x800);
            if (bl && (this.monster.flags & 0x80) == 0 && (this.info & 0x2000000) == 0 && (this.info & 0x80000) == 0) {
                if (by2 == 10) {
                    this.dropChickenPlate(entity);
                } else {
                    this.dropItem(0);
                }
            }
            Canvas.invalidateRect();
            n5 = this.getIndex();
            int[] nArray = Game.placedBombs;
            for (n4 = 0; n4 < 4; ++n4) {
                if (nArray[n4] == 0) continue;
                Entity entity2 = Game.entities[nArray[n4]];
                int n6 = (entity2.param & 0x7FFFFF00) >> 8;
                if (n6 == 0 || n6 != n5) continue;
                int n7 = entity2.getSprite();
                Render.mapSprites[Render.S_Z + n7] = (short)(Render.getHeight(Render.mapSprites[Render.S_X + n7], Render.mapSprites[Render.S_Y + n7]) + 32);
            }
            if (Game.difficulty == 4 && (this.monster.flags & 0x40) == 0 && (this.info & 0x80000) == 0) {
                n4 = 2 + App.nextInt() % 3;
                this.monster.monsterEffects = (short)(this.monster.monsterEffects | n4 << 9);
                this.monster.monsterEffects = (short)(this.monster.monsterEffects | 4);
            } else if ((this.info & 0x80000) != 0) {
                n2 |= 0x10000;
                this.info |= 0x410000;
                this.info &= 0xFFF7FFFF;
                Player.counters[4] = Player.counters[4] + 1;
                Game.unlinkEntity(this);
                GameSprite gameSprite = Game.gsprite_allocAnim(192, Render.mapSprites[Render.S_X + n], Render.mapSprites[Render.S_Y + n], Render.mapSprites[Render.S_Z + n] - 20);
                gameSprite.flags |= 0x400;
                gameSprite.startScale = (byte)96;
                gameSprite.destScale = (byte)127;
                gameSprite.scaleStep = 38;
            }
        }
        if ((this.info & 0x2000000) != 0) {
            Game.executeEntityFunc(this, this.deathByExplosion(entity));
            this.info &= 0xFDFFFFFF;
        }
        Render.mapSpriteInfo[n] = n2;
        Canvas.updateFacingEntity = true;
    }

    private void dropChickenPlate(Entity entity) {
        int n = 0;
        if (entity != null) {
            byte by = entity.def.eType;
            byte by2 = entity.def.eSubType;
            if (by == 14 && by2 == 6 || by == 10 && by2 == 2 || by == 8 && by2 == 1 || entity == Player.getPlayerEnt() && (1L << Player.ce.weapon & 0x3000L) != 0L) {
                n = 1;
            }
        }
        this.dropItem(n);
    }

    private boolean deathByExplosion(Entity entity) {
        boolean bl = false;
        if (entity == Player.getPlayerEnt() && Player.ce.weapon == 12) {
            bl = true;
        } else if (entity != null && (entity.def.eType == 10 && entity.def.eSubType == 2 || entity.def.eType == 14 && entity.def.eSubType == 6)) {
            bl = true;
        }
        return bl;
    }

    private void dropItem(int n) {
        int n2 = this.getSprite();
        int n3 = 0;
        byte by = this.def.eSubType;
        int n4 = 1;
        boolean bl = true;
        short s = App.nextByte();
        short s2 = App.nextByte();
        boolean bl2 = this.def.eType == 9 && this.def.eSubType == 10;
        boolean bl3 = bl2 = bl2 || this.def.eType == 10 && by == 8;
        if (bl2) {
            boolean bl4 = n == 1;
            n3 = bl4 ? 118 : 117;
            bl = false;
        } else if (this.def.eType == 9) {
            if (!Player.god && s < 145) {
                return;
            }
            if (by == 1 || by == 0) {
                if (s2 < 70) {
                    n3 = 113;
                } else if (this.def.parm == 2) {
                    if (Game.difficulty == 4) {
                        n3 = 116;
                    } else {
                        n3 = 89;
                        n4 = 2;
                    }
                } else if (s2 < 204 || by == 0 || Game.difficulty == 4) {
                    n3 = 85;
                    n4 = 4;
                } else {
                    n3 = 5;
                }
            } else if (by == 3) {
                if (Game.difficulty == 4 && this.def.parm == 2) {
                    n3 = 116;
                }
            } else if (by == 7) {
                if (Game.difficulty == 4) {
                    if (s2 > 100) {
                        n3 = this.def.parm > 0 ? 116 : 113;
                    } else {
                        n3 = 85;
                        n4 = 4;
                    }
                } else if ((s2 & 1) == 0) {
                    n3 = 113;
                } else {
                    n3 = 85;
                    n4 = 4;
                }
            } else if (by == 6) {
                if (Game.difficulty != 4) {
                    if (this.def.parm == 0) {
                        n3 = 90;
                        n4 = 4;
                    } else {
                        n3 = 86;
                        n4 = 9;
                    }
                } else {
                    n3 = 116;
                }
            } else if (by == 5 && Game.difficulty != 4) {
                if (this.def.parm == 0) {
                    n3 = 91;
                    n4 = 3;
                } else {
                    n3 = 86;
                    n4 = 9;
                }
            }
        }
        if (n3 != 0) {
            EntityDef entityDef = EntityDef.lookup(n3);
            Game.spawnDropItem(Render.mapSprites[Render.S_X + n2], Render.mapSprites[Render.S_Y + n2], n3, 6, entityDef.eSubType, entityDef.parm, n4, bl);
        }
    }

    void aiCalcSimpleGoal(boolean bl) {
        int n;
        if ((this.monster.flags & 0x800) != 0) {
            this.monster.flags = (short)(this.monster.flags & 0xFFFFDFFF);
            this.monster.goalType = (byte)4;
            this.monster.goalParam = 3;
            return;
        }
        if (this.def.eSubType == 9 ? this.aiCalcTormentorGoal() : this.def.eSubType == 14 && this.aiCalcHarbingerGoal()) {
            return;
        }
        if (Player.buffs[11] > 0 && (1 << this.def.eSubType & 0x7200) == 0) {
            this.monster.goalType = (byte)4;
            this.monster.goalParam = 1;
            return;
        }
        if ((0xCF & 1 << this.def.eSubType) != 0) {
            short s = this.getIndex();
            int[] nArray = Game.placedBombs;
            for (n = 0; n < 4; ++n) {
                if (nArray[n] == 0) continue;
                Entity entity = Game.entities[nArray[n]];
                int n2 = (entity.param & 0x7FFFFF00) >> 8;
                if (n2 != s) continue;
                this.monster.goalType = (byte)4;
                this.monster.goalParam = 1;
                return;
            }
        }
        Entity entity = Game.entities[1];
        int n3 = this.aiWeaponForTarget(entity);
        n = 0;
        if (n3 != -1) {
            this.monster.ce.weapon = n3;
            n = 1;
        }
        if (n != 0) {
            this.monster.goalType = (byte)3;
            this.monster.goalParam = 1;
            if ((1 << this.def.eSubType & 0x308E) != 0) {
                this.monster.flags = (short)(this.monster.flags | 1);
            }
            if (!bl && this.def.eSubType == 0 && App.nextByte() < 30) {
                this.monster.goalType = (byte)5;
                this.monster.goalParam = 1;
            }
        } else if (this.def.eSubType == 2 && (this.monster.flags & 0x100) != 0) {
            this.monster.goalType = (byte)4;
            this.monster.goalTurns = (byte)10;
            this.monster.goalParam = 1;
        } else {
            this.monster.goalType = (byte)2;
            this.monster.goalParam = 1;
            if ((1 << this.def.eSubType & 0x308E) != 0) {
                this.monster.flags = (short)(this.monster.flags & 0xFFFFFFFE);
            }
        }
    }

    public boolean aiCalcTormentorGoal() {
        int n = 256 - (this.monster.ce.getStat(0) << 8) / this.monster.ce.getStat(1);
        if (App.nextByte() <= n) {
            Entity[] entityArray = Game.gridEntities;
            int n2 = this.linkIndex % 32 << 6;
            int n3 = this.linkIndex / 32 << 6;
            entityArray[0] = Game.findMapEntity(n2, n3, 512);
            entityArray[1] = Game.findMapEntity(n2 - 64, n3, 512);
            entityArray[2] = Game.findMapEntity(n2 + 64, n3, 512);
            entityArray[3] = Game.findMapEntity(n2, n3 - 64, 512);
            entityArray[4] = Game.findMapEntity(n2, n3 + 64, 512);
            entityArray[5] = Game.findMapEntity(n2 - 64, n3 - 64, 512);
            entityArray[6] = Game.findMapEntity(n2 - 64, n3 + 64, 512);
            entityArray[7] = Game.findMapEntity(n2 + 64, n3 - 64, 512);
            entityArray[8] = Game.findMapEntity(n2 + 64, n3 + 64, 512);
            for (int i = 0; i < 9; ++i) {
                if (entityArray[i] == null) continue;
                Game.trace(n2 + 32, n3 + 32, (entityArray[i].linkIndex % 32 << 6) + 32, (entityArray[i].linkIndex / 32 << 6) + 32, this, 15535, 16);
                if (Game.numTraceEntities != 0) continue;
                if (i == 0) {
                    this.monster.goalType = (byte)3;
                    this.monster.ce.weapon = 42;
                } else {
                    this.monster.goalType = (byte)2;
                }
                this.monster.goalParam = entityArray[i].getIndex();
                return true;
            }
        }
        return false;
    }

    private final boolean aiCalcHarbingerGoal() {
        ++this.param;
        int n = 256 - (this.monster.ce.getStat(0) << 8) / this.monster.ce.getStat(1);
        if (App.nextByte() <= n && this.param >= 7) {
            Entity entity = Game.findMapEntity(HARBINGER_BLOOD_POOLX, HARBINGER_BLOOD_POOLY);
            Entity entity2 = null;
            boolean bl = false;
            while (entity != null) {
                if (entity.def.eType == 14) {
                    entity2 = entity;
                } else if (entity.def.eType == 1) {
                    bl = true;
                }
                entity = entity.nextOnTile;
            }
            if (bl) {
                return false;
            }
            int[] nArray = entity2.calcPosition();
            if (nArray[0] >> 6 != this.linkIndex % 32 || nArray[1] >> 6 != this.linkIndex / 32) {
                this.monster.goalType = (byte)2;
                this.monster.goalParam = entity2.getIndex();
            } else {
                this.monster.goalType = (byte)3;
                this.monster.goalParam = entity2.getIndex();
                this.monster.ce.weapon = 41;
            }
            return true;
        }
        return false;
    }

    private void aiMoveToGoal() {
        byte by = this.monster.goalType;
        EntityMonster entityMonster = this.monster;
        if (by == 2 || by == 1 || by == 4 || by == 5) {
            boolean bl = this.aiGoal_MOVE();
            if (!bl && this.def.eSubType == 0 && by == 5) {
                this.aiChooseNewGoal(false);
                this.aiMoveToGoal();
            }
        } else if (by == 3) {
            entityMonster.target = entityMonster.goalParam == 1 ? null : Game.entities[entityMonster.goalParam];
            this.attack();
        }
    }

    private void aiChooseNewGoal(boolean bl) {
        byte by = this.def.eSubType;
        this.monster.resetGoal();
        this.aiCalcSimpleGoal(bl);
        if ((1 << by & 0x308E) != 0 && this.monster.goalType == 3) {
            this.monster.goalFlags = (byte)(this.monster.goalFlags | 8);
        }
    }

    private boolean aiIsValidGoal() {
        byte by = this.monster.goalType;
        if (this.monster.goalTurns >= 16 || by == 3 || by == 0) {
            return false;
        }
        if (by == 2) {
            Entity entity = Game.entities[this.monster.goalParam];
            if (this.monster.goalParam != 1) {
                int[] nArray = entity.calcPosition();
                Entity entity2 = Game.findMapEntity(nArray[0], nArray[1], 15535);
                if (entity.linkIndex != this.linkIndex && (entity2 == null || entity2 == entity)) {
                    return true;
                }
            }
        } else if (by == 1) {
            if (this.linkIndex != this.monster.goalX + this.monster.goalY * 32) {
                return true;
            }
        } else {
            if (by == 4 || by == 5) {
                return this.monster.goalTurns < this.monster.goalParam;
            }
            if (by == 6) {
                if (this.monster.goalTurns < this.monster.goalParam) {
                    return true;
                }
                if (this.monster.goalTurns == this.monster.goalParam) {
                    this.monster.resetGoal();
                    return false;
                }
            }
        }
        return false;
    }

    public boolean aiIsAttackValid() {
        EntityMonster entityMonster = this.monster;
        int n = entityMonster.ce.weapon;
        int[] nArray = this.calcPosition();
        Game.trace(nArray[0], nArray[1], Game.destX, Game.destY, this, 5295, 2);
        Entity entity = Game.traceEntity;
        if (entity != null) {
            boolean bl = Combat.weapons[n * 9 + 3] >= Combat.WorldDistToTileDist(this.distFrom(Game.destX, Game.destY));
            boolean bl2 = false;
            if (bl) {
                int n2 = nArray[0] - Game.destX;
                int n3 = nArray[1] - Game.destY;
                boolean bl3 = bl2 = !(n2 == 0 && n3 == 0 || n2 != 0 && n3 != 0);
            }
            if (entityMonster.target == null && entity.def.eType == 1 && bl && bl2) {
                return true;
            }
            if (entityMonster.target == entity && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public void aiThink(boolean bl) {
        EntityMonster entityMonster = this.monster;
        if ((entityMonster.flags & 0x400) != 0) {
            entityMonster.flags = (short)(entityMonster.flags & 0xFFFFFBFF);
        }
        if ((entityMonster.flags & 0x20) != 0) {
            return;
        }
        if (!this.aiIsValidGoal()) {
            this.aiChooseNewGoal(bl);
        }
        entityMonster.goalTurns = (byte)(entityMonster.goalTurns + 1);
        this.aiMoveToGoal();
    }

    private int aiWeaponForTarget(Entity entity) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getSprite();
        if (entity.def.eType == 1) {
            n4 = Canvas.viewX;
            n3 = Canvas.viewY;
        } else {
            int n6 = entity.getSprite();
            n4 = Render.mapSprites[Render.S_X + n6];
            n3 = Render.mapSprites[Render.S_Y + n6];
        }
        int n7 = n4 - Render.mapSprites[Render.S_X + n5];
        int n8 = n3 - Render.mapSprites[Render.S_Y + n5];
        if (n7 != 0 && n8 != 0) {
            return -1;
        }
        boolean bl = false;
        Game.trace(Render.mapSprites[Render.S_X + n5], Render.mapSprites[Render.S_Y + n5], n4, n3, this, 5295, 2);
        if (Game.traceEntity != entity) {
            if (this.def.eSubType == 14) {
                Game.traceEntity = Game.findMapEntity(Render.mapSprites[Render.S_X + n5], Render.mapSprites[Render.S_Y + n5], 16384);
                if (Game.traceEntity != entity) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        int n9 = n7;
        int n10 = n8;
        if (n9 != 0) {
            n9 /= Math.abs(n7);
        }
        if (n10 != 0) {
            n10 /= Math.abs(n8);
        }
        Game.trace(Render.mapSprites[Render.S_X + n5] + n9 * 18, Render.mapSprites[Render.S_Y + n5] + n10 * 18, n4, n3, this, 15791, 2);
        bl = Game.traceEntity == entity;
        int n11 = Combat.getMonsterField(this.def, 0);
        int n12 = Combat.getMonsterField(this.def, 1);
        if (!bl) {
            if ((1L << n11 & 0x38D01950800FL) != 0L) {
                n11 = 0;
            }
            if ((1L << n12 & 0x38D01950800FL) != 0L) {
                n12 = 0;
            }
        }
        if (this.def.eSubType == 4) {
            if (this.def.parm == 2 && (this.monster.flags & 1) == 0) {
                n12 = 26;
            }
            if (Player.buffs[9] > 0) {
                if ((1L << n11 & 0x10046000000L) != 0L) {
                    n11 = 0;
                }
                if ((1L << n12 & 0x10046000000L) != 0L) {
                    n12 = 0;
                }
            }
        }
        int n13 = -1;
        int n14 = -1;
        int n15 = Combat.WorldDistToTileDist(entity.distFrom(Render.mapSprites[Render.S_X + n5], Render.mapSprites[Render.S_Y + n5]));
        if (n11 == n12) {
            n12 = 0;
        }
        if (this.def.eSubType == 9 && entity.def.eType == 9) {
            if (n15 == 0) {
                return 42;
            }
            return -1;
        }
        if (this.def.eSubType == 14 && entity.def.eType == 14) {
            if (n15 == 0) {
                return 41;
            }
            return -1;
        }
        byte[] byArray = Combat.weapons;
        if (n11 != 0 && byArray[(n2 = n11 * 9) + 2] <= n15 && byArray[n2 + 3] >= n15) {
            n14 = n2;
        }
        if (n12 != 0 && byArray[(n2 = n12 * 9) + 2] <= n15 && byArray[n2 + 3] >= n15) {
            n13 = n2;
        }
        if (this.def.eSubType == 2 && this.def.parm == 0) {
            if ((this.monster.flags & 0x100) == 0 && this.monster.ce.getStat(0) < 10) {
                n14 = -1;
            } else if ((this.monster.flags & 0x100) != 0) {
                n13 = -1;
                n14 = -1;
            } else {
                n13 = -1;
            }
        }
        if ((1L << n11 & 0x109010000000L) != 0L || (1L << n12 & 0x109010000000L) != 0L) {
            boolean bl2 = true;
            int n16 = Render.mapSprites[Render.S_X + n5] >> 6;
            int n17 = Render.mapSprites[Render.S_Y + n5] >> 6;
            do {
                if ((baseVisitedTiles[n17] & 1 << n16) != 0) {
                    bl2 = false;
                    break;
                }
                n16 += n9;
                n17 += n10;
            } while (--n15 > 0);
            if ((1L << n11 & 0x109010000000L) != 0L && !bl2) {
                n14 = -1;
            }
            if ((1L << n12 & 0x109010000000L) != 0L && !bl2) {
                n13 = -1;
            }
        }
        if (n13 != -1 && n14 != -1) {
            n = App.nextByte() <= Combat.getMonsterField(this.def, 2) ? n11 : n12;
        } else if (n13 != -1) {
            n = n12;
        } else if (n14 != -1) {
            n = n11;
        } else {
            return -1;
        }
        return n;
    }

    public LerpSprite aiInitLerp(int n) {
        int n2 = this.getSprite();
        LerpSprite lerpSprite = Game.allocLerpSprite(null, n2, true);
        lerpSprite.srcX = Render.mapSprites[Render.S_X + n2];
        lerpSprite.srcY = Render.mapSprites[Render.S_Y + n2];
        lerpSprite.srcZ = Render.mapSprites[Render.S_Z + n2];
        lerpSprite.dstX = 32 + (this.monster.goalX << 6);
        lerpSprite.dstY = 32 + (this.monster.goalY << 6);
        lerpSprite.dstZ = 32 + Render.getHeight(lerpSprite.dstX, lerpSprite.dstY);
        lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + n2];
        lerpSprite.startTime = App.gameTime;
        lerpSprite.travelTime = n;
        lerpSprite.flags |= 0x11;
        this.monster.frameTime = App.time + n;
        lerpSprite.calcDist();
        this.monster.goalFlags = (byte)(this.monster.goalFlags | 1);
        return lerpSprite;
    }

    public void aiFinishLerp() {
        this.monster.goalFlags = (byte)(this.monster.goalFlags & 0xFFFFFFFE);
        if ((this.monster.flags & 0x1000) != 0) {
            this.monster.flags = (short)(this.monster.flags & 0xFFFFEFFF);
        } else {
            this.aiReachedGoal_MOVE();
        }
    }

    private boolean checkLineOfSight(int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 - n;
        int n7 = n4 - n2;
        if (n6 != 0 && n7 != 0) {
            return false;
        }
        if (n6 != 0) {
            n6 /= Math.abs(n6);
        }
        if (n7 != 0) {
            n7 /= Math.abs(n7);
        }
        while (n != n3 && n2 != n4) {
            if (null == Game.findMapEntity((n += n6) << 6, (n2 += n7) << 6, n5)) continue;
            return false;
        }
        return true;
    }

    private boolean calcPath(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n3 - n;
        int n12 = n4 - n2;
        int n13 = n11 * n11 + n12 * n12;
        byte[] byArray = visitOrder;
        int[] nArray = visitDist;
        int n14 = n2;
        visitedTiles[n14] = visitedTiles[n14] | 1 << n;
        boolean bl2 = this.checkLineOfSight(n, n2, n3, n4, n5 | 0x100);
        if (lineOfSight == 0 && !bl2 || lineOfSight == 1 && bl2) {
            n13 = bl ? (n13 -= 30) : (n13 += 30);
        }
        if (bl2) {
            n13 += lineOfSightWeight;
        }
        if (pathDepth > 0 && (!bl && n13 < closestPathDist || bl && n13 > closestPathDist)) {
            closestPath = curPath;
            closestPathDepth = pathDepth;
            closestPathDist = n13;
        }
        if (n == n3 && n2 == n4) {
            closestPath = curPath;
            closestPathDepth = pathDepth;
            closestPathDist = n13;
            return true;
        }
        if (pathDepth == pathSearchDepth) {
            return false;
        }
        int n15 = 0;
        byte[] byArray2 = Canvas.viewStepValues;
        int n16 = 4;
        byte by = (byte)(App.nextByte() & 3);
        while (--n16 >= 0) {
            by = (byte)(by + 1 & 3);
            n10 = n + (byArray2[by << 2] >> 6);
            n9 = n2 + (byArray2[(by << 2) + 1] >> 6);
            if (n9 < 0 || n9 >= 32 || n10 < 0 || n10 >= 32 || null != Game.findMapEntity(n10 << 6, n9 << 6, 256) || 0 != (visitedTiles[n9] & 1 << n10)) continue;
            byArray[n15] = by;
            n11 = n3 - n10;
            n12 = n4 - n9;
            nArray[n15] = n11 * n11 + n12 * n12;
            bl2 = this.checkLineOfSight(n10, n9, n3, n4, n5 | 0x100);
            if (lineOfSight == 0 && !bl2 || lineOfSight == 1 && bl2) {
                if (bl) {
                    int n17 = n15;
                    nArray[n17] = nArray[n17] - 30;
                } else {
                    int n18 = n15;
                    nArray[n18] = nArray[n18] + 30;
                }
            }
            if (bl2) {
                int n19 = n15;
                nArray[n19] = nArray[n19] + lineOfSightWeight;
            }
            ++n15;
        }
        for (n8 = 0; n8 < n15; ++n8) {
            for (n7 = 0; n7 < n15 - n8 - 1; ++n7) {
                n6 = nArray[n7] - nArray[n7 + 1];
                if ((bl || n6 <= 0) && (!bl || n6 >= 0)) continue;
                n10 = nArray[n7 + 1];
                nArray[n7 + 1] = nArray[n7];
                nArray[n7] = n10;
                n10 = byArray[n7 + 1];
                byArray[n7 + 1] = byArray[n7];
                byArray[n7] = (byte)n10;
            }
        }
        n8 = 0;
        n7 = 0;
        for (n6 = 0; n6 < n15; ++n6) {
            n8 |= (byArray[n6] & 3) << n7;
            n7 += 2;
        }
        for (int i = 0; i < n15; ++i) {
            n6 = n8 & 3;
            n8 >>= 2;
            n10 = n + (byArray2[n6 << 2] >> 6);
            n9 = n2 + (byArray2[(n6 << 2) + 1] >> 6);
            Game.trace((n << 6) + 32, (n2 << 6) + 32, (n10 << 6) + 32, (n9 << 6) + 32, skipEnt, n5, 16);
            if (findEnt != null && Game.traceEntity == findEnt) {
                closestPath = curPath;
                closestPathDepth = pathDepth;
                closestPathDist = n13;
                return true;
            }
            int n20 = interactClipMask;
            if (Game.traceEntity != null) {
                n20 = 1 << Game.traceEntity.def.eType;
            }
            if (n20 != 0 && (n20 & interactClipMask) == 0) continue;
            ++pathDepth;
            curPath >>= 2;
            curPath &= 0x3FFFFFFFFFFFFFFFL;
            curPath |= (long)n6 << 62;
            if (this.calcPath(n10, n9, n3, n4, n5, bl)) {
                return true;
            }
            --pathDepth;
            curPath <<= 2;
        }
        return false;
    }

    private boolean aiGoal_MOVE() {
        boolean bl;
        boolean bl2 = false;
        int n = this.getSprite();
        Game.snapLerpSprites(n);
        short s = Render.mapSprites[Render.S_X + n];
        short s2 = Render.mapSprites[Render.S_Y + n];
        closestPath = 0L;
        closestPathDepth = 0;
        closestPathDist = 999999999;
        curPath = 0L;
        pathDepth = 0;
        pathSearchDepth = 8;
        findEnt = null;
        skipEnt = this;
        lineOfSight = 2;
        lineOfSightWeight = 0;
        interactClipMask = 32;
        System.arraycopy(baseVisitedTiles, 0, visitedTiles, 0, visitedTiles.length);
        if (this.monster.goalType == 2 && this.monster.goalParam == 1) {
            findEnt = Game.entities[1];
            this.monster.goalX = Game.destX >> 6;
            this.monster.goalY = Game.destY >> 6;
            lineOfSightWeight = -4;
        } else if (this.monster.goalType == 5) {
            this.monster.goalX = Game.destX >> 6;
            this.monster.goalY = Game.destY >> 6;
            interactClipMask = 0;
            bl2 = true;
            lineOfSight = 1;
            pathSearchDepth = this.monster.goalParam;
        } else if (this.monster.goalType == 4) {
            this.monster.goalX = Game.destX >> 6;
            this.monster.goalY = Game.destY >> 6;
            bl2 = true;
            lineOfSight = 1;
        } else if (this.monster.goalType == 2) {
            findEnt = Game.entities[this.monster.goalParam];
            this.monster.goalX = Entity.findEnt.linkIndex % 32;
            this.monster.goalY = Entity.findEnt.linkIndex / 32;
        }
        if (bl2) {
            closestPathDist = 0;
        }
        if (!(bl = this.calcPath(s >> 6, s2 >> 6, this.monster.goalX, this.monster.goalY, 15535, bl2)) && closestPathDist < 999999999) {
            bl = true;
            curPath = closestPath;
            pathDepth = closestPathDepth;
        }
        if (bl && pathDepth > 0) {
            this.info &= 0xEFFFFFFF;
            int n2 = s + Canvas.viewStepValues[(int)(((curPath >>= 64 - pathDepth * 2) & 3L) << 2)];
            int n3 = s2 + Canvas.viewStepValues[(int)((curPath & 3L) << 2) + 1];
            this.monster.goalX = n2 >> 6;
            this.monster.goalY = n3 >> 6;
            Game.trace(s, s2, n2, n3, this, interactClipMask, 25);
            if (Game.numTraceEntities == 0) {
                Game.unlinkEntity(this);
                Game.linkEntity(this, n2 >> 6, n3 >> 6);
                int n4 = Math.min(s, n2) - 16;
                int n5 = Math.max(s, n2) + 16;
                int n6 = Math.min(s2, n3) - 16;
                int n7 = Math.max(s2, n3) + 16;
                if (!Render.cullBoundingBox(n4 << 4, n6 << 4, n5 << 4, n7 << 4, true)) {
                    this.info |= 0x10000000;
                }
                Game.interpolatingMonsters = true;
                this.aiInitLerp(275);
            } else {
                this.monster.goalX = s >> 6;
                this.monster.goalY = s2 >> 6;
                if (Game.traceEntity.def.eType == 5) {
                    Game.performDoorEvent(0, Game.traceEntity, 2);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private void aiReachedGoal_MOVE() {
        EntityMonster entityMonster = this.monster;
        EntityDef entityDef = this.def;
        this.info &= 0xEFFFFFFF;
        if (entityMonster.goalType != 4 && entityMonster.goalType != 5 && (entityDef.eSubType == 9 || (1 << entityDef.eSubType & 0x308E) != 0 && 0 == (entityMonster.flags & 1) || entityDef.eSubType == 13 || entityDef.eSubType == 14)) {
            int n;
            Entity entity = Game.entities[1];
            if ((entityDef.eSubType == 9 || entityDef.eSubType == 14) && entityMonster.goalType == 2) {
                entity = Game.entities[entityMonster.goalParam];
            }
            if ((n = this.aiWeaponForTarget(entity)) != -1) {
                entityMonster.target = entity == Game.entities[1] ? null : entity;
                entityMonster.ce.weapon = n;
                this.attack();
                return;
            }
        }
        if ((1 << entityDef.eSubType & 0x308E) != 0) {
            entityMonster.flags = (short)(entityMonster.flags | 1);
        }
        if ((entityMonster.goalFlags & 0x10) != 0) {
            entityMonster.goalFlags = (byte)(entityMonster.goalFlags & 0xFFFFFFEF);
            this.aiCalcSimpleGoal(false);
            if (entityMonster.goalType == 1 || entityMonster.goalType == 2) {
                if (!Game.tileObstructsAttack(entityMonster.goalX, entityMonster.goalY)) {
                    this.aiGoal_MOVE();
                } else {
                    entityMonster.resetGoal();
                }
            }
        }
    }

    public int distFrom(int n, int n2) {
        int[] nArray = this.calcPosition();
        return Math.max((n - nArray[0]) * (n - nArray[0]), (n2 - nArray[1]) * (n2 - nArray[1]));
    }

    private void attack() {
        if ((this.monster.flags & 0x400) == 0) {
            this.monster.flags = (short)(this.monster.flags | 0x400);
            this.monster.nextAttacker = Game.combatMonsters;
            Game.combatMonsters = this;
        }
    }

    public void undoAttack() {
        if ((this.monster.flags & 0x400) == 0) {
            return;
        }
        this.monster.flags = (short)(this.monster.flags & 0xFFFFFBFF);
        int n = this.getSprite();
        int n2 = this.monster.ce.weapon;
        if (n2 == 36 || n2 == 39 || n2 == 28) {
            int n3 = n;
            Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] & 0xFFFF00FF;
        }
        this.monster.resetGoal();
        Entity entity = Game.combatMonsters;
        Entity entity2 = null;
        while (entity != null && entity != this) {
            entity2 = entity;
            entity = entity.monster.nextAttacker;
        }
        if (entity2 != null) {
            entity2.monster.nextAttacker = this.monster.nextAttacker;
        } else if (Game.combatMonsters != null) {
            Game.combatMonsters = this.monster.nextAttacker;
        }
    }

    private void trimCorpsePile(int n, int n2) {
        Entity entity = Game.inactiveMonsters;
        if (entity != null) {
            int n3 = 0;
            do {
                int n4;
                if (Render.mapSprites[Render.S_X + (n4 = entity.getSprite())] != n || Render.mapSprites[Render.S_Y + n4] != n2 || (entity.info & 0x1010000) == 0 || (Render.mapSpriteInfo[n4] & 0x10000) != 0 || ++n3 < 3) continue;
                int n5 = n4;
                Render.mapSpriteInfo[n5] = Render.mapSpriteInfo[n5] | 0x10000;
                entity.info = entity.info & 0xFEFFFFFF | 0x10000;
                Game.unlinkEntity(entity);
            } while ((entity = entity.monster.nextOnList) != Game.inactiveMonsters);
        }
    }

    public void knockback(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray = knockbackDelta;
        if (n3 == 0) {
            return;
        }
        if (this.def.eType == 1) {
            n7 = Game.destX;
            n6 = Game.destY;
            n5 = 13501;
        } else {
            n4 = this.getSprite();
            n7 = Render.mapSprites[Render.S_X + n4];
            n6 = Render.mapSprites[Render.S_Y + n4];
            n5 = 15535;
        }
        nArray[0] = n7 - n;
        nArray[1] = n6 - n2;
        if (nArray[0] != 0) {
            nArray[0] = nArray[0] / Math.abs(nArray[0]);
            Canvas.knockbackStart = n7;
            Canvas.knockbackWorldDist = Math.abs(64 * nArray[0] * n3);
        }
        if (nArray[1] != 0) {
            nArray[1] = nArray[1] / Math.abs(nArray[1]);
            Canvas.knockbackStart = n6;
            Canvas.knockbackWorldDist = Math.abs(64 * nArray[1] * n3);
        }
        n4 = n3;
        int n8 = n7 + 64 * nArray[0] * n4;
        int n9 = n6 + 64 * nArray[1] * n4;
        if ((n4 = this.getFarthestKnockbackDist(n7, n6, n8, n9, this, n5, 16, n3)) == 0 || nArray[0] == 0 && nArray[1] == 0) {
            return;
        }
        n8 = n7 + nArray[0] * n4 * 64 >> 6;
        n9 = n6 + nArray[1] * n4 * 64 >> 6;
        if (this.def.eType == 1) {
            if (this.def.eSubType != 1) {
                Canvas.knockbackX = nArray[0];
                Canvas.knockbackY = nArray[1];
                Canvas.knockbackDist = n4;
            }
        } else {
            this.monster.goalType = 1;
            this.monster.goalX = n8;
            this.monster.goalY = n9;
            this.monster.flags = (short)(this.monster.flags | 0x1000);
            LerpSprite lerpSprite = this.aiInitLerp(400);
            Game.unlinkEntity(this);
            Game.linkEntity(this, n8, n9);
            Game.interpolatingMonsters = true;
            Game.updateLerpSprite(lerpSprite);
        }
    }

    public final int getFarthestKnockbackDist(int n, int n2, int n3, int n4, Entity entity, int n5, int n6, int n7) {
        int n8 = n7;
        Game.trace(n, n2, n3, n4, entity, n5, n6);
        Entity entity2 = Game.traceEntity;
        if (entity2 != null) {
            int n9 = Game.traceFracs[0];
            n8 = n8 * n9 >> 14;
        }
        return n8;
    }

    public void resurrect(int n, int n2, int n3) {
        int n4 = this.getSprite();
        this.def = EntityDef.find(2, this.def.eSubType, this.def.parm);
        this.name = (short)(this.def.name | 0x800);
        this.monster.clearEffects();
        Render.mapSprites[Render.S_X + n4] = (short)n;
        Render.mapSprites[Render.S_Y + n4] = (short)n2;
        Render.mapSprites[Render.S_Z + n4] = (short)n3;
        int n5 = n4;
        Render.mapSpriteInfo[n5] = Render.mapSpriteInfo[n5] & 0xFFFC00FF;
        if ((App.nextInt() & 1) != 0) {
            int n6 = n4;
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] | 0x20000;
        }
        Render.relinkSprite(n4);
        this.info &= 0xF6FEFFFF;
        this.info |= 0x20000;
        CombatEntity combatEntity = this.monster.ce;
        this.initspawn();
        this.monster.ce = combatEntity;
        this.monster.ce.setStat(0, combatEntity.getStat(1));
        Game.unlinkEntity(this);
        Game.linkEntity(this, n >> 6, n2 >> 6);
        Canvas.updateFacingEntity = true;
    }

    public int[] calcPosition() {
        int n;
        int n2;
        if (this.def.eType == 0) {
            n2 = Game.traceCollisionX;
            n = Game.traceCollisionY;
        } else if (this.def.eType == 1) {
            n2 = Canvas.destX;
            n = Canvas.destY;
        } else if (this.def.eType == 2) {
            int n3 = this.getSprite();
            n2 = Render.mapSprites[Render.S_X + n3];
            n = Render.mapSprites[Render.S_Y + n3];
        } else {
            int n4 = this.getSprite();
            n2 = Render.mapSprites[Render.S_X + n4];
            n = Render.mapSprites[Render.S_Y + n4];
        }
        Entity.pos[0] = n2;
        Entity.pos[1] = n;
        return pos;
    }

    public boolean isBoss() {
        return this.def.eSubType >= 11 && this.def.eSubType <= 14;
    }

    public boolean isHasteResistant() {
        return this.def.eType == 2 && (this.def.eSubType == 14 || this.def.eSubType == 13 || this.def.eSubType == 12);
    }

    public boolean isExplodableEntity() {
        if (this.def.eType == 10 && this.def.eSubType == 2) {
            return true;
        }
        return this.def.eType == 14 && this.def.eSubType == 6;
    }

    private boolean isDroppedEntity() {
        short s = this.getIndex();
        return s >= Game.firstDropIndex && s < Game.firstDropIndex + 16;
    }

    private boolean isBinaryEntity(int[] nArray) {
        boolean bl = false;
        if (this.def == null) {
            return false;
        }
        if (this.isDroppedEntity()) {
            return false;
        }
        switch (this.def.eType) {
            default: {
                return false;
            }
            case 6: 
            case 10: 
            case 11: {
                if ((this.info & 0x100000) != 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                int n = this.getSprite();
                bl = Render.mapSprites[Render.S_SCALEFACTOR + n] != 64;
                if (this.def.eSubType != 1 || null == nArray) break;
                nArray[1] = nArray[1] | 0x200000;
                break;
            }
            case 13: {
                int n = this.getSprite();
                int n2 = Render.mapSpriteInfo[n] & 0xFF;
                if (n2 != 194 && n2 != 168) break;
                bl = (Render.mapSpriteInfo[n] & 0x10000) != 0;
            }
        }
        if (null != nArray) {
            nArray[0] = bl ? 1 : 0;
        }
        return true;
    }

    private boolean isNamedEntity(int[] nArray) {
        if (this.def == null || this.name == Text.STRINGID((short)2, this.def.name) || this.def.eType == 9) {
            return false;
        }
        if (this.def.eType == 2 && this.def.eSubType == 8) {
            return false;
        }
        nArray[0] = this.name;
        if (nArray[0] != -1) {
            return true;
        }
        App.Error(25);
        return false;
    }

    public void saveState(DataOutputStream dataOutputStream, int n) throws IOException {
        short[] sArray = Render.mapSprites;
        int[] nArray = Render.mapSpriteInfo;
        if ((n & 0x20000) != 0) {
            int[] nArray2 = tempSaveBuf;
            this.isNamedEntity(nArray2);
            dataOutputStream.writeShort((short)nArray2[0]);
        }
        if ((n & 0x80000) != 0) {
            return;
        }
        if (this.def.eType == 10 && this.def.eSubType == 1) {
            return;
        }
        int n2 = this.getSprite();
        if (this.def.eType == 2 && (n & 0x200000) != 0) {
            dataOutputStream.writeByte(sArray[Render.S_X + n2] >> 3);
            dataOutputStream.writeByte(sArray[Render.S_Y + n2] >> 3);
            dataOutputStream.writeByte((nArray[n2] & 0xFF00) >> 8);
            dataOutputStream.writeShort(this.monster.flags);
            return;
        }
        dataOutputStream.writeByte(this.info >> 16 & 0xFF);
        if ((this.info & 0x10000) == 0) {
            dataOutputStream.writeByte((nArray[n2] & 0xFF0000) >> 16);
            dataOutputStream.writeByte((nArray[n2] & 0xFF00) >> 8);
            if (this.isDroppedEntity() || (Render.mapSpriteInfo[n2] & 0xF000000) == 0) {
                dataOutputStream.writeByte(sArray[Render.S_X + n2] >> 3);
                dataOutputStream.writeByte(sArray[Render.S_Y + n2] >> 3);
            }
            if (this.isDroppedEntity()) {
                dataOutputStream.writeInt(this.param);
            }
            if (!this.isDroppedEntity() && (Render.mapSpriteInfo[n2] & 0xF000000) != 0) {
                dataOutputStream.writeShort(this.linkIndex);
            }
        }
        if (this.monster != null) {
            dataOutputStream.writeShort(this.monster.flags);
            if ((this.info & 0x10000) == 0) {
                if ((this.monster.flags & 0x200) != 0) {
                    dataOutputStream.writeByte(sArray[Render.S_SCALEFACTOR + n2]);
                }
                if ((n & 0x100000) == 0) {
                    dataOutputStream.writeShort(this.monster.monsterEffects);
                    this.monster.ce.saveState(dataOutputStream, false);
                    this.monster.saveGoalState(dataOutputStream);
                }
            }
        } else if (this.isDroppedEntity()) {
            byte by = (byte)(this.def.eType | this.def.eSubType << 4);
            dataOutputStream.writeByte(by);
            dataOutputStream.writeByte(this.def.parm);
            if (this.def.eType == 14 && this.def.eSubType == 6) {
                dataOutputStream.writeByte((nArray[n2] & 0xFF000000) >> 24);
            }
        } else {
            dataOutputStream.writeShort(sArray[Render.S_Z + n2]);
        }
    }

    public void loadState(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        if ((n & 0x20000) != 0) {
            this.name = dataInputStream.readShort();
        }
        int n6 = this.getSprite();
        int n7 = Render.mapSpriteInfo[n6] & 0xFF;
        if ((Render.mapSpriteInfo[n6] & 0x400000) != 0) {
            n7 += 257;
        }
        if ((n & 0x40000) != 0) {
            int n8 = n6;
            Render.mapSpriteInfo[n8] = Render.mapSpriteInfo[n8] & 0xFFFEFFFF;
            if ((n & 0x80000) != 0 && (this.info & 0x100000) == 0) {
                Game.linkEntity(this, Render.mapSprites[Render.S_X + n6] >> 6, Render.mapSprites[Render.S_Y + n6] >> 6);
            }
        } else {
            int n9 = n6;
            Render.mapSpriteInfo[n9] = Render.mapSpriteInfo[n9] | 0x10000;
            if ((this.info & 0x100000) != 0 && this.def.eType != 5 && (n7 < 60 || n7 > 63)) {
                Game.unlinkEntity(this);
            } else if (this.def.eType == 10 && this.def.eSubType != 8 && this.def.eSubType != 10) {
                ++Game.destroyedObj;
            }
        }
        if ((n & 0x1000000) != 0) {
            this.info |= 0x2000000;
        }
        if (this.isBinaryEntity(null)) {
            this.restoreBinaryState(n);
            if ((n & 0x80000) != 0) {
                return;
            }
        }
        if (this.def != null && this.def.eType == 10 && this.def.eSubType == 1) {
            return;
        }
        if ((n & 0x100000) != 0) {
            if ((n & 0x40000) == 0) {
                this.info |= 0x10000;
                if ((this.info & 0x100000) != 0) {
                    Game.unlinkEntity(this);
                }
            } else if ((n & 0x80000) != 0) {
                App.Error(5);
            }
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] & 0xFFFF00FF | 0x7000;
            this.def = EntityDef.find(9, this.def.eSubType, this.def.parm);
        }
        if (this.def != null && this.def.eType == 3) {
            this.param = (n & 0x200000) != 0 ? 1 : 0;
            this.param += (n & 0x4000000) != 0 ? 1 : 0;
        }
        if (this.monster != null) {
            if ((n & 0x800000) != 0) {
                this.monster.flags = (short)(this.monster.flags | 0x10);
                this.info |= 0x400000;
            }
            if ((n & 0x400000) != 0) {
                this.monster.flags = (short)(this.monster.flags | 0x80);
                this.info |= 0x400000;
            }
        }
        if ((n & 0x80000) != 0) {
            return;
        }
        if ((this.info & 0x100000) != 0) {
            Game.unlinkEntity(this);
        }
        n6 = this.getSprite();
        if (this.def != null && this.def.eType == 2 && (n & 0x200000) != 0) {
            short s = (short)((dataInputStream.readByte() & 0xFF) << 3);
            short s2 = (short)((dataInputStream.readByte() & 0xFF) << 3);
            int n10 = (dataInputStream.readByte() & 0xFF) << 8;
            Render.mapSprites[Render.S_X + n6] = s;
            Render.mapSprites[Render.S_Y + n6] = s2;
            Render.mapSprites[Render.S_Z + n6] = (short)(Render.getHeight(s, s2) + 32);
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] & 0xFFFF00FF | n10;
            Render.relinkSprite(n6);
            if ((this.info & 0x100000) != 0) {
                Game.unlinkEntity(this);
            }
            if ((n & 0x40000) == 0) {
                Game.deactivate(this);
            } else {
                Game.linkEntity(this, s >> 6, s2 >> 6);
            }
            this.monster.flags = dataInputStream.readShort();
            if (this.monster.flags != 0 || n10 != 0) {
                this.info |= 0x400000;
                if ((this.monster.flags & 0x800) != 0) {
                    if (n10 >> 8 == 96) {
                        this.monster.frameTime = Integer.MAX_VALUE;
                    }
                    this.info &= 0xFFFDFFFF;
                }
            }
            return;
        }
        this.info = this.info & 0xFF00FFFF | (dataInputStream.readByte() & 0xFF) << 16;
        if ((this.info & 0x10000) == 0) {
            n5 = dataInputStream.readByte() & 0xFF;
            n4 = dataInputStream.readByte() & 0xFF;
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] & 0xFF0000FF | n4 << 8 | n5 << 16;
            if (this.isDroppedEntity() || (Render.mapSpriteInfo[n6] & 0xF000000) == 0) {
                Render.mapSprites[Render.S_X + n6] = (short)(dataInputStream.readUnsignedByte() << 3);
                Render.mapSprites[Render.S_Y + n6] = (short)(dataInputStream.readUnsignedByte() << 3);
                if (this.monster != null || this.isDroppedEntity()) {
                    Render.mapSprites[Render.S_Z + n6] = (short)(Render.getHeight(Render.mapSprites[Render.S_X + n6], Render.mapSprites[Render.S_Y + n6]) + 32);
                }
                Render.relinkSprite(n6);
            }
            if (this.isDroppedEntity()) {
                this.param = dataInputStream.readInt();
            }
            this.linkIndex = !this.isDroppedEntity() && (Render.mapSpriteInfo[n6] & 0xF000000) != 0 ? dataInputStream.readShort() : (short)((Render.mapSprites[Render.S_X + n6] >> 6) + (Render.mapSprites[Render.S_Y + n6] >> 6) * 32);
            if (!((Render.mapSpriteInfo[n6] & 0xF000000) != 0xC000000 && (Render.mapSpriteInfo[n6] & 0xF000000) != 0x3000000 || this.def.eType != 13 && this.def.eType != 12)) {
                n3 = this.linkIndex % 32;
                n2 = this.linkIndex / 32;
                Render.mapSprites[Render.S_X + n6] = (short)((n3 << 6) + 32);
                Render.mapSprites[Render.S_Y + n6] = (short)((n2 << 6) + 32);
                Render.relinkSprite(n6);
            }
            if (n4 != 0) {
                this.info |= 0x400000;
            }
        }
        if ((n & 0x2000000) != 0) {
            this.info |= 0x80000;
        }
        if (this.monster != null) {
            this.monster.flags = dataInputStream.readShort();
            if ((this.info & 0x10000) == 0) {
                if ((this.monster.flags & 0x200) != 0) {
                    Render.mapSprites[Render.S_SCALEFACTOR + n6] = (short)dataInputStream.readUnsignedByte();
                }
                if ((n & 0x100000) != 0) {
                    this.info |= 0x1000000;
                } else {
                    this.monster.monsterEffects = dataInputStream.readShort();
                    this.monster.ce.loadState(dataInputStream, false);
                    this.monster.loadGoalState(dataInputStream);
                }
            }
            if ((this.info & 0x40000) != 0) {
                this.info &= 0xFFFBFFFF;
                Game.activate(this, false, false, false, true);
            }
            if ((this.info & 0x1000000) != 0) {
                this.def = EntityDef.find(9, this.def.eSubType, this.def.parm);
            }
            int n11 = n5 = (this.monster.flags & 0x800) != 0 ? 1 : 0;
            if (n5 != 0) {
                if ((Render.mapSpriteInfo[n6] & 0xFF00) >> 8 == 96) {
                    this.monster.frameTime = Integer.MAX_VALUE;
                }
                this.info &= 0xFFFDFFFF;
                this.info |= 0x400000;
            }
        } else if (this.isDroppedEntity()) {
            n5 = dataInputStream.readByte();
            n4 = (byte)(n5 & 0xF);
            n3 = n5 >> 4 & 0xF;
            n2 = dataInputStream.readByte();
            this.def = EntityDef.find(n4, n3, n2);
            this.name = (short)(this.def.name | 0x800);
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] & 0xFFFFFF00 | this.def.tileIndex;
            Render.mapSprites[Render.S_ENT + n6] = this.getIndex();
            if (this.def.eType == 14 && this.def.eSubType == 6) {
                int n12 = (dataInputStream.readByte() & 0xFF) << 24;
                int n13 = n6;
                Render.mapSpriteInfo[n13] = Render.mapSpriteInfo[n13] | n12;
                boolean bl = (Render.mapSpriteInfo[n6] & 0xF000000) != 0;
                int n14 = bl ? 32 : 31;
                Render.mapSprites[Render.S_Z + n6] = (short)(Render.getHeight(Render.mapSprites[Render.S_X + n6], Render.mapSprites[Render.S_Y + n6]) + n14);
                Render.mapSprites[Render.S_SCALEFACTOR + n6] = 32;
                Render.relinkSprite(n6);
            }
        } else {
            Render.mapSprites[Render.S_Z + n6] = dataInputStream.readShort();
            Render.relinkSprite(n6);
        }
        if ((this.info & 0x100000) != 0) {
            if ((Render.mapSpriteInfo[n6] & 0xF000000) != 0) {
                Game.linkEntity(this, this.linkIndex % 32, this.linkIndex / 32);
            } else {
                Game.linkEntity(this, Render.mapSprites[Render.S_X + n6] >> 6, Render.mapSprites[Render.S_Y + n6] >> 6);
            }
        }
    }

    public int getSaveHandle(boolean bl) {
        int n;
        int[] nArray;
        int[] nArray2 = tempSaveBuf;
        nArray2[0] = 1;
        nArray2[1] = this.getIndex();
        boolean bl2 = this.isDroppedEntity();
        boolean bl3 = this.isBinaryEntity(nArray2);
        if (!((this.info & 0xFFFF) != 0 && this.def != null || bl3)) {
            return -1;
        }
        if (bl2 && (this.info & 0x100000) == 0) {
            return -1;
        }
        if (bl2 && bl && this.def.eType == 14 && this.def.eSubType == 6) {
            return -1;
        }
        boolean bl4 = nArray2[0] != 0;
        int n2 = nArray2[1];
        if (bl3 && bl4) {
            n2 |= 0x10000;
        }
        if (this.isNamedEntity(nArray = tempSaveBuf)) {
            n2 |= 0x20000;
        }
        if ((Render.mapSpriteInfo[n = this.getSprite()] & 0x10000) == 0) {
            n2 |= 0x40000;
        }
        if ((this.info & 0x2000000) != 0) {
            n2 |= 0x1000000;
        }
        if ((this.info & 0x400000) == 0 && ((n2 |= 0x80000) & 0x20000) == 0 && this.def.eType == 7 && this.def.eSubType != 3) {
            return -1;
        }
        if ((this.info & 0x1010000) != 0) {
            n2 |= 0x100000;
        }
        if ((this.info & 0x80000) != 0) {
            n2 |= 0x2000000;
        }
        if ((this.info & 0x10000) != 0) {
            n2 &= 0xFFFBFFFF;
            n2 |= 0x100000;
        }
        if (this.def.eType == 3 && this.param != 0) {
            n2 |= 0x200000;
            if (this.param == 2) {
                n2 |= 0x4000000;
            }
        }
        if (this.monster != null) {
            if ((this.monster.flags & 0x10) != 0) {
                n2 |= 0x800000;
            }
            if ((this.monster.flags & 0x80) != 0) {
                n2 |= 0x400000;
            }
        }
        if (bl) {
            if (this.def.eType == 9 && this.def.eSubType != 15 && 0 == (this.monster.flags & 0x80)) {
                n2 = n2 & 0xFFFBFFFF | 0x80000;
            } else if (this.def.eType == 2) {
                n2 |= 0x200000;
            }
        }
        return n2;
    }

    private void restoreBinaryState(int n) {
        boolean bl = (n & 0x10000) != 0;
        switch (this.def.eType) {
            default: {
                return;
            }
            case 6: 
            case 10: 
            case 11: {
                if (bl) {
                    Game.unlinkEntity(this);
                    Game.linkEntity(this, this.linkIndex % 32, this.linkIndex / 32);
                } else {
                    Game.unlinkEntity(this);
                }
                if (this.def.eType != 10 || this.def.eSubType != 1) break;
                if (bl) {
                    Game.unlinkEntity(this);
                    Game.linkEntity(this, this.linkIndex % 32, this.linkIndex / 32);
                    Render.relinkSprite((this.info & 0xFFFF) - 1);
                    break;
                }
                Render.unlinkSprite((this.info & 0xFFFF) - 1);
                break;
            }
            case 5: {
                boolean bl2 = this.def.eSubType == 1;
                Game.setLineLocked(this, false);
                if (bl) {
                    Game.performDoorEvent(0, this, 0);
                } else {
                    Game.performDoorEvent(1, this, 0);
                }
                if ((n & 0x200000) == 0 && !bl2) break;
                Game.setLineLocked(this, (n & 0x200000) != 0);
                break;
            }
            case 13: {
                if (bl) {
                    Game.performDoorEvent(0, this, 0);
                    break;
                }
                Game.performDoorEvent(1, this, 0);
            }
        }
    }

    public short getIndex() {
        for (short s = 0; s < Game.numEntities; s = (short)(s + 1)) {
            if (this != Game.entities[s]) continue;
            return s;
        }
        return -1;
    }

    void updateMonsterFX() {
        if (null != this.monster) {
            if (this.def.eSubType == 13 && this.def.eType == 2 && this.monster.ce.getStat(0) < this.monster.ce.getStat(1)) {
                this.monster.ce.addStat(0, 20);
                Text text = Text.getSmallBuffer();
                Text.composeText((short)2, this.def.name, text);
                Text.resetTextArgs();
                Text.addTextArg(text);
                Text.addTextArg(5);
                Hud.addMessage((short)96);
                text.dispose();
            }
            for (int i = 0; i < 5; ++i) {
                short s = this.monster.monsterEffects;
                int n = 1 << i;
                if ((s & n) == 0) continue;
                int n2 = 5 + (i << 1);
                int n3 = s >> n2 & 3;
                if (this.def.eType != 9 && (this.info & 0x20000) != 0) {
                    byte by = this.def.eSubType;
                    int n4 = 0;
                    if (n == 8) {
                        n4 = by == 12 || by == 4 && this.def.parm == 0 ? 8 : (by == 9 ? 6 : 4);
                        Text.resetTextArgs();
                        Text.addTextArg(n4);
                        Hud.addMessage((short)1, (short)97);
                    } else if (n4 > 0) {
                        Text.resetTextArgs();
                        Text.addTextArg(n4);
                        Hud.addMessage((short)1, (short)73);
                    }
                    if (n4 > 0) {
                        this.pain(n4, null);
                        s = this.monster.monsterEffects;
                        if (this.monster.ce.getStat(0) <= 0) {
                            this.died(true, null);
                            s = this.monster.monsterEffects;
                            s = (short)(s & 0xFFFF801F);
                            s = (short)(s | 0x28A0);
                            n3 = 1;
                        }
                    }
                }
                if (n3 == 0) {
                    s = (short)(s & ~n);
                } else {
                    s = (short)(s & ~(3 << n2));
                    s = (short)(s | --n3 << n2);
                }
                this.monster.monsterEffects = s;
            }
        }
    }

    static {
        knockbackDelta = new int[2];
        pos = new int[2];
        tempSaveBuf = new int[2];
    }
}

