/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

final class CardGames {
    public static int touchMe = 1;
    private static final int GRAVITY = 10;
    private static final int DEF_VELOCITY = 2048;
    private static final int NUM_POKER_CARDS = 51;
    private static final int CARD_W = 17;
    private static final int CARD_H = 25;
    private static final int SUITSTART = 112;
    private static final int CARD_ROT0 = 1;
    private static final int CARD_ROT90 = 2;
    private static final int CARD_ROT180 = 4;
    private static final int CARD_ROT270 = 8;
    private static final int CARD_FACE_UP = 16;
    private static final int CARD_LERPING = 32;
    private static final int CARD_EXLERP = 64;
    private static final int CARD_HIDDEN = 128;
    private static final int CARD_PLAYER = 256;
    private static final int CARD_DEALER = 512;
    private static final int CARD_DARKEN = 1024;
    private static final int CARD_DESC = 0;
    private static final int CARD_SRCX = 1;
    private static final int CARD_SRCY = 2;
    private static final int CARD_DSTX = 3;
    private static final int CARD_DSTY = 4;
    private static final int CARD_FLAGS = 5;
    private static final int CARD_START = 6;
    private static final int CARD_LERP_DUR = 7;
    private static final int CARD_FIELDS = 8;
    private static final int MAX_CARDS = 24;
    private static final int PART_X = 0;
    private static final int PART_Y = 1;
    private static final int PART_VX = 2;
    private static final int PART_VY = 3;
    private static final int PART_ALIVE = 4;
    private static final int PART_FIELDS = 5;
    private static final int CHIP_OWNER = 0;
    private static final int CHIP_SRCX = 1;
    private static final int CHIP_SRCY = 2;
    private static final int CHIP_DSTX = 3;
    private static final int CHIP_DSTY = 4;
    private static final int CHIP_START = 5;
    private static final int CHIP_DUR = 6;
    private static final int CHIP_FIELDS = 7;
    private static final int MAX_CHIPS = 20;
    private static final int GAME_STATE = 0;
    private static final int PREV_STATE = 1;
    private static final int STATE_TIME = 2;
    private static final int CUR_BET = 3;
    private static final int MSG_ID = 4;
    private static final int SUB_STATE = 5;
    private static final int CARD_SEL_IDX = 6;
    private static final int DEALER_SEL_IDX = 7;
    private static final int MSG_TIME = 8;
    static int[] stateVars = Canvas.stateVars;
    public static Image imgOtherImgs = null;
    public static Image imgTable = null;
    private static final int INVALID_CARD = -1;
    private static int numPlayerCards = 0;
    private static int numDealerCards = 0;
    private static final short[] playersCards = new short[12];
    private static final short[] dealersCards = new short[12];
    private static int[] cardsInPlay = new int[192];
    private static int numCardsInPlay = 0;
    private static long deckMask = 0L;
    private static int numCardsLerping = 0;
    private static int backgroundColor = -16749526;
    private static ScriptThread callingThread = null;
    private static boolean savePlayer;
    private static int playerTreasure;
    private static int aiTreasure;
    private static int playerChips;
    private static int dealerChips;
    private static int startingChips;
    private static int chipAmount;
    private static int betPercentage;
    private static final int DEFAULT_TREASURE = 100;
    private static int CARDS_Y;
    private static int CARDS_X;
    private static int NUM_CARDS_W;
    private static int NUM_CARDS_H;
    private static final int NUM_WAR_CARDS = 6;
    private static int WAR_CARDS_X;
    private static int START_BTM_BG;
    private static int PORTRAIT_Y;
    private static final int NUM_CARD_ROWS = 3;
    private static int xMin;
    private static int xMaxW;
    private static int BJPortX;
    private static int BJChipsX;
    private static int GuntherPortX;
    private static int GuntherChipsX;
    private static int chipsY;
    private static int CARD_TEXT_Y;
    private static int CARD_WAR_TEXT_Y;
    private static int curCardsW;
    private static int curCardsH;
    private static Image flakImg;
    private static boolean animationDone;
    private static int cardsDiscarded;
    private static int particleFrameTime;
    private static int numParticles;
    private static short[] particles;
    private static int numChipsLerping;
    private static int numChips;
    private static int[] chips;
    static final int BORDER_W = 88;
    static final int BORDER_H = 48;
    private static final int CHIP_W = 17;
    private static final int CHIP_H = 10;
    private static final int CHIP_PART_H = 6;
    private static final int PORTRAIT_WH = 27;
    private static final int FONT_W = 9;
    private static final int FONT_H = 12;
    private static final int MAX_LERPING = 3;
    public static final int DEF_SPEED = 256;
    private static final int PLAYER_CHIP = 1;
    private static final int DEALER_CHIP = 2;
    private static final int WAR_BET = 0;
    private static final int WAR_TOSS_CHIPS = 1;
    private static final int WAR_DEAL = 2;
    private static final int WAR_PLAYERCHOOSE = 3;
    private static final int WAR_DEALERCHOOSE = 4;
    private static final int WAR_RESOLVE = 5;
    private static final int WAR_REDEAL = 6;
    private static final int WAR_PLAYERDISCARD = 7;
    private static final int WAR_DEALERDISCARD = 8;
    private static final int WAR_PICKWARCARD = 9;
    private static final int WAR_RESOLVEFINAL = 10;
    private static final int WAR_MESSAGE = 11;
    private static final int PLAYER_TURN = 137;
    private static final int DEALER_TURN = 272;
    private static final int DEALER_MOVE_TIMEOUT = 750;

    CardGames() {
    }

    public static final void initGame(int n, ScriptThread scriptThread, boolean bl) {
        numCardsLerping = 0;
        callingThread = scriptThread;
        App.beginImageLoading();
        flakImg = App.loadImageFromIndex(5);
        imgOtherImgs = App.loadImageFromIndex(38);
        imgTable = App.loadImageFromIndex(39);
        App.endImageLoading();
        Canvas.setState(12);
        xMin = Canvas.screenRect[2] / 2 - 88;
        xMaxW = Math.min(176, Canvas.screenRect[2]);
        BJPortX = xMin + 1;
        BJChipsX = xMin + 27 + 3;
        GuntherPortX = xMin + xMaxW - 28;
        GuntherChipsX = xMin + xMaxW - 30 - 17;
        chipsY = Canvas.screenRect[3] - 10;
        Canvas.scrollWithBarMaxChars = (xMaxW - 10) / 7;
        PORTRAIT_Y = Canvas.displayRect[3] - 26;
        PORTRAIT_Y = (PORTRAIT_Y - 48) / 48 * 48;
        START_BTM_BG = PORTRAIT_Y - 48;
        CARDS_Y = (START_BTM_BG + 48) / 2 - 39;
        numParticles = 0;
        CardGames.clearParticles();
        numChips = 0;
        numChipsLerping = 0;
        Canvas.clearSoftKeys();
        playerTreasure = !bl ? 100 : Player.gold + Player.inventory[26] + Player.inventory[25] + Player.inventory[27];
        if (playerTreasure > 10) {
            chipAmount = (playerTreasure << 8) / 10;
            dealerChips = 10;
            playerChips = 10;
        } else {
            playerChips = dealerChips = playerTreasure;
            chipAmount = 256;
        }
        CardGames.setChips(playerChips, dealerChips);
        savePlayer = bl;
        startingChips = playerChips;
        aiTreasure = playerTreasure <<= 8;
        CARDS_X = (Canvas.screenRect[2] - (17 * NUM_CARDS_W + (NUM_CARDS_W - 1))) / 2;
        if (CARDS_X <= 0) {
            NUM_CARDS_W = 7;
            CARDS_X = (Canvas.screenRect[2] - (17 * NUM_CARDS_W + (NUM_CARDS_W - 1))) / 2;
        }
        WAR_CARDS_X = (Canvas.screenRect[2] - 107) / 2;
        CARD_TEXT_Y = CARDS_Y + 78 + 4;
        CARD_WAR_TEXT_Y = CARDS_Y + 25 + 1 + 25 + 5;
        CardGames.stateVars[3] = 1;
        CardGames.updateBetPerc();
        numCardsInPlay = 0;
        CardGames.resetHand();
        CardGames.setState(0);
    }

    private static final void resetHand() {
        int n;
        for (n = 0; n < 12; ++n) {
            CardGames.playersCards[n] = -1;
        }
        for (n = 0; n < 12; ++n) {
            CardGames.dealersCards[n] = -1;
        }
        numPlayerCards = 0;
        numDealerCards = 0;
    }

    public static final void endGame(int n) {
        int n2;
        Game.scriptStateVars[7] = (short)n;
        int n3 = n2 = n == 2 ? 5 : 10;
        if (savePlayer) {
            int n4 = Player.gold + Player.inventory[26] + Player.inventory[25] + Player.inventory[27];
            if ((playerTreasure & 0x80) != 0) {
                playerTreasure += 256;
            }
            int n5 = -1;
            if ((playerTreasure >>= 8) > n4) {
                n5 = 1;
            }
            boolean bl = false;
            while (n4 != playerTreasure && !bl) {
                int n6 = App.nextInt() % 4;
                if (!CardGames.giveTreasure(n5, n6) && !CardGames.giveTreasure(n5, 0)) {
                    bl = true;
                }
                n4 += n5;
            }
        }
        App.beginImageUnload();
        imgOtherImgs = null;
        imgTable = null;
        flakImg = null;
        App.endImageUnload();
        if (callingThread != null) {
            Canvas.setState(3);
            callingThread.run();
            callingThread = null;
            Player.addXP(n2);
        } else {
            MenuSystem.setMenu(24);
        }
    }

    private static final boolean giveTreasure(int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: {
                if (Player.gold + n <= 0) break;
                Player.gold += n;
                bl = true;
                break;
            }
            case 1: {
                if (Player.inventory[26] + n <= 0) break;
                Player.inventory[26] = (short)(Player.inventory[26] + n);
                bl = true;
                break;
            }
            case 2: {
                if (Player.inventory[25] + n <= 0) break;
                Player.inventory[25] = (short)(Player.inventory[25] + n);
                bl = true;
                break;
            }
            case 3: {
                if (Player.inventory[27] + n <= 0) break;
                Player.inventory[27] = (short)(Player.inventory[27] + n);
                bl = true;
            }
        }
        return bl;
    }

    private static final void nextState() {
        CardGames.setState(stateVars[0] + 1);
    }

    private static final void prevState() {
        CardGames.setState(stateVars[0] - 1);
    }

    private static final void setState(int n) {
        boolean bl;
        int n2 = stateVars[0];
        CardGames.stateVars[5] = 0;
        CardGames.stateVars[1] = n2;
        CardGames.stateVars[0] = n;
        boolean bl2 = bl = !savePlayer || (Player.gamePlayedMask & 1) != 0;
        if (n == 0) {
            if (bl) {
                Canvas.setLeftSoftKey((short)1, (short)26);
            }
            Canvas.setRightSoftKey((short)1, (short)42);
        }
    }

    public static final void updateGame(Graphics graphics) {
        CardGames.updateWar(graphics);
    }

    private static final void dealerPickCard() {
        int n;
        int n2;
        for (n2 = n = App.nextInt() % numCardsInPlay; n2 >= 0; --n2) {
            if ((cardsInPlay[n2 * 8 + 5] & 0x490) != 0) continue;
            CardGames.stateVars[7] = n2;
            return;
        }
        for (n2 = n + 1; n2 < numCardsInPlay; ++n2) {
            if ((cardsInPlay[n2 * 8 + 5] & 0x490) != 0) continue;
            CardGames.stateVars[7] = n2;
            return;
        }
        App.Error(new Exception("Cannot find a card for the dealer in dealerPickCard"), 115);
    }

    private static final boolean dealerMoveSelector() {
        boolean bl = false;
        int n = stateVars[6];
        int n2 = n % curCardsH;
        int n3 = n / curCardsH;
        int n4 = stateVars[7] % curCardsH;
        int n5 = stateVars[7] / curCardsH;
        if (n2 >= n4) {
            if (n2 > n4) {
                --n;
            } else if (n3 < n5) {
                n += curCardsH;
            } else if (n3 > n5) {
                n -= curCardsH;
            } else {
                bl = true;
            }
        }
        CardGames.stateVars[6] = ++n;
        return bl;
    }

    public static final void handleInput(int n, int n2) {
        CardGames.handleWarInput(n, n2);
    }

    private static final void dealFullDeck() {
        deckMask = 0L;
        numCardsInPlay = 0;
        int n = 0;
        for (int i = 0; i < NUM_CARDS_W; ++i) {
            for (int j = 0; j < NUM_CARDS_H; ++j) {
                n = App.nextInt() % 51;
                while (((long)(1 << n) & deckMask) != 0L) {
                    n = (n + 1) % 51;
                }
                deckMask |= (long)(1 << n);
                CardGames.dealCard(n, xMin + xMaxW, Canvas.screenRect[3], CARDS_X + 18 * i, CARDS_Y + 26 * j, 64, 256);
            }
        }
        CardGames.stateVars[6] = 1 + NUM_CARDS_W / 2 * NUM_CARDS_H;
        curCardsW = NUM_CARDS_W;
        curCardsH = NUM_CARDS_H;
    }

    private static final void dealWarHand() {
        deckMask = 0L;
        numCardsInPlay = 0;
        int n = 0;
        int n2 = CARDS_Y + 25 + 1;
        for (int i = 0; i < 6; ++i) {
            n = App.nextInt() % 51;
            while (((long)(1 << n) & deckMask) != 0L) {
                n = (n + 1) % 51;
            }
            deckMask |= (long)(1 << n);
            CardGames.dealCard(n, xMin + xMaxW, Canvas.screenRect[3], WAR_CARDS_X + 18 * i, n2, 64, 256);
        }
        CardGames.stateVars[6] = 3;
        curCardsW = 6;
        curCardsH = 1;
    }

    private static final void reDealCard(int n, int n2, int n3) {
        int[] nArray = cardsInPlay;
        deckMask &= (long)(~(1 << nArray[n + 0]));
        int n4 = App.nextInt() % 51;
        while (((long)(1 << n4) & deckMask) != 0L) {
            n4 = (n4 + 1) % 51;
        }
        nArray[n + 0] = n4;
        nArray[n + 5] = n2;
        if ((n2 & 0x20) != 0) {
            nArray[n + 6] = App.getUpTimeMs();
            ++numCardsLerping;
        } else if ((n2 & 0x40) != 0) {
            nArray[n + 6] = -1;
            ++numCardsLerping;
        }
    }

    private static final void dealCard(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9 = numCardsInPlay * 8;
        CardGames.cardsInPlay[n9 + 0] = n;
        CardGames.cardsInPlay[n9 + 1] = n2;
        CardGames.cardsInPlay[n9 + 2] = n3;
        CardGames.cardsInPlay[n9 + 3] = n4;
        CardGames.cardsInPlay[n9 + 4] = n5;
        CardGames.cardsInPlay[n9 + 5] = n6;
        int n10 = Math.abs(n4 - n2);
        CardGames.cardsInPlay[n9 + 7] = n10 > (n8 = Math.abs(n5 - n3)) ? (n10 << 15) / n7 >> 8 : (n8 << 15) / n7 >> 8;
        if ((n6 & 0x20) != 0) {
            CardGames.cardsInPlay[n9 + 6] = App.getUpTimeMs();
            ++numCardsLerping;
        } else if ((n6 & 0x40) != 0) {
            CardGames.cardsInPlay[n9 + 6] = -1;
            ++numCardsLerping;
        }
        ++numCardsInPlay;
    }

    private static final void drawCardHud(Graphics graphics) {
        Text text = Text.getSmallBuffer();
        Text.composeText((short)1, (short)150, text);
        graphics.drawString(text, Canvas.SCR_CX, 5, 1);
        text.dispose();
        graphics.drawRegion(imgOtherImgs, 0, 0, 27, 27, BJPortX, PORTRAIT_Y);
        graphics.drawRegion(imgOtherImgs, 27, 0, 27, 27, GuntherPortX, PORTRAIT_Y);
        int n = stateVars[0];
        if (numCardsLerping == 0) {
            if (n == 9) {
                if (numPlayerCards == 0) {
                    graphics.drawRegion(imgOtherImgs, 54, 0, 27, 27, BJPortX, PORTRAIT_Y);
                } else {
                    graphics.drawRegion(imgOtherImgs, 54, 0, 27, 27, GuntherPortX, PORTRAIT_Y);
                }
            } else if ((1 << n & 0x89) != 0) {
                graphics.drawRegion(imgOtherImgs, 54, 0, 27, 27, BJPortX, PORTRAIT_Y);
            } else if ((1 << n & 0x110) != 0) {
                graphics.drawRegion(imgOtherImgs, 54, 0, 27, 27, GuntherPortX, PORTRAIT_Y);
            }
        }
        CardGames.drawChips(graphics);
        if (stateVars[0] == 0) {
            int n2 = 111;
            int n3 = stateVars[3];
            int n4 = chipsY - (stateVars[3] - 1) * 3 + 4;
            graphics.drawRegion(Canvas.imgFont, (n2 & 0xF) * 9, ((n2 & 0xF0) >> 4) * 12, 9, 12, BJChipsX + 17 + 1, n4 - 2);
            if (n3 == playerChips) {
                graphics.drawRegion(imgOtherImgs, 98, 0, 17, 10, BJChipsX, n4 - 4);
            } else {
                graphics.drawRegion(imgOtherImgs, 81, 16, 17, 6, BJChipsX, n4);
            }
            graphics.drawRegion(Canvas.imgFont, (n2 & 0xF) * 9, ((n2 & 0xF0) >> 4) * 12, 9, 12, GuntherChipsX - 10, n4 - 2, 0, 2);
            if (n3 == dealerChips) {
                graphics.drawRegion(imgOtherImgs, 98, 0, 17, 10, GuntherChipsX, n4 - 4);
            } else {
                graphics.drawRegion(imgOtherImgs, 81, 16, 17, 6, GuntherChipsX, n4);
            }
        }
    }

    private static final void drawChips(Graphics graphics) {
        int n = 81;
        int n2 = 0;
        int n3 = App.getUpTimeMs();
        numChipsLerping = 0;
        for (int i = 0; i < numChips; ++i) {
            n2 = i * 7;
            if (chips[n2 + 6] > 0) {
                int n4 = n3 - chips[n2 + 5];
                if (n4 >= chips[n2 + 6]) {
                    CardGames.chips[n2 + 6] = 0;
                    graphics.drawRegion(imgOtherImgs, n, 0, 17, 10, chips[n2 + 3], chips[n2 + 4]);
                    continue;
                }
                int n5 = (n4 << 16) / (chips[n2 + 6] << 8);
                int n6 = chips[n2 + 1] + (n5 * (chips[n2 + 3] - chips[n2 + 1] << 8) >> 16);
                int n7 = chips[n2 + 2] + (n5 * (chips[n2 + 4] - chips[n2 + 2] << 8) >> 16);
                graphics.drawRegion(imgOtherImgs, n, 0, 17, 10, n6, n7);
                ++numChipsLerping;
                continue;
            }
            graphics.drawRegion(imgOtherImgs, n, 0, 17, 10, chips[n2 + 3], chips[n2 + 4]);
        }
    }

    private static final void drawCards(Graphics graphics) {
        int n = 0;
        for (int i = 0; i < numCardsInPlay; ++i) {
            int n2;
            int n3;
            int n4 = i * 8;
            int n5 = cardsInPlay[n4 + 5];
            if ((n5 & 0x80) != 0) {
                graphics.fillRect(cardsInPlay[n4 + 3], cardsInPlay[n4 + 4], 17, 25, backgroundColor & 0xFF3F3F3F);
                continue;
            }
            if ((n5 & 0x60) != 0) {
                if (n == 3) continue;
                int[] nArray = CardGames.updateLerpingCard(i);
                n3 = nArray[0];
                n2 = nArray[1];
                if ((n5 & 0x40) != 0) {
                    ++n;
                }
            } else {
                n3 = cardsInPlay[n4 + 3];
                n2 = cardsInPlay[n4 + 4];
            }
            CardGames.drawCard(graphics, n3, n2, cardsInPlay[n4 + 0], n5);
        }
    }

    private static final void drawCard(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n3 % 4;
        int n6 = n3 / 4;
        if ((n4 & 0x10) != 0) {
            graphics.drawRegion(imgOtherImgs, 0, 27, 17, 25, n, n2);
            int n7 = 0;
            int n8 = 0;
            if (n6 > 0 && n6 < 9) {
                n7 = 49 + n6 - 33;
            } else {
                switch (n6) {
                    case 0: {
                        n7 = 32;
                        break;
                    }
                    case 9: {
                        n7 = 16;
                        n8 = 15;
                        break;
                    }
                    case 10: {
                        n7 = 41;
                        break;
                    }
                    case 11: {
                        n7 = 48;
                        break;
                    }
                    case 12: {
                        n7 = 42;
                        break;
                    }
                    default: {
                        App.Error(new Exception("Invalid Card Number"), 113);
                    }
                }
            }
            if (n8 != 0) {
                graphics.drawRegion(Canvas.imgFont, (n7 & 0xF) * 9, ((n7 & 0xF0) >> 4) * 12, 9, 12, n - 1, n2 + 2);
                graphics.drawRegion(Canvas.imgFont, (n8 & 0xF) * 9, ((n8 & 0xF0) >> 4) * 12, 9, 12, n + 6, n2 + 2);
            } else {
                graphics.drawRegion(Canvas.imgFont, (n7 & 0xF) * 9, ((n7 & 0xF0) >> 4) * 12, 9, 12, n + 3, n2 + 2);
            }
            n7 = 112 + n5;
            graphics.drawRegion(Canvas.imgFont, (n7 & 0xF) * 9, ((n7 & 0xF0) >> 4) * 12, 9, 12, n + 4, n2 + 12);
        } else {
            int n9 = 17;
            int n10 = 25;
            int n11 = 0;
            if ((n4 & 2) != 0) {
                n11 |= 5;
                n -= 4;
                n2 += 4;
            } else if ((n4 & 4) != 0) {
                n11 |= 3;
            } else if ((n4 & 8) != 0) {
                n11 |= 6;
                n -= 4;
                n2 += 4;
            }
            graphics.drawRegion(imgOtherImgs, 17, 27, n9, n10, n, n2, 0, n11);
        }
        if ((n4 & 0x100) != 0) {
            graphics.drawRegion(imgOtherImgs, 51, 27, 17, 25, n, n2);
        } else if ((n4 & 0x200) != 0) {
            graphics.drawRegion(imgOtherImgs, 68, 27, 17, 25, n, n2);
        }
        if ((n4 & 0x400) != 0) {
            graphics.drawRegion(imgOtherImgs, 85, 27, 17, 25, n, n2);
        }
    }

    private static final void clearParticles() {
        for (int i = 0; i < 120; ++i) {
            CardGames.particles[i] = 0;
        }
    }

    private static final void drawParticles(Graphics graphics) {
        if (numParticles == 0) {
            return;
        }
        int n = App.getUpTimeMs() << 8;
        int n2 = (n - particleFrameTime) / 1000;
        particleFrameTime = n;
        n >>= 8;
        numParticles = 0;
        int n3 = 0;
        for (int i = 0; i < 24; ++i) {
            n3 = i * 5;
            if (particles[n3 + 4] <= 0 || !CardGames.updateParticle(n3, n2)) continue;
            int n4 = n / 100 % 4;
            if (particles[n3 + 2] > 0) {
                n4 = n4 + 2 & 3;
            }
            CardGames.drawCard(graphics, particles[n3 + 0], particles[n3 + 1], 0, 1 << n4);
            ++numParticles;
        }
    }

    private static final boolean updateParticle(int n, int n2) {
        short s = particles[n + 2];
        int n3 = particles[n + 3];
        int n4 = particles[n + 0];
        int n5 = particles[n + 1];
        n4 = (s >> 8) + n4;
        n5 = ((n3 += 10 * n2) >> 8) + n5;
        if (n4 + 17 <= 0 || n4 >= xMin + xMaxW) {
            CardGames.particles[n + 4] = 0;
            return false;
        }
        if (n5 + 25 <= 0 || n5 >= Canvas.screenRect[1] + Canvas.screenRect[3]) {
            CardGames.particles[n + 4] = 0;
            return false;
        }
        CardGames.particles[n + 2] = s;
        CardGames.particles[n + 3] = (short)n3;
        CardGames.particles[n + 0] = (short)n4;
        CardGames.particles[n + 1] = (short)n5;
        return true;
    }

    private static final int[] updateLerpingCard(int n) {
        int[] nArray = cardsInPlay;
        int n2 = n * 8;
        int[] nArray2 = new int[2];
        int n3 = nArray[n2 + 1];
        int n4 = nArray[n2 + 2];
        int n5 = nArray[n2 + 3];
        int n6 = nArray[n2 + 4];
        if (nArray[n2 + 6] == -1) {
            nArray[n2 + 6] = App.getUpTimeMs();
            nArray2[0] = n3;
            nArray2[1] = n4;
            return nArray2;
        }
        int n7 = App.getUpTimeMs() - nArray[n2 + 6];
        if (n7 >= nArray[n2 + 7]) {
            nArray2[0] = n5;
            nArray2[1] = n6;
            int n8 = n2 + 5;
            cardsInPlay[n8] = cardsInPlay[n8] & 0xFFFFFF9F;
            --numCardsLerping;
        } else {
            int n9 = (n7 << 16) / (nArray[n2 + 7] << 8);
            nArray2[0] = n3 + (n9 * (n5 - n3 << 8) >> 16);
            nArray2[1] = n4 + (n9 * (n6 - n4 << 8) >> 16);
        }
        return nArray2;
    }

    private static final void allocChip(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = numChips * 7;
        CardGames.chips[n8 + 0] = n7;
        CardGames.chips[n8 + 1] = n;
        CardGames.chips[n8 + 2] = n2;
        CardGames.chips[n8 + 3] = n3;
        CardGames.chips[n8 + 4] = n4;
        CardGames.chips[n8 + 5] = n5;
        CardGames.chips[n8 + 6] = n6;
        ++numChips;
    }

    private static final void setChips(int n, int n2) {
        int n3;
        numChips = 0;
        int n4 = chipsY;
        for (n3 = 0; n3 < n; ++n3) {
            CardGames.allocChip(BJChipsX, n4, BJChipsX, n4, 0, 0, 1);
            n4 -= 3;
        }
        n4 = chipsY;
        for (n3 = 0; n3 < n2; ++n3) {
            CardGames.allocChip(GuntherChipsX, n4, GuntherChipsX, n4, 0, 0, 2);
            n4 -= 3;
        }
    }

    public static final void drawPlayingBG(Graphics graphics) {
        graphics.fillRegion(imgTable, 0, 0, Canvas.displayRect[2], Canvas.displayRect[3] - 26);
    }

    private static final void updateWar(Graphics graphics) {
        graphics.clipRect(0, 0, Canvas.menuRect[2], Canvas.menuRect[3]);
        CardGames.drawPlayingBG(graphics);
        CardGames.drawCardHud(graphics);
        CardGames.drawParticles(graphics);
        switch (stateVars[0]) {
            case 0: {
                CardGames.WAR_BET_FUNC(graphics);
                break;
            }
            case 1: {
                CardGames.WAR_TOSS_CHIPS_FUNC();
                break;
            }
            case 2: {
                CardGames.WAR_DEAL_FUNC();
                break;
            }
            case 3: {
                CardGames.WAR_PLAYERCHOOSE_FUNC(graphics);
                break;
            }
            case 4: {
                CardGames.WAR_DEALERCHOOSE_FUNC(graphics, stateVars[5]);
                break;
            }
            case 7: {
                CardGames.WAR_PLAYERDISCARD_FUNC(graphics);
                break;
            }
            case 8: {
                CardGames.WAR_DEALERDISCARD_FUNC(graphics, stateVars[5]);
                break;
            }
            case 9: {
                CardGames.WAR_PICKWARCARD_FUNC(graphics, stateVars[5]);
                break;
            }
            case 5: 
            case 10: {
                CardGames.WAR_RESOLVE_FUNC(graphics, stateVars[5]);
                break;
            }
            case 6: {
                CardGames.WAR_REDEAL_FUNC(graphics, stateVars[5]);
                break;
            }
            case 11: {
                CardGames.WAR_MESSAGE_FUNC(graphics);
            }
        }
        Canvas.staleView = true;
        graphics.resetScreenSpace();
    }

    private static final void WAR_BET_FUNC(Graphics graphics) {
        Text text = Text.getLargeBuffer();
        if (playerTreasure == 0) {
            CardGames.stateVars[4] = 154;
            CardGames.setState(11);
            return;
        }
        text.setLength(0);
        Text.resetTextArgs();
        Text.addTextArg(betPercentage);
        Text.composeText((short)1, (short)187, text);
        text.wrapText(Canvas.scrollWithBarMaxChars);
        graphics.drawString(text, Canvas.SCR_CX, (START_BTM_BG + 48) / 2, 3);
        text.dispose();
    }

    private static final void WAR_TOSS_CHIPS_FUNC() {
        if (stateVars[5] == 0) {
            short s;
            int n;
            int n2;
            int n3 = BJChipsX + 17 + 9 + 6;
            int n4 = GuntherChipsX - 32;
            int n5 = n4 - n3;
            int n6 = chipsY - 30;
            int n7 = 30;
            int n8 = playerChips - 1;
            int n9 = stateVars[3];
            int n10 = App.getUpTimeMs();
            for (n2 = 0; n2 < n9; ++n2) {
                n = n8 * 7;
                s = App.nextByte();
                CardGames.chips[n + 3] = n3 + s % n5;
                CardGames.chips[n + 4] = n6 + s % n7;
                CardGames.chips[n + 5] = n10;
                CardGames.chips[n + 6] = 200;
                --n8;
                ++numChipsLerping;
            }
            n8 = playerChips + dealerChips - 1;
            for (n2 = 0; n2 < n9; ++n2) {
                n = n8 * 7;
                s = App.nextByte();
                CardGames.chips[n + 3] = n3 + s % n5;
                CardGames.chips[n + 4] = n6 + s % n7;
                CardGames.chips[n + 5] = n10;
                CardGames.chips[n + 6] = 200;
                --n8;
                ++numChipsLerping;
            }
            stateVars[5] = stateVars[5] + 1;
        }
        if (numChipsLerping == 0) {
            CardGames.nextState();
        }
    }

    private static final void WAR_DEAL_FUNC() {
        if (numCardsInPlay == 0 || numCardsInPlay < 24) {
            CardGames.dealFullDeck();
        } else {
            int n;
            for (n = 0; n < numPlayerCards; ++n) {
                CardGames.reDealCard(playersCards[n], 64, 256);
            }
            for (n = 0; n < numDealerCards; ++n) {
                CardGames.reDealCard(dealersCards[n], 64, 256);
            }
            CardGames.stateVars[6] = 1 + NUM_CARDS_W / 2 * NUM_CARDS_H;
        }
        CardGames.resetHand();
        CardGames.setState(3);
    }

    private static final void WAR_PLAYERCHOOSE_FUNC(Graphics graphics) {
        Text text = Text.getSmallBuffer();
        CardGames.drawCards(graphics);
        if (numCardsLerping == 0) {
            text.setLength(0);
            Text.composeText((short)1, (short)182, text);
            text.wrapText(Canvas.scrollWithBarMaxChars, 2, '\n');
            graphics.drawString(text, Canvas.SCR_CX, CARD_TEXT_Y, 1);
            CardGames.drawSelector(graphics);
        }
        text.dispose();
    }

    private static final void WAR_PICKWARCARD_FUNC(Graphics graphics, int n) {
        Text text = Text.getSmallBuffer();
        CardGames.drawCards(graphics);
        if (numPlayerCards == 0 && numCardsLerping == 0) {
            text.setLength(0);
            Text.composeText((short)1, (short)183, text);
            text.wrapText(Canvas.scrollWithBarMaxChars, 3, '\n');
            graphics.drawString(text, Canvas.SCR_CX, CARD_WAR_TEXT_Y, 1);
            CardGames.drawSelector(graphics);
        } else if (numPlayerCards == 1) {
            CardGames.stateVars[5] = CardGames.dealerAI(n);
            text.setLength(0);
            Text.composeText((short)1, (short)188, text);
            text.wrapText(Canvas.scrollWithBarMaxChars, 2, '\n');
            graphics.drawString(text, Canvas.SCR_CX, CARD_WAR_TEXT_Y, 1);
            CardGames.drawSelector(graphics);
        }
        text.dispose();
    }

    private static final void WAR_DEALERCHOOSE_FUNC(Graphics graphics, int n) {
        CardGames.drawCards(graphics);
        Text text = Text.getSmallBuffer();
        CardGames.stateVars[5] = CardGames.dealerAI(n);
        text.setLength(0);
        Text.composeText((short)1, (short)188, text);
        text.wrapText(Canvas.scrollWithBarMaxChars, 2, '\n');
        graphics.drawString(text, Canvas.SCR_CX, CARD_TEXT_Y, 1);
        CardGames.drawSelector(graphics);
        text.dispose();
    }

    private static final void WAR_DEALERDISCARD_FUNC(Graphics graphics, int n) {
        CardGames.drawCards(graphics);
        Text text = Text.getSmallBuffer();
        CardGames.stateVars[5] = CardGames.dealerAI(n);
        text.setLength(0);
        Text.composeText((short)1, (short)188, text);
        text.wrapText(Canvas.scrollWithBarMaxChars, 2, '\n');
        graphics.drawString(text, Canvas.SCR_CX, CARD_WAR_TEXT_Y, 1);
        CardGames.drawSelector(graphics);
        text.dispose();
    }

    private static final void WAR_REDEAL_FUNC(Graphics graphics, int n) {
        CardGames.drawCards(graphics);
        if (n == 0) {
            Text text = Text.getSmallBuffer();
            Text.composeText((short)1, (short)stateVars[4], text);
            text.dehyphenate();
            graphics.drawString(text, Canvas.SCR_CX, CARD_TEXT_Y, 1);
            text.dispose();
        } else if (n == 1) {
            CardGames.explodeCards();
            stateVars[5] = stateVars[5] + 1;
            ++n;
        }
        if (n == 2) {
            if (!animationDone) {
                int n2 = App.getUpTimeMs() - stateVars[2];
                int n3 = n2 / 200 & 3;
                if (n2 > 800) {
                    animationDone = true;
                } else {
                    Image image = flakImg;
                    graphics.drawRegion(image, 64 * n3, 0, 64, 64, cardsInPlay[playersCards[0] + 3] - 37, cardsInPlay[playersCards[0] + 4] - 34);
                    graphics.drawRegion(image, 64 * n3, 0, 64, 64, cardsInPlay[dealersCards[0] + 3] - 37, cardsInPlay[dealersCards[0] + 4] - 34);
                }
            }
            if (animationDone && numCardsLerping == 0 && numParticles == 0) {
                stateVars[5] = stateVars[5] + 1;
            }
        } else if (n == 3) {
            cardsDiscarded = 0;
            CardGames.resetHand();
            CardGames.dealWarHand();
            stateVars[5] = stateVars[5] + 1;
        } else if (n == 4 && numCardsLerping == 0) {
            CardGames.setState(7);
        }
        if (n == 0) {
            Canvas.clearSoftKeys();
        }
    }

    private static final void WAR_PLAYERDISCARD_FUNC(Graphics graphics) {
        CardGames.drawCards(graphics);
        if (numCardsLerping == 0) {
            Text text = Text.getSmallBuffer();
            text.setLength(0);
            if (cardsDiscarded == 0) {
                Text.composeText((short)1, (short)184, text);
            } else {
                Text.composeText((short)1, (short)185, text);
            }
            text.wrapText(Canvas.scrollWithBarMaxChars, 3, '\n');
            graphics.drawString(text, Canvas.SCR_CX, CARD_WAR_TEXT_Y, 1);
            CardGames.drawSelector(graphics);
            text.dispose();
        }
    }

    private static final void WAR_RESOLVE_FUNC(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4;
        CardGames.drawCards(graphics);
        if (n == 0) {
            CardGames.stateVars[5] = 1;
            int n5 = cardsInPlay[playersCards[numPlayerCards - 1] + 0] / 4;
            n4 = cardsInPlay[dealersCards[numDealerCards - 1] + 0] / 4;
            int n6 = 1;
            if (n5 == n4) {
                CardGames.stateVars[4] = 151;
                n6 = 3;
            } else if (n5 == 0 || n4 != 0 && n5 > n4) {
                CardGames.stateVars[4] = 149;
                n6 = 2;
            } else {
                CardGames.stateVars[4] = 148;
            }
            animationDone = false;
            if (n6 == 1 || n6 == 2) {
                n3 = stateVars[3];
                if (n6 == 1) {
                    n3 = -n3;
                }
                if (savePlayer) {
                    Player.gamePlayedMask |= 1;
                }
                playerTreasure += n3 * chipAmount;
                playerChips += n3;
                dealerChips += -n3;
                if ((aiTreasure += -n3 * chipAmount) < 0) {
                    aiTreasure = 0;
                }
                if (stateVars[3] > (n2 = Math.min(playerChips, dealerChips))) {
                    CardGames.stateVars[3] = n2;
                    CardGames.updateBetPerc();
                }
                CardGames.setChips(playerChips, dealerChips);
                CardGames.stateVars[2] = App.getUpTimeMs();
                CardGames.stateVars[5] = n6;
                backgroundColor = -16749526;
            } else {
                CardGames.setState(6);
                return;
            }
        }
        if (n != 3) {
            Text text = Text.getLargeBuffer();
            text.setLength(0);
            Text.composeText((short)1, (short)stateVars[4], text);
            text.append('|');
            Text.composeText((short)1, (short)100, text);
            text.dehyphenate();
            n4 = CARD_TEXT_Y;
            if (numCardsInPlay == 6) {
                n4 = CARD_WAR_TEXT_Y;
            }
            graphics.drawString(text, Canvas.SCR_CX, n4, 1);
            text.dispose();
            CardGames.drawSelector(graphics);
            if (!animationDone) {
                n3 = App.getUpTimeMs() - stateVars[2];
                n2 = n3 / 200 & 3;
                if (n3 > 800) {
                    animationDone = true;
                } else {
                    Image image = flakImg;
                    int n7 = 64;
                    int n8 = 64;
                    int n9 = stateVars[5] == 1 ? BJPortX + 13 - n7 / 2 : GuntherPortX + 13 - n7 / 2;
                    graphics.drawRegion(image, 64 * n2, 0, n7, n8, n9, PORTRAIT_Y + 13 - n8 / 2);
                }
            }
        }
    }

    private static final void WAR_MESSAGE_FUNC(Graphics graphics) {
        Text text = Text.getSmallBuffer();
        text.setLength(0);
        Text.composeText((short)1, (short)stateVars[4], text);
        Text.composeText((short)1, (short)50, text);
        Text.composeText((short)1, (short)100, text);
        text.wrapText(Canvas.scrollWithBarMaxChars, 10, '\n');
        graphics.drawString(text, Canvas.SCR_CX, (START_BTM_BG + 48) / 2, 3);
        text.dispose();
    }

    private static final void drawSelector(Graphics graphics) {
        if (stateVars[0] != 6) {
            int n = stateVars[6] * 8;
            graphics.drawRegion(imgOtherImgs, 34, 27, 17, 25, cardsInPlay[n + 3], cardsInPlay[n + 4]);
        }
    }

    private static final int dealerAI(int n) {
        int n2 = n;
        if (n == 0) {
            CardGames.dealerPickCard();
            n2 = n + 1;
            CardGames.stateVars[2] = App.getUpTimeMs() + 250;
        } else if (n == 1) {
            if (stateVars[2] <= App.getUpTimeMs()) {
                CardGames.stateVars[2] = App.getUpTimeMs() + 250;
                if (stateVars[8] <= App.getUpTimeMs() && CardGames.dealerMoveSelector()) {
                    n2 = n + 1;
                }
            }
        } else if (n == 2) {
            CardGames.handleWarInput(6, -5);
            n2 = 0;
        }
        return n2;
    }

    private static final void handleWarInput(int n, int n2) {
        boolean bl;
        int n3 = stateVars[0];
        int n4 = App.getUpTimeMs();
        if (stateVars[8] > n4) {
            return;
        }
        boolean bl2 = bl = !savePlayer || (Player.gamePlayedMask & 1) != 0;
        if (n3 == 11 && (n == 6 || n == 15)) {
            if (stateVars[4] == 152) {
                CardGames.endGame(1);
            } else if (stateVars[4] == 153) {
                CardGames.endGame(0);
            } else if (stateVars[4] == 154) {
                CardGames.endGame(2);
            } else {
                CardGames.setState(stateVars[1]);
            }
        } else if (!(n3 != 5 && n3 != 10 || n != 6 && n != 15)) {
            if (playerChips == 0) {
                CardGames.stateVars[4] = 153;
                CardGames.setState(11);
            } else if (dealerChips == 0) {
                CardGames.stateVars[4] = 152;
                CardGames.setState(11);
            } else {
                CardGames.setState(0);
            }
        } else if (n3 == 6 && (n == 7 || n == 6 || n == 15)) {
            if (stateVars[5] == 0) {
                stateVars[5] = stateVars[5] + 1;
                CardGames.stateVars[2] = n4;
                backgroundColor = -10092544;
            } else if (stateVars[5] == 4) {
                for (int i = 0; i < 24; ++i) {
                    int n5 = i * 8 + 5;
                    cardsInPlay[n5] = cardsInPlay[n5] & 0xFFFFFF9F;
                }
                numCardsLerping = 0;
            }
        } else if (numCardsLerping != 0 && n3 == 3) {
            for (int i = 0; i < 24; ++i) {
                int n6 = i * 8 + 5;
                cardsInPlay[n6] = cardsInPlay[n6] & 0xFFFFFF9F;
            }
            numCardsLerping = 0;
        } else if ((n == 5 || n == 15) && bl && n3 == 0) {
            CardGames.endGame(2);
        } else if (n == 6 || n == 15) {
            short s = (short)(stateVars[6] * 8);
            if (n3 == 0) {
                CardGames.setState(1);
                Canvas.clearSoftKeys();
            } else if ((n3 == 3 || n3 == 4) && numCardsLerping == 0) {
                if ((cardsInPlay[s + 5] & 0x300) != 0) {
                    return;
                }
                if (n3 == 3) {
                    CardGames.playersCards[CardGames.numPlayerCards++] = s;
                    int n7 = s + 5;
                    cardsInPlay[n7] = cardsInPlay[n7] | 0x110;
                    CardGames.nextState();
                    CardGames.stateVars[8] = n4 + 750;
                } else {
                    CardGames.dealersCards[CardGames.numDealerCards++] = s;
                    int n8 = s + 5;
                    cardsInPlay[n8] = cardsInPlay[n8] | 0x210;
                    CardGames.nextState();
                }
            } else if ((n3 == 7 || n3 == 8) && numCardsLerping == 0) {
                if ((cardsInPlay[s + 5] & 0x400) != 0) {
                    return;
                }
                if (n3 == 7) {
                    ++cardsDiscarded;
                    int n9 = s + 5;
                    cardsInPlay[n9] = cardsInPlay[n9] | 0x400;
                    CardGames.nextState();
                    CardGames.stateVars[8] = n4 + 750;
                } else {
                    int n10 = s + 5;
                    cardsInPlay[n10] = cardsInPlay[n10] | 0x400;
                    if (++cardsDiscarded < 4) {
                        CardGames.prevState();
                    } else {
                        CardGames.nextState();
                    }
                }
            } else if (n3 == 9) {
                if ((cardsInPlay[s + 5] & 0x400) != 0) {
                    return;
                }
                if (numPlayerCards == 0) {
                    CardGames.playersCards[CardGames.numPlayerCards++] = s;
                    int n11 = s + 5;
                    cardsInPlay[n11] = cardsInPlay[n11] | 0x110;
                    CardGames.stateVars[8] = n4 + 750;
                } else {
                    CardGames.dealersCards[CardGames.numDealerCards++] = s;
                    int n12 = s + 5;
                    cardsInPlay[n12] = cardsInPlay[n12] | 0x210;
                    CardGames.nextState();
                }
            }
        } else if (n == 1) {
            if (n3 == 0) {
                int n13 = stateVars[3] + 1;
                if (n13 <= playerChips && n13 <= dealerChips) {
                    stateVars[3] = stateVars[3] + 1;
                    CardGames.updateBetPerc();
                }
            } else if ((n3 == 3 || n3 == 7 || n3 == 9) && stateVars[6] - 1 >= 0) {
                stateVars[6] = stateVars[6] - 1;
            }
        } else if (n == 2) {
            if (n3 == 0) {
                int n14 = stateVars[3] - 1;
                if (n14 >= 1) {
                    stateVars[3] = stateVars[3] - 1;
                    CardGames.updateBetPerc();
                }
            } else if ((n3 == 3 || n3 == 7 || n3 == 9) && stateVars[6] + 1 < numCardsInPlay) {
                stateVars[6] = stateVars[6] + 1;
            }
        } else if (n == 4 && (n3 == 3 || n3 == 7 || n3 == 9)) {
            int n15 = stateVars[6] / curCardsH;
            if (++n15 < curCardsW) {
                stateVars[6] = stateVars[6] + curCardsH;
            }
        } else if (n == 3 && (n3 == 3 || n3 == 7 || n3 == 9)) {
            int n16 = stateVars[6] / curCardsH;
            if (--n16 >= 0) {
                stateVars[6] = stateVars[6] - curCardsH;
            }
        } else if (n == 7 && n3 == 0) {
            CardGames.setState(1);
            Canvas.clearSoftKeys();
        }
    }

    private static final void updateBetPerc() {
        betPercentage = (stateVars[3] << 16) / startingChips * 100;
        if ((betPercentage & 0x8000) != 0) {
            betPercentage += 65536;
        }
        betPercentage >>= 16;
    }

    private static final void explodeCards() {
        int[] nArray = cardsInPlay;
        CardGames.clearParticles();
        int n = App.getUpTimeMs() + 5 << 8;
        int n2 = cardsInPlay[playersCards[0] + 3];
        int n3 = cardsInPlay[playersCards[0] + 4];
        int n4 = cardsInPlay[dealersCards[0] + 3];
        int n5 = cardsInPlay[dealersCards[0] + 4];
        int[] nArray2 = new int[2];
        int n6 = 0;
        for (int i = 0; i < numCardsInPlay; ++i) {
            int n7 = i * 8;
            if ((nArray[n7 + 5] & 0x90) != 0) continue;
            n6 = numParticles * 5;
            ++numParticles;
            CardGames.particles[n6 + 0] = (short)nArray[n7 + 3];
            CardGames.particles[n6 + 1] = (short)nArray[n7 + 4];
            int n8 = nArray[n7 + 3];
            int n9 = nArray[n7 + 4];
            int n10 = (n2 - n8) * (n2 - n8) + (n3 - n9) * (n3 - n9);
            int n11 = (n4 - n8) * (n4 - n8) + (n5 - n9) * (n5 - n9);
            if (n10 <= n11) {
                Game.NormalizeVec(nArray[n7 + 3] - n2, nArray[n7 + 4] - n3, nArray2);
            } else {
                Game.NormalizeVec(nArray[n7 + 3] - n4, nArray[n7 + 4] - n5, nArray2);
            }
            CardGames.particles[n6 + 2] = (short)(nArray2[0] * 2048 >> 8);
            CardGames.particles[n6 + 3] = (short)(nArray2[1] * 2048 >> 8);
            CardGames.particles[n6 + 4] = 1;
        }
        particleFrameTime = n;
        numCardsInPlay = 0;
    }

    static {
        playerTreasure = 0;
        aiTreasure = 0;
        playerChips = 0;
        dealerChips = 0;
        startingChips = 0;
        chipAmount = 0;
        betPercentage = 0;
        CARDS_Y = 0;
        CARDS_X = 0;
        NUM_CARDS_W = 8;
        NUM_CARDS_H = 3;
        WAR_CARDS_X = 0;
        START_BTM_BG = 0;
        PORTRAIT_Y = 0;
        xMin = 0;
        xMaxW = 0;
        BJPortX = 0;
        BJChipsX = 0;
        GuntherPortX = 0;
        GuntherChipsX = 0;
        chipsY = 0;
        CARD_TEXT_Y = 0;
        CARD_WAR_TEXT_Y = 0;
        curCardsW = 0;
        curCardsH = 0;
        animationDone = false;
        cardsDiscarded = 0;
        particleFrameTime = 0;
        numParticles = 0;
        particles = new short[120];
        numChipsLerping = 0;
        numChips = 0;
        chips = new int[140];
    }
}

