/*
 * Decompiled with CFR 0.152.
 */
final class MayaCamera {
    public static int touchMe = 1;
    public int keyOffset;
    public int numKeys;
    private int curTweenTime = 0;
    public int curTween = 0;
    public ScriptThread cameraThread;
    public ScriptThread keyThread;
    public int keyThreadResumeCount = 0;
    public boolean complete;
    public int x;
    public int y;
    public int z;
    public int pitch;
    public int yaw;
    public int roll;
    public short[] aggComponents = new short[6];
    public int sampleRate;
    static final int CAM_TINYGL_SHIFT = 4;
    public boolean isTableCam = false;
    private boolean inheritYaw = false;
    private boolean inheritPitch = false;
    private boolean inheritX = false;
    private boolean inheritY = false;
    private boolean inheritZ = false;
    static int posShift = 0;
    static int angleShift = 0;
    static final int CAM_DEFAULT_FOVX = 250;

    MayaCamera() {
    }

    public void NextKey() {
        Game.activeCameraTime = App.gameTime;
        this.curTween = -1;
        this.curTweenTime = 0;
        this.resetTweenBase(this.keyOffset + ++Game.activeCameraKey);
    }

    public void Update(int n, int n2) {
        int n3;
        short[] sArray = Game.mayaCameraKeys;
        byte[] byArray = Game.mayaCameraTweens;
        if (this.complete) {
            return;
        }
        this.complete = false;
        int n4 = this.keyOffset + n;
        if (Game.cinematicWeapon != -1 && App.time > Combat.animEndTime && Combat.numActiveMissiles == 0) {
            if (Combat.animLoopCount <= 0) {
                Game.cinematicWeapon = -1;
            } else {
                --Combat.animLoopCount;
                Combat.animStartTime = App.gameTime;
                Combat.animEndTime = Combat.animStartTime + Combat.animTime;
                Combat.flashDone = false;
                Combat.flashDoneTime = Combat.animStartTime + Combat.flashTime;
                Combat.nextStageTime = Combat.animEndTime;
            }
        }
        if (n2 >= (sArray[Game.OFS_MAYAKEY_MS + n4] & 0xFFFF)) {
            if (this.keyThreadResumeCount > 0) {
                this.Snap(n);
            }
            return;
        }
        if (!this.hasTweens(n4)) {
            this.x = sArray[Game.OFS_MAYAKEY_X + n4];
            this.y = sArray[Game.OFS_MAYAKEY_Y + n4];
            this.z = sArray[Game.OFS_MAYAKEY_Z + n4];
            this.pitch = sArray[Game.OFS_MAYAKEY_PITCH + n4];
            this.yaw = sArray[Game.OFS_MAYAKEY_YAW + n4];
            this.roll = sArray[Game.OFS_MAYAKEY_ROLL + n4];
            if (this.x == -2) {
                this.x = Game.camPlayerX;
            }
            if (this.y == -2) {
                this.y = Game.camPlayerY;
            }
            if (this.z == -2) {
                this.z = Game.camPlayerZ;
            }
            this.x <<= 4;
            this.y <<= 4;
            this.z <<= 4;
            if (this.yaw == -2) {
                this.yaw = Game.camPlayerYaw;
            }
            if (this.pitch == -2) {
                this.pitch = Game.camPlayerPitch;
            }
        } else {
            short[] sArray2 = null;
            n3 = this.sampleRate;
            if (this.curTween == -1) {
                if (n2 >= this.curTweenTime + this.sampleRate) {
                    this.curTween = 0;
                    this.curTweenTime += this.sampleRate;
                    this.updateTweenBase(n4, 0);
                } else {
                    sArray2 = this.getTweenData(byArray, n4, 0);
                }
            }
            if (sArray2 == null) {
                int n5 = this.estNumTweens(n4) - 1;
                while (this.curTween != n5 && n2 >= this.curTweenTime + this.sampleRate) {
                    this.curTweenTime += this.sampleRate;
                    ++this.curTween;
                    this.updateTweenBase(n4, this.curTween);
                }
                if (this.curTween == n5) {
                    sArray2 = this.getKeyOfs(sArray, n4 + 1);
                    n3 = (sArray[Game.OFS_MAYAKEY_MS + n4] & 0xFFFF) - this.curTweenTime;
                } else {
                    sArray2 = this.getTweenData(byArray, n4, this.curTween + 1);
                }
            }
            this.Interpolate(sArray2, (n2 - this.curTweenTime << 16) / n3);
        }
        int n6 = (n2 << 16) / (sArray[Game.OFS_MAYAKEY_MS + n4] & 0xFFFF);
        if (this.inheritX && sArray[Game.OFS_MAYAKEY_X + n4 + 1] != -2) {
            this.x = (this.aggComponents[0] << 20) + n6 * (sArray[Game.OFS_MAYAKEY_X + n4 + 1] - this.aggComponents[0] << 4) + 32768 >> 16;
        }
        if (this.inheritY && sArray[Game.OFS_MAYAKEY_Y + n4 + 1] != -2) {
            this.y = (this.aggComponents[1] << 20) + n6 * (sArray[Game.OFS_MAYAKEY_Y + n4 + 1] - this.aggComponents[1] << 4) + 32768 >> 16;
        }
        if (this.inheritZ && sArray[Game.OFS_MAYAKEY_Z + n4 + 1] != -2) {
            this.z = (this.aggComponents[2] << 20) + n6 * (sArray[Game.OFS_MAYAKEY_Z + n4 + 1] - this.aggComponents[2] << 4) + 32768 >> 16;
        }
        if (this.inheritYaw && sArray[Game.OFS_MAYAKEY_YAW + n4 + 1] != -2) {
            n3 = this.getAngleDifference(this.aggComponents[4], sArray[Game.OFS_MAYAKEY_YAW + n4 + 1]);
            this.yaw = (this.aggComponents[4] << 16) + n6 * n3 + 32768 >> 16;
        }
        if (this.inheritPitch && sArray[Game.OFS_MAYAKEY_PITCH + n4 + 1] != -2) {
            n3 = this.getAngleDifference(this.aggComponents[3], sArray[Game.OFS_MAYAKEY_PITCH + n4 + 1]);
            this.pitch = (this.aggComponents[3] << 16) + n6 * n3 + 32768 >> 16;
        }
    }

    private int getAngleDifference(int n, int n2) {
        if (n2 - n > 512) {
            n2 -= 1024;
        } else if (n2 - n < -512) {
            n2 += 1024;
        }
        return n2 - n;
    }

    public boolean hasTweens(int n) {
        for (int i = 0; i < 6; ++i) {
            short s = Game.mayaTweenIndices[n * 6 + i];
            if (s == -1 || s == -2) continue;
            return true;
        }
        return false;
    }

    public int estNumTweens(int n) {
        if (n + 1 == Game.totalMayaCameraKeys) {
            return 0;
        }
        return ((Game.mayaCameraKeys[Game.OFS_MAYAKEY_MS + n] & 0xFFFF) - 1) / this.sampleRate;
    }

    private short[] getTweenData(byte[] byArray, int n, int n2) {
        short[] sArray = new short[6];
        short[] sArray2 = Game.ofsMayaTween;
        short s = 0;
        for (int i = 0; i < 6; ++i) {
            s = Game.mayaTweenIndices[n * 6 + i];
            sArray[i] = s != -1 && s != -2 ? (short)byArray[sArray2[i] + s + n2] : (short)0;
        }
        return sArray;
    }

    private short[] getKeyOfs(short[] sArray, int n) {
        short[] sArray2 = new short[]{this.inheritX ? (short)0 : (short)(sArray[Game.OFS_MAYAKEY_X + n] - this.aggComponents[0]), this.inheritY ? (short)0 : (short)(sArray[Game.OFS_MAYAKEY_Y + n] - this.aggComponents[1]), this.inheritZ ? (short)0 : (short)(sArray[Game.OFS_MAYAKEY_Z + n] - this.aggComponents[2]), this.inheritPitch ? (short)0 : (short)this.getAngleDifference(this.aggComponents[3] & 0x3FF, sArray[Game.OFS_MAYAKEY_PITCH + n]), this.inheritYaw ? (short)0 : (short)this.getAngleDifference(this.aggComponents[4] & 0x3FF, sArray[Game.OFS_MAYAKEY_YAW + n]), (short)this.getAngleDifference(this.aggComponents[5] & 0x3FF, sArray[Game.OFS_MAYAKEY_ROLL + n])};
        return sArray2;
    }

    private void Interpolate(short[] sArray, int n) {
        this.pitch = (this.aggComponents[3] << 16) + n * sArray[3] + 32768 >> 16;
        this.yaw = (this.aggComponents[4] << 16) + n * sArray[4] + 32768 >> 16;
        this.roll = (this.aggComponents[5] << 16) + n * sArray[5] + 32768 >> 16;
        this.x = (this.aggComponents[0] << 20) + n * (sArray[0] << 4) + 32768 >> 16;
        this.y = (this.aggComponents[1] << 20) + n * (sArray[1] << 4) + 32768 >> 16;
        this.z = (this.aggComponents[2] << 20) + n * (sArray[2] << 4) + 32768 >> 16;
    }

    private void resetTweenBase(int n) {
        short[] sArray = Game.mayaCameraKeys;
        short[] sArray2 = this.aggComponents;
        sArray2[0] = sArray[Game.OFS_MAYAKEY_X + n];
        sArray2[1] = sArray[Game.OFS_MAYAKEY_Y + n];
        sArray2[2] = sArray[Game.OFS_MAYAKEY_Z + n];
        sArray2[3] = sArray[Game.OFS_MAYAKEY_PITCH + n];
        sArray2[4] = sArray[Game.OFS_MAYAKEY_YAW + n];
        sArray2[5] = sArray[Game.OFS_MAYAKEY_ROLL + n];
        if (sArray2[0] == -2) {
            sArray2[0] = (short)Game.camPlayerX;
            this.inheritX = true;
        } else {
            this.inheritX = false;
        }
        if (sArray2[1] == -2) {
            sArray2[1] = (short)Game.camPlayerY;
            this.inheritY = true;
        } else {
            this.inheritY = false;
        }
        if (sArray2[2] == -2) {
            sArray2[2] = (short)Game.camPlayerZ;
            this.inheritZ = true;
        } else {
            this.inheritZ = false;
        }
        if (sArray2[3] == -2) {
            sArray2[3] = (short)Game.camPlayerPitch;
            this.inheritPitch = true;
        } else {
            this.inheritPitch = false;
        }
        if (sArray2[4] == -2) {
            sArray2[4] = (short)Game.camPlayerYaw;
            this.inheritYaw = true;
        } else {
            this.inheritYaw = false;
        }
    }

    private void updateTweenBase(int n, int n2) {
        byte[] byArray = Game.mayaCameraTweens;
        short s = 0;
        for (int i = 0; i < 6; ++i) {
            s = Game.mayaTweenIndices[n * 6 + i];
            if (s == -1 || s == -2) continue;
            int n3 = Game.ofsMayaTween[i] + s + n2;
            byte by = byArray[n3];
            int n4 = i;
            this.aggComponents[n4] = (short)(this.aggComponents[n4] + by);
        }
    }

    public void Render() {
        if (Canvas.state == 8) {
            Render.render(this.x, this.y, this.z, this.yaw, this.pitch, this.roll, 250);
        } else {
            Render.render(this.x, this.y, this.z, this.yaw, this.pitch, this.roll, 250);
        }
        if (Game.cinematicWeapon != -1) {
            Combat.drawWeapon(0, 0);
        }
        if (Render.isFading()) {
            Render.fadeScene();
        }
        Canvas.repaintFlags |= 0x40;
    }

    public void Snap(int n) {
        short[] sArray = Game.mayaCameraKeys;
        if (this.complete) {
            return;
        }
        int n2 = this.keyOffset + n;
        if (n2 + 1 < this.keyOffset + this.numKeys) {
            int n3 = n2 + 1;
            this.x = sArray[Game.OFS_MAYAKEY_X + n3] << 4;
            this.y = sArray[Game.OFS_MAYAKEY_Y + n3] << 4;
            this.z = sArray[Game.OFS_MAYAKEY_Z + n3] << 4;
            this.pitch = sArray[Game.OFS_MAYAKEY_PITCH + n3];
            this.yaw = sArray[Game.OFS_MAYAKEY_YAW + n3];
            this.roll = sArray[Game.OFS_MAYAKEY_ROLL + n3];
            if (this.inheritX && sArray[Game.OFS_MAYAKEY_X + n3] == -2) {
                this.x = Game.camPlayerX << 4;
            }
            if (this.inheritY && sArray[Game.OFS_MAYAKEY_Y + n3] == -2) {
                this.y = Game.camPlayerY << 4;
            }
            if (this.inheritZ && sArray[Game.OFS_MAYAKEY_Z + n3] == -2) {
                this.z = Game.camPlayerZ << 4;
            }
            if (this.inheritPitch && sArray[Game.OFS_MAYAKEY_PITCH + n3] == -2) {
                this.pitch = (short)Game.camPlayerPitch;
            }
            if (this.inheritYaw && sArray[Game.OFS_MAYAKEY_YAW + n3] == -2) {
                this.yaw = (short)Game.camPlayerYaw;
            }
            if (null != this.keyThread && --this.keyThreadResumeCount == 0) {
                ScriptThread scriptThread = this.keyThread;
                this.keyThread = null;
                scriptThread.run();
            } else if (null != this.keyThread && this.keyThreadResumeCount > 0) {
                this.NextKey();
            } else if (this.isTableCam) {
                this.NextKey();
            }
            return;
        }
        this.complete = true;
        Game.skippingCinematic = false;
        Game.cinUnpauseTime = 0;
        Game.activeCameraView = false;
        if (Canvas.state != 18) {
            return;
        }
        TinyGL.resetViewPort();
        Canvas.setState(3);
        Canvas.updateFacingEntity = true;
        if (null != this.keyThread) {
            ScriptThread scriptThread = this.keyThread;
            this.keyThread = null;
            scriptThread.run();
        }
        this.cameraThread = null;
        Canvas.destPitch = 0;
        Canvas.viewPitch = 0;
        Canvas.startRotation(true);
    }
}

