/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class PngEncoder {
    public static Object lock = new Object();
    public static final int BLOCK_INFO_SIZE = 11;
    public static final int PNG_INFO_SIZE = 57;
    public static final int HEADER_LEVEL0_MAX_WBITS = 30938;
    protected static final byte[] MAGIC = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    protected static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    protected static final byte[] PLTE = new byte[]{80, 76, 84, 69};
    protected static final byte[] tRNS = new byte[]{116, 82, 78, 83};
    protected static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    protected static final byte[] IEND = new byte[]{73, 69, 78, 68};
    protected static final byte[] INFO32 = new byte[]{8, 6, 0, 0, 0};
    protected static final byte[] INFO8 = new byte[]{8, 3, 0, 0, 0};
    protected static final byte[] MAGIC_tRNS = new byte[]{0, 0, 0, 1, 116, 82, 78, 83, 0, 64, -26, -40, 102};
    protected static final byte[] MAGIC_tRNS_NO = new byte[]{0, 0, 0, 1, 116, 82, 78, 83, -1, 64, -26, -40, 102};
    protected static final byte[] MAGIC_IEND = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    static byte[] _buffer_index;
    static byte[] _png_index;
    static byte[] _png_result;
    static int _png_size;
    static int _png_start_crc;
    public static int[] crcTable;
    public static final int CRC32_POLYNOMIAL = -306674912;
    public static final int BASE = 65521;
    public static final int FLAG_FLIP_HORIZONTAL = 1;
    public static final int FLAG_FLIP_VERTICAL = 2;
    public static final int FLAG_FLIP_HV = 3;

    static void reset(int n, boolean bl) {
        _png_size = 0;
        if (_png_result == null) {
            _png_result = new byte[n];
            return;
        }
        if (_png_result.length > n && bl) {
            _png_result = new byte[n];
            return;
        }
        if (_png_result.length < n) {
            _png_result = new byte[n];
            return;
        }
    }

    static byte[] getPngBuffer() {
        return _png_result;
    }

    static int getPngBytesCount() {
        return _png_size;
    }

    static void putArray(byte[] byArray) {
        System.arraycopy(byArray, 0, _png_result, _png_size, byArray.length);
        _png_size += byArray.length;
    }

    static void putInt(int n) {
        PngEncoder._png_result[PngEncoder._png_size++] = (byte)(n >> 24 & 0xFF);
        PngEncoder._png_result[PngEncoder._png_size++] = (byte)(n >> 16 & 0xFF);
        PngEncoder._png_result[PngEncoder._png_size++] = (byte)(n >> 8 & 0xFF);
        PngEncoder._png_result[PngEncoder._png_size++] = (byte)(n & 0xFF);
    }

    static void beginChunk(byte[] byArray, int n) {
        PngEncoder.putInt(n);
        _png_start_crc = _png_size;
        PngEncoder.putArray(byArray);
    }

    public static Image buildPNG8(short[] sArray, boolean bl, byte[] byArray, int n, int n2, int n3) {
        long l = 1L;
        int n4 = _png_size;
        _png_size = 0;
        if (bl) {
            _png_size = 33;
        } else {
            PngEncoder.putArray(MAGIC);
            PngEncoder.beginChunk(IHDR, 13);
            PngEncoder.putInt(n);
            PngEncoder.putInt(n2);
            PngEncoder.putArray(INFO8);
            PngEncoder.putInt(PngEncoder.crc32(_png_result, _png_start_crc, _png_size - _png_start_crc, 0));
        }
        PngEncoder.beginChunk(PLTE, sArray.length * 3);
        int n5 = 0;
        while (n5 < sArray.length) {
            short s = sArray[n5];
            PngEncoder._png_result[PngEncoder._png_size++] = (byte)(((s & 0xF00) >>> 8) * 17);
            PngEncoder._png_result[PngEncoder._png_size++] = (byte)(((s & 0xF0) >>> 4) * 17);
            PngEncoder._png_result[PngEncoder._png_size++] = (byte)((s & 0xF) * 17);
            ++n5;
        }
        PngEncoder.putInt(PngEncoder.crc32(_png_result, _png_start_crc, _png_size - _png_start_crc, 0));
        if (bl) {
            _png_size = n4;
        } else {
            PngEncoder.beginChunk(tRNS, sArray.length);
            n5 = 0;
            while (n5 < sArray.length) {
                PngEncoder._png_result[PngEncoder._png_size++] = (byte)(((sArray[n5] & 0xF000) >> 12) * 17);
                ++n5;
            }
            PngEncoder.putInt(PngEncoder.crc32(_png_result, _png_start_crc, _png_size - _png_start_crc, 0));
            int n6 = n * n2 + n2;
            PngEncoder.beginChunk(IDAT, n6 + 11);
            PngEncoder._png_result[PngEncoder._png_size++] = 120;
            PngEncoder._png_result[PngEncoder._png_size++] = -38;
            PngEncoder._png_result[PngEncoder._png_size++] = 1;
            PngEncoder._png_result[PngEncoder._png_size++] = (byte)n6;
            PngEncoder._png_result[PngEncoder._png_size++] = (byte)(n6 >>> 8);
            PngEncoder._png_result[PngEncoder._png_size++] = (byte)(~n6);
            PngEncoder._png_result[PngEncoder._png_size++] = (byte)(~n6 >>> 8);
            int n7 = _png_size;
            switch (n3 & 3) {
                case 0: {
                    int n8 = 0;
                    while (n8 < n2) {
                        PngEncoder._png_result[PngEncoder._png_size++] = 0;
                        System.arraycopy(byArray, n8 * n, _png_result, _png_size, n);
                        _png_size += n;
                        ++n8;
                    }
                    break;
                }
                case 1: {
                    int n9 = 0;
                    while (n9 < n2) {
                        int n10 = (n9 + 1) * n;
                        PngEncoder._png_result[PngEncoder._png_size++] = 0;
                        n5 = 0;
                        while (n5 < n) {
                            PngEncoder._png_result[PngEncoder._png_size++] = byArray[--n10];
                            ++n5;
                        }
                        ++n9;
                    }
                    break;
                }
                case 2: {
                    int n11 = 0;
                    while (n11 < n2) {
                        PngEncoder._png_result[PngEncoder._png_size++] = 0;
                        System.arraycopy(byArray, (n2 - n11 - 1) * n, _png_result, _png_size, n);
                        _png_size += n;
                        ++n11;
                    }
                    break;
                }
                case 3: {
                    int n12 = 0;
                    while (n12 < n2) {
                        int n13 = (n2 - n12) * n;
                        PngEncoder._png_result[PngEncoder._png_size++] = 0;
                        n5 = 0;
                        while (n5 < n) {
                            PngEncoder._png_result[PngEncoder._png_size++] = byArray[--n13];
                            ++n5;
                        }
                        ++n12;
                    }
                    break;
                }
            }
            l = PngEncoder.adler32(l, _png_result, n7, n6);
            PngEncoder.putInt((int)l);
            PngEncoder.putInt(PngEncoder.crc32(_png_result, _png_start_crc, _png_size - _png_start_crc, 0));
            PngEncoder.putArray(MAGIC_IEND);
        }
        Thread.yield();
        return Image.createImage((byte[])PngEncoder.getPngBuffer(), (int)0, (int)PngEncoder.getPngBytesCount());
    }

    static boolean buildCrcTable() {
        if (crcTable != null) {
            return false;
        }
        crcTable = new int[256];
        int n = 0;
        while (n < 256) {
            int n2 = n;
            int n3 = 8;
            while (n3 > 0) {
                n2 = (n2 & 1) == 1 ? n2 >>> 1 ^ 0xEDB88320 : (n2 >>>= 1);
                --n3;
            }
            PngEncoder.crcTable[n] = n2;
            ++n;
        }
        return true;
    }

    public static int crc32(byte[] byArray, int n, int n2, int n3) {
        n3 ^= 0xFFFFFFFF;
        while (n2-- != 0) {
            n3 = crcTable[(n3 ^ byArray[n++]) & 0xFF] ^ n3 >>> 8;
        }
        return ~n3;
    }

    static long adler32(long l, byte[] byArray, int n, int n2) {
        long l2 = l & 0xFFFFL;
        long l3 = l >> 16 & 0xFFFFL;
        while (n2-- > 0) {
            l3 += (l2 += (long)(byArray[n++] & 0xFF));
            l2 %= 65521L;
            l3 %= 65521L;
        }
        return l3 << 16 | l2;
    }

    static {
        crcTable = null;
    }
}

