/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.furby;

import com.lemonquest.furby.Items;

public class Inventory {
    public static final int INVENTORY_CAPACITY = 21;
    private short[] inventory;
    private Items items;

    public Inventory(Items items) {
        this.items = items;
        this.initInventory();
    }

    private void initInventory() {
        this.inventory = new short[21];
    }

    public short getShortSlot(int numSlot) {
        return this.inventory[numSlot];
    }

    public void setShortSlot(short sItem, int numSlot) {
        this.inventory[numSlot] = sItem;
    }

    private int getSlotEqualItem(int typeItem, int numItem, int stack) {
        for (int i = 0; i < 21; ++i) {
            if (typeItem != this.getTypeItem(i) || numItem != this.getNumItem(i) || this.getStackItem(i) + stack > 99) continue;
            return i;
        }
        return -1;
    }

    public boolean isItemInInventory(int typeItem, int numItem, int stack) {
        for (int i = 0; i < 21; ++i) {
            if (typeItem != this.getTypeItem(i) || numItem != this.getNumItem(i) || this.getStackItem(i) < stack) continue;
            return true;
        }
        return false;
    }

    public boolean canAddItem(int typeItem, int numItem, int stack) {
        int posEqualItem = this.getSlotEqualItem(typeItem, numItem, stack);
        if (posEqualItem != -1 && this.getStackItem(posEqualItem) + stack <= 99) {
            return true;
        }
        return this.getEmptySlot() != -1;
    }

    public void addItem(int typeItem, int numItem, int stack) {
        int posEqualItem = this.getSlotEqualItem(typeItem, numItem, stack);
        if (posEqualItem != -1) {
            this.addItem(typeItem, numItem, this.getStackItem(posEqualItem) + stack, posEqualItem);
        } else {
            this.addItem(typeItem, numItem, stack, this.getEmptySlot());
        }
    }

    public void removeItem(int typeItem, int numItem, int stack) {
        for (int i = 0; i < 21; ++i) {
            if (this.isEmptySlot(i) || typeItem != this.getTypeItem(i) || numItem != this.getNumItem(i)) continue;
            if (stack > this.getStackItem(i)) {
                this.removeItem(i);
                continue;
            }
            this.inventory[i] = (short)((this.getStackItem(i) - stack & 0xFF) << 8 | (typeItem & 1) << 7 | numItem & 0x7F);
        }
    }

    public void removeItem(int posSlot) {
        if (!this.isEmptySlot(posSlot)) {
            this.inventory[posSlot] = (short)((this.getStackItem(posSlot) - 1 & 0xFF) << 8 | (this.getTypeItem(posSlot) & 1) << 7 | this.getNumItem(posSlot) & 0x7F);
        }
    }

    private void addItem(int typeItem, int numItem, int stack, int posSlot) {
        this.inventory[posSlot] = (short)((stack & 0xFF) << 8 | (typeItem & 1) << 7 | numItem & 0x7F);
    }

    public int getTypeItem(int posSlot) {
        return this.inventory[posSlot] >> 7 & 1;
    }

    public int getStackItem(int posSlot) {
        return this.inventory[posSlot] >> 8 & 0xFF;
    }

    public int getNumItem(int posSlot) {
        return this.inventory[posSlot] & 0x7F;
    }

    public int getEmptySlot() {
        for (int i = 0; i < 21; ++i) {
            if ((this.inventory[i] >> 8 & 0xFF) != 0) continue;
            return i;
        }
        return -1;
    }

    public int getActualCapacity() {
        int numItems = 0;
        for (int i = 0; i < 21; ++i) {
            if ((this.inventory[i] >> 8 & 0xFF) <= 0) continue;
            ++numItems;
        }
        return numItems;
    }

    public boolean isEmptySlot(int posSlot) {
        return this.getStackItem(posSlot) == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Iventory:\n");
        for (int i = 0; i < 21; ++i) {
            int type = this.getTypeItem(i);
            int stack = this.getStackItem(i);
            int numItem = this.getNumItem(i);
            sb.append(" Item[");
            sb.append(i);
            sb.append("]: ");
            if (!this.isEmptySlot(i)) {
                sb.append(stack);
                sb.append(" x ");
                sb.append(this.items.getNameItem(type, numItem));
                sb.append("\n");
                continue;
            }
            sb.append("--- No Item ---");
        }
        return sb.toString();
    }

    public void destroy() {
        this.inventory = null;
    }
}

