/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.furby;

import com.lemonquest.furby.Actor;
import com.lemonquest.furby.GameCanvas;
import com.lemonquest.furby.GameMIDlet;
import com.lemonquest.furby.Inventory;
import com.lemonquest.furby.IsoEngine;
import com.lemonquest.furby.Items;
import com.lemonquest.furby.QuestManager;
import com.lemonquest.utils.SSFunctions;
import com.lemonquest.utils.SSKeyboard;
import com.lemonquest.utils.SSMusic;
import com.lemonquest.utils.SSTextBox;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class GameEngine
extends Canvas {
    private boolean running;
    public long lastProcessTime;
    private long pauseTime;
    public static final int MAX_PROCESS = 40;
    public boolean bSound = true;
    public int state;
    public static final int STATE_SPLASH = 0;
    public static final int STATE_SPLASH_HASBRO = 1;
    public static final int STATE_COVER = 2;
    public static final int STATE_SOUND_QUESTION = 3;
    public static final int STATE_MAIN_MENU = 4;
    public static final int STATE_GAME = 5;
    public static final int STATE_HELP = 6;
    public static final int STATE_ABOUT = 7;
    public static final int STATE_IN_GAME_MENU = 8;
    public static final int STATE_TUTORIAL = 9;
    public static final int STATE_NEW_GAME = 10;
    public static final int STATE_EXIT_QUESTION = 11;
    public static final int STATE_EXIT_QUESTION_INGAME = 12;
    public static final int STATE_LOADING = 99;
    private int[] stateGameList;
    private String[] messagesList;
    private int lastStateGame;
    private String lastMessage;
    private int posStateGameRead;
    private int posStateGameWrite;
    public static final int MAX_STATE_GAME_LIST = 5;
    public int stateGame;
    public static final int STATE_GAME_WORLD = 0;
    public static final int STATE_GAME_BUTTONS_INTERFACE = 1;
    public static final int STATE_GAME_INTERFACE = 2;
    public static final int STATE_GAME_STORE_POPUP_BUY = 3;
    public static final int STATE_GAME_STORE_POPUP_SELL = 4;
    public static final int STATE_GAME_HANDCRAFT_POPUP = 5;
    public static final int STATE_GAME_MINIGAME_GOW = 6;
    public static final int STATE_GAME_MINIGAME_GOW_WAIT = 7;
    public static final int STATE_GAME_POPUP = 8;
    public static final int STATE_GAME_TALK = 9;
    public static final int STATE_GAME_GROWN = 10;
    public static final int STATE_GAME_HANDCRAFTING = 11;
    public static final int STATE_GAME_WHISTLING = 12;
    public static final int STATE_GAME_FADING = 13;
    public static final int STATE_GAME_PARTY = 14;
    public static final int STATE_GAME_OVER = 15;
    public int stateFurby;
    public static final int STATE_FURBY_NORMAL = 0;
    public static final int STATE_FURBY_FISHING = 1;
    public static final int STATE_FURBY_RECOLECTING_ROCK = 2;
    public static final int STATE_FURBY_RECOLECTING_SHELL = 3;
    public static final int STATE_FURBY_RECOLECTING_WOOD = 4;
    public static final int STATE_FURBY_RECOLECTING_PLANT = 5;
    public static final int STATE_FURBY_WHISTLING = 6;
    private static final int MENU_MAIN_MENU = 0;
    private static final int MENU_HELP = 1;
    private static final int MENU_ABOUT = 2;
    public static final int MENU_IN_GAME = 3;
    private static final int MENU_NEW_CONTINUE = 4;
    private static final int MENU_TUTORIAL = 5;
    public static final int INTERFACE_INFO = 0;
    public static final int INTERFACE_INVENTORY = 1;
    public static final int INTERFACE_MAP = 2;
    public static final int INTERFACE_QUESTS = 3;
    public static final int INTERFACE_HANDCRAFT = 4;
    public static final int INTERFACE_MENU = 5;
    public static final int INTERFACE_STORE_BUY = 6;
    public static final int INTERFACE_STORE_SELL = 7;
    public static final int INTERFACE_DICTIONARY = 8;
    public SSKeyboard keyboard;
    private GameCanvas gc;
    private GameMIDlet gm;
    public Random random;
    public int iconLeft = -1;
    public int iconRight = -1;
    public String[] lang;
    public String[] optionsMenu;
    public String urlGetMoreGames;
    public int[] dictionaryWordsPrices = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8};
    public long timeFinish = 0L;
    private static final int TIME_SPLASH = 3000;
    private static final int TIME_COVER = 3000;
    public boolean activeButton;
    public int optionActual = 0;
    public int optionInterface = 0;
    public int posInventory;
    public int posStore;
    public int optionPopup = 0;
    public int tutorialActual = 0;
    public int posMinList = 0;
    public int numItems = 0;
    public int posFurbyMap;
    public int maxOptions;
    private long timeScrollText;
    private boolean loading;
    private boolean downPressed = false;
    private boolean upPressed = false;
    private static final int TIME_SCROLL_TEXT = 50;
    public SSTextBox textBox;
    public short[][] lineData;
    public int lineActual;
    public int linesScreen;
    public int maxLines;
    private boolean hasLoadGame;
    public SSMusic music;
    public int sMusic;
    public int sGood;
    private final int CHEAT_SHOP;
    private final int CHEAT_SKILL_1;
    private final int CHEAT_SKILL_2;
    private final int CHEAT_SKILL_3;
    private final int CHEAT_SKILL_4;
    private final int CHEAT_SKILL_5;
    private final int CHEAT_SKILL_6;
    private final int CHEAT_SKILL_7;
    private final int CHEAT_SKILL_8;
    private final int CHEAT_MONEY;
    private final int CHEAT_QUEST;
    private int[] cheatState = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final String[] cheatCode = new String[]{"347467", "34754551", "34754552", "34754553", "34754554", "34754555", "34754556", "34754557", "34754558", "3466639", "3478378"};
    public final char[][] lettersGame = new char[][]{{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I'}, {'J', 'K', 'L', 'M', 'N', '\u00d1', 'O', 'P', 'Q'}, {'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'}};
    public static final char[][] letters = new char[][]{{'A', 'B', 'C'}, {'D', 'E', 'F'}, {'G', 'H', 'I'}, {'J', 'K', 'L'}, {'M', 'N', '\u00d1', 'O'}, {'P', 'Q', 'R', 'S'}, {'T', 'U', 'V'}, {'W', 'X', 'Y', 'Z'}};
    public int posLetter;
    public int posSymbol;
    public char actualChar;
    public IsoEngine isoEngine;
    public QuestManager qm;
    public Inventory inventory;
    public boolean[] houseObjects;
    public Items items;
    public static final int MAX_BUTTONS_INTERFACE = 8;
    private byte[] buttons;
    private short[] buttonsAngle;
    private short[] buttonsAngleOffset;
    public String messageTextDown;
    public String messagePopup;
    public int idFurbyTalk;
    private long timeFootprint;
    private boolean footFootprint;
    public static final int MINIGAME_GOW_MAX_TIME = 750;
    public static final int MINIGAME_GOW_TIME_WAIT = 3000;
    public static final int MINIGAME_GOW_MEDIUM_ZONE_PERCENT = 25;
    public static final int MINIGAME_GOW_HIGH_ZONE_PERCENT = 5;
    public static final int MINIGAME_GOW_SCORE_ZONE_BAD = 0;
    public static final int MINIGAME_GOW_SCORE_ZONE_MEDIUM = 100;
    public static final int MINIGAME_GOW_SCORE_ZONE_HIGH = 200;
    public int percentZoneMedium;
    public int percentZoneMediumSize;
    public int percentZoneHigh;
    public int percentZoneHighSize;
    public int percentPiece;
    public long timeStartMiniGameGow;
    public long timeBornFurby;
    private int scoreMiniGame;
    private int numRounds;
    private int idObjectList;
    public static final int MODIFIER_SKILL_SHELLS = 0;
    public static final int MODIFIER_SKILL_GEOLOGY = 1;
    public static final int MODIFIER_SKILL_FISHING = 2;
    public static final int MODIFIER_SKILL_PLANT = 3;
    public static final int MODIFIER_SKILL_CHOP = 4;
    public static final int MODIFIER_SKILL_HANDCRAFT1 = 5;
    public static final int MODIFIER_SKILL_HANDCRAFT2 = 6;
    public static final int MODIFIER_SKILL_COOKING = 7;
    public static final int MODIFIER_SKILL_GARDEN = 8;
    public static final int MODIFIER_SKILL_FRIENSHIP = 9;
    public static final int MODIFIER_SKILL_LANGUAGE = 10;
    public static final int MODIFIER_SKILL_PLAY = 11;
    public static final int MODIFIER_SKILL_MUSIC = 12;
    public static final int MODIFIER_SKILL_TIMEOUT_SLEEP = 13;
    public static final int MODIFIER_SKILL_TIMEOUT_HUNGER = 14;
    public static final int MODIFIER_SKILL_TIMEOUT_FUN = 15;
    public static final int MODIFIER_EAT_MEAL_1 = 16;
    public static final int MODIFIER_EAT_MEAL_2 = 17;
    public static final int MODIFIER_EAT_MEAL_3 = 18;
    public static final int MODIFIER_EAT_MEAL_4 = 19;
    public static final int MODIFIER_EAT_MEAL_5 = 20;
    public static final int MODIFIER_SLEEP = 21;
    public final byte[][] modifierSkillBar = new byte[][]{{-2, -4, -2}, {-2, -2, -4}, {0, -4, -4}, {-2, -4, -2}, {-4, -2, -2}, {-2, -4, -2}, {-4, -4, 0}, {-2, -4, -2}, {-4, -2, -4}, {0, 0, 2}, {0, 0, 0}, {-2, -4, 20}, {0, 0, 4}, {-1, 0, 0}, {0, -1, 0}, {0, 0, -1}, {0, 10, 0}, {0, 20, 0}, {0, 30, 0}, {0, 40, 0}, {0, 50, 0}, {15, 0, 0}};
    private static final int[] limitSkillLevels = new int[]{0, 5, 10, 20, 30};
    public static final int BAR_DREAM = 0;
    public static final int BAR_HUNGRY = 1;
    public static final int BAR_HAPPY = 2;
    public static final int SKILL_SHELLS = 0;
    public static final int SKILL_GEOLOGY = 1;
    public static final int SKILL_FISHING = 2;
    public static final int SKILL_PLANT = 3;
    public static final int SKILL_CHOP = 4;
    public static final int SKILL_HANDCRAFT = 5;
    public static final int SKILL_COOKING = 6;
    public static final int SKILL_FRIENDSHIP = 7;
    public Actor playerActor;
    public int[] playerBars;
    public int[] playersSkillsTimes;
    public int playerMoney;
    public int playerMoneyOffset;
    public int[] playerSkills;
    public byte[] playerBarsFurby;
    public String textPlayerLife;
    private boolean playerAdult;
    public int choosingObject;
    public static final int CHOOSING_NONE = -1;
    public static final int CHOOSING_GIVE = 1;
    public static final int CHOOSING_EAT = 2;
    public static final int TIMEOUT_DECREASE_BAR_SLEEP = 30000;
    public static final int TIMEOUT_DECREASE_BAR_HUNGER = 30000;
    public static final int TIMEOUT_DECREASE_BAR_FUN = 30000;
    public static final int LIFE_MODIFIER_TOTAL = 40;
    public static final int LIFE_MODIFIER_STOP = 20;
    private long[] timeBars;
    public static final int TIME_BAR_HANDCRAFTING = 10000;
    public static final int TIME_BAR_WHISTLING = 5000;
    public int fade;
    public int typeFading;
    public static final int FADING_NORMAL = 0;
    public static final int FADING_SLEEP = 1;
    private boolean[] lockLevels;
    private boolean textMinigameVisible;
    private boolean textBarDream;
    private boolean textBarHappy;
    private boolean textBarHungry;
    private int idObjectRecolect;
    int loadIndex;
    String lastMidName;
    private long timeSick = 0L;
    public boolean isSick = false;
    public static final int TIME_BETWEEN_SICK = 28800000;

    public GameEngine(GameMIDlet gm) {
        this.CHEAT_SHOP = 0;
        this.CHEAT_SKILL_1 = 1;
        this.CHEAT_SKILL_2 = 2;
        this.CHEAT_SKILL_3 = 3;
        this.CHEAT_SKILL_4 = 4;
        this.CHEAT_SKILL_5 = 5;
        this.CHEAT_SKILL_6 = 6;
        this.CHEAT_SKILL_7 = 7;
        this.CHEAT_SKILL_8 = 8;
        this.CHEAT_MONEY = 9;
        this.CHEAT_QUEST = 10;
        this.setFullScreenMode(true);
        this.gm = gm;
        this.gc = new GameCanvas(this);
        this.keyboard = new SSKeyboard();
        this.random = new Random(System.currentTimeMillis());
        this.music = new SSMusic();
        this.gc.loadResource(0);
        this.loadLanguage();
        this.timeFinish = System.currentTimeMillis() + 3000L;
        this.state = 0;
    }

    public void loadLanguage() {
        this.lang = null;
        System.gc();
        this.lang = SSFunctions.loadLangUnicode(this.gc.resManager.getResourceAsStream("t.dat"), 403);
        this.lang[10] = SSFunctions.replace(this.lang[10], "$SRL$", "LQNS43001");
        this.lang[10] = SSFunctions.replace(this.lang[10], "$VERSION$", this.gm.getAppProperty("MIDlet-Version"));
        this.urlGetMoreGames = this.gm.getAppProperty("URL_ECAP_GMG");
        if (this.urlGetMoreGames != null && (this.urlGetMoreGames.equals("") || this.urlGetMoreGames.length() <= 1)) {
            this.urlGetMoreGames = null;
        }
    }

    public static void store(String recordStoreName, String content) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                db.deleteRecord(re.nextRecordId());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(content);
            byte[] b = baos.toByteArray();
            db.addRecord(b, 0, b.length);
            dos.close();
            db.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DataInputStream load(String recordStoreName) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            ByteArrayInputStream bais = new ByteArrayInputStream(re.nextRecord());
            DataInputStream dis = new DataInputStream(bais);
            db.closeRecordStore();
            return dis;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void saveGame() {
        try {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            StringBuffer sb = new StringBuffer();
            sb.append(this.playerActor.name);
            sb.append("#");
            sb.append(this.playerMoney);
            sb.append("#");
            sb.append(this.qm.getActualQuest());
            sb.append("#");
            sb.append(this.playerAdult ? 1 : 0);
            sb.append("#");
            sb.append(this.textMinigameVisible ? 1 : 0);
            sb.append("#");
            for (i = 0; i < this.lockLevels.length; ++i) {
                sb.append(this.lockLevels[i] ? 1 : 0);
                sb.append("#");
            }
            for (i = 0; i < this.playerBars.length; ++i) {
                sb.append(this.playerBars[i]);
                sb.append("#");
            }
            for (i = 0; i < this.playerBarsFurby.length; ++i) {
                sb.append(this.playerBarsFurby[i]);
                sb.append("#");
            }
            for (i = 0; i < this.playerSkills.length; ++i) {
                sb.append(this.playerSkills[i]);
                sb.append("#");
                sb.append(this.playersSkillsTimes[i]);
                sb.append("#");
            }
            for (i = 0; i < 21; ++i) {
                sb.append(this.inventory.getShortSlot(i));
                sb.append("#");
            }
            for (i = 0; i < this.houseObjects.length; ++i) {
                sb.append(this.houseObjects[i] ? 1 : 0);
                sb.append("#");
            }
            sb.append(this.timeBornFurby);
            sb.append("#");
            dos.writeUTF(sb.toString());
            SSFunctions.store("furbygame", baos);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String parseRecord(String s) {
        if (s == null) {
            return "0";
        }
        String sParser = "";
        while (s.charAt(this.loadIndex) != '#') {
            sParser = sParser + s.charAt(this.loadIndex);
            ++this.loadIndex;
        }
        ++this.loadIndex;
        return sParser;
    }

    private void checkLoadGame() {
        DataInputStream dis = SSFunctions.load("furbygame");
        if (dis != null) {
            try {
                this.hasLoadGame = true;
                dis.close();
            }
            catch (IOException ex) {
                this.hasLoadGame = false;
            }
        } else {
            this.hasLoadGame = false;
        }
    }

    private void loadGame() {
        try {
            int i;
            DataInputStream dis = SSFunctions.load("furbygame");
            String s = dis.readUTF();
            dis.close();
            this.loadIndex = 0;
            this.playerActor.name = this.parseRecord(s);
            this.playerMoney = Integer.parseInt(this.parseRecord(s));
            this.qm.setActualQuest(Integer.parseInt(this.parseRecord(s)));
            this.playerAdult = Integer.parseInt(this.parseRecord(s)) == 1;
            this.textMinigameVisible = Integer.parseInt(this.parseRecord(s)) == 1;
            for (i = 0; i < this.lockLevels.length; ++i) {
                this.lockLevels[i] = Integer.parseInt(this.parseRecord(s)) == 1;
            }
            for (i = 0; i < this.playerBars.length; ++i) {
                this.playerBars[i] = Integer.parseInt(this.parseRecord(s));
            }
            for (i = 0; i < this.playerBarsFurby.length; ++i) {
                this.playerBarsFurby[i] = (byte)Integer.parseInt(this.parseRecord(s));
            }
            for (i = 0; i < this.playerSkills.length; ++i) {
                this.playerSkills[i] = Integer.parseInt(this.parseRecord(s));
                this.playersSkillsTimes[i] = Integer.parseInt(this.parseRecord(s));
            }
            for (i = 0; i < 21; ++i) {
                this.inventory.setShortSlot((short)Integer.parseInt(this.parseRecord(s)), i);
            }
            for (i = 0; i < this.houseObjects.length; ++i) {
                this.houseObjects[i] = Integer.parseInt(this.parseRecord(s)) == 1;
            }
            this.timeBornFurby = Long.parseLong(this.parseRecord(s));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int nextInt(int max) {
        return Math.abs(this.random.nextInt()) % max;
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void loadTextsMenu(int menu) {
        switch (menu) {
            case 4: {
                this.optionsMenu = new String[]{this.lang[12], this.lang[11]};
                break;
            }
            case 0: {
                this.optionsMenu = this.urlGetMoreGames != null ? new String[]{this.lang[1], this.lang[5] + " " + (this.bSound ? this.lang[6] : this.lang[7]), this.lang[401], this.lang[141], this.lang[2], this.lang[3], this.lang[4]} : new String[]{this.lang[1], this.lang[5] + " " + (this.bSound ? this.lang[6] : this.lang[7]), this.lang[141], this.lang[2], this.lang[3], this.lang[4]};
                this.iconLeft = 0;
                this.iconRight = -1;
                break;
            }
            case 3: {
                this.optionsMenu = new String[]{this.lang[12], this.lang[5] + " " + (this.bSound ? this.lang[6] : this.lang[7]), this.lang[142]};
                this.iconLeft = 0;
                this.iconRight = 2;
                break;
            }
            case 1: {
                this.lineData = this.gc.fntGame.getLineData(this.lang[9].toCharArray(), 192);
                this.optionsMenu = new String[]{this.lang[2]};
                this.lineActual = 0;
                break;
            }
            case 2: {
                this.lineData = this.gc.fntGame.getLineData(this.lang[10].toCharArray(), 192);
                this.optionsMenu = new String[]{this.lang[3]};
                this.lineActual = 0;
                break;
            }
            case 5: {
                this.lineData = this.gc.fntGame.getLineData(this.lang[381 + this.tutorialActual].toCharArray(), 192);
                this.optionsMenu = new String[]{this.lang[141]};
                this.lineActual = 0;
            }
        }
        if (menu != 3) {
            this.optionActual = 0;
            this.maxOptions = this.optionsMenu.length;
        } else {
            this.posStore = 0;
        }
    }

    public int searchOption(String option) {
        for (int i = 0; i < this.maxOptions; ++i) {
            if (this.optionsMenu[i].indexOf(option) == -1) continue;
            return i;
        }
        return 0;
    }

    private void toMainMenu() {
        this.setLoading(true);
        this.gc.setMaxLoadResources(10);
        this.gc.loadPanoramic(-1);
        this.gc.unloadResource(4);
        this.gc.unloadResource(8);
        this.gc.unloadResource(15);
        this.gc.unloadResource(16);
        this.gc.unloadResource(7);
        this.gc.unloadResource(9);
        this.gc.unloadResource(10);
        this.gc.unloadResource(11);
        this.gc.unloadResource(12);
        this.gc.unloadResource(13);
        this.gc.unloadResource(14);
        this.gc.unloadResource(17);
        this.gc.unloadResource(18);
        this.gc.unloadResource(19);
        if (this.gc.map != null) {
            this.gc.map.unloadAll();
        }
        this.gc.loadResource(5);
        this.gc.loadResource(1);
        this.gc.loadResource(2);
        this.gc.loadResource(3);
        this.gc.loadResource(20);
        this.gc.loadResource(22);
        this.gc.loadResource(23);
        this.gc.loadResource(21);
        this.gc.loadResource(25);
        this.gc.loadResource(14);
        this.loadTextsMenu(0);
        this.textBox = new SSTextBox(this.gc.fntMenu, 13);
        this.textBox.setColor(0, 2588703);
        this.textBox.setAlphabet(" 0+()[]", "1.,@!?", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9");
        if (this.bSound) {
            this.music.playSound(this.sMusic);
        } else if (this.music.isSound(this.sMusic)) {
            this.music.stopSound(this.sMusic);
        }
        this.keyboard.removeAllEvents();
        this.iconLeft = 0;
        this.iconRight = -1;
        this.optionActual = 0;
        this.state = 4;
    }

    private void processKeyMiniGameGow(char key) {
        switch (key) {
            case '\u0000': 
            case '\u0002': 
            case '5': {
                this.percentPiece = (int)((System.currentTimeMillis() - this.timeStartMiniGameGow) * 100L / 750L) % 100;
                this.scoreMiniGame = this.percentPiece >= this.percentZoneHigh && this.percentPiece <= this.percentZoneHigh + this.percentZoneHighSize ? (this.scoreMiniGame += 200) : (this.percentPiece >= this.percentZoneMedium && this.percentPiece <= this.percentZoneMedium + this.percentZoneMediumSize ? (this.scoreMiniGame += 100) : (this.scoreMiniGame += 0));
                --this.numRounds;
                this.timeStartMiniGameGow = System.currentTimeMillis() + 3000L;
                this.stateGame = 7;
            }
        }
    }

    private void processKeyPlayerWorld(char key, int event) {
        switch (key) {
            case '0': {
                break;
            }
            case '\u0005': 
            case '2': 
            case '3': {
                this.isoEngine.setOffsetX(-4);
                this.isoEngine.setOffsetY(2);
                this.playerActor.direction = 0;
                this.playerActor.stopped = false;
                break;
            }
            case '\u0006': 
            case '7': 
            case '8': {
                this.isoEngine.setOffsetX(4);
                this.isoEngine.setOffsetY(-2);
                this.playerActor.direction = 2;
                this.playerActor.stopped = false;
                break;
            }
            case '\u0003': 
            case '1': 
            case '4': {
                this.isoEngine.setOffsetX(4);
                this.isoEngine.setOffsetY(2);
                this.playerActor.direction = 1;
                this.playerActor.stopped = false;
                break;
            }
            case '\u0004': 
            case '6': 
            case '9': {
                this.isoEngine.setOffsetX(-4);
                this.isoEngine.setOffsetY(-2);
                this.playerActor.direction = 3;
                this.playerActor.stopped = false;
                break;
            }
            case '\u0000': 
            case '\u0002': 
            case '5': {
                if (this.isoEngine.getPlayerGate() != -1) {
                    if (!this.canTravel(this.isoEngine.getGateMap())) break;
                    this.setLoading(true);
                    this.gc.setMaxLoadResources(2);
                    this.travelToMap(this.isoEngine.getGateMap(), this.isoEngine.getGateMapTargetTileX(), this.isoEngine.getGateMapTargetTileY());
                    this.playerActor.stopped = true;
                    this.isoEngine.setOffsetX(0);
                    this.isoEngine.setOffsetY(0);
                    this.state = 5;
                    break;
                }
                this.componeButtonsInterface();
                break;
            }
            case '\u0001': {
                this.toInterface();
            }
        }
    }

    private boolean canTravel(int numMap) {
        if (!this.lockLevels[numMap]) {
            return true;
        }
        this.idFurbyTalk = -1;
        switch (numMap) {
            case 1: {
                this.newTalkMessage(this.lang[138]);
                break;
            }
            case 4: 
            case 6: {
                this.newTalkMessage(this.lang[139]);
                break;
            }
            case 2: {
                this.newTalkMessage(this.lang[140]);
            }
        }
        return false;
    }

    private void processKeyButtonsInterface(char key) {
        int maxButtons = this.getMaxButtons();
        int angleStep = 360 / maxButtons;
        switch (key) {
            case '\u0003': 
            case '4': {
                --this.optionActual;
                if (this.optionActual < 0) {
                    this.optionActual = maxButtons - 1;
                }
                for (int i = 0; i < maxButtons; ++i) {
                    int n = i;
                    this.buttonsAngle[n] = (short)(this.buttonsAngle[n] - angleStep);
                    int n2 = i;
                    this.buttonsAngleOffset[n2] = (short)(this.buttonsAngleOffset[n2] - angleStep);
                    if (this.buttonsAngle[i] >= 0) continue;
                    int n3 = i;
                    this.buttonsAngle[n3] = (short)(this.buttonsAngle[n3] + 360);
                }
                this.messageTextDown = this.lang[45 + this.buttons[this.optionActual]];
                break;
            }
            case '\u0004': 
            case '6': {
                ++this.optionActual;
                if (this.optionActual >= maxButtons) {
                    this.optionActual = 0;
                }
                int i = 0;
                while (i < maxButtons) {
                    int n = i;
                    this.buttonsAngle[n] = (short)(this.buttonsAngle[n] + angleStep);
                    int n4 = i++;
                    this.buttonsAngleOffset[n4] = (short)(this.buttonsAngleOffset[n4] + angleStep);
                }
                this.messageTextDown = this.lang[45 + this.buttons[this.optionActual]];
                break;
            }
            case '\u0000': 
            case '\u0002': 
            case '5': {
                int toolLevel = 1;
                if (this.buttons[this.optionActual] == 4) {
                    this.idObjectList = this.idObjectRecolect;
                    if (this.items.isItemRecolected(this.isoEngine.getNumActualMap(), this.idObjectList, System.currentTimeMillis())) {
                        this.messagePopup = this.lang[392];
                        this.stateGame = 8;
                    } else if (this.gc.map.isItemToFish(this.idObjectList)) {
                        if (this.inventory.isItemInInventory(1, 1, 1) || this.inventory.isItemInInventory(1, 0, 1) || this.inventory.isItemInInventory(1, 2, 1)) {
                            if (this.inventory.isItemInInventory(1, 0, 1)) {
                                toolLevel = 1;
                            }
                            if (this.inventory.isItemInInventory(1, 1, 1)) {
                                toolLevel = 3;
                            }
                            if (this.inventory.isItemInInventory(1, 2, 1)) {
                                toolLevel = 5;
                            }
                            int minLevel = this.items.getFishLevel(this.isoEngine.getNumActualMap(), 0);
                            int maxLevel = this.items.getFishLevel(this.isoEngine.getNumActualMap(), 1);
                            if (toolLevel < minLevel) {
                                this.messagePopup = this.lang[137];
                                this.stateGame = 8;
                            } else if (this.playerSkills[2] < minLevel) {
                                this.messagePopup = this.lang[395];
                                this.stateGame = 8;
                            } else {
                                this.playerActor.stopped = false;
                                this.playerActor.numAnimationForced = this.isoEngine.getNumActualMap() == 1 ? 12 : 11;
                                this.initMiniGameGow(0, 0, 2);
                                this.stateFurby = 1;
                            }
                        } else {
                            this.messagePopup = this.lang[131];
                            this.stateGame = 8;
                        }
                    } else if (this.gc.map.isItemRock(this.idObjectList) || this.gc.map.isItemShell(this.idObjectList) || this.gc.map.isItemPlant(this.idObjectList) || this.gc.map.isItemWood(this.idObjectList)) {
                        if (this.gc.map.isItemWood(this.idObjectList) && !this.inventory.isItemInInventory(1, 5, 1) && !this.inventory.isItemInInventory(1, 4, 1) && !this.inventory.isItemInInventory(1, 3, 1)) {
                            this.messagePopup = this.lang[134];
                            this.stateGame = 8;
                        } else {
                            this.initMiniGameGow(0, 0, 2);
                            if (this.inventory.isItemInInventory(1, 3, 1)) {
                                toolLevel = 1;
                            }
                            if (this.inventory.isItemInInventory(1, 4, 1)) {
                                toolLevel = 3;
                            }
                            if (this.inventory.isItemInInventory(1, 5, 1)) {
                                toolLevel = 5;
                            }
                            if (this.gc.map.isItemRock(this.idObjectList)) {
                                int minLevel = this.items.getRockLevel(this.isoEngine.getNumActualMap(), 0);
                                int maxLevel = this.items.getRockLevel(this.isoEngine.getNumActualMap(), 1);
                                if (this.playerSkills[1] < minLevel) {
                                    this.messagePopup = this.lang[396];
                                    this.stateGame = 8;
                                    this.resetStateGame();
                                } else {
                                    this.stateFurby = 2;
                                }
                            } else if (this.gc.map.isItemPlant(this.idObjectList)) {
                                int minLevel = this.items.getPlantLevel(this.isoEngine.getNumActualMap(), 0);
                                int maxLevel = this.items.getPlantLevel(this.isoEngine.getNumActualMap(), 1);
                                if (this.playerSkills[3] < minLevel) {
                                    this.messagePopup = this.lang[396];
                                    this.stateGame = 8;
                                    this.resetStateGame();
                                } else {
                                    this.stateFurby = 5;
                                }
                            } else if (this.gc.map.isItemWood(this.idObjectList)) {
                                int minLevel = this.items.getWoodLevel(this.isoEngine.getNumActualMap(), 0);
                                int maxLevel = this.items.getWoodLevel(this.isoEngine.getNumActualMap(), 1);
                                if (toolLevel + 1 < minLevel) {
                                    this.messagePopup = this.lang[137];
                                    this.stateGame = 8;
                                    this.resetStateGame();
                                } else if (this.playerSkills[4] < minLevel) {
                                    this.messagePopup = this.lang[394];
                                    this.stateGame = 8;
                                    this.resetStateGame();
                                } else {
                                    this.playerActor.stopped = false;
                                    this.playerActor.direction = 0;
                                    this.playerActor.numAnimationForced = 15;
                                    this.stateFurby = 4;
                                }
                            } else {
                                int minLevel = this.items.getShellLevel(this.isoEngine.getNumActualMap(), 0);
                                int maxLevel = this.items.getShellLevel(this.isoEngine.getNumActualMap(), 1);
                                if (this.playerSkills[0] < minLevel) {
                                    this.messagePopup = this.lang[396];
                                    this.stateGame = 8;
                                    this.resetStateGame();
                                } else {
                                    this.stateFurby = 3;
                                }
                            }
                            if (this.stateGame != 8 && this.playerActor.numAnimationForced == -1) {
                                this.playerActor.stopped = false;
                                if (this.playerActor.direction == 1 || this.playerActor.direction == 3) {
                                    this.playerActor.direction = 3;
                                    this.playerActor.numAnimationForced = 14;
                                } else {
                                    this.playerActor.direction = 2;
                                    this.playerActor.numAnimationForced = 13;
                                }
                            }
                        }
                    }
                } else if (this.buttons[this.optionActual] == 0) {
                    this.idFurbyTalk = this.gc.map.getNumFurbyFromObject(this.getIdListFromObjectInFrontFurby());
                    this.newTalkMessage(this.lang[69 + this.idFurbyTalk]);
                    this.idFurbyTalk = -1;
                } else if (this.buttons[this.optionActual] == 1) {
                    this.idFurbyTalk = this.gc.map.getNumFurbyFromObject(this.getIdListFromObjectInFrontFurby());
                    if (this.qm.getActualQuest() < 49 && this.qm.getTypeRequirement(this.qm.getActualQuest(), 0) == 1 && this.qm.getNumItemRequirement(this.qm.getActualQuest(), 0) == this.idFurbyTalk) {
                        if (this.isQuestCompleted(this.qm.getActualQuest(), this.idFurbyTalk)) {
                            if (this.qm.getNumRequirements(this.qm.getActualQuest()) > 1) {
                                this.removeQuestItems(this.qm.getActualQuest());
                            }
                            if (!this.qm.getQuestRewardText(this.qm.getActualQuest()).equals("-")) {
                                this.newTalkMessage(this.qm.getQuestRewardText(this.qm.getActualQuest()));
                                this.addStateGame(8, this.lang[43]);
                            } else {
                                this.messagePopup = this.lang[43];
                                this.stateGame = 8;
                            }
                            int typeReward = this.qm.getRewardType(this.qm.getActualQuest());
                            switch (typeReward) {
                                case 0: 
                                case 1: {
                                    if (this.inventory.getEmptySlot() == -1) {
                                        this.inventory.removeItem(20);
                                    }
                                    int typeItem = typeReward;
                                    int numItem = this.qm.getRewardItem(this.qm.getActualQuest());
                                    int stack = this.qm.getRewardStack(this.qm.getActualQuest());
                                    this.inventory.addItem(typeItem, numItem, stack);
                                    this.addModifierPlayer(typeItem, numItem, stack);
                                    break;
                                }
                                case 3: {
                                    this.playerMoney += this.qm.getRewardItem(this.qm.getActualQuest());
                                    break;
                                }
                                case 2: {
                                    int n = this.qm.getRewardItem(this.qm.getActualQuest());
                                    this.playersSkillsTimes[n] = this.playersSkillsTimes[n] + this.qm.getRewardStack(this.qm.getActualQuest());
                                }
                            }
                            if (this.qm.getActualQuest() == 36) {
                                this.playerMoney += 100;
                            }
                            this.qm.setActualQuest(this.qm.getActualQuest() + 1);
                            if (this.qm.getActualQuest() < 49) {
                                this.checkLockLevels();
                                this.addStateGame(8, this.lang[44] + "\n" + this.qm.getQuestName(this.qm.getActualQuest()));
                                if (!this.qm.getQuestLongText(this.qm.getActualQuest()).equals("-")) {
                                    this.addStateGame(9, this.qm.getQuestLongText(this.qm.getActualQuest()));
                                }
                                this.addStateGame(2, String.valueOf(3));
                            } else {
                                this.setLoading(true);
                                this.gc.setMaxLoadResources(2);
                                this.gc.unloadResource(8);
                                this.gc.loadPanoramic(-1);
                                this.gc.loadResource(26);
                                this.sleep(1000);
                                this.stateGame = 14;
                                this.state = 5;
                            }
                        } else if (this.qm.getNumRequirements(this.qm.getActualQuest()) > 1) {
                            this.newTalkMessage(this.lang[81]);
                        }
                    } else if (this.idFurbyTalk == 6) {
                        this.toInterface();
                        this.maxOptions = 8;
                        this.optionActual = 8;
                        this.optionInterface = 1;
                    } else if (this.idFurbyTalk == 0) {
                        this.newTalkMessage(this.lang[150]);
                        this.addStateGame(9, this.lang[151]);
                        this.addStateGame(9, this.lang[152]);
                        this.addStateGame(9, this.lang[153 + this.nextInt(3)]);
                        this.addStateGame(9, this.lang[156]);
                    } else {
                        int rnd = this.nextInt(22);
                        if (rnd < 2) {
                            this.newTalkMessage(this.lang[84 + this.idFurbyTalk * 2 + rnd]);
                        } else {
                            this.newTalkMessage(this.lang[108 + rnd - 2]);
                        }
                    }
                } else if (this.buttons[this.optionActual] == 6) {
                    this.toInterface();
                    this.optionActual = 1;
                    this.optionInterface = 1;
                    this.choosingObject = 1;
                } else if (this.buttons[this.optionActual] == 7) {
                    this.toInterface();
                    this.optionActual = 1;
                } else if (this.buttons[this.optionActual] == 2) {
                    this.idFurbyTalk = this.gc.map.getNumFurbyFromObject(this.getIdListFromObjectInFrontFurby());
                    this.toInterface();
                    this.maxOptions = 8;
                    this.optionActual = 6;
                    this.optionInterface = 0;
                } else if (this.buttons[this.optionActual] == 3) {
                    this.playerActor.stopped = false;
                    this.playerActor.numAnimationForced = this.playerActor.direction == 2 || this.playerActor.direction == 1 ? 6 : 7;
                    this.gc.heightActor = this.playerActor.getHeight() >> 2;
                    this.timeFinish = this.lastProcessTime + 5000L;
                    this.stateFurby = 6;
                    this.stateGame = 12;
                } else if (this.buttons[this.optionActual] == 9) {
                    this.toInterface();
                    this.optionActual = 1;
                    this.optionInterface = 1;
                    this.choosingObject = 2;
                } else if (this.buttons[this.optionActual] == 5) {
                    this.toFade(1);
                } else if (this.buttons[this.optionActual] == 8) {
                    this.stateGame = 0;
                }
                this.messageTextDown = null;
                break;
            }
            case '\u0001': {
                this.stateGame = 0;
            }
        }
    }

    private void cheatMoney() {
        this.playerMoney += 250;
    }

    private void cheatQuestCompleted() {
        if (this.qm.getActualQuest() < 49) {
            this.idFurbyTalk = this.qm.getNumItemRequirement(this.qm.getActualQuest(), 0);
            if (this.qm.getNumRequirements(this.qm.getActualQuest()) > 1) {
                this.removeQuestItems(this.qm.getActualQuest());
            }
            if (!this.qm.getQuestRewardText(this.qm.getActualQuest()).equals("-")) {
                this.newTalkMessage(this.qm.getQuestRewardText(this.qm.getActualQuest()));
                this.addStateGame(8, this.lang[43]);
            } else {
                this.messagePopup = this.lang[43];
                this.stateGame = 8;
            }
            int typeReward = this.qm.getRewardType(this.qm.getActualQuest());
            switch (typeReward) {
                case 0: 
                case 1: {
                    if (this.inventory.getEmptySlot() == -1) {
                        this.inventory.removeItem(20);
                    }
                    int typeItem = typeReward;
                    int numItem = this.qm.getRewardItem(this.qm.getActualQuest());
                    int stack = this.qm.getRewardStack(this.qm.getActualQuest());
                    this.inventory.addItem(typeItem, numItem, stack);
                    this.addModifierPlayer(typeItem, numItem, stack);
                    break;
                }
                case 3: {
                    this.playerMoney += this.qm.getRewardItem(this.qm.getActualQuest());
                    break;
                }
                case 2: {
                    int n = this.qm.getRewardItem(this.qm.getActualQuest());
                    this.playersSkillsTimes[n] = this.playersSkillsTimes[n] + this.qm.getRewardStack(this.qm.getActualQuest());
                }
            }
            if (this.qm.getActualQuest() == 36) {
                this.playerMoney += 100;
            }
            this.qm.setActualQuest(this.qm.getActualQuest() + 1);
            if (this.qm.getActualQuest() < 49) {
                this.checkLockLevels();
                this.addStateGame(8, this.lang[44] + "\n" + this.qm.getQuestName(this.qm.getActualQuest()));
                if (!this.qm.getQuestLongText(this.qm.getActualQuest()).equals("-")) {
                    this.addStateGame(9, this.qm.getQuestLongText(this.qm.getActualQuest()));
                }
                this.addStateGame(2, String.valueOf(3));
            } else {
                this.setLoading(true);
                this.gc.setMaxLoadResources(2);
                this.gc.unloadResource(8);
                this.gc.loadPanoramic(-1);
                this.gc.loadResource(26);
                this.sleep(1000);
                this.stateGame = 14;
                this.state = 5;
                this.idFurbyTalk = -1;
                this.addStateGame(9, this.lang[393]);
            }
        }
    }

    private void checkLockLevels() {
        if (this.qm.getActualQuest() >= 24) {
            this.lockLevels[1] = false;
        }
        if (this.qm.getActualQuest() >= 33) {
            this.lockLevels[4] = false;
        }
        if (this.qm.getActualQuest() >= 40) {
            this.lockLevels[6] = false;
        }
        if (this.qm.getActualQuest() >= 44) {
            this.lockLevels[2] = false;
        }
    }

    private void removeQuestItems(int numQuest) {
        for (int i = 1; i < this.qm.getNumRequirements(numQuest); ++i) {
            int typeItem = this.qm.getTypeRequirement(numQuest, i) - 2;
            int numItem = this.qm.getNumItemRequirement(numQuest, i);
            int stack = this.qm.getSizeRequirement(numQuest, i);
            this.inventory.removeItem(typeItem, numItem, stack);
            this.addModifierPlayer(typeItem, numItem, -stack);
        }
    }

    private boolean isQuestCompleted(int numQuest, int idFurby) {
        for (int i = 0; i < this.qm.getNumRequirements(numQuest); ++i) {
            if (!(this.qm.getTypeRequirement(numQuest, i) == 1 ? this.qm.getNumItemRequirement(numQuest, i) != idFurby : !this.inventory.isItemInInventory(this.qm.getTypeRequirement(numQuest, i) - 2, this.qm.getNumItemRequirement(numQuest, i), this.qm.getSizeRequirement(numQuest, i)))) continue;
            return false;
        }
        return true;
    }

    private void initMiniGameGow(int level, int scoreInitial, int rounds) {
        this.scoreMiniGame = scoreInitial;
        this.numRounds = rounds;
        this.percentZoneMediumSize = 25 - this.nextInt(5);
        this.percentZoneMedium = 5 + this.nextInt(70);
        this.percentZoneHighSize = 5;
        this.percentZoneHigh = this.percentZoneMedium + this.nextInt(this.percentZoneMediumSize - 5);
        this.timeStartMiniGameGow = System.currentTimeMillis();
        if (this.textMinigameVisible) {
            this.textMinigameVisible = false;
            this.idFurbyTalk = -2;
            this.newTalkMessage(this.lang[389]);
            this.addStateGame(6, null);
        } else {
            this.stateGame = 6;
        }
    }

    private void processKeyStorePopup(char key) {
        switch (key) {
            case '\u0003': 
            case '\u0004': 
            case '4': 
            case '6': {
                this.optionPopup = (this.optionPopup + 1) % 2;
                if (this.stateGame == 5) {
                    if (!this.items.isCraftable(this.posStore, this.inventory)) {
                        this.optionPopup = 1;
                    }
                } else if (this.stateGame == 3) {
                    if (this.optionActual == 8) {
                        if (this.playerMoney < this.dictionaryWordsPrices[this.posStore] || this.dictionaryWordsPrices[this.posStore] == 0) {
                            this.optionPopup = 1;
                        }
                    } else if (this.playerMoney < this.items.getItemStorePrice(this.posStore)) {
                        this.optionPopup = 1;
                    }
                }
                if (this.activeButton) break;
                this.optionPopup = 1;
                break;
            }
            case '\u0000': 
            case '\u0002': 
            case '5': {
                if (this.optionPopup == 0) {
                    int i;
                    if (this.optionActual == 6) {
                        int numItem;
                        if (this.playerMoney < this.items.getItemStorePrice(this.posStore)) break;
                        int typeItem = this.items.getItemStoreType(this.posStore);
                        if (this.items.getCategory(typeItem, numItem = this.items.getItemStoreNumItem(this.posStore)) == 5 && this.items.getLevelItem(typeItem, numItem) > this.playerSkills[6]) {
                            this.messagePopup = this.lang[397];
                            this.stateGame = 8;
                            break;
                        }
                        if (this.inventory.canAddItem(typeItem, numItem, 1)) {
                            this.playerMoney -= this.items.getItemStorePrice(this.posStore);
                            this.playerMoneyOffset = this.items.getItemStorePrice(this.posStore);
                            this.gc.addModifier(200, 45, typeItem, numItem, 1, 40);
                            this.inventory.addItem(typeItem, numItem, 1);
                            this.stateGame = 2;
                            break;
                        }
                        this.messagePopup = this.lang[390];
                        this.stateGame = 8;
                        break;
                    }
                    if (this.optionActual == 8) {
                        if (this.playerMoney >= this.dictionaryWordsPrices[this.posStore]) {
                            this.playerMoney -= this.dictionaryWordsPrices[this.posStore];
                            this.playerMoneyOffset = this.dictionaryWordsPrices[this.posStore];
                            this.dictionaryWordsPrices[this.posStore] = 0;
                        }
                        this.stateGame = 2;
                        break;
                    }
                    if (this.optionActual == 7) {
                        int typeItem = this.inventory.getTypeItem(this.posInventory);
                        int numItem = this.inventory.getNumItem(this.posInventory);
                        if (typeItem == 0 && numItem == 45 && typeItem == 1 && numItem == 90) break;
                        this.playerMoney += this.items.getSellPrice(typeItem, numItem);
                        this.playerMoneyOffset = -this.items.getSellPrice(typeItem, numItem);
                        this.gc.addModifier(200, 45, typeItem, numItem, -1, 40);
                        this.inventory.removeItem(typeItem, numItem, 1);
                        this.stateGame = 2;
                        break;
                    }
                    if (!(this.items.getCategory(1, this.posStore) != 7 || this.inventory.isItemInInventory(1, 8, 1) || this.inventory.isItemInInventory(1, 7, 1) || this.inventory.isItemInInventory(1, 6, 1))) {
                        this.messagePopup = this.lang[132];
                        this.stateGame = 8;
                        break;
                    }
                    if (this.items.getCategory(1, this.posStore) == 9 && this.isoEngine.getNumActualMap() != 8) {
                        this.messagePopup = this.lang[133];
                        this.stateGame = 8;
                        break;
                    }
                    for (i = 0; i < this.items.getNumItemsCostManufactureItem(this.posStore); ++i) {
                        this.inventory.removeItem(0, this.items.getNumItemCost(this.posStore, i), this.items.getStackItemCost(this.posStore, i));
                    }
                    if (this.inventory.canAddItem(1, this.posStore, 1)) {
                        for (i = 0; i < this.items.getNumItemsCostManufactureItem(this.posStore); ++i) {
                            this.addModifierPlayer(0, this.items.getNumItemCost(this.posStore, i), -this.items.getStackItemCost(this.posStore, i));
                        }
                        this.addModifiersBars(5);
                        this.gc.heightActor = this.playerActor.getHeight() >> 2;
                        this.timeFinish = this.lastProcessTime + 10000L;
                        this.stateGame = 11;
                        break;
                    }
                    for (i = 0; i < this.items.getNumItemsCostManufactureItem(this.posStore); ++i) {
                        this.inventory.addItem(0, this.items.getNumItemCost(this.posStore, i), this.items.getStackItemCost(this.posStore, i));
                    }
                    this.messagePopup = this.lang[390];
                    this.stateGame = 8;
                    break;
                }
                this.stateGame = 2;
            }
        }
    }

    private void addModifierPlayer(int typeItem, int numItem, int stack) {
        this.gc.addModifier(this.playerActor.x, this.playerActor.y - this.playerActor.getHeight(), typeItem, numItem, stack, 40);
    }

    private void processKeyInterface(char key) {
        switch (key) {
            case '\u0005': 
            case '2': {
                if (this.optionActual == 1 || this.optionActual == 7) {
                    if (this.optionInterface == 0) {
                        this.optionInterface = 1;
                        this.posInventory = 14;
                        break;
                    }
                    if (this.posInventory < 7) break;
                    this.posInventory -= 7;
                    break;
                }
                if (this.optionActual == 2) {
                    if (this.optionInterface != 0) break;
                    this.optionInterface = 1;
                    break;
                }
                if (this.optionActual != 8 && this.optionActual != 6 && this.optionActual != 4 && this.optionActual != 5) break;
                if (this.posStore == this.posMinList) {
                    if (this.posMinList <= 0) break;
                    --this.posMinList;
                    --this.posStore;
                    break;
                }
                --this.posStore;
                break;
            }
            case '\u0006': 
            case '8': {
                if ((this.optionActual == 1 || this.optionActual == 7) && this.optionInterface == 1) {
                    this.posInventory += 7;
                    if (this.posInventory < 21) break;
                    if (this.choosingObject != -1) {
                        this.posInventory -= 7;
                        break;
                    }
                    this.optionInterface = 0;
                    break;
                }
                if (this.optionActual == 2) {
                    if (this.optionInterface != 1) break;
                    this.optionInterface = 0;
                    break;
                }
                if (this.optionActual != 8 && this.optionActual != 6 && this.optionActual != 4 && this.optionActual != 5) break;
                if (this.posStore < this.posMinList + this.numItems - 1) {
                    ++this.posStore;
                    if (this.optionActual != 5 || this.posStore != this.optionsMenu.length) break;
                    --this.posStore;
                    break;
                }
                int maxItems = this.optionActual == 4 ? this.items.getNumItemsManufacture() : (this.optionActual == 5 ? this.optionsMenu.length : (this.optionActual == 8 ? 108 : this.items.getItemStoreNumItems()));
                if (this.posStore >= maxItems - 1) break;
                ++this.posStore;
                ++this.posMinList;
                break;
            }
            case '\u0004': 
            case '6': {
                if (this.optionInterface == 0) {
                    if (this.optionActual != 7) {
                        ++this.optionActual;
                    }
                    if (this.optionActual == this.maxOptions) {
                        this.optionActual = 0;
                    }
                    if (this.optionActual == 2) {
                        this.posInventory = 0;
                        for (int i = 0; i < 24; i += 3) {
                            if (this.gc.map.MAP_POINTS[i + 2] != this.isoEngine.getNumActualMap()) continue;
                            this.posInventory = i / 3;
                            break;
                        }
                        if (this.isoEngine.getNumActualMap() == 8) {
                            this.posInventory = 7;
                        }
                        this.posFurbyMap = this.posInventory * 3;
                    }
                    this.posMinList = 0;
                    this.posStore = 0;
                    if (this.optionActual != 5) break;
                    this.loadTextsMenu(3);
                    break;
                }
                if (this.optionActual == 1 || this.optionActual == 7) {
                    if (this.optionInterface != 1 || this.posInventory >= 20) break;
                    ++this.posInventory;
                    break;
                }
                if (this.optionActual != 2) break;
                this.posInventory = (this.posInventory + 1) % 8;
                break;
            }
            case '\u0003': 
            case '4': {
                if (this.optionInterface == 0) {
                    if (this.optionActual != 6) {
                        --this.optionActual;
                    }
                    if (this.optionActual < 0) {
                        this.optionActual = this.maxOptions - 1;
                    }
                    if (this.optionActual == 2) {
                        this.posInventory = 0;
                        for (int i = 0; i < 24; i += 3) {
                            if (this.gc.map.MAP_POINTS[i + 2] != this.isoEngine.getNumActualMap()) continue;
                            this.posInventory = i / 3;
                            break;
                        }
                        if (this.isoEngine.getNumActualMap() == 8) {
                            this.posInventory = 7;
                        }
                        this.posFurbyMap = this.posInventory * 3;
                    }
                    this.posMinList = 0;
                    this.posStore = 0;
                    if (this.optionActual != 5) break;
                    this.loadTextsMenu(3);
                    break;
                }
                if (this.optionActual == 1 || this.optionActual == 7) {
                    if (this.optionInterface != 1 || this.posInventory <= 0) break;
                    --this.posInventory;
                    break;
                }
                if (this.optionActual != 2) break;
                --this.posInventory;
                if (this.posInventory >= 0) break;
                this.posInventory = 7;
                break;
            }
            case '\u0001': {
                this.gc.resetModifiers();
                this.stateGame = 0;
                break;
            }
            case '\u0000': 
            case '\u0002': 
            case '5': {
                this.activeButton = false;
                if (this.optionActual == 1) {
                    boolean twice;
                    if (this.optionInterface != 1) break;
                    if (this.choosingObject == 1 && !this.inventory.isEmptySlot(this.posInventory)) {
                        int typeItem = this.inventory.getTypeItem(this.posInventory);
                        int numItem = this.inventory.getNumItem(this.posInventory);
                        if (typeItem == 0 && numItem == 45) break;
                        this.idFurbyTalk = this.getNumFurby();
                        int idList = this.getIdListFromObjectInFrontFurby();
                        int modifier = this.items.isGoodItemToFurby(this.idFurbyTalk, typeItem, numItem);
                        if (modifier > 0) {
                            this.newTalkMessage(this.lang[82]);
                        } else {
                            this.newTalkMessage(this.lang[83]);
                        }
                        this.addSkillPoint(7, 1);
                        this.addModifiersBars(9);
                        this.addModifierPlayer(2, 2, modifier);
                        this.addModifierPlayer(typeItem, numItem, -1);
                        this.inventory.removeItem(this.posInventory);
                        break;
                    }
                    if (this.choosingObject != 2) break;
                    int typeItem = this.inventory.getTypeItem(this.posInventory);
                    int numItem = this.inventory.getNumItem(this.posInventory);
                    boolean bl = twice = typeItem == 1 && this.items.getCategory(typeItem, numItem) == 9;
                    if (this.items.isEdibleItem(typeItem, numItem)) {
                        int level = this.items.getLevelItem(typeItem, numItem) - 1;
                        this.addModifiersBars(16 + level);
                        if (twice) {
                            this.addModifiersBars(16 + level);
                        }
                        this.addModifierPlayer(2, 1, this.modifierSkillBar[16 + level][1] * (twice ? 2 : 1));
                        this.inventory.removeItem(typeItem, numItem, 1);
                        this.stateGame = 0;
                        break;
                    }
                    this.messagePopup = this.lang[135];
                    this.stateGame = 8;
                    break;
                }
                if (this.optionActual == 2) {
                    if (this.optionInterface != 1 || !this.canTravel(this.gc.map.MAP_POINTS[this.posInventory * 3 + 2])) break;
                    this.setLoading(true);
                    this.gc.setMaxLoadResources(2);
                    this.travelToMap(this.gc.map.MAP_POINTS[this.posInventory * 3 + 2], this.gc.map.MAP_POINTS_TILE[this.posInventory * 3 + 0], this.gc.map.MAP_POINTS_TILE[this.posInventory * 3 + 1]);
                    this.playerActor.direction = this.gc.map.MAP_POINTS_TILE[this.posInventory * 3 + 2];
                    this.playerActor.stopped = true;
                    this.isoEngine.setOffsetX(0);
                    this.isoEngine.setOffsetY(0);
                    this.stateGame = 0;
                    this.state = 5;
                    break;
                }
                if (this.optionActual == 6) {
                    if (this.playerMoney >= this.items.getItemStorePrice(this.posStore)) {
                        this.activeButton = true;
                        this.optionPopup = 0;
                    } else {
                        this.optionPopup = 1;
                    }
                    this.stateGame = 3;
                    break;
                }
                if (this.optionActual == 8) {
                    if (this.playerMoney >= this.dictionaryWordsPrices[this.posStore] && this.dictionaryWordsPrices[this.posStore] != 0) {
                        this.activeButton = true;
                        this.optionPopup = 0;
                    } else {
                        this.activeButton = false;
                        this.optionPopup = 1;
                    }
                    this.stateGame = 3;
                    break;
                }
                if (this.optionActual == 7) {
                    if (this.optionInterface != 1 || this.inventory.isEmptySlot(this.posInventory)) break;
                    int typeItem = this.inventory.getTypeItem(this.posInventory);
                    int numItem = this.inventory.getNumItem(this.posInventory);
                    if (typeItem == 0 && numItem == 45 || typeItem == 1 && numItem == 90) {
                        this.activeButton = false;
                        this.optionPopup = 1;
                    } else {
                        this.activeButton = true;
                        this.optionPopup = 0;
                    }
                    this.stateGame = 4;
                    break;
                }
                if (this.optionActual == 4) {
                    if (this.items.isCraftable(this.posStore, this.inventory)) {
                        this.activeButton = true;
                        this.optionPopup = 0;
                    } else {
                        this.optionPopup = 1;
                    }
                    this.stateGame = 5;
                    break;
                }
                if (this.optionActual != 5) break;
                if (this.optionsMenu[this.posStore].equals(this.lang[12])) {
                    this.gc.resetModifiers();
                    this.stateGame = 0;
                    break;
                }
                if (this.optionsMenu[this.posStore].indexOf(this.lang[5]) != -1) {
                    this.bSound = !this.bSound;
                    this.loadTextsMenu(3);
                    this.posStore = this.searchOption(this.lang[5]);
                    break;
                }
                if (!this.optionsMenu[this.posStore].equals(this.lang[142])) break;
                this.saveGame();
                if (this.items != null) {
                    this.items.destroy();
                }
                this.toMainMenu();
                this.loadMusic(-1);
            }
        }
    }

    private void newTalkMessage(String message) {
        this.lineActual = 0;
        this.messagePopup = message;
        this.lineData = this.gc.fntGame.getLineData(this.messagePopup.toCharArray(), 240 - GameCanvas.GAP_FURBY_X - this.gc.fntGame.getFontHeight() * 3);
        this.maxLines = this.lineData.length;
        this.stateGame = 9;
    }

    private int getNumFurby() {
        return this.gc.map.getNumFurbyFromObject(this.getIdListFromObjectInFrontFurby());
    }

    private void processKeyPlayer(char key, int event) {
        if (event == 0) {
            switch (this.stateGame) {
                case 0: {
                    if (this.stateFurby != 0) break;
                    this.processKeyPlayerWorld(key, event);
                    break;
                }
                case 1: {
                    this.processKeyButtonsInterface(key);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.processKeyStorePopup(key);
                    break;
                }
                case 2: {
                    this.processKeyInterface(key);
                    break;
                }
                case 6: {
                    this.processKeyMiniGameGow(key);
                    break;
                }
                case 7: {
                    this.timeStartMiniGameGow = 0L;
                    break;
                }
                case 15: {
                    this.playerActor.name = "-";
                    this.saveGame();
                    this.toMainMenu();
                    break;
                }
                default: {
                    if (key != '\u0006' && key != '\u0002' && key != '5' && key != '8') break;
                    if (this.stateGame == 9 && this.lineActual + this.linesScreen < this.maxLines) {
                        this.lineActual += this.linesScreen;
                        break;
                    }
                    if (this.nextStateGame()) {
                        this.messagePopup = this.getLastMessage();
                        this.lineActual = 0;
                        this.linesScreen = 0;
                        this.maxLines = 0;
                        switch (this.getLastStateGame()) {
                            case 9: {
                                this.lineData = this.gc.fntGame.getLineData(this.messagePopup.toCharArray(), 240 - GameCanvas.GAP_FURBY_X - this.gc.fntGame.getFontHeight() * 3);
                                this.maxLines = this.lineData.length;
                                break;
                            }
                            case 8: {
                                this.lineData = this.gc.fntGame.getLineData(this.messagePopup.toCharArray(), 240 - GameCanvas.GAP_FURBY_X - this.gc.fntGame.getFontHeight() * 2);
                                break;
                            }
                            case 2: {
                                this.toInterface();
                                this.optionActual = Integer.parseInt(this.messagePopup);
                                break;
                            }
                            default: {
                                this.lineData = null;
                            }
                        }
                        this.stateGame = this.getLastStateGame();
                        break;
                    }
                    this.lineActual = 0;
                    this.linesScreen = 0;
                    this.maxLines = 0;
                    this.stateGame = 0;
                }
            }
            this.cheat(key);
        } else if (this.stateFurby == 0) {
            this.isoEngine.setOffsetX(0);
            this.isoEngine.setOffsetY(0);
            this.playerActor.stopped = true;
        }
    }

    public String getInterfaceName(int option, int maxOptions) {
        if (option == 8) {
            return this.lang[157];
        }
        if (option >= 0) {
            return this.lang[18 + option % maxOptions];
        }
        return this.lang[18 + (maxOptions + option)];
    }

    public void hideNotify() {
        this.gm.pauseApp();
    }

    public void showNotify() {
        this.gm.pauseApp();
    }

    public void toInterface() {
        this.optionActual = 0;
        this.optionInterface = 0;
        this.posInventory = 0;
        this.posStore = 0;
        this.posMinList = 0;
        this.maxOptions = 6;
        this.choosingObject = -1;
        this.stateGame = 2;
        this.updateTextPlayerBornLife();
        this.gc.resetModifiers();
    }

    private void loadMusic(int numMap) {
        String midName;
        switch (numMap) {
            case 1: {
                midName = "beach.mid";
                break;
            }
            case 6: {
                midName = "cave.mid";
                break;
            }
            case 0: {
                midName = "forest.mid";
                break;
            }
            case 8: {
                midName = "house.mid";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                midName = "gameplay.mid";
                break;
            }
            default: {
                midName = "mainMusic.mid";
            }
        }
        if (!midName.equals(this.lastMidName)) {
            this.music.unloadSound(this.sMusic);
            this.sMusic = this.music.loadSound(this.gc.resManager.getResource(midName), 0);
            this.lastMidName = midName;
        }
    }

    private void travelToMap(int numMap, int tileX, int tileY) {
        this.gc.loadPanoramic(numMap);
        this.gc.setMaxLoadResources(this.gc.map.getNumResourcesToLoad());
        this.loadMusic(numMap);
        this.isoEngine.loadMap(numMap);
        this.isoEngine.initBackbuffer(this.isoEngine.gbb, tileX, tileY);
        this.isoEngine.setPlayer(tileX, tileY);
        this.isoEngine.resetFootprints();
        if (numMap == 8 && this.updateHouseObjects()) {
            this.messagePopup = this.lang[143];
            this.stateGame = 8;
        }
        this.keyboard.removeAllEvents();
    }

    private boolean updateHouseObjects() {
        int objectIndex = -1;
        boolean isUpdated = false;
        objectIndex = this.gc.map.isObjectInMap(82);
        if (this.houseObjects[0] && objectIndex != -1) {
            this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)17);
        } else if (objectIndex != -1 && this.inventory.isItemInInventory(1, 85, 1)) {
            this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)17);
            this.inventory.removeItem(1, 85, 1);
            isUpdated = true;
            this.houseObjects[0] = true;
        }
        objectIndex = this.gc.map.isObjectInMap(20);
        if (this.houseObjects[1] && objectIndex != -1) {
            this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)8);
        } else if (objectIndex != -1 && this.inventory.isItemInInventory(1, 22, 1)) {
            this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)8);
            this.inventory.removeItem(1, 22, 1);
            isUpdated = true;
            this.houseObjects[1] = true;
        }
        objectIndex = this.gc.map.isObjectInMap(28);
        if (this.houseObjects[2] && objectIndex != -1) {
            this.gc.map.replaceObjectInMap(objectIndex, (byte)9, (byte)2);
        } else if (objectIndex != -1 && this.inventory.isItemInInventory(1, 30, 1)) {
            this.gc.map.replaceObjectInMap(objectIndex, (byte)9, (byte)2);
            this.inventory.removeItem(1, 30, 1);
            isUpdated = true;
            this.houseObjects[2] = true;
        }
        objectIndex = this.gc.map.isObjectInMap(23);
        if (this.houseObjects[3] && objectIndex != -1) {
            this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)16);
        } else if (this.houseObjects[4] && objectIndex != -1) {
            this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)15);
        } else if (objectIndex != -1) {
            if (this.inventory.isItemInInventory(1, 24, 1)) {
                this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)16);
                this.inventory.removeItem(1, 24, 1);
                isUpdated = true;
                this.houseObjects[3] = true;
            } else if (this.inventory.isItemInInventory(1, 26, 1)) {
                this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)16);
                this.inventory.removeItem(1, 26, 1);
                isUpdated = true;
                this.houseObjects[3] = true;
            } else if (this.inventory.isItemInInventory(1, 25, 1)) {
                this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)15);
                this.inventory.removeItem(1, 25, 1);
                isUpdated = true;
                this.houseObjects[4] = true;
            }
        }
        objectIndex = this.gc.map.isObjectInMap(24);
        if (this.houseObjects[4] && objectIndex != -1) {
            this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)15);
        } else if (objectIndex != -1) {
            if (this.inventory.isItemInInventory(1, 26, 1)) {
                this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)16);
                this.inventory.removeItem(1, 26, 1);
                isUpdated = true;
                this.houseObjects[3] = true;
            } else if (objectIndex != -1 && this.inventory.isItemInInventory(1, 25, 1)) {
                this.gc.map.replaceObjectInMap(objectIndex, (byte)8, (byte)15);
                this.inventory.removeItem(1, 25, 1);
                isUpdated = true;
                this.houseObjects[4] = true;
            }
        }
        return isUpdated;
    }

    private void resetButtonsInterface() {
        for (int i = 0; i < 8; ++i) {
            this.buttons[i] = -1;
            this.buttonsAngle[i] = 0;
            this.buttonsAngleOffset[i] = 0;
        }
    }

    private void addButtonInterface(int button) {
        for (int i = 0; i < 8; ++i) {
            if (this.buttons[i] != -1) continue;
            this.buttons[i] = (byte)button;
            break;
        }
    }

    private boolean isButtonInterface(int button) {
        for (int i = 0; i < 8; ++i) {
            if (this.buttons[i] != button) continue;
            return true;
        }
        return false;
    }

    private int getLastStateGame() {
        return this.lastStateGame;
    }

    private String getLastMessage() {
        return this.lastMessage;
    }

    private boolean nextStateGame() {
        if (this.posStateGameRead != this.posStateGameWrite) {
            this.lastStateGame = this.stateGameList[this.posStateGameRead];
            this.lastMessage = this.messagesList[this.posStateGameRead];
            this.posStateGameRead = (this.posStateGameRead + 1) % 5;
            return true;
        }
        return false;
    }

    private void resetStateGame() {
        this.posStateGameWrite = this.posStateGameRead;
    }

    private void addStateGame(int state, String message) {
        this.stateGameList[this.posStateGameWrite] = state;
        this.messagesList[this.posStateGameWrite] = message;
        this.posStateGameWrite = (this.posStateGameWrite + 1) % 5;
    }

    private int getIdListFromObjectInTileFurby() {
        return this.gc.map.getIdListObject(this.playerActor.tileX, this.playerActor.tileY);
    }

    private int getIdListFromObjectInFrontFurby() {
        int offY;
        int offX;
        switch (this.playerActor.direction) {
            case 0: {
                offX = 4;
                offY = -2;
                break;
            }
            case 2: {
                offX = -4;
                offY = 2;
                break;
            }
            case 3: {
                offX = 4;
                offY = 2;
                break;
            }
            default: {
                offX = -4;
                offY = -2;
            }
        }
        int tileX = this.isoEngine.getMapTileX(this.playerActor.x + offX * 3, this.playerActor.y + offY * 3);
        int tileY = this.isoEngine.getMapTileY(this.playerActor.x + offX * 3, this.playerActor.y + offY * 3);
        int idObject = this.gc.map.getIdListObject(tileX, tileY);
        if (idObject == -1) {
            this.gc.map.getIdListObject(this.playerActor.tileX, this.playerActor.tileY);
        }
        return idObject;
    }

    private boolean isUtilizable() {
        int idObjectListFront = this.getIdListFromObjectInFrontFurby();
        int idObjectListInTile = this.getIdListFromObjectInTileFurby();
        boolean bFront = false;
        boolean bTile = false;
        if (idObjectListFront == -1 && idObjectListInTile == -1) {
            return false;
        }
        if (idObjectListFront != -1) {
            boolean bl = bFront = this.gc.map.isFurby(idObjectListFront) || this.gc.map.isItemToFish(idObjectListFront) || this.gc.map.isItemShell(idObjectListFront) || this.gc.map.isItemRock(idObjectListFront) || this.gc.map.isItemPlant(idObjectListFront) || this.gc.map.isItemWood(idObjectListFront);
        }
        if (idObjectListInTile != -1) {
            bTile = this.gc.map.isFurby(idObjectListInTile) || this.gc.map.isItemToFish(idObjectListInTile) || this.gc.map.isItemShell(idObjectListInTile) || this.gc.map.isItemRock(idObjectListInTile) || this.gc.map.isItemPlant(idObjectListInTile) || this.gc.map.isItemWood(idObjectListInTile);
        }
        return bFront || bTile;
    }

    private void componeButtonsInterface() {
        this.idObjectRecolect = -1;
        this.resetButtonsInterface();
        int idObjectListFront = this.getIdListFromObjectInFrontFurby();
        int idObjectListTile = this.getIdListFromObjectInTileFurby();
        if (idObjectListFront != -1) {
            if (this.gc.map.isFurby(idObjectListFront)) {
                if (this.gc.map.getNumFurbyFromObject(this.getIdListFromObjectInFrontFurby()) == 9) {
                    this.addButtonInterface(2);
                }
                this.addButtonInterface(1);
                this.addButtonInterface(0);
                this.addButtonInterface(6);
            }
            if (this.gc.map.isItemToFish(idObjectListFront)) {
                this.addButtonInterface(4);
            }
            if (this.gc.map.isItemShell(idObjectListFront)) {
                this.addButtonInterface(4);
            }
            if (this.gc.map.isItemPlant(idObjectListFront)) {
                this.addButtonInterface(4);
            }
            if (this.gc.map.isItemRock(idObjectListFront)) {
                this.addButtonInterface(4);
            }
            if (this.gc.map.isItemWood(idObjectListFront)) {
                this.addButtonInterface(4);
            }
            if (this.isButtonInterface(4)) {
                this.idObjectRecolect = idObjectListFront;
            }
        }
        if (idObjectListTile != -1 && !this.isButtonInterface(4)) {
            if (this.gc.map.isItemToFish(idObjectListTile)) {
                this.addButtonInterface(4);
            }
            if (this.gc.map.isItemRock(idObjectListTile)) {
                this.addButtonInterface(4);
            }
            if (this.gc.map.isItemShell(idObjectListTile)) {
                this.addButtonInterface(4);
            }
            if (this.gc.map.isItemPlant(idObjectListTile)) {
                this.addButtonInterface(4);
            }
            if (this.gc.map.isItemWood(idObjectListTile)) {
                this.addButtonInterface(4);
            }
            if (this.isButtonInterface(4)) {
                this.idObjectRecolect = idObjectListTile;
            }
        }
        this.addButtonInterface(7);
        if (this.isoEngine.getNumActualMap() == 8) {
            this.addButtonInterface(5);
        } else {
            this.addButtonInterface(9);
            this.addButtonInterface(3);
        }
        this.addButtonInterface(8);
        this.prepareButtonsAngle();
        this.optionActual = 0;
        this.messageTextDown = this.lang[45 + this.buttons[0]];
        this.stateGame = 1;
    }

    private int getMaxButtons() {
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.buttons[i] == -1) continue;
            ++count;
        }
        return count;
    }

    private void prepareButtonsAngle() {
        int maxButtons = this.getMaxButtons();
        int angleStep = 360 / maxButtons;
        int count = 450;
        for (int i = 0; i < maxButtons; ++i) {
            this.buttonsAngle[i] = (short)count;
            this.buttonsAngleOffset[i] = (short)count;
            count -= angleStep;
        }
    }

    private void processKeysGame() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.stateGame != 11 && this.stateGame != 12 && this.stateGame != 13 && this.stateGame != 14) {
                this.processKeyPlayer(key, this.keyboard.getLastEvent());
                continue;
            }
            if (this.stateGame != 14) continue;
            switch (key) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '5': {
                    this.setLoading(true);
                    this.gc.unloadResource(26);
                    this.gc.loadResource(8);
                    if (!this.nextStateGame()) break;
                    this.messagePopup = this.getLastMessage();
                    this.lineActual = 0;
                    this.linesScreen = 0;
                    this.maxLines = 0;
                    switch (this.getLastStateGame()) {
                        case 9: {
                            this.lineData = this.gc.fntGame.getLineData(this.messagePopup.toCharArray(), 240 - GameCanvas.GAP_FURBY_X - this.gc.fntGame.getFontHeight() * 3);
                            this.maxLines = this.lineData.length;
                            break;
                        }
                        case 8: {
                            this.lineData = this.gc.fntGame.getLineData(this.messagePopup.toCharArray(), 240 - GameCanvas.GAP_FURBY_X - this.gc.fntGame.getFontHeight() * 2);
                            break;
                        }
                        default: {
                            this.lineData = null;
                        }
                    }
                    this.state = 5;
                    this.stateGame = this.getLastStateGame();
                }
            }
        }
    }

    public int nextPart(int posPart, int maxPart) {
        if (++posPart == maxPart) {
            posPart = 0;
        }
        return posPart;
    }

    private void updateTextPlayerBornLife() {
        long timeLife = System.currentTimeMillis() - this.timeBornFurby;
        int days = (int)(timeLife / 86400000L);
        int hours = (int)((timeLife -= (long)(days * 86400000)) / 3600000L);
        StringBuffer sb = new StringBuffer();
        sb.append(days);
        sb.append(' ');
        if (days > 1) {
            sb.append(this.lang[68]);
        } else {
            sb.append(this.lang[67]);
        }
        sb.append(" : ");
        sb.append(hours);
        sb.append(' ');
        if (hours > 1) {
            sb.append(this.lang[66]);
        } else {
            sb.append(this.lang[65]);
        }
        this.textPlayerLife = sb.toString();
    }

    private void launchGame(int modeGame) {
        int i;
        this.setLoading(true);
        this.gc.setMaxLoadResources(14 + this.gc.map.getNumResourcesToLoad());
        this.gc.loadPanoramic(-1);
        this.gc.unloadResource(20);
        this.gc.unloadResource(22);
        this.gc.unloadResource(23);
        this.gc.unloadResource(21);
        this.gc.loadResource(8);
        this.gc.loadResource(15);
        this.gc.loadResource(16);
        this.gc.loadResource(7);
        this.gc.loadResource(9);
        this.gc.loadResource(10);
        this.gc.loadResource(11);
        this.gc.loadResource(12);
        this.gc.loadResource(13);
        this.gc.loadResource(14);
        this.gc.loadResource(17);
        this.gc.loadResource(18);
        this.gc.loadResource(19);
        this.buttons = new byte[8];
        this.buttonsAngle = new short[8];
        this.buttonsAngleOffset = new short[8];
        this.lockLevels = new boolean[]{false, true, true, false, true, false, true, false, false};
        this.houseObjects = new boolean[5];
        this.playerAdult = false;
        this.playerBars = new int[3];
        this.playerBars[1] = 100;
        this.playerBars[2] = 100;
        this.playerBars[0] = 100;
        this.playerBarsFurby = new byte[12];
        this.playerSkills = new int[8];
        for (i = 0; i < this.playerSkills.length; ++i) {
            this.playerSkills[i] = 1;
        }
        this.playerMoney = 0;
        this.timeBars = new long[3];
        this.playersSkillsTimes = new int[10];
        for (i = 0; i < this.playersSkillsTimes.length; ++i) {
            this.playersSkillsTimes[0] = 0;
        }
        this.initWorld();
        this.items = new Items(this.gc.resManager);
        this.inventory = new Inventory(this.items);
        this.qm = new QuestManager(this.playerActor, this.gc.resManager);
        this.gc.map.setItems(this.items);
        this.gc.map.setGameEngine(this);
        this.stateGameList = new int[5];
        this.messagesList = new String[5];
        this.posStateGameRead = 0;
        this.posStateGameWrite = 0;
        this.qm.setActualQuest(0);
        this.timeBornFurby = System.currentTimeMillis();
        if (modeGame == 1) {
            this.loadGame();
            if (this.playerAdult) {
                this.playerActor.setAnimation(null);
                this.gc.loadResource(6);
                this.playerActor.setAnimation(this.gc.furby);
            }
        }
        this.checkLockLevels();
        this.timeBars[0] = System.currentTimeMillis() + 30000L;
        this.timeBars[1] = System.currentTimeMillis() + 30000L;
        this.timeBars[2] = System.currentTimeMillis() + 30000L;
        this.keyboard.removeAllEvents();
        this.state = 5;
        this.stateGame = 0;
        this.stateFurby = 0;
        if (modeGame == 0) {
            this.idFurbyTalk = -2;
            this.newTalkMessage(this.lang[388]);
            this.addStateGame(9, this.qm.getQuestLongText(this.qm.getActualQuest()));
            this.textMinigameVisible = true;
        }
        this.loadMusic(this.isoEngine.getNumActualMap());
    }

    private void setLoading(boolean isLoading) {
        if (isLoading) {
            this.gc.bPanoramic = false;
            this.state = 99;
        }
    }

    private void initWorld() {
        this.isoEngine = new IsoEngine(this.gc);
        this.isoEngine.setMap(this.gc.map);
        this.isoEngine.loadMap(3);
        this.isoEngine.allocBackbuffer();
        this.isoEngine.initBackbuffer(this.isoEngine.gbb, 4, 1);
        this.isoEngine.setPlayer(4, 1);
        this.playerActor = this.isoEngine.getActor(0);
        this.playerActor.setAnimationDirection(0, 2, false);
        this.playerActor.setAnimationDirection(1, 3, false);
        this.playerActor.setAnimationDirection(2, 0, false);
        this.playerActor.setAnimationDirection(3, 1, false);
        this.playerActor.name = this.textBox.getText();
        if (this.playerActor.name.compareTo("") == 0) {
            this.playerActor.name = "FURBY";
        }
        this.processWorld();
    }

    private void processSplash() {
        if (this.timeFinish < this.lastProcessTime) {
            if (this.state == 0) {
                this.gc.unloadResource(0);
                this.gc.loadResource(24);
                this.timeFinish = System.currentTimeMillis() + 3000L;
                this.state = 1;
            } else if (this.state == 1) {
                this.gc.unloadResource(24);
                this.gc.loadResource(4);
                this.timeFinish = System.currentTimeMillis() + 3000L;
                this.state = 2;
            } else if (this.state == 2) {
                this.toMainMenu();
                this.bSound = false;
                this.loadMusic(-1);
                this.iconLeft = 0;
                this.iconRight = 1;
                this.state = 3;
            }
        }
    }

    private void processKeysExitQuestion(boolean ingame) {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() == 1) continue;
            switch (key) {
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    this.running = false;
                    this.gm.running = false;
                    break;
                }
                case '\u0001': {
                    if (!ingame) {
                        this.iconLeft = 0;
                        this.iconRight = -1;
                        this.state = 4;
                        break;
                    }
                    this.state = 5;
                }
            }
        }
    }

    private void processKeysSoundQuestion() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() == 1) continue;
            switch (key) {
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    this.bSound = true;
                    this.keyboard.removeAllEvents();
                    this.iconLeft = 0;
                    this.iconRight = -1;
                    this.state = 4;
                    break;
                }
                case '\u0001': {
                    this.bSound = false;
                    this.loadTextsMenu(0);
                    this.keyboard.removeAllEvents();
                    this.iconLeft = 0;
                    this.iconRight = -1;
                    this.state = 4;
                }
            }
        }
    }

    private void toCoverMenu() {
        if (this.bSound) {
            this.music.playSound(this.sMusic);
        }
        this.iconLeft = 0;
        this.iconRight = -1;
        this.timeFinish = this.lastProcessTime + 3000L;
        this.keyboard.removeAllEvents();
        this.state = 2;
    }

    private void processButtonsInterface() {
        for (int i = 0; i < 8; ++i) {
            this.buttonsAngleOffset[i] = (short)(this.buttonsAngleOffset[i] * 5 / 6);
        }
    }

    private void processFootprints(int tileX, int tileY) {
        boolean posFootprint = false;
        if (this.timeFootprint <= this.lastProcessTime && this.isoEngine.getNumActualMap() == 1) {
            switch (this.playerActor.direction) {
                case 0: 
                case 2: {
                    if (this.footFootprint) {
                        this.isoEngine.addFootprint(this.playerActor.x, this.playerActor.y - 3, 1);
                        break;
                    }
                    this.isoEngine.addFootprint(this.playerActor.x, this.playerActor.y + 3, 1);
                    break;
                }
                default: {
                    if (this.footFootprint) {
                        this.isoEngine.addFootprint(this.playerActor.x - 3, this.playerActor.y, 0);
                        break;
                    }
                    this.isoEngine.addFootprint(this.playerActor.x + 3, this.playerActor.y, 0);
                }
            }
            this.footFootprint = !this.footFootprint;
            this.timeFootprint = this.lastProcessTime + 250L;
        }
    }

    private void processPlayer() {
        this.isoEngine.processPlayer(-this.isoEngine.getOffsetX(), -this.isoEngine.getOffsetY());
        this.processFootprints(this.playerActor.tileX, this.playerActor.tileY);
        this.isoEngine.setExclamation(this.isUtilizable());
        if (!this.playerAdult && this.state == 5) {
            int sumSkills = 0;
            for (int i = 0; i < this.playerSkills.length; ++i) {
                sumSkills += this.playerSkills[i];
            }
            if (sumSkills >= 20) {
                this.setLoading(true);
                this.gc.setMaxLoadResources(1);
                this.playerActor.setAnimation(null);
                this.gc.loadResource(6);
                this.playerActor.setAnimation(this.gc.furby);
                this.playerAdult = true;
                this.stateGame = 10;
                this.state = 5;
            }
        }
        this.messageTextDown = this.isoEngine.getPlayerGate() != -1 ? this.lang[55 + this.isoEngine.getGateMap()] : null;
    }

    private void processWorld() {
        this.isoEngine.processActors();
        this.processPlayer();
        this.isoEngine.processScroll();
        this.isoEngine.processExtras();
    }

    private void processWhistling() {
        if (this.lastProcessTime >= this.timeFinish) {
            this.playerActor.numAnimationForced = -1;
            for (int i = 0; i < this.modifierSkillBar[11].length; ++i) {
                this.addModifierPlayer(2, i, this.modifierSkillBar[11][i]);
            }
            this.addModifiersBars(11);
            this.playerActor.stopped = true;
            this.stateFurby = 0;
            this.stateGame = 0;
        }
    }

    private void processHandcraft() {
        if (this.lastProcessTime >= this.timeFinish) {
            if (this.inventory.canAddItem(1, this.posStore, 1)) {
                this.inventory.addItem(1, this.posStore, 1);
                this.addModifierPlayer(1, this.posStore, 1);
                this.stateGame = 0;
                this.addSkillPoint(5, 1);
                if (this.items.getCategory(1, this.posStore) == 9) {
                    this.addSkillPoint(6, 2);
                }
            } else {
                this.messagePopup = this.lang[390];
                this.stateGame = 8;
            }
        }
    }

    private void processSkillsBars() {
        if (this.timeBars[0] <= this.lastProcessTime) {
            this.addModifiersBars(13);
            this.timeBars[0] = System.currentTimeMillis() + 30000L;
        }
        if (this.timeBars[1] <= this.lastProcessTime) {
            this.addModifiersBars(14);
            this.timeBars[1] = System.currentTimeMillis() + 30000L;
        }
        if (this.timeBars[2] <= this.lastProcessTime) {
            this.addModifiersBars(15);
            this.timeBars[2] = System.currentTimeMillis() + 30000L;
        }
        if (this.playerBars[0] > 40) {
            this.textBarDream = true;
        } else if (this.textBarDream) {
            this.textBarDream = false;
            this.idFurbyTalk = -1;
            this.newTalkMessage(this.lang[398]);
        }
        if (this.playerBars[2] > 40) {
            this.textBarHappy = true;
        } else if (this.textBarHappy) {
            this.textBarHappy = false;
            this.idFurbyTalk = -1;
            this.newTalkMessage(this.lang[400]);
        }
        if (this.playerBars[1] > 40) {
            this.textBarHungry = true;
        } else if (this.textBarHungry) {
            this.textBarHungry = false;
            this.idFurbyTalk = -1;
            this.newTalkMessage(this.lang[399]);
        }
        if (this.playerBars[0] <= 0 || this.playerBars[1] <= 0 || this.playerBars[2] <= 0) {
            this.toFade(0);
        }
    }

    private void toFade(int type) {
        this.fade = 0;
        this.typeFading = type;
        this.stateGame = 13;
    }

    private void processMiniGameGow() {
        if (this.timeStartMiniGameGow <= this.lastProcessTime) {
            if (this.numRounds > 0) {
                this.timeStartMiniGameGow = System.currentTimeMillis();
                this.initMiniGameGow(0, this.scoreMiniGame, this.numRounds);
            } else {
                int numItem;
                int stackItem = this.scoreMiniGame / 100;
                switch (this.stateFurby) {
                    case 1: {
                        numItem = this.items.getFishItem(this.isoEngine.getNumActualMap());
                        this.addModifiersBars(2);
                        break;
                    }
                    case 2: {
                        numItem = this.items.getRockItem(this.isoEngine.getNumActualMap());
                        this.addModifiersBars(1);
                        break;
                    }
                    case 3: {
                        numItem = this.items.getShellItem(this.isoEngine.getNumActualMap());
                        this.addModifiersBars(0);
                        break;
                    }
                    case 5: {
                        numItem = this.items.getPlantItem(this.isoEngine.getNumActualMap());
                        this.addModifiersBars(3);
                        break;
                    }
                    case 4: {
                        numItem = this.items.getWoodItem(this.isoEngine.getNumActualMap());
                        this.addModifiersBars(4);
                        break;
                    }
                    default: {
                        numItem = 0;
                        stackItem = 0;
                    }
                }
                System.out.println("score: " + this.scoreMiniGame);
                this.items.addItemRecolected(this.isoEngine.getNumActualMap(), this.idObjectList, this.lastProcessTime + 10000L);
                if (stackItem > 0) {
                    if (this.inventory.canAddItem(0, numItem, 1)) {
                        this.inventory.addItem(0, numItem, stackItem);
                        this.messagePopup = SSFunctions.replace(this.lang[64], "$ITEM$", String.valueOf(stackItem) + " x " + this.items.getNameItem(0, numItem));
                        this.stateGame = 8;
                    } else {
                        this.messagePopup = this.lang[390];
                        this.stateGame = 8;
                    }
                } else {
                    this.stateGame = 0;
                }
                switch (this.stateFurby) {
                    case 1: {
                        this.addSkillPoint(2, 1);
                        break;
                    }
                    case 2: {
                        this.addSkillPoint(1, 1);
                        break;
                    }
                    case 3: {
                        this.addSkillPoint(0, 1);
                        break;
                    }
                    case 5: {
                        this.addSkillPoint(3, 1);
                        break;
                    }
                    case 4: {
                        this.addSkillPoint(4, 1);
                    }
                }
                this.playerActor.stopped = true;
                this.playerActor.numAnimationForced = -1;
                this.stateFurby = 0;
            }
        }
    }

    private void addSkillPoint(int numBar, int repetitions) {
        int n = numBar;
        this.playersSkillsTimes[n] = this.playersSkillsTimes[n] + repetitions;
        if (this.playerSkills[numBar] < 5 && this.playersSkillsTimes[numBar] >= limitSkillLevels[this.playerSkills[numBar]]) {
            int n2 = numBar;
            this.playerSkills[n2] = this.playerSkills[n2] + 1;
            String text = SSFunctions.replace(this.lang[148], "$SKILL$", this.lang[27 + numBar]);
            if (this.stateGame == 1 || this.stateGame != 8) {
                this.messagePopup = text;
                this.stateGame = 8;
            } else {
                this.addStateGame(8, text);
            }
        }
    }

    private void addModifiersBars(int numModifier) {
        this.playerBars[0] = this.playerBars[0] + this.modifierSkillBar[numModifier][0];
        this.playerBars[1] = this.playerBars[1] + this.modifierSkillBar[numModifier][1];
        this.playerBars[2] = this.playerBars[2] + this.modifierSkillBar[numModifier][2];
        for (int i = 0; i < this.playerBars.length; ++i) {
            if (this.playerBars[i] < 0) {
                this.playerBars[i] = 0;
                continue;
            }
            if (this.playerBars[i] <= 100) continue;
            this.playerBars[i] = 100;
        }
    }

    private void addModifiersBarsBack(int numModifier, int min) {
        this.playerBars[0] = this.playerBars[0] + this.modifierSkillBar[numModifier][0] * min;
        this.playerBars[1] = this.playerBars[1] + this.modifierSkillBar[numModifier][1] * min;
        this.playerBars[2] = this.playerBars[2] + this.modifierSkillBar[numModifier][2] * min;
        for (int i = 0; i < this.playerBars.length; ++i) {
            if (this.playerBars[i] < 0) {
                this.playerBars[i] = 10;
                continue;
            }
            if (this.playerBars[i] <= 100) continue;
            this.playerBars[i] = 100;
        }
    }

    private void processGame() {
        this.processMusic();
        this.processSick();
        this.processKeysGame();
        switch (this.stateGame) {
            case 0: {
                this.processWorld();
                break;
            }
            case 11: {
                this.processHandcraft();
                break;
            }
            case 12: {
                this.processWhistling();
                break;
            }
            case 1: {
                this.processButtonsInterface();
                break;
            }
            case 7: {
                this.processMiniGameGow();
                break;
            }
            case 13: {
                this.processFading();
            }
        }
        this.gc.processModifiers();
        this.processMoney();
        if (this.stateGame == 0 && this.stateFurby == 0) {
            this.processSkillsBars();
        }
    }

    private void processSick() {
    }

    private void processFading() {
        this.fade += 5;
        if (this.fade > 100) {
            this.setLoading(true);
            this.gc.setMaxLoadResources(2);
            switch (this.typeFading) {
                case 0: {
                    if (this.playerBars[0] <= 0) {
                        this.playerBars[0] = 30;
                        this.travelToMap(8, 6, 2);
                        this.playerActor.direction = 2;
                        this.playerActor.stopped = true;
                        this.isoEngine.setOffsetX(0);
                        this.isoEngine.setOffsetY(0);
                        this.messagePopup = this.lang[144];
                    } else if (this.playerBars[1] <= 0) {
                        this.playerBars[1] = 30;
                        this.travelToMap(8, 2, 7);
                        this.playerActor.direction = 1;
                        this.playerActor.stopped = true;
                        this.isoEngine.setOffsetX(0);
                        this.isoEngine.setOffsetY(0);
                        this.messagePopup = this.lang[145];
                    } else if (this.playerBars[2] <= 0) {
                        this.playerBars[2] = 30;
                        if (!this.lockLevels[1]) {
                            this.travelToMap(1, 4, 3);
                            this.playerActor.direction = 3;
                        } else {
                            this.travelToMap(8, 6, 2);
                            this.playerActor.direction = 2;
                        }
                        this.playerActor.stopped = true;
                        this.isoEngine.setOffsetX(0);
                        this.isoEngine.setOffsetY(0);
                        this.messagePopup = this.lang[146];
                    }
                    this.stateGame = 8;
                    break;
                }
                case 1: {
                    this.addModifiersBars(21);
                    this.travelToMap(8, 6, 2);
                    this.playerActor.direction = 2;
                    this.playerActor.stopped = true;
                    this.isoEngine.setOffsetX(0);
                    this.isoEngine.setOffsetY(0);
                    this.stateGame = 0;
                }
            }
            this.state = 5;
        }
    }

    private void processMoney() {
        this.playerMoneyOffset = this.playerMoneyOffset * 2 / 3;
    }

    private void cheat(char key) {
        for (int i = 0; i < this.cheatCode.length; ++i) {
            if (key == this.cheatCode[i].charAt(this.cheatState[i])) {
                int n = i;
                this.cheatState[n] = this.cheatState[n] + 1;
            } else {
                this.cheatState[i] = 0;
            }
            if (this.cheatState[i] != this.cheatCode[i].length()) continue;
            switch (i) {
                case 0: {
                    this.items.cheatShop();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    int numSkill = i - 1;
                    switch (this.playerSkills[numSkill]) {
                        case 1: {
                            this.addSkillPoint(numSkill, limitSkillLevels[1] - this.playersSkillsTimes[numSkill]);
                            break;
                        }
                        case 2: {
                            this.addSkillPoint(numSkill, limitSkillLevels[2] - this.playersSkillsTimes[numSkill]);
                            break;
                        }
                        case 3: {
                            this.addSkillPoint(numSkill, limitSkillLevels[3] - this.playersSkillsTimes[numSkill]);
                            break;
                        }
                        case 4: {
                            this.addSkillPoint(numSkill, limitSkillLevels[4] - this.playersSkillsTimes[numSkill]);
                        }
                    }
                    break;
                }
                case 9: {
                    this.cheatMoney();
                    break;
                }
                case 10: {
                    this.cheatQuestCompleted();
                }
            }
            this.cheatState[i] = 0;
        }
    }

    private void processKeysMenu() {
        block12: while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) {
                this.upPressed = false;
                this.downPressed = false;
                continue;
            }
            switch (key) {
                case '\u0003': 
                case '4': {
                    this.lineActual = 0;
                    --this.optionActual;
                    if (this.optionActual < 0) {
                        this.optionActual = this.maxOptions - 1;
                    }
                    if (this.state != 9) break;
                    this.tutorialActual = (this.tutorialActual + 6) % 7;
                    this.lineData = this.gc.fntGame.getLineData(this.lang[381 + this.tutorialActual].toCharArray(), 240 - (this.gc.fntMenu.getLineSpacing() + this.gc.fntMenu.getFontHeight()) * 2);
                    this.lineActual = 0;
                    break;
                }
                case '\u0004': 
                case '6': {
                    this.lineActual = 0;
                    ++this.optionActual;
                    if (this.optionActual >= this.maxOptions) {
                        this.optionActual = 0;
                    }
                    if (this.state != 9) break;
                    this.tutorialActual = (this.tutorialActual + 1) % 7;
                    this.lineData = this.gc.fntGame.getLineData(this.lang[381 + this.tutorialActual].toCharArray(), 240 - (this.gc.fntMenu.getLineSpacing() + this.gc.fntMenu.getFontHeight()) * 2);
                    this.lineActual = 0;
                    break;
                }
                case '\u0005': 
                case '2': {
                    if (this.state == 4) {
                        --this.optionActual;
                        if (this.optionActual < 0) {
                            this.optionActual = this.maxOptions - 1;
                        }
                    }
                    if (this.lineActual > 0) {
                        --this.lineActual;
                    }
                    this.downPressed = false;
                    this.upPressed = true;
                    this.timeScrollText = this.lastProcessTime + 50L;
                    break;
                }
                case '\u0006': 
                case '8': {
                    if (this.state == 4) {
                        ++this.optionActual;
                        if (this.optionActual >= this.maxOptions) {
                            this.optionActual = 0;
                        }
                    }
                    if (this.lineData != null && this.lineActual <= this.lineData.length - this.maxLines) {
                        ++this.lineActual;
                    }
                    this.downPressed = true;
                    this.upPressed = false;
                    this.timeScrollText = this.lastProcessTime + 50L;
                }
            }
            if (this.state == 2) {
                this.keyboard.removeAllEvents();
                this.loadTextsMenu(0);
                this.state = 4;
                continue;
            }
            String option = this.optionsMenu[this.optionActual];
            switch (key) {
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    if (option.indexOf(this.lang[5]) != -1) {
                        boolean bl = this.bSound = !this.bSound;
                        if (this.bSound && !this.music.isSound(this.sMusic)) {
                            this.music.playSound(this.sMusic);
                        } else if (!this.bSound) {
                            this.music.stopSound(this.sMusic);
                        }
                        this.loadTextsMenu(0);
                        this.optionActual = this.searchOption(this.lang[5]);
                        this.state = 4;
                        break;
                    }
                    if (option.equals(this.lang[1])) {
                        this.checkLoadGame();
                        if (this.hasLoadGame) {
                            this.loadTextsMenu(4);
                            this.iconLeft = 0;
                            this.iconRight = 2;
                            break;
                        }
                        this.iconLeft = 0;
                        this.iconRight = 2;
                        this.state = 10;
                        break;
                    }
                    if (option.equals(this.lang[12])) {
                        this.launchGame(1);
                        break;
                    }
                    if (option.equals(this.lang[11])) {
                        this.iconLeft = 0;
                        this.iconRight = 2;
                        this.state = 10;
                        break;
                    }
                    if (option.equals(this.lang[4])) {
                        this.iconLeft = 0;
                        this.iconRight = 2;
                        this.state = 11;
                        break;
                    }
                    if (option.equals(this.lang[2])) {
                        this.loadTextsMenu(1);
                        this.state = 6;
                        this.iconLeft = -1;
                        this.iconRight = 2;
                        break;
                    }
                    if (option.equals(this.lang[3])) {
                        this.loadTextsMenu(2);
                        this.state = 7;
                        this.iconLeft = -1;
                        this.iconRight = 2;
                        break;
                    }
                    if (option.equals(this.lang[141])) {
                        this.loadTextsMenu(5);
                        this.state = 9;
                        this.iconLeft = -1;
                        this.iconRight = 2;
                        break;
                    }
                    if (!option.equals(this.lang[401])) break;
                    try {
                        if (this.urlGetMoreGames == null) continue block12;
                        this.running = false;
                        this.gm.running = false;
                        this.gm.platformRequest(this.urlGetMoreGames);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case '\u0001': {
                    if (this.state == 6 || this.state == 7 || this.state == 9) {
                        this.loadTextsMenu(0);
                        this.iconLeft = 0;
                        this.iconRight = -1;
                        if (this.state == 6) {
                            this.optionActual = this.searchOption(this.lang[2]);
                        } else if (this.state == 7) {
                            this.optionActual = this.searchOption(this.lang[3]);
                        } else if (this.state == 9) {
                            this.optionActual = this.searchOption(this.lang[141]);
                        }
                        this.state = 4;
                        break;
                    }
                    if (!option.equals(this.lang[12]) && !option.equals(this.lang[11])) break;
                    this.loadTextsMenu(0);
                    this.iconLeft = 0;
                    this.iconRight = -1;
                    this.optionActual = 0;
                }
            }
        }
    }

    private void processMusic() {
        if (!this.music.isSound(this.sMusic) && this.bSound) {
            this.music.playSound(this.sMusic);
        } else if (!this.bSound) {
            this.music.stopSound(this.sMusic);
        }
    }

    private void processMenu() {
        this.processMusic();
        this.processKeysMenu();
        switch (this.state) {
            case 4: {
                break;
            }
            case 2: {
                if (this.lastProcessTime < this.timeFinish) break;
                this.loadTextsMenu(0);
                this.state = 4;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                if (this.timeScrollText > this.lastProcessTime) break;
                if (this.upPressed) {
                    if (this.lineActual > 0) {
                        --this.lineActual;
                    }
                } else if (this.downPressed && this.lineActual <= this.lineData.length - this.maxLines) {
                    ++this.lineActual;
                }
                this.timeScrollText = this.lastProcessTime + 50L;
            }
        }
    }

    private void processKeysNewGame() {
        block4: while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() == 1) continue;
            switch (key) {
                case '\u0001': {
                    this.iconLeft = 0;
                    this.iconRight = -1;
                    this.state = 4;
                    continue block4;
                }
                case '\u0000': 
                case '\u0002': {
                    this.launchGame(0);
                    continue block4;
                }
            }
            this.textBox.keyPressed(key);
        }
    }

    private void process() {
        switch (this.state) {
            case 0: 
            case 1: 
            case 2: {
                this.processSplash();
                break;
            }
            case 11: {
                this.processKeysExitQuestion(false);
                break;
            }
            case 12: {
                this.processKeysExitQuestion(true);
                break;
            }
            case 3: {
                this.processKeysSoundQuestion();
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                this.processMenu();
                break;
            }
            case 5: {
                this.processGame();
                break;
            }
            case 10: {
                this.processKeysNewGame();
            }
        }
    }

    public void keyPressed(int keyCode) {
        this.keyboard.keyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
        this.keyboard.keyReleased(keyCode);
    }

    public void paint(Graphics g) {
        switch (this.state) {
            case 0: 
            case 1: {
                this.gc.paintSplash(g);
                break;
            }
            case 10: {
                this.gc.paintNewGame(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 2: {
                this.gc.paintCover(g);
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                this.gc.paintMainMenu(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 9: {
                this.gc.paintTutorial(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 6: {
                this.gc.paintHelp(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 7: {
                this.gc.paintAbout(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 5: {
                if (this.stateGame == 0 || this.stateGame == 11 || this.stateGame == 12) {
                    this.gc.paintGame(g, this.isoEngine);
                    break;
                }
                if (this.stateGame == 13) {
                    this.gc.paintGame(g, this.isoEngine);
                    this.gc.paintFade(g);
                    break;
                }
                if (this.stateGame == 6 || this.stateGame == 7) {
                    this.gc.paintGame(g, this.isoEngine);
                    this.gc.paintMiniGameGow(g);
                    break;
                }
                if (this.stateGame == 8) {
                    this.gc.paintGame(g, this.isoEngine);
                    this.gc.paintPopup(g, this.messagePopup);
                    break;
                }
                if (this.stateGame == 15) {
                    this.gc.paintGameOver(g);
                    this.gc.paintPopupGameOver(g, this.messagePopup, this.isoEngine);
                    break;
                }
                if (this.stateGame == 9) {
                    this.gc.paintGame(g, this.isoEngine);
                    this.gc.paintTalk(g, this.messagePopup, this.isoEngine);
                    break;
                }
                if (this.stateGame == 1) {
                    this.gc.paintGame(g, this.isoEngine);
                    this.gc.paintButtonsInterface(g, this.isoEngine.getActorX(this.playerActor), this.isoEngine.getActorY(this.playerActor) - this.playerActor.getHeight() / 3 - this.playerActor.height * this.isoEngine.getTileGapHeight(), 40, this.buttons, this.buttonsAngle, this.buttonsAngleOffset);
                    break;
                }
                if (this.stateGame == 2 || this.stateGame == 3 || this.stateGame == 4 || this.stateGame == 5) {
                    this.gc.paintInterface(g, this.optionActual);
                    break;
                }
                if (this.stateGame == 10) {
                    this.gc.paintFurbyGrown(g, this.playerActor);
                    break;
                }
                if (this.stateGame != 14) break;
                this.gc.paintParty(g);
                break;
            }
            case 99: {
                this.gc.paintLoading(g);
            }
        }
    }

    public void run() {
        this.running = true;
        while (this.running) {
            this.lastProcessTime = System.currentTimeMillis() - this.pauseTime;
            this.process();
            this.repaint();
            this.serviceRepaints();
            long time = System.currentTimeMillis() - this.pauseTime;
            if (time - this.lastProcessTime < 40L) {
                this.sleep(40 - (int)(time - this.lastProcessTime));
                continue;
            }
            this.sleep(5);
        }
    }
}

