/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.furby;

import com.lemonquest.furby.Actor;
import com.lemonquest.furby.GameCanvas;
import com.lemonquest.furby.Map;
import com.lemonquest.utils.SSAnimation;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class IsoEngine {
    public static final int CAMERA_OFFSET = 4;
    private static final int BACKBUFFER_RIGHT = 0;
    private static final int BACKBUFFER_LEFT = 1;
    private static final int BACKBUFFER_DOWN = 0;
    private static final int BACKBUFFER_UP = 1;
    private GameCanvas gc;
    private Map map;
    private int numActualMap;
    private Image backbuffer;
    private int backWidth;
    private int backHeight;
    private int tileWidth;
    private int tileHeight;
    private int tilesX;
    private int tilesY;
    private int limitX;
    private int limitY;
    private int limitPixelsX;
    private int limitPixelsY;
    public Graphics gbb;
    private int walkTileX;
    private int walkTileY;
    public static int CAMERA_GAP_X;
    public static int CAMERA_GAP_Y;
    private int cameraX;
    private int cameraY;
    private int offsetX;
    private int offsetY;
    private int cameraWorldX;
    private int cameraWorldY;
    private int cameraTileX;
    private int cameraTileY;
    private int offsetCameraTileX;
    private int offsetCameraTileY;
    public int rootInScreenX;
    public int rootInScreenY;
    public static final int MAX_ACTORS = 5;
    private Actor[] actors;
    private int playerGate;
    private int numActors;
    public static final int MAX_FOOTPRINTS = 50;
    public static final int FOOTPRINTS_HORIZONTAL = 0;
    public static final int FOOTPRINTS_VERTICAL = 1;
    public static final int TIME_FOOTPRINT = 250;
    public short[] footPrintsX;
    public short[] footPrintsY;
    public int posFootprint;
    private int exclamationOffsetY;
    private int cloudOffsetY;
    public static int SCREEN_WIDTH;
    public static int SCREEN_HEIGHT;
    public boolean debugMode = false;

    public IsoEngine(GameCanvas gc) {
        this.gc = gc;
        this.footPrintsX = new short[50];
        this.footPrintsY = new short[50];
        this.posFootprint = 0;
    }

    public SSAnimation getAnimation(int numFile) {
        return this.map.getAnimation(numFile);
    }

    public void setExclamation(boolean visible) {
        if (visible) {
            if (this.exclamationOffsetY == -1) {
                this.exclamationOffsetY = this.gc.sign.getHeight();
            }
        } else {
            this.exclamationOffsetY = -1;
        }
    }

    public void setCloud(boolean visible) {
        if (visible) {
            if (this.cloudOffsetY == -1) {
                this.cloudOffsetY = this.gc.cloud.getHeight();
            }
        } else {
            this.cloudOffsetY = -1;
        }
    }

    public Actor getActor(int numActor) {
        return this.actors[numActor];
    }

    public int getActorX(Actor actor) {
        return CAMERA_GAP_X + this.rootInScreenX + actor.x;
    }

    public int getActorY(Actor actor) {
        return CAMERA_GAP_Y + this.rootInScreenY + actor.y;
    }

    public void setMap(Map map) {
        this.map = map;
        this.map.isoEngine = this;
    }

    public void loadMap(int numMap) {
        this.numActualMap = numMap;
        this.map.loadMap(this.gc.resManager.getResourceAsStream("w.fbw"), this.gc.resManager, numMap);
        this.tileWidth = this.map.getTileGapX() * 2;
        this.tileHeight = this.map.getTileGapY() * 2;
    }

    private void walkTile(int x, int y, int stepX, int stepY) {
        this.walkTileX = x + stepX;
        this.walkTileY = y - stepX;
        this.walkTileX += stepY;
        this.walkTileY += stepY;
    }

    public int getWorldCoordinateXFromTile(int tileX, int tileY) {
        return (tileX - tileY) * this.map.getTileGapX();
    }

    public int getWorldCoordinateYFromTile(int tileX, int tileY) {
        return (tileX + tileY) * this.map.getTileGapY();
    }

    public void setPlayer(int tileX, int tileY) {
        if (this.actors[0] == null) {
            this.actors[0] = new Actor("FURBY", 0, 0, 2, this.gc.furby);
            this.numActors = 1;
        }
        this.actors[0].x = this.getWorldCoordinateXFromTile(tileX, tileY);
        this.actors[0].y = this.getWorldCoordinateYFromTile(tileX, tileY) + this.map.getTileGapY();
        this.processActors();
    }

    public void allocBackbuffer() {
        int tileWidth = this.map.getTileGapX() * 2;
        int tileHeight = this.map.getTileGapY() * 2;
        CAMERA_GAP_X = 0;
        CAMERA_GAP_Y = 0;
        this.tilesX = SCREEN_WIDTH / tileWidth + 1 + (SCREEN_WIDTH % tileWidth > 0 ? 1 : 0);
        this.tilesY = SCREEN_HEIGHT / tileHeight + 1 + (SCREEN_HEIGHT % tileHeight > 0 ? 1 : 0);
        System.out.println("TilesX = " + this.tilesX);
        System.out.println("TilesY = " + this.tilesY);
        this.backWidth = this.tilesX * tileWidth;
        this.backHeight = this.tilesY * tileHeight;
        this.backbuffer = Image.createImage((int)this.backWidth, (int)this.backHeight);
        this.gbb = this.backbuffer.getGraphics();
        this.actors = new Actor[5];
    }

    public void initBackbuffer(Graphics g, int cameraTileX, int cameraTileY) {
        this.paintBackground(g, 0, 0, this.backWidth, this.backHeight);
        this.limitX = this.tilesX / 2;
        this.limitY = this.tilesY / 2;
        this.limitPixelsX = this.limitX * this.tileWidth;
        this.limitPixelsY = this.limitY * this.tileHeight;
        this.cameraX = SCREEN_WIDTH / 2 - (this.backWidth - this.limitPixelsX - this.map.getTileGapX() * (this.tilesX % 2));
        this.cameraY = SCREEN_HEIGHT / 2 - (this.backHeight - this.limitPixelsY - this.map.getTileGapY() * (this.tilesY % 2));
        this.cameraTileX = cameraTileX;
        this.cameraTileY = cameraTileY;
        cameraTileX += this.tilesX - this.limitX * 2;
        this.cameraWorldX = this.getWorldCoordinateXFromTile(this.cameraTileX, this.cameraTileY);
        this.cameraWorldY = this.getWorldCoordinateYFromTile(this.cameraTileX, this.cameraTileY) + this.map.getTileGapY();
        this.rootInScreenX = SCREEN_WIDTH / 2 - this.getWorldCoordinateXFromTile(this.cameraTileX, this.cameraTileY) - CAMERA_GAP_X;
        this.rootInScreenY = SCREEN_HEIGHT / 2 - this.map.getTileGapY() - this.getWorldCoordinateYFromTile(this.cameraTileX, this.cameraTileY) - CAMERA_GAP_Y;
        this.offsetCameraTileX = this.map.getTileGapX();
        this.offsetCameraTileY = this.map.getTileGapY();
        this.walkTile(cameraTileX, cameraTileY, -(this.tilesX - this.limitX), -(this.tilesY - this.limitY));
        int tileIniX = this.cameraTileX = this.walkTileX;
        int tileX = this.cameraTileX;
        int tileIniY = this.cameraTileY = this.walkTileY;
        int tileY = this.cameraTileY;
        int startX = this.limitPixelsX;
        int startY = this.limitPixelsY;
        this.fillQuad(g, tileX, tileY, startX - this.map.getTileGapX(), startY - this.map.getTileGapY(), this.backWidth, this.backHeight, startX, startY, this.backWidth, this.backHeight);
        this.walkTile(tileIniX, tileIniY, this.tilesX - this.limitX, 0);
        tileX = this.walkTileX;
        tileY = this.walkTileY;
        startX = this.limitPixelsX - this.limitX * this.map.getTileGapX() * 2;
        startY = this.limitPixelsY;
        this.fillQuad(g, tileX, tileY, startX - this.map.getTileGapX(), startY - this.map.getTileGapY(), startX, this.backHeight, startX, startY, this.limitPixelsX, this.backHeight);
        this.walkTile(tileIniX, tileIniY, 0, this.tilesY - this.limitY);
        tileX = this.walkTileX;
        tileY = this.walkTileY;
        startX = this.limitPixelsX;
        startY = this.limitPixelsY - this.limitY * this.map.getTileGapY() * 2;
        this.fillQuad(g, tileX, tileY, startX - this.map.getTileGapX(), startY - this.map.getTileGapY(), this.backWidth, this.limitPixelsY, startX, startY, this.backWidth, this.limitPixelsY);
        this.walkTile(tileIniX, tileIniY, this.tilesX - this.limitX + 0, this.tilesY - this.limitY + 0);
        tileX = this.walkTileX;
        tileY = this.walkTileY;
        startX = this.limitPixelsX - this.limitX * this.map.getTileGapX() * 2;
        startY = this.limitPixelsY - this.limitY * this.map.getTileGapY() * 2;
        this.fillQuad(g, tileX, tileY, startX - this.map.getTileGapX(), startY - this.map.getTileGapY(), this.limitPixelsX, this.limitPixelsY, startX, startY, this.limitPixelsX, this.limitPixelsY);
    }

    private void fillQuad(Graphics g, int paintTileX, int paintTileY, int startX, int startY, int endX, int endY, int minClipX, int minClipY, int maxClipX, int maxClipY) {
        startY -= this.map.getTileHeight();
        if (--paintTileX < 0 || --paintTileY < 0) {
            int distMap = Math.min(paintTileX, paintTileY);
            endY += this.map.getTileGapY() * Math.abs(distMap);
        }
        int y = startY;
        int j = 0;
        while (y < endY) {
            int tileX = paintTileX;
            int tileY = paintTileY;
            int x = startX;
            if (j % 2 == 1) {
                x += this.map.getTileGapX();
                tileX += j / 2 + 1;
                tileY += j / 2;
            } else {
                tileX += j / 2;
                tileY += j / 2;
            }
            int maxHeight = 0;
            int maxTilesRepaint = 0;
            while (x < maxClipX) {
                if (tileX >= 0 && tileY >= 0 && tileX < this.map.getMapWidth() && tileY < this.map.getMapHeight()) {
                    if (this.map.getCompressedTile(tileX, tileY) != -1) {
                        if (tileX == this.map.getMapWidth() - 1 && tileY > 0 && this.map.getCompressedTile(tileX, tileY - 1) != -1) {
                            this.paintTile(g, x + this.map.getTileGapX(), y - this.map.getTileGapY(), this.map.getNumTile(tileX, tileY - 1), this.map.getNumTileSet(tileX, tileY - 1), this.map.getNumWall(tileX, tileY - 1), this.map.getHeightMapTile(tileX, tileY - 1), minClipX, minClipY, maxClipX, maxClipY);
                        } else if (tileY == this.map.getMapHeight() - 1 && tileX > 0 && this.map.getCompressedTile(tileX - 1, tileY) != -1) {
                            this.paintTile(g, x - this.map.getTileGapX(), y - this.map.getTileGapY(), this.map.getNumTile(tileX - 1, tileY), this.map.getNumTileSet(tileX - 1, tileY), this.map.getNumWall(tileX - 1, tileY), this.map.getHeightMapTile(tileX - 1, tileY), minClipX, minClipY, maxClipX, maxClipY);
                        }
                        this.paintTile(g, x, y, this.map.getNumTile(tileX, tileY), this.map.getNumTileSet(tileX, tileY), this.map.getNumWall(tileX, tileY), this.map.getHeightMapTile(tileX, tileY), minClipX, minClipY, maxClipX, maxClipY);
                        int tilesRepaint = this.map.getNumTilesRepaint(tileX, tileY);
                        maxHeight = Math.max(maxHeight, this.map.getHeightMapTile(tileX, tileY));
                        maxTilesRepaint = Math.max(maxTilesRepaint, tilesRepaint);
                    }
                } else if (tileX == this.map.getMapWidth() && tileY == this.map.getMapHeight() && this.map.getCompressedTile(tileX - 1, tileY - 1) != -1) {
                    this.paintTile(g, x, y - this.map.getTileGapY() * 2, this.map.getNumTile(tileX - 1, tileY - 1), this.map.getNumTileSet(tileX - 1, tileY - 1), this.map.getNumWall(tileX - 1, tileY - 1), this.map.getHeightMapTile(tileX - 1, tileY - 1), minClipX, minClipY, maxClipX, maxClipY);
                }
                x += this.map.getTileGapX() * 2;
                ++tileX;
                --tileY;
            }
            y += this.map.getTileGapY();
            endY += this.map.getTileGapHeight() * maxHeight + this.map.getTileGapY() * 2 * maxTilesRepaint;
            ++j;
        }
    }

    private void paintWall(Graphics g, int x, int y, int numTileSet, int numWall, int height, int minClipX, int minClipY, int maxClipX, int maxClipY) {
        int tileWidth = this.map.getSpriteDataWall(numWall, numTileSet, 2);
        int tileHeight = this.map.getSpriteDataWall(numWall, numTileSet, 3);
        int imageX = this.map.getSpriteDataWall(numWall, numTileSet, 0);
        int imageY = this.map.getSpriteDataWall(numWall, numTileSet, 1);
        Image image = this.map.getTileSetImage(numTileSet);
        x += this.map.getSpriteDataWall(numWall, numTileSet, 4);
        y += this.map.getSpriteDataWall(numWall, numTileSet, 5);
        y -= height * this.map.getTileGapHeight();
        if (height > 0) {
            ++height;
        }
        for (int i = 0; i < height; ++i) {
            if (this.collision(x, y, tileWidth, tileHeight, minClipX, minClipY, maxClipX - minClipX, maxClipY - minClipY)) {
                g.setClip(x, y, tileWidth, tileHeight);
                g.clipRect(minClipX, minClipY, maxClipX - minClipX, maxClipY - minClipY);
                g.drawImage(image, x - imageX, y - imageY, 20);
            }
            y += this.map.getTileGapHeight();
        }
        image = null;
    }

    private void paintTilesVertically(Graphics g, int x, int y, int tileX, int tileY, int tilesRepaint, int minClipX, int minClipY, int maxClipX, int maxClipY) {
        for (int j = 0; j < tilesRepaint; ++j) {
            y += this.map.getTileGapY() * 2;
            if (this.map.getCompressedTile(++tileX, ++tileY) == 65535) continue;
            this.paintTile(g, x, y, this.map.getNumTile(tileX, tileY), this.map.getNumTileSet(tileX, tileY), 0, this.map.getHeightMapTile(tileX, tileY), minClipX, minClipY, maxClipX, maxClipY);
        }
    }

    private void paintTile(Graphics g, int x, int y, int numTile, int numTileSet, int numWall, int height, int minClipX, int minClipY, int maxClipX, int maxClipY) {
        int tileWidth = this.map.getSpriteDataTile(numTile, numTileSet, 2);
        int tileHeight = this.map.getSpriteDataTile(numTile, numTileSet, 3);
        int imageX = this.map.getSpriteDataTile(numTile, numTileSet, 0);
        int imageY = this.map.getSpriteDataTile(numTile, numTileSet, 1);
        Image image = this.map.getTileSetImage(numTileSet);
        int offsetY = this.map.getSpriteDataTile(numTile, numTileSet, 5);
        if (height > 0 && numWall != -1) {
            this.paintWall(g, x, y - (offsetY < 0 ? offsetY : 0), numTileSet, numWall, height, minClipX, minClipY, maxClipX, maxClipY);
        }
        y += offsetY;
        if (this.collision(x += this.map.getSpriteDataTile(numTile, numTileSet, 4), y -= height * this.map.getTileGapHeight(), tileWidth, tileHeight, minClipX, minClipY, maxClipX - minClipX, maxClipY - minClipY)) {
            g.setClip(x, y, tileWidth, tileHeight);
            g.clipRect(minClipX, minClipY, maxClipX - minClipX, maxClipY - minClipY);
            g.drawImage(image, x - imageX, y - imageY, 20);
        }
        image = null;
    }

    private void paintColumnBackbuffer(Graphics g, int type) {
        if (type == 0) {
            this.paintBackground(this.gbb, this.limitPixelsX, 0, this.map.getTileWidth(), this.backHeight);
            this.walkTile(this.cameraTileX - 1, this.cameraTileY - 1, this.tilesX, this.tilesY - this.limitY);
            int tileX = this.walkTileX;
            int tileY = this.walkTileY;
            int startX = this.limitPixelsX;
            int startY = this.limitPixelsY - this.limitY * this.map.getTileHeight();
            this.fillQuad(this.gbb, tileX, tileY, startX - this.offsetCameraTileX, startY - this.offsetCameraTileY - this.map.getTileHeight(), this.limitPixelsX + this.map.getTileWidth(), this.limitPixelsY, this.limitPixelsX, startY, this.limitPixelsX + this.map.getTileWidth(), this.limitPixelsY);
            this.walkTile(this.cameraTileX - 1, this.cameraTileY - 1, this.tilesX, 0);
            tileX = this.walkTileX;
            tileY = this.walkTileY;
            startX = this.limitPixelsX;
            startY = this.limitPixelsY;
            this.fillQuad(this.gbb, tileX, tileY, startX - this.offsetCameraTileX, startY - this.offsetCameraTileY - this.map.getTileHeight(), this.limitPixelsX + this.map.getTileWidth(), this.backHeight, this.limitPixelsX, startY, this.limitPixelsX + this.map.getTileWidth(), this.backHeight);
            ++this.cameraTileX;
            --this.cameraTileY;
            ++this.limitX;
            this.limitPixelsX += this.map.getTileWidth();
            if (this.limitX == this.tilesX) {
                this.limitX = 0;
                this.limitPixelsX = 0;
            }
        } else {
            --this.limitX;
            this.limitPixelsX -= this.map.getTileWidth();
            if (this.limitX < 0 || this.limitPixelsX < 0) {
                this.limitX = this.tilesX - 1;
                this.limitPixelsX = this.backWidth - this.map.getTileWidth();
            }
            --this.cameraTileX;
            ++this.cameraTileY;
            this.paintBackground(this.gbb, this.limitPixelsX, 0, this.map.getTileWidth(), this.backHeight);
            this.walkTile(this.cameraTileX - 1, this.cameraTileY - 1, 0, this.tilesY - this.limitY);
            int tileX = this.walkTileX;
            int tileY = this.walkTileY;
            int startX = this.limitPixelsX;
            int startY = this.limitPixelsY - this.limitY * this.map.getTileHeight();
            this.fillQuad(this.gbb, tileX, tileY, startX - this.offsetCameraTileX, startY - this.offsetCameraTileY - this.map.getTileHeight(), this.limitPixelsX + this.map.getTileWidth(), this.limitPixelsY, this.limitPixelsX, startY, this.limitPixelsX + this.map.getTileWidth(), this.limitPixelsY);
            tileX = this.cameraTileX - 1;
            tileY = this.cameraTileY - 1;
            startX = this.limitPixelsX;
            startY = this.limitPixelsY;
            this.fillQuad(this.gbb, tileX, tileY, startX - this.offsetCameraTileX, startY - this.offsetCameraTileY - this.map.getTileHeight(), this.limitPixelsX + this.map.getTileWidth(), this.backHeight, this.limitPixelsX, startY, this.limitPixelsX + this.map.getTileWidth(), this.backHeight);
        }
    }

    private void paintRowBackbuffer(Graphics g, int type) {
        if (type == 0) {
            this.paintBackground(this.gbb, 0, this.limitPixelsY, this.backWidth, this.map.getTileHeight());
            this.walkTile(this.cameraTileX - 1, this.cameraTileY - 1, 0, this.tilesY);
            int tileX = this.walkTileX;
            int tileY = this.walkTileY;
            int startX = this.limitPixelsX;
            int startY = this.limitPixelsY;
            this.fillQuad(this.gbb, tileX, tileY, startX - this.offsetCameraTileX, startY - this.offsetCameraTileY - this.map.getTileHeight(), this.backWidth, startY + this.map.getTileHeight(), this.limitPixelsX, this.limitPixelsY, this.backWidth, startY + this.map.getTileHeight());
            this.walkTile(this.cameraTileX - 1, this.cameraTileY - 1, this.tilesX - this.limitX, this.tilesY);
            tileX = this.walkTileX;
            tileY = this.walkTileY;
            startX = this.limitPixelsX - this.limitX * this.map.getTileWidth();
            startY = this.limitPixelsY;
            this.fillQuad(this.gbb, tileX, tileY, startX - this.offsetCameraTileX, startY - this.offsetCameraTileY - this.map.getTileHeight(), this.limitPixelsX, startY + this.map.getTileHeight(), startX, this.limitPixelsY, this.limitPixelsX, startY + this.map.getTileHeight());
            ++this.cameraTileX;
            ++this.cameraTileY;
            ++this.limitY;
            this.limitPixelsY += this.map.getTileHeight();
            if (this.limitY == this.tilesY) {
                this.limitY = 0;
                this.limitPixelsY = 0;
            }
        } else {
            --this.limitY;
            this.limitPixelsY -= this.map.getTileHeight();
            if (this.limitY < 0) {
                this.limitY = this.tilesY - 1;
                this.limitPixelsY = this.backHeight - this.map.getTileHeight();
            }
            --this.cameraTileX;
            --this.cameraTileY;
            this.paintBackground(this.gbb, 0, this.limitPixelsY, this.backWidth, this.map.getTileHeight());
            int tileX = this.cameraTileX;
            int tileY = this.cameraTileY;
            int startX = this.limitPixelsX;
            int startY = this.limitPixelsY;
            this.fillQuad(this.gbb, tileX - 1, tileY - 1, startX - this.offsetCameraTileX, startY - this.offsetCameraTileY - this.map.getTileHeight(), this.backWidth, startY + this.map.getTileHeight(), this.limitPixelsX, this.limitPixelsY, this.backWidth, startY + this.map.getTileHeight());
            this.walkTile(this.cameraTileX, this.cameraTileY, this.tilesX - this.limitX, 0);
            tileX = this.walkTileX;
            tileY = this.walkTileY;
            startX = this.limitPixelsX - this.limitX * this.map.getTileWidth();
            startY = this.limitPixelsY;
            this.fillQuad(this.gbb, tileX - 1, tileY - 1, startX - this.offsetCameraTileX, startY - this.offsetCameraTileY - this.map.getTileHeight(), this.limitPixelsX, startY + this.map.getTileHeight(), startX, this.limitPixelsY, this.limitPixelsX, startY + this.map.getTileHeight());
        }
    }

    private void paintBackground(Graphics g, int x, int y, int width, int height) {
        g.setClip(x, y, width, height);
        g.setColor(0);
        g.fillRect(x, y, width, height);
    }

    private void paintMap(Graphics g, int worldX, int worldY) {
        this.paintBackground(g, 0, 0, 240, 320);
        int width = this.map.getMapWidth();
        int height = this.map.getMapHeight();
        int x = worldX - this.map.getTileGapX();
        int y = worldY;
        for (int tileY = 0; tileY < height; ++tileY) {
            int xTile = x;
            int yTile = y;
            for (int tileX = 0; tileX < width; ++tileX) {
                if (this.map.getCompressedTile(tileX, tileY) != -1) {
                    this.paintTile(g, x, y, this.map.getNumTile(tileX, tileY), this.map.getNumTileSet(tileX, tileY), this.map.getNumWall(tileX, tileY), this.map.getHeightMapTile(tileX, tileY), 0, 0, 240, 320);
                }
                x += this.map.getTileGapX();
                y += this.map.getTileGapY();
            }
            x = xTile - this.map.getTileGapX();
            y = yTile + this.map.getTileGapY();
        }
    }

    private void paintBackbuffer(Graphics g, int x, int y) {
        g.setClip(x, y, this.backWidth - this.limitPixelsX, this.backHeight - this.limitPixelsY);
        g.drawImage(this.backbuffer, x - this.limitPixelsX, y - this.limitPixelsY, 20);
        g.setClip(x + (this.backWidth - this.limitPixelsX), y, this.limitPixelsX, this.backHeight - this.limitPixelsY);
        g.drawImage(this.backbuffer, x + (this.backWidth - this.limitPixelsX), y - this.limitPixelsY, 20);
        g.setClip(x, y + (this.backHeight - this.limitPixelsY), this.backWidth - this.limitPixelsX, this.limitPixelsY);
        g.drawImage(this.backbuffer, x - this.limitPixelsX, y + (this.backHeight - this.limitPixelsY), 20);
        g.setClip(x + (this.backWidth - this.limitPixelsX), y + (this.backHeight - this.limitPixelsY), this.limitPixelsX, this.limitPixelsY);
        g.drawImage(this.backbuffer, x + (this.backWidth - this.limitPixelsX), y + (this.backHeight - this.limitPixelsY), 20);
    }

    private void resetClip(Graphics g) {
        g.setClip(CAMERA_GAP_X, CAMERA_GAP_Y, SCREEN_WIDTH, SCREEN_HEIGHT);
    }

    public int getMapTileX(int worldCoordinateX, int wolrdCoordinateY) {
        return (wolrdCoordinateY << 10) / this.map.getTileHeight() + (worldCoordinateX << 10) / this.map.getTileWidth() >> 10;
    }

    public int getMapTileY(int worldCoordinateX, int wolrdCoordinateY) {
        return (wolrdCoordinateY << 10) / this.map.getTileHeight() - (worldCoordinateX << 10) / this.map.getTileWidth() >> 10;
    }

    public int getTileGapHeight() {
        return this.map.getTileGapHeight();
    }

    public void paintFurby(Graphics g, int x, int y) {
        this.actors[0].x = x;
        this.actors[0].y = y + 30;
        this.actors[0].paint(g, 0, 0);
    }

    private void paintActor(Graphics g, Actor actor) {
        int x = CAMERA_GAP_X + this.rootInScreenX;
        int y = CAMERA_GAP_Y + this.rootInScreenY;
        int height = actor.height * this.map.getTileGapHeight();
        actor.paint(g, x, y - height);
        actor.updateMaxClipping();
        int indexRepaint = this.map.getIndexRepaint(actor.tileX, actor.tileY);
        if (indexRepaint != -1) {
            this.paintRepaintsTile(g, indexRepaint, x, y, x + actor.x + actor.minX, y + actor.y + actor.minY - height, actor.maxX - actor.minX, actor.maxY - actor.minY);
        }
        int obj1 = this.map.getFirstObjectRepaint(actor.tileX, actor.tileY);
        int obj2 = this.map.getSecondObjectRepaint(actor.tileX, actor.tileY);
        if (obj1 != -1) {
            this.map.paintObject(g, obj1, x, y, x + actor.x + actor.minX, y + actor.y + actor.minY - height, x + actor.x + actor.maxX, y + actor.y + actor.maxY - height);
        }
        if (obj2 != -1) {
            this.map.paintObject(g, obj2, x, y, x + actor.x + actor.minX, y + actor.y + actor.minY - height, x + actor.x + actor.maxX, y + actor.y + actor.maxY - height);
        }
    }

    public void paintRepaintsTile(Graphics g, int indexRepaint, int xWorld, int yWorld, int x, int y, int width, int height) {
        short[] tilesRepaint = this.map.getTilesRepaints(indexRepaint);
        for (int i = 1; i < tilesRepaint.length; ++i) {
            int tileY;
            int tileX = tilesRepaint[i] % this.map.getMapWidth();
            if (this.map.getCompressedTile(tileX, tileY = tilesRepaint[i] / this.map.getMapWidth()) == 65535) continue;
            this.paintTile(g, xWorld + this.getWorldCoordinateXFromTile(tileX, tileY) - this.map.getTileGapX(), yWorld + this.getWorldCoordinateYFromTile(tileX, tileY), this.map.getNumTile(tileX, tileY), this.map.getNumTileSet(tileX, tileY), this.map.getNumWall(tileX, tileY), this.map.getHeightMapTile(tileX, tileY), x, y, x + width, y + height);
        }
    }

    private void paintActors(Graphics g) {
        for (int i = 0; i < this.numActors; ++i) {
            this.paintActor(g, this.actors[i]);
        }
    }

    public void paintAnimation(Graphics g, int x, int y, int numFile, int numAnimation, boolean cyclical) {
        this.map.paintAnimation(g, x, y, numFile, numAnimation, cyclical);
    }

    private void paintObjects(Graphics g) {
        for (int i = 0; i < this.map.getNumObjectsMap(); ++i) {
            this.map.paintObject(g, i, CAMERA_GAP_X + this.rootInScreenX, CAMERA_GAP_Y + this.rootInScreenY);
        }
    }

    public void paint(Graphics g) {
        if (this.debugMode) {
            g.setClip(0, 0, this.backWidth, this.backHeight);
            g.drawImage(this.backbuffer, 0, 0, 20);
        } else {
            this.paintBackbuffer(g, CAMERA_GAP_X + this.cameraX, CAMERA_GAP_Y + this.cameraY);
            this.paintFootprints(g, CAMERA_GAP_X + this.rootInScreenX, CAMERA_GAP_Y + this.rootInScreenY);
            this.paintObjects(g);
            this.paintSign(g);
            this.paintActors(g);
        }
    }

    private void paintSign(Graphics g) {
        this.resetClip(g);
        if (this.exclamationOffsetY != -1) {
            g.drawImage(this.gc.sign, CAMERA_GAP_X + this.rootInScreenX + this.actors[0].x, CAMERA_GAP_Y + this.rootInScreenY + this.actors[0].y - this.actors[0].getWidth() - this.gc.sign.getHeight() / 2 + this.exclamationOffsetY, 33);
        }
    }

    public void resetFootprints() {
        for (int i = 0; i < 50; ++i) {
            this.footPrintsY[i] = 0;
            this.footPrintsX[i] = 0;
        }
    }

    public void addFootprint(int x, int y, int type) {
        this.footPrintsX[this.posFootprint] = (short)(type & 1 | x & 0xFFFE);
        this.footPrintsY[this.posFootprint] = (short)(type & 1 | y & 0xFFFE);
        if (x < 0) {
            int n = this.posFootprint;
            this.footPrintsX[n] = (short)(this.footPrintsX[n] | 0x8000);
        }
        if (y < 0) {
            int n = this.posFootprint;
            this.footPrintsX[n] = (short)(this.footPrintsX[n] | 0x8000);
        }
        ++this.posFootprint;
        if (this.posFootprint >= 50) {
            this.posFootprint = 0;
        }
    }

    private void paintFootprints(Graphics g, int x, int y) {
        for (int i = 0; i < 50; ++i) {
            int type = this.footPrintsX[i] & 1;
            int fx = this.footPrintsX[i] - type;
            int fy = this.footPrintsY[i] - type;
            if (fx == 0 || fy == 0) continue;
            this.resetClip(g);
            if (type == 1) {
                g.setColor(10912049);
                g.drawLine(x + fx, y + fy, x + fx - 4, y + fy + 2);
                g.setColor(12623445);
                g.drawLine(x + fx, y + fy + 1, x + fx - 4, y + fy + 3);
                continue;
            }
            g.setColor(10912049);
            g.drawLine(x + fx, y + fy, x + fx + 4, y + fy + 2);
            g.setColor(12623445);
            g.drawLine(x + fx, y + fy + 1, x + fx + 4, y + fy + 3);
        }
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public int getMapGate(int tileX, int tileY, int direction) {
        block5: for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < this.map.getNumGates(); ++i) {
                int tx = this.map.getGate(i, 0);
                int ty = this.map.getGate(i, 1);
                if (tileX != tx || tileY != ty) continue;
                return i;
            }
            switch (direction) {
                case 0: {
                    --tileY;
                    continue block5;
                }
                case 2: {
                    ++tileY;
                    continue block5;
                }
                case 1: {
                    --tileX;
                    continue block5;
                }
                default: {
                    ++tileX;
                }
            }
        }
        return -1;
    }

    public void processPlayer(int offsetX, int offsetY) {
        int tileY;
        int tileX = this.getMapTileX(this.actors[0].x + offsetX * 3, this.actors[0].y + offsetY * 3);
        if (this.map.isTileInMap(tileX, tileY = this.getMapTileY(this.actors[0].x + offsetX * 3, this.actors[0].y + offsetY * 3)) && this.map.getWalkableTile(tileX, tileY)) {
            int height = this.map.getHeightMapTile(tileX, tileY);
            if (Math.abs(this.actors[0].height - height) <= 1) {
                this.actors[0].x += offsetX;
                this.actors[0].y += offsetY;
            } else {
                this.setOffsetX(0);
                this.setOffsetY(0);
                this.actors[0].stopped = true;
            }
        } else {
            this.setOffsetX(0);
            this.setOffsetY(0);
            this.actors[0].stopped = true;
        }
        this.playerGate = this.getMapGate(tileX, tileY, this.actors[0].direction);
    }

    public void processExtras() {
        if (this.exclamationOffsetY != -1) {
            this.exclamationOffsetY = (this.exclamationOffsetY << 1) / 3;
        }
    }

    public void processActors() {
        for (int i = 0; i < this.numActors; ++i) {
            this.actors[i].tileX = this.getMapTileX(this.actors[i].x, this.actors[i].y);
            this.actors[i].tileY = this.getMapTileY(this.actors[i].x, this.actors[i].y);
            this.actors[i].height = this.map.getHeightMapTile(this.actors[i].tileX, this.actors[i].tileY);
        }
    }

    public void processScroll() {
        this.cameraX += this.offsetX;
        this.cameraY += this.offsetY;
        this.rootInScreenX += this.offsetX;
        this.rootInScreenY += this.offsetY;
        if (this.cameraX > 0 || this.cameraX <= -this.map.getTileGapX() * 2) {
            if (this.offsetX > 0) {
                this.paintColumnBackbuffer(this.gbb, 1);
                this.cameraX = -(this.map.getTileGapX() * 2 - Math.abs(this.cameraX));
            } else if (this.offsetX < 0) {
                this.paintColumnBackbuffer(this.gbb, 0);
                this.cameraX %= this.map.getTileGapX() * 2;
            }
        }
        if (this.cameraY > 0 || this.cameraY <= -this.map.getTileGapY() * 2) {
            if (this.offsetY > 0) {
                this.paintRowBackbuffer(this.gbb, 1);
                this.cameraY = -(this.map.getTileGapY() * 2 - Math.abs(this.cameraY));
            } else if (this.offsetY < 0) {
                this.paintRowBackbuffer(this.gbb, 0);
                this.cameraY %= this.map.getTileGapY() * 2;
            }
        }
    }

    public boolean collision(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return x1 + width1 > x2 && y1 + height1 > y2 && x2 + width2 > x1 && y2 + height2 > y1;
    }

    public int getGateMap() {
        return this.map.getGate(this.playerGate, 4);
    }

    public int getPlayerGate() {
        return this.playerGate;
    }

    public int getGateMapTargetTileX() {
        return this.map.getGate(this.playerGate, 2);
    }

    public int getGateMapTargetTileY() {
        return this.map.getGate(this.playerGate, 3);
    }

    public Map getMap() {
        return this.map;
    }

    public int getNumActualMap() {
        return this.numActualMap;
    }

    static {
        SCREEN_WIDTH = 240;
        SCREEN_HEIGHT = 320;
    }
}

