/*
 * Decompiled with CFR 0.152.
 */
public class Cache {
    private Object[] cacheData;
    private String[] names;
    private int size;
    private int currMaxSize;
    private int curr_ID = -1;

    public Cache(int isize) {
        this.size = isize;
        this.cacheData = new Object[this.size];
        this.names = new String[this.size];
        this.currMaxSize = 0;
        this.curr_ID = -1;
    }

    public void addCache(Object o, String Name) {
        ++this.curr_ID;
        if (this.curr_ID >= this.size) {
            this.curr_ID = 0;
        }
        this.cacheData[this.curr_ID] = o;
        this.names[this.curr_ID] = Name;
        if (this.currMaxSize < this.size) {
            ++this.currMaxSize;
        }
    }

    public void clearCache() {
        for (int i = 0; i < this.currMaxSize; ++i) {
            this.cacheData[i] = null;
            this.names[i] = null;
        }
        this.currMaxSize = 0;
        this.curr_ID = -1;
        System.gc();
    }

    public Object getObject(String name) {
        for (int i = 0; i < this.currMaxSize; ++i) {
            if (!this.names[i].equals(name)) continue;
            return this.cacheData[i];
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }
}

