/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MovinMazeCanvas
extends Canvas
implements Constants {
    private static final int MAXACTIONS = 16;
    public static int screenwidth;
    public static int screenheight;
    private Image bg;
    private MovinMazeApp app;
    private Engine engine;
    public boolean[] pressed;
    public static Image titles;
    public static int PAGE;
    public static Image[] image;
    public static Image button;
    public static Image button_in;
    public static Image menu_bg;
    public static Image window;
    public static Image igname;
    public static Image win;
    public static Image loose;
    public static Image pause_arrow;
    public static Image jump_anim;
    public static Image lifelost;
    static int ref_val;
    static final int LINEGAP = 15;
    static int SWITCH_MUSIC;
    static int SWITCH_SFX;
    public static int animctr;
    int allign = 0;
    int clipval = 0;
    int jumpTo = 0;
    int imgW;
    int imgH;
    int counter = 0;
    int novalues = 0;
    int noofelements = 0;
    int appcursor = 0;
    int ctr1 = 0;
    int jmp_ctr = 0;
    static int bonus_anim;
    int arrow_move = 0;
    int arrow_move_counter = 0;
    static int intro_var;
    static int intro_var1;
    public static int index;
    static int intro_shown;
    int KEYCODE;
    public static final int NEED_TYPE_STRING_ARRAY = 0;
    public static final int NEED_TYPE_STRING_PLAIN = 1;
    public static final int NEED_TYPE_BYTE_ARRAY = 2;
    public String[] dataS = null;
    public String[] tutorS = null;
    public int[][] tutorSidx = null;
    int CMD_TYPE = -1;
    public static final int CMD_PAUSE = 0;
    public static final int CMD_SEL = 1;
    public static final int CMD_SEL_MEN = 2;
    public static final int CMD_YES_NO = 3;
    public static final int CMD_OK = 4;
    public static final int CMD_SAVE = 5;
    public static final int CMD_MENU = 6;
    public static final int CMD_OK_MENU = 7;
    public static final int CMD_NEXT_SKIP = 8;
    public static final int CMD_SEL_MENU = 9;
    public static final int CMD_SAVE_BACK = 10;
    public static final int CMD_SAVE_NEXT = 11;
    public static final int CMD_BACK = 12;
    public static final int CMD_CONTINUE = 13;
    public static final int RSK = 15;
    public static final int LSK = 14;
    public static final int ZERO = 0;
    String rsk = "";
    String lsk = "";
    static int scrollCounter;
    int anchor = 20;
    int startPos = 10;
    int gap = 5;
    int color = 0;
    public static int cursor;
    String[] parsedText = new String[4];
    public static char[] mapper;
    static final int[] characterSpacing;
    int xcorrection = 0;
    int ycorrection = 0;
    static int charw;
    static int charh;

    public MovinMazeCanvas(MovinMazeApp movinMazeApp, Engine engine) {
        this.setFullScreenMode(true);
        screenwidth = 128;
        screenheight = 160;
        this.app = movinMazeApp;
        this.engine = engine;
        try {
            titles = Image.createImage((String)"/iglogo.png");
            for (int i = 0; i < image.length; ++i) {
                MovinMazeCanvas.image[i] = Image.createImage((String)("/" + i + ".png"));
            }
            menu_bg = Image.createImage((String)"/menu.png");
            igname = Image.createImage((String)"/ig.png");
            button = Image.createImage((String)"/menu_button.png");
            button_in = Image.createImage((String)"/menu_button_in.png");
            jump_anim = Image.createImage((String)"/jump_froo.png");
            lifelost = Image.createImage((String)"/lifelost.png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.imgW = jump_anim.getWidth();
        this.imgH = jump_anim.getHeight();
        this.pressed = new boolean[17];
        this.reloadLanguage();
        MovinMazeCanvas.loadFontEngine();
    }

    public void reloadLanguage() {
        if (!MovinMazeApp.current_LANGUAGE_LOADED) {
            MovinMazeApp.current_LANGUAGE = 0;
        }
        this.dataS = (String[])MovinMazeCanvas.loadTxtResource("/MMaze" + Constants.LANG_CODES[MovinMazeApp.current_LANGUAGE] + ".txt", 0);
        this.loadTutorial("/MTutor" + Constants.LANG_CODES[MovinMazeApp.current_LANGUAGE] + ".txt");
        System.out.println("loaded language " + Constants.LANG_NAMES[MovinMazeApp.current_LANGUAGE]);
    }

    protected void showNotify() {
        this.releaseKeys();
        this.repaint();
    }

    protected void hideNotify() {
        if (PAGE == 31) {
            this.app.stopSound();
            this.app.sound.stopSounds();
            PAGE = 11;
        }
        this.releaseKeys();
    }

    void drawBackground(Graphics graphics) {
        graphics.setClip(0, 0, 128, 160);
        graphics.drawImage(menu_bg, 0, 0, 20);
        this.engine.interfaceimg(menu_bg, 0, 0, 64, 0, graphics);
        graphics.drawImage(igname, 6, 6, 20);
    }

    void doAnimation(Graphics graphics) {
        graphics.setClip(0, 0, screenwidth << 3, screenheight << 3);
        if (++animctr < 5) {
            graphics.drawImage(image[2], screenwidth >> 1, screenheight >> 1, 3);
        } else if (animctr < 10) {
            graphics.drawImage(image[1], screenwidth >> 1, screenheight >> 1, 3);
        } else if (animctr < 15) {
            graphics.drawImage(image[0], 0, 0, 20);
            this.engine.interfaceimg(image[0], 0, 0, 64, 0, graphics);
        }
    }

    void drawScoreboard(Graphics graphics) {
        graphics.setClip(0, 0, screenwidth, screenheight);
        graphics.setColor(0);
        this.drawString(graphics, this.extractText(31) + " " + (MovinMazeApp.LEVEL_DONE + 1) + " " + this.extractText(32) + "!", screenwidth >> 1, (screenheight >> 1) - 50, 17, 1);
        this.drawString(graphics, this.extractText(33), 4, (screenheight >> 1) - 30, 20, 0);
        this.drawString(graphics, ": " + MovinMazeApp.NO_OF_MOVES, screenwidth - 4, (screenheight >> 1) - 30, 24, 0);
        this.drawString(graphics, this.extractText(34), 4, (screenheight >> 1) - 20, 20, 0);
        this.drawString(graphics, ": " + MovinMazeApp.LEVEL_BONUS, screenwidth - 4, (screenheight >> 1) - 20, 24, 0);
        this.drawString(graphics, this.extractText(35), 4, (screenheight >> 1) - 10, 20, 0);
        this.drawString(graphics, ": " + MovinMazeApp.TIME_BONUS, screenwidth - 4, (screenheight >> 1) - 10, 24, 0);
        this.drawString(graphics, this.extractText(36), 4, screenheight >> 1, 20, 0);
        this.drawString(graphics, ": " + MovinMazeApp.SCORE, screenwidth - 4, screenheight >> 1, 24, 0);
        this.drawString(graphics, this.extractText(37), 4, (screenheight >> 1) + 15, 20, 0);
        this.drawString(graphics, ": " + MovinMazeApp.TOTAL_SCORE, screenwidth - 4, (screenheight >> 1) + 15, 24, 0);
    }

    void drawSelection(Graphics graphics, int n, int n2, int n3) {
        graphics.setClip(0, 0, screenwidth, screenheight);
        graphics.drawImage(button_in, this.allign + (screenwidth >> 1), -5 + ((screenheight >> 1) - (n3 - n2) * 15 / 2) - 7 + (n - n2) * 15 + 10, 17);
        int n4 = 0;
        n4 = n % 2 == 0 ? -60 : 37;
        graphics.setClip(n4 + (screenwidth >> 1) + 2, -5 + ((screenheight >> 1) - (n3 - n2) * 15 / 2) - 9 + (n - n2) * 15 + 10 + this.jumpTo, this.imgW / 3, this.imgH);
        graphics.drawImage(jump_anim, n4 + (screenwidth >> 1) + 2 - this.clipval, -5 + ((screenheight >> 1) - (n3 - n2) * 15 / 2) - 9 + (n - n2) * 15 + 10 + this.jumpTo, 20);
    }

    void drawPage(int n, int n2, Graphics graphics) {
        this.jmp_ctr += 3;
        if (this.jmp_ctr > 15) {
            this.jmp_ctr = 0;
            this.jumpTo = 0;
        }
        if (this.jmp_ctr < 5) {
            this.clipval = this.imgW / 3;
            this.jumpTo = -MovinMazeApp.CELL_WIDTH;
        } else if (this.jmp_ctr < 10) {
            this.clipval = 2 * (this.imgW / 3);
            this.jumpTo = 0;
        } else {
            this.clipval = 0;
            this.jumpTo = 0;
        }
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            n3 = n4;
            if (PAGE == 1) {
                if (n4 == 13) {
                    ++n4;
                    continue;
                }
                if (n4 > 13) {
                    n3 = n4 - 1;
                }
            }
            if (PAGE == 11) {
                if (n4 == 19) {
                    ++n4;
                    continue;
                }
                if (n4 > 19) {
                    n3 = n4 - 1;
                }
            }
            this.allign = n3 % 2 == 0 ? 10 : -10;
            graphics.drawImage(button, this.allign + (screenwidth >> 1), -5 + ((screenheight >> 1) - (n2 - n) * 15 / 2) - 8 + (n3 - n) * 15 + 10, 17);
            if (cursor == n3 - n) {
                this.drawSelection(graphics, n3, n, n2);
            }
            int n5 = this.allign + (screenwidth >> 1);
            int n6 = -4 + ((screenheight >> 1) - (n2 - n) * 15 / 2) - 10 + (n3 - n) * 15 + 10;
            if (n4 == 16) {
                this.drawString(graphics, Constants.LANG_NAMES[MovinMazeApp.current_LANGUAGE], n5, n6, 17, cursor == n3 - n ? 0 : 1);
                if (cursor == n3 - n) {
                    this.drawArrowH(graphics, n5 - 40, n6 + 3, true);
                    this.drawArrowH(graphics, n5 + 40 - 3, n6 + 3, false);
                }
            } else {
                this.drawString(graphics, this.extractText(n4) + (PAGE == 1 || PAGE == 11 ? (n3 == 13 || n3 == 19 ? (SWITCH_SFX == 1 ? " " + this.extractText(38) + " " : " " + this.extractText(39)) : "") : ""), n5, n6, 17, cursor == n3 - n ? 0 : 1);
            }
            graphics.setClip(0, 0, screenwidth, screenheight);
            ++n4;
        }
    }

    void drawSlots(Graphics graphics) {
        graphics.translate(0, -20);
        ++this.jmp_ctr;
        if (this.jmp_ctr > 15) {
            this.jmp_ctr = 0;
            this.jumpTo = 0;
        }
        if (this.jmp_ctr < 5) {
            this.clipval = this.imgW / 3;
            this.jumpTo = -MovinMazeApp.CELL_WIDTH;
        } else if (this.jmp_ctr < 10) {
            this.clipval = 2 * (this.imgW / 3);
            this.jumpTo = 0;
        } else {
            this.clipval = 0;
            this.jumpTo = 0;
        }
        int n = 0;
        int n2 = 2;
        for (int i = n; i <= n2; ++i) {
            this.allign = i % 2 == 0 ? 10 : -10;
            graphics.drawImage(button, this.allign + (screenwidth >> 1), -3 + ((screenheight >> 1) - (n2 - n) * 15 / 2) - 10 + (i - n) * 15 + 10, 17);
            if (cursor == i - n) {
                this.drawSelection(graphics, i, n, n2);
            }
            this.drawString(graphics, MovinMazeApp.slot[i], this.allign + (screenwidth >> 1) + 7, -3 + ((screenheight >> 1) - (n2 - n) * 15 / 2) - 10 + (i - n) * 15 + 10, 17, cursor == i - n ? 0 : 1);
            graphics.setClip(0, 0, screenwidth, screenheight);
        }
        this.drawString(graphics, this.extractText(40), screenwidth >> 1, (screenheight >> 1) + 30, 17, 1);
        if (this.app.hasrecordExists(this.app.lane)) {
            this.drawString(graphics, this.extractText(31) + " " + MovinMazeApp.LEVEL_DONE, screenwidth >> 1, (screenheight >> 1) + 40, 17, 0);
            this.drawString(graphics, this.extractText(37) + " " + MovinMazeApp.TOTAL_SCORE, screenwidth >> 1, (screenheight >> 1) + 50, 17, 0);
        } else {
            this.drawString(graphics, this.extractText(41), screenwidth >> 1, (screenheight >> 1) + 40, 17, 0);
        }
        graphics.translate(0, 30);
    }

    void drawButton(Graphics graphics) {
        if (MovinMazeApp.LEVEL_DONE >= MovinMazeApp.TUTORIAL_ONE && PAGE == 31) {
            if (this.rsk != "") {
                this.drawString(graphics, this.rsk, 119, screenheight - 38, 24, 0);
            }
            if (this.lsk != "") {
                this.drawString(graphics, this.lsk, 9, screenheight - 38, 20, 0);
            }
        } else {
            if (this.rsk != "") {
                this.drawString(graphics, this.rsk, 126, screenheight - charh - 2, 24, 0);
            }
            if (this.lsk != "") {
                this.drawString(graphics, this.lsk, 2, screenheight - charh - 2, 20, 0);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (PAGE >= 31) {
            this.engine.paint(graphics, 0, 0);
            this.drawString(graphics, "" + MovinMazeApp.BONUS, 22, screenheight - 12 - 6, 20, 1);
            this.drawString(graphics, "" + (3 - (MovinMazeApp.NO_OF_CHANCES - 1)), 57, screenheight - 12 - 6, 20, 1);
            this.drawString(graphics, "" + MovinMazeApp.TIMER, 89, screenheight - 12 - 6, 20, 1);
            if (MovinMazeApp.LEVEL_DONE >= MovinMazeApp.TUTORIAL_ONE) {
                this.drawString(graphics, this.extractText(57) + " " + (MovinMazeApp.LEVEL_DONE - 99), screenwidth >> 1, 5, 17, 0);
            } else {
                this.drawString(graphics, this.extractText(42) + " " + MovinMazeApp.NO_OF_MOVES, screenwidth >> 1, 5, 17, 0);
            }
            if (bonus_anim-- > 0) {
                this.drawString(graphics, "+" + ref_val, screenwidth >> 1, -100 + (screenheight >> 1) + 5 * bonus_anim, 20, 0);
            }
            if (MovinMazeApp.LEVEL_DONE >= MovinMazeApp.TUTORIAL_ONE && animctr < 1) {
                if (!MovinMazeApp.stop_display) {
                    if (MovinMazeApp.LEVEL_DONE == MovinMazeApp.TUTORIAL_TEN && index > 1) {
                        this.autoText(graphics, this.extractTutotialText(MovinMazeApp.LEVEL_DONE - 100, index), screenwidth - 20, 3, (screenheight >> 1) - 20 + 3, 17);
                    } else if (MovinMazeApp.LEVEL_DONE == MovinMazeApp.TUTORIAL_ONE) {
                        this.autoText(graphics, this.extractTutotialText(MovinMazeApp.LEVEL_DONE - 100, index), screenwidth - 20, 3, (screenheight >> 1) - 20 - 9, 17);
                    } else {
                        this.autoText(graphics, this.extractTutotialText(MovinMazeApp.LEVEL_DONE - 100, index), screenwidth - 20, 3, (screenheight >> 1) - 20 + 3, 17);
                    }
                }
                this.addCmd(8);
                this.drawButton(graphics);
            } else {
                graphics.drawImage(pause_arrow, screenwidth - 14, screenheight - 15, 20);
            }
            graphics.setClip(0, 0, screenwidth, screenheight);
            if (PAGE == 32) {
                graphics.setColor(0);
                graphics.fillRect(0, (screenheight >> 1) - intro_var1, screenwidth, intro_var);
                if (intro_var >= 50) {
                    ++intro_shown;
                    this.parseText(this.extractText(43) + " " + MovinMazeApp.level_best_moves[MovinMazeApp.LEVEL_DONE] + ", " + this.extractText(44), screenwidth - 8);
                    this.autoText2(graphics, screenwidth >> 1, (screenheight >> 1) - 20, 3);
                }
                return;
            }
            graphics.setClip(0, 0, screenwidth, screenheight);
            if (intro_var <= 50) {
                graphics.setColor(0);
                graphics.fillRect(0, (screenheight >> 1) - intro_var1, screenwidth, intro_var);
            }
            if (--animctr > 10) {
                graphics.drawImage(image[0], 0, 0, 20);
                this.engine.interfaceimg(image[0], 0, 0, 64, 0, graphics);
            } else if (animctr > 5) {
                graphics.drawImage(image[1], screenwidth >> 1, screenheight >> 1, 3);
            } else if (animctr > 0) {
                graphics.drawImage(image[2], screenwidth >> 1, screenheight >> 1, 3);
            }
            if (animctr == 0) {
                if (MovinMazeApp.LEVEL_DONE < MovinMazeApp.TUTORIAL_ONE) {
                    PAGE = 32;
                    intro_shown = 0;
                }
            }
            return;
        }
        switch (PAGE) {
            case -10: {
                graphics.setColor(0);
                graphics.setClip(0, 0, screenwidth, screenheight);
                graphics.fillRect(0, 0, screenwidth, screenheight);
                graphics.drawImage(titles, screenwidth >> 1, (screenheight >> 1) - 8, 3);
                graphics.setColor(255, 255, 255);
                graphics.drawRect(8, screenheight - 20 - 10, 111, 8);
                graphics.setColor(255, 0, 0);
                graphics.fillRect(9, screenheight - 19 - 10, MovinMazeApp.COUNTER * 10, 7);
                break;
            }
            case -9: {
                if (this.counter++ > 30) {
                    PAGE = 30;
                    this.counter = 0;
                    break;
                }
            }
            case -8: {
                break;
            }
            case 30: {
                graphics.setClip(0, 0, screenwidth, screenheight);
                this.drawBackground(graphics);
                this.drawString(graphics, Constants.LANG_NAMES[MovinMazeApp.current_LANGUAGE], screenwidth >> 1, (screenheight >> 1) - 20, 17, 1);
                this.drawArrowH(graphics, screenwidth / 4, (screenheight >> 1) - 18, true);
                this.drawArrowH(graphics, screenwidth - screenwidth / 4, (screenheight >> 1) - 18, false);
                this.addCmd(1);
                this.drawButton(graphics);
                break;
            }
            case 27: {
                graphics.setClip(0, 0, screenwidth, screenheight);
                graphics.drawImage(menu_bg, 0, 0, 20);
                this.engine.interfaceimg(menu_bg, 0, 0, 64, 0, graphics);
                graphics.drawImage(igname, 6, 6, 20);
                this.autoText(graphics, this.extractText(11), screenwidth, (screenheight - 90) / 15, (screenheight >> 1) - 25, 17);
                this.addCmd(3);
                this.drawButton(graphics);
                break;
            }
            case -7: {
                graphics.setClip(0, 0, screenwidth, screenheight);
                graphics.drawImage(menu_bg, 0, 0, 20);
                this.engine.interfaceimg(menu_bg, 0, 0, 64, 0, graphics);
                graphics.drawImage(igname, 6, 6, 20);
                graphics.drawImage(titles, screenwidth >> 1, screenheight >> 1, 3);
                this.addCmd(4);
                this.drawButton(graphics);
                break;
            }
            case 0: {
                this.drawBackground(graphics);
                this.drawPage(0, 5, graphics);
                this.addCmd(1);
                this.drawButton(graphics);
                break;
            }
            case 1: {
                this.drawBackground(graphics);
                this.drawString(graphics, this.extractText(3), screenwidth >> 1, 25, 17, 1);
                this.drawPage(13, 16, graphics);
                if (cursor == 3) {
                    this.addCmd(6);
                } else {
                    this.addCmd(9);
                }
                this.drawButton(graphics);
                break;
            }
            case 2: {
                this.drawBackground(graphics);
                this.drawString(graphics, this.extractText(1), screenwidth >> 1, 25, 17, 1);
                this.autoText(graphics, this.extractText(6), screenwidth, 5, (screenheight >> 1) - 45, 17);
                this.addCmd(6);
                this.drawButton(graphics);
                break;
            }
            case 3: {
                this.drawBackground(graphics);
                this.app.drawScore(graphics, -1);
                this.addCmd(6);
                this.drawButton(graphics);
                break;
            }
            case 4: {
                this.drawBackground(graphics);
                this.drawString(graphics, this.extractText(4), screenwidth >> 1, 25, 17, 1);
                this.drawPage(29, 30, graphics);
                this.addCmd(9);
                this.drawButton(graphics);
                break;
            }
            case 5: {
                break;
            }
            case -11: {
                this.drawBackground(graphics);
                this.drawString(graphics, this.extractText(29), screenwidth >> 1, 25, 17, 1);
                this.autoText(graphics, this.extractText(7), screenwidth, 5, (screenheight >> 1) - 45, 17);
                this.addCmd(12);
                this.drawButton(graphics);
                break;
            }
            case -12: {
                this.drawBackground(graphics);
                this.drawString(graphics, this.extractText(30), screenwidth >> 1, 25, 17, 1);
                this.autoText(graphics, this.extractText(28), screenwidth, 5, (screenheight >> 1) - 45, 17);
                this.addCmd(12);
                this.drawButton(graphics);
                break;
            }
            case 17: {
                this.doAnimation(graphics);
                if (animctr >= 10) {
                    if (MovinMazeApp.LEVEL_DONE < MovinMazeApp.TUTORIAL_ONE) {
                        this.drawScoreboard(graphics);
                    }
                }
                this.addCmd(11);
                this.drawButton(graphics);
                break;
            }
            case 21: {
                this.doAnimation(graphics);
                break;
            }
            case 19: {
                this.drawBackground(graphics);
                if (MovinMazeApp.current_LANGUAGE == 0) {
                    graphics.drawImage(loose, 0, screenheight >> 1, 6);
                } else {
                    this.drawString(graphics, this.extractText(55), screenwidth >> 1, screenheight >> 1, 17, 1);
                }
                this.drawString(graphics, this.extractText(36) + " " + MovinMazeApp.TOTAL_SCORE, screenwidth >> 1, (screenheight >> 1) + 33 + 10, 17, 1);
                this.addCmd(1);
                this.drawButton(graphics);
                break;
            }
            case 26: {
                this.drawBackground(graphics);
                if (MovinMazeApp.current_LANGUAGE == 0) {
                    graphics.drawImage(win, 0, screenheight >> 1, 6);
                } else {
                    this.drawString(graphics, this.extractText(56), screenwidth >> 1, screenheight >> 1, 17, 1);
                }
                this.drawString(graphics, this.extractText(36) + " " + MovinMazeApp.TOTAL_SCORE, screenwidth >> 1, (screenheight >> 1) + 30 + 13, 17, 1);
                this.addCmd(1);
                this.drawButton(graphics);
                break;
            }
            case -32: {
                this.drawBackground(graphics);
                this.drawString(graphics, this.extractText(31) + " 100 " + this.extractText(32) + "!", screenwidth >> 1, (screenheight >> 1) - 40, 17, 1);
                this.drawString(graphics, this.extractText(33), 4, (screenheight >> 1) - 30 + 2 + 10, 20, 0);
                this.drawString(graphics, ": " + MovinMazeApp.NO_OF_MOVES, screenwidth - 4, (screenheight >> 1) - 30 + 2 + 10, 24, 0);
                this.drawString(graphics, this.extractText(34), 4, (screenheight >> 1) - 20 + 2 + 10, 20, 0);
                this.drawString(graphics, ": " + MovinMazeApp.LEVEL_BONUS, screenwidth - 4, (screenheight >> 1) - 20 + 2 + 10, 24, 0);
                this.drawString(graphics, this.extractText(35), 4, (screenheight >> 1) - 10 + 2 + 10, 20, 0);
                this.drawString(graphics, ": " + MovinMazeApp.TIME_BONUS, screenwidth - 4, (screenheight >> 1) - 10 + 2 + 10, 24, 0);
                this.drawString(graphics, this.extractText(36), 4, (screenheight >> 1) + 2 + 10, 20, 0);
                this.drawString(graphics, ": " + MovinMazeApp.SCORE, screenwidth - 4, (screenheight >> 1) + 2 + 10, 24, 0);
                this.addCmd(1);
                this.drawButton(graphics);
                break;
            }
            case 32: {
                this.drawBackground(graphics);
                this.drawString(graphics, this.extractText(43), screenwidth >> 1, screenheight >> 1, 17, 0);
                this.drawString(graphics, "" + MovinMazeApp.level_best_moves[MovinMazeApp.LEVEL_DONE], screenwidth >> 1, (screenheight >> 1) + 10, 17, 0);
                this.addCmd(1);
                this.drawButton(graphics);
                break;
            }
            case 20: {
                this.doAnimation(graphics);
                break;
            }
            case 28: {
                this.drawBackground(graphics);
                this.autoText(graphics, this.extractText(12), screenwidth, (screenheight - 90) / 15, (screenheight >> 1) - 25, 17);
                this.addCmd(3);
                this.drawButton(graphics);
                break;
            }
            case 23: {
                this.drawBackground(graphics);
                this.app.addName(graphics);
                this.drawArrows(graphics);
                this.addCmd(10);
                this.drawButton(graphics);
                break;
            }
            case 18: {
                this.doAnimation(graphics);
                if (MovinMazeApp.current_LANGUAGE == 0) {
                    graphics.drawImage(lifelost, screenwidth >> 1, screenheight >> 1, 3);
                } else {
                    this.drawString(graphics, this.extractText(54), screenwidth >> 1, screenheight >> 1, 17, 1);
                }
                this.addCmd(7);
                this.drawButton(graphics);
                break;
            }
            case 15: {
                this.drawBackground(graphics);
                if (MovinMazeApp.loaded_data == 0) {
                    this.drawPage(24, 25, graphics);
                } else {
                    this.drawPage(25, 25, graphics);
                }
                this.addCmd(2);
                this.drawButton(graphics);
                break;
            }
            case 22: {
                this.drawBackground(graphics);
                this.drawSlots(graphics);
                graphics.translate(0, -10);
                this.addCmd(2);
                this.drawButton(graphics);
                graphics.translate(0, 10);
                break;
            }
            case 6: {
                this.drawBackground(graphics);
                this.drawString(graphics, this.extractText(8), screenwidth >> 1, (screenheight >> 1) - 6, 17, 1);
                this.addCmd(3);
                this.drawButton(graphics);
                break;
            }
            case 24: {
                this.drawBackground(graphics);
                this.drawString(graphics, this.extractText(8), screenwidth >> 1, (screenheight >> 1) - 6, 17, 1);
                this.addCmd(3);
                this.drawButton(graphics);
                break;
            }
            case 29: {
                this.drawBackground(graphics);
                this.drawString(graphics, this.extractText(8), screenwidth >> 1, (screenheight >> 1) - 6, 17, 1);
                this.addCmd(3);
                this.drawButton(graphics);
                break;
            }
            case 11: {
                this.drawBackground(graphics);
                this.drawPage(18, 21, graphics);
                this.addCmd(1);
                this.drawButton(graphics);
            }
        }
    }

    public void releaseKeys() {
        if (MovinMazeApp.LEVEL_DONE >= MovinMazeApp.TUTORIAL_ONE || PAGE != 31) {
            for (int i = 0; i < this.pressed.length; ++i) {
                this.pressed[i] = false;
            }
        }
    }

    private void setPressed(int n, boolean bl) {
        try {
            int n2 = 0;
            n2 = n == -6 ? 14 : (n == -7 ? 15 : this.getGameAction(n));
            if (MovinMazeApp.LEVEL_DONE >= MovinMazeApp.TUTORIAL_ONE && PAGE == 31) {
                this.pressed[n2] = n2 == 5 || n2 == 2 ? false : bl;
            } else if (n2 < 16) {
                this.pressed[n2] = bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void keyPressed(int n) {
        this.KEYCODE = n;
        if (PAGE == -10 || PAGE == -9) {
            return;
        }
        if (n == 49 || n == 51 || n == 35 || n == 42 || n == -10) {
            return;
        }
        if (n == 48 && PAGE == 31) {
            if (MovinMazeApp.BONUS > 0) {
                if (MovinMazeApp.LEVEL_DONE < MovinMazeApp.TUTORIAL_ONE) {
                    if (MovinMazeApp.SHOW_ANIM != 9 && intro_var <= 0 && animctr <= 0) {
                        if (MovinMazeApp.SHOW_ANIM != 10) {
                            MovinMazeApp.CHAR_MODE = MovinMazeApp.CHAR_MODE != 1 ? (byte)1 : 0;
                        }
                    }
                }
            }
        }
        this.setPressed(n, true);
    }

    protected void keyReleased(int n) {
        if (MovinMazeApp.LEVEL_DONE <= MovinMazeApp.TUTORIAL_ONE && PAGE == 31) {
            this.setPressed(n, false);
        }
        if (PAGE == -11 || PAGE == 2 || PAGE == -12) {
            this.setPressed(n, false);
        }
        if (PAGE == 32) {
            this.setPressed(n, false);
        }
    }

    protected void keyRepeated(int n) {
        if (PAGE == 31) {
            this.setPressed(n, true);
        }
    }

    public static Object loadTxtResource(String string, int n) {
        InputStream inputStream = MovinMazeApp.instance.getClass().getResourceAsStream(string);
        int n2 = 0;
        int n3 = 0;
        byte[][] byArrayArray = new byte[128][];
        do {
            try {
                byArrayArray[n3] = new byte[512];
                n2 = inputStream.read(byArrayArray[n3]);
                ++n3;
                if (n2 < 512) {
                    throw new Exception("last cycle");
                }
            }
            catch (Exception exception) {
                break;
            }
        } while (n2 > 0);
        byte[] byArray = new byte[512 * (n3 - 1) + n2];
        for (int i = 0; i < n3 - 1; ++i) {
            System.arraycopy(byArrayArray[i], 0, byArray, i * 512, 512);
        }
        System.arraycopy(byArrayArray[n3 - 1], 0, byArray, (n3 - 1) * 512, n2);
        if (n == 2) {
            return byArray;
        }
        String string2 = new String(byArray).trim();
        if (n == 1) {
            return string2;
        }
        n2 = string2.length();
        n3 = 1;
        for (int i = 0; i < n2; ++i) {
            if (string2.charAt(i) != '\n') continue;
            ++n3;
        }
        String[] stringArray = new String[n3];
        n3 = 0;
        while (string2.length() > 0) {
            n2 = string2.indexOf("\n");
            if (n2 >= 0) {
                stringArray[n3] = string2.substring(0, n2).trim();
                string2 = string2.substring(n2 + 1);
            } else {
                stringArray[n3] = string2.trim();
                string2 = "";
            }
            ++n3;
        }
        return stringArray;
    }

    public void loadTutorial(String string) {
        int n;
        this.tutorS = (String[])MovinMazeCanvas.loadTxtResource(string, 0);
        int n2 = 1;
        for (n = 0; n < this.tutorS.length; ++n) {
            if (this.tutorS[n].length() >= 1) continue;
            ++n2;
        }
        this.tutorSidx = new int[n2][];
        for (n = 0; n < this.tutorSidx.length; ++n) {
            this.tutorSidx[n] = new int[2];
        }
        int n3 = 0;
        n = 0;
        for (int i = 0; i < this.tutorS.length; ++i) {
            boolean bl;
            boolean bl2 = bl = this.tutorS[i].length() < 1;
            if (!bl) {
                if (n == 0) {
                    n = 1;
                    this.tutorSidx[n3][0] = i;
                    n2 = 1;
                } else {
                    ++n2;
                }
                if (i != this.tutorS.length - 1) continue;
                this.tutorSidx[n3][1] = n2;
                continue;
            }
            if (n == 0) continue;
            n = 0;
            this.tutorSidx[n3][1] = n2;
            ++n3;
        }
    }

    public String extractTutotialText(int n, int n2) {
        return this.tutorS[this.tutorSidx[n][0] + n2];
    }

    public String extractText(int n) {
        return this.dataS[n];
    }

    void addCmd(int n) {
        if (this.CMD_TYPE > -1) {
            this.rsk = "";
            this.lsk = "";
            this.removeAll();
        }
        if (n == 0) {
            this.rsk = "";
            this.lsk = this.extractText(45);
        } else if (n == 8) {
            this.rsk = this.extractText(47);
            this.lsk = this.extractText(46);
        } else if (n == 1) {
            this.rsk = this.extractText(48);
            this.lsk = "";
        } else if (n == 2) {
            this.rsk = this.extractText(48);
            this.lsk = this.extractText(17);
        } else if (n == 9) {
            this.rsk = this.extractText(48);
            this.lsk = this.extractText(49);
        } else if (n == 3) {
            this.lsk = this.extractText(10);
            this.rsk = this.extractText(9);
        } else if (n == 12) {
            this.lsk = this.extractText(17);
            this.rsk = "";
        } else if (n == 4) {
            this.rsk = this.extractText(50);
            this.lsk = "";
        } else if (n == 7) {
            this.lsk = "";
            this.rsk = this.extractText(50);
        } else if (n == 5) {
            this.rsk = "";
            this.lsk = this.extractText(51);
        } else if (n == 10) {
            this.rsk = this.extractText(51);
            this.lsk = "";
        } else if (n == 6) {
            this.rsk = "";
            this.lsk = this.extractText(49);
        } else if (n == 11) {
            this.lsk = this.extractText(51);
            this.rsk = this.extractText(47);
        } else if (n == 13) {
            this.lsk = "";
            this.rsk = this.extractText(52);
        }
        this.CMD_TYPE = (byte)n;
        String string = this.rsk;
        this.rsk = this.lsk;
        this.lsk = string;
    }

    void removeAll() {
        this.rsk = "";
        this.lsk = "";
    }

    public void autoText(Graphics graphics, String string, int n, int n2, int n3) {
        this.autoText(graphics, string, n, n2, n3, -1);
    }

    public void autoText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        this.gap = MovinMazeApp.LEVEL_DONE >= MovinMazeApp.TUTORIAL_ONE ? 11 : 15;
        int n8 = this.startPos + (MovinMazeApp.LEVEL_DONE >= MovinMazeApp.TUTORIAL_ONE ? 5 : 0);
        int n9 = -1;
        char[] cArray = string.toCharArray();
        int n10 = string.length();
        int[] nArray = new int[n10 * charw / (n += 50) + 50];
        int[] nArray2 = new int[nArray.length - 1];
        nArray[0] = -1;
        int n11 = 0;
        for (n7 = 0; n7 < n10; ++n7) {
            if (cArray[n7] != ' ' && cArray[n7] != '^') {
                n11 += charw + 1;
            }
            if (n7 != n10 - 1 && cArray[n7] != ' ' && cArray[n7] != '^') continue;
            if (n9 != -1 && nArray2[n9] + n11 + 8 <= n) {
                int n12 = n9;
                nArray2[n12] = nArray2[n12] + charw;
            }
            int n13 = ++n9;
            nArray2[n13] = nArray2[n13] + n11;
            nArray[n9 + 1] = n7 == n10 - 1 ? n7 + 1 : n7;
            n11 = 0;
            if (cArray[n7] != '^') continue;
            cArray[n7] = 32;
            ++n9;
        }
        cArray = null;
        StringBuffer stringBuffer = new StringBuffer(0);
        if (scrollCounter < 0) {
            scrollCounter = 0;
        }
        if (n9 >= n2) {
            if (scrollCounter >= n9 - n2) {
                scrollCounter = n9 - n2;
            }
        } else {
            scrollCounter = 0;
        }
        this.color = 0;
        this.anchor = 20;
        for (n7 = scrollCounter; n7 <= scrollCounter + n2; ++n7) {
            if (n4 == -1) {
                this.color = 1;
                this.anchor = 20;
                this.startPos = 6;
            }
            if (n4 == 17) {
                this.anchor = 17;
                this.startPos = screenwidth >> 1;
            }
            if (n4 == 20) {
                this.anchor = 20;
                this.startPos = 8;
            }
            if (n7 >= n9 + 1 || n7 <= -1) continue;
            stringBuffer.setLength(0);
            stringBuffer.insert(0, string.substring(nArray[n7] + 1, nArray[n7 + 1]));
            if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '~') {
                if (n4 == -1) {
                    stringBuffer = stringBuffer.deleteCharAt(0);
                    this.color = 0;
                    this.anchor = 17;
                    this.startPos = screenwidth >> 1;
                }
                if (n4 == 17) {
                    this.anchor = 17;
                    this.startPos = screenwidth >> 1;
                }
                if (n4 == 20) {
                    this.anchor = 20;
                    this.startPos = 6;
                }
            }
            if (PAGE == -12) {
                if (MovinMazeApp.current_LANGUAGE == 0 && (n7 == 0 || n7 == 2 || n7 == 4 || n7 == 5 || n7 == 7 || n7 == 9 || n7 == 11 || n7 == 13 || n7 == 15 || n7 == 17 || n7 == 21) || MovinMazeApp.current_LANGUAGE == 1 && (n7 == 0 || n7 == 2 || n7 == 4 || n7 == 5 || n7 == 7 || n7 == 8 || n7 == 10 || n7 == 12 || n7 == 14 || n7 == 16 || n7 == 18 || n7 == 22) || MovinMazeApp.current_LANGUAGE == 2 && (n7 == 0 || n7 == 2 || n7 == 3 || n7 == 5 || n7 == 6 || n7 == 7 || n7 == 9 || n7 == 10 || n7 == 12 || n7 == 14 || n7 == 15 || n7 == 17 || n7 == 19 || n7 == 21 || n7 == 25) || MovinMazeApp.current_LANGUAGE == 3 && (n7 == 0 || n7 == 1 || n7 == 3 || n7 == 5 || n7 == 6 || n7 == 8 || n7 == 9 || n7 == 11 || n7 == 13 || n7 == 14 || n7 == 16 || n7 == 18 || n7 == 20 || n7 == 24) || MovinMazeApp.current_LANGUAGE == 4 && (n7 == 0 || n7 == 1 || n7 == 3 || n7 == 5 || n7 == 6 || n7 == 8 || n7 == 9 || n7 == 11 || n7 == 13 || n7 == 15 || n7 == 17 || n7 == 18 || n7 == 20 || n7 == 24)) {
                    this.drawString(graphics, stringBuffer.toString(), this.startPos, n3 + (n7 - scrollCounter) * this.gap + 10, this.anchor, 1);
                    continue;
                }
                this.drawString(graphics, stringBuffer.toString(), this.startPos, n3 + (n7 - scrollCounter) * this.gap + 10, this.anchor, 0);
                continue;
            }
            this.drawString(graphics, stringBuffer.toString(), n8, n3 + (n7 - scrollCounter) * this.gap + 10, this.anchor, this.color);
        }
        if (PAGE >= 31) {
            graphics.setColor(0xFFFFFF);
            this.drawArrowsV(graphics, (screenwidth >> 1) - (MovinMazeApp.current_LANGUAGE == 1 ? 5 : 0), 125, scrollCounter > 0, scrollCounter < n9 - n2);
            return;
        }
        int n14 = this.getWidth() / 2;
        graphics.setColor(0xFFFFFF);
        graphics.setClip(0, 0, screenwidth, screenheight);
        if (scrollCounter < n9 - n2) {
            n6 = 60;
            n5 = 145;
            graphics.drawLine(n6, n5, n6 + 9, n5);
            graphics.drawLine(n6 + 1, n5 + 1, n6 + 1 + 7, n5 + 1);
            graphics.drawLine(n6 + 2, n5 + 2, n6 + 2 + 5, n5 + 2);
            graphics.drawLine(n6 + 3, n5 + 3, n6 + 3 + 3, n5 + 3);
            graphics.drawLine(n6 + 4, n5 + 4, n6 + 4 + 1, n5 + 4);
        }
        if (scrollCounter > 0) {
            n6 = 60;
            n5 = 139;
            graphics.drawLine(n6, n5 + 4, n6 + 9, n5 + 4);
            graphics.drawLine(n6 + 1, n5 + 3, n6 + 1 + 7, n5 + 3);
            graphics.drawLine(n6 + 2, n5 + 2, n6 + 2 + 5, n5 + 2);
            graphics.drawLine(n6 + 3, n5 + 1, n6 + 3 + 3, n5 + 1);
            graphics.drawLine(n6 + 4, n5, n6 + 4 + 1, n5);
        }
    }

    public void parseText(String string, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        String string2 = string;
        String string3 = " ";
        for (int i = 0; i < this.parsedText.length; ++i) {
            this.parsedText[i] = "";
        }
        try {
            int n6;
            string2 = string2.trim();
            int n7 = string2.length();
            for (n6 = 0; n6 < n7; ++n6) {
                if (string3.indexOf(string2.charAt(n6)) < 0) continue;
                ++n4;
            }
            String[] stringArray = new String[++n4];
            n4 = 0;
            while (string2.length() > 0) {
                n7 = string2.length();
                for (n6 = 0; n6 < n7; ++n6) {
                    int n8 = string3.indexOf(string2.charAt(n6));
                    if (n8 < 0) continue;
                    stringArray[n4++] = string2.substring(0, n8 != 0 && n6 < n7 - 1 ? n6 + 1 : n6);
                    string2 = string2.substring(n6 + 1);
                    break;
                }
                if (n6 != n7) continue;
                stringArray[n4++] = string2;
                string2 = "";
            }
            while (n5 < n4) {
                String string4;
                String string5 = "";
                while (n5 < n4 && this.getStringWidth(string4 = (string5 + (string5.length() > 0 && string3.indexOf(string5.charAt(string5.length() - 1)) > 0 ? "" : " ") + stringArray[n5]).trim(), 0) < n3 - 3) {
                    string5 = string4;
                    ++n5;
                }
                int n9 = this.getStringWidth(string5, 0);
                this.parsedText[n2] = string5;
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void autoText2(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.parsedText.length; ++n4) {
            if (this.parsedText[n4].length() >= 1) continue;
            n5 = n4;
            break;
        }
        if (n5 < n3) {
            n2 += (n3 - n5) * (charh + 3) / 2;
        }
        for (n4 = 0; n4 < this.parsedText.length && this.parsedText[n4].length() >= 1; ++n4) {
            this.drawString(graphics, this.parsedText[n4], n, n2 + n4 * (charh + 1), 17, 0);
        }
    }

    public void drawArrowH(Graphics graphics, int n, int n2, boolean bl) {
        if (!MovinMazeApp.blink) {
            return;
        }
        graphics.setColor(0xFFFFFF);
        graphics.setClip(0, 0, screenwidth, screenheight);
        if (!bl) {
            graphics.drawLine(n, n2, n, n2 + 7);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1 + 5);
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2 + 3);
            graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + 3 + 1);
        } else {
            graphics.drawLine(n += 3, n2, n, n2 + 7);
            graphics.drawLine(n - 1, n2 + 1, n - 1, n2 + 1 + 5);
            graphics.drawLine(n - 2, n2 + 2, n - 2, n2 + 2 + 3);
            graphics.drawLine(n - 3, n2 + 3, n - 3, n2 + 3 + 1);
        }
    }

    public void drawArrowsV(Graphics graphics, int n, int n2, boolean bl, boolean bl2) {
        graphics.setColor(0xFFFFFF);
        graphics.setClip(0, 0, screenwidth, screenheight);
        if (bl2) {
            graphics.drawLine(n, n2, n + 5, n2);
            graphics.drawLine(n + 1, n2 + 1, n + 1 + 3, n2 + 1);
            graphics.drawLine(n + 2, n2 + 2, n + 2 + 1, n2 + 2);
        }
        n2 -= 4;
        if (bl) {
            graphics.drawLine(n, n2 + 2, n + 5, n2 + 2);
            graphics.drawLine(n + 1, n2 + 1, n + 1 + 3, n2 + 1);
            graphics.drawLine(n + 2, n2, n + 2 + 1, n2);
        }
    }

    public static void loadFontEngine() {
        mapper = (" " + (String)MovinMazeCanvas.loadTxtResource("/codepage.txt", 1)).toCharArray();
        System.out.println("character mapper loaded : " + mapper.length + " bytes");
    }

    public static int map(char c) {
        for (int i = 0; i < mapper.length; ++i) {
            if (c != mapper[i]) continue;
            return i;
        }
        return 0;
    }

    int getCharWidth(char c, int n) {
        int n2 = MovinMazeCanvas.map(c);
        if ((PAGE == 1 || PAGE == 17) && n2 == 0) {
            return 3;
        }
        return characterSpacing[n2];
    }

    int getStringWidth(String string, int n) {
        int n2 = 0;
        char[] cArray = string.toUpperCase().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (n == 1) {
                n2 += this.getCharWidth(c, 0);
                continue;
            }
            n2 += this.getCharWidth(c, n);
        }
        return n2;
    }

    public final void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = n4 == 0 ? charh * 7 : 0;
        int n6 = this.getStringWidth(string, 0);
        int n7 = 0;
        if (n3 == 24) {
            n -= n6;
        } else if (n3 == 17) {
            n -= n6 / 2;
        }
        char[] cArray = string.toUpperCase().toCharArray();
        int n8 = 0;
        for (n7 = 0; n7 < string.length(); ++n7) {
            char c = cArray[n7];
            int n9 = MovinMazeCanvas.map(c);
            graphics.setClip(n + n8, n2, charw, charh);
            graphics.drawImage(this.app.gameFont, n + n8 - n9 % 13 * charw, n2 - n5 - n9 / 13 * charh, 20);
            graphics.setClip(0, 0, this.getWidth(), 160);
            n8 += this.getCharWidth(c, 0);
        }
    }

    public void drawArrows(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.setClip(0, 0, screenwidth, screenheight);
        int n = 58;
        int n2 = 110;
        graphics.drawLine(n, n2, n + 9, n2);
        graphics.drawLine(n + 1, n2 + 1, n + 1 + 7, n2 + 1);
        graphics.drawLine(n + 2, n2 + 2, n + 2 + 5, n2 + 2);
        graphics.drawLine(n + 3, n2 + 3, n + 3 + 3, n2 + 3);
        graphics.drawLine(n + 4, n2 + 4, n + 4 + 1, n2 + 4);
        n = 58;
        n2 = 104;
        graphics.drawLine(n, n2 + 4, n + 9, n2 + 4);
        graphics.drawLine(n + 1, n2 + 3, n + 1 + 7, n2 + 3);
        graphics.drawLine(n + 2, n2 + 2, n + 2 + 5, n2 + 2);
        graphics.drawLine(n + 3, n2 + 1, n + 3 + 3, n2 + 1);
        graphics.drawLine(n + 4, n2, n + 4 + 1, n2);
    }

    static {
        PAGE = -10;
        image = new Image[3];
        ref_val = 0;
        SWITCH_MUSIC = 0;
        SWITCH_SFX = 1;
        animctr = 15;
        bonus_anim = -1;
        intro_var = 2;
        intro_var1 = 2;
        index = 0;
        intro_shown = 0;
        scrollCounter = 0;
        cursor = 0;
        characterSpacing = new int[]{6, 3, 5, 9, 6, 6, 7, 3, 4, 4, 7, 5, 4, 5, 3, 7, 6, 4, 6, 6, 6, 6, 6, 6, 6, 6, 3, 3, 6, 5, 6, 6, 7, 6, 6, 6, 6, 6, 6, 6, 6, 5, 6, 6, 6, 7, 6, 6, 6, 6, 6, 6, 4, 6, 7, 7, 6, 6, 5, 4, 7, 4, 7, 4, 6, 6, 6, 6, 6, 5, 6, 6, 6, 6, 6, 6, 6, 6, 7, 3, 6, 6, 5, 6};
        charw = 9;
        charh = 11;
    }
}

