/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class ASprite {
    static int[] transform = new int[]{0, 2, 1, 3};
    int _nModules;
    byte[] _modules_type;
    int[] _modules_color;
    byte[] _modules_x;
    byte[] _modules_y;
    byte[] _modules_w;
    byte[] _modules_h;
    byte[] _frames_nfm;
    short[] _frames_fm_start;
    byte[] _frames_rc;
    short[] _fmodules;
    byte[] _anims_naf;
    short[] _anims_af_start;
    byte[] _aframes;
    static int[] _temp = new int[7168];
    int[][] _pal;
    int _palettes;
    int _crt_pal;
    boolean _alpha;
    short _data_format;
    int _i64rle_color_mask;
    int _i64rle_color_bits;
    byte[] _modules_data;
    short[] _modules_data_off;
    Image[][] _modules_image;
    boolean m_isDynamiCreateImage;
    int _id = -1;
    short[] _real_frames_rc;
    int[] m_palletesAlpha;
    int m_transpartColor = -1;
    public int m_crtAlpha = 255;
    int crtPool = -1;
    static int[] s_cachePoolStackIndex;
    static short[][] s_cachePoolStack;
    static int[] s_cachePoolStackMax;
    static int[][] s_cachePoolSprites;

    ASprite(int id) {
        this._id = id;
    }

    int loadPalette(byte[] file, int offset, int palCount, int clrCount, int iPalOff, int _pixel_format) {
        if (this._pal == null) {
            this._pal = new int[24][];
        }
        for (int p = 0; p < palCount; ++p) {
            int c2;
            int iPalIndex = iPalOff + p;
            this._pal[iPalIndex] = new int[clrCount];
            if (_pixel_format == 21781) {
                for (c2 = 0; c2 < clrCount; ++c2) {
                    int _1555 = file[offset++] & 0xFF;
                    int n = offset++;
                    int a2 = -16777216;
                    if (((_1555 += (file[n] & 0xFF) << 8) & 0x8000) != 32768) {
                        a2 = 0;
                        this._alpha = true;
                    }
                    this._pal[iPalIndex][c2] = a2 | (_1555 & 0x7C00) << 9 | (_1555 & 0x3E0) << 6 | (_1555 & 0x1F) << 3;
                }
                continue;
            }
            if (_pixel_format == -30584) {
                for (c2 = 0; c2 < clrCount; ++c2) {
                    int _8888 = file[offset++] & 0xFF;
                    _8888 += (file[offset++] & 0xFF) << 8;
                    _8888 += (file[offset++] & 0xFF) << 16;
                    if (((_8888 += (file[offset++] & 0xFF) << 24) & 0xFF000000) != -16777216) {
                        this._alpha = true;
                    }
                    this._pal[iPalIndex][c2] = _8888;
                }
                continue;
            }
            if (_pixel_format == 17476) {
                // empty if block
            }
            if (_pixel_format != 25861) continue;
        }
        return offset;
    }

    void load(byte[] file, int offset, int mStart, int mEnd) {
        try {
            int colors;
            int nAnims;
            int nAFrames;
            int nFrames;
            int nFModules;
            Game.CALL_GC();
            short bs_version = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
            int bs_flags = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8) + ((file[offset++] & 0xFF) << 16) + ((file[offset++] & 0xFF) << 24);
            this._nModules = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8);
            if (mEnd == -1) {
                mEnd = this._nModules - 1;
            }
            if (this._nModules > 0) {
                if ((bs_flags & 2) != 0) {
                    this._modules_x = new byte[this._nModules];
                    this._modules_y = new byte[this._nModules];
                }
                this._modules_w = new byte[this._nModules];
                this._modules_h = new byte[this._nModules];
                for (int i2 = 0; i2 < this._nModules; ++i2) {
                    if ((bs_flags & 4) == 4) {
                        if (file[offset] == -2) {
                            if (this._modules_type == null) {
                                this._modules_type = new byte[this._nModules];
                            }
                            if (this._modules_color == null) {
                                this._modules_color = new int[this._nModules];
                            }
                            this._modules_type[i2] = file[offset++];
                            this._modules_color[i2] = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8) + ((file[offset++] & 0xFF) << 16) + ((file[offset++] & 0xFF) << 24);
                        } else {
                            ++offset;
                        }
                    }
                    if ((bs_flags & 2) != 0) {
                        this._modules_x[i2] = file[offset++];
                        this._modules_y[i2] = file[offset++];
                    }
                    this._modules_w[i2] = file[offset++];
                    if (this._modules_w[i2] == -1) {
                        offset += 6;
                        continue;
                    }
                    this._modules_h[i2] = file[offset++];
                }
            }
            if ((nFModules = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._fmodules = new short[nFModules << 2];
                for (int i3 = 0; i3 < nFModules << 2; i3 += 4) {
                    this._fmodules[i3] = (short)(file[offset++] & 0xFF);
                    this._fmodules[i3 + 1] = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
                    this._fmodules[i3 + 2] = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
                    this._fmodules[i3 + 3] = file[offset++];
                }
            }
            if ((nFrames = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._frames_nfm = new byte[nFrames];
                this._frames_fm_start = new short[nFrames];
                for (int i4 = 0; i4 < nFrames; ++i4) {
                    this._frames_nfm[i4] = file[offset++];
                    int n = ++offset;
                    int n2 = ++offset;
                    ++offset;
                    this._frames_fm_start[i4] = (short)((file[n] & 0xFF) + ((file[n2] & 0xFF) << 8));
                    this.precomputeFrameRect(i4);
                }
                int nFrames4 = nFrames << 2;
                this._frames_rc = new byte[nFrames4];
                for (int i5 = 0; i5 < nFrames4; ++i5) {
                    this._frames_rc[i5] = file[offset++];
                }
            }
            if ((nAFrames = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._aframes = new byte[nAFrames * 5];
                System.arraycopy(file, offset, this._aframes, 0, this._aframes.length);
                offset += this._aframes.length;
            }
            if ((nAnims = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._anims_naf = new byte[nAnims];
                this._anims_af_start = new short[nAnims];
                for (int i6 = 0; i6 < nAnims; ++i6) {
                    this._anims_naf[i6] = file[offset++];
                    int n = ++offset;
                    int n3 = ++offset;
                    ++offset;
                    this._anims_af_start[i6] = (short)((file[n] & 0xFF) + ((file[n3] & 0xFF) << 8));
                }
            }
            if (this._nModules <= 0) {
                Game.CALL_GC();
                return;
            }
            if ((bs_flags & 0x1000000) == 0) {
                return;
            }
            short _pixel_format = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
            int iImgCount = 1;
            if ((bs_flags & 0x40000000) != 0) {
                iImgCount = file[offset++] & 0xFF;
            }
            this._palettes = file[offset++] & 0xFF;
            if ((colors = file[offset++] & 0xFF) == 0) {
                colors = 256;
            }
            offset = this.loadPalette(file, offset, this._palettes, colors, 0, _pixel_format);
            if (iImgCount > 1) {
                int iAlphaPalCount = file[offset++] & 0xFF;
                int iAlphaColors = file[offset++] & 0xFF;
                if (colors == 0) {
                    colors = 256;
                }
                offset = this.loadPalette(file, offset, iAlphaPalCount, iAlphaColors, this._palettes, _pixel_format);
            }
            this._data_format = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
            if (this._data_format == 25840) {
                int clrs = colors - 1;
                this._i64rle_color_mask = 1;
                this._i64rle_color_bits = 0;
                while (clrs != 0) {
                    clrs >>= 1;
                    this._i64rle_color_mask <<= 1;
                    ++this._i64rle_color_bits;
                }
                --this._i64rle_color_mask;
            }
            if (this._nModules > 0) {
                int size;
                this._modules_data_off = new short[this._nModules];
                int len = 0;
                int off = offset;
                int m = 0;
                while (m < mStart) {
                    size = (file[off] & 0xFF) + ((file[off + 1] & 0xFF) << 8);
                    off += 2;
                    off += size;
                    this._modules_data_off[m++] = -1;
                }
                while (m <= mEnd) {
                    size = (file[off] & 0xFF) + ((file[off + 1] & 0xFF) << 8);
                    off += 2;
                    this._modules_data_off[m++] = (short)len;
                    off += size;
                    len += size;
                }
                while (m < this._nModules) {
                    this._modules_data_off[m++] = -1;
                }
                this._modules_data = new byte[len];
                for (m = 0; m < this._nModules; ++m) {
                    size = (file[offset] & 0xFF) + ((file[offset + 1] & 0xFF) << 8);
                    offset += 2;
                    if (this._modules_data_off[m] != -1) {
                        System.arraycopy(file, offset, this._modules_data, this._modules_data_off[m] & 0xFFFF, size);
                    }
                    offset += size;
                }
            }
            Game.CALL_GC();
        }
        catch (Exception e2) {
            // empty catch block
        }
    }

    void buildCacheImages(int pal, int m1, int m2, int pal_copy) {
        if (this._nModules == 0) {
            return;
        }
        if (m2 == -1) {
            m2 = this._nModules - 1;
        }
        if (this._modules_image == null) {
            this._modules_image = new Image[this._palettes][];
        }
        if (this._modules_image[pal] == null) {
            this._modules_image[pal] = new Image[this._nModules];
        }
        if (pal_copy >= 0) {
            for (int i2 = m1; i2 <= m2; ++i2) {
                this._modules_image[pal][i2] = this._modules_image[pal_copy][i2];
            }
        } else {
            int old_pal = this._crt_pal;
            this._crt_pal = pal;
            Game.CALL_GC();
            for (int i3 = m1; i3 <= m2; ++i3) {
                int[] image_data;
                if (this._modules_w[i3] == -1 || this._modules_type != null && this._modules_type[i3] == -2) continue;
                int sizeX = this._modules_w[i3] & 0xFF;
                int sizeY = this._modules_h[i3] & 0xFF;
                if (sizeX == 0 || sizeY == 0 || (image_data = this.decodeImage(i3, 0, false)) == null) continue;
                boolean bAlpha = false;
                int size = sizeX * sizeY;
                for (int ii = 0; ii < size; ++ii) {
                    if ((image_data[ii] & 0xFF000000) == -16777216) continue;
                    bAlpha = true;
                    break;
                }
                this._modules_image[pal][i3] = Image.createRGBImage((int[])image_data, (int)sizeX, (int)sizeY, (boolean)bAlpha);
                image_data = null;
            }
            Game.CALL_GC();
            this._crt_pal = old_pal;
        }
        Game.CALL_GC();
    }

    void freeData(boolean bRemainPalette) {
        this._modules_data = null;
        if (!bRemainPalette) {
            this._pal = null;
        }
        this._modules_data_off = null;
        Game.CALL_GC();
    }

    int getFrameWidth(int frame) {
        return this._frames_rc[frame * 4 + 2] & 0xFF;
    }

    int getFrameModuleX(int frame, int fmodule) {
        int off = this._frames_fm_start[frame] + fmodule << 2;
        return this._fmodules[off + 1];
    }

    int getFrameModuleY(int frame, int fmodule) {
        int off = this._frames_fm_start[frame] + fmodule << 2;
        return this._fmodules[off + 2];
    }

    int getFrameModuleWidth(int frame, int fmodule) {
        int off = this._frames_fm_start[frame] + fmodule << 2;
        int index = this._fmodules[off] & 0xFF;
        int fm_flags = this._fmodules[off + 3] & 0xFF;
        if ((fm_flags & 0x10) != 0) {
            return 0;
        }
        return this._modules_w[index] & 0xFF;
    }

    int getFrameModuleHeight(int frame, int fmodule) {
        int off = this._frames_fm_start[frame] + fmodule << 2;
        int index = this._fmodules[off] & 0xFF;
        int fm_flags = this._fmodules[off + 3] & 0xFF;
        if ((fm_flags & 0x10) != 0) {
            return 0;
        }
        return this._modules_h[index] & 0xFF;
    }

    int GetActionTime(int anim) {
        int time = 0;
        for (int aframe = 0; aframe < (this._anims_naf[anim] & 0xFF); ++aframe) {
            time += this.GetAFrameTime(anim, aframe);
        }
        return time;
    }

    int GetAFrameTime(int anim, int aframe) {
        return this._aframes[(this._anims_af_start[anim] + aframe) * 5 + 1] & 0xFF;
    }

    int GetAFrameID(int anim, int time) {
        int aframe;
        int time_count = 0;
        for (aframe = 0; aframe < (this._anims_naf[anim] & 0xFF) && (time < time_count || time >= time_count + this.GetAFrameTime(anim, aframe)); time_count += this.GetAFrameTime(anim, aframe), ++aframe) {
        }
        return aframe;
    }

    int GetAFrames(int anim) {
        return this._anims_naf[anim] & 0xFF;
    }

    void precomputeFrameRect(int iFrameId) {
        if (this._real_frames_rc == null) {
            int nFrames4 = this._frames_nfm.length << 2;
            this._real_frames_rc = new short[nFrames4];
        }
        int[] rc = new int[4];
        int nFModules = this._frames_nfm[iFrameId] & 0xFF;
        if (nFModules <= 0) {
            return;
        }
        this.getFModuleRect(rc, iFrameId, 0, 0, 0, 0);
        int fx = rc[0];
        int fy = rc[1];
        int fw = rc[2] - rc[0];
        int fh = rc[3] - rc[1];
        for (int fmodule = 1; fmodule < nFModules; ++fmodule) {
            this.getFModuleRect(rc, iFrameId, fmodule, 0, 0, 0);
            if (rc[0] < fx) {
                fw += fx - rc[0];
                fx = rc[0];
            }
            if (rc[1] < fy) {
                fh += fy - rc[1];
                fy = rc[1];
            }
            if (rc[2] > fx + fw) {
                fw = rc[2] - fx;
            }
            if (rc[3] <= fy + fh) continue;
            fh = rc[3] - fy;
        }
        int posX = fx;
        int posY = fy;
        rc[0] = posX;
        rc[1] = posY;
        rc[2] = fw;
        rc[3] = fh;
        int iOff = iFrameId * 4;
        this._real_frames_rc[iOff + 0] = (short)rc[0];
        this._real_frames_rc[iOff + 1] = (short)rc[1];
        this._real_frames_rc[iOff + 2] = (short)rc[2];
        this._real_frames_rc[iOff + 3] = (short)rc[3];
    }

    void getFModuleRect(int[] rc, int frame, int fmodule, int posX, int posY, int flags) {
        rc[0] = this.getFrameModuleX(frame, fmodule);
        rc[1] = this.getFrameModuleY(frame, fmodule);
        rc[2] = rc[0] + this.getFrameModuleWidth(frame, fmodule);
        rc[3] = rc[1] + this.getFrameModuleHeight(frame, fmodule);
    }

    void paintAFrame(Graphics g2, int anim, int aframe, int posX, int posY, int flags) {
        int off = (this._anims_af_start[anim] + aframe) * 5;
        int frame = this._aframes[off] & 0xFF;
        byte iXOff = this._aframes[off + 2];
        byte iYOff = this._aframes[off + 3];
        posX = (flags & 1) != 0 ? (posX -= iXOff) : (posX += iXOff);
        posY = (flags & 2) != 0 ? (posY -= iYOff) : (posY += iYOff);
        this.paintFrame(g2, frame, posX, posY, flags ^ this._aframes[off + 4] & 0xF);
    }

    void paintFrame(Graphics g2, int frame, int posX, int posY, int flags) {
        int nFModules = this._frames_nfm[frame] & 0xFF;
        for (int fmodule = 0; fmodule < nFModules; ++fmodule) {
            this.paintFModule(g2, frame, fmodule, posX, posY, flags);
        }
    }

    void paintFModule(Graphics g2, int frame, int fmodule, int posX, int posY, int flags) {
        int off = this._frames_fm_start[frame] + fmodule << 2;
        int fm_flags = this._fmodules[off + 3] & 0xFF;
        int index = this._fmodules[off] & 0xFF;
        if ((fm_flags & 0x10) != 0) {
            this.paintFrame(g2, index, posX += this._fmodules[off + 1], posY += this._fmodules[off + 2], flags ^ fm_flags & 0xF);
        } else {
            posX = (flags & 1) != 0 ? (posX -= (this._modules_w[index] & 0xFF) + this._fmodules[off + 1]) : (posX += this._fmodules[off + 1]);
            posY = (flags & 2) != 0 ? (posY -= (this._modules_h[index] & 0xFF) + this._fmodules[off + 2]) : (posY += this._fmodules[off + 2]);
            int iFlag = flags ^ fm_flags & 0xF;
            this.paintModule(g2, index, posX, posY, iFlag);
        }
    }

    public void setAlpha(int iAlpha) {
        this.m_crtAlpha = iAlpha % 256;
    }

    public void setPaletteAlpha(int iPalette, int iAlpha) {
        int iCount;
        int[] pal;
        if (this.m_palletesAlpha == null) {
            this.m_palletesAlpha = new int[this._palettes];
            for (int i2 = 0; i2 < this._palettes; ++i2) {
                this.m_palletesAlpha[i2] = 255;
            }
            pal = this._pal[0];
            iCount = pal.length;
            for (int i3 = 0; i3 < iCount; ++i3) {
                if ((pal[i3] & 0xFF000000) != 0) continue;
                this.m_transpartColor = i3;
                pal[i3] = 0;
            }
            if (this.m_transpartColor == -1) {
                this.m_transpartColor = 0;
            }
        }
        if (this.m_palletesAlpha[iPalette] == this.m_crtAlpha) {
            return;
        }
        this.m_palletesAlpha[iPalette] = this.m_crtAlpha;
        pal = this._pal[iPalette];
        iCount = pal.length;
        int iShiftAlpha = iAlpha << 24;
        for (int i4 = 0; i4 < iCount; ++i4) {
            if (this.m_transpartColor == i4) continue;
            pal[i4] = pal[i4] & 0xFFFFFF | iShiftAlpha;
        }
    }

    void paintModule(Graphics g2, int module, int posX, int posY, int flags) {
        int sizeX = this._modules_w[module] & 0xFF;
        int sizeY = this._modules_h[module] & 0xFF;
        if (sizeX == 255) {
            return;
        }
        if (this._modules_type != null && this._modules_type[module] == -2) {
            g2.setColor(this._modules_color[module]);
            g2.fillRect(posX, posY, sizeX, sizeY);
            return;
        }
        Image img = null;
        if (this._modules_image != null && this._modules_image[this._crt_pal] != null) {
            img = this._modules_image[this._crt_pal][module];
        }
        if (img == null) {
            int[] image_data = null;
            this.setPaletteAlpha(this._crt_pal, 255);
            if (image_data == null) {
                image_data = this.decodeImage(module, 0, false);
            }
            if (image_data == null) {
                return;
            }
            img = Image.createRGBImage((int[])image_data, (int)sizeX, (int)sizeY, (boolean)this._alpha);
            if (img == null) {
                return;
            }
        }
        this.UpdateCachePool(module, img);
        if (flags >= transform.length) {
            flags = 0;
        }
        if (Game.isRectTouchCamera(g2, posX, posY, sizeX, sizeY)) {
            g2.drawRegion(img, 0, 0, sizeX, sizeY, transform[flags], posX, posY, 0);
        }
    }

    int[] decodeImage(int module, int offset, boolean bUseNewArray) {
        int[] img_data;
        block14: {
            int ds;
            int di;
            int si;
            byte[] image;
            int[] pal;
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block13: {
                                if (this._modules_data == null || this._modules_data_off == null) {
                                    return null;
                                }
                                if (this._modules_type != null && this._modules_type[module] == -2) {
                                    return null;
                                }
                                int sizeX = this._modules_w[module] & 0xFF;
                                int sizeY = this._modules_h[module] & 0xFF;
                                img_data = null;
                                img_data = bUseNewArray ? new int[sizeX * sizeY] : _temp;
                                pal = this._pal[this._crt_pal];
                                if (pal == null) {
                                    return null;
                                }
                                image = this._modules_data;
                                si = this._modules_data_off[module] & 0xFFFF;
                                di = offset;
                                ds = di + sizeX * sizeY;
                                if (this._data_format != 25840) break block13;
                                while (di < ds) {
                                    int c2 = image[si++] & 0xFF;
                                    int clr = pal[c2 & this._i64rle_color_mask];
                                    c2 >>= this._i64rle_color_bits;
                                    while (c2-- >= 0) {
                                        img_data[di++] = clr;
                                    }
                                }
                                break block14;
                            }
                            if (this._data_format != 10225) break block15;
                            while (di < ds) {
                                int c3;
                                if ((c3 = image[si++] & 0xFF) > 127) {
                                    int c2 = image[si++] & 0xFF;
                                    int clr = pal[c2];
                                    c3 -= 128;
                                    while (c3-- > 0) {
                                        img_data[di++] = clr;
                                    }
                                    continue;
                                }
                                img_data[di++] = pal[c3];
                            }
                            break block14;
                        }
                        if (this._data_format == 22258) {
                            // empty if block
                        }
                        if (this._data_format != 5632) break block16;
                        while (di < ds) {
                            img_data[di++] = pal[image[si] >> 4 & 0xF];
                            img_data[di++] = pal[image[si] & 0xF];
                            ++si;
                        }
                        break block14;
                    }
                    if (this._data_format != 1024) break block17;
                    while (di < ds) {
                        img_data[di++] = pal[image[si] >> 6 & 3];
                        img_data[di++] = pal[image[si] >> 4 & 3];
                        img_data[di++] = pal[image[si] >> 2 & 3];
                        img_data[di++] = pal[image[si] & 3];
                        ++si;
                    }
                    break block14;
                }
                if (this._data_format != 512) break block18;
                while (di < ds) {
                    img_data[di++] = pal[image[si] >> 7 & 1];
                    img_data[di++] = pal[image[si] >> 6 & 1];
                    img_data[di++] = pal[image[si] >> 5 & 1];
                    img_data[di++] = pal[image[si] >> 4 & 1];
                    img_data[di++] = pal[image[si] >> 3 & 1];
                    img_data[di++] = pal[image[si] >> 2 & 1];
                    img_data[di++] = pal[image[si] >> 1 & 1];
                    img_data[di++] = pal[image[si] & 1];
                    ++si;
                }
                break block14;
            }
            if (this._data_format != 22018) break block14;
            while (di < ds) {
                img_data[di++] = pal[image[si++] & 0xFF];
            }
        }
        return img_data;
    }

    void setCurrentPalette(int pal) {
        if (pal >= this._palettes) {
            pal = 0;
        }
        if (this.m_isDynamiCreateImage) {
            if (this._modules_image == null) {
                this._modules_image = new Image[this._palettes][];
            }
            if (this._crt_pal != pal || this._modules_image[pal] == null) {
                this._modules_image[this._crt_pal] = null;
                this.buildCacheImages(pal, 0, -1, -1);
            }
        }
        this._crt_pal = pal;
    }

    static void DRAW_LINE(Graphics g2, int x1, int y1, int x2, int y2) {
        g2.drawLine(x1, y1, x2, y2);
    }

    static void SET_COLOR(Graphics g2, int color) {
        g2.setColor(color);
    }

    static void FILL_RECT(Graphics g2, int x, int y, int width, int height) {
        g2.fillRect(x, y, width, height);
    }

    static void DRAW_RECT(Graphics g2, int x, int y, int width, int height) {
        g2.drawRect(x, y, width, height);
    }

    static void DRAW_ROUND_RECT(Graphics g2, int x, int y, int width, int height, int rx, int ry) {
        g2.drawRoundRect(x, y, width, height, rx, ry);
    }

    static void FILL_ROUND_RECT(Graphics g2, int x, int y, int width, int height, int rx, int ry) {
        g2.fillRoundRect(x, y, width, height, rx, ry);
    }

    static void SET_CLIP(Graphics g2, int x, int y, int width, int height) {
        g2.setClip(x, y, width, height);
    }

    public static void InitCachePool(int count) {
        s_cachePoolStackIndex = new int[count];
        s_cachePoolStack = new short[count][];
        s_cachePoolStackMax = new int[count];
        s_cachePoolSprites = new int[count][];
    }

    public static void InitCachePoolSize(int pID, int size) {
        ASprite.s_cachePoolStack[pID] = new short[size];
        ASprite.s_cachePoolStackMax[pID] = size;
        ASprite.s_cachePoolSprites[pID] = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            ASprite.s_cachePoolStack[pID][i2] = -1;
            ASprite.s_cachePoolSprites[pID][i2] = -1;
        }
    }

    public static void ResetCachePool(int pID) {
        for (int i2 = 0; i2 < s_cachePoolStackMax[pID]; ++i2) {
            if (s_cachePoolSprites[pID][i2] >= 0 && Game.s_sprites[s_cachePoolSprites[pID][i2]] != null) {
                for (int idx = 0; idx < Game.s_sprites[ASprite.s_cachePoolSprites[pID][i2]]._modules_image.length; ++idx) {
                    for (int img = 0; img < Game.s_sprites[ASprite.s_cachePoolSprites[pID][i2]]._modules_image[idx].length; ++img) {
                        Game.s_sprites[ASprite.s_cachePoolSprites[pID][i2]]._modules_image[idx][img] = null;
                    }
                }
            }
            ASprite.s_cachePoolSprites[pID][i2] = -1;
            ASprite.s_cachePoolStack[pID][i2] = -1;
        }
        ASprite.s_cachePoolStackIndex[pID] = 0;
    }

    public void setPool(int pID) {
        this.crtPool = pID;
        if (this._modules_image == null) {
            this._modules_image = new Image[this._palettes][];
        }
        for (int i2 = 0; i2 < this._modules_image.length; ++i2) {
            if (this._modules_image[i2] != null) continue;
            this._modules_image[i2] = new Image[this._nModules];
        }
    }

    public void UpdateCachePool(int moduleID, Image img) {
        if (this.crtPool >= 0) {
            int sprID;
            if (this._modules_image[this._crt_pal][moduleID] != null) {
                return;
            }
            int crtIdx = s_cachePoolStackIndex[this.crtPool];
            int moduleIdx = s_cachePoolStack[this.crtPool][crtIdx] & 0xFFF;
            int modulePal = (s_cachePoolStack[this.crtPool][crtIdx] & 0xF000) >> 12;
            if (moduleIdx >= 0 && (sprID = s_cachePoolSprites[this.crtPool][crtIdx]) >= 0 && Game.s_sprites[sprID] != null) {
                Game.s_sprites[sprID]._modules_image[modulePal][moduleIdx] = null;
            }
            moduleIdx = moduleID & 0xFFFF | (this._crt_pal & 0xF) << 12;
            ASprite.s_cachePoolStack[this.crtPool][crtIdx] = (short)moduleIdx;
            ASprite.s_cachePoolSprites[this.crtPool][crtIdx] = this._id;
            this._modules_image[this._crt_pal][moduleID] = img;
            ASprite.s_cachePoolStackIndex[this.crtPool] = (s_cachePoolStackIndex[this.crtPool] + 1) % s_cachePoolStackMax[this.crtPool];
        }
    }
}

