/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class ActorPool {
    public Vector m_actorPool;
    public Vector m_actorsInUsing;
    public int m_actorType;
    public int m_actorMaxCount;
    public int m_freeType;

    public ActorPool(int iType, int iCount, int iFreeType) {
        this.m_actorType = iType;
        this.m_actorMaxCount = iCount;
        this.m_freeType = iFreeType;
        this.initActorPool();
    }

    private void initActorPool() {
        this.m_actorPool = new Vector(this.m_actorMaxCount);
        this.m_actorsInUsing = new Vector(this.m_actorMaxCount);
        int i2 = 0;
        while (i2 < this.m_actorMaxCount) {
            Actor aActor = new Actor();
            aActor.m_idInPool = i2++;
            this.m_actorPool.addElement(aActor);
        }
    }

    public void freeActorPool() {
        this.m_actorPool.removeAllElements();
        this.m_actorsInUsing.removeAllElements();
        this.m_actorPool = null;
        this.m_actorsInUsing = null;
    }

    public Actor newActor(int param1, int param2, int param3, int param4) {
        Actor aActor = (Actor)this.m_actorPool.elementAt(0);
        this.m_actorPool.removeElementAt(0);
        this.m_actorsInUsing.addElement(aActor);
        aActor.resetActor();
        aActor.m_type = this.m_actorType;
        aActor.m_isActive = true;
        aActor.m_freeType = this.m_freeType;
        aActor.initActor(this.m_actorType, param1, param2, param3, param4);
        return aActor;
    }

    public void freeActor(Actor aObj) {
        for (int i2 = 0; i2 < this.m_actorsInUsing.size(); ++i2) {
            Actor aTmp = (Actor)this.m_actorsInUsing.elementAt(i2);
            if (!aTmp.equals(aObj)) continue;
            this.m_actorPool.addElement(aObj);
            aTmp.m_isActive = true;
            this.m_actorsInUsing.removeElementAt(i2);
            return;
        }
    }

    public void freeAllActor() {
        for (int i2 = this.m_actorsInUsing.size() - 1; i2 >= 0; --i2) {
            Actor aTmp = (Actor)this.m_actorsInUsing.elementAt(i2);
            this.freeActor(aTmp);
        }
    }

    public void updateActors() {
        Actor aTmp;
        int i2;
        for (i2 = 0; i2 < this.m_actorsInUsing.size(); ++i2) {
            aTmp = (Actor)this.m_actorsInUsing.elementAt(i2);
            aTmp.update();
        }
        for (i2 = this.m_actorsInUsing.size() - 1; i2 >= 0; --i2) {
            aTmp = (Actor)this.m_actorsInUsing.elementAt(i2);
            if (aTmp.m_freeType == 1 && aTmp.isAnimFinished()) {
                this.freeActor(aTmp);
            }
            if (aTmp.m_freeType == 2 && aTmp.m_tag1 != 0 && aTmp.m_tag2 == aTmp.m_tag4 && aTmp.m_tag3 == aTmp.m_tag5) {
                this.freeActor(aTmp);
            }
            if (aTmp.m_isActive) continue;
            this.freeActor(aTmp);
        }
    }

    public Actor getActor(int iIndex) {
        if (iIndex >= this.m_actorsInUsing.size()) {
            return null;
        }
        return (Actor)this.m_actorsInUsing.elementAt(iIndex);
    }

    public void drawActors() {
        for (int i2 = 0; i2 < this.m_actorsInUsing.size(); ++i2) {
            Actor aTmp = (Actor)this.m_actorsInUsing.elementAt(i2);
            aTmp.draw();
        }
    }

    public void hideAllActors() {
        for (int i2 = 0; i2 < this.m_actorsInUsing.size(); ++i2) {
            Actor aTmp = (Actor)this.m_actorsInUsing.elementAt(i2);
            aTmp.m_visible = false;
        }
    }
}

